/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import java.awt.color.ColorSpace;

public class BogusColorSpace
extends ColorSpace {
    private static int getType(int n) {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("numComponents < 1!");
        }
        switch (n) {
            case 1: {
                n2 = 6;
                break;
            }
            default: {
                n2 = n + 10;
            }
        }
        return n2;
    }

    public BogusColorSpace(int n) {
        super(BogusColorSpace.getType(n), n);
    }

    @Override
    public float[] toRGB(float[] fArray) {
        if (fArray.length < this.getNumComponents()) {
            throw new ArrayIndexOutOfBoundsException("colorvalue.length < getNumComponents()");
        }
        float[] fArray2 = new float[3];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(3, this.getNumComponents()));
        return fArray;
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        if (fArray.length < 3) {
            throw new ArrayIndexOutOfBoundsException("rgbvalue.length < 3");
        }
        float[] fArray2 = new float[this.getNumComponents()];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(3, fArray2.length));
        return fArray;
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        if (fArray.length < this.getNumComponents()) {
            throw new ArrayIndexOutOfBoundsException("colorvalue.length < getNumComponents()");
        }
        float[] fArray2 = new float[3];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(3, this.getNumComponents()));
        return fArray;
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        if (fArray.length < 3) {
            throw new ArrayIndexOutOfBoundsException("xyzvalue.length < 3");
        }
        float[] fArray2 = new float[this.getNumComponents()];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(3, fArray2.length));
        return fArray;
    }
}

