/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class TIFFFieldNode
extends IIOMetadataNode {
    private final boolean isIFD;
    private volatile boolean isInitialized = false;
    private final TIFFField field;

    private static String getNodeName(TIFFField tIFFField) {
        return tIFFField.getData() instanceof TIFFDirectory ? "TIFFIFD" : "TIFFField";
    }

    public TIFFFieldNode(TIFFField tIFFField) {
        super(TIFFFieldNode.getNodeName(tIFFField));
        this.isIFD = tIFFField.getData() instanceof TIFFDirectory;
        this.field = tIFFField;
        TIFFTag tIFFTag = tIFFField.getTag();
        int n = tIFFTag.getNumber();
        String string = tIFFTag.getName();
        if (this.isIFD) {
            TIFFDirectory tIFFDirectory;
            TIFFTagSet[] tIFFTagSetArray;
            if (n != 0) {
                this.setAttribute("parentTagNumber", Integer.toString(n));
            }
            if (string != null) {
                this.setAttribute("parentTagName", string);
            }
            if ((tIFFTagSetArray = (tIFFDirectory = (TIFFDirectory)tIFFField.getData()).getTagSets()) != null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < tIFFTagSetArray.length; ++i) {
                    stringBuilder.append(tIFFTagSetArray[i].getClass().getName());
                    if (i == tIFFTagSetArray.length - 1) continue;
                    stringBuilder.append(',');
                }
                this.setAttribute("tagSets", stringBuilder.toString());
            }
        } else {
            this.setAttribute("number", Integer.toString(n));
            this.setAttribute("name", string);
        }
    }

    private void initialize() {
        if (this.isInitialized) {
            return;
        }
        if (this.isIFD) {
            TIFFDirectory tIFFDirectory = (TIFFDirectory)this.field.getData();
            TIFFField[] tIFFFieldArray = tIFFDirectory.getTIFFFields();
            if (tIFFFieldArray != null) {
                for (TIFFField tIFFField : tIFFFieldArray) {
                    Node node = tIFFField.getAsNativeNode();
                    if (node == null) continue;
                    this.appendChild(node);
                }
            }
        } else {
            IIOMetadataNode iIOMetadataNode;
            int n = this.field.getCount();
            if (this.field.getType() == 7) {
                iIOMetadataNode = new IIOMetadataNode("TIFFUndefined");
                byte[] byArray = this.field.getAsBytes();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(Integer.toString(byArray[i] & 0xFF));
                    if (i >= n - 1) continue;
                    stringBuilder.append(",");
                }
                iIOMetadataNode.setAttribute("value", stringBuilder.toString());
            } else {
                iIOMetadataNode = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.field.getType()) + "s");
                TIFFTag tIFFTag = this.field.getTag();
                if (n <= 100000) {
                    for (int i = 0; i < n; ++i) {
                        int n2;
                        String string;
                        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.field.getType()));
                        iIOMetadataNode2.setAttribute("value", this.field.getValueAsString(i));
                        if (tIFFTag.hasValueNames() && this.field.isIntegral() && (string = tIFFTag.getValueName(n2 = this.field.getAsInt(i))) != null) {
                            iIOMetadataNode2.setAttribute("description", string);
                        }
                        iIOMetadataNode.appendChild(iIOMetadataNode2);
                    }
                }
            }
            this.appendChild(iIOMetadataNode);
        }
        this.isInitialized = true;
    }

    @Override
    public Node appendChild(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        return super.insertBefore(node, null);
    }

    @Override
    public boolean hasChildNodes() {
        this.initialize();
        return super.hasChildNodes();
    }

    @Override
    public int getLength() {
        this.initialize();
        return super.getLength();
    }

    @Override
    public Node getFirstChild() {
        this.initialize();
        return super.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        this.initialize();
        return super.getLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        this.initialize();
        return super.getPreviousSibling();
    }

    @Override
    public Node getNextSibling() {
        this.initialize();
        return super.getNextSibling();
    }

    @Override
    public Node insertBefore(Node node, Node node2) {
        this.initialize();
        return super.insertBefore(node, node2);
    }

    @Override
    public Node replaceChild(Node node, Node node2) {
        this.initialize();
        return super.replaceChild(node, node2);
    }

    @Override
    public Node removeChild(Node node) {
        this.initialize();
        return super.removeChild(node);
    }

    @Override
    public Node cloneNode(boolean bl) {
        this.initialize();
        return super.cloneNode(bl);
    }
}

