/*!
 * FSI Pages
 * Build: 19.10.6785
 * 
 * Copyright (c) 2019 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function(k,d){if(k.fnDoNothing!==d){return}k.fnDoNothing=function(){};if(typeof(console.error)!=="function"){k.console={};k.console.log=k.fnDoNothing;k.console.logCSS=k.fnDoNothing;k.console.warn=k.fnDoNothing;k.console.error=k.fnDoNothing;k.console.dir=k.fnDoNothing;k.console.info=k.fnDoNothing}else{k.console=console;if(typeof(console.timeLog)==="function"){k.console.logCSS=console.log}else{k.console.logCSS=function(e){e=e.replace(/%c/g,"");console.log(e)}}}if(typeof(window.requestAnimationFrame)!=="function"){var b=0;var m=["ms","moz","webkit","o"];for(var l=0;l<m.length&&!window.requestAnimationFrame;++l){window.requestAnimationFrame=window[m[l]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m[l]+"CancelAnimationFrame"]||window[m[l]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(q){var e=new Date().getTime();var i=Math.max(0,16-(e-b));var p=window.setTimeout(function(){q(e+i)},i);b=e+i;return p};window.cancelAnimationFrame=function(e){clearTimeout(e)}}}k.initCustomTag=k.initCustomTags=k.fnDoNothing;k.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};k.osVersion=[0,0,0];var c=navigator.userAgent.toLowerCase();var o,n,f;if(c.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){o=true;if(c.search("android")>-1){k.mobileOS="android";k.isTouch=true;k.noMouse=true;n=c.match(/android (\S*)/);if(n&&n.length>1){n=n[1].split(".");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}else{if(c.indexOf("mac os")!==-1){k.mobileOS="ios";k.isTouch=true;k.noMouse=true;n=c.match(/ os (\S*)/);if(n&&n.length>1){n=n[1].split("_");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}}}else{o=false}k.isMobileDevice=o;k.isSmallMobileDevice=(c.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);k.isInternetExplorer=false;k.isIETouch=false;if(c.search("msie")>-1){k.isInternetExplorer=true;n=c.match(/msie ([^;]*)/);if(n&&n.length>1){k.versionInternetExplorer=parseFloat(n[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){k.isInternetExplorer=true;k.versionInternetExplorer=parseFloat(RegExp.$1)}else{k.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");if(k.isInternetExplorer){k.versionInternetExplorer=12}}}if(window.navigator.msPointerEnabled){k.isIETouch=(window.navigator.msMaxTouchPoints>1)}if(!k.isTouch){k.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(c.search("chrome")!==-1&&c.search("edge")===-1){k.isChrome=true}else{if(c.search("safari")!==-1){k.isSafari=true}else{if(c.search("firefox")!==-1){k.isFirefox=true}else{if(c.search("opera")!==-1){k.isOpera=true}}}}if(c.search("mac os")>-1){k.isMac=true}if(typeof(window.pageYOffset)==="number"){k.getDocumentScroll=function(e){return{x:e.pageXOffset,y:e.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.body.scrollLeft,y:e.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.documentElement.scrollLeft,y:e.document.documentElement.scrollTop}}}}}if(typeof(window.devicePixelRatio)!=="undefined"){k.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{k.getDevicePixelRatio=function(){return 1}}k.preventDefaultEvent=function(e){if(e.preventDefault){e.preventDefault()}e.returnValue=false;return false};k.getElementDimension=function(e){return{width:e.offsetWidth,height:e.offsetHeight}};k.getViewportSize=function(i){var e;if(!i){i=window}if(k.BrowserSupports.visualViewportAPI()){e={width:i.visualViewport.width,height:i.visualViewport.height}}else{e={width:i.innerWidth,height:i.innerHeight}}return e};k.replaceChild=function(q,s,i){try{var p=s.nextSibling;if(p){q.removeChild(s);q.insertBefore(i,p)}else{q.appendChild(i)}}catch(r){k.console.error(r.message);k.console.log(q);k.console.log(s);k.console.log(i)}};k.removeChild=function(i,q){try{i.removeChild(q)}catch(p){k.console.error(p.message);k.console.log(i);k.console.log(q)}};k.getWindowOffset=function(r){var q=0;var p=0;try{if(r.frameElement){var i=r;while(i.frameElement){var s=i.frameElement;var u=k.getElementPosition(s);q+=u.left;p+=u.top;i=i.parent}}}catch(t){}return{x:q,y:p}};var a=document.createElement("div");try{a.getBoundingClientRect();k.getBoundingClientRect=function(e){return e.getBoundingClientRect()}}catch(h){k.getBoundingClientRect=function(i){try{return i.getBoundingClientRect()}catch(p){return{top:0,left:0,right:0,bottom:0,width:0,height:0}}}}k.getElementClientDim=function(e){var i=k.getBoundingClientRect(e);return{width:(i.right-i.left),height:(i.bottom-i.top)}};k.getElementClientPos=function(e){return k.getBoundingClientRect(e)};k.getElementPosition=function(v){var i=k.getBoundingClientRect(v);var t=v.clientLeft;var B=v.clientTop;var C=0;var x=0;var u=0;var r=0;var D=0;var A=0;try{var q=window.getComputedStyle(v,null);u=parseFloat(q.paddingLeft);r=parseFloat(q.paddingRight);D=parseFloat(q.paddingTop);A=parseFloat(q.paddingBottom);t=parseFloat(q.borderLeftWidth);C=parseFloat(q.borderRightWidth);B=parseFloat(q.borderTopWidth);x=parseFloat(q.borderBottomWidth)}catch(w){}var s=i.left+t+u;var z=i.top+B+D;var p=i.right-C-r;var y=i.bottom-x-A;return{left:s,top:z,right:p,bottom:y}};k.dispatchEvent=function(e){var i;if(k.BrowserSupports.genericEvent()){i=new Event(e)}else{i=document.createEvent("Event");i.initEvent(e,true,true)}if(i){return window.dispatchEvent(i)}else{return false}};k.removeEvent=function(q,i,p,e){if(window.removeEventListener&&q){if(e===d){e=true}q.removeEventListener(i,p,e)}else{if(window.detachEvent&&q){q.detachEvent("on"+i,p)}}};k.addEvent=function(q,i,p,e){if(window.addEventListener&&q){if(e===d){e=true}q.addEventListener(i,p,e)}else{if(window.attachEvent&&q){q.attachEvent("on"+i,p)}}};k.sign=Math.sign||function(i){var e;if(isNaN(i)){e=NaN}else{if(i===0){e=0}else{e=(i<0)?-1:1}}return e};k.trim=function(e){if(!e||typeof(e)!=="string"||e.length<1){return e}return e.replace(/(^\s+)|(\s+$)/g,"")};var j=k.escapeRegEx=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};k.addClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};k.addClass(p,q);e.setAttribute("class",p.className)};k.removeClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={removeAttribute:k.fnDoNothing,className:i};k.removeClass(p,q);if(p.className!==""){e.setAttribute("class",p.className)}else{e.removeAttribute("class")}};k.hasClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};return k.hasClass(p,q)};k.addClass=function(i,r){if(!i||typeof(i.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var q=j(r);var p=new RegExp("(^|\\s+)"+q+"(\\s+|$)");var s=k.trim(i.className);var e=s.match(p);if(!e){if(s.length>0){s+=" "+r}else{s+=r}i.className=s}};k.removeClass=function(e,r){if(!e||typeof(e.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");var q=k.trim(e.className.replace(i," "));if(q.length>0){e.className=q}else{e.removeAttribute("class")}};k.hasClass=function(e,r){if(typeof(r)!=="string"){return false}r=k.trim(r);if(r.length<1){return false}var q=e.className;if(typeof(q)!=="string"||q.length<1){return false}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");return(q.match(i)!=null)};k.getFSIServerImageDim=function(e,r,p,t,i,q){var u={width:e,height:r};var s={width:p,height:t};k.calcFSIServerImageDim(u,s,i,q);return s};k.calcFSIServerImageDim=function(e,i,q,r){if(typeof(q)!=="object"){q={left:0,top:0,width:1,height:1}}else{q.left=q.left<0?0:q.left>1?1:q.left;q.top=q.top<0?0:q.top>1?1:q.top;q.width=q.width<0?1-q.left:q.width+q.left>1?1-q.left:q.width;q.height=q.height<0?1-q.top:q.height+q.top>1?1-q.top:q.height}i.width=i.width<=0||i.width===d?-1:i.width;i.height=i.height<=0||i.height===d?-1:i.height;var u={};if(i.width!==-1&&i.height!==-1){u.x=i.width/(e.width*q.width);u.y=i.height/(e.height*q.height)}else{if(i.height===-1){u.x=u.y=i.width/(e.width*q.width)}else{u.x=u.y=i.height/(e.height*q.height)}}if(i.width===-1||i.height===-1){var t=Math.min(u.x,u.y);if(i.width===-1){i.width=Math.round(e.width*q.width*t)}else{if(i.height===-1){i.height=Math.round(e.height*q.height*t)}}u.x=t;u.y=t}if(r&&Math.abs(u.x-u.y)>1e-7){if(u.x>u.y){var p=i.height*e.width*q.width/(e.height*q.height);u.x=p/e.width;i.width=Math.round(p)}else{var s=i.width*e.height*q.height/(e.width*q.width);u.y=s/e.height;i.height=Math.round(s)}}i.width=i.width===0?1:i.width;i.height=i.height===0?1:i.height;return u};k.BrowserSupports={};k.BrowserSupports[false]=function(){return false};k.BrowserSupports[true]=function(){return true};k.BrowserSupports.localStorage=function(){var i=false;try{if(typeof(window.localStorage)!=="undefined"&&typeof(localStorage.setItem)==="function"){i=true}}catch(p){}k.BrowserSupports.localStorage=k.BrowserSupports[i];return i};k.BrowserSupports.visualViewportAPI=function(){var i=false;try{if(typeof(window.visualViewport)!=="undefined"){i=true}}catch(p){}k.BrowserSupports.visualViewportAPI=k.BrowserSupports[i];return i};k.BrowserSupports.genericEvent=function(){var i=false;try{if(typeof(window.Event)==="function"){i=true}}catch(p){}k.BrowserSupports.genericEvent=k.BrowserSupports[i];return i};k.BrowserSupports.customElementRegistry=function(){var i=false;try{if(typeof(window.customElements)==="object"&&typeof(window.customElements.define)==="function"){i=true}}catch(p){}k.BrowserSupports.customElementRegistry=k.BrowserSupports[i];return i};k.BrowserSupports.registerElement=function(){var i=false;try{if(typeof(document.registerElement)==="function"){i=true}}catch(p){}k.BrowserSupports.registerElement=k.BrowserSupports[i];return i};k.BrowserSupports.canvas=function(){var q=false;try{var p=document.createElement("canvas");var i=p.getContext("2d");if(i&&i.clearRect!==d){q=true}}catch(r){}k.BrowserSupports.canvas=k.BrowserSupports[q];return q};k.BrowserSupports.cssTouchAction=function(){var p=false;try{if(k.isTouch){if(typeof(window.getComputedStyle)==="function"){var i=window.getComputedStyle(document.body);p=(typeof(i.touchAction)==="string")}}}catch(q){}k.BrowserSupports.cssTouchAction=k.BrowserSupports[p];return p};var g=Boolean(k.isMobileDevice||k.isIETouch||k.isTouch||(k.isMac&&k.isSafari));k.BrowserSupports.documentZoom=k.BrowserSupports[g]}(window.$FSI=window.$FSI||{}));(function($FSI,undefined){if($FSI.Utils!==undefined){return}$FSI.Utils=function(){var self=this;var addedCSSBlocks={};var rgxThousandSeperator=/(\d+)(\d{3})/;var regexPlusToSpace=/\+/g;var regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;var regExServerFormat1=/(&)?format=[^&]*/ig;var regExServerFormat2=/\?&/;var documentScaleMethod;var __getMediaMinScreenWidthCount=0;var __getMediaMinScreenWidthLoopCount=0;var __LastGetMediaMinScreenWidthResult;var __LastGetMediaMinScreenWidth;var __getDocumentScaleReferenceWidth;var strCSSTransformStyleName;var iLoaderCSSSkin;var iLoaderJavascript;this.oLanguageMap=undefined;this.API={};var topWindow;var strFSIViewerURL;try{if(typeof(top.window.alert)==="function"){topWindow=top.window}else{topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");topWindow=window}var oMatchMedia=topWindow.matchMedia||topWindow.msMatchMedia;this.getTopWindow=function(){return topWindow};var callbackFunctionID=0;this.getNewCallbackFunctionID=function(){return callbackFunctionID++};var nViewerInstanceID=0;this.getViewerInstanceID=function(){return ++nViewerInstanceID};var oSupportedEvents={};$FSI.isEventSupported=function(eventName){if(oSupportedEvents[eventName]!==undefined){return oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;oSupportedEvents[eventName]=isSupported;return isSupported};this.getSVGNameSpaceURL=function(){return"http://www.w3.org/2000/svg"};var nSVGID=0;this.getSVGID=function(){return"$FSI.SVGID_"+nSVGID++};var oClassDefCreated={};this.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;if(oOptions.bNoAPI!==true){instance.getAPIData=function(){return self.oAPI}}this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){if(obj.hasOwnProperty(o)){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,strResult,strType,itm;var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{$FSI.console.log("\r\n"+strTitle+" of "+strVersionString+line)}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a===undefined){ar[i].a="void"}args="%c( "+ar[i].a+" )"}else{args="%c"}strResult=(ar[i].r===undefined)?"%c":"%c"+strReturn+ar[i].r;strType=(ar[i].t===undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]===undefined){nNotAvailable++;itm+=" [x]"}$FSI.console.logCSS(itm,"color:#00a;","color:green;")}if(nNotAvailable>0){$FSI.console.logCSS("%c\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options","color:#c50")}if(fnGroup!==undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)==="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)==="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!==undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)==="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!==undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!oClassDefCreated[strClassName]){oClassDefCreated[strClassName]=true;if(instance.getBuild()!==$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};new self.ClassDef($FSI,"FSI Core",{strVersion:"2019",strBuild:"19.10.6785",bNoAPI:true});this.mergeObjects=function(o1,o2){for(var o in o2){if(o2.hasOwnProperty(o)){o1[o]=o2[o]}}return o1};this.cloneArray=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}return ar.concat([])};this.cloneArrayRecursive=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=self.cloneValue(ar[i])}return ret};this.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=self.cloneArrayRecursive(val)}else{ret=self.cloneObject(val)}}break;default:ret=val}return ret};this.cloneObject=function(obj){if(typeof(obj)!=="object"){return{}}if(obj==null){return null}var ret={};if(typeof(obj)==="object"&&typeof(obj.push)==="function"){ret=self.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=self.cloneValue(obj[o])}}return ret};this.cloneParameters=function(parameters){return self.cloneObject(parameters)};var regExEffects=/((\?)|&)effects=([^&]*)/ig;var regExPadEffect=/[=,]+Pad\([^)]*/ig;this.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match(regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match(regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};var documentDomain=document.location.hostname;var regCors=new RegExp("//"+documentDomain+"[:/]");this.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match(regCors)==null};this.loadImageCors=function(img,url){if(self.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};var oBoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=oBoolTable[value];if(ret===undefined){ret=def}}return ret};this.getBoolTable=function(val){return oBoolTable[val]};var oCustomEventListenerClasses={};var oCustomEventListenerInstances={};var oCustomEventListeners={};var nCustomEventListeners=0;var nCustomEventListenerID=0;var nCustomEventFunctionID=0;var nCustomEventElementID=0;this.customEventClassExists=function(nam){return(oCustomEventListenerClasses[nam]!==undefined)};this.getCustomEventListenerInstance=function(myEvent){return new oCustomEventListenerClasses[myEvent]()};this.registerCustomEvent=function(nam,fnClass){if(oCustomEventListenerClasses[nam]){return false}oCustomEventListenerClasses[nam]=fnClass};this.getNewEventElementID=function(){return nCustomEventElementID++};this.getNewEventFunctionID=function(){return nCustomEventFunctionID++};$FSI.addCustomEvent=function(myObj,myEvent,myFunc){var obj,listenerID;var listener=oCustomEventListenerInstances[myEvent];if(!listener){if(typeof(oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is missing.");return false}listener=oCustomEventListenerInstances[myEvent]=new oCustomEventListenerClasses[myEvent]()}obj=listener.addListener(myObj,myFunc);if(obj!==undefined){listenerID=obj.nCustomEventListenerID=nCustomEventListenerID++;oCustomEventListeners[obj.nCustomEventListenerID]=obj;nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc){var listener=oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&oCustomEventListeners[obj.nCustomEventListenerID]!==undefined){delete oCustomEventListeners[obj.nCustomEventListenerID];nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};var createJavascriptLoader=function(){if(!iLoaderJavascript){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!createJavascriptLoader()){return false}return iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!createJavascriptLoader()){return false}return iLoaderJavascript.release(strScriptPath,idInstance)};this.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof(iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};this.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};this.setStyleAttr=function(el,strStyle){
/*@cc_on
			 @if (@_jscript_version < 9)
			 el.style.setAttribute('cssText', strStyle);
			 @else @*/
el.setAttribute("style",strStyle);
/*@end
			 @*/
};this.changeRendererInURL=function(url,strRenderer){url=url.replace(regExServerRenderer,"$1renderer="+strRenderer);return url};this.removeFormatInURL=function(url){url=url.replace(regExServerFormat1,"");url=url.replace(regExServerFormat2,"?");return url};this.urlEncode=function(str){if(!str){return str}try{str=encodeURIComponent(str)}catch(e){$FSI.console.error("Malformed URI: "+str)}str=str.replace(regexPlusToSpace,"%2B");return str};this.getCSSTransformStyleName=function(){if(strCSSTransformStyleName!==undefined){return strCSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!=="translate( 0 , 0)"){ret=ar[i];break}}div=null;strCSSTransformStyleName=ret;return ret};var oViewerClassCSSRules={};var oInsertedCSS;this.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=oViewerClassCSSRules[strClass];if(res===strRule){return}addCSSRule(strClass,strRule,0);oViewerClassCSSRules[strClass]=strRule};this.dumpCSS=function(){console.log("Viewer Class CSS");console.log(oViewerClassCSSRules);console.log("CSS blocks");console.log(addedCSSBlocks);console.log("CSS in FSI.CORE");console.dir(oInsertedCSS.sheet.rules)};this.cssClassExists=function(cssID){return(typeof(addedCSSBlocks[cssID])!=="undefined")};this.addCSSClass=function(cssID,strCode){if(self.cssClassExists(cssID)){return false}var node=addCSSNode(cssID);if(node){try{node.innerHTML=strCode;addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};var addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("data-generated-by","FSI");node.setAttribute("data-generated-for",cssID);node.setAttribute("data-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};this.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!==undefined&&ar.length>0){for(var i=0;i<ar.length;i++){deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};this.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors===undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);addCSSRule(strSelector,strRule,0)};var addCSSRule=function(selector,rules,index){if(oInsertedCSS===undefined){oInsertedCSS=addCSSNode("FSI.Core")}if(oInsertedCSS!==undefined){try{if(oInsertedCSS&&oInsertedCSS.sheet){if("insertRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};var deleteCSSRule=function(selector){var ret=false;var i;if(oInsertedCSS!==undefined){try{var arDelete=[];var ar=oInsertedCSS.sheet.cssRules;for(i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText===selector){arDelete.push(i)}}if(arDelete.length>0){for(i=arDelete.length-1;i>-1;i--){oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};this.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};this.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};this.getElementBorders=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.borderLeftWidth);ret.top=parseFloat(style.borderTopWidth);ret.right=parseFloat(style.borderRightWidth);ret.bottom=parseFloat(style.borderBottomWidth)}catch(e){}return ret};this.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};var getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};this.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};this.guessFSIViewerLocation=function(strScriptName,depth){if(strFSIViewerURL!==undefined){return strFSIViewerURL}var ret=self.getScriptPath(strScriptName,depth);if(ret){strFSIViewerURL=ret}return ret};var bHTTPS=(document.location.protocol==="https:");this.isHTTPS=function(){return bHTTPS};$FSI.getViewerLocation=function(){return strFSIViewerURL};this.getNumberSeperators=function(iConfig){var lngEng={english:1,japanese:1,chinese_simplified:1,chinese_traditional:1};var lng;if(!iConfig||!iConfig.cfg||typeof(iConfig.cfg.language)!=="string"){lng="english"}else{lng=iConfig.cfg.language.toLowerCase()}return(lngEng[lng])?{thousand:",",decimal:"."}:{thousand:".",decimal:","}};this.makeNiceNumber=function(val,dec,oNumberSep){if(!oNumberSep){oNumberSep={thousand:",",decimal:"."}}if(dec===undefined){dec=0}val=val.toFixed(dec);val=""+val;val=val.split(".");var ret=val[0];while(rgxThousandSeperator.test(ret)){ret=ret.replace(rgxThousandSeperator,"$1"+oNumberSep.thousand+"$2")}if(dec>0){ret+=oNumberSep.decimal+val[1]}return ret};this.makeNiceFileSize=function(n,oNumberSep){var u="byte";if(n>1024){n/=1024;u="KB"}if(n>1024){n/=1024;u="MB"}if(n>1024){n/=1024;u="GB"}if(n>1024){n/=1024;u="TB"}if(u!=="byte"){n=self.makeNiceNumber(Math.round(100*n)/100,2,oNumberSep)}else{n=self.makeNiceNumber(n,0,oNumberSep)}return n+" "+u};this.getCSSColor=function(val){if(typeof(val)==="string"&&val.length>0){val=$FSI.trim(val);if(val.match(/^[0-9,a-f]{3}$/i)||val.match(/^[0-9,a-f]{6}$/i)){val="#"+val.toUpperCase()}}return val};var getMediaMinScreenWidth=function(nam,unit){var init=topWindow.document.documentElement.clientWidth;if(__LastGetMediaMinScreenWidth===topWindow.document.documentElement.clientWidth){return __LastGetMediaMinScreenWidthResult}__LastGetMediaMinScreenWidth=topWindow.document.documentElement.clientWidth;__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}__LastGetMediaMinScreenWidthResult=__getDocumentScaleReferenceWidth=init-step;return __LastGetMediaMinScreenWidthResult};this.getDocumentScaleMethod=function(){return documentScaleMethod};this.getDocumentScaleNone=function(){return 1};this.getDocumentScaleInit=function(){self.getDocumentScale=self.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){documentScaleMethod="visualViewport API";self.getDocumentScale=function(){return topWindow.visualViewport.scale};return self.getDocumentScale()}if(topWindow.innerWidth===undefined){documentScaleMethod="none";return self.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";self.getDocumentScale=function(){if(screen.width!==topWindow.outerWidth){return(topWindow.outerWidth-192)/topWindow.innerWidth}return(topWindow.outerWidth-83)/topWindow.innerWidth};return self.getDocumentScale()}if(window.orientation!==undefined){if(!window.outerWidth){documentScaleMethod="screen.width / window.innerWidth iOS";self.getDocumentScale=function(){__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return __getDocumentScaleReferenceWidth/window.innerWidth};return self.getDocumentScale()}documentScaleMethod="window.outerWidth / window.innerWidth";self.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return self.getDocumentScale()}if(oMatchMedia&&topWindow.document.documentElement.clientWidth>0){var w=getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){documentScaleMethod="CSS Media Query";self.getDocumentScale=function(){var res=getMediaMinScreenWidth("min-width","px")/topWindow.innerWidth;if(isNaN(res)){res=1}return res};return self.getDocumentScale()}}documentScaleMethod="fallback";self.getDocumentScale=function(){return topWindow.outerWidth/topWindow.innerWidth};return self.getDocumentScale()};self.getDocumentScale=self.getDocumentScaleInit;self.getDocumentScaleWithPixelRatio=function(){return self.getDocumentScale()*$FSI.getDevicePixelRatio()};self.getImageDimFitInto=function(wSrc,hSrc,wMax,hMax,oCroppedImage,bNoLimitToSourceDim){var ret={};var wSrcOrg=wSrc;var hSrcOrg=hSrc;if(!bNoLimitToSourceDim){wMax=Math.min(wSrc,wMax);hMax=Math.min(hSrc,hMax)}var bCropped=oCroppedImage&&oCroppedImage.isCropped();if(bCropped){oCroppedImage.setSourceDimension(wSrc,hSrc);var rc=oCroppedImage.getPixelRangeRect();wSrc=rc.right;hSrc=rc.bottom}if(wSrc/wMax>hSrc/hMax){ret.width=wMax;ret.height=Math.round(hSrc/wSrc*wMax)}else{ret.height=hMax;ret.width=Math.round(wSrc/hSrc*hMax)}if(bCropped){ret.widthUncropped=Math.round(ret.width*wSrcOrg/wSrc);ret.heightUncropped=Math.round(ret.height*hSrcOrg/hSrc)}else{ret.widthUncropped=ret.width;ret.heightUncropped=ret.height}return ret};self.extendRectToFill=function(rc,srcWidth,srcHeight,targetWidth,targetHeight,bAllowInvalidRect,bAllowMove){var amount;var wCur=rc.width()*srcWidth;var hCur=rc.height()*srcHeight;var dim=self.fitImageIntoSpace(wCur,hCur,targetWidth,targetHeight,true,true);if(dim.width/targetWidth<dim.height/targetHeight){amount=(targetWidth/dim.width-1)*rc.width();rc.left=rc.left-amount/2;rc.right=rc.right+amount/2;if(bAllowMove){if(rc.right>1){rc.offsetRect(-(rc.right-1),0)}else{if(rc.left<0){rc.offsetRect(-rc.left,0)}}}}else{amount=(targetHeight/dim.height-1)*rc.height();rc.top=rc.top-amount/2;rc.bottom=rc.bottom+amount/2;if(bAllowMove){if(rc.bottom>1){rc.offsetRect(0,-(rc.bottom-1))}else{if(rc.top<0){rc.offsetRect(0,-rc.top)}}}}if(!bAllowInvalidRect){rc.limitToImageRect()}};this.fitImageIntoSpace=function(wSrc,hSrc,wTarget,hTarget,bDoNotLimitToSrcDim,bFloats){if(!bDoNotLimitToSrcDim){wTarget=Math.min(wTarget,wSrc);hTarget=Math.min(hTarget,hSrc)}var ret={};if(wTarget/wSrc<hTarget/hSrc){ret.dim="width";if(bDoNotLimitToSrcDim){ret.width=wTarget}else{ret.width=Math.min(wTarget,wSrc)}ret.height=ret.width*hSrc/wSrc}else{ret.dim="height";if(bDoNotLimitToSrcDim){ret.height=Math.min(hTarget,hSrc)}else{ret.height=hTarget}ret.width=ret.height*wSrc/hSrc}if(!bFloats){ret.width=Math.round(ret.width);ret.height=Math.round(ret.height)}return ret};this.getParameterValueFromURL=function(url,nam){var ret=undefined;if(typeof(url)==="string"&&typeof(nam)==="string"&&nam.length>0&&url.length>0){nam=$FSI.escapeRegEx(nam);var reg=new RegExp("(\\?|&)"+nam+"=([^&]*)");var match=url.match(reg);if(match&&match[2]){ret=decodeURIComponent(match[2])}}return ret}};if(!$FSI.utils){$FSI.utils=new $FSI.Utils()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomTags!==b){return}a.CustomTags=function(){var g={};var e=false;var f=(a.BrowserSupports.registerElement()||a.BrowserSupports.customElementRegistry());var d=this.initCustomTags=function(){if(f){return false}for(var h in g){if(g.hasOwnProperty(h)){c(h)}}return true};var c=this.initCustomTag=function(l){if(f){return false}var k=g[l];if(!k){return false}var h=document.getElementsByTagName(l);if(h.length>0){k.replaceTagInit()}if(h&&h.length>0){for(var j=0;j<h.length;j++){k.replaceTag(h[j],k)}}return true};this.get=function(h){return g[h]};this.register=function(i,h){if(g[i]===b){g[i]=new a.CustomTag(i,h);if(!e){e=true;if(!f){a.addEvent(window,"DOMContentLoaded",d)}}a.customTags.initCustomTag(i)}return g[i]}};a.CustomTag=function(f,c){var q=this;var h;this.opts=c;var p=function(){a.utils.addViewerClassCSSRule(f,c.viewerCSS);if(a.BrowserSupports.customElementRegistry()){j()}else{if(a.BrowserSupports.registerElement()){l()}}};var e=function(s,t){var r=s.getAttribute(t);if(typeof(r)==="string"&&r.length>0){if(!r.match(/[^0-9\s]/)){r+="px"}s.style[t]=r}};var k=function(r){e(r,"width");e(r,"height")};var i=function(u){var r=a.utils.attributes2parameters(u);if(c.parameterAliases){var v=c.parameterAliases;for(var t in v){if(v.hasOwnProperty(t)){var s=v[t];if(r[t]!==b&&r[s]===b){r[s]=r[t]}}}}if(r.src!==b&&r.imagesrc===b){r.imagesrc=r.src}return r};var j=function(){window.customElements.define(f,n)};var g=this.onCreated=function(){c.constructorClass.prototype.constructor.call(this,this,{autoInit:false})};var o=this.onAttached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}m(this)};var m=function(r){k(r);r.init(r,i(r),b,true);if(typeof(r.start)==="function"){r.start()}};var d=this.onDetached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}if(typeof(this.destroyOnDetach)==="function"){this.destroyOnDetach()}};var l=function(){var r=Object.create(HTMLDivElement.prototype);r.createdCallback=g;r.attachedCallback=o;r.detachedCallback=d;document.registerElement(f,{prototype:r})};this.replaceTag=function(s,r){if(!s||(typeof(s.getInitDone)==="function"&&s.getInitDone())){return}if(r.opts.bConfigTag!==true){c.constructorClass.prototype.constructor.call(s,s,{autoInit:false});m(s)}else{c.constructorClass.prototype.constructor.call(s);s.init(s,i(s),false,true)}};this.replaceTagInit=function(){if(h){return}h=true;a.utils.addViewerClassCSSRule(f,c.viewerCSS)};var n;if(window.Reflect){n=function(){var r=window.Reflect.construct(HTMLElement,[],this.constructor);g.apply(r);return r};n.prototype=Object.create(HTMLElement.prototype);n.prototype.constructor=n;n.prototype.connectedCallback=o;n.prototype.disconnectedCallback=d}p()};if(!a.customTags){a.customTags=new a.CustomTags();a.initCustomTags=a.customTags.initCustomTags;a.initCustomTag=a.customTags.initCustomTag}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!==b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=this.logCSS=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=a.console;var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("logCSS",this.log);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CORSLoader!==b){return}a.CORSLoader=function(){var h=this;var d=0;var c={};var g=false;var i;var f=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){i=function(k){var e;if(!a.utils.isCrossDomain(k)){g=false;e=new XMLHttpRequest()}else{g=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){i=function(){return new XMLHttpRequest()}}}if(!i){try{f=new ActiveXObject("Msxml2.XMLHTTP");i=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(j){try{f=new ActiveXObject("Microsoft.XMLHTTP");i=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(j){f=null;i=function(){return null}}}}this.getSupported=function(){return(i()!=null)};this.load=function(l,m,o,q){var k=i(l);if(!k){return}if(o&&k.overrideMimeType){k.overrideMimeType(o)}k._url=l;var n=d;c[d]=k;d++;if(g){k.onerror=function(){delete c[n];if(m===b||this.FSIaborted){return}m(this,this.responseText,q,400)};k.onload=function(){delete c[n];if(m===b||this.FSIaborted){return}var r=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var s=new ActiveXObject("Microsoft.XMLDOM");s.async=false;s.loadXML(r);r=this.responseXML=s}catch(t){}break}m(this,r,q,200)}}else{k.onreadystatechange=function(){if(k.readyState!==4){return}delete c[n];if(m===b||this.FSIaborted){return}var e=(this.responseXML!=null&&this.responseXML.firstChild)?this.responseXML:this.responseText;m(this,e,q,k.status)}}try{k.open("GET",l,true);k.send(null)}catch(p){m(this,"",q,500)}return k};this.stopPendingRequests=function(){for(var k in c){if(c.hasOwnProperty(k)){var e=c[k];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}}};this.destroy=function(){h.reset()};this.reset=function(){this.stopPendingRequests();c={}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!==b){return}a.Config=function(al,x,f){if(typeof(f)!=="object"){f={}}if(!x||typeof(x)!=="object"){x={}}var n=this;this.parameters=(al&&typeof(al)==="object")?al:{};this.XMLSerializer=(window.XMLSerializer)?new window.XMLSerializer():b;this.plugins={};this.arPlugins=[];this.arUnrecognizedConfigNodes=[];this.arConditions=[];var Z=false;var O={};var B=0;var r;var ad={};var H=n.debug=new a.EmptyDebugger();var D=false;var y={};var aq=false;var T={stickynotes:"bookmarks"};var g;var Y=false;var t;var L;var ag;var c;var m;var v="token";var w;var p;var K={};var aj=/(\\?|&)tpl=/i;var af=/\.json\s*$/i;var d=/\.xml\s*$/i;if(a.isInternetExplorer&&a.versionInternetExplorer<10){p=function(at){var ar;if(!a.utils.isCrossDomain(at)){aq=false;ar=new XMLHttpRequest()}else{aq=true;ar=new XDomainRequest()}return ar}}else{if(typeof(XMLHttpRequest)!=="undefined"){p=function(){return new XMLHttpRequest()}}}this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",format:"imageformat",renderer:"fpxservertemplate",imagerenderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(av){n.reset();t=(typeof(f.strSection)==="string")?f.strSection:"";L=t.toLowerCase();if(typeof(f.strTraceParam)==="string"){var at=f.strTraceParam.toLowerCase();c={};c[at]=true;if(at.indexOf("_")>0&&at.indexOf("pages")===0){at=at.split("_");at.shift();at=at.join("_");c[at]=true}var au=n.getParameterAlias(at);if(au){c[au]=true}}else{c=false}if(av){if(n.parameters){n.parameters=a.utils.mergeObjects(n.parameters,av)}else{n.parameters=av}}ak(n.parameters);n.getQueryParameters();n.cloneParameters(n.cfgDefaults,n.cfg);n.cloneParameters(n.queryParameters,n.cfg);delete n.cfg.effects;n.elevateToHTTPS();e();n.locationFSIViewer="";if(n.queryParameters.fsiviewerlocation!==b){n.locationFSIViewer=n.queryParameters.fsiviewerlocation}else{H.log("FSI Viewer location guessed based on script location: "+a.getViewerLocation());n.locationFSIViewer=(a.getViewerLocation()||"")}if(n.locationFSIViewer.charAt(n.locationFSIViewer.length-1)!=="/"){n.locationFSIViewer+="/"}var ar=n.cfg.defaultcfg;if(typeof(ar)==="string"&&ar.length>0){n.nextConfigURL=n.getReloadPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.defaultcfg))}else{n.nextConfigURL=b}n.checkDebug(false)};var ak=this.makeObjectPropertiesLowerCase=function(ar){for(var at in ar){if(ar.hasOwnProperty(at)){var au=at.toLowerCase();if(at!==au){if(ar[au]===b){ar[au]=ar[at]}delete ar[at]}}}};this.getClassParameters=function(){return ag};this.setAccessToken=function(ar){w=ar};this.getParameterAlias=function(au){var ar;if(n.cfgAliasNames[au]){ar=n.cfgAliasNames[au]}else{for(var at in n.cfgAliasNames){if(n.cfgAliasNames.hasOwnProperty(at)){if(n.cfgAliasNames[at]===au){ar=at;break}}}}return ar};var e=function(){Z=n.makeBool(n.cfg.usenc,false);if(n.cfg.usencquery!==b&&n.cfg.usencquery.length>0){D=n.cfg.usencquery;Z=true;n.queryToObject("?"+D,y)}};this.stopPendingRequests=function(){for(var at in O){if(O.hasOwnProperty(at)){var ar=O[at];if(ar){ar.FSIaborted=true;if(ar.abort){ar.abort()}}}}};this.destroy=function(){n.stopPendingRequests()};this.reset=function(){K={};ag={};n.parameters={};H=n.debug=new a.EmptyDebugger();n.stopPendingRequests();r=Math.random();n.nIncludedConfigs=0;n.completedConfigs={};n.plugins={};n.cfg={};n.queryParameters=b;n.arUnrecognizedConfigNodes=[];am=0;n.arConditions=[];ad={}};this.getQueryParameters=function(){if(n.queryParameters!==b){return}n.queryParameters={};n.cloneParameters(n.parameters,n.queryParameters)};this.makeBool=function(av,ar){if(typeof(ar)!=="boolean"){ar=false}var at=ar;switch(typeof(av)){case"string":var au=a.makeBool(av);if(au!==b){at=au}break;case"number":at=Boolean(av);break;case"boolean":at=av;break}return at};this.parsePositionParameter=function(at){if(typeof(at)!=="string"||at.length<3){return b}at=at.split(",");if(at.length<3){return b}for(var ar=0;ar<3;ar++){at[ar]=parseFloat(at[ar]);if(isNaN(at[ar])){at[ar]=0}}return{x:at[0],y:at[1],z:at[2]}};this.logLoadFileFailed=function(ar){if(!H.on){return}if(ar&&ar.status!==b){var au="HTTP "+ar.status;if(ar&&ar.statusText){au+=", "+ar.statusText}var at=(ar._url)?ar._url:"";H.error("Failed to load "+at+" ("+au+")")}else{H.error("Failed loading a file");if(ar&&ar._url){H.error(ar._url)}}};this.getAttributeValue=function(at,ar){if(!at){return}return at.getAttribute(ar)};this.getImageDownloadOriginalURL=function(at){var ar=n.serverBase.replace(/\/server$/,"");return ar+"/service/file/"+at};this.getImageURL=function(au,ar){var at;if(au===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="image"}if(w){ar[v]=w}ar.source=au;for(at in ad){if(ad.hasOwnProperty(at)){if(ad[at]!==b&&ar[at]===b){ar[at]=ad[at]}}}for(at in ab){if(ar[at]){if(ab[at]!==at){if(!ar[ab[at]]){ar[ab[at]]=ar[at]}ar[at]=null}}}if(ar.renderer===b){ar.renderer="jpeg"}return n.requestBase+"?"+n.objectToQuery(ar)};this.getRectFromInitialView=function(au){var at=n.viewStringToArray(au);return new a.Rect(at[2],at[3],at[4],at[5])};this.getImageRectParamFromRect=function(ar){var at=ar.duplicateRect();at.right=at.width();at.bottom=at.height();return at.toString()};this.getImageURLAsInViewer=function(ax,aA,aF,av,aw,aG,ar,az){az=az||{};var aH={};if(!ar||typeof(ar)!=="object"){ar={}}if(typeof(aG)!=="string"){aG=n.cfg.initialview}var aC,aE;var aB={width:aA,height:aF};var aD={width:aA,height:aF};if(aG){aE=n.getRectFromInitialView(aG)}if(az.bDoNotModifyQuery!==true){delete ar.width;delete ar.height;delete ar.rect}var au=new a.CroppedImage();au.setSourceDimension(aA,aF);au.setCropFromConfig(n.cfg);if(az.cropToFill){au=au.getCropToFill(av,aw,az.cropToFill,true)}var ay;aH.iCrop=au;if(au.isCropped()){ay=aC=au.getFloatRect();aH.rcSource=au.getImageRect()}else{aH.rcSource=new a.Rect(0,0,aA,aF)}if(aE&&!aE.isDefaultImageRect()&&az.expandViewStringToFit!==false){var aI,aJ;if(ay){aI=ay.width();aJ=ay.height()}else{aI=aJ=1}a.utils.extendRectToFill(aE,aI*aA,aJ*aF,av,aw,false,true)}if(ay){if(aE){aC=aC.getPartialRect(aE)}}else{aC=aE}if(aC&&!aC.isDefaultImageRect()){aD.width=aA*aC.width();aD.height=aF*aC.height();aB.width=Math.round(aD.width);aB.height=Math.round(aD.height);if(ar.rect===b){ar.rect=n.getImageRectParamFromRect(aC)}}aH.rc=aC;var at=a.utils.fitImageIntoSpace(aD.width,aD.height,av,aw);if(ar.width===b&&ar.height===b){ar[at.dim]=at[at.dim]}aH.dimFit=at;aH.srcArea=aB;aH.srcAreaFloat=aD;aH.url=n.getImageURL(ax,ar);return aH};this.getImageInfoURL=function(at,ar){if(at===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="info"}if(ar.tpl===b){if(n.cfg.fpxinfotemplate!==b){ar.tpl=n.cfg.fpxinfotemplate}else{ar.tpl="info.json"}}if(n.cfg.headers&&n.cfg.headers.length>0){ar.headers=n.cfg.headers}if(!ar.tpl.match(/.json$/)){ar.tpl+=".json"}ar.source=at;if(w){ar[v]=w}return n.requestBase+"?"+n.objectToQuery(ar)};this.queryToObject=function(aw,au){if(au===b){au={}}var av,ay,ax,ar,at;av=aw.indexOf("?");if(av!==-1){at=aw.slice(av+1)}else{at=""}av=at.indexOf("#");if(av!==-1){at=at.substring(0,av)}at=at.split("&");for(av=0;av<at.length;av++){ay=at[av].split("=");ax=decodeURIComponent(ay[0]).toLowerCase();if(ax.length>0){ar=decodeURIComponent(ay[1]);au[ax]=ar}}return au};this.parseSceneSets=function(ar,aw){var aD={};if(aw===b){aw=true}var aI=[];var aG=0;var aE=0;var au;var ay,ax,av,aC,aA,aH;var az,aB,aF;var at=n.cfg.scenesets;if(ar>1&&at!==b&&typeof(at)==="string"){aB=at.split(";");for(ay=0;ay<aB.length;ay++){aF=[];az=aB[ay].split(",");aE=0;for(ax=0;ax<az.length;ax++){aH=az[ax].split("-");aC=aA=0;if(aH.length===1){aC=parseInt(aH[0])}else{aC=parseInt(aH[0]);if(isNaN(aC)){aC=1}au=false;if(aH[1].charAt(0)===">"){aH[1]=aH[1].substr(1);if(!isNaN(parseInt(aH[1]))){au=true}}aA=parseInt(aH[1]);if(isNaN(aA)){aA=ar}if(aC>0&&aA>0&&aC<=ar&&aA<=ar){if(au===true||aC!==aA){if(au!==true){if(aA<aC){for(av=aC;av>=aA;av--){aF[aE]=av;aE++}}else{for(av=aC;av<=aA;av++){aF[aE]=av;aE++}}}else{for(av=aC;av<=ar;av++){aF[aE]=av;aE++}for(av=1;av<=aA;av++){aF[aE]=av;aE++}}}}}if(aC>0&&aC<=ar&&(aA===0||aA===aC)){aF[aE]=aC;aE++}}if(aE>0){aI[aG]={};aI[aG].arScenes=[];aI[aG].arScenes=aI[aG].arScenes.concat(aF);aG++}}}if(aG===0){aD.bDefault=true;if(aw){aI[0]={};aI[0].arScenes=[];for(ay=0;ay<ar;ay++){aI[0][ay]=ay}}}aD.nSceneSets=aG;aD.bHasMultipleSets=(aD.nSceneSets>1);aD.arSets=aI;aD.nCurrent=1;return aD};this.objectToQuery=function(au){var at=[];var aw,av;if(Z&&D!==false){for(aw in y){if(y.hasOwnProperty(aw)){au[aw]=y[aw]}}}for(aw in au){if(au.hasOwnProperty(aw)){av=au[aw];if(av!==null&&av!==b){av=encodeURIComponent(av);at.push(encodeURIComponent(aw)+"="+av)}}}return at.join("&")};this.loadImageInfo=function(av,ar,au){if(typeof(av)!=="string"||av.length<1){if(ar){ar(null,"",au)}}else{var at=n.getImageInfoURL(av);n.loadFile(at,ar,b,au)}};this.loadFile=function(aw,av,au,aA,az,at,ax){if(!aw||aw.length<0){if(av){setTimeout(function(){av(null,"",aA)},0)}return}if(az===b){az="GET"}if(at===b){at=null}else{if(typeof(at)==="object"){at=n.objectToQuery(at)}}if(au===b){au="application/json"}var ay=p(aw);if(au&&ay.overrideMimeType){ay.overrideMimeType(au)}ay._url=aw;var ar=B;O[B]=ay;B++;if(aq){ay.onerror=function(){delete O[ar];if(av===b||this.FSIaborted){return}n.logLoadFileFailed(this)};ay.onload=function(){delete O[ar];if(av===b||this.FSIaborted){return}var aB=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var aC=new ActiveXObject("Microsoft.XMLDOM");aC.async=false;aC.loadXML(aB);aB=this.responseXML=aC}catch(aD){H.log("Failed parsing XML using Microsoft.XMLDOM");H.log(aw)}break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aD){H.error("Failed parsing JSON from URL: "+aw+" ("+aD.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}else{ay.onreadystatechange=function(){var aB;if(ay.readyState!==4){return}delete O[ar];if(this.FSIaborted||typeof(av)!=="function"){return}if(this.status>299){n.logLoadFileFailed(this)}switch(au){case"application/xml":case"text/xml":aB=this.responseXML;break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aC){H.error("Failed parsing JSON from URL: "+aw+" ("+aC.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}ay.open(az,aw,true);if(ax&&w){ay.setRequestHeader("data-token",w)}if(at){ay.setRequestHeader("Content-type","application/x-www-form-urlencoded");ay.send(at)}else{ay.send()}return ay};this.loadConfigs=function(){ag=(t.length>0)?{}:false;g=true;n.loadNextConfig(true)};this.loadNextConfig=function(at){if(n.nextConfigURL===b){X();return}var au={};if(f.bPreventCaching||n.makeBool(n.cfg.debug)||(!at&&!n.makeBool(n.cfg.configcaching,true)&&n.makeBool(n.cfg.enableconfigcachingparameter))){n.addNoCacheParams(au)}n.finishRequestParams(au);var ar=n.addURLParameters(n.nextConfigURL,au);H.log("Loading config file: "+ar);n.loadFile(ar,E,"application/xml")};this.setDebugger=function(ar){H=n.debug=ar};this.checkDebug=function(au){if(f.bNoDebug){return}var at;var ar;if(n.parameters.debug!==b){ar=n.makeBool(n.parameters.debug)}else{ar=n.makeBool(n.cfg.debug)}if(ar){if(!H||!H.on){H=n.debug=new a.Debugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}else{if(!H||H.on===true){H=n.debug=new a.EmptyDebugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}return at};var E=function(ar){var au=ar.responseXML;m=n.nextConfigURL;n.parseConfig(au);m=b;n.elevateToHTTPS();if(n.checkDebug(true)===true){return}e();if(g&&f.bCaptureDefaultCfg){g=false;n.cfgFromDefaultConfig=a.utils.cloneValue(n.cfg)}var at;if(n.cfg.includeconfig!==b&&n.nIncludedConfigs<10){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.includeconfig));n.nIncludedConfigs++;n.cfg["_includeconfig("+n.nIncludedConfigs+")"]=n.cfg.includeconfig;n.cfg.includeconfig=b}else{if(n.cfg.cfg!==b){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.cfg))}}if(at!==b&&!n.completedConfigs[at]){n.completedConfigs[at]=true;n.nextConfigURL=at;n.loadNextConfig()}else{n.evaluateQuery(n.queryParameters,n.cfg);X()}};this.evaluateXML=function(ar){m="XML Object";n.parseConfig(ar);m=b;n.elevateToHTTPS();e();n.evaluateQuery(n.queryParameters,n.cfg);X()};this.elevateToHTTPS=function(){if(!a.utils.isHTTPS()){return}if(!n.makeBool(n.cfg.autoelevatetohttps,true)){return}i("fpxbase");i("fpxserver")};var i=function(ar){if(n.cfg[ar]!==b&&n.cfg[ar].length>0&&n.cfg[ar].indexOf("http://")===0){n.cfg[ar]="https"+n.cfg[ar].substr(4)}};this.evaluateQuery=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){n.setConfigParamByValue(ar,au.toLowerCase(),at[au])}}};this.parseConfig=function(at,au){var aD="";var ax;var az=false;if(at&&typeof(at)==="object"){if(au===b){au=at.firstChild}if(au&&au.nodeName==="xml"){au=au.nextSibling}var aC=au.childNodes;for(var ay=0;ay<aC.length;ay++){var aw=aC[ay];if(aw.nodeType!==1){continue}var aA;if(aw._myTagName!==b){aA=aw._myTagName}else{aA=aw.nodeName.toLowerCase()}aD=aA;var av=aw.childNodes;az=false;switch(aA){case"licence":break;case"if":n.arConditions.push(aw);break;case"plugins":for(ax=0;ax<av.length;ax++){n.parsePluginNode(av[ax])}break;case L:az=true;case"info":case"options":aD=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(ax=0;ax<av.length;ax++){var aB=av[ax];if(aB.nodeType!==1){continue}if(aB.tagName==="if"){aB._myTagName=aA;n.arConditions.push(aB)}else{var ar=n.getValueFromXMLNode(aB,aD);if(aD===b&&ag){if(az){n.setConfigParam(ag,ar,null,true);n.setConfigParam(n.cfg,ar,aB)}else{if(ag[ar.name]===b){n.setConfigParam(n.cfg,ar,aB)}}}else{n.setConfigParam(n.cfg,ar,aB)}}}break;default:n.arUnrecognizedConfigNodes.push(aw)}}}};this.getData=function(){var ar={};ar.cfg={};for(var at in n.cfg){if(n.cfg.hasOwnProperty(at)){ar.cfg[at]=n.cfg[at]}}return ar};this.setData=function(ar){if(!ar||!ar.cfg){return}n.cfg={};this.setCfgValues(ar.cfg)};this.setCfgValues=function(at){for(var au in at){if(at.hasOwnProperty(au)){var ar=au.toLowerCase();if(n.cfgAliasNames[ar]){ar=n.cfgAliasNames[ar]}if(K.nItems){if(K.bPositive){if(!K.params[ar]){continue}}else{if(K.params[ar]){continue}}}n.cfg[ar]=at[au]}}W()};this.getImagesNodeList=function(au){var ar=[];if(au===b){au=n.getUnrecognizedConfigNode("images")}if(au){var av=au.firstChild;while(av){if(av.nodeType===1){var at={};at.attributes={};N(av,at.attributes);at.cfg={};n.parseConfigFragment(av,at.cfg);ar.push(at)}av=av.nextSibling}}return ar};this.removeUnrecognizedConfigNodes=function(){n.arUnrecognizedConfigNodes=[]};this.setUnrecognizedConfigNode=function(aw,au){var ar;aw=aw.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var av=n.arUnrecognizedConfigNodes[at];if(av&&av.nodeName.toLowerCase()===aw){ar=av;break}}if(!ar){if(au!==null){n.arUnrecognizedConfigNodes.push(au)}}else{if(au===null){n.arUnrecognizedConfigNodes.slice(at,1)}else{n.arUnrecognizedConfigNodes[at]=au}}return ar};this.getUnrecognizedConfigNode=function(av){var ar;av=av.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var au=n.arUnrecognizedConfigNodes[at];if(au&&au.nodeName.toLowerCase()===av){ar=au;break}}return ar};this.parseConfigFragment=function(at,az,ay){var aD="";if(at&&typeof(at)==="object"&&az!==b){if(ay===b){ay=[]}var aC=at.childNodes;for(var ax=0;ax<aC.length;ax++){var av=aC[ax];if(av.nodeType!==1){continue}var aA=av.nodeName.toLowerCase();aD=aA;var au=av.childNodes;switch(aA){case"info":case"options":aD=b;case"fpx":case"image":case"include":for(var aw=0;aw<au.length;aw++){var aB=au[aw];if(aB.nodeType!==1){continue}var ar=n.getValueFromXMLNode(aB,aD);n.setConfigParam(az,ar,aB)}break;default:ay.push(av)}}}};this.findXMLNode=function(at,ar){if(at===b||at.nodeType===b){return b}while(at){if(at.nodeName.toLowerCase()===ar){break}if(at.firstChild){at=at.firstChild}else{if(at.nextSibling){at=at.nextSibling}else{at=at.parentNode.nextSibling}}}return at};this.getValueFromXMLNode=function(au,ar){if(!au||au.nodeType!==1){return}var at={};var av=(ar)?ar:"";at.name=av+au.nodeName.toLowerCase();var aw=au.getAttribute("value");if(aw){at.value=aw;return at}at.value=n.XMLChildNodesToString(au);at.node=au;return at};this.getXMLNodeAttribute=function(av,au,ar){if(!av||av.nodeType!==1||!av.getAttribute){return ar}var at=av.getAttribute(au);if(at===b||at==null){at=ar}return at};this.XMLChildNodesToString=function(au,at){var ar="";if(!au||!au.firstChild){return ar}if(au.childNodes.length===1&&au.firstChild.nodeType===3){ar=au.firstChild.nodeValue}else{ar=au.innerHTML}if(at!==b){ar=ar.replace(/[\x00-\x1f]/g,at)}return ar};this.hasPlugin=function(ar){return(n.plugins&&n.plugins[ar]!==b)};this.getPluginParameter=function(ay,at,ar,ax,az){ay=ay.toLowerCase();at=at.toLowerCase();if(n.plugins[ay]===b){H.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+ay+"."+at);return ar}var aw;var av=ay+"_"+at;if(az&&n.cfg[av]===b){av=at}if(n.cfg[av]!==b){aw=n.cfg[av]}else{if(ag&&ag[at]!==b&&L==="pages"){aw=ag[at]}else{var au=n.plugins[ay].parameters;if(au!==b&&au[at]!==b){aw=au[at]}}}if(aw===b){aw=ar}if(ax){aw=n.makeBool(aw,ar)}return aw};var R=this.getAllPluginParameters=function(at){at=at.toLowerCase();var au=a.utils.cloneObject(n.plugins[at].parameters);var aw=at+"_";var ar=aw.length;for(var ax in n.cfg){if(n.cfg.hasOwnProperty(ax)){if(ax.toLowerCase().indexOf(aw)===0){var av=ax.substr(ar);au[av]=n.cfg[ax]}}}return au};this.getIntParameterMinMax=function(at,au,ar,av){return Math.min(av,Math.max(ar,n.getIntParameter(at,au)))};this.getIntParameter=function(at,au){var ar=parseInt(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};this.getStringParameter=function(at,au){var ar=n.cfg[at.toLowerCase()];if(ar===b){ar=au}return ar};this.getFloatParameter=function(at,au){var ar=parseFloat(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};var N=function(ax,at){if(!ax||!ax.attributes||!ax.attributes.length||!at){return false}var au=ax.attributes;for(var aw=0;aw<au.length;aw++){var ar=au[aw];var av=ar.nodeName.toLowerCase();at[av]=ar.value}return true};this.parsePluginNode=function(au){if(au.nodeType!==1){return}var aw={};N(au,aw);var av=au.childNodes;for(var ar=0;ar<av.length;ar++){var ax=av[ar];if(ax.nodeType!==1){continue}var at=n.getValueFromXMLNode(ax);if(at.value!==b){aw[at.name]=at.value;if(at.node!==b){aw[at.name+".node"]=at.node}}}this.addPluginFromString(aw.src,aw)};this.clone=function(){var ar=new a.Config(al,x,f);ar.init();ar.setParameterFilter(K);ar.serverBase=n.serverBase;ar.requestBase=n.requestBase;ar.cfg=a.utils.cloneObject(n.cfg);ar.plugins=a.utils.cloneObject(n.plugins);ar.arPlugins=a.utils.cloneArray(ar.arPlugins);ar.arUnrecognizedConfigNodes=a.utils.cloneArray(n.arUnrecognizedConfigNodes);ar.arUnrecognizedConfigNodesWithoutDefault=a.utils.cloneArray(n.arUnrecognizedConfigNodesWithoutDefault);ar.setImageQueryParameters(ad);ar.arConditions=a.utils.cloneArray(n.arConditions);ar.hasImageParameterConditions=n.hasImageParameterConditions;return ar};this.setImageQueryParameters=function(ar){ad=a.utils.cloneObject(ar)};this.getImageQueryParameters=function(){return a.utils.cloneObject(ad)};this.addPluginsFromString=function(au){if(typeof(au)!=="string"||au.length<1){return}var ar=au.split(",");for(var at=0;at<ar.length;at++){var av=a.trim(ar[at]);n.addPluginFromString(av)}};this.addPluginFromString=function(av,aw){if(typeof(av)!=="string"||av.length<1){H.error("PLUGIN without src parameter:");return}av=av.toLowerCase();if(T[av]!==b){av=T[av]}if(aw===b){aw={}}var at=n.plugins[av]={};at.name=av;if(aw.src===b){aw.src=av}at.parameters=aw;if(c){for(var ax in c){if(c.hasOwnProperty(ax)){if(ax.indexOf(av+"_")===0){var au=av+"_";var ar=ax.substr(au.length);if(typeof(at.parameters[ar])!=="undefined"){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log(at.parameters[ar]);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}else{if(ax===av){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log("(enabled)");n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}}};this.setConfigParamByValue=function(at,au,ar){n.setConfigParam(at,{name:au.toLowerCase(),value:ar})};var V=function(at){if(at.nodeType!==1){return"<unknown>"}var ar=n.XMLSerializer.serializeToString(at.cloneNode(false));ar=ar.replace(/\/>$/gi,">");return ar};this.setParameterFilter=function(at,ar){if(at===b){if(K.nItems){K={}}return}if(typeof(at)==="string"){K=n.getParameterFilterFromString(at,ar)}else{if(typeof(at)==="object"){K=a.utils.cloneObject(at)}}};this.getParameterFilterFromString=function(ay,at){var av={bPositive:at,nItems:0,params:{}};var az=av.params;var au=ay.split(",");for(var ax=0;ax<au.length;ax++){var aw=a.trim(au[ax]).toLowerCase();if(aw.length>0){az[aw]=true;av.nItems++}}return av};this.getParameterFilter=function(){return a.utils.cloneObject(K)};this.setConfigParam=function(av,ar,aw,ax){var az=ar.name;var aB=ar.value;if(!az){return}if(c){for(var aA in c){if(aA===az&&!ax){if(typeof(aw)==="object"&&typeof(aw.tagName)==="string"){var ay;if(m){ay=m}var au=aw.parentNode;var at=[];while(au){if(au.tagName==="if"){ay="Matched Condition"}at.unshift(V(au));au=au.parentNode}at.shift();at.shift();n.iTraceParameterDebug.group(ay);n.iTraceParameterDebug.log(at.join(" "));n.iTraceParameterDebug.log(aw);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}else{n.iTraceParameterDebug.group("By Parameter/Attribute:");n.iTraceParameterDebug.log(aB);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}if(n.cfgAliasNames[az]!==b){az=n.cfgAliasNames[az]}if(K.nItems){if(K.bPositive){if(!K.params[az]){return}}else{if(K.params[az]){return}}}if(av[az]!==b&&(typeof(aB)==="string"&&a.utils.getBoolTable(aB.toLowerCase())===false)&&a.utils.getBoolTable(av[az])===b){delete av[az]}else{switch(az){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":aB=a.trim(aB);n.appendImageEffect(av,az,aB);break;case"plugins":n.addPluginsFromString(aB);break;case"fpxpath":av[az]=aB;av.fpxsrc=encodeURIComponent(aB);break;default:av[az]=aB;if(ar.node!==b){av[az+".node"]=ar.node}}}};this.appendImageEffect=function(au,at,ar){if(typeof(ar)!=="string"){return}if(ar.match(/^ClearEffects\(\)*/i)){ar=ar.replace(/^ClearEffects\(\)\s*[,]?\s*/i,"");au[at]=b}if(ar.length>0){if(au[at]!==b&&au[at].length>0){au[at]+=","+ar;au[at]=au[at].replace(/,,/g,",")}else{au[at]=ar}}};var l={};l["="]=function(at,ar){return(at.toLowerCase()===ar.toLowerCase())};l["=="]=function(at,ar){return(at===ar)};l["!="]=function(at,ar){return(at.toLowerCase()!==ar.toLowerCase())};l["!=="]=function(at,ar){return(at!==ar)};l["<"]=function(at,ar){return(at<ar)};l["<="]=function(at,ar){return(at<=ar)};l[">"]=function(at,ar){return(at>ar)};l[">="]=function(at,ar){return(at>=ar)};l.match=function(at,ar){var au=false;var aw="g";if(ar.charAt(0)==="/"&&ar.lastIndexOf("/")>0){var av=ar.split("/");av.shift();aw=av.pop();ar=av.join("/")}try{var ax=new RegExp(ar,aw);au=(at.match(ax)!==null)}catch(ay){H.error("Invalid regex in condition: "+ar)}return au};l.notmatch=function(at,ar){return !l.match(at,ar)};var s={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var u=function(at,au){if(n.cfgAliasNames[au]){au=n.cfgAliasNames[au]}var ar=n.cfg[au];if(ar===b){ar=""}if(!n.hasImageParameterConditions){n.hasImageParameterConditions=(ab[au]!==b)}return G(at,au,ar)};var M=function(av,aw){var ar=false;var au;var at=av.getAttribute("value");switch(aw){case"@mobile":at=n.makeBool(at,true);au=a.isMobileDevice;break;case"@devicepixelratio":au=a.getDevicePixelRatio();break;case"@navigatoruseragent":au=navigator.userAgent;break;case"@navigatorlanguage":au=navigator.language;break;case"@navigatorplatform":au=navigator.platform;break}if(au!==b){if(typeof(at)!=="string"){at=""+at}if(typeof(au)!=="string"){au=""+au}ar=G(av,aw,au,at)}return ar};var G=function(av,au,ax,aw){var az;var at=av.getAttribute("operator");if(typeof(at)!=="string"){at="="}at=at.toLowerCase();if(s[at]){at=s[at]}if(l[at]===b){at="="}if(aw===b){aw=av.getAttribute("value")}if(aw===null){aw=""}var ar=l[at];if(at.match(/[<,>]+/)){var aA=function(aB){aB=parseFloat(aB);if(isNaN(aB)){az=false}return aB};ax=aA(ax);aw=aA(aw)}else{ax=decodeURIComponent(ax)}if(az===b){az=ar(ax,aw)}if(H.on){H.log("Evaluating condition: "+au+": "+ax+" "+at+" "+aw+" => "+az)}if(az===true){if(av._myTagName!==b){var ay={};ay.nodeType=1;ay.tagName=av._myTagName;ay.childNodes=[av];av=ay}n.parseConfig(av,av)}return az};var ab={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var ac={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi",overlays:"overlays"};var aa;var U=function(){if(aa===b){aa={};for(var ar in ab){aa[ab[ar]]=ar}}return aa};var q=function(aw,av,au){if(au===b){au=""}var ay=au+"left";if(aw[ay]===b){return}var ax=au+"top";var at=au+"right";var ar=au+"bottom";if(av==="pixelrange"){aw[at]=aw[at]-aw[ay];aw[ar]=aw[ar]-aw[ax]}aw[av]=aw[ay]+","+aw[ax]+","+aw[at]+","+aw[ar];if(aw[ay]){delete aw[ay]}if(aw[ax]){delete aw[ax]}if(aw[at]){delete aw[at]}if(aw[ar]){delete aw[ar]}};var ao=this.mapImageParametersToViewer=function(ar){q(ar,"rect");q(ar,"pixelrange","pixel");U();ai(ar,U())};var an=this.mapImageParametersToServer=function(ar){ai(ar,ab)};var ai=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){if(ar[au]&&au!==ar[au]){at[ar[au]]=at[au];delete at[au]}}}};this.reWriteImageURLByConditions=function(ay){if(n.arConditions.length<1){return ay}if(typeof(ay)!=="string"||ay.length<1){return ay}var au=ay.indexOf("?");if(au===-1){return ay}var at=n.clone();var aw={};n.parseQuery(ay,aw);ao(aw);n.evaluateQuery(aw,at.cfg);var ar=at.evaluateConditions();if(!ar){return ay}var ax;for(ax in aw){if(aw.hasOwnProperty(ax)){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}}for(ax in ac){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}an(aw);var av=ay.substr(0,au);return av+"?"+n.objectToQuery(aw)};var o=this.applyConditions=function(){if(n.arConditions.length<1){return}if(n.cfgBeforeConditions===b){n.cfgBeforeConditions=a.utils.cloneObject(n.cfg)}n.cfg=n.cfgBeforeConditions;return h()};var am=0;var h=this.evaluateConditions=function(){if(n.arConditions.length<1){return false}var at=false;for(var au=am;au<n.arConditions.length;au++){var av=n.arConditions[au];if(av.fsiConfigEvaluated){continue}am++;var aw=av.getAttribute("parameter");if(typeof(aw)==="string"){aw=aw.toLowerCase();var ar;if(aw.charAt(0)==="@"){ar=M(av,aw)}else{ar=u(av,aw)}if(!at&&ar){at=ar}}}return at};var W=function(){o();n.serverProfile=n.cfg.fpxservertemplate;n.serverProfileDoublePage=n.cfg.fpxservertemplatedoublepage;if(n.serverProfileDoublePage===b){n.serverProfileDoublePage="doublepage"}n.serverBase=n.cfg.fpxserver;if(n.serverBase===b){H.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+n.locationFSIViewer+")");var at;at=n.locationFSIViewer.indexOf("/users/");if(at!==-1){n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}else{at=n.locationFSIViewer.indexOf("/viewer/");n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}H.log("Derived server location is: ["+n.serverBase+"]")}n.requestBase=n.serverBase;ad={};var ar=n.cfg;for(var au in ac){if(ar[au]!==b){ad[au]=ar[au]}}if(ad.fpxsrc!==b){ad.fpxsrc=decodeURIComponent(ad.fpxsrc)}ar=n.cfg.effects;if(ar!==b){n.cfg.effectsUnFiltered=ar;n.cfg.effects=ar=k(ar)}if(ar!==b){ad.effects=ar}ar=n.cfg.lefteffects;if(ar!==b){ad.lefteffects=ar}ar=n.cfg.righteffects;if(ar!==b){ad.righteffects=ar}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){n.setEffectsFilter(n.getAreaEffects())};this.setEffectsFilter=function(aw){if(typeof(aw)!=="string"||aw.length<1){Y=false;return}aw=a.trim(aw);var au=aw.split(",");for(var av=0;av<au.length;av++){au[av]=a.escapeRegEx(au[av])}var at="(^|[=,]+)("+au.join("|")+")\\([^)]*\\)";Y=new RegExp(at,"ig")};var k=this.removeFilteredEffects=function(ar){if(Y===false||typeof(ar)!=="string"){return ar}ar=ar.replace(Y,"");ar=ar.replace(/^[,\s]*/g,"");ar=a.trim(ar);return ar};var j=function(){for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){var au=at.toLowerCase();var ar=n.makeBool(n.cfg[au],true);if(!ar){n.plugins[at]=b}}}};var X=function(){n.elevateToHTTPS();j();W();n.dumpConfig();if(x.onConfigsReady){x.onConfigsReady()}};this.dumpConfig=function(au){if(!au){au=H}if(au.on){if(n.cfg.fpxsrc!==b){n.cfg["fpxsrc (decoded)"]=decodeURIComponent(n.cfg.fpxsrc)}au.info("Evaluated Configuration:",Q(n.cfg));if(n.queryParameters){au.info("Parameters:",Q(n.queryParameters))}if(ag){au.info("Class <"+t+"> Configuration:",Q(ag))}var at=n.getPluginsAndParameters();var ar=at.data;if(at.count===0){ar="No active plugins."}au.info("Plugin Configuration:",Q(ar))}};var Q=function(au){var ar="--- none ---";if(typeof(au)!=="object"){return ar}for(var at in au){if(au.hasOwnProperty(at)){ar=au;break}}return ar};this.getPluginsAndParameters=function(){var ar={};var au=0;for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){if(n.hasPlugin(at)){ar[at]=R(at);au++}}}return{count:au,data:ar}};var J=this.addQueryParameterToURL=function(av,ar,au){var at=av.lastIndexOf("?");if(at===-1){av+="?"}else{if(at!==av.length-1){av+="&"}}return av+encodeURIComponent(ar)+"="+encodeURIComponent(au)};var ap=n.finishURL=function(ar){if(w){ar=J(ar,v,w)}if(!Z||ar===b){return ar}var at;if(D===false){at="cache=0&cachernd="+r;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+="&"+at}}else{at=D;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+=at}}return ar};this.addURLParameters=function(au,av){if(!au||!av){return au}var at=[];for(var aw in av){if(av.hasOwnProperty(aw)){at.push(encodeURIComponent(aw)+"="+encodeURIComponent(av[aw]))}}if(at.length>0){if(au.indexOf("?")===-1){au+="?"}else{au+="&"}au+=at.join("&")}return au};this.finishRequestParams=function(at){if(Z){if(D===false){at.cache=0;at.cachernd=r}else{for(var ar in y){if(y.hasOwnProperty(ar)){at[ar]=y[ar]}}}}};this.addNoCacheParams=function(ar){ar.cache=0;ar.cachernd=r};this.parseQuery=function(at,ar){if(typeof(ar)!=="object"||typeof(at)!=="string"||at.length<1){return}n.queryToObject(at,ar);if(ar.ignorequeryparameters!==b){delete ar.ignorequeryparameters}if(ar.enableconfigcachingparameter!==b){delete ar.enableconfigcachingparameter}};this.cloneParameters=function(ar,at){if(!ar||!at||typeof(ar)!=="object"||typeof(at)!=="object"){H.error("Cloning object failed: "+ar+" / "+at)}for(var au in ar){if(ar.hasOwnProperty(au)){at[au]=ar[au]}}};this.getFSIPath=function(ar,at){if(typeof(at)!=="string"){at=""}if(at.indexOf("//")!==-1){return at}if(n.cfg.fsibase!==b){at=n.cfg.fsibase+at}return n.getReloadPath(ar,at)};this.expandFSIPath=function(at){if(typeof(at)!=="string"){return at}var ar=decodeURIComponent(at);if(ar.indexOf("?")!==-1||ar.indexOf(".xml")===(ar.length-4)){return at}return at+".xml"};this.getReloadPath=function(av,ax){var at,ay,ar,aw;if(av===b){av=n.locationFSIViewer}if(typeof(ax)!=="string"){ax=""}var au="/";if(ax.indexOf("//")!==-1){return ax}at=av;aw=at.lastIndexOf("?");if(aw===-1){aw=at.length}ay=at.lastIndexOf("\\",aw);ar=at.lastIndexOf("/",aw);ay=Math.max(ay,ar);if(ay===-1){ay=at.length-1}at=at.slice(0,ay);if(at.length>0&&ax.indexOf(au)!==0){at+=au}return at+ax};var C=function(ar){var at;if(!ar){return}if(ar.childNodes.length>0){at=ar.innerHTML}else{at=ar.getAttribute("value")}return at};var I=function(au,aw){var at,ar;var av=0;while(au){if(au.nodeType===1&&au.nodeName.toLowerCase()===aw){ar=au;break}at=au.firstChild;if(!at){at=au.nextSibling}else{av++}if(!at&&av>0&&au.parentNode){at=au.parentNode.nextSibling;av--}au=at}return ar};var S=function(aO,at){var ay;var aK;if(at===b){at=0}var aL={};var aJ=aL.arImages=[];var aC=aL.arConfigs=[];var aM=aL.arNodes=[];var aw=aL.arImageLists=[];var aB="";var aP="";var aI;var ax;var aH={};if(at===0&&(n.cfg.imagelistparameterfilterpositive||n.cfg.imagelistparameterfilternegative)){n.getParameterFilter();n.cloneParameters(K,aH);if(n.cfg.imagelistparameterfilterpositive){n.setParameterFilter(n.cfg.imagelistparameterfilterpositive,true)}else{if(n.cfg.imagelistparameterfilternegative){n.setParameterFilter(n.cfg.imagelistparameterfilternegative,false)}}}var aG=function(ar){aJ.push(ar);aM.push(aO);if(at===0){aC.push(aI);aw.push(ax)}};var aF;if(!aO){return aL}var aU;aU=n.getAttributeValue(aO,"prefix");if(typeof(aU)==="string"){aB=aU}aU=n.getAttributeValue(aO,"suffix");if(typeof(aU)==="string"){aP=aU}var av=n.getAttributeValue(aO,"from");var aE=n.getAttributeValue(aO,"to");var aT,au;if(typeof(av)==="string"&&typeof(aE)==="string"){aT=parseInt(av);au=parseInt(aE);if(!isNaN(aT)&&!isNaN(au)&&aT<=au&&(au-aT)<512){}else{aT=au=b}}if(aT!==b){ax=aI=b;var aS;var aN=av.length;var aR=aE.length;if(aN===aR){aS=aN}for(var aQ=aT;aQ<=au;aQ++){aK=""+aQ;if(aS){while(aK.length<aS){aK="0"+aK}}if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}}else{aO=I(aO,"image");var az;if(!aO){return aL}while(aO){az=true;if(aO.nodeType===1&&aO.nodeName.toLowerCase()==="image"){ax=aI=b;if(at===0){aI=n.clone();aI.getImageQueryParameters();aI.arUnrecognizedConfigNodes=[];aI.parseConfig(aO,aO);aI.setCfgValues({});aI.checkDebug();if(aI.debug&&aI.debug.on){aI.debug.group("Sub Config #"+aJ.length+" from image list:");aI.dumpConfig();aI.debug.groupEnd()}aI.serverBase=n.serverBase;aI.requestBase=n.requestBase;ax=aI.getImageList(at+1);if(ax&&ax.arImages.length>0){az=false;var aD=aI.parseSceneSets(ax.arImages.length,true);var aV=n.viewStringToArray(aI.cfg.initialview);var aA=aD.arSets[aV[0]-1][aV[1]-1];if(aA===b){aA=0}aG(ax.arImages[aA])}}if(az){ax=aI=b;aF=I(aO,"path");aK=C(aF);if(!aK){aK=decodeURIComponent(n.getAttributeValue(aO,"src"))}if(!aK){aK=decodeURIComponent(n.getAttributeValue(aO,"file"))}if(aK!==b){if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}if(aL.width===b){aF=I(aO,"width");aF=C(aF);if(aF!==b){aL.width=parseInt(aF)}aF=I(aO,"height");aF=C(aF);if(aF!==b){aL.height=parseInt(aF)}}}}aO=aO.nextSibling}}if(aH){n.setParameterFilter(aH)}return aL};this.getImageList=function(au){var aA,ay,av;A();if(!n.makeBool(n.cfg.ignoreimagelists)){if(n.cfg&&n.cfg.fpxsources!==b){var az=n.cfg.fpxsources;if(typeof(az)==="string"||(typeof(az)==="object")&&typeof(az.push)==="function"){aA={};aA.oXML=null;if(typeof(az)==="string"){if(ae===false){aA.arImages=az.split(",");for(ay=0;ay<aA.arImages.length;ay++){aA.arImages[ay]=decodeURIComponent(aA.arImages[ay])}}else{var ax=az.split(",");aA.arImages=[];for(ay=0;ay<ax.length;ay++){av=decodeURIComponent(ax[ay]);if(ae(av)){aA.arImages.push(av)}}}}else{aA.arImages=az}}}if(!aA&&n.arUnrecognizedConfigNodes&&n.arUnrecognizedConfigNodes.length>0){var aB=n.arUnrecognizedConfigNodes;for(ay=0;ay<aB.length;ay++){var aw=aB[ay];if(typeof(aw.nodeName)==="string"){var at=aw.nodeName.toLowerCase();if(at==="images"||at==="images3d"){if(H.on){H.log("Reading image list from XML node: <"+aw.nodeName+">")}aA=S(aw,au);aA.oXML=aw;break}}}}}if(!aA&&n.cfg&&n.cfg.fpxsrc!==b){aA={};aA.oXML=null;if(ae===false){aA.arImages=[decodeURIComponent(n.cfg.fpxsrc)]}else{av=decodeURIComponent(n.cfg.fpxsrc);if(ae(av)){aA.arImages=[av]}}}return aA};this.fillViewString=function(aw){if(typeof(aw)!=="string"){aw=""}var au=[1,1,0,0,1,1,0];var at=aw.split(",");if(at.length===2){return aw+",0,0,1,1,0"}if(at.length===6){return aw+",0"}if(at.length===7){return aw}for(var av=at.length;av<7;av++){at.push(au[av])}return at.join(",")};this.viewStringToArray=function(au){var av=function(ay,ax){var ar=parseFloat(ay);if(isNaN(ar)){ar=ax}return ar};var aw=function(ay,ax){var ar=parseInt(ay);if(isNaN(ar)){ar=ax}return ar};au=n.fillViewString(au);var at=au.split(",");at[0]=aw(at[0],1);at[1]=aw(at[1],1);at[2]=av(at[2],0);at[3]=av(at[3],0);at[4]=av(at[4],1);at[5]=av(at[5],1);at[6]=av(at[6],0);return at};this.getServerBase=function(){return n.serverBase};this.loadImageList=function(aw,ax,az,ay){if(!n.serverBase||!aw){ax([],b,ay);return false}A();var av=n.serverBase+"?type=list";if(!aw.match(aj)){var au=n.cfg.listtemplate;if(au&&au.length>0&&!au.match(af)&&!au.match(d)){au+=".json"}av+="&tpl="+au}if(n.cfg.headers&&n.cfg.headers.length>0&&y.headers===b){av+="&headers="+n.cfg.headers}if(typeof(n.cfg.imagelistlimit)==="string"&&n.cfg.imagelistlimit.length>0){av+="&limit="+encodeURIComponent(n.cfg.imagelistlimit)}if(n.cfg.imagelistsort!==b){H.log("Sorting image list by: "+n.cfg.imagelistsort);av+="&sort="+n.cfg.imagelistsort}if(typeof(n.cfg.imagelistsortorder)==="string"){var at=n.cfg.imagelistsortorder.toLowerCase();if(at==="asc"||at==="desc"){H.log("Image list sort order: "+at);av+="&sortorder="+at}}av+="&source="+encodeURIComponent(aw);if(az!==b){av+=az}av=ap(av);var ar=n.loadFile(av,function(aA,aE){if(typeof(aE)==="object"&&typeof(aE.images)==="object"){aE.images.pop();var aF="";if(aE&&aE.imagesattributes&&aE.imagesattributes.dir){aF=aE.imagesattributes.dir}var aB,aD;if(ae===false){aB=new Array(aE.images.length);for(aD=0;aD<aE.images.length;aD++){aB[aD]=aF+aE.images[aD].src}}else{aB=[];for(aD=aE.images.length-1;aD>-1;aD--){var aC=aF+aE.images[aD].src;if(ah(aC)){aB.push(aC)}else{aE.images.splice(aD,1)}}aB.reverse()}ax(aB,aE,ay)}else{ax([],aE,ay)}},"application/json",ay);return ar};var ah=function(at){if(typeof(at)!=="string"){return 1}var ar=1;if(P!==b){if(!at.match(P)){ar=0}}if(ar===1&&z!==b){if(at.match(z)){ar=0}}return ar};var ae=true;var P,z;var F=function(aw){var au;var ay=n.cfg[aw.toLowerCase()];if(!ay||typeof(ay)!=="string"||ay.length<1){return}var ar=/\/([^/]*)$/;try{var av=ay.match(ar);if(av&&av.length>1){var at=av[1];ay=ay.replace(ar,"");ay=ay.replace(/^\//,"")}au=new RegExp(ay,at)}catch(ax){H.error("Invalid Regular Expression "+ay+" in parameter "+aw);H.error(ax.message);au=b}return au};var A=function(){P=F("ListFilterPositive");z=F("ListFilterNegative");if(P===b&&z===b){ae=false}else{ae=ah}};this.traceConfigValue=function(ar,av){if(typeof(ar)!=="string"){return false}ar=a.trim(ar);if(ar.length<1){return false}var at=ar.toLowerCase();if(at.indexOf(".")!==-1){at=at.split(".").join("")}if(at.indexOf("/")!==-1){at=at.split("/").join("")}if(at.indexOf(" ")!==-1){at=at.split(" ").join("")}var au=new a.Debugger();au.setPrefix("");au.group('Tracing parameter "'+ar+'"');var aw=function(){var ax=ar;var aC=n.getParameterAlias(at);if(typeof(aC)==="string"){ax+=" (alias: "+aC+")";if(typeof(n.cfgAliasNames[at])==="string"){at=n.cfgAliasNames[at]}}var ay=n.cfg[at];var aB=true;if(at.indexOf("_")!==-1){var aA=at.split("_");var az=aA.shift();var aD=aA.join("_");if(n.hasPlugin(az)){ay=n.getPluginParameter(az,aD)}}else{if(n.hasPlugin(at)){aB=false;ay="is enabled."}}if(ay===b){aB=false;ay="is undefined (default value applies)"}if(aB){ay='= "'+ay+'"'}au.group("RESULT:");au.log(ax+" "+ay);au.groupEnd();au.groupEnd()};x={onConfigsReady:aw};f.strTraceParam=at;f.bNoDebug=true;n.iTraceParameterDebug=au;n.init(av);n.loadConfigs();return""};this.loadLanguageFile=function(ar,aD,aw,au){var ax=arguments;var ay,aB;if(typeof(aD)!=="string"||n.makeBool(aD,true)===false){return aw.call(n,{},"")}var aC=function(aE){try{a.utils.oLanguageMap=JSON.parse(aE.responseText)}catch(aF){a.utils.oLanguageMap={"default":"english"}}n.loadLanguageFile.apply(this,ax)};var az=function(aE,aH){ar.urlLanguageCurrentLoaded=ay;var aG=ar.oLanguageData={};if(aH){var aF=n.findXMLNode(aH,"data");if(aF){aF=n.findXMLNode(aF,"tip")}while(aF){if(aF.nodeType===1){var aI=aF.getAttribute("id");aG[aI]=aF.innerHTML}aF=aF.nextSibling}}aw.call(n,ar.oLanguageData,aB)};if(aD.toLowerCase()==="auto"){if(!a.utils.oLanguageMap){n.loadFile(n.locationFSIViewer+"/languages/mapping.json",aC,"application/json");return}if(a.utils.oLanguageMap._current!==b){aD=a.utils.oLanguageMap._current}else{aD=a.utils.oLanguageMap["default"];var av=navigator.language;if(typeof(av)==="string"){av=av.toLowerCase()}if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}else{if(av.indexOf("-")!==-1){av=av.split("-")[0];if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}}}}if(aD===b){return aw.call(n,{},"")}if(au){au.log('Automatically choosing language "'+aD+'" from navigator.language "'+navigator.language+'"')}a.utils.oLanguageMap._current=aD}var aA=aD+".xml";var at=n.locationFSIViewer+"/languages/"+aA;if(at!==ar.urlLanguageCurrentLoaded){aB=aD;ay=at;if(au){au.log("Loading language file: "+at)}n.loadFile(at,az,"application/xml")}else{aw.call(n,ar.oLanguageData,aB)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!==b){return}a.Callbacks=function(f,m,k,c){if(typeof(m)!=="object"||typeof(m.cfg)!=="object"){m={cfg:{}}}if(typeof(k)!=="object"){k={}}var l=this;var q=0;var s={};var t=0;var g={};var n=new a.EmptyDebugger();var p={};var w={reg:{}};var o;var v={};var j;var r=function(){if(f){f.dumpListeners=l.dumpReg}};this.destroy=function(){if(n.on){this.removeConfigListeners();if(q>0){n.warn("WARNING: "+q+" listener(s) have not been removed:");for(var x in g){if(g.hasOwnProperty(x)){if(g[x].count>0){a.console.logCSS(g[x].dump(),"color:blue;","color:green;")}}}}}m={cfg:{}};this.checkListenerChanges()};this.removeConfigListeners=function(){for(var x in s){if(s.hasOwnProperty(x)){var y=s[x];if(y!==false){d(y.evt,y.fn)}}}s={}};this.setDebug=function(x){n=x};this.setConfig=function(x){l.removeConfigListeners();m=x};var u=function(A){if(!g[A]){if(s[A]===b){var z;var y=A.toLowerCase();var B=m.cfg[y];var x=typeof(B);if(x!=="undefined"){if(x==="function"){z=B}else{if(x==="string"&&typeof(window[B])==="function"){z=window[B]}}if(z&&h(A,z,f,true)){s[A]={evt:A,fn:z}}else{s[A]=false}}}if(!g[A]){g[A]=new e(A)}}return g[A]};var h=this.addListener=function(z,x,y,B){if(typeof(x)!="function"){n.error("Failed to add listener for "+z+". The function argument is not a function.");return false}var A;if(g[z]===b){A=g[z]=new e(z)}else{A=g[z]}A.addFunction(x,y,B);return true};var d=this.removeListener=function(y,x){var z=g[y];if(z===b||typeof(x)!="function"||x.__FSICallbackFunctionID===b){n.error("Unable to remove listener: no callback for "+y+" registered");return false}return z.removeFunction(x)};this.watchListeners=function(y,x){o=x;v=y;j=false;for(var z in y){if(y.hasOwnProperty(z)){j=true;l.isset(z);w.reg[z]=b}}w.bDirty=true;l.checkListenerChanges()};var i=function(x){if(v[x]){w.bDirty=true;if(w.reg[x]===b){w.reg[x]=g[x].count}if(w.nTimeout===b){w.nTimeout=setTimeout(l.checkListenerChanges,5)}}};this.checkListenerChanges=function(){if(typeof(o)==="function"){if(w.nTimeout!==b){clearTimeout(w.nTimeout);w.nTimeout=b}if(w.bDirty){var z={};for(var x in w.reg){if(w.reg.hasOwnProperty(x)){var y=(g[x]!==b&&g[x].count>0);var A=(w.reg[x]===b)?b:(w.reg[x]>0);if(y!==A){z[x]=y}}}o.apply(l,[z]);w.bDirty=false;w.reg={}}}};this.dumpReg=function(){var A;var B;if(f&&f.getAPIData){B=f.getAPIData().oCallbacks}if(B){for(A in B){if(B.hasOwnProperty(A)){u(A)}}}var x;if(n&&n.on){x=n}else{x=a.console}var y=[];x.group("Total listeners: "+q);for(A in g){if(g.hasOwnProperty(A)){y.push(g[A].dump())}}y.sort();for(var z=0;z<y.length;z++){x.logCSS(y[z],"color:blue;","color:green;")}x.groupEnd()};this.isset=function(x){return(u(x).count>0)};this.runPersistent=function(y,x){l.run(y,x);p[y]=[x]};this.run=function(C,z){var y;var E=u(C);if(E.count>0){var x=E.getFunctionsArray();for(var B=0;B<x.length;B++){var D=x[B];D.countCalled++;var A=D.fn.apply(D.scope,z);if(A!==b){y=A;if(E.handleCallbackResult){y=E.handleCallbackResult(y,z)}}}}return y};var e=function(B){var y=this;this.count=0;var C=false;var A;var z={};var x={};this.addFunction=function(E,F,J){if(j&&y.count===0){i(B)}q++;y.count++;C=true;if(F===b){F=f}var D=E.__FSICallbackFunctionID;if(D===b){D=E.__FSICallbackFunctionID=a.utils.getNewCallbackFunctionID()}if(x[D]===b){x[D]=[]}x[D].push(t);z[t]={fn:E,scope:F,countCalled:0};if(n.on){var I=x[D].length;if(I>1){var H="";try{H=" "+E.name+"()"}catch(G){}n.error(I+" listeners for "+B+" have been added for the same function "+H+". Did you forget to remove a listener?")}if(y.count>20){n.error(I+" listeners for "+B+" have been added for this instance. Did you forget to remove a listener?")}}if(typeof(k[B])==="function"){y.handleCallbackResult=k[B]}if(p[B]!==b){if(!c||c(B,p[B],J)){E.apply(F,p[B][0])}}t++};this.getFunctionsArray=function(){if(C){A=[];var D=z;for(var E in D){if(D.hasOwnProperty(E)){if(typeof(D[E].fn)==="function"){A.push(D[E])}}}C=false}return A};this.removeFunction=function(G){var E=G.__FSICallbackFunctionID;var D=x[E];if(D===b){if(n.on){var I="this function";try{I="the function "+G.name}catch(H){}n.error("Unable to remove listener: no callback for "+B+" registered for "+I)}return false}var F=D.pop();if(j&&y.count===1){i(B)}q--;y.count--;if(D.length===0){delete x[E]}C=true;delete z[F]};this.dump=function(){var F;if(y.count===0){F="%c"+B+": %c no listeners"}else{if(y.count===1){F="%c"+B+": %c"+y.count+" listener"}else{F="%c"+B+": %c"+y.count+" listeners"}}var E=y.getFunctionsArray();if(E&&E.length>0){for(var G=0;G<E.length;G++){try{var I=E[G].fn.name;if(typeof(I)!=="string"||I.length===0){I="anonymous"}}catch(H){I="anonymous"}F+="\n - "+I;var D=E[G].countCalled;if(D===0){F+=" (not called yet)"}else{if(D===1){F+=" (called once)"}else{F+=" (called "+E[G].countCalled+" times)"}}}}return F}};r()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!==b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.setFromArray=function(h){e.left=h[0];e.top=h[1];e.right=h[2];e.bottom=h[3]};this.scaleRect=function(h){if(h===1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h===1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.getPartialRect=function(j){var i=e.duplicateRect();if(!j.isDefaultImageRect()){var h=i.width();var k=i.height();i.offsetRect(j.left*h,j.top*k);i.right=i.left+h*j.width();i.bottom=i.top+k*j.height()}return i};this.isDefaultImageRect=function(){return(e.left===0&&e.top===0&&e.right===1&&e.bottom===1)};this.limitToImageRect=function(){e.left=Math.max(0,Math.min(1,e.left));e.right=Math.max(0,Math.min(1,e.right));e.top=Math.max(0,Math.min(1,e.top));e.bottom=Math.max(0,Math.min(1,e.bottom))};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left===h.left&&e.top===h.top&&e.right===h.right&&e.bottom===h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.setFromString=function(j){if(typeof(j)!=="string"){return}j=decodeURIComponent(j);j=j.replace(/[^0-9,.]/g,"");j=j.split(",");if(j.length>3){for(var h=0;h<j.length;h++){j[h]=parseFloat(j[h])}e.setFromArray(j)}};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CroppedImage!==b){return}a.CroppedImage=function(){var p=this;var e=new a.Rect(0,0,0,0);var n,d;var i=new a.Rect();var h=new a.Rect(0,0,1,1);var c={width:0,height:0};var k=false;var o=function(t,s){if(typeof(t)!="string"){return s}var q=t.split(",");var r=q.length;while(q.length<4){q.push(s[r]);r++}return q};this.setCropFromConfig=function(q){if(q.cropvalues!==b){p.setCropValuesParam(q.cropvalues)}else{if(q.croprect!==b){p.setCropRectParam(q.croprect)}}};this.setCropRectParam=function(r){var q=o(r,["0","0","1","1"]);p.setCropRect(q[0],q[1],q[2],q[3])};var g=function(s,r){var q;if(isNaN(s)){q=r}else{q=Math.max(0,Math.min(1,s))}return q};var j=function(r,q){return Math.round(r*q)};this.setCropRect=function(s,u,v,q){n={l:s,t:u,r:v,b:q};d=b;s=g(s,0);u=g(u,0);v=g(v,1);q=g(q,1);h.setRect(s,u,1-v,1-q);s=j(s,c.width);u=j(u,c.height);v=c.width-j(v,c.width);q=c.height-j(q,c.height);f(s,u,v,q)};var f=function(s,u,v,q){v=Math.min(c.width-s,v);q=Math.min(c.height-u,q);e.setRect(s,u,v,q);k=(s!==0||u!==0||v!==0||q!==0);i.setRect(s,u,c.width-v,c.height-q)};this.setCropValuesParam=function(r){var q=o(r,["0","0","0","0"]);p.setCropValues(q[0],q[1],q[2],q[3])};var m=function(s,q){var r={};if(s.indexOf("%")!==-1){s=Math.max(0,Math.min(100,parseFloat(s)));r.floatVal=s/100;r.pxVal=Math.round(s*q/100)}else{if(s.indexOf("px")!==-1){s=parseInt(s);r.pxVal=Math.max(0,Math.min(q,s));r.floatVal=r.pxVal/q}else{r.floatVal=Math.max(0,Math.min(1,parseFloat(s)));r.pxVal=Math.round(r.floatVal*q)}}return r};this.setCropValues=function(s,u,v,q){d={l:s,t:u,r:v,b:q};n=b;s=m(s,c.width);v=m(v,c.width);u=m(u,c.height);q=m(q,c.height);h.setRect(s.floatVal,u.floatVal,v.floatVal,q.floatVal);f(s.pxVal,u.pxVal,v.pxVal,q.pxVal)};this.setSourceDimension=function(q,r){c.width=q;c.height=r;l()};this.getSourceDimension=function(){return{width:c.width,height:c.height}};this.isCropped=function(){return k};this.getImageRect=function(){return i.duplicateRect()};this.flipCropHorz=function(){var r=function(t){var s=t.l;t.l=t.r;t.r=s};var q=function(t){var s=t.l;t.l=1-t.r;t.r=1-s};if(n){q(n)}if(d){r(d)}l()};this.getFloatValues=function(){return h.duplicateRect()};this.getFloatRect=function(){var q=h.duplicateRect();q.right=1-q.right;q.bottom=1-q.bottom;return q};this.getCropMargins=function(){return e.duplicateRect()};var l=function(){if(n!==b){p.setCropRect(n.l,n.t,n.r,n.b)}else{if(d!==b){p.setCropValues(d.l,d.t,d.r,d.b)}else{f(0,0,0,0);h.setRect(0,0,0,0)}}};this.getOffsettedPixelRangeRect=function(q,v,r,t){var u=i.width();var s=i.height();q=Math.max(0,Math.min(u,q));v=Math.max(0,Math.min(s,v));r=Math.max(0,Math.min(u-q,r));t=Math.max(0,Math.min(s-v,t));q+=i.left;v+=i.top;return new a.Rect(q,v,r,t)};this.getPixelRangeRect=function(r,u,z,v,B,s){var q,A;if(r===b&&u===b){r=i.width();u=i.height();A=1}else{if(r!==b){A=i.width()/r;if(u===b){u=i.height()/A}}else{A=i.height()/u;if(r===b){r=i.width()/A}}}if(z===b){z=v=0;B=r;s=u}if(!k){q=new a.Rect(z,v,B,s);q._refWidth=r;q._refHeight=u}else{r*=A;u*=A;var t=new a.Rect(z,v,B,s);t.scaleRect(A);q=p.getOffsettedPixelRangeRect(t.left,t.top,t.right,t.bottom);q.scaleRectInt(1/A);r+=e.left+e.right;u+=e.top+e.bottom;r/=A;u/=A;q._refWidth=Math.round(r);q._refHeight=Math.round(u);q.right=Math.min(q._refWidth-q.left,q.right);q.bottom=Math.min(q._refHeight-q.top,q.bottom)}return q};this.getPixelRangeParameters=function(A,u,q,z,r,t){var s;var v=p.getPixelRangeRect(A,u,q,z,r,t);if(v.left===0&&v.top===0&&v.width()===v._refWidth&&v.height()===v._refHeight){s="&width="+v._refWidth}else{s="&pixelRange="+v.left+","+v.top+","+v.right+","+v.bottom+"&referenceWidth="+v._refWidth+"&referenceHeight="+v._refHeight}return s};this.getPixelRangeParametersByCalculatedResult=function(r){var q;if(r.left===0&&r.top===0&&r.width()===r._refWidth&&r.height()===r._refHeight){q="&width="+r._refWidth}else{q="&pixelRange="+r.left+","+r.top+","+r.right+","+r.bottom+"&referenceWidth="+r._refWidth+"&referenceHeight="+r._refHeight}return q};this.getCropToFill=function(u,s,y,B){var C=new a.CroppedImage();var D,v;if(typeof(y)!=="string"||y.length!==2){y="cc"}else{y=y.toLowerCase()}var t=0;var r=new a.Rect();var A;var z=p.isCropped();var q,E;var x,F;if(z){x=(1-h.left-h.right);F=(1-h.top-h.bottom);q=Math.round(x*c.width);E=Math.round(F*c.height)}else{q=c.width;E=c.height}u=Math.min(u,q);s=Math.min(s,E);if(u/q<s/E){v=s;D=Math.round(q/E*s);t=D-u;switch(y.charAt(1)){case"l":r.setRect(0,0,D-t,v);break;case"r":r.setRect(t,0,D,v);break;case"v":A=Math.random()*t;r.setRect(A,0,A+u,v);break;default:r.setRect(t/2,0,D-t/2,v)}}else{D=u;v=Math.round(E/q*u);t=v-s;switch(y.charAt(0)){case"t":r.setRect(0,0,D,v-t);break;case"b":r.setRect(0,t,D,v);break;case"v":A=Math.random()*t;r.setRect(0,A,D,A+s);break;default:r.setRect(0,t/2,D,v-t/2)}}r.scaleRectXY(1/D,1/v);if(p.isCropped()){D/=x;v/=F;if(B){D=Math.min(D,c.width);v=Math.min(v,c.height)}C.setSourceDimension(D,v);r.scaleRectXY(x,F);r.offsetRect(h.left,h.top)}else{if(B){D=Math.min(D,c.width);v=Math.min(v,c.height)}C.setSourceDimension(D,v)}C.widthUncropped=D;C.heightUncropped=v;C.setCropRect(r.left,r.top,r.right,r.bottom);return C}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomSkinClass!==b){return}a.CustomSkinClass=function(i,m,f,j){var q=this;var l;var o;var g;var k;var n=f.getCallbacks();var d=this.paramCustomSkinClass=m;var c;var p=function(){l=f.getRootContainer();o=f.getParentElement();q.destroy();c=a.getViewerLocation()+"/skins/";if(typeof(m)==="string"){if(m.match(/\.js$/)){var r=a.getViewerLocation()+"/"+m;c=r;c=c.replace(/\/[^/]*$/,"/");a.loadJavascript(r,f.getInstanceID(),q,e)}else{if(typeof(window[m])==="function"){k=new window[m](i,o,h,q)}}}else{if(typeof(m)==="function"){k=new m(i,o,h,q)}}};this.getSkinPath=function(){return c};this.replacePaths=function(r){r=r.replace(/\[fsi-skin-path]/g,c);r=r.replace(/\[fsi-viewer-path]/g,a.getViewerLocation()+"/");return r};this.loadHTMLFragment=function(s,v,t,r){s=q.replacePaths(s);var u=function(x,w){w=q.replacePaths(w);if(v&&typeof(v)==="object"&&v.tagName){while(v.firstChild){v.removeChild(v.firstChild)}v.innerHTML=w}t(w,r)};i.loadFile(s,u,"text/plain; charset=utf-8")};var h=function(s){g=s;if(s&&typeof(s)==="object"&&s.tagName){s.appendChild(l)}if(n.isset("onResize")){var r=f.getElementSpace();n.run("onResize",[r.width,r.height,true,f.getIsFullScreen()])}if(i.onResize){i.onResize({FSI_after_treshold:true})}j.apply(i)};var e=function(){d=d.replace(/\.js$/,"");var r=d.lastIndexOf("/");if(r!==1){d=d.substr(r+1)}if(d.length>0&&typeof(window[d])==="function"){k=new window[d](i,o,h,q)}else{h()}};this.getCustomSkinInstance=function(){return k};this.destroy=function(){if(k&&typeof(k.destroy)==="function"){k.destroy(q);k=b}if(g!==b){g=b;while(o.firstChild){o.removeChild(o.firstChild)}o.appendChild(l)}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Sprite!==b){return}a.Sprite=function(k,i,t,o,s,m,f){var n=this;var c=0.075;var d;var e=true;var u;var j;var v=1;var l=n.margin={left:0,top:0,right:0,bottom:0};var r={};r.width=i;r.height=t;var p=(s)?"canvas":"div";d=n.element=document.createElement(p);d.setAttribute("draggable","false");if(f){d.className=f}var g="";switch(m){case"inline":break;default:g+="position:absolute;z-index:"+o}a.utils.setStyleAttr(d,g);if(s){n.canvas=n.element;n.canvas.setAttribute("crossorigin","anonymous");n.canvas.setAttribute("width",r.width);n.canvas.setAttribute("height",r.height);n.ctx=n.canvas.getContext("2d")}if(k){k.appendChild(d)}this.remove=function(){if(k){a.removeChild(k,d)}};this.setPos=function(h,w){n.x=h;n.y=w;d.style.marginLeft=h+"px";d.style.marginTop=w+"px"};this.isVisible=function(){return(v>0)};this.show=function(h,w){if(e===h){return}e=h;if(j!==b){cancelAnimationFrame(j);j=b}if(!w){v=d.style.opacity=(h)?1:0;d.style.display=(h)?"block":"none"}else{u=(h)?c:-c;if(h){d.style.display="block"}q()}};this.updateMargins=function(){l=n.margin=a.utils.getElementMargins(d)};this.getClientDim=function(){return a.getElementClientDim(n.element)};this.updateDimension=function(){r=a.getElementClientDim(d)};this.width=function(){return r.width};this.height=function(){return r.height};var q=function(){v+=u;if(u>0){if(v>=1){v=1;j=b}else{j=requestAnimationFrame(q)}}else{if(v<=0){v=0;j=b;d.style.display="none"}else{j=requestAnimationFrame(q)}}d.style.opacity=v};if(!s){this.setSize=function(x,y){r.width=x;r.height=y;if(typeof(x)!=="string"){x+="px"}if(typeof(y)!=="string"){y+="px"}n.element.style.width=x;n.element.style.height=y};this.clear=function(){}}else{this.setSize=function(x,y){r.width=x;r.height=y;n.canvas.width=x;n.canvas.height=y};this.clear=function(){n.ctx.clearRect(0,0,r.width,r.height)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ToolTip!==b){return}a.ToolTip=function(c){var q=this;var n;var h;var d;var m,l;var j;var k=false;var e={};var g=false;var i;var p=function(){n=document.createElement("div");a.addClass(n,"fsi-ui-tool-tip-container fsi-ui-tool-tip-container-hidden");h=document.createElement("div");a.addClass(h,"fsi-ui-tool-tip");n.appendChild(h);d=document.createElement("div");a.addClass(d,"fsi-ui-tool-tip-arrow");n.appendChild(d)};this.destroy=function(){q.hide();clearTimeout(j)};this.setContent=function(r){i=r};this.show=function(t,s,r,z,v,u,w){if(!i){return}e.strTip=t;e.elSrc=s;e.x=r;e.y=z;e.bNoAutoBold=w;e.fnGetToolTipText=v;if(l!==b){clearTimeout(l);l=b}if(m!==b){clearTimeout(m)}if(u===b){u=(k)?100:1000}m=setTimeout(f,u)};this.setParentContainer=function(r){q.hide();c=r};var f=function(){if(m!==b){clearTimeout(m);m=b}var w=e.strTip;var C,D;if(e.fnGetToolTipText!==b){D=e.fnGetToolTipText(w,i);if(D===b){D=i[w]}}else{D=i[w]}if(D!==b){w=D}else{if(!e.bNoAutoBold){w="<b>"+w+"</b>"}}h.innerHTML=w;c.appendChild(n);d.style.left="0px";n.style.display="inline-block";n.style.width=c.offsetWidth+"px";C=a.getElementClientPos(h);n.style.display="block";n.style.width=C.width+"px";var G=e.x;if(G===b){G=0}var F=e.y;if(F===b){F=0}var v;var u=a.getElementClientPos(c);if(e.elSrc){v=a.getElementClientPos(e.elSrc);G+=v.left-u.left+(v.right-v.left)/2;F+=v.top-u.top}C=a.getElementClientPos(n);G-=C.width/2;F-=C.height+2;var t=document.body;var z=4;var E=G;var s=t.clientWidth;if(a.isMobileDevice){s=Math.max(t.clientWidth,u.width+u.left)}G=Math.min(s-u.left-C.width-z,Math.max(-u.left+z,G));var B=E-G;var r=d.offsetWidth/2;if(B!==0){var A=Math.min(n.offsetWidth/2-r,Math.abs(B));if(B<0){B=-A}else{B=A}}d.style.left=(n.offsetWidth/2-r+B)+"px";n.style.left=G+"px";n.style.top=F+"px";g=true;k=true;clearTimeout(j);j=setTimeout(o,1000);a.removeClass(n,"fsi-ui-tool-tip-container-hidden");a.addClass(n,"fsi-ui-tool-tip-container-visible")};var o=function(){k=false};this.hideAfter=function(r){if(r===b||isNaN(r)||r<1){r=2500}if(l!==b){clearTimeout(l);l=b}l=setTimeout(q.hide,r)};this.hide=function(){if(m!==b){clearTimeout(m);m=b}if(l!==b){clearTimeout(l);l=b}if(g){a.removeClass(n,"fsi-ui-tool-tip-container-visible");a.addClass(n,"fsi-ui-tool-tip-container-hidden");a.removeChild(c,n);g=false}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.FullScreen!==b){return}a.FullScreen={};a.FullScreen.__initDone=false;a.FullScreen._nIDChangeEvent=0;a.FullScreen._nIDErrorEvent=0;a.FullScreen._eventHandlers={};a.FullScreen.__init=function(){var d=a.FullScreen;if(d.__initDone){return}d.__initDone=true;var c=0;if(document.webkitExitFullscreen){c=3}else{if(document.msExitFullscreen){c=1}else{if(document.mozCancelFullScreen){c=2}else{if(document.exitFullscreen){c=0}}}}switch(c){case 1:d.requestFullscreen="msRequestFullscreen";d.exitFullscreen="msExitFullscreen";d.fullscreenPseudoClass=":-ms-fullscreen";d.fullscreenChange="MSFullscreenChange";d.fullscreenError="MSFullscreenError";d.fullScreen="msFullscreenElement";d.fullscreenElement="msFullscreenElement";break;case 2:d.requestFullscreen="mozRequestFullScreen";d.exitFullscreen="mozCancelFullScreen";d.fullscreenPseudoClass=":-moz-full-screen";d.fullscreenChange="mozfullscreenchange";d.fullscreenError="mozfullscreenerror";d.fullScreen="mozFullScreen";d.fullscreenElement="mozFullScreenElement";break;case 3:d.requestFullscreen="webkitRequestFullscreen";d.exitFullscreen="webkitExitFullscreen";d.fullscreenPseudoClass=":-webkit-full-screen";d.fullscreenChange="webkitfullscreenchange";d.fullscreenError="webkitfullscreenerror";d.fullScreen="webkitIsFullScreen";d.fullscreenElement="webkitFullscreenElement";break;default:d.requestFullscreen="requestFullscreen";d.exitFullscreen="exitFullscreen";d.fullscreenPseudoClass=":fullscreen";d.fullscreenChange="fullscreenChange";d.fullscreenError="fullscreenError";d.fullScreen="fullScreen";d.fullscreenElement="fullscreenElement"}if(typeof(document[d.exitFullscreen])!=="function"){a.FullScreen.bUseFakeFullScreen=true}d.nMode=c};a.FullScreen.start=function(c){a.FullScreen.__init();a.FullScreen.quit();if(!a.FullScreen.bUseFakeFullScreen){c[a.FullScreen.requestFullscreen]()}else{a.FullScreen._enterFakeFullScreen(c)}};a.FullScreen.quit=function(){a.FullScreen.__init();if(!a.FullScreen._exitFakeFullScreen()&&!a.FullScreen.bUseFakeFullScreen){document[a.FullScreen.exitFullscreen]()}};a.FullScreen._enterFakeFullScreen=function(c){if(!c){return}var f=a.FullScreen.oFake={};f.elParentOriginal=c.parentNode;f.elNextSibling=c.nextSibling;f.el=c;var e,d;e=document.documentElement;f.docScrollLeft=e.scrollLeft;f.docScrollTop=e.scrollTop;e.scrollTop=e.scrollLeft=0;e=document.body;f.bodyScrollLeft=e.scrollLeft;f.bodyScrollTop=e.scrollTop;e.scrollTop=e.scrollLeft=0;d=f.bodyStyle={};d.overflow=e.style.overflow;e.style.overflow="hidden";d.boxSizing=e.style.boxSizing;e.style.boxSizing="border-box";if(document.documentElement){e=document.documentElement;d=f.documentStyle={};d.overflow=e.style.overflow;e.style.overflow="hidden";d.boxSizing=e.style.boxSizing;e.style.boxSizing="border-box"}a.FullScreen.bChanging=true;document.body.appendChild(c);a.FullScreen.bChanging=false;a.addEvent(window,"keydown",a.FullScreen._keyDown);a.FullScreen.callHandlers()};a.FullScreen._keyDown=function(c){if(c&&c.key==="Escape"||c.which===27){a.FullScreen.quit()}};a.FullScreen._exitFakeFullScreen=function(){if(!a.FullScreen.oFake){return false}var f=a.FullScreen.oFake;a.FullScreen.bChanging=true;if(f.elParentOriginal){if(f.elNextSibling){f.elParentOriginal.insertBefore(f.el,f.elNextSibling)}else{f.elParentOriginal.appendChild(f.el)}}var e=document.body;var d=f.bodyStyle;var c;for(c in d){if(d.hasOwnProperty(c)){e.style[c]=d[c]}}e.scrollLeft=f.bodyScrollLeft;e.scrollTop=f.bodyScrollTop;if(document.documentElement){e=document.documentElement;d=f.documentStyle;for(c in d){if(d.hasOwnProperty(c)){e.style[c]=d[c]}}e.scrollLeft=f.docScrollLeft;e.scrollTop=f.docScrollTop}a.FullScreen.bChanging=false;a.FullScreen.oFake=b;a.FullScreen.callHandlers();a.removeEvent(window,"keydown",a.FullScreen._keyDown);return true};a.FullScreen.toggle=function(c){if(a.FullScreen.getEnabled()){a.FullScreen.quit()}else{a.FullScreen.start(c)}};a.FullScreen.getFullscreenPseudoClass=function(){a.FullScreen.__init();return a.FullScreen.fullscreenPseudoClass};a.FullScreen.addChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();a.FullScreen._nIDChangeEvent++;if(typeof(e)==="function"){if(!e._FSIFullScreenEventID){a.FullScreen._eventHandlers[a.FullScreen._nIDChangeEvent]=e;e._FSIFullScreenEventID=a.FullScreen._nIDChangeEvent}a.addEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)==="function"){a.addEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.callHandlers=function(){var c={type:"fullscreenchange",FSI_fake:true};for(var e in a.FullScreen._eventHandlers){if(a.FullScreen._eventHandlers.hasOwnProperty(e)){var d=a.FullScreen._eventHandlers[e];d(c)}}};a.FullScreen.removeChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();if(typeof(e)==="function"){if(e._FSIFullScreenEventID&&a.FullScreen._eventHandlers[e._FSIFullScreenEventID]){delete a.FullScreen._eventHandlers[e._FSIFullScreenEventID]}a.removeEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)==="function"){a.removeEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.getAvailable=function(d){a.FullScreen.__init();var c=d[a.FullScreen.requestFullscreen];return(c)};a.FullScreen.getEnabled=function(){a.FullScreen.__init();var c=a.FullScreen.getElement();return(c!==b&&c!==null)};a.FullScreen.getElement=function(){a.FullScreen.__init();var c;if(a.FullScreen.bUseFakeFullScreen){if(a.FullScreen.oFake){c=a.FullScreen.oFake.el}}else{c=document[a.FullScreen.fullscreenElement]}return c}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderCSSSkin!==b){return}a.LoaderCSSSkin=function(){var e=this;var i=0;var g={};var c=0;var d=new a.CORSLoader();var h=function(m,l,u,k,s){var r=this;var t;var A=[];var n;var x=0;var q=false;var p=false;this.uniqueID=c++;this.bReleased=false;this.getSkinName=function(){return l.getSkinName()};this.callReady=function(C,D,F,E){if(this.bReleased){return}if(E){p=true}n=arguments;q=true;o()};var o=function(){if(!q||x>0){return}if(p){t=setTimeout(y,1)}else{y()}};var y=function(){j();u.apply(k,n)};var j=function(){if(t!==b){clearTimeout(t);t=b}};this.remove=function(){j();if(r.bReleased){return}l.removeWaiter(r.uniqueID);for(var C=0;C<A.length;C++){A[C].remove()}this.bReleased=true};var B=function(C,D,F,E){if(E){p=true}x--;o()};if(s&&typeof(s)=="object"&&s.length>0){for(var v=0;v<s.length;v++){var w=s[v];x++;var z=a.utils.loadSkinCSS(w.file,r,B,w.nPriority);A.push(z)}}};var f=function(j,v){var s=false;var k=0;var u={};var p=false;var q=false;var r;var o;var l;var n;l=j.match(/(.*)\/[^/]*$/);l=l[1]+"/";l=l.replace(/\/resources\/$/,"/");o=j.replace(/\.[^/]*$/,"");o=o.match(/([^/]*)$/);o=o[1].toLowerCase();this.removeWaiter=function(w){if(u[w]===b){return}delete u[w];k--};this.addWaiter=function(w){if(w.uniqueID===b||w.bReleased){return}if(p){w.callReady(q,n,"ALREADY LOADED",false)}else{if(u[w.uniqueID]===b){u[w.uniqueID]=w;k++;if(!s){t()}}}};this.getSkinName=function(){return o};var m=function(G,z,H,B){var E=false;if(B>299||typeof(z)!="string"){a.console.error("Failed to load Skin CSS (HTTP "+B+"): "+j)}else{E=true;z=z.replace(/\[fsi-skin-path]/g,l);r=document.createElement("style");r.setAttribute("type","text/css");r.setAttribute("data-generated-by","FSI");r.setAttribute("data-fsi-skin",o);r.setAttribute("data-fsi-priority",v);r.appendChild(document.createTextNode(z));var D=document.head;if(!D){D=document.getElementsByTagName("head");if(D&&D.length>0){D=D[0]}}if(D&&D.firstChild){try{var y;var I=D.getElementsByTagName("style");for(var A=0;A<I.length;A++){var F=I[A];var x=parseInt(F.getAttribute("data-fsi-priority"));if(isNaN(x)||x>v){y=F;break}}if(y){D.insertBefore(r,y)}else{D.appendChild(r)}}catch(C){D.appendChild(r)}}else{D.appendChild(r)}n=r.sheet;q=E}p=true;for(var w in u){if(u.hasOwnProperty(w)){u[w].callReady(q,n,"onLoaded",true)}}u={};k=0};var t=function(){s=true;if(typeof(j)!="string"||j.length<0){return false}d.load(j,m,"text/css");return true}};this.load=function(o,p,l,q,k){if(q===b){q=100}var n=false;if(a.versionInternetExplorer<9){n=true}if(n){a.console.error("Unable to load skin: unsupported browser version.");if(l){l.call(p,false)}return false}if(!a.getViewerLocation()||typeof(o)!="string"||o.length<1){a.console.error("Unable to load skin:");if(!a.getViewerLocation()){a.console.error("FSI Viewer path not known")}else{a.console.error("Invalid skin URL "+o)}if(l){l.call(p,false)}return false}var j=o;if(j.indexOf("http")!==0){j=a.getViewerLocation()+"/skins/"+j}if(!j.match(/\.css$/)){j+=".css"}var r;if(g[j]===b){i++;r=g[j]=new f(j,q)}else{r=g[j]}var m=new h(j,r,l,p,k);r.addWaiter(m);return m}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderJavascript!==b){return}a.LoaderJavascript=function(){var e={};this.load=function(h,l,n,j,m){var k=e[h];if(n===b){n=window}if(typeof(j)!="function"){return false}if(k===b){k=e[h]={};k.path=h;k.loaded=false;k.failed=false;f(k);if(!g(k)){k.failed=true;k.loaded=true;k.addNodeFailed=true}}else{if(k.oListeners[l]!==b){d(h,l)}}k.nListeners++;var i=k.oListeners[l]={};i.argScope=n;i.argFunction=j;i.oPassThrough=m;if(k.loaded===true){c(k)}return true};var d=this.release=function(h,j){var i=e[h];if(i===b){return}if(i.oListeners[j]!==b){delete i.oListeners[j];i.nListeners--}};var g=function(l){var h=false;try{var i=document.getElementsByTagName("head");if(i&&i.length>0){i=i[0];var j=l.node=document.createElement("script");var k=l.onLoad=function(n){if(n.type==="error"){l.failed=true;c(l)}else{l.failed=false;c(l)}l.loaded=true};a.addEvent(j,"load",k);l.onError=function(){l.failed=true;c(l);l.loaded=true};a.addEvent(j,"error",k);i.appendChild(j);j.src=l.path;h=true}}catch(m){}return h};var c=function(j){var h=!j.failed;a.removeEvent(j.node,j.onLoad);a.removeEvent(j.node,j.onError);for(var k in j.oListeners){if(j.oListeners.hasOwnProperty(k)){var i=j.oListeners[k];i.argFunction.call(i.argScope,h,j.path,i.oPassThrough)}}f(j)};var f=function(h){h.oListeners={};h.nListeners=0}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CSSTransformMatrix!==b){return}a.CSSTransformMatrix=function(){var d=[];var e=[1,0,0,1,0,0];var c=a.utils.getCSSTransformStyleName();this.init=function(){d[0]=e[0];d[1]=e[1];d[2]=e[2];d[3]=e[3];d[4]=e[4];d[5]=e[5]};this.rotate=function(h){e[0]=Math.cos(h);e[1]=Math.sin(h);e[2]=-1*Math.sin(h);e[3]=Math.cos(h);g();e[0]=1;e[1]=0;e[2]=0;e[3]=1};this.translate=function(h,i){e[4]=h;e[5]=i;g();e[4]=0;e[5]=0};this.scale=function(h,i){e[0]=h;e[3]=i;g();e[0]=1;e[3]=1};this.skew=function(h,i){e[1]=Math.tan(i);e[2]=Math.tan(h);g();e[1]=0;e[2]=0};var g=function(){var h=d[0];d[0]=e[0]*d[0]+e[2]*d[1];d[1]=e[1]*h+e[3]*d[1];h=d[2];d[2]=e[0]*d[2]+e[2]*d[3];d[3]=e[1]*h+e[3]*d[3];h=d[4];d[4]=e[0]*d[4]+e[2]*d[5]+e[4];d[5]=e[1]*h+e[3]*d[5]+e[5]};var f=this.outputString=function(){return d.join()};this.set=function(l,j,o,n,k,h){for(var m=0;m<arguments.length;m++){d[m]=arguments[m]}};this.applyTo=function(h){h.style[c]="matrix("+f()+")"};this.init()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!==b){return}a.Easing={easeLinear:function(f,g,e,h){return h*(f/g)+e},easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f===0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f===g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f===0){return e}if(f===g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j)===1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j)===1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j/2)===2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g===b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g===b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g===b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!==b){return}a.TouchHandler=function(m,aX,al,e,aN){var aE=this;var aL=false;var ak=true;var o=false;var aT=false;var aK=false;var aB,E,j,ad;var aC,Y,aI;var h=false;var ae;var r;var a0={};var aq=[];var ac=0;var I=window;var aV;var s;var aU;var d;var aZ=[];var aR={x:0,y:0};var v={x:0,y:0};var ar=40;var n={};n.enabled=false;n.factor=5;n.fEndDiff=1;var ay={};ay.enabled=false;ay.minFrames=14;ay.factorAmount=23;ay.factorAmountQuad=0;ay.factorFrames=2.6;ay.offsetFrames=5;var ab;var az;var aH,w;var F;var at={};var X;var aM=false;var z=false;var am={};am.name="none";var N;var W;var aO;var f=false;var Z={};if(!aX||typeof(aX)!="object"){aX={}}var an=function(){var a6;if(aL){aE.destroy()}aU=A;s=b;if(a.utils.getTopWindow()!==window){s=a.utils.getTopWindow();try{var a5=a.getWindowOffset(window);if(a5.x!==b&&a5.y!==b){aU=ap}}catch(a4){aU=A;s=b}}else{s=b}F=aX.oPassTrough;aW(aX.panDirectionAllowed,true);if(aX.getPageCoords){r=aF}else{r=M}if(aX.afterTouch){for(a6 in aX.afterTouch){if(aX.afterTouch.hasOwnProperty(a6)){ay[a6]=aX.afterTouch[a6]}}}if(ay.minDelta===b){ay.minDelta=15}if(aX.nClickRadius){ab=aX.nClickRadius}else{ab=10}if(ay.fnStartStopAfterTouch&&typeof(ay.fnStartStopAfterTouch)!="function"){ay.fnStartStopAfterTouch=b}if(ay.fnStartStopAfterTouch){ay.useAnimationFrame=b}if(typeof(ay.modifyTarget)!="function"){ay.modifyTarget=b}if(typeof(ay.fnGetAfterTouchEnabled)=="function"){az=ay.fnGetAfterTouchEnabled}else{az=b}if(aX.smoothing){for(a6 in aX.smoothing){if(aX.smoothing.hasOwnProperty(a6)){n[a6]=aX.smoothing[a6]}}}if(aX.detectClick===true){X=true}if(aX.preventSelection!==false){aX.preventSelection=true}if(!m){return}if(typeof(m.join)!="function"){m=[m]}if(typeof(al)!="function"){al=A}if(typeof(e)!="function"){e=A}if(typeof(aN)!="function"){aN=A}if(typeof(aX.onPinchChange)=="function"){N=aX.onPinchChange}else{N=b}aM=aX.detectGestures;aZ=[];ax(true,aM);for(var a3=0;a3<m.length;a3++){var a2=m[a3];if(a2&&typeof(a2.nodeName)!="undefined"){a6={};a6.element=a2;aZ.push(a6);ao(a2,R);if(a.isTouch){try{if(a2.style!==b){if(a.BrowserSupports.cssTouchAction()){if(at.cssTouchAction!==b){q(a2,at.cssTouchAction)}}}}catch(a4){}}}}if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aD,false)}};this.setFnDown=function(a2){al=a2};this.setFnUp=function(a2){aN=a2};this.setFnMove=function(a2){e=a2};var aW=this.setAllowedPanDirection=function(a3,a2){if(typeof(a3)=="string"){if(a3==="pan-x"||a3==="pan-y"||a3==="pan-x pan-y"){aV=a3+" "}else{aV=""}}else{aV=""}if(!a2){at.nCheck=b;ah(at.captureScroll,at.capturePinch)}};this.enable=function(a2){if(ak===a2){return}if(!a2){Q();ah(false,false)}else{ah(at.captureScrollUser,at.capturePinchUser)}ak=a2};this.getEnabled=function(){return ak};this.cancel=function(){P();ag();aJ();Q()};var aJ=function(){if(n.enabled){i()}B()};this.cancelAfterTouch=function(){B()};this.getInitialDownEvent=function(){return W};var Q=function(){if(!o){return}aJ();o=false;W=b;z=false;if(ac===0){aP()}};var aP=function(){f=false;c()};this.destroy=function(){if(a.BrowserSupports.cssTouchAction()){for(var a3=0;a3<m.length;a3++){var a2=m[a3];q(a2,"")}}if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aD,false)}if(aO){clearTimeout(aO)}aE.cancel();var a2;for(var a3=0;a3<aZ.length;a3++){var a4=aZ[a3];a2=a4.element;x(a2,R)}at={}};var q=function(a2,a3){if(!a.BrowserSupports.cssTouchAction()||!a2||!a2.style){return}a2.style.touchAction=a2.style.msTouchAction=a3};var T=function(a2){if(a2.preventDefault){a2.preventDefault()}};var l=function(a2){T(a2);return false};var ao=function(a3,a2){a.addEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{a.addEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a3,"touchstart",a2);a.addEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a3,"MSPointerDown",a2)}a.addEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var x=function(a3,a2){a.removeEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{a.removeEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a3,"touchstart",a2);a.removeEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a3,"MSPointerDown",a2)}a.removeEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var A=function(){return true};var aQ=function(a2){if(aK){V(a2,a2.pointerId)}else{var a3=a2.changedTouches;for(var a4=0;a4<a3.length;a4++){V(a3[a4],a3[a4].identifier)}}};var V=function(a2,a4){if(a4===b||a0[a4]!==b){if(aX.debug){if(a4===b){a.console.error("doRegisterPointer: no pointerId")}if(a0[a4]!==b){a.console.error("doRegisterPointer: pointerId already registered: "+a4)}}return}ac++;var a3=a0[a4]={};a3.identifier=a4;r(a3,a2);aq.push(a3)};var aj=function(a2){var a4=false;if(aK){a4=K(a2.pointerId)}else{var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){a4=K(a3[a5].identifier)}}}if(a4){aq=new Array(ac);var a7=0;for(var a6 in a0){if(a0.hasOwnProperty(a6)){aq[a7++]=a0[a6]}}}};var K=function(a2){if(a2===b||a0[a2]===b){if(aX.debug){if(a2===b){a.console.error("doUnregisterPointer: no pointerId")}if(a0[a2]===b){a.console.error("doUnregisterPointer: pointerId not registered: "+a2)}}return false}delete a0[a2];ac--;return true};var H=function(){ac=0;a0={};aq=[]};var M=function(a3,a2){a3.x=a2.clientX;a3.y=a2.clientY};var aF=function(a3,a2){a3.x=a2.pageX;a3.y=a2.pageY};var u=function(a2){var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){var a4=a0[a3[a5].identifier];if(a4){r(a4,a3[a5])}}}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y}};var aw=function(a2){var a3=a0[a2.pointerId];if(a3){r(a3,a2)}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y;aU(a2,aR)}};var U=function(a2){r(aR,a2);aU(a2,aR)};this.getMousePositionFromMouseEvent=function(a2){U(a2);return aR};this.getMousePositionPage=function(a3){var a2={};aF(a2,a3);aU(a3,a2);return a2};this.getMousePositionClient=function(a3){var a2={};M(a2,a3);aU(a3,a2);return a2};var t=function(a2,a3){if(window!==a2.view){var a4=a.getWindowOffset(window);a3.x-=a4.x;a3.y-=a4.y}};var ap=function(a2){try{t(a2);aU=t}catch(a3){aU=A}};var aA=function(a2){if(!ak){return}var a4=ac;if(z&&a4===0){z=false}var a5=a2.type;if(o||am.started){if(a5!==aB){if(am.started){P();ag()}else{a2._FSI_Canceled=true;a1(a2,true)}}}aB=a5;d=false;var a3=true;switch(a5){case"touchstart":aT=true;aK=false;ae=u;j="touchmove";E="touchend";ad="touchcancel";aH=false;break;case"MSPointerDown":ae=aw;aT=true;aK=true;j="MSPointerDown";E="MSPointerUp";ad="MSPointerCancel";aH=false;d=true;break;case"pointerdown":ae=aw;aT=true;aK=true;j="pointermove";E="pointerup";ad="pointercancel";aH=true;d=true;break;default:if(ac>0){H()}aT=false;aK=false;aH=(aX.preventSelection);a3=false;ae=U;j="mousemove";E="mouseup";ad=b;d=true}if(aT&&a3){aQ(a2)}ae(a2);if(ac>1){Z.bClick=false}w=false;if(a3&&ai(a2)){if(a4===0){B();D()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ac};var R=this.handleDownEvent=function(a2){if(aX.bMouseOnly&&a2.type==="pointerdown"&&a2.pointerType!=="mouse"){return true}if(!aA(a2)){return}if(o||a2.which>1){return}g(a2)};this.getCurrentPos=function(){return v};var g=function(a2){aJ();if(o){return}ay.evtMove=b;if(n.enabled){v={x:aR.x,y:aR.y}}else{v=aR}Z.x=aR.x;Z.y=aR.y;var a3=W;W=a2;if(!al.call(I,a2,v,F)){W=a3;return false}o=f=true;if(X&&!z){Z.bClick=true;Z.clickRadiusX=Z.clickRadiusY=0}else{Z.bClick=false}D();if(ay.enabled){ay.x=ay.y=0;ay.lastX=aR.x;ay.lastY=aR.y;if(ay.nInterval){clearInterval(ay.nInterval)}ay.nInterval=setInterval(aa,30)}return true};var c=function(){if(h&&Y!==b){var a2={passive:false,capture:false};var a4=(s===b)?a2:b;h=false;a.removeEvent(window,Y,af,a4);a.removeEvent(window,aC,a1,a4);if(d&&s){try{a.removeEvent(s,Y,af,a2);a.removeEvent(s,aC,a1,a2)}catch(a3){}}if(aI!==b){a.removeEvent(window,aI,au,a4)}Y=aC=aI=b}};var aD=function(){};var D=function(){if(h){c()}h=true;var a2={passive:false,capture:false};var a4=(s===b)?a2:b;Y=j;aC=E;aI=ad;a.addEvent(window,Y,af,a4);a.addEvent(window,aC,a1,a4);if(d&&s){try{a.addEvent(s,Y,af,a2);a.addEvent(s,aC,a1,a2)}catch(a3){}}if(ad!==b){a.addEvent(window,aI,au,a4)}};var af=function(a2){ae(a2);a2.FSI_start_x=Z.x;a2.FSI_start_y=Z.y;if(ay.enabled&&ay.evtMove===b){ay.evtMove=a2}if(o){if(Z.bClick){Z.clickRadiusX=Math.max(Z.clickRadiusX,Math.abs(aR.x-Z.x));if(Z.clickRadiusX>ab){Z.bClick=false}else{Z.clickRadiusY=Math.max(Z.clickRadiusY,Math.abs(aR.y-Z.y));if(Z.clickRadiusY>ab){Z.bClick=false}}}if(n.enabled){n.evt=a2;aY()}else{e.call(I,a2,v,F)}}else{if(am.started){if(am.nType===1){av(a2)}}}if(w&&!a2.FSI_allowEventDefault){T(a2)}};var av=function(a2){var a3=k();if(!N){return}a2._FSI_PinchDeltaStart=am.nPinchDistance-am.pinchDistanceStart;a2._FSI_PinchDeltaRelative=am.nPinchDistance-am.pinchDistanceLast;a2._FSI_PinchScale=Math.max(ar,am.pinchDistanceLast)/am.pinchDistanceStartMaxed;am.pinchDistanceLast=am.nPinchDistance;a2._FSI_PinchDistance=a3;N.call(I,a2,aR,F)};var au=function(a2){if(aT){aj(a2);if(ac<1){if(o){a2._FSI_Canceled=true;a1(a2,true);return}else{Q();return}}}ae(a2);ai(a2)};var a1=function(a3,a4){var a2=Z.bClick;Z.bClick=false;if(a4){a3._FSI_Canceled=true}if(aT){aj(a3)}if(ac===0){aP()}ae(a3);if(!a4&&ai(a3)){return}aJ();if(!a4){if(!o||ac>0){return}}a3.FSI_start_x=Z.x;a3.FSI_start_y=Z.y;var a5=false;if(!a4&&ay.enabled){if(az===b||az()){a5=S(a3)}}if(a5){Q();y(a3)}else{if(X){a3._FSI_Click=a2}aN.call(I,a3,v,F);if(a3.type==="touchend"){aO=setTimeout(p,1)}Q()}T(a3)};var p=function(){Q();H();aO=b};var G=function(){return aq};var aY=function(){if(n.animationFrame!==b){return}aS()};var i=function(){if(n.animationFrame===b){return}cancelAnimationFrame(n.animationFrame);n.animationFrame=b};var aS=function(){var a2=Math.abs(v.x-aR.x)+Math.abs(v.y-aR.y);if(a2>n.fEndDiff){v.x+=(aR.x-v.x)/n.factor;v.y+=(aR.y-v.y)/n.factor;n.animationFrame=requestAnimationFrame(aS)}else{v.x=aR.x;v.y=aR.y;n.animationFrame=b}e.call(I,n.evt,v,F)};var S=function(a2){var a3;if(!ay.enabled){return false}if(ay.running){B()}ay.pos=0;var a5=(a2.touches!==b)?1.8:1;if(ay.factorAmountQuad){a3=(ay.x>0)?1:-1;ay.x=ay.x+a3*ay.x*ay.x/ay.factorAmountQuad;a3=(ay.y>0)?1:-1;ay.y=ay.y+a3*ay.y*ay.y/ay.factorAmountQuad}var a7=a5*ay.factorAmount;ay.startX=v.x;ay.startY=v.y;var a6={};a6.x=ay.startX+a7*ay.x;a6.y=ay.startY+a7*ay.y;if(ay.roundTargetPos){a6.x=Math.round(a6.x);a6.y=Math.round(a6.y)}if(ay.modifyTarget){a6=ay.modifyTarget.call(I,a6,F);if(a6===false){return false}}ay.amountX=a6.x-ay.startX;ay.amountY=a6.y-ay.startY;ay.amountXABS=Math.abs(ay.amountX);ay.amountYABS=Math.abs(ay.amountY);var a4=(ay.amountXABS>ay.minDelta||ay.amountYABS>ay.minDelta);if(a4){a7=ay.factorFrames/100;ay.frames=ay.offsetFrames+Math.round(a7*ay.amountXABS+a7*ay.amountYABS)}else{if(typeof(aX.onAfterTouchCancel)=="function"){aX.onAfterTouchCancel.call(I,a2,v,F)}}return a4};this.isAfterTouchRunning=function(){return ay.running};var y=function(a2){if(typeof(aX.onAfterTouchStart)=="function"){aX.onAfterTouchStart.call(I,a2,v,F)}ay.running=true;ay.evtUp=a2;if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,true,ay.evtMove,F)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}else{ay.intervalRun=setInterval(J,16)}}return true};var aG=function(a3,a2,a5,a4){return a5*((a3=a3/a4-1)*a3*a3+1)+a2};var J=this.runAfterTouch=function(){var a2=false;ay.pos++;v.x=aG(ay.pos,ay.startX,ay.amountX,ay.frames);v.y=aG(ay.pos,ay.startY,ay.amountY,ay.frames);e.call(I,ay.evtMove,v,F);if(ay.pos===ay.frames){B(true)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}a2=true}return a2};this.enableAfterTouch=function(a2){if(ay.enabled===a2){return}if(!a2){B()}ay.enabled=a2};var B=function(a2){if(!ay.running){return}if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,false,ay.evtMove,F)}else{if(ay.useAnimationFrame){if(ay.animationFrameRun){cancelAnimationFrame(ay.animationFrameRun)}}else{if(ay.intervalRun){clearInterval(ay.intervalRun);ay.intervalRun=b}}}if(typeof(aX.onAfterTouchEnd)=="function"){aX.onAfterTouchEnd.call(I,ay.evtMove,F)}ay.evtMove=b;ay.running=false;ay.evtUp._FSI_Canceled=(a2!==true);ay.evtUp._FSI_fromAfterTouch=true;aN.call(I,ay.evtUp,v,F)};var aa=function(){ay.x=(2*ay.x+aR.x-ay.lastX)/5;ay.y=(2*ay.y+aR.y-ay.lastY)/5;ay.lastX=aR.x;ay.lastY=aR.y};var ax=this.setCapture=function(a2,a4){var a3=ah(a2,a4);if(a3){at.captureScrollUser=a2;at.capturePinchUser=a4}return a3};var ah=function(a2,a4){var a3=0;if(a2){a3+=2}if(a4){a3+=4}if(a3===at.nCheck){return}at.nCheck=a3;at.captureScroll=a2;at.capturePinch=a4;if(a.BrowserSupports.cssTouchAction()){O(a2,a4)}return true};var O=function(){if(aX.bMouseOnly){return}var a4;switch(at.nCheck){case 0:a4="auto";break;case 2:a4=aV+"pinch-zoom";break;case 4:a4="pan-x pan-y";break;default:a4=(aV.length>0)?aV:"none"}at.cssTouchAction=a4;for(var a3=0;a3<m.length;a3++){var a2=m[a3];q(a2,at.cssTouchAction)}};var k=function(){if(aq.length<1){return 0}var a3=Math.abs(aq[1].x-aq[0].x);var a2=Math.abs(aq[1].y-aq[0].y);return am.nPinchDistance=Math.sqrt(a3*a3+a2*a2)};var ai=function(a2){w=false;if(!ak){return}var a3=aq.length;if(!aM){w=(a3===1&&at.captureScroll);return}if(am.pointerCount!==a3){P(a2);if(a3>1){ag();am.nPointers=a3;switch(a3){case 2:am.started=true;am.name="pinch";am.nType=1;if(typeof(aX.onPinchStart)=="function"){L(a2);am.nPinchDistance=0;am.nPinchDistance=k();am.pinchDistanceStart=am.pinchDistanceLast=am.nPinchDistance;am.pinchDistanceStartMaxed=Math.max(ar,am.pinchDistanceStart);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchStart.call(I,a2,aR,F)}break;default:am.started=true;am.name="unknown";am.nType=-1}if(am.started){z=true;if(o){aJ();o=false;a2._FSI_Canceled=true;aN.call(I,a2,v,F)}if(typeof(aX.onGestureStart)=="function"){L(a2);aX.onGestureStart.call(I,a2,aR,F)}}}else{if(a3<1){ag()}}am.pointerCount=a3;w=false;if(a3===1){if(at.captureScroll){w=true}}else{if(at.capturePinch&&am.nType===1){w=true}}}return am.started};var ag=function(){if(!am.timeoutRestartDown){return}clearTimeout(am.timeoutRestartDown);am.timeoutRestartDown=b};var C=function(){if(ac!==1){return}g(W);ag()};var L=function(a2){a2._FSI_Gesture=am.name;a2._FSI_GestureType=am.nType;a2._FSI_PointerCount=am.nPointers};var P=function(a2){if(!am.started){return}am.started=false;if(!a2){a2={}}if(am.nType===1&&typeof(aX.onPinchEnd)=="function"){L(a2);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchEnd.call(I,a2,aR,F)}if(typeof(aX.onGestureEnd)=="function"){L(a2);aX.onGestureEnd.call(I,a2,aR,F)}am.name="none";am.nType=0;if(a2&&ac===1){ag();am.timeoutRestartDown=setTimeout(C,20)}};an()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.VerticalScrollPanel!==b){return}a.VerticalScrollPanel=function(){var d=this;var c;var e=function(){d.elContainer=document.createElement("div");c=d.elContainerInner=document.createElement("div");a.addClass(c,"fsi-v-scroll-panel-inner");d.elContainer.appendChild(c)};this.destroy=function(){if(d.elContainer.parentNode){a.removeChild(d.elContainer.parentNode,d.elContainer)}};this.setContent=function(f){c.innerHTML="";c.appendChild(f)};e()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.CustomEventListener!==b){return}a.utils.CustomEventListener=function(i){var k=this;var c=[];var f={};var g={};var h=0;k._strClassName="$FSI.CustomEventListener";var j=function(){};this.destroy=function(){for(var l=0;l<c.length;l++){var m=c[l];e(m.element,m.fn)}c=[];f={};g={};k.onDestroy()};this.fireEvent=function(l,m){if(!l||!l.enabled){return false}if(typeof(m)!="object"){m={}}if(l.paused){m.FSI_paused=true}m.FSI_custom_event=true;m.FSI_type=i;m.FSI_target=l.element;return l.fn.call(l.element,m)};this.fireEvents=function(m){if(typeof(m)!="object"){m={}}m.FSI_custom_event=true;m.FSI_type=i;for(var n=0;n<c.length;n++){var l=c[n];if(l.enabled){if(l.paused){m.FSI_paused=true}else{if(m.FSI_paused){delete m.FSI_paused}}m.FSI_target=l.element;l.fn.call(l.element,m)}}};this.addListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for addListener");return}if(p.__FSI===b){p.__FSI={}}if(p.__FSI.eventElementID===b){p.__FSI.eventElementListenerCount=1;p.__FSI.eventElementID=a.utils.getNewEventElementID()}else{p.__FSI.eventElementListenerCount++}if(o.__FSIEventFunctionID===b){o.__FSIEventFunctionListenerCount=1;o.__FSIEventFunctionID=a.utils.getNewEventFunctionID()}else{o.__FSIEventFunctionListenerCount++}var m=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(f[m]===b){var l=f[m]={};l.nFunction=0;l.oFunctions={}}if(f[m].oFunctions[n]===b){f[m].nFunction++;f[m].oFunctions[n]=[]}else{a.console.warn(k._strClassName+": There is already a listener for this exact element and function");a.console.log(p);a.console.log(o)}var q={};q.element=p;q.elementID=m;q.fn=o;q.fnID=n;q.instanceListener=k;q.enabled=true;q.paused=false;q.uniqueID=h++;f[m].oFunctions[n].push(q);c.push(q);g[q.uniqueID]=q;k._onListenerAdd(q);k._onListenerCountChange(c.length);return q};this.setListenerProps=function(o,m,n){var l=g[o];if(!l){return false}if(l.props===b){l.props={}}l.props[m]=n;return true};this.enableListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.enabled===m){return}l.enabled=m};this.pauseListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.paused===m){return}l.paused=m};var e=this.removeListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for removeListener");return}if(typeof(p.__FSI)!=="object"||p.__FSI.eventElementID===b||o.__FSIEventFunctionID===b){if(o.__FSIEventFunctionID===b){a.console.error(k._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(k._strClassName+": Element not registered for listener in removeListener")}return}var l=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(!f[l]){a.console.error(k._strClassName+": No registered listener for this element in removeListener");return}var m=f[l].oFunctions[n];if(m===b||typeof(m.pop)!="function"){a.console.error(k._strClassName+": No registered listener for this function in removeListener");return}var q=m.pop();q.fn.__FSIEventFunctionListenerCount--;q.element.__FSI.eventElementListenerCount--;if(q.element.__FSI.eventElementListenerCount===0){delete q.element.__FSI.eventElementListenerCount;delete q.element.__FSI.eventElementID}if(q.fn.__FSIEventFunctionListenerCount===0){delete q.fn.__FSIEventFunctionListenerCount;delete q.fn.__FSIEventFunctionID}if(m.length===0){delete f[l].oFunctions[n];f[l].nFunction--;if(f[l].nFunction===0){delete f[l]}}delete g[q.uniqueID];d();k._onListenerRemove(q);k._onListenerCountChange(c.length);return q};this.getEventListenerByID=function(l){return g[l]};this.getListenerObjectByID=function(l){return g[l]};this.getListenersArray=function(){return c};this.getListenerCount=function(){return c.length};var d=function(){c=[];for(var m in f){if(f.hasOwnProperty(m)){var o=f[m].oFunctions;for(var n in o){if(o.hasOwnProperty(n)){var l=o[n];c=c.concat(l)}}}}};this.dump=function(){a.console.dir(f);a.console.dir(c)};this._onListenerCountChange=function(l){};this._onListenerAdd=function(m,l){};this._onListenerRemove=function(m,l){};this.triggerEvent=function(l){};this.triggerEvents=function(){};this.setListenerProps=function(n,l,m){};this.onDestroy=function(){};j()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIElementDimension")){return}a.utils.registerCustomEvent("FSIElementDimension",function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)==="function";a.utils.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e===b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(!g){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!==b){h(s)}}}}};var h=function(p){if(p===k||e===b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIMouseWheel")){return}a.utils.registerCustomEvent("FSIMouseWheel",function(){var c=this;var f=100000;var g;a.utils.CustomEventListener.prototype.constructor.call(c,"FSIMouseWheel");c._strClassName="$FSI.CustomEventListenerMouseWheel";this._onListenerAdd=function(h){h.callback=function(i){d(h,i)};a.addEvent(h.element,"mousewheel",h.callback);a.addEvent(h.element,"DOMMouseScroll",h.callback)};this._onListenerRemove=function(h){a.removeEvent(h.element,"mousewheel",h.callback);a.removeEvent(h.element,"DOMMouseScroll",h.callback)};this._onListenerCountChange=function(h){if(h<1){if(g!==b){clearInterval(g);g=b}}};this.setListenerProps=function(k,i,j){if(typeof(i)!=="string"){return false}var h=c.getListenerObjectByID(k);if(!h){return false}switch(i){case"acceleration":if(j){h.bAccelerate=true;h.acceleration=j;h._accelerate=1;if(h._accelerateMax===b){h._accelerateMax=10}}break;case"accelerationMax":h._accelerateMax=j;break}};var e=function(){var j=c.getListenersArray();var k=true;for(var l=0;l<j.length;l++){var h=j[l];if(h.bAccelerate&&h._accelerate>1){h._accelerate/=1.5*h.acceleration;if(h._accelerate>1.5){k=false}else{k=true;h._accelerate=1}}}if(k){clearInterval(g);g=b}};var d=function(h,i){var k=0;if(i.detail){k=i.detail}else{if(i.wheelDelta){k=-i.wheelDelta}}if(k!==0){i.FSI_normalized_delta=(k>0)?-1:1;f=Math.min(f,Math.abs(k))}else{i.FSI_normalized_delta=0}if(h.bAccelerate){if(g===b){g=setInterval(e,200)}h._accelerate*=h.acceleration;h._accelerate=Math.min(h._accelerateMax,h._accelerate);k=Math.round(h._accelerate*k)}else{h._accelerate=1}i.FSI_delta=-k;i.FSI_weighted_delta=i.FSI_delta/f;i.FSI_normalized_accelerated_delta=(k>0)?-h._accelerate:h._accelerate;var j=c.fireEvent(h,i);if(j===false){h._accelerate=1}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIDocumentZoomChange")){return}a.utils.registerCustomEvent("FSIDocumentZoomChange",function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.utils.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.utils.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!==c){if(q){j()}else{i()}}};var m=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!==q){g=q;k(q);p=true}else{p=false}return p};var d=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!==q){if(!f){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l===20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l===40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l===50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.utils.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.utils.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.utils.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.utils.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIViewport")){return}a.utils.registerCustomEvent("FSIViewport",function(){var k=this;var d=false;var h=new a.Rect(0,0,0,0);var i=new a.Rect(0,0,0,0);var l=new a.Rect(0,0,0,0);var H=new a.Rect(0,0,0,0);var t={left:0,top:0};var T;var B;var C="";var o=b;var y;var q=10;var F;var s=0;var u;var E;var S=0;var c=100;var n=1;var z=1;var N=32;var w;var p;var G=a.BrowserSupports.visualViewportAPI();try{p=window.frameElement}catch(P){}a.utils.CustomEventListener.prototype.constructor.call(k,"FSIViewport");k._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){m()};var M=function(){if(d){return}d=true;g(a.addEvent);F=a.addCustomEvent(k,"FSIDocumentZoomChange",I);n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio()};var m=function(){if(!d){return}d=false;g(a.removeEvent);a.removeCustomEvent(k,"FSIDocumentZoomChange",I);F=b;if(o){clearInterval(o);o=b}r();s=0;if(w!==b){clearTimeout(w);w=b}};var g=function(U){var e=window;U(e.document,"scroll",j,false);U(e,"resize",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&p){U(e,"touchmove",Q,false)}}while(e.frameElement){e=e.parent.window;if(e){U(e.document,"scroll",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){U(e,"touchmove",Q,false)}}U(e,"resize",j,false)}}U(window,"orientationchange",j,false)};this.setListenerProps=function(W,U,V){if(typeof(U)!="string"){return false}var e=k.getListenerObjectByID(W);if(!e){return false}switch(U){case"treshold":if(e.tresholdEnd!==b){s--;e.tresholdEnd=b}if(V&&V>0){s++;e.tresholdEnd=V}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=V;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!==b){s--}};this._onListenerCountChange=function(e){var U=(e>0);if(U!==d){if(U){M()}else{m()}}};var I=function(e){n=e.FSI_scale;z=e.FSI_scale_with_pixel_ratio;j()};var j=function(){if(w!==b){return}w=setTimeout(K,N);K()};var K=function(){if(w!==b){clearTimeout(w);w=b}var e=false;var U=L();if(C!==U){C=U;e=true;f()}return e};var J=function(){n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio();L()};this.triggerEvent=function(V){var e=k.getEventListenerByID(V);if(!e){return}J();var U=O();k.fireEvent(e,U)};this.triggerEvents=function(){J();f()};var f=this.fireEvents=function(){var U=O();var V=k.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(!e.fireTresholdEventOnly){k.fireEvent(e,U)}}A()};var O=function(){var e={};e.FSI_scale=a.utils.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=i;e.FSI_scroll=t;e.FSI_client_rect_body_top=T;e.FSI_viewport_size_top=B;return e};this.getVisibleRect=function(){L();return H};this.getScrollRect=function(){return T};var R=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);var e=window.visualViewport;H.setRect(e.pageLeft,e.pageTop,e.pageLeft+e.width,e.pageTop+e.height);if(p){t.left=-window.pageXOffset;t.top=-window.pageYOffset}else{t.left=T.left;t.top=T.top}i.left=e.offsetLeft;i.top=e.offsetTop;i.right=i.left+e.width;i.bottom=i.top+e.height;return e.scale+"_"+e.offsetLeft+","+e.offsetTop+","+e.width+","+e.height+" "+B.width+" x "+B.height+" "+e.pageTop+"x"+e.pageLeft};var x=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);h.left=a.utils.getTopWindow().pageXOffset;h.top=a.utils.getTopWindow().pageYOffset;h.right=h.left+B.width;h.bottom=h.top+B.height;if(p){var e=a.getViewportSize(window);var U=a.getWindowOffset(window);i.left=0;i.top=0;i.right=i.left+e.width;i.bottom=i.top+e.height;t.left=-window.pageXOffset;t.top=-window.pageYOffset;l.copyRect(i);l.left=-U.x+h.left+T.left;l.top=-U.y+h.top+T.top;l.right=l.left+B.width;l.bottom=l.top+B.height;i.interSectRectValidate(l);var V=a.getBoundingClientRect(window.document.body);H.copyRect(i);H.offsetRect(U.x+V.left,U.y+V.top)}else{t.left=T.left;t.top=T.top;H.copyRect(h);i.copyRect(h);i.offsetRect(T.left,T.top)}return n+"_"+H.toString()+" "+B.width+" x "+B.height};var L=(G)?R:x;var Q=function(){y=q;if(o!==b){return}o=setInterval(v,100)};var v=function(){if(!K()){y--}else{y=q}if(y<1){clearInterval(o);o=b}};var r=function(){if(E!==b){clearInterval(E);E=b;u=b}};var A=function(){r();if(s>0){E=setInterval(D,c)}};var D=function(){var W,e;S+=c;if(u===b){S=c;u=[];var V=k.getListenersArray();for(W=0;W<V.length;W++){e=V[W];if(e.tresholdEnd>0){u.push(e)}}}var U;for(W=u.length-1;W>-1;W--){e=u[W];if(e.tresholdEnd<=S){if(k.getEventListenerByID(e.uniqueID)!==b){if(U===b){U=O();U.FSI_after_treshold=true}k.fireEvent(e,U)}u.splice(W,1)}}if(u.length===0){r()}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.AboutWindow!==b){return}a.AboutWindow=function(d,k){var m=this;var e;var g;var h;var f;var i;var l=function(){e=document.createElement("div");a.utils.setStyleAttr(e,"position: absolute;z-index:1000;width:12em;");e.className="fsi-ui-info-window";h=document.createElement("div");h.className="fsi-ui-title";f=document.createElement("div");f.style.display="inline-block";f.innerHTML=k.title;h.appendChild(f);i=document.createElement("div");i.style.display="inline-block";i.style["float"]="right";i.style.cursor="pointer";i.innerHTML="X";h.appendChild(i);e.appendChild(h);g=document.createElement("div");g.className="fsi-ui-content";var o=k.strLongVersion;o="<h3>"+o.replace(/ build/,'</h3><span class="small">build')+"</span>";var n;if(k.strCopyright===b){n="<br/><br/>&copy; 2019 NeptuneLabs GmbH<br/>";n+='<hr/><a style="color:inherit;text-decoration:none" href="//www.neptunelabs.com/" target="_blank">www.neptunelabs.com</a><br/><br/><span class="small">FSI Viewer &reg; is a registered trademark of NeptuneLabs GmbH, Germany<br/></span>'}else{k.strCopy=k.strCopyright}o+="<br/>"+n;g.innerHTML=o;e.appendChild(g);d.appendChild(e);a.addEvent(e,"click",j);c()};var c=function(){var o=a.getElementPosition(d);o.width=(o.right-o.left);o.height=(o.bottom-o.top);var n=a.getElementPosition(e);n.width=(n.right-n.left);n.height=(n.bottom-n.top);e.style.left=Math.round((o.width-n.width)/2)+"px";e.style.top=Math.round((o.height-n.height)/2)+"px"};var j=this.destroy=function(){if(typeof(k.fnOnDestroy)=="function"){if(!k.fnOnDestroy.call(this)){return}}a.removeEvent(e,"click",j);a.removeChild(e.parentNode,e)};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.MenuBar!==b){return}a.MenuBar=function(k,s,A,J,r){var i=this;var M=this.myViewer=k.iViewer;var B=k.getElementSpace();var h;var x;var u=0;var D=[];var m=b;if(r===b){r={}}this.bEnabled=b;var C={};var n={};var L={};var g=0;var j=0;var z="fsi-ui-button-icon";var q;var E;var o=1;var y=[];var d;var v,K;var p=this.setInterface=function(){v=k.getDebug();K=k.getToolTip()};var G=function(){i.oInterface=k;var N=k.iConfig;E=N.makeBool(N.cfg.menubuttontooltips,true,true);p(k);i.btnID=0;i.sprite=new a.Sprite(A,B.width,g,450,b,b,"fsi-ui-menu-bar");i.sprite.element.style.width="100%";i.sprite.element.style.top="auto";i.sprite.element.style.left="0px";i.sprite.element.style.right="auto";i.sprite.element.style.lineHeight="100%";i.sprite.element.style.bottom="0px";i.sprite.element.style.visibility="hidden";i.iconClassNamesNormal=z;m=setTimeout(f,0)};this.getContainer=function(){return A};this.getSprite=function(){return i.sprite.element};this.groupButtons=function(N){var Q;var O=[];for(Q=0;Q<N.length;Q++){var P=i.getButtonByCMD(N[Q]);if(P&&P.elButton){O.push(P.elButton)}}if(O.length>0){var S=document.createElement("span");S.className="fsi-ui-button-group-container";var R=O[0].parentNode;R.replaceChild(S,O[0]);for(Q=0;Q<N.length;Q++){S.appendChild(O[Q])}y.push(S)}};var f=function(){if(i.sprite.element.offsetHeight!==0||u++>200){m=b;l()}else{m=setTimeout(f,25)}};this.getButtonContainerWidth=function(){return x.element.offsetWidth};this.addButtonCSSClass=function(N,O){F(N,O,true)};this.removeButtonCSSClass=function(N,O){F(N,O,false)};var F=function(P,Q,O){var N=n[P];if(N===b){return}if(O){a.addClass(N.elButton,Q)}else{a.removeClass(N.elButton,Q)}i.setExternalButtonState(P,N.getState(),N.elButton.className)};this.getExternalButtonID=function(){return o++};var l=function(){var O=i.sprite.getClientDim();g=Math.round(O.height);i.sprite.setSize("100%",g);i.setEnabled(false);if(typeof(s.urlLogo)==="string"&&s.urlLogo.length>0&&s.urlLogo!=="none"){h=document.createElement("div");a.addClass(h,"fsi-ui-logo");a.utils.setStyleAttr(h,"position:absolute;display:none");var N=document.createElement("img");N.className="fsi-ui-logo-image";N.style.backgroundImage="none";N.src=s.urlLogo;h.appendChild(N);a.addEvent(N,"load",w);i.sprite.element.appendChild(h);a.addEvent(h,"click",M.showAboutWindow)}a.addEvent(i.sprite.element,"mouseup",e);a.addEvent(i.sprite.element,"contextmenu",H);i.sprite.element.style.visibility="";J()};this.show=function(N){if(d===N){return}d=N;i.sprite.show(N,false)};this.getVisible=function(){return d};this.destroy=function(){t("onMenuDestroy");if(m!==b){clearTimeout(m);m=b}if(h){a.removeEvent(h,"click",M.showAboutWindow)}a.removeEvent(i.sprite.element,"mouseup",e);a.removeEvent(i.sprite.element,"contextmenu",H);i.removeButtons();i.removeDomElement()};this.removeDomElement=function(){if(i.sprite.element.parentNode){a.removeChild(i.sprite.element.parentNode,i.sprite.element);g=0}};var e=function(N){if(N.which&&N.which===3){j=new Date().getTime()}};var H=function(O){if(j){var N=new Date().getTime()-j;if(N<300){return}}O.preventDefault&&O.preventDefault()};this.getHeight=function(){return g};this.pressButton=function(O){var N=n[O];if(N!==b){N.onMouseDown()}};this.releaseButton=function(O){var N=n[O];if(N!==b){N.onMouseUp()}};var c=function(N,P){var Q=b;if(!N||!P){return Q}if(N.indexOf("_")!==-1){var O=N.split("_");switch(O[0]){case"MouseMode":Q="";if(P.Mode){Q+="<b>"+P.Mode+"</b>"}if(P["Mode"+O[1]]){Q+=" "+P["Mode"+O[1]]}break}}return Q};this.showButtonToolTip=function(O,P){var N;if(P){N=P.getAttribute("fsi-tool-tip");if(k.iConfig.makeBool(N,true)===false){return}}if(!N){N=O.getCMD()}if(typeof(r[N])==="string"){N=r[N]}i.showToolTip(N,P)};this.getButtonDomElement=function(O){var N=n[O];if(N){return N.elButton}};this.showToolTip=function(P,O,N,Q){if(!K||!E){return}K.show(P,O,N,Q,c)};this.hideToolTip=function(){if(!K||!E){return}K.hide()};this.setEnabled=function(N,O){if(i.bEnabled===N){return}i.bEnabled=N;if(O){return}if(N){a.removeClass(i.sprite.element,"fsi-ui-menu-bar-disabled")}else{a.addClass(i.sprite.element,"fsi-ui-menu-bar-disabled")}t("onMenuEnabled",[N])};this.getButtonEnabled=function(O){var N=n[O];if(N===b){return}return N.bEnabled};this.showButton=function(P,N){var O=n[P];if(O===b){return false}return O.show(N)};this.enableButton=function(P,N){var O=n[P];if(O===b){return false}return O.setEnabled(N)};this.getButtonPressed=function(O){var N=n[O];if(N===b){return false}return N.getPressed()};this.setButtonPressed=function(P,N){var O=n[P];if(O===b){return false}O.setPressed(N);return true};var I=function(O,P){var N;if(C[P]===b){N=C[P]={};N.arButtons=[]}else{N=C[P]}N.arButtons.push(O);O.oGroup=N;O.makeRadioButton()};this.removeButtons=function(){var N;i.unregisterExternalButtons();for(N=0;N<D.length;N++){D[N].destroy()}for(N=0;N<y.length;N++){if(y[N]&&y[N].parentNode){y[N].parentNode.removeChild(y[N])}}D=[];C={};n={}};this.unregisterExternalButtons=function(){for(var P in L){if(L.hasOwnProperty(P)){var N=L[P];for(var O=0;O<N.length;O++){N[O].destroy(true)}}}L={}};this.addButtons=function(Y,ac){i.removeButtons();var Q;var Z=g-6;var S,ad;var R,aa,T;var O="";if(typeof(ac)==="string"&&ac.length>0){O=" (sorted by parameter MenuButtonOrder)";var N=ac.split(",");var W={};for(aa=0;aa<Y.length;aa++){if(typeof(Y[aa].cmd)==="string"){W[Y[aa].cmd.toLowerCase()]=aa}}var V=[];var ab={};for(aa=0;aa<N.length;aa++){T=a.trim(N[aa].toLowerCase());if(W[T]!==b){if(ab[T]===b){ab[T]=true;V.push(Y[W[T]])}}}for(aa=0;aa<Y.length;aa++){if(typeof(Y[aa].cmd)==="string"){T=Y[aa].cmd.toLowerCase();if(!ab[T]){V.push(Y[aa])}}}Y=V}else{O=" (default)"}if(!x){x=new a.Sprite(i.sprite.element,B.width,g,2);a.utils.setStyleAttr(x.element,"position:relative");a.addClass(x.element,"fsi-ui-button-container")}var ae;if(v.on){ae=[]}for(aa=0;aa<Y.length;aa++){Q=Y[aa];if(Q.cmd){if(v.on){ae.push(Q.cmd)}if(Q.width===b){S=Z}else{S=Q.width}if(Q.height===b){ad=Z}else{ad=Q.height}R=new a.MenuBarButton(i,x.element,Q,Q.bCheckButton);n[Q.cmd]=R;D.push(R);if(Q.groupID!==b){I(R,Q.groupID)}}if(typeof(Q.fnCreate)==="function"){Q.fnCreate.apply(Q.fnCreateInstance,[R,Q])}if(Q.enabled===false){i.enableButton(Q.cmd,false)}}if(v.on){v.log("Button sequence"+O+": "+ae.join(","))}w();var P=q.run("onRegisterExternalMenuButtons");if(P){i.registerExternalButtonsFromContainer(P)}var U=k.iConfig;if(typeof(U.cfg.externalbuttoncontainer)!=="undefined"){i.registerExternalButtonsFromContainer(U.cfg.externalbuttoncontainer)}t("onMenuReady",[i]);for(var X in C){if(C.hasOwnProperty(X)){C[X].arButtons[0].setPressed(true)}}};this.createHiddenButton=function(O,Q){if(n[O]!==b){return n[O]}var N={cmd:O,bCheckButton:Q};var P=new a.MenuBarButton(i,b,N,N.bCheckButton);P.bUserButton=true;n[N.cmd]=P;D.push(P);return P};this.setCallbacks=function(N){q=N};var t=this.callListeners=function(O,N){if(q){q.run(O,N)}};this.setContainerSize=function(N){var O=i.sprite.element.style.display;i.sprite.element.style.display="block";var P=a.getElementClientDim(i.sprite.element);g=P.height;if(P.width===0&&P.height===0){return}i.sprite.updateDimension();B=N;i.sprite.setSize("100%",g);i.sprite.element.style.display=O;w();if(d){i.sprite.show(true)}};var w=function(){if(!h){return}h.style.display="";if(h.firstChild!==b&&h.firstChild.offsetWidth>0&&x!==b){var N=(i.sprite.element.offsetWidth-x.element.offsetWidth)/2;if(N-8<h.firstChild.offsetWidth){h.style.display="none"}}};this.setPressedExternalButtons=function(Q,O){if(L[Q]!==b){var N=L[Q];for(var P=0;P<N.length;P++){N[P].setPressed(O)}}};this.enableExternalButtons=function(Q,O){if(L[Q]!==b){var N=L[Q];for(var P=0;P<N.length;P++){N[P].setEnabled(O)}}};this.setExternalButtonState=function(Q,P,R){if(L[Q]!==b){var N=L[Q];for(var O=0;O<N.length;O++){N[O].setState(P,R)}}};this.removeExternalButton=function(P,Q){var N=L[P];if(N!==b){for(var O=0;O<N.length;O++){if(N[O].nExternalButtonID===Q){N.splice(O,1)}}}};M.getMenuButtonPresent=function(O){var N=i.getButtonByCMD(O);return(N!==b&&N.bUserButton!==true)};M.registerExternalMenuButtonsFromContainer=this.registerExternalButtonsFromContainer=function(S){if(typeof(S)==="string"){S=document.getElementById(S)}v.groupCollapsed("Registering external buttons from container: ");v.log(S);if(S&&typeof(S.querySelectorAll)==="function"){var Q=S.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var O=0;O<Q.length;O++){var P=Q[O];var R=P.getAttribute("fsi-cmd");var N=P.getAttribute("fsi-tool-tip");if((R&&R.length>0)||N&&N.length>0){i.registerExternalButton(Q[O],R)}}}v.groupEnd()};M.unregisterExternalMenuButtonsFromContainer=this.unregisterExternalButtonsFromContainer=function(S){if(typeof(S)==="string"){S=document.getElementById(S)}v.groupCollapsed("Unregistering external buttons from container: ");v.log(S);if(S&&typeof(S.querySelectorAll)==="function"){var Q=S.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var O=0;O<Q.length;O++){var P=Q[O];var R=P.getAttribute("fsi-cmd");var N=P.getAttribute("fsi-tool-tip");if((R&&R.length>0)||N&&N.length>0){i.unregisterExternalButton(Q[O],R)}}}v.groupEnd()};M.registerExternalMenuButton=this.registerExternalButton=function(N,Q){var O=Q;if(typeof(O)!=="string"||O.length<1){O="user_tool_tip_only"}if(typeof(N)==="string"){N=document.getElementById(N)}if(!N||N.style===b){return false}if(N.FSIExternalButton!==b){if(v.on){v.error("The dom element has already been registered as external button for command '"+N.FSIExternalButton.getCMD()+"'.")}return false}var P=new a.MenuBarExternalButton(i,k,N,O);if(!P.init()){v.error("The dom element could not be registered as external button for command '"+O+"'.",N);P.destroy();return false}if(P.bUserButton){v.log("Registering external button for user command: "+O,N)}else{v.log("Registering external button for command: "+O,N)}N.FSIExternalButton=P;if(L[O]===b){L[O]=[]}L[O].push(P);if(q.isset("onAfterRegisterExternalButton")){q.run("onAfterRegisterExternalButton",[N,Q,(P.bUserButton!==true)])}};M.unregisterExternalMenuButton=this.unregisterExternalButton=function(O){if(typeof(O)==="string"){O=document.getElementById(O)}if(!O||O.style===b||typeof(O.FSIExternalButton)!=="object"||typeof(O.FSIExternalButton.destroy)!=="function"){return false}var N=O.FSIExternalButton;if(v.on){v.log("Unregistering external button for command: "+N.getCMD(),O)}O.FSIExternalButton.destroy();O.FSIExternalButton=b;return true};this.getButtonByCMD=function(N){return n[N]};G()};a.MenuBarExternalButton=function(i,e,c,g){var k=this;var h=i;var f="";var j;var d;this.init=function(){if(c.style===b){return false}k.nExternalButtonID=i.getExternalButtonID();d=i.getButtonByCMD(g);if(d===b){d=h.createHiddenButton(g,e.iConfig.makeBool(c.getAttribute("fsi-check-button")))}if(d===b){return false}k.bUserButton=d.bUserButton;f=a.trim(c.className);if(f.length>0){f+=" "}d.addEvents(c);k.setState(d.getState(),d.getCSSClass());k.setEnabled(d.getEnabled());k.setPressed(d.getIsPressed());c.setAttribute("data-fsi-registered","true");return true};this.getCMD=function(){return g};this.setPressed=function(l){if(l){c.setAttribute("checked","checked")}else{c.removeAttribute("checked")}};this.setEnabled=function(l){if(l){c.removeAttribute("disabled");a.removeClass(c,"fsi-ui-button-disabled")}else{c.setAttribute("disabled","disabled");a.addClass(c,"fsi-ui-button-disabled")}};this.setState=function(l,m){j=l;c.className=f+m};this.destroy=function(l){if(c.FSIExternalButton){d.removeEvents(c);c.FSIExternalButton=b;c.removeAttribute("data-fsi-registered");if(d){c.className=a.trim(f)}if(!l){h.removeExternalButton(g,k.nExternalButtonID)}}}};a.MenuBarButton=function(u,f,i,h){var q=this;var v=i.cmd;var k=u;var C;this.bEnabled=true;this.id=k.btnID++;var m=false;var B;var c;var l="";var e=true;var d;var y;var x="";var A,r;var g;var j={passive:false,capture:false};var w=function(){B=q.elButton=document.createElement("div");a.addClass(B,"fsi-ui-button");c=document.createElement("div");a.addClass(c,k.iconClassNamesNormal);B.appendChild(c);if(f){f.appendChild(B)}if(v.length>0){l=v.replace(/#.*$/,"")}else{l=""}if(i.cssClass){if(l.length>0){l+=" "}l+=i.cssClass}B.className="fsi-ui-button "+l;if(!i.bNoMouseEvents){q.addEvents(B)}s(1)};var t=function(D){D.cancelBubble=true;if(D.stopPropagation){D.stopPropagation()}if(D.preventDefault){D.preventDefault()}return false};this.addEvents=function(D){a.addEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.addEvent(D,"mousedown",q.onMouseDown,j);a.addEvent(D,"mouseleave",q.onMouseOut,j);a.addEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.addEvent(D,"touchstart",q.onTouchDown,j);a.addEvent(D,"touchcancel",q.onTouchUp,j);a.addEvent(D,"touchend",q.onTouchUp,j)}};this.removeEvents=function(D){a.removeEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.removeEvent(D,"mousedown",q.onMouseDown,j);a.removeEvent(D,"mouseleave",q.onMouseOut,j);a.removeEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.removeEvent(D,"touchstart",q.onTouchDown,j);a.removeEvent(D,"touchcancel",q.onTouchUp,j);a.removeEvent(D,"touchend",q.onTouchUp,j)}};this.destroy=function(){if(!i.bNoMouseEvents){q.removeEvents(B)}if(B&&B.parentNode){a.removeChild(B.parentNode,B)}};this.getCMD=function(){return v};this.makeCheckButton=function(){h=true};this.makeRadioButton=function(){h=true;m=true};this.getState=function(){return C};this.getCSSClass=function(){return B.className};var s=this.setState=function(E){if(C===E){return}if(h){var D=(E>2);if(D!==y){y=D;z("onMenuButtonSetPressed",null,D)}}o(E)};var o=this.setState=function(F){if(F===C){return}C=F;var G="";if(!q.bEnabled){G="fsi-ui-button-disabled "}switch(C){case 2:G+="fsi-ui-button-hover";break;case 3:G+="fsi-ui-button-active";break;case 4:G+="fsi-ui-button-active";if(q.oGroup!==b){for(var E=0;E<q.oGroup.arButtons.length;E++){var D=q.oGroup.arButtons[E];if(D.id!==q.id){D.setPressed(false)}}}break;default:break}if(G!==x){if(x.length>0){a.removeClass(B,x)}if(G.length>0){a.addClass(B,G)}x=G}k.setExternalButtonState(v,C,B.className)};this.onMouseOver=function(D){A=true;var E=D.target;if(a.hasClass(E,"fsi-ui-button-icon")&&E.parentNode){E=E.parentNode}k.showButtonToolTip(q,E);if(!q.bEnabled||!k.bEnabled){return}if(C===1){s(2)}};this.onMouseOut=function(){A=false;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}if(r){return}if(C!==1&&C!==4){s(1)}};this.onMouseDown=function(D){z("onMenuButtonMouseDown",D);if(D&&D.type==="mousedown"){if(D.preventDefault){D.preventDefault()}if(D.which!==1){return true}}r=true;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}a.addEvent(window,"mouseup",q.onMouseUp);g=true;if(h){if(C===4){if(!m){s(3)}}else{s(4)}}else{s(3)}p(D)};this.show=function(D){if(e===D){return}e=D;q.elButton.style.display=(D)?"":"none"};this.onTouchDown=function(D){if(A){q.onMouseOut(D)}if(r){q.onMouseUp(D)}q.onMouseDown(D)};this.onTouchUp=function(D){if(A){k.hideToolTip();A=false}q.onMouseUp(D);if(D.preventDefault){D.preventDefault()}};this.onMouseUp=function(E){if(g){a.removeEvent(window,"mouseup",q.onMouseUp);g=false}var F=(E&&E.type==="touchend");if(!F&&!r){return}r=false;if(!q.bEnabled||!k.bEnabled){return}if(!F&&!A&&h&&!m){if(C===4){s(1)}else{s(4)}}var D=(!A)?1:2;if(h){if(C===3){s(D)}}else{s(D)}n(E);if(F||A){u.oInterface.clickMenuButton(v,E);z("onMenuButtonClicked",E)}};this.getEnabled=function(){return q.bEnabled};this.setEnabled=function(D){if(q.bEnabled===D){return}if(!D&&d){n()}if(!D&&(C===1||!h)){q.setState(1)}if(D){a.removeClass(B,"fsi-ui-button-disabled")}else{a.addClass(B,"fsi-ui-button-disabled")}q.bEnabled=D;k.enableExternalButtons(v,D);z("onMenuButtonEnabled",null,D);return true};this.getPressed=function(){return(C>2)};this.getIsPressed=function(){return(h&&q.getPressed())};this.setPressed=function(D){if(!h){return}if(D){s(4)}else{s(1)}k.setPressedExternalButtons(v,D)};var p=function(D){d=true;z("onMenuButtonPressed",D);u.oInterface.pressMenuButton(v,D)};var n=function(D){d=false;z("onMenuButtonReleased",D);u.oInterface.releaseMenuButton(v,D)};var z=function(F,D){var E=[v,D];if(arguments.length>2){E=E.concat(Array.prototype.slice.call(arguments,2))}k.callListeners(F,E)};w()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.FlipEffect!==b){return}a.FlipEffect=function(ab,ax,aH,f){var aw=this;if(typeof(f)!="object"){f={}}var ay=false;var C;var s;var aC={};var U={};var D={};var J={};var t={};var aB,R;var aI,am,aE;var al,q;var Z,aj;var aG,H;var W;var L;var Q=(a.isInternetExplorer);var O;var A;var g,aA;var w,m;var i;var ae,ac;var G,F;var n={};var d={};var at;var K={};var y;var aK=false;var u;var k,T,ar;var aa,v;var ag=Math.PI;var az=false;var e={};var aJ;var N=(!a.isInternetExplorer||a.versionInternetExplorer>11);var af=(a.isInternetExplorer&&a.versionInternetExplorer<12);var au=a.Easing.easeInOutQuad;var ao;var aD={x:0,y:0,offsetX:0,offsetY:0};var M=new a.CSSTransformMatrix();var av="-webkit-perspective: 10000;perspective: 10000;will-change:transform;";var o=false;var E,h;var ap=0;aw.bReverse=false;var ah=function(){if(ay){return}ay=true;E=f.bDoublePages;h=(E)?2:1;an();if(f.svgTemplate){aa=f.svgTemplate;aa.setAttribute("style","position:absolute;left:0px;top:0px;")}W.style.display="none";if(af){a.addEvent(window,"scroll",ai)}};var ai=function(){var aM=window.scrollY||window.pageYOffset||document.body.scrollTop;aw.elFlipTop.style.marginTop=(-aM)+"px"};this.destroy=function(){if(!ay){return}aw.cancel();if(W&&W.parentNode){a.removeChild(W.parentNode,W)}ay=false;if(af){a.removeEvent(window,"scroll",ai)}};this.getContainerElement=function(){return W};this.setPreliminary=function(aM){o=aM};this.cancel=function(){if(!az){return false}if(y!==b){cancelAnimationFrame(y);y=b}p();aK=az=false;return true};this.appendTo=function(aM){O=aM;aM.appendChild(W)};this.setContentByString=function(aN,aM){al.innerHTML=aN;q.innerHTML=aM};this.setContent=function(aM,aP,aN,aO){aw.removeContent();if(aM){al.appendChild(aM)}if(aP){q.appendChild(aP)}if(aN){aj.appendChild(aN)}if(aO){H.appendChild(aO)}if(af){ai()}};this.setPageSize=function(aN,aO){if(G===aN&&F===aO){return false}G=aN;F=aO;aw.cancel();i=b;C=aN;s=aO;aI.style.width=al.style.width=C+"px";aI.style.height=al.style.height=s+"px";am.style.width=q.style.width=C+"px";am.style.height=q.style.height=s+"px";aE.style.width=C+"px";aE.style.height=s+"px";m=Math.sqrt(C*C+s*s);W.style.width=2*C+"px";var aP=m-s;var aM=s+2*aP;W.style.height=aM+"px";aD.offsetY=-aP;aE.style.top=aP+"px";K.y=aP;L.style.width=C+"px";L.style.height=s+"px";Z.style.width=aG.style.width=al.style.width=q.style.width=aN+"px";Z.style.height=aG.style.height=al.style.height=q.style.height=aO+"px";aL();I();return true};this.removeContent=function(){j(al);j(q);j(aj);j(H)};var j=function(aM){while(aM.firstChild){aM.removeChild(aM.firstChild)}};var an=function(){var aO;var aN="overflow:hidden;";var aM="position:absolute;left:0px;top:0px;font-size:0px;";W=ak(aM+aN);W.className="fsi-pages-flip-effect";if(f.bFixEdgeTransformFlicker){W.style.transform="rotate(0.001deg)"}aE=ak(aM,W);aG=ak(aM+aN,aE);aw.elBottomStaticContent=H=ak("position:relative",aG);Z=ak(aM+aN,aE);aw.elTopStaticContent=aj=ak("position:relative",Z);L=ak(aM+aN+av+"z-index:1;",aE);A=ak(aM+aN+av+"z-index:2;",aE);if(Q){aO="position:fixed;transform:rotate(0deg);overflow:hidden;"}else{aO=aM+aN+av}aw.elFlipTop=aI=ak(aO,A);aw.elFlipTopContent=al=ak("position:relative",aI);aw.elFlipBottom=am=ak(aM+aN+av,A);aw.elFlipBottomContent=q=ak("position:relative;",am);ad(am,"0px 0px")};var ak=function(aO,aM){var aN=document.createElement("div");aN.setAttribute("style",aO);if(aM){aM.appendChild(aN)}return aN};var z=function(){if(v){return}v=true;k=P(aa,"fsi_pages_gradient_flip_top");aI.appendChild(k);k.style.zIndex=2;T=P(aa,"fsi_pages_gradient_flip_back");T.style.zIndex=2;am.appendChild(T);ar=P(aa,"fsi_pages_gradient_flip_shadow");L.appendChild(ar);aL()};var aL=function(){if(!k){return}aJ=m+C;k.style.width=C+"px";k.style.height=aJ+"px";k.style.left=k.style.top="0px";T.style.width=C+"px";T.style.height=m+"px";ar.style.height=m+C+"px";T.style.left=k.style.top="0px"};var P=function(aP,aN){var aQ=false;var aM=aP.cloneNode(true);var aO=aM.getElementsByTagName("rect")[0];if(!aO){aQ=true;W.appendChild(aM);aO=aM.getElementsByTagName("rect")[0]}aO.removeAttribute("id");aM.removeAttribute("id");aO.setAttribute("fill","url(#"+aN+")");aM.setAttribute("style",aM.getAttribute("style")+av);if(aQ){W.removeChild(aM)}return aM};this.setPosition=function(aM,aN){if(aD.x!==aM||aD.y!==aN){aD.x=aM;aD.y=aN;I()}};var I=function(aN){var aM=(aD.x+aD.offsetX);if(aN!==b){aM+=aN}W.style.left=aM+"px";W.style.top=(aD.y+aD.offsetY)+"px"};var ad=function(aM,aN){aM.style.transformOrigin=aM.style.webkitTransformOrigin=aN+" 0px"};var Y=function(aM){if(E){return aM}if(aM<2){aM+=2;aw.bReverse=true;A.style.opacity=""}else{aw.bReverse=false}return aM};var x=function(aN){aN=Y(aN);if(i===aN){return}i=aN;w=C;d.x=n.x=0;d.ofsAngle=0;switch(aN){case 0:U.x=0;U.y=0;d.x=n.x=C;ae=-C;ac=0;n.y=0;d.y=s;K.x=0;d.ofsAngle=ag;u=true;ad(ar,"0px 0px");ad(k,"0px 0px");d.nShadowRotateOffsetX=0;d.nShadowRotateOffsetY=0;d.nShadowTranslateX=-C;d.nShadowTranslateY=-aJ;d.nShadowTranslateDir=-1;ad(T,"100% 0px");d.nBackShadowOffsetX=0;d.nBackShadowOffsetY=0;d.nBackShadowTranslateY=m;break;case 1:U.x=0;U.y=s;d.x=n.x=C;ae=-C;ac=-s;n.y=s;d.y=0;K.x=0;d.ofsAngle=ag;u=true;ad(ar,"0px 100%");ad(k,"0px 100%");d.nShadowRotateOffsetX=0;d.nShadowRotateOffsetY=-aJ+s;d.nShadowTranslateX=-C;d.nShadowTranslateY=aJ;d.nShadowTranslateDir=1;ad(T,"100% 100%");d.nBackShadowOffsetX=0;d.nBackShadowOffsetY=-m+s;d.nBackShadowTranslateY=-m;break;case 2:U.x=C;U.y=0;ae=0;ac=0;n.y=0;d.y=s;K.x=C;u=false;ad(ar,"100% 0px");ad(k,"100% 0px");d.nShadowRotateOffsetX=0;d.nShadowRotateOffsetY=0;d.nShadowTranslateX=0;d.nShadowTranslateY=0;d.nShadowTranslateDir=1;ad(T,"0px 0px");d.nBackShadowOffsetX=0;d.nBackShadowOffsetY=0;d.nBackShadowTranslateY=0;break;case 3:U.x=C;U.y=s;ae=0;ac=-s;n.y=s;d.y=0;K.x=C;u=false;ad(ar,"100% 100%");ad(k,"100% 100%");d.nShadowRotateOffsetX=0;d.nShadowRotateOffsetY=-aJ+s;d.nShadowTranslateX=0;d.nShadowTranslateY=0;d.nShadowTranslateDir=-1;ad(T,"0px 100%");d.nBackShadowOffsetX=0;d.nBackShadowOffsetY=s-m;d.nBackShadowTranslateY=0;break}g=aA=2*m;A.style.width=g+"px";A.style.height=aA+"px";aE.style.left=K.x+"px";if(u){Z.style.left=C+"px"}else{Z.style.left=-C+"px"}var aM=g+"px "+aA/2+"px";ad(A,aM);ad(aI,aM);if(!E){if(i>1){ap=-C}else{ap=0}I(ap)}};this.flip=function(aN,aP,aO){aw.bFlipFinishing=false;aw.bPointerFlip=false;if(!aP){aP=40}if(a.isMobileDevice){aP=Math.ceil(aP/1.5)}au=a.Easing.easeInOutQuad;aw.cancel();r();x(aN);at=B();at.angleRange=ag;at.angleStart=0;at.pos=1;at.frames=aP;if(aw.bReverse){at.startX+=at.distX;at.distX=-at.distX;at.angleRange=-at.angleRange}aC.x=at.startX;aC.y=at.startY;aC.offset=0;var aM=Math.random()/3-0.25;if(aO){aM=-0.05}if(u){aM=-aM}at.radius=(aM)*w;if(i%2!==0){at.radius=-at.radius}aK=true;aq()};var r=function(){az=true;W.style.display="";if(!v){z()}};var l=function(aM){aC.clientX=aM.clientX;aC.clientY=aM.clientY};var c=function(aM){aC.clientX=aM.touches[0].clientX;aC.clientY=aM.touches[0].clientY};this.handlePointerDown=function(aN,aQ){aw.bFlipFinishing=false;if(aN.touches){ao=c}else{ao=l}if(!aQ){ao(aN)}else{aC.clientX=aQ.x;aC.clientY=aQ.y}au=a.Easing.easeOutQuad;if(y!==b){cancelAnimationFrame(y);y=b}aK=false;r();var aO=a.getBoundingClientRect(W);var aM=ap;aC.x=aC.clientX-aO.left+ap;aC.y=aC.clientY-aO.top-K.y;var aP=0;if(aC.x>C/2){aP+=2}if(aC.y>s/2){aP++}x(aP);aC.fsiOffsetLeft=aO.left+K.x+ap-aM;aC.fsiOffsetTop=aO.top+K.y;if(aw.bReverse){aC.fsiOffsetLeft+=Math.round(0.95*C)}aC.x=aC.clientX-aC.fsiOffsetLeft;aC.y=aC.clientY-aC.fsiOffsetTop;aC.offset=aC.y-n.y+1;if(Math.abs(aC.offset)<50){aC.offset=0}aN.preventDefault();X();return true};this.getFlipCorner=function(){return i};this.handlePointerMove=function(aM,aN){if(!aN){ao(aM)}else{aC.clientX=aN.x;aC.clientY=aN.y}aC.x=aC.clientX-aC.fsiOffsetLeft;aC.y=aC.clientY-aC.fsiOffsetTop;if(y===b){y=requestAnimationFrame(V)}return true};this.handlePointerUp=function(){aw.bPointerFlip=true;aF()};var V=function(){if(!az){return}y=b;X()};var B=function(){var aM={};aM.x=(u)?2*C:-C;aM.startX=(u)?0:C;aM.y=aM.startY=U.y;aM.distX=aM.x-aM.startX;aM.distY=aM.y-aM.startY;return aM};var aF=function(){if(!az){return}var aM=aC.x;if(aw.bReverse){aM+=C}aC.offset=0;var aN=false;at=B();if(o){aN=!aw.bReverse}else{if(u){if(aM+C/2<C){aN=true;at.x=0}}else{if(aM>C/2){aN=true;at.x=C}}}if(aN){at.x=U.x}at.angleStart=at.angleRange=ag/2;at.radius=D.y-at.startY;var aO=D.y-at.startY;if(i%2!==0){aO=-aO}if(aN&&aO<0){at.angleRange=ag+ag/2}at.startX=D.x;at.distX=at.x-at.startX;at.distY=at.y-at.startY;at.pos=1;at.frames=(a.isMobileDevice)?20:32;aK=true;aq();if(aw.bReverse){aN=!aN}aw.bFlipAborted=aN;aw.bFlipFinishing=!aN};var aq=function(){aC.x=au(at.pos,at.frames,at.startX,at.distX);if(at.radius!==b){var aM=at.angleStart+(aC.x-at.startX)/Math.abs(at.distX)*at.angleRange;aC.y=at.startY+at.radius*Math.sin(aM)}else{aC.y=au(at.pos,at.frames,at.startY,at.distY)}if(at.pos===at.frames){y=b;aK=false;aC.x=at.x;aC.y=at.y;az=false;aw.bFlipFinishing=false;if(f.onFlipFinish){f.onFlipFinish.apply(aw,[aw.bPointerFlip,aw.bFlipAborted])}else{p()}return true}else{X();at.pos++;y=requestAnimationFrame(aq)}};var S=function(aM){for(var aN=0;aN<aM.length;aN++){var aO=aM[aN];if(aO){aO.style.webkitTransform=aO.style.transform=""}}};var p=this.resetTransform=function(){W.style.display="none";S([A,aI,am,k,ar,T])};var X=function(){var aU,aT,aX,a1,aS,aR;D.x=aC.x;D.y=aC.y-aC.offset;aU=Math.abs(D.x-n.x);aT=Math.abs(D.y-n.y);aX=Math.sqrt(aU*aU+aT*aT);if(aX>w){a1=Math.atan2(n.y-D.y,n.x-D.x);D.x=n.x-Math.cos(a1)*w;D.y=n.y-Math.sin(a1)*w}aU=Math.abs(D.x-d.x);aT=Math.abs(D.y-d.y);aX=Math.sqrt(aU*aU+aT*aT);if(aX>m){a1=Math.atan2(d.y-D.y,d.x-D.x);D.x=d.x-Math.cos(a1)*m;D.y=d.y-Math.sin(a1)*m}J.x=D.x+0.5*(U.x-D.x);J.y=D.y+0.5*(U.y-D.y);J.angle=Math.atan2(U.y-J.y,U.x-J.x);J.tangent=J.x-Math.tan(J.angle)*(U.y-J.y);if(J.tangent<0){J.tangent=0}t.bottomX=J.tangent;t.bottomY=U.y;J.bottomX=J.x;J.bottomY=t.bottomY;R=Math.atan2(t.bottomY-D.y,t.bottomX-D.x)-d.ofsAngle;aB=Math.atan2(t.bottomY-J.y,t.bottomX-J.x);if(aB===0){aB=ag/2}else{if(aB<0){aB+=ag}}aB-=ag/2-d.ofsAngle;var aZ=J.x-g;var aY=J.y-aA/2;M.init();M.rotate(aB);M.translate(aZ,aY);M.applyTo(A);M.init();if(N){aS=-aZ;aR=-aY;M.translate(aS,aR);M.rotate(-aB);M.applyTo(aI)}else{M.rotate(0.0001);M.applyTo(aI)}aS=-g+D.x;aR=-aA/2+D.y;M.init();if(ae||ac){M.translate(ae,ac)}M.rotate(R);M.translate(aS-aZ,aR-aY);M.rotate(-aB);M.translate(g,aA/2);M.applyTo(am);e.y=n.y;if(J.x===0){e.x=a0=0}else{var a3=-aB+ag;var a0=(n.y-J.y)/Math.cos(a3);e.x=J.x+Math.sin(a3)*a0}var a6,a5,aW,aV,a4;aU=J.x-D.x;aT=J.y-D.y;var aO=Math.sqrt(aU*aU+aT*aT);aU=2*C-Math.abs(U.x-D.x);aT=Math.abs(U.y-D.y);var aP=Math.sqrt(aU*aU+aT*aT);var aQ;if(J.y>0&&J.y<s){aU=J.x-e.x;aT=J.y-e.y;aQ=Math.sqrt(aU*aU+aT*aT)}else{aQ=0}aU=U.x-J.x;aT=U.y-J.y;var aM=Math.sqrt(aU*aU+aT*aT);a1=aB;aW=d.nShadowRotateOffsetX;aV=d.nShadowRotateOffsetY;a4=Math.abs((U.x-J.x)/C/2.7);a6=-aM+d.nShadowTranslateX;if(u){a6+=(C-a4*C)}a5=-a0+d.nShadowTranslateY-d.nShadowTranslateDir*Math.abs(a0);M.init();M.scale(a4,1);M.translate(a6,a5);M.rotate(a1);M.translate(aW,aV);M.applyTo(k);a4=aO/C;a6=-aM+d.nShadowTranslateX+C;if(!u){a6-=C-a4*C}M.init();M.scale(a4,1);M.translate(a6,a5);M.rotate(a1);M.translate(aW,aV);M.applyTo(ar);var aN=aP/(2*C);aN=Math.max(0,Math.min(1,aN));L.style.opacity=aN;if(!E&&!aw.bReverse){aN=aP/(C/4);aN=Math.max(0,Math.min(1,aN));A.style.opacity=aN}a4=aO/C;a6=0;a5=-d.nShadowTranslateDir*aQ-d.nBackShadowTranslateY;if(u){a6+=a4*C}aW=d.nBackShadowOffsetX;aV=d.nBackShadowOffsetY;a1=aB-R;M.init();M.scale(a4,1);M.translate(a6,a5);M.rotate(a1);M.translate(aW,aV);M.applyTo(T);var a2=10*aN;T.style.opacity=Math.max(0,Math.min(1,a2))};ah()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageInput!==b){return}a.PageInput=function(n,m,i){var o=this;var j;var t="";var s;var r;var e=true;var p=[];var q=function(){i.elButton.innerHTML="";j=document.createElement("input");j.setAttribute("type","text");i.elButton.appendChild(j);a.addEvent(j,"focus",f);a.addEvent(j,"blur",l);a.addEvent(j,"keydown",d);r=m.getMenu();k("onMenuButtonReleased",c);k("onMenuDestroy",g);k("onMenuReady",h)};this.destroy=function(){for(var u=0;u<p.length;u++){n.removeListener(p[u].event,p[u].fn)}if(!j){return}a.removeChild(j.parentNode,j)};var k=function(w,v){var u=n.addListener(w,v,o);if(u){p.push({event:w,fn:v})}};this.hide=function(){if(!e){return}e=false;i.elButton.style.display="none";if(r){r.showButton("PageInputEnter",false)}};this.show=function(){if(e){return}e=true;if(r){r.showButton("PageInputEnter",true)}i.elButton.style.display=""};var c=function(v){if(v==="PageInputEnter"&&j.value.length>0){var u=n.gotoPage(j.value,true);if(!u){j.focus()}}};var g=function(){r=b};var h=function(u){if(r){r=u;r.enableButton("PageInputEnter",false)}};var f=function(){a.addClass(i.elButton,"fsi-input-focussed");m.onUserAction();j.value="";s=true;if(r){r.enableButton("PageInputEnter",true)}};var l=function(){a.removeClass(i.elButton,"fsi-input-focussed");j.value=t;s=false;if(r){r.enableButton("PageInputEnter",false)}};this.blur=function(){if(s){j.blur()}};var d=function(u){m.onUserAction();switch(u.which){case 13:var v=n.gotoPage(j.value,true);if(v){j.blur()}break;case 27:j.blur();break}};this.onPageChange=function(v,u){t=v+" / "+u;if(!s){j.value=t}};q()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PrintImageList!==b){return}a.PrintImageList=function(n,f,k){var o=this;var h;var e;var g=a.mobileOS==="android";var m;var d,j;var l;this.destroy=function(){if(!h){return}c()};this.print=function(){if(!k){f.getDebug().error("PrintImageList: No print options");return}if(!k.imageList){f.getDebug().error("PrintImageList: Missing list of images");return}h=true;var x=("objectFit" in document.body.style);var p=function(){var z=[];for(var A=0;A<k.imageList.length;A++){z.push("<div>");z.push('<img alt="" src="'+k.imageList[A]+'" onload="ili()"/>');z.push("</div>")}return z.join("\r\n")};var u=function(z){if(z!==true){return"document.execCommand('print', false, null);"}else{return"window.focus();window.print();"}};var q=function(z){if(z){return"div {height:100%;page-break-after: always;}\nimg {width:100%;height:100%;object-fit: contain;}"}else{return"div{width: 100%;height: 100%;text-align: center;page-break-after: always;}\nimg {height: auto;width: 100%;}"}};var t=function(z){if(z!==true){return"<script>printMe();<\/script>"}};var w=["<!DOCTYPE>",'<html lang="en">',"<head><title>FSI Pages Print</title>","<meta charset=utf-8>",'<meta http-equiv="X-UA-Compatible" content="IE=edge">','<style type="text/css" media="print">',"@page{size:auto;margin: 0mm;}","html{background-color: #fff; margin: 0px;}","body{height: 100%;border: 0;margin: 0mm 0mm 0mm 0mm;}",q(x),"</style>",'<style type="text/css">',"div.divProgress{margin:20px;width:500px;position:fixed;top:0px;left:0px;z-index:1;background-color:white;border:2px solid black;padding:12px;font-family:sans-serif;font-size:18px;color:black;}","</style>",'<script type="text/javascript">',"iFSIImageListPrint = (document.iFSIImageListPrint)?document.iFSIImageListPrint:parent.$FSI.oPrintImageListInstances["+k.idInstance+"];","var maxImages="+k.imageList.length+";","var curImages=0;","function printMe(){iFSIImageListPrint.onBeforePrint();"+u(x)+"iFSIImageListPrint.printFinisher()}","function ili(){curImages++;iFSIImageListPrint.printUpdater(curImages,maxImages)}","<\/script>","</head>",'<body onload="printMe();">',p(k),t(x),"</body>","</html>"];var y=function(){o.printFinisher();c()};if(g){m=window.open();l=m.document;var v=['<div id="divProgress" class="divProgress">',"Please wait. Downloading print data...<br/>","Close this browser window to cancel printing.<br/>",'<progress max="100" id="printProgress" style="width:100%;height:18px;margin-top:20px;"></progress>',"</div>"];w=w.concat(v);a.addEvent(m,"beforeunload",y);a.addEvent(m,"unload",y)}else{var s=o.iframe=document.createElement("iframe");s.setAttribute("width","400");s.setAttribute("height","400");s.style.position="absolute";s.style.left=s.style.top="0px";s.style.display="none";document.body.appendChild(s);l=s.contentDocument||s.contentWindow.document}l.iFSIImageListPrint=o;var r=w.join("\r\n");l.open();l.write(r);l.close()};this.printUpdater=function(q,p){if(k.updateCallback){k.updateCallback.apply(n,arguments)}if(!d){d=l.getElementById("printProgress")}if(d){d.value=100*q/p}};this.onBeforePrint=function(){if(!j){j=l.getElementById("divProgress")}if(j&&j.parentNode){j.parentNode.removeChild(j)}};this.printFinisher=function(){if(!h){return}if(k.finishCallback){k.finishCallback.apply(n,arguments)}};var c=this.finishPrinting=function(){if(!h){return}if(e!==b){clearTimeout(e)}if(a.mobileOS==="ios"){a.addEvent(window,"touchstart",i)}else{e=setTimeout(i,100)}};var i=function(){if(!h){return}if(a.mobileOS==="ios"){a.removeEvent(window,"touchstart",i)}if(e!==b){clearTimeout(e)}e=b;if(o.iframe&&o.iframe.parentNode){document.body.removeChild(o.iframe)}o.iframe=b;if(m){m.close()}m=b;h=false;if(k.onRemove){k.onRemove.apply(n,arguments)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PagesSearchDialog!==b){return}a.PagesSearchDialog=function(c,m,h){var k=this;var n;var C=m.iConfig;var T;if(typeof(h)!="object"){h={}}var G;var I={};var r=1;var A;var s,S,u,J;var Q;var R={};var l=false;var q;var W;var U;var K={};var v;var o;var O;var N;var Y=m.getRootContainer();var f=m.cfgString("SearchCustomURL",C.getServerBase());var L=m.cfgBool("SearchUseMethodGet");var d=(m.cfgString("SearchResultClickAction","flip")!=="zoom");var g=m.cfgBool("SearchSortResults",false);var j=m.cfgString("SearchResultServerTemplate","pages_searchresult.json");var z=m.cfgString("SearchContext","iptc.fsi_search_data,iptc.caption,iptc.fsi_extra");var F=m.cfgString("SearchType","simplesearch");var Z={and:1,or:1,not:1};var x='+-&|!(){}[]^"~*?:\\';var t;var V=function(){if(n){return}n=true;var ad=a.trim(m.cfgString("SearchParameters",""));if(ad.length>0){if(ad.charAt(0)!=="?"){ad="?"+ad}N={};C.parseQuery(ad,N)}if(h&&h.oMenu&&typeof(h.oMenu.sprite)=="object"){T=document.createElement("input");T.setAttribute("type","search");T.className="fsi-dialog-search-input";s=h.oMenu.sprite.element;if(m.cfgBool("SearchInput",true)){s.appendChild(T);T.parentNode.FSI_bMenuContainsSearchInput=true}T.style.top=((s.offsetHeight-T.offsetHeight)/2)+"px";if(a.isEventSupported){a.addEvent(T,"input",B)}else{a.addEvent(T,"keyup",B);a.addEvent(T,"change",B);a.addEvent(T,"paste",B)}a.addEvent(T,"focus",p)}m.iCallbacks.run("onSearchInit",[T]);X()};this.destroy=function(){if(!n){return}k.closeDialog();if(q){q.destroy();q=b}if(a.isEventSupported){a.removeEvent(T,"input",B)}else{a.removeEvent(T,"keyup",B);a.removeEvent(T,"change",B);a.removeEvent(T,"paste",B)}a.removeEvent(T,"focus",p);if(G&&G.parentNode){a.removeChild(G.parentNode,G)}if(T&&T.parentNode){a.removeChild(T.parentNode,T)}n=false};var p=function(){var ad=a.trim(T.value);if(ad.length>0&&G){H()}};var B=function(){if(Q!==b){clearTimeout(Q);Q=b}Q=setTimeout(y,500)};var y=function(){Q=b;k.search(T.value)};var E=function(){if(G){return}var ad=m.getMenuHeight();G=document.createElement("div");Y.appendChild(G);S=document.createElement("div");S.className="fsi-dialog-search-no-results";G.className="fsi-dialog fsi-dialog-search";G.style.bottom=ad+"px";J=document.createElement("div");J.className="fsi-dialog-close";G.appendChild(J);a.addEvent(J,"click",k.closeDialog);u=document.createElement("h1");G.appendChild(u);U=document.createElement("div");U.className="fsi-dialog-search-results";G.appendChild(U);k.onLanguageDataReady();a.addEvent(document,"keyup",e)};var X=function(){if(!T.parentNode||!T.parentNode.FSI_bMenuContainsSearchInput){return}var ae=0;T.style.display="";var ag=m.getMenu();if(ag){ae=ag.getButtonContainerWidth()}var af=(Y.offsetWidth-ae)/2;var ad=((af-12)>T.offsetWidth);if(!ad){T.style.display="none"}O=ad};this.onResize=function(ad){if(ad&&ad.FSI_after_treshold){X()}if(!l){return}u.style.width=(U.offsetWidth-100)+"px";var ae=a.utils.getElementPaddings(G);var af=m.getMenuHeight();G.style.height=(Y.offsetHeight-af)+"px";var ag=a.utils.getElementMargins(u);U.style.height=(G.clientHeight-u.offsetHeight-ag.top-ag.bottom-ae.top-ae.bottom)+"px"};var H=function(){if(l){return}E();G.style.display="block";l=true;k.onResize();if(q){q.show()}m.iCallbacks.run("onShowSearchDialog",[true])};var aa=function(){if(q){q.destroy();q=b}if(m.iCallbacks.isset("onSearchResults")){m.iCallbacks.run("onSearchResults",[a.utils.cloneArray(o),a.utils.cloneArray(R._arImages)])}var ad=ab("PagesSearchDialogResultsTitle").replace(/%%phrase%%/,v);u.innerText=ad.replace(/%%count%%/,R.images.length);if(R.images.length>0){if(S.parentNode){S.parentNode.removeChild(S)}var ae={};ae.initialPageIndex=1;ae.imageOptions={};if(m.cfgString("effects")){ae.imageOptions.effects=m.cfgString("effects")}ae.elContainer=U;ae.pageOptions={bInteractive:false,bImageOnly:true,bGroupDoublePages:false,bPageNumbers:true};ae.nScrollAnimationFrames=12;ae.nCreateAhead=0.2;ae.bScrollToCurrentTopPageAfterResize=true;ae.name="SearchResults";ae.bNoBendEffect=true;ae.nConcurrentImageLoad=24;ae.onPageClick=i;ae.strContainerClass="fsi-pages-search-results fsi-pages-scrollbar";ae.bCenterContent=true;var af=m.cfgInt("searchThumbSize",320);ae.thumbWidth=ae.thumbHeight=af;a.addClass(m.pageIndexContainer,"fsi-pages-search-results");q=new a.PageLayoutGrid(c,m,R,C,ae);q.getCustomPageLayoutData=M;q.getPageNumberString=P;q.init();if(m.cfgBool("SearchAutoSelectFirstResult",false)){D(0)}}else{U.appendChild(S)}};var P=function(ad){return m.getPageNumberString(K[ad])};var i=function(ad){if(ad){D(ad.nIndex);k.closeDialog()}};var D=function(ad){var ae=K[ad];if(d){m.gotoPageByIndex(ae,true)}else{c.gotoPageAndZoom(ae)}};this.closeDialog=function(ad){if(!l){return}l=false;if(q){q.hide()}G.style.display="none";if(!ad){T.blur()}m.iCallbacks.run("onShowSearchDialog",[false])};var ab=function(ae,ad){if(I[ae]!==b){return I[ae]}else{if(ad===b){ad=""}return ad}};var e=function(ad){switch(ad.which){case 27:k.closeDialog();break}};var w=function(){A={};var ad=m.oImageList._arImages;for(var ae=0;ae<ad.length;ae++){A[ad[ae]]=ae}};this.runSearch=function(ad){T.value=ad;k.search(ad)};this.search=function(ai){var ad=ai;ai=a.trim(ai);if(ai.length<2){k.closeDialog(true);return}if(!m.oImageList){W=ai;return}if(v===ai){H();return}v=ai;r++;W=b;if(m.cfgBool("SearchAutoWildCards",false)){for(var ak in Z){if(Z[ai]){ai=ai.replace(ak,ak.toUpperCase())}}ai=ai.split(" ");for(var ah=0;ah<ai.length;ah++){var aj=a.trim(ai[ah]);var ag=aj.charAt(aj.length-1);if(Z[aj]===1){aj=aj.toUpperCase()}else{if(aj.length>0&&x.indexOf(ag)===-1){aj+="*"}else{if(aj==="*"){aj=""}}}ai[ah]=aj}for(ah=ai.length-1;ah>-1;ah--){if(ai[ah].length<1){ai.splice(ah,1)}}ai=ai.join(" ")}var ae={query:ai,source:h.dir,context:z,tpl:j,type:F,limit:"0,"+m.maxPage};if(typeof(N)=="object"){a.utils.mergeObjects(ae,N)}m.iCallbacks.run("onSearchStart",[ai,ad]);if(L){var af=f;if(af.indexOf("?")===-1){af+="?"}af+=C.objectToQuery(ae);C.loadFile(af,ac,b,r)}else{C.loadFile(f,ac,b,r,"POST",ae)}};this.onDataComplete=function(){if(W){T.value=W;k.search(W)}k.onLanguageDataReady()};this.onLanguageDataReady=function(){if(t){return}I=m.getLanguageData();if(!I){return}if(T){T.setAttribute("placeholder",ab("PagesSearchPlaceholder"))}if(!u){return}t=true;S.innerHTML=ab("PagesNoSearchResults");u.innerText=ab("PagesSearchDialogResultsTitle")};var M=function(ad){ad.nMinPage=1;ad.nMaxPage=R.images.length;ad.nImages=R.images.length};var ac=function(ah,ad,ag){var af;if(typeof(ad)!="object"||typeof(ad.results)!="object"){return}var ae;if(ag!==r){return}k.closeDialog(true);m.getDebug().log((ad.results.length-1)+" results for phrase '"+v+"'");if(typeof(ad)=="object"&&typeof(ad.results)=="object"&&ad.results.length>0){R.images=[];R._arImages=[];o=[];if(!A){w()}for(ae=0;ae<ad.results.length;ae++){af=A[ad.results[ae]];if(af!==b){o.push(af)}}if(g){o.sort()}for(ae=0;ae<o.length;ae++){af=o[ae];K[ae]=af;R.images.push(m.oImageList.images[af]);R._arImages.push(m.oImageList._arImages[af])}H();aa()}else{}};this.show=function(ad){if(!ad){k.closeDialog()}else{if(G){H()}}};V()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PagesPrintDialog!==b){return}a.PagesPrintDialog=function(c,i,D){var h=this;var j;var P;var G;var l;var o=i.iConfig;var O=[];var s;var I="FSIPagesPrintRadio_"+c.getInstanceID();var A=1;var n=i.getMinMaxRealPages();var t=i.getLanguageData();var q;var v=false;var H;var J,R;var T,E;var x=i.getCurrentPageRange();var f,K,u;var r=0;var m;var N=function(){if(j){return}j=true;var Z,ab;P=i.getRootContainer();s=document.createElement("div");s.className="fsi-dialog fsi-dialog-print";s.style.bottom=i.getMenuHeight()+"px";u=document.createElement("div");u.className="fsi-dialog-close";s.appendChild(u);a.addEvent(u,"click",i.closePrintDialog);Z=document.createElement("h1");Z.innerHTML=S("PagesPrintDialogTitle");s.appendChild(Z);f=document.createElement("div");Z=document.createElement("span");Z.className="fsi-dialog-body-text";Z.innerHTML=S("PagesPrintDialogText");f.appendChild(Z);R=document.createElement("fieldset");ab=S("CurrentPage(s)","Current Page(s)");var X=Q(ab,"current",{checked:"checked"});R.appendChild(X);R.appendChild(Q(S("AllPages","All Pages"),"all"));ab=S("Page Range","Page Range (e.g. 1-5;12;20-25)");X=Q(ab,"defined");K=X.FSIInput;R.appendChild(X);var V=q=document.createElement("input");V.className="fsi-dialog-input-page-range";X.appendChild(V);a.addEvent(q,"focus",k);H=document.createElement("div");H.className="fsi-dialog-error";X.appendChild(H);f.appendChild(R);s.appendChild(f);E=document.createElement("div");E.style.display="none";var U=document.createElement("h3");U.innerHTML=S("WaitForPrintData","Please wait. Downloading print data...");E.appendChild(U);T=document.createElement("progress");T.setAttribute("max","100");T.style.width="100%";E.appendChild(T);s.appendChild(E);var Y;var W=document.createElement("span");W.className="fsi-dialog-main-button-group";Y=w(S("Cancel","Cancel"),i.closePrintDialog);W.appendChild(Y);Y=J=w(S("PagesPrintButton","Ok"),M);W.appendChild(Y);s.appendChild(W);P.appendChild(s);var aa=a.getBoundingClientRect(s);if(window.innerWidth>0&&aa.width>window.innerWidth){s.style.width=window.innerWidth+"px"}s.style.left=(P.offsetWidth-s.offsetWidth)/2+"px";y(null,"current");a.addEvent(document,"keyup",e)};this.destroy=function(){if(!j){return}a.removeEvent(q,"focus",k);if(a.oPrintImageListInstances!==b){delete a.oPrintImageListInstances[i.getInstanceID()]}a.removeEvent(document,"keyup",e);F();if(s&&s.parentNode){a.removeChild(s.parentNode,s)}j=false};var k=function(){K.checked="checked";y(null,"defined")};var S=function(V,U){if(t[V]!==b){return t[V]}else{return U}};var w=function(W,V){var U=document.createElement("input");U.setAttribute("type","button");U.setAttribute("value",W);if(typeof(V)==="function"){a.addEvent(U,"click",V)}return U};var y=function(U,V){if(U&&U.target){V=U.target.getAttribute("value")}if(V==="defined"){q.removeAttribute("readonly");a.removeClass(q,"fsi-dialog-input-page-range-readonly");q.focus()}else{q.setAttribute("readonly","readonly");a.addClass(q,"fsi-dialog-input-page-range-readonly")}switch(V){case"current":q.value=x;break;case"all":q.value=o.getPageNumber(n.nMin)+"-"+o.getPageNumber(n.nMax);break}};var Q=function(Y,aa,W){var ab=document.createElement("div");ab.className="fsi-dialog-option-element";var X=document.createElement("input");var V=I+"_"+A;A++;X.setAttribute("type","radio");X.setAttribute("id",V);X.setAttribute("name",I);X.setAttribute("value",aa);ab.FSIInput=X;a.addEvent(X,"change",y);if(W){for(var Z in W){if(W.hasOwnProperty(Z)){X.setAttribute(Z,W[Z])}}}var U=document.createElement("label");U.setAttribute("for",V);U.innerHTML=Y;ab.appendChild(X);ab.appendChild(U);return ab};var z=function(X,Y,W,Z,V){var U=S(X);if(typeof(U)==="string"&&U.length>0){U=U.replace(/%%e1%%/,Y);if(W!==b){U=U.replace(/%%e2%%/,W)}U=U.replace(/%%min%%/,Z);U=U.replace(/%%max%%/,V)}return U};var C=function(ae,aa,U){var ab,V,Z,ad,ac;v=false;var W=[];if(ae.length>0){ae=ae.split(";");for(var Y=0;Y<ae.length;Y++){ab=ae[Y];if(ab.indexOf("-")!==-1){V=ab.split("-");if(V.length===2){ad=V[0];ac=V[1];V[0]=o.getPageIndex(parseInt(V[0]));V[1]=o.getPageIndex(parseInt(V[1]));if(!isNaN(V[0])&&V[0]>=aa&&V[0]<=U&&!isNaN(V[1])&&V[1]>=aa&&V[1]<=U){if(V[0]>V[1]){Z=V[0];V[0]=V[1];V[1]=Z}for(var X=V[0];X<=V[1];X++){W.push(X)}}else{v=z("InvalidPageRange",ad,ac,aa,U)}}}else{if(ab.length>0){ad=ab;ab=o.getPageIndex(parseInt(ab));if(!isNaN(ab)&&ab>=aa&&ab<=U){W.push(ab)}else{v=z("InvalidPageValue",ad,b,aa,U)}}}}}return W};var e=function(U){switch(U.which){case 27:i.closePrintDialog();break;case 13:M()}};var F=function(){r++;if(G){G.destroy();G=b}};var M=function(){F();l=q.value;O=C(l,n.nMin,n.nMax);if(v){H.innerText=v;H.style.display="block";q.focus();return}else{H.innerHTML=""}if(O.length<1){return false}J.style.display=f.style.display="none";E.style.display="";a.addClass(s,"fsi-pages-print-dialog-loading");if(!i.bListWithDimensionLoaded){L()}else{g()}return true};var p=function(W,U,V){if(V.nInfoJobID!==r){return}V.oImage.width=U.width;V.oImage.height=U.height;m++;if(m===O.length){g()}};var L=function(){r++;m=0;for(var V=0;V<O.length;V++){var X=O[V];var U=D.images[X];if(U.width===b){var W={nInfoJobID:r,oImage:U};o.loadImageInfo(D._arImages[X],p,W)}else{m++}}if(m===O.length){g()}};var g=function(){var ah=i.cfgInt("PrintResolution",2000);var ag=i.cfgString("PrintEffects","");var W;if(ag.length>0){if(ag.indexOf("?")===-1){ag="?"+ag}W={};o.parseQuery(ag,W)}if(W===b){W={}}var aa=new a.CroppedImage();var ab=[];var ai=D._arImages;for(var ad=0;ad<O.length;ad++){var Z=O[ad];var Y=D.images[Z];var V=ai[Z];if(V!=null){var ac=Y.width;var af=Y.height;if(ah<ac||ah<af){var ae=i.getImageDimFitInto(ac,af,ah,ah);ac=ae.width;af=ae.height}X="";aa.setSourceDimension(ac,af);aa.setCropFromConfig(o.cfg);if(aa.isCropped()){if(i.bAutoFlipCrop&&Z%2){aa.flipCropHorz()}var X=aa.getPixelRangeParametersByCalculatedResult(aa.getPixelRangeRect())}if(!aa.isCropped()){W.width=ac}ab.push(o.getImageURL(V,W)+X)}}var aj=i.getInstanceID();var U={imageList:ab,updateCallback:B,finishCallback:d,idInstance:aj};G=new a.PrintImageList(h,i,U);if(a.oPrintImageListInstances===b){a.oPrintImageListInstances={}}a.oPrintImageListInstances[aj]=G;i.iCallbacks.run("onPrintPages",[O,ab]);G.print()};var B=function(V,U){T.value=Math.floor(100*V/U)};var d=function(){i.closePrintDialog()};N()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PagesSaveDialog!==b){return}a.PagesSaveDialog=function(r,w,l){var x=this;var n;var G;var z=w.iConfig;var B;var t="FSIPagesSaveRadio_"+r.getInstanceID();var o=1;var u=w.getLanguageData();var k,e;var y,v;var f;var p;var E=function(){if(n){return}n=true;f=w.getLayout().getCurrentContainer();var L;G=w.getRootContainer();B=document.createElement("div");B.className="fsi-dialog fsi-dialog-save";B.style.bottom=w.getMenuHeight()+"px";v=document.createElement("div");v.className="fsi-dialog-close";B.appendChild(v);a.addEvent(v,"click",w.closeSaveDialog);L=document.createElement("h1");L.innerHTML=c("PagesSaveDialogTitle");B.appendChild(L);y=document.createElement("div");L=document.createElement("span");L.className="fsi-dialog-body-text";L.innerHTML=c("PagesSaveDialogText");y.appendChild(L);var O;var N=f.iPage1&&f.iPage1.bRealPage;var K=f.iPage2&&f.iPage2.bRealPage;if(N&&K){O={checked:"checked"}}else{O={disabled:"disabled"}}e=document.createElement("fieldset");e.appendChild(q(c("Both Pages","Both Pages"),"both",O));if(N){O=(!K)?{checked:"checked"}:b}else{O={disabled:"disabled"}}e.appendChild(q(c("Left Page","Left Page"),"left",O));if(K){O=(!N)?{checked:"checked"}:b}else{O={disabled:"disabled"}}e.appendChild(q(c("Right Page","Right Page"),"right",O));p=w.getConfigVal("savedocumentfile");if(typeof(p)==="string"&&p.length>0){e.appendChild(q(c("Entire Document","Entire Document"),"doc"))}y.appendChild(e);B.appendChild(y);var J;var I=document.createElement("span");I.className="fsi-dialog-main-button-group";J=D(c("Cancel","Cancel"),w.closeSaveDialog);I.appendChild(J);J=k=D(c("PagesSaveButton","Ok"),d);I.appendChild(J);B.appendChild(I);G.appendChild(B);var M=a.getBoundingClientRect(B);if(window.innerWidth>0&&M.width>window.innerWidth){B.style.width=window.innerWidth+"px"}B.style.left=(G.offsetWidth-B.offsetWidth)/2+"px";a.addEvent(document,"keyup",j)};this.destroy=function(){if(!n){return}a.removeEvent(document,"keyup",j);if(B&&B.parentNode){a.removeChild(B.parentNode,B)}n=false};var c=function(J,I){if(u[J]!==b){return u[J]}else{return I}};var D=function(K,J){var I=document.createElement("input");I.setAttribute("type","button");I.setAttribute("value",K);if(typeof(J)==="function"){a.addEvent(I,"click",J)}return I};var q=function(M,O,K){var P=document.createElement("div");P.className="fsi-dialog-option-element";var L=document.createElement("input");var J=t+"_"+o;o++;L.setAttribute("type","radio");L.setAttribute("id",J);L.setAttribute("name",t);L.setAttribute("value",O);P.FSIInput=L;if(K){for(var N in K){if(K.hasOwnProperty(N)){L.setAttribute(N,K[N])}}}var I=document.createElement("label");I.setAttribute("for",J);I.innerHTML=M;P.appendChild(L);P.appendChild(I);return P};var j=function(I){switch(I.which){case 27:w.closeSaveDialog();break;case 13:d()}};var H,m;var A,i;var g=0;var s;var h=function(K,I,J){if(J.nInfoID!==g){return}if(J.bLeft){A=I}else{i=I}if(A&&i){C()}};var C=function(){var V=w.cfgInt("SaveResolution",2000);var W,L,I,J,Q;var U=w.cfgString("SaveEffects","");var K={};if(U.length>0){if(U.indexOf("?")===-1){U="?"+U}z.parseQuery(U,K)}K.save=1;if(A!==true){s.push(A)}if(i!==true){s.push(i)}if(s.length<1){return false}var N=new a.CroppedImage();if(s.length===1){for(var P=0;P<s.length;P++){var T=s[P];I=T.src;if(I!=null){var O=T.width;var S=T.height;if(V<O||V<S){Q=w.getImageDimFitInto(O,S,V,V);O=Q.width;S=Q.height}N.setSourceDimension(O,S);N.setCropFromConfig(z.cfg);if(N.isCropped()){if(i!==true&&w.bAutoFlipCrop){N.flipCropHorz()}L=N.getPixelRangeParametersByCalculatedResult(N.getPixelRangeRect())}else{L=""}if(!N.isCropped()){K.width=O}W=z.getImageURL(I,K)+L}}}else{I=s[0].src+","+s[1].src;K.renderer="doublepage";K.backgroundcolor="FFFFFF";N.setSourceDimension(s[0].width,s[0].height);N.setCropFromConfig(z.cfg);if(N.isCropped()){J=N.getFloatRect();J.right=J.width();J.bottom=J.height();K.leftimagecrop=J.toString()}var R=w.getImageDimFitInto(s[0].width,s[0].height,V,V,N);N.setSourceDimension(s[1].width,s[1].height);N.setCropFromConfig(z.cfg);if(N.isCropped()){if(w.bAutoFlipCrop){N.flipCropHorz()}J=N.getFloatRect();J.right=J.width();J.bottom=J.height();K.rightimagecrop=J.toString()}var M=w.getImageDimFitInto(s[1].width,s[1].height,V,V,N);K.width=R.width+M.width;W=z.getImageURL(I,K)}if(W){window.open(W,"_self")}};var F=function(J,K){var L=l._arImages[J];if(l.images&&l.images[J]&&l.images[J].width&&l.images[J].height){var I={src:L,width:l.images[J].width,height:l.images[J].height};h(null,I,K)}else{z.loadImageInfo(L,h,K)}};var d=function(){g++;A=i=b;H=m=b;s=[];if(f.iPage1){H=f.iPage1.nIndex}if(f.iPage2){m=f.iPage2.nIndex}var I=document.querySelector('input[name="'+t+'"]:checked').value;switch(I){case"doc":window.open(p,"_blank");break;case"left":i=true;F(H,{bLeft:true,nInfoID:g});break;case"right":A=true;F(m,{bLeft:false,nInfoID:g});break;default:F(H,{bLeft:true,nInfoID:g});F(m,{bLeft:false,nInfoID:g})}w.closeSaveDialog();return true};E()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PagesChapters!==b){return}a.PagesChapters=function(y,w,F){var z=this;if(typeof(F)!="object"){F={}}var m=false;var A=w.iConfig;var H=[];var J={};var B=w.getDebug();var f,g,o,e,s;var I=0;var h=false;z.bVisible=false;var C,v,l;var p=[];var q;var j;var d=true;this.init=function(){if(m){return}m=true;f=(!i("useFirstPageNumber",true,true))?0:A.firstPageNum-1;g=i("usePageNameAliases",false,true);o=i("PageNumbers",true,true);if(o){e=i("PageNumberPrefix","");s=i("PageNumberSuffix","")}q=parseFloat(i("width"));if(isNaN(q)){q=b}if(w.inLineChaptersDataNode===b){w.inLineChaptersDataNode=w.iCallbacks.run("onGetChaptersData");if(!w.inLineChaptersDataNode){w.inLineChaptersDataNode=false}}var O;if(!i("indexdata.node")&&i("indexdatafile")){O=w.inLineChaptersDataNode}if(O){c(O)}else{var N=i("indexdata.node");var L=x(N);if(!L){var M=i("indexdatafile","");if(M.length>0){k(M)}else{E(false)}}}};this.destroy=function(){if(!m){return}m=false;if(C){if(j!==b){clearTimeout(j);j=b}z.show(false);a.removeEvent(C.elContainerInner,"click",D);C.destroy()}};var i=function(M,L,N){return A.getPluginParameter("chapters",M,L,N)};var k=function(P){var M;if(P.toLowerCase()==="auto"){var N=A.requestBase+"?source=";var L=w.cfgString("dir");M=N+encodeURIComponent(L)+"&type=info&tpl=chapters.xml"}else{M=A.getFSIPath(A.locationFSIViewer,A.expandFSIPath(P))}B.log("Loading chapters data: "+M);var O={};A.finishRequestParams(O);M=A.addURLParameters(M,O);A.loadFile(M,r,"application/xml")};var r=function(N,M){var L=false;if(typeof(M)=="object"&&M!==null){L=x(M.firstChild)}if(!L){E(false)}};var K=function(N,O,L,M,R){I++;var Q={};Q.label=N;Q.page=O;Q.color=L;Q.downloadfile=M;Q.level=R;if(R===0){H.push(Q)}else{var P=J[R-1];if(P!==b){if(P.items===b){P.items=[]}P.items.push(Q)}}J[R]=Q};var c=function(M){var L=function(T,Z){var R;var W=T.childNodes;if(W&&W.length>0){for(var V=0;V<W.length;V++){R={childNodes:[]};var N=W[V];if(N.nodeType!==1||N.nodeName!=="CHAPTER"){continue}var P=N.childNodes;if(P&&P.length>0){for(var U=0;U<P.length;U++){var O=P[U];if(O.nodeType===1&&O.nodeName==="CHAPTER"){R.childNodes.push(O);N.removeChild(O)}}}var Y=a.trim(N.innerHTML);var X=N.getAttribute("page");var S=N.getAttribute("color");var Q=N.getAttribute("file");if(Y.length>0){K(Y,X,S,Q,Z)}if(R.childNodes.length>0){L(R,Z+1)}}}};L(M.cloneNode(true),0);E(H.length>0)};var x=function(L){if(!L||!L.firstChild){return false}var T=0;var M=L.firstChild;var P;while(M&&T>-1){if(M.nodeType===1){var S=decodeURIComponent(A.getXMLNodeAttribute(M,"label",""));var R=A.getXMLNodeAttribute(M,"page","");var O=A.getXMLNodeAttribute(M,"color",b);var N=A.getXMLNodeAttribute(M,"file",b);if(S.length>0){K(S,R,O,N,T)}}P=M.firstChild;if(!P){P=M.nextSibling;if(!P){P=M.parentNode.nextSibling;T--}}else{T++}M=P}var Q=false;if(H.length>0){Q=true;E(true)}return Q};var E=function(L){if(I<1){B.error("No items for plugin chapters.")}else{B.log("Initializing chapters with "+I+" items.")}if(w.iCallbacks.isset("onShowChaptersData")){w.iCallbacks.run("onShowChaptersData",[a.utils.cloneArray(H)])}if(typeof(F.onReady)=="function"){F.onReady.apply(y,[L])}};var n=function(){if(h){return}h=true;var M=false;var L=function(Y,U){if(U>0){M=true}var Z,V,X,aa,W,ab;var ac=T.cloneNode(true);a.addClass(ac,"fsi-pages-chapters-level-"+U);for(Z=0;Z<Y.length;Z++){V=Y[Z];X=S.cloneNode(true);V.domElement=X;X._FSIChaptersElement=V;if(V.cssClass){a.addClass(X,V.cssClass)}X.firstChild.innerHTML=V.label;aa=V.page;if(g){aa=A.getPageNumberFromString(aa)}else{aa=parseInt(aa)}V.nPage=aa;if(!isNaN(aa)&&o){p.push(V);W=e+A.getPageNumberString(aa+f)+s}else{W=""}X.firstChild.nextSibling.innerHTML=W;ac.appendChild(X);if(V.items){ab=L(V.items,V.level+1);X=O.cloneNode(true);X.firstChild.style.paddingLeft=(U+1)*12+"px";X.firstChild.appendChild(ab);ac.appendChild(X)}}return ac};C=new a.VerticalScrollPanel();C.elContainer.style.display="none";a.addClass(C.elContainer,"fsi-pages-chapters");F.elContainer.appendChild(C.elContainer);var T=document.createElement("table");T.setAttribute("cellpadding","0");T.setAttribute("cellspacing","0");a.addClass(T,"fsi-pages-chapters");var S=document.createElement("tr");a.addClass(S,"fsi-pages-chapters-row");var P=document.createElement("td");a.addClass(P,"fsi-pages-chapters-td1");S.appendChild(P);var N=document.createElement("td");a.addClass(N,"fsi-pages-chapters-td2");S.appendChild(N);var O=document.createElement("tr");var Q=document.createElement("td");Q.setAttribute("colspan","2");a.addClass(Q,"fsi-pages-chapters-tdt");O.appendChild(Q);var R=L(H,0);if(M){a.addClass(C.elContainer,"fsi-pages-chapters-multilevel")}v="fsi-pages-table-of-contents-"+y.getInstanceID();R.setAttribute("id",v);C.setContent(R);a.addEvent(C.elContainerInner,"click",D);p.sort(w.sortNumeric)};var D=function(L){var N=L.target;while(N&&N._FSIChaptersElement===b&&N.id!==v){N=N.parentNode}if(N._FSIChaptersElement){var M=N._FSIChaptersElement.nPage;if(!isNaN(M)){if(y.gotoPageNumeric(M,true)){z.show(false)}}}};this.toggle=function(){z.show(!z.bVisible)};var u=function(N){if(p.length>0){if(l){a.removeClass(l,"fsi-pages-chapters-current")}var L;for(var M=0;M<p.length;M++){if(p[M].nPage>N){L=p[Math.max(0,M-1)];break}}if(L===b){L=p[p.length-1]}var O=a.getBoundingClientRect(L.domElement);l=L.domElement;a.addClass(l,"fsi-pages-chapters-current");C.elContainerInner.scrollTop=C.elContainerInner.scrollTop+O.top-C.elContainerInner.offsetHeight/2}};var t=function(L){if(L&&L.pointerType==="touch"){return}z.show(false)};var G=function(){a.addEvent(document,"click",t);j=b};this.onResize=function(){z.show(false);d=true};this.show=function(P){if(z.bVisible===P){return}z.bVisible=P;w.iCallbacks.run("onShowChapters",[P]);n();var M=w.getMenu();if(M){M.setButtonPressed("ToggleTableOfContents",P)}if(P){C.elContainer.style.opacity=1;if(d){d=false;var O=F.elContainer.offsetWidth;if(q!==b){var L=Math.min(O,q);C.elContainer.style.width=L+"px";C.elContainer.style.left=Math.round((O-L)/2)+"px"}var N=(!M)?0:M.getHeight();var S,R;R=w.getRootContainer().offsetHeight-N;C.elContainerInner.style.height="";C.elContainer.style.display="";S=Math.min(R,C.elContainerInner.offsetHeight);if(S<60){z.show(false);return}C.elContainerInner.style.height="100%";C.elContainer.style.height=S+"px";if(C.elContainerInner.clientHeight<C.elContainerInner.scrollHeight){S+=C.elContainerInner.scrollHeight-C.elContainerInner.clientHeight;S=Math.min(R,S);C.elContainer.style.height=S+"px"}C.elContainer.style.top=(R-S)+"px"}else{C.elContainer.style.display=""}var Q=w.getCurrentPageNumberNumeric();u(Q);j=setTimeout(G,50)}else{C.elContainer.style.opacity=0;if(j!==b){clearTimeout(j);j=b}a.removeEvent(document,"click",t);C.elContainer.style.display="none"}};a.customTags.register("fsi-pages-chapters",{constructorClass:a.PagesChaptersData,viewerCSS:"display:none;"})};a.PagesChaptersData=function(d){var c;this.init=function(){d.style.display="none";c=d.parentNode;if(c&&c.tagName==="FSI-PAGES"&&typeof(c.addListener)==="function"){c.addListener("onGetChaptersData",e)}};var e=function(){if(c){c.removeListener("onGetChaptersData",e);c.removeChild(d)}return d}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PagesBookmarks!==b){return}a.PagesBookmarks=function(d,m,z,g){var j=this;if(typeof(g)!="object"){g={}}var o=false;var v=m.iConfig;var r;var e=false;var J={};var y={};var E={};var n=g.bDoublePages;var O,U;var T=m.getFrontCoverIndex();var q=m.getContentID()+"_stickynotes";var Q=q+"_time";var N;var h;var M=0;var l,K;var u;var i,p;var S=function(){var X;if(o){return}o=true;u=v.getPluginParameter("bookmarks","PageNumbers",true,true);i=v.getPluginParameter("bookmarks","PersistentStorage",true,true);p=parseInt(v.getPluginParameter("bookmarks","PersistentStorageExpiresAfter"));if(isNaN(p)||p<1){p=b}h=document.createElement("div");h.className="fsi-ui-button-icon fsi-pages-remove-bookmark-icon";if(T===b){T=-1}O=0;U=z.images.length;J.images=[];J._arImages=[];var W=L();if(typeof(W)=="string"&&W.length>0){var V=W.split(",");for(X=0;X<V.length;X++){j.addPage(V[X],true)}}k()};this.destroy=function(){if(!o){return}o=false;if(r){r.destroy()}};var C=function(){return new Date().getTime()};var R=function(){var V=m.getMenu();V.enableButton("ToggleBookmarkList",M>0)};var L=function(){if(!i||!a.BrowserSupports.localStorage()){return false}if(p){var W=parseInt(localStorage.getItem(Q));if(!isNaN(W)&&((C()-W)/1000)>p){localStorage.removeItem(Q);localStorage.removeItem(q);return false}else{localStorage.setItem(Q,C())}}var V=localStorage.getItem(q);m.iCallbacks.run("onBookmarksLoaded",[V]);return V};var s=function(){var V;var W="";if(!i||!a.BrowserSupports.localStorage()){return false}if(N.length<1){localStorage.removeItem(Q);localStorage.removeItem(q)}else{if(p){localStorage.setItem(Q,C())}W=N.join(",");V=localStorage.setItem(q,W)}m.iCallbacks.run("onBookmarksSaved",[W]);return V};var A=function(W){var V=U;if(n){V=V-V%2;W=W-W%2;W=Math.max(O,Math.min(V,W))}else{W=Math.max(O,Math.min(U,W))}return W};var H=function(X){var V="";var W=J.images[X];if(W&&W.nBookmarkPageNumber!==b){V=m.getPageNumberString(W.nBookmarkPageNumber)}return V};this.toggleBookmark=function(X){var W=false;if(j.addPage(X)){m.iCallbacks.run("onBookmarkAdded",[X]);W=true}else{var V=j.removePage(X);if(V){m.iCallbacks.run("onBookmarkRemoved",[X])}}return W};this.isPageBookmarked=function(V){return y[V]};this.removePage=function(W,X){var V=false;W=A(W);if(y[W]){V=true;if(n){t(W+1)}t(W);if(!X){k();s()}}return V};var t=function(W){var V=E[W];if(V===b){return}y[W]=b;delete y[W];E[W]=b;delete y[W];delete J.images[V].srcBookmark;J.images.splice(V,1);m.showBookmarkIconOnPage(W,false)};this.addPage=function(X,Y){if(isNaN(X)){return false}var W;var V=false;X=A(X);if(!y[X]){W=z.images[X];if(W!==b){V=true;D(X,W);if(n){W=z.images[X+1];if(W!==b){D(X+1,W)}}if(!Y){k();s()}}}return V};var D=function(W,V){y[W]=true;V.nBookmarkPageNumber=W;V.srcBookmark=z._arImages[W];J.images.push(V);J._arImages.push(z._arImages[W]);m.showBookmarkIconOnPage(W,true)};var f=function(W,V){return W.nBookmarkPageNumber-V.nBookmarkPageNumber};var k=function(){J.images.sort(f);M=J.images.length;N=new Array(M);J._arImages=new Array(M);E={};var Y=J.images;var W=J._arImages;for(var V=0;V<Y.length;V++){var X=Y[V].nBookmarkPageNumber;E[X]=V;N[V]=X;W[V]=Y[V].srcBookmark}R();m.updateAddBookmarkButton()};this.getVisible=function(){return e};var P=function(X,V){if(V.target&&a.hasClass(V.target,"fsi-pages-remove-bookmark-icon")){x(V);return}var W=J.images[X.nIndex];if(W!==b){m.gotoPageByIndex(W.nBookmarkPageNumber,true)}};var x=function(V){var X=r.getPageInstanceFromChildElement(V.target);if(X&&X.oImage.nBookmarkPageNumber){var W=j.removePage(X.oImage.nBookmarkPageNumber);if(W){m.iCallbacks.run("onBookmarkRemoved",[X.oImage.nBookmarkPageNumber])}if(M>0){G(X.oContainer);r.removeContainerFromLayout(X.oContainer)}else{m.hideBookmarks()}}};var G=function(V){if(V){if(V.iPage1){w(V.iPage1)}if(V.iPage2){w(V.iPage2)}}};var w=function(V){if(V&&V.elRemoveBookmark){a.removeEvent(V.elRemoveBookmark,"mouseenter",I);a.removeEvent(V.elRemoveBookmark,"mouseleave",c)}};var I=function(V){m.getToolTip().show("RemoveThisBookmark",V.target)};var c=function(){m.getToolTip().hide()};var B=function(){if(M<1){return}m.iCallbacks.run("onRemoveAllBookmarks");for(var V=0;V<N.length;V++){m.showBookmarkIconOnPage(N[V],false)}J.images=[];J._arImages=[];y={};E={};M=0;N=[];s();m.hideBookmarks()};this.show=function(V){if(V===e){return}e=V;m.iCallbacks.run("onShowBookmarkList",[V]);if(V){var W={};W.initialPageIndex=1;W.imageOptions={};if(m.cfgString("effects")!==b){W.imageOptions.effects=m.cfgString("effects")}W.elContainer=m.pageIndexContainer;W.pageOptions={bInteractive:false,bImageOnly:true,bGroupDoublePages:n,bPageNumbers:u};W.nScrollAnimationFrames=12;W.nCreateAhead=0.2;W.bScrollToCurrentTopPageAfterResize=true;W.name="Bookmarks";W.nConcurrentImageLoad=24;W.onPageClick=P;W.strContainerClass="fsi-pages-bookmarks fsi-pages-scrollbar";W.bCenterContent=true;var X=parseInt(v.getPluginParameter("bookmarks","ThumbSize"));if(isNaN(X)||X<20){X=200}W.thumbWidth=W.thumbHeight=X;a.addClass(m.pageIndexContainer,"fsi-pages-bookmarks");r=new a.PageLayoutGrid(d,m,J,v,W);r.getCustomPageLayoutData=F;r.onFinishPage=function(Y,Z){if(n){if(!Y.bOddPage&&Y.iSiblingPage&&Y.iSiblingPage.bRealPage){return}}Y.elRemoveBookmark=h.cloneNode(false);Z.appendChild(Y.elRemoveBookmark);a.addEvent(Y.elRemoveBookmark,"mouseenter",I);a.addEvent(Y.elRemoveBookmark,"mouseleave",c)};r.getPageNumberString=H;r.init();K=document.createElement("div");K.className="fsi-pages-remove-all-bookmarks-container";l=document.createElement("span");l.className="fsi-pages-remove-all-bookmarks";l.innerHTML=m.getLanguageString("RemoveAllBookmarks","Remove all bookmarks");K.appendChild(l);m.pageIndexContainer.appendChild(K);a.addEvent(l,"click",B)}else{c();R();m.updateAddBookmarkButton();a.removeEvent(l,"click",B);a.removeClass(m.pageIndexContainer,"fsi-pages-bookmarks");m.pageIndexContainer.removeChild(K);r.destroy()}};var F=function(V){if(J.images.length>0){V.nMinPage=1;V.nMaxPage=J.images.length;V.nImages=J.images.length}else{V.nMinPage=1;V.nMaxPage=1;V.nImages=0}};S()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PagesConfig!==b){return}a.PagesConfig=function(d,h,g,f,e){a.Config.prototype.constructor.call(this,g,f,e);var c=this;this.getPagesParameter=function(j,i,k){return c.getPluginParameter("pages",j,i,k)};this.getUnescapedParameter=function(l,k,j){var i=h.cfgString(l,k);if(i===b&&j!==b){i=h.cfgString(j,k)}if(i!==b){i=decodeURIComponent(i)}return i};this.initPagesParameters=function(){var j;if(!c.hasPlugin("pages")){return}c.LinkTemplates=h.cfgString("LinkTemplates","").split(",");for(j=0;j<c.LinkTemplates.length;j++){c.LinkTemplates[j]=decodeURIComponent(c.LinkTemplates[j])}c.LinkTemplateData=h.cfgString("LinkTemplateData","").split(",");for(j=0;j<c.LinkTemplateData.length;j++){c.LinkTemplateData[j]=decodeURIComponent(c.LinkTemplateData[j])}c.LinkTemplateCount=Math.max(c.LinkTemplates.length,c.LinkTemplateData.length);c.ParamForceLinkTarget=c.getUnescapedParameter("ForceLinkTarget",b,"LinkTarget");c.ParamForceJavascriptTarget=c.getUnescapedParameter("ForceJavascriptTarget",b);c.ParamForceLinkURLPrefix=c.getUnescapedParameter("ForceLinkUrlPrefix",b,"UrlPrefix");c.ParamForceLinkURLSuffix=c.getUnescapedParameter("ForceLinkUrlSuffix",b,"UrlSuffix");c.ParamForceLinkURL=c.getUnescapedParameter("ForceLinkUrl",b);c.ParamForceLinkTip=c.getUnescapedParameter("ForceLinkTip",b);c.ParamDefaultLinkTarget=c.getUnescapedParameter("DefaultLinkTarget",b);c.ParamDefaultJavascriptTarget=c.getUnescapedParameter("DefaultJavascriptTarget","_self");c.ParamDefaultLinkURLPrefix=c.getUnescapedParameter("DefaultLinkUrlPrefix",b);c.ParamDefaultLinkURLSuffix=c.getUnescapedParameter("DefaultLinkUrlSuffix",b);c.ParamDefaultLinkURL=c.getUnescapedParameter("DefaultLinkUrl",b);c.ParamDefaultLinkTip=c.getUnescapedParameter("DefaultLinkTip",b);c.bFollowLinks=h.cfgBool("FollowLinks",true);c.bRTL=h.cfgBool("PageOrderRTL",false);c.bUseNamedPageNumbersExternal=h.cfgBool("externalPageNumbersAreAliases",false);c.firstPageNum=c.getIntParameter("firstPageNumber",1);if(!h.cfgBool("frontcover",true)){c.firstPageNum++}c.nMaxRomanPageNumber=h.cfgInt("UseRomanPageNumbersToPage",0);if(isNaN(c.nMaxRomanPageNumber)){c.nMaxRomanPageNumber=0}c.nRomanPageNumberOffset=h.cfgInt("RomanPageNumbersOffset",0);if(isNaN(c.nRomanPageNumberOffset)){c.nRomanPageNumberOffset=0}};this.getSuperseedingParam=function(l,k,j,i){if(typeof(l)==="string"&&l.length>0){return l}if(typeof(k)==="string"&&k.length>0){return k}if(typeof(j)==="string"&&j.length>0){return j}return i};this.getAbsoluteURL=function(j,k,l){if(typeof(j)!=="string"){return""}if(!k){k=""}if(!l){l=""}if(j.indexOf(":")!==-1){var m=j.indexOf("://");if((m!==-1&&m<7)||j.indexOf("javascript:")===0||j.indexOf("mailto:")===0){return j}}if(j.charAt(0)==="#"){var i=j.toLowerCase();if(i.indexOf("#page=")===0){return j}if(i.indexOf("#zoomonpage=")===0){return j}if(i.indexOf("#zoom")===0){return j}if(i.indexOf("#zoomarea")===0){return j}if(i.indexOf("#showimage")===0){return j}if(i.indexOf("#none")===0){return""}}return k+j+l};this.getHotSpotUrl=function(m,o){var l=o;var k=m.oLinkAttributes;var n=c.getSuperseedingParam(c.ParamForceLinkURL,l.url,k.DefaultURL,c.ParamDefaultLinkURL);var i=c.getSuperseedingParam(c.ParamForceLinkURLPrefix,b,k.UrlPrefix,c.ParamDefaultLinkURLPrefix);var j=c.getSuperseedingParam(c.ParamForceLinkURLSuffix,b,k.UrlSuffix,c.ParamDefaultLinkURLSuffix);return c.getAbsoluteURL(n,i,j)};this.getHotSpotTarget=function(m,o,n){var k;var l=o;var j=m.oLinkAttributes;var i=n.toLowerCase();if(i.indexOf("mailto:")===0){k=c.getSuperseedingParam(b,l.target,"_self","_self")}else{if(i.indexOf("javascript:")===0){k=c.getSuperseedingParam(c.ParamForceJavascriptTarget,l.target,j.URLTargetJavascript,c.ParamDefaultJavascriptTarget)}else{k=c.getSuperseedingParam(c.ParamForceLinkTarget,l.target,j.DefaultTarget,c.ParamDefaultLinkTarget)}}if(k===b){k="_self"}return k};this.Replace_CurrentPage=function(k,j){var i=c.strReplace(k,"_FSI_CURRENTPAGE_",j);i=c.strReplace(i,"_FSI_CURRENTDOUBLEPAGE_",1+Math.floor(j/2));return i};this.strReplace=function(k,j,i){if(typeof(k)!=="string"||k.length<1||k.indexOf(j)===-1){return k}return k.split(j).join(i)};this.ReplaceLinkTemplates=function(k){if(c.LinkTemplateCount<0){return k}for(var j=0;j<c.LinkTemplateCount;j++){k=c.replaceLinkTemplate(k,j)}return k};this.replaceLinkTemplate=function(n,l){var k;var j=c.LinkTemplates[l];var m;switch(j){case"_FSI_CURRENTPAGE_":case"_FSI_CURRENTDOUBLEPAGE_":k=c.Replace_CurrentPage(n,h.getCurrentPageNumberNumeric());break;default:m=c.LinkTemplateData[l];k=c.strReplace(n,j,m);if(c.debug.on){c.debug.log("REPLACE: ["+j+"] with ["+m+"]")}}return k};this.readCustomPageNumbers=function(){var j=h.cfgString("CustomPageNumbersFile","");if(j.length>1){var i=c.getFSIPath(c.locationFSIViewer,j);if(i!==j){i=c.getFSIPath(c.locationFSIViewer,j)}var l={};c.finishRequestParams(l);if(i.indexOf(".xml")===-1){i+=".xml"}c.loadFile(i,c.onCustomPageNumbersLoaded,"application/xml")}else{var k=h.cfgString("CustomPageNumbers","");if(k.length>0){c.parseCustomPageNumbers(k)}h.onCustomPageNumbersDone()}};c.onCustomPageNumbersLoaded=function(j,l){var m=(typeof(l)=="object"&&l!=null);if(m){var k=c.findXMLNode(l,"pagenumbers");var i=c.getValueFromXMLNode(k);if(i.value){i=i.value}else{i=""}c.parseCustomPageNumbers(i);c.debug.log("External page numbers loaded, "+c.pageNumberArrayString.length+" entries found.")}else{c.debug.error("Loading external page numbers failed.")}h.onCustomPageNumbersDone()};c.parseCustomPageNumbers=function(l){if(l.length<1){return}c.pageNumberArrayString=l.split(",");c.pageNumberArrayNum={};for(var k=0;k<c.pageNumberArrayString.length;k++){var j=c.pageNumberArrayString[k];if(c.pageNumberArrayNum[j]===b){c.pageNumberArrayNum[j]=k}}c.bUseNamedPageNumbersExternal=h.cfgBool("externalPageNumbersAreAliases",false)};this.getPageNumberString=function(k){var j;if(c.pageNumberArrayString!==b){j=c.pageNumberArrayString[k-1];if(j!==b){if(j.indexOf("_")===0){j="---"}return j}}k=c.getPageNumber(k);j=k-c.nMaxRomanPageNumber;if(j>0){return String(k)}var i=c.firstPageNum;return c.int2roman(-(i-c.nMaxRomanPageNumber-j)+1+c.nRomanPageNumberOffset)};this.getPageNumber=function(i){return(c.bRTL)?c.firstPageNum+c.maxpage-i:c.firstPageNum-1+i};this.getPageIndex=function(i){return(c.bRTL)?-i+c.firstPageNum+c.maxpage:i-c.firstPageNum+1};this.getPageNumberFromString=function(k){var j;if(c.pageNumberArrayNum!==b){j=c.pageNumberArrayNum[k];if(j!==b){return j+c.firstPageNum}}j=parseInt(k);if(isNaN(j)){var i=c.firstPageNum;if(k==="---"){return i}j=c.roman2int(k)-c.nMaxRomanPageNumber-c.nRomanPageNumberOffset;if(j-1<=-i){j=j+i-1+c.nMaxRomanPageNumber}else{j=j+c.nMaxRomanPageNumber+i-1}}return j};this.int2roman=function(i){var j="";if(i<=0||isNaN(i)){return"---"}while(i/5000>=1){j+="A";i-=5000}while(i/1000>=1){j+="M";i-=1000}if(i/900>=1){j+="CM";i-=900}if(i/500>=1){j+="D";i-=500}if(i/400>=1){j+="CD";i-=400}while(i/100>=1){j+="C";i-=100}if(i/90>=1){j+="XC";i-=90}if(i/50>=1){j+="L";i-=50}if(i/40>=1){j+="XL";i-=40}while(i/10>=1){j+="X";i-=10}if(i/9>=1){j+="IX";i-=9}if(i/5>=1){j+="V";i-=5}if(i/4>=1){j+="IV";i-=4}while(i>=1){j+="I";i-=1}return j};this.oRomanToIntMap={I:1,V:5,X:10,L:50,C:100,D:500,M:1000,A:5000};this.roman2int=function(j){if(!j||typeof(j)!="string"){return 0}j=j.toUpperCase();var l=0;for(var m=j.length-1;m>-1;m--){var k=c.oRomanToIntMap[j.charAt(m)];var n=c.oRomanToIntMap[j.charAt(m-1)];l+=k;while(m>0&&n!==b&&n<k){l-=n;m--;n=c.oRomanToIntMap[j.charAt(m-1)]}}return l}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageLayout!==b){return}a.PageLayout=function(c,q,S,z,f){var k=this;k._strClassName="PageLayout";q.registerLayout(k);f=k.oOptions=(typeof(f)=="object")?f:{};if(f.name===b){k.name=k._strClassName+"_"+this.nLayoutID}else{k.name=f.name}var C=k.debug=q.getDebug();k.elemSpace={};k.elContainer={};k.pageContainer={};var R={};k.oPageDef={};k.arPages=[];k.oPageOptions={};k.bGroupDoublePages=(f.pageOptions.bGroupDoublePages!==false);k.elDoublePageContainer=false;k.oPageDefs={};var j={};var G={};var P=q.oCropCacheSource;var U;var D;var t=false;var s={};var N,H;var I=k.oVisibleRange={start:-10000,end:-10000,nVisible:0};this.arContainers=[];this.bVisible=k.bLayoutVisible=true;this.bFlipping=false;k.nContainerLoadedWidth=0;k.nContainerLoadedScale=k.nDocumentScale=k.nDocumentScalePixelRatio=1;k.bZoomed=false;var r=k.oZoomAnimation={scale:1};var e;var K=26;var l=(a.mobileOS==="ios"&&(a.osVersion.length>0&&a.osVersion[0]<6));var x=a.Easing.easeOutCubic;var i=new a.CSSTransformMatrix();this.dimImage={};this.dimContainer={};k.bVertical=(f.bHorizontal!==true);k.strLayoutClass="fsi-pages_layout-"+this.nLayoutID;var m=q.getBaseCSSSelector()+" div.fsi-pages-page-layout."+k.strLayoutClass;k.bDefinesPageSizeByCSS=true;k.nFakePagesStart=q.getFakePagesStart();var p=k.bAutoPageSize=(f.thumbWidth==="auto");var J={};var d=4;var o=(a.isMobileDevice)?350:100;var T=(a.isMobileDevice)?50:10;var F=(a.mobileOS==="ios");k.bLoadContentWhileScrolling=!F;var A=0;k.strPageContainerClass="fsi-pages-scroll";var w,v,h;k.bOnePageInView=f.bOnePageInView;k.nShowNeighbourPages=0;k.nOuterMargin=0;this.getClassName=function(){return k._strClassName};this.init=function(){if(!S||!S.images||S.images.length<1){return}if(!k.bFlipLayout){if(f.ScrollItemMinimumSpacing>0){k.nOuterMargin=f.ScrollItemMinimumSpacing}if(f.ShowNeighbourPages>0){k.nShowNeighbourPages=f.ShowNeighbourPages}w=((k.bOnePageInView===true&&k.bVertical===false)||(k.bVertical===true&&f.bSingleColumn===true));v=(k.bOnePageInView===true&&k.bVertical===true);h=(k.nOuterMargin!==0||w||v)}k.nFrontCoverContainerIndex=k.getContainerIndexFromPage(q.getFrontCoverIndex());k.nBackCoverContainerIndex=k.getContainerIndexFromPage(q.getBackCoverIndex());k.nDocumentScale=q.roundDocumentScale(q.nDocumentScale);k.nContainerLoadedScale=k.nDocumentScalePixelRatio=q.roundDocumentScale(q.nDocumentScalePixelRatio);k.elemSpace=a.getElementDimension(k.elContainer);if(f.nConcurrentImageLoad){d=f.nConcurrentImageLoad}if(a.isMobileDevice){d=Math.max(1,Math.ceil(d/3))}var W=S.images[0];k.bFakePageOnStart=(W&&W.src===b&&W.type===b);W=S.images[S.images.length-1];k.bFakePageOnEnd=(W&&W.src===b&&W.type===b);if(k.getCustomPageLayoutData){k.getCustomPageLayoutData(j)}else{j.nMinPage=k.nFakePagesStart;j.nMaxPage=q.getRealPages()-1+j.nMinPage;j.nImages=q.getRealPages()}k.nMinPage=j.nMinPage;k.nMaxPage=j.nMaxPage;j.bDoublePages=k.bGroupDoublePages;if(f.bMainLayout&&q.iCallbacks.isset("onPageLayoutChanged")){q.iCallbacks.run("onPageLayoutChanged",[k.getPageLayoutData()])}k.bHasSingleLastPage=(!k.bGroupDoublePages||(k.nMaxPage+k.nFakePagesStart)%2!==0);k.arPages=new Array(S.images.length);if(k.bGroupDoublePages){k.nContainers=Math.ceil((S._arImages.length-1)/2)}else{k.nContainers=Math.ceil(S._arImages.length)}k.setLayoutContainers();k.arContainers=new Array(k.nContainers);k.nMinPageIndex=0;k.nMaxPageIndex=S.images.length-1;M();V();k.elDoublePageContainer=document.createElement("div");k.elDoublePageContainer.setAttribute("class","fsi-pages-page-container fsi-pages-page-border");k.oPageDef.iConfig=z;if(typeof(f.imageOptions)==="object"){k.oPageDef.imageOptions=f.imageOptions}else{k.oPageDef.imageOptions={}}k.oImageOptionsUncropped=a.utils.cloneObject(k.oPageDef.imageOptions);k.oImageOptionsCropped=a.utils.cloneObject(k.oPageDef.imageOptions);k.oImageOptionsCropped.width=k.oImageOptionsCropped.height=null;if(f.pageOptions){k.oPageOptions=f.pageOptions}else{k.oPageOptions={bInteractive:false,bImageOnly:true}}k.oPageDef.hasLinks=k.bHasLinks=(!f.pageOptions.bImageOnly&&f.pageOptions.bInteractive);k.oPageOptions.bBendEffect=(!f.bNoBendEffect&&q.cfgString("BendEffect","glossy").toLowerCase()!=="none");k.elPageNumberTemplate=document.createElement("div");k.elPageNumberTemplate.setAttribute("style","position:absolute;z-index:10");a.addClass(k.elPageNumberTemplate,"fsi-page-number");if(!f.elContainer){C.error("oOptions.elContainer missing for "+k._strClassName)}k.elContainer=f.elContainer;k.pageContainer=document.createElement("div");k.pageContainer.bFSIIsPageContainer=true;a.addClass(k.pageContainer,"fsi-pages-page-layout "+k.strLayoutClass);k.pageContainer.style.visibility="hidden";if(typeof(f.strContainerClass)=="string"){k.bHasScrollBar=(f.strContainerClass.indexOf("fsi-pages-scrollbar")!==-1);a.addClass(k.pageContainer,f.strContainerClass)}else{k.bHasScrollBar=false}a.addClass(k.pageContainer,k.strPageContainerClass);if(f.enableZoom){a.addClass(k.pageContainer,"fsi-pages-zoom")}k.elContainer.appendChild(k.pageContainer);O();k.initLayout();if(k.onAfterInit){k.onAfterInit()}if(k.centerContent){k.centerContent()}if(f.bOneClickZoom){a.addClass(k.pageContainerInner,"fsi-pages-one-click-zoom")}u()};this.setLayoutContainers=function(){k.nLayoutContainers=k.nContainers};this.destroy=function(){q.unregisterLayout(k);k.stopLoading();for(var X=0;X<k.arContainers.length;X++){var W=k.arContainers[X];if(W){W.destroy()}}if(k.pageContainer.parentNode){a.removeChild(k.pageContainer.parentNode,k.pageContainer)}a.utils.deleteInstanceCSSRules(k)};this.getPageNumberString=function(W){return q.getPageNumberString(W)};this.getPageLayoutData=function(){return a.utils.cloneObject(j)};this.showBookmarkIconOnPage=function(Y,W,X){var Z=k.arPages[Y];if(!Z){return}if(W===Z.bBookmarkIconVisible||!Z.bRealPage){return}Z.bBookmarkIconVisible=W;var aa=Z.getContainer();if(W){if(!Z.elBookMark){Z.elBookMark=X.cloneNode(true);if(Z.bOddPage){a.addClass(Z.elBookMark,"fsi-pages-bookmark-icon-odd")}else{a.addClass(Z.elBookMark,"fsi-pages-bookmark-icon-even")}}aa.appendChild(Z.elBookMark);a.addClass(Z.oContainer.elContainer,"fsi-pages-bookmarked")}else{aa.removeChild(Z.elBookMark);a.removeClass(Z.oContainer.elContainer,"fsi-pages-bookmarked")}};this.removeContainerFromLayout=function(X){k.resetLoadContent();k.removeAllContainers();if(X.bCloned){X.unCloneDomElements()}if(X.iPage1){k.removePageFromLayout(X.iPage1)}if(X.iPage2){k.removePageFromLayout(X.iPage2)}k.arContainers.splice(X.nIndex,1);k.nContainers--;k.setLayoutContainers();for(var W=X.nIndex;W<k.nContainers;W++){if(k.arContainers[W]){k.arContainers[W].nIndex--}}X.destroy();k.updateVisiblePageRange(true);k.updateContainerDim()};this.removePageFromLayout=function(Y){var W=k.arPages.length;k.arPages.splice(Y.nIndex,1);Y.destroy();for(var X=Y.nIndex;X<W;X++){if(k.arPages[X]){k.arPages[X].nIndex--}}j.nMaxPage=k.nMaxPage=k.nMaxPage-1};this.getShowState=function(){var W={};W.bVisible=k.bVisible;W.bLayoutVisible=k.bLayoutVisible;W.nLockShow=A;return W};this.restoreShowState=function(W){if(W.bLayoutVisible){k.show()}else{k.hide()}k.bVisible=W.bVisible;A=W.nLockShow};this.unlockShow=function(){A--;if(!A){k.bLayoutVisible=true;if(k.bVisible){k.bVisible=false;k.show()}}};this.lockShow=function(){if(!A){k.bLayoutVisible=false;k.hide(true)}A++};this.hide=function(W){if(!k.bVisible){return false}k.cancelScrolling(false);if(!W){k.bVisible=false}k.bLayoutVisible=false;k.pageContainer.style.display="none";if(f.onShowHide){f.onShowHide()}return true};this.show=function(){if(A||k.bVisible){return false}k.bLayoutVisible=true;k.bVisible=true;k.pageContainer.style.display="block";if(k.resizeOnShow){O({FSI_after_treshold:true})}if(f.onShowHide){f.onShowHide()}return true};var M=function(){U=document.createElement("img");U.setAttribute("loading","eager");U.setAttribute("draggable","false")};this.initLayout=function(){};this.onActivateLink=function(X,W,Y){g();J.bActive=true;J.iPage=X;J.iLinks=W;J.oArea=Y};var g=k.disableActiveLink=function(){if(!J.oArea){return}J.iLinks.setLinkNormal(J.oArea)};this.getPage=function(X){var W=k.arPages[X];if(!W){W=k.createPage(X)}return W};this.createPage=function(Y){var Z,X;k.oPageOptions.bOddPage=(Y%2);var W=(k.oPageDefs[Y]!==b)?k.oPageDefs[Y]:k.oPageDef;X=S.images[Y];if(X){X.fullImagePath=S._arImages[Y]}if(!X||!X.src){k.oPageOptions.bRealPage=(X&&X.type!==b)}else{k.oPageOptions.bRealPage=true}Z=k.arPages[Y]=new a.Page(c,q,k,Y,W,X,k.oPageOptions);return Z};this.getContainerForPage=function(W){if(k.arPages[W]&&k.arPages[W].oContainer){return k.arPages[W].oContainer}return k.createPageContainerForPage(W)};this.createPageContainerForPage=function(Z){var Y;var ab;var ad;var X,W;var ac=k.getPage(Z);if(k.bGroupDoublePages){ab=k.elDoublePageContainer.cloneNode();var aa;if(ac.bOddPage){aa=Z-1;ad=Math.floor(Z/2)}else{aa=Z+1;ad=Math.floor(aa/2)}W=k.getPage(aa);if(ac.bOddPage){X=W;W=ac}else{X=ac}X.iSiblingPage=W;X.attachTo(ab);k.onAfterPageAdd(X);X.setOuterContainer(ab);if(W){W.iSiblingPage=X;W.attachTo(ab);k.onAfterPageAdd(W);W.setOuterContainer(ab)}if(!X.bRealPage||!W.bRealPage){a.removeClass(ab,"fsi-pages-page-border");if(X.bRealPage){a.addClass(X.getContainer(),"fsi-pages-page-border")}else{a.addClass(W.getContainer(),"fsi-pages-page-border")}}}else{ad=Z;X=ac;ac.init();k.onAfterPageAdd(ac);ab=ac.getContainer();a.addClass(ab,"fsi-pages-page-container fsi-pages-page-border");ac.setOuterContainer(ab)}Y=new a.PageContainer(c,q,k,ab,ad,X,W);k.arContainers[ad]=Y;return Y};k.onAfterPageAdd=function(){};k.getCurrentContainerIndex=function(Y){var W;var X=k.getCurrentPage(Y);if(k.bGroupDoublePages){W=Math.floor(X/2)}else{W=X}return W};k.getContainerIndexFromPage=function(W){return(k.bGroupDoublePages)?Math.floor(W/2):W};k.getPageIndexFromContainerIndex=function(W){return(k.bGroupDoublePages)?2*W:W};k.getCurrentContainer=function(W){return k.arContainers[k.getCurrentContainerIndex(W)]};this.gotoPage=function(W){W=Math.max(k.minPage,k.maxPage);if(k.nCurrentPage===W){return false}k.nCurrentPage=W;if(k.onAfterGotoPageResize){k.onAfterGotoPage(W)}return true};this.onStartDocumentZoom=function(){};this.onAfterDocumentZoom=function(W){u(W.FSI_scale)};var u=function(X){if(!q.bIsIOS){return}if(X===b){X=a.utils.getDocumentScale()}var W=(X>1.1);if(W!==k.biOSScaled){k.biOSScaled=W;if(W){a.addClass(k.pageContainerInner,"fsi-pages-layout-ios-zoomed")}else{a.removeClass(k.pageContainerInner,"fsi-pages-layout-ios-zoomed")}}};this.getImageNode=function(){return U.cloneNode()};this.resetCropCache=function(){G={}};this.getPageImageURL=function(aa,ac){var Y=Math.round(k.nDocumentScalePixelRatio*k.dimImage.width);var W=Math.round(k.nDocumentScalePixelRatio*k.dimImage.height);var ab=(!q.iLinkEditor);var X;if(typeof(aa)!=="object"||typeof(aa.fullImagePath)!=="string"){return false}var Z=aa.width+"_"+aa.height;if(q.bAutoFlipCrop){Z+="_"+ac}if(G[Z]!==b){X=G[Z]}else{X={};if(P[Z]===b){P[Z]=X.oCroppedImageSource=new a.CroppedImage();X.oCroppedImageSource.setSourceDimension(aa.width,aa.height);if(ab){X.oCroppedImageSource.setCropFromConfig(z.cfg)}}else{X.oCroppedImageSource=P[Z]}if(ab){X.oCroppedImage=X.oCroppedImageSource.getCropToFill(Y,W,"cc",true)}else{X.oCroppedImage=X.oCroppedImageSource}if(X.oCroppedImage.isCropped()){if(q.bAutoFlipCrop&&ac){X.oCroppedImage.flipCropHorz()}X.oImageOptions=k.oImageOptionsCropped;X.strCrop=X.oCroppedImage.getPixelRangeParameters()}else{X.strCrop="";X.oImageOptions=k.oImageOptionsUncropped;X.oImageOptions.width=Math.floor(Y)}G[Z]=X}return X};var V=function(){D=q.getPageAspectRatio()};this.getMaxPageDimForContainer=function(X){if(X===b){X={width:0,height:0}}var W=k.getCurrentContainer();if(W){if(W.iPage1&&W.iPage1.oImage&&W.iPage1.oImage.width){X.width=Math.floor(Math.max(X.width,W.iPage1.oImage.width));X.height=Math.floor(Math.max(X.height,W.iPage1.oImage.height))}else{if(W.iPage2&&W.iPage2.oImage&&W.iPage2.oImage.width){X.width=Math.floor(Math.max(X.width,W.iPage2.oImage.width));X.height=Math.floor(Math.max(X.height,W.iPage2.oImage.height))}}}return X};this.getAutoDoublePageMode=function(){var Y=k.getMaxPageDim(1);Y.width=Math.max(0,Y.width);Y.height=Math.max(0,Y.height);var ab=k.getMaxPageDim(2);ab.width=Math.max(0,ab.width);ab.height=Math.max(0,ab.height);var aa=q.getImageDimFitInto(D.width,D.height,Y.width,Y.height);var X=q.getImageDimFitInto(D.width,D.height,ab.width,ab.height);var Z=(1.5*X.width+X.height);var W=aa.width+aa.height;return(Z>=W)};this.calcPageDim=function(){var X=false;var W;W=k.getMaxPageDim();if(k.bZoomed){W=k.getMaxPageDimForContainer(W);W.width=Math.round(f.fMaxZoom*W.width);W.height=Math.round(f.fMaxZoom*W.height)}if(W.width<1||W.height<1){C.error("Insufficient element dimension");W.width=W.height=10}if(D.width===b||D.height===b){C.error("Missing image dimension.")}else{X=q.getImageDimFitInto(D.width,D.height,W.width,W.height,b,k.bZoomed)}return X};k.updateImagesOfVisiblePages=function(){k.dimImageScaledWidth=Math.ceil(k.nDocumentScalePixelRatio*k.dimImage.width);if(k.nContainerLoadedScale===k.nDocumentScalePixelRatio){if(!p||k.nContainerLoadedWidth===k.dimImageScaledWidth){return}}k.resetLoadContent();k.startLoadingContent(I.start,I.end)};this.resetLoadContent=function(){k.stopLoading();s.start=s.end=b};this.stopLoading=function(){if(!k.bLoadingContent){return}k.bLoadingContent=false;if(N===b&&H===b){return}if(H){clearTimeout(H);H=b}if(N){clearInterval(N);N=b}};var n=this.loadContainerContent=function(X){var W=false;if(!X.bContentLoaded){X.bContentLoaded=true;X.contentImageWidth=k.dimImageScaledWidth;if(X.iPage1){X.iPage1.initContent()}if(X.iPage2){X.iPage2.initContent()}W=true}else{if(X.contentImageWidth!==k.dimImageScaledWidth){X.contentImageWidth=k.dimImageScaledWidth;if(X.iPage1){X.iPage1.updateImage()}if(X.iPage2){X.iPage2.updateImage()}W=true}}return W};var E=function(){if(k.bFlipping&&!k.bLoadContentWhileScrolling){return}var Z=d;if(k.bFlipping&&a.isMobileDevice){Z=Math.ceil(Z/2)}var Y=Math.min(s.end,s.start+100);for(var X=s.start;X<=Y;X++){var W=n(k.arContainers[k.oLoadIndex[X]]);if(W&&--Z===0){break}}s.start=X+1;if(s.start>s.end){k.stopLoading()}};this.startLoadingContent=function(W,X){k.nContainerLoadedWidth=k.dimImageScaledWidth;k.nContainerLoadedScale=k.nDocumentScalePixelRatio;s.start=W;s.end=X;if(H){clearTimeout(H)}H=setTimeout(y,T)};var y=function(){H=b;s.current=s.start+Math.round((s.end-s.start)/2);var aa=k.oLoadIndex={};var Z=s.current;var Y=Z-1;var X=Z+1;aa[s.start]=Z;var ab=s.start+1;for(var W=s.start+1;W<=s.end+1;W++){if(W%2===0&&Y>=s.start){aa[ab]=Y;Y--;ab++}else{if(X<=s.end){aa[ab]=X;X++;ab++}}}k.stopLoading();k.bLoadingContent=true;E();if(k.bLoadingContent){N=setInterval(E,o)}};this.getTargetPage=function(X){var W=k.nMaxPage;if(k.bGroupDoublePages){W=W-W%2;X=X-X%2;X=Math.max(k.nMinPage,Math.min(W,X))}else{X=Math.max(k.nMinPage,Math.min(k.nMaxPage,X))}return X};this.updatePageSize=function(){if(!k.bLayoutVisible){return}k.dimImage=k.calcPageDim();k.dimImage.width=Math.floor(k.dimImage.width);k.dimImage.height=Math.floor(k.dimImage.height);a.utils.deleteInstanceCSSRules(k);var ad="width:"+k.dimImage.width+"px;height:"+k.dimImage.height+"px;";a.utils.addInstanceCSSRule(k,m+" div.fsi-pages-page",ad);if(k.dimContainer.width!==b&&k.containerMargins.left!==b){ad="";var aa,Z,W,Y;if(!k.bZoomed&&h){var ac=c.getPageContainerDim();k.updateContainerDim();var X={left:k.containerMarginsInitial.left,top:k.containerMarginsInitial.top,right:k.containerMarginsInitial.right,bottom:k.containerMarginsInitial.bottom};if(v){aa=Math.abs(X.top-X.bottom);Z=X.top+X.bottom;W=Math.ceil((ac.height-k.dimContainer.height)-2*Z)+aa-2*k.nShowNeighbourPages;X.top+=W/4;X.bottom+=W/4}if(w){aa=Math.abs(X.left-X.right);Z=X.left+X.right;W=Math.ceil((ac.width-k.dimContainer.width)-2*Z)+aa-2*k.nShowNeighbourPages;X.left+=W/4;X.right+=W/4}if(k.nOuterMargin>0){if(k.bVertical){Z=X.top+X.bottom;if(Z<k.nOuterMargin){Y=(k.nOuterMargin-Z)/2;X.top+=Y;X.bottom+=Y}}else{Z=X.left+X.right;if(Z<k.nOuterMargin){Y=(k.nOuterMargin-Z)/2;X.left+=Y;X.right+=Y}}}for(var ab in X){X[ab]=Math.max(0,X[ab]);ad+="margin-"+ab+":"+Math.ceil(X[ab])+"px;"}if(ad.length>0){a.utils.addInstanceCSSRule(k,m+".fsi-pages-main-view .fsi-pages-page-container",ad);k.updateContainerDim()}}}if(f.bMainLayout){q.iCallbacks.run("onPageSizeChanged",[k.dimImage.width,k.dimImage.height])}return true};this.getPageInstanceFromChildElement=function(W){while(W&&!W._fsiPage&&!W.bFSIIsPageContainer){W=W.parentNode}if(W){return W._fsiPage}};var O=this.onResize=function(W){k.resizeOnShow=!k.bLayoutVisible;if(!k.bLayoutVisible){return}if(k.onBeforeResize){k.onBeforeResize(W)}k.bResizing=(W&&!W.FSI_after_treshold);k.elemSpace=a.getElementDimension(k.elContainer);t=false;if(W&&W.FSI_after_treshold){k.updatePageSize()}if(k.dimImage.width>0&&k.dimImage.height>0){t=true}if(k.onAfterResize){k.onAfterResize(W)}};this.isFlipping=function(){return k.bFlipping};this.deactivateActiveLink=function(){if(!J.oArea){return}J.iLinks.setLinkNormal(J.oArea,true)};k.restoreActiveLinkState=function(){if(!J.oArea||!J.oArea._state){return}var W=k.getCurrentContainer();var X=J.iPage.nIndex;if(J.iPage.isVisible()&&W&&((W.iPage1&&W.iPage1.nIndex===X)||(W.iPage2&&W.iPage2.nIndex===X))){J.iLinks.updateLinkVisualState(J.oArea,J.evt,J.oArea._state)}else{k.deactivateActiveLink()}};this.setActiveLinkArea=function(Y,X,Z,W){if(Z){if(J.iPage!==b&&J.iPage.nIndex!==Y.nIndex){if(J.oArea){J.iLinks.setLinkNormal(null)}}}J.iPage=Y;J.iLinks=X;J.oArea=Z;J.evt=W};this.nextPage=function(){};this.previousPage=function(){};this.firstPage=function(){};this.lastPage=function(){};this.setOption=function(W,X){if(R[W]===b){R[W]=f[W]}f[W]=X};this.resetOption=function(W){f[W]=R[W]};this.updateVisiblePageRange=this.stopScrolling=function(){};var Q=function(W){if(l){W=false}var Z=r;Z.stopWidth=k.wItem-k.containerMargins.left-k.containerMargins.right;var Y=Z.startWidth/Z.stopWidth;k.pageContainer.scrollLeft+=Z.focusX;k.pageContainer.scrollTop+=Z.focusY;if(!W){if(!k.bZoomed){a.removeClass(k.pageContainer,"fsi-pages-zoomed")}return}Z.rcEnd=a.getBoundingClientRect(Z.container.elContainer);var X=a.getBoundingClientRect(k.pageContainerOuter);Z.endX=Z.rcEnd.left;Z.endY=Z.rcEnd.top;Z.deltaX=Z.startX-Z.endX;Z.deltaY=Z.startY-Z.endY;Z.orgLeft=Z.endX-X.left;Z.orgTop=Z.endY-X.top;Z.aniDeltaX=Z.deltaX;Z.aniDeltaY=Z.deltaY;Z.aniDeltaScale=1-Y;Z.aniPos=0;if(Z.aniFrames===b){Z.aniFrames=K}k.pageContainerInner.style.webkitTransformOrigin=k.pageContainerInner.style.transformOrigin=r.orgLeft+"px "+r.orgTop+"px";B()};var B=function(){var X=x(r.aniPos,r.aniFrames,1,-1);var W=r.scale=1-X*r.aniDeltaScale;r.x=X*r.aniDeltaX;r.y=X*r.aniDeltaY;if(r.aniPos<r.aniFrames){i.init();i.scale(W,W);i.translate(r.x,r.y);i.applyTo(k.pageContainerInner);r.aniPos++;e=requestAnimationFrame(B)}else{L()}};var L=this.stopInPlaceZoomAnimation=function(){if(e!==b){if(!k.bZoomed){a.removeClass(k.pageContainer,"fsi-pages-zoomed")}cancelAnimationFrame(e);e=b;k.pageContainerInner.style.webkitTransformOrigin=k.pageContainerInner.style.transformOrigin="";k.pageContainerInner.style.transform=k.pageContainerInner.style.webkitTransform="";r.aniFrames=K}};this.onPageDoubleClick=function(W){if(f.bOneClickZoom){return}k.clickZoomPage(W)};this.clickZoomPage=function(ac){if(k.bFlipping){return}var Y;var ab;var ae=ac.target;if(!k.bZoomed){while(ae){if(ae._fsiPage!==b){ab=ae._fsiPage;break}ae=ae.parentNode}if(ab){Y={};var ad=ab.oContainer;var X=ad.elContainer;var W=a.getBoundingClientRect(X);var aa,Z;if(ac.FSI_start_x!==b){aa=ac.FSI_start_x;Z=ac.FSI_start_y}else{aa=ac.clientX;Z=ac.clientY}Y.left=aa-W.left;Y.top=Z-W.top;Y.left/=k.dimContainer.width;Y.top/=k.dimContainer.height}k.zoom(true,true,Y)}else{k.zoom(false,true)}};this.toggleZoom=function(W){if(!k.bVisible){return}k.zoom(!k.bZoomed,W)};this.canZoomPage=function(){if(!f.enableZoom){return false}var W=k.getMaxPageDimForContainer();W.width=Math.round(f.fMaxZoom*W.width);W.height=Math.round(f.fMaxZoom*W.height);return(W.width-50>k.dimImage.width)};this.zoom=function(Y,W,Z){if(!f.enableZoom||k.bZoomed===Y){return false}if(k.bFlippEffect){return}if(Y&&!k.canZoomPage()){return}if(Y){a.addClass(k.pageContainer,"fsi-pages-zoomed")}q.showThumbBar(!Y);k.disableActiveLink();if(!k.bVisible){W=false}if(!W){L()}if(Y){f.bQuantizeOrg=f.bQuantize;f.bQuantize=b}else{f.bQuantize=f.bQuantizeOrg}k.bZoomed=Y;q.getMenu().setButtonPressed("ZoomPage",Y);k.stopScrolling();if(e!==b){k.pageContainerInner.style.transform="";r.startX=r.endX+r.x;r.startY=r.endY+r.y;r.startWidth=r.stopWidth*r.scale;r.aniFrames=r.aniPos}else{r.container=k.getCurrentContainer(true);if(r.container){var X=a.getBoundingClientRect(r.container.elContainer);r.startX=X.left;r.startY=X.top;r.startWidth=k.wItem-k.containerMargins.left-k.containerMargins.right}}if(!Y){if(k.touchHandler&&!a.isInternetExplorer){k.touchHandler.setAllowedPanDirection(k.touchOptions.panDirectionAllowed)}if(k.bVertical){k.pageContainer.scrollLeft=0;k.pageContainerOuter.style.width="100%"}else{k.pageContainer.scrollTop=0;k.pageContainerOuter.style.height="100%"}}else{if(k.touchHandler&&!a.isInternetExplorer){k.touchHandler.setAllowedPanDirection("")}}k.updatePageSize();k.centerContent();k.centerCurrentPage(false);if(k.updateFlipContainerPos){k.updateFlipContainerPos()}if(Y&&Z!==b){r.focusX=Z.left*k.dimContainer.width-k.pageContainer.offsetWidth/2+k.containerMargins.left;r.focusY=Z.top*k.dimContainer.height-k.pageContainer.offsetHeight/2+k.containerMargins.top;r.focusX=Math.max(k.containerMargins.left,Math.min(k.dimContainer.width-k.pageContainer.offsetWidth+k.containerMargins.left,r.focusX));r.focusY=Math.max(+k.containerMargins.top,Math.min(k.dimContainer.height-k.pageContainer.offsetHeight+k.containerMargins.top,r.focusY))}else{if(Y){r.focusX=k.containerMargins.left;if(k.bGroupDoublePages&&k.nCurrentPage===q.getFrontCoverIndex()){r.focusX+=k.wItem/2}r.focusY=k.containerMargins.top}else{r.focusX=r.focusY=0}}if(Y){q.iCallbacks.run("onPageZoomed",[k.nCurrentPage])}Q(W);if(k.showDropShadow&&k.bGroupDoublePages){if(!Y){k.repositionDropShadow()}k.showDropShadow(!Y)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageLayoutGrid!==b){return}a.PageLayoutGrid=function(ad,az,W,aE,g){a.PageLayout.prototype.constructor.call(this,ad,az,W,aE,g);var ay=this;ay._strClassName="FSI.PageLayoutGrid";var t=ay.debug;var aD,al;var aI,d;var G={};var f,o;var S;var p;var av;var O;var at;var ab;var K=0;var D;var aC={};var aw=a.Easing.easeOutCubic;var ao;var C=ay.bVertical;var ag;var N;var j=0;var X;ay.containerPaddingX=ay.containerPaddingY=0;var am,ai;var q;var Z={x:0,y:0};var i=false;var l;var ac=ay.oVisibleRange;var F={};var B=-1;var n=(ay.bGroupDoublePages)?2:1;var V=0;var R=0;var A=false;var v=ay.bAutoPageSize;ay.containerMargins={};var L=(g.nScrollAnimationFrames!==b)?g.nScrollAnimationFrames:30;var an=(g.nCreateAhead!==b)?g.nCreateAhead+1:2;var aN=an-1;var ap,I;var h;var au=g.trackCurrentPageWhileScrolling;var ak=g.bAutoSelectCurrentPage;var aP;var aa=0;var aL=(a.isMobileDevice)?1:2;var k=false;var aJ=false;var aB;ay.bUseAfterTouch=true;ay.bScrollEventHandler=true;var aR;var z=true;if(a.isMobileDevice){L=Math.max(1,Math.ceil(L/2))}if(!v){if(typeof(g.thumbWidth)!="number"||g.thumbWidth<1){g.thumbWidth=120}if(typeof(g.thumbHeight)!="number"||g.thumbHeight<1){g.thumbHeight=120}}var aq=this.destroy;this.destroy=function(){if(l!==b){clearTimeout(l)}az.getMenu().setButtonPressed("ZoomPage",false);if(g.bMainLayout&&g.enableZoom){a.removeEvent(ay.pageContainer,"dblclick",ay.onPageDoubleClick)}if(aR!==b){a.removeCustomEvent(ay.pageContainer,"FSIMouseWheel",ay.onMouseWheel);aR=b}if(ay.bScrollEventHandler&&ay.pageContainer.style!==b){a.removeEvent(ay.pageContainer,"scroll",aH)}if(q){q.destroy();q=b}c();aq.apply(ay,arguments)};if(typeof(g.onCurrentPageChange)=="function"){am=g.onCurrentPageChange}else{am=false}if(typeof(g.onSelectedPageChange)=="function"){ai=g.onSelectedPageChange}else{ai=false}this.getMaxPageDim=function(aS){var a0,aX,aY;if(aS===b){aS=n}else{aY=true}if(v){var aW=ad.getPageContainerDim();if(aS===2&&ay.divDropShadow){ay.containerPaddingX=ay.fDropSchadowDistance*0.027*aW.width;ay.containerPaddingY=ay.fDropSchadowDistance*0.025*aW.height}else{ay.containerPaddingX=ay.containerPaddingY=0}var aV=aW.width-ay.containerPaddingX;var aZ=aW.height-1.7*ay.containerPaddingY;if(aS===2){a0=aV/2}else{a0=aV}aX=aZ;if(ay.containerMarginsInitial!==b){a0-=Math.floor((ay.dimContainer.width-ay.clientDimContainer.width)/aS);aX-=Math.floor(ay.dimContainer.height-ay.clientDimContainer.height);var aU=ay.containerMarginsInitial.left+ay.containerMarginsInitial.right;var aT=ay.containerMarginsInitial.top+ay.containerMarginsInitial.bottom;if(ay.nShowNeighbourPages>0){if(ay.bVertical){aT=Math.max(ay.nOuterMargin,aT)}else{aU=Math.max(ay.nOuterMargin,aU)}}a0-=Math.floor(aU/aS);aX-=Math.floor(aT);if(ay.nShowNeighbourPages){if(C){aX-=2*ay.nShowNeighbourPages+ay.containerMarginsInitial.top+ay.containerMarginsInitial.bottom;aX-=aT}else{a0-=2*ay.nShowNeighbourPages;a0-=aU}}}if(ay.dimContainer.width>0){if(!aY){aK()}}}else{a0=g.thumbWidth;aX=g.thumbHeight;if(!aY){aK()}}return{width:Math.floor(a0),height:Math.floor(aX)}};this.handlePointerDown=function(aS,aT){if(az.iChapters){az.iChapters.show(false)}az.onUserAction();if(aB){aB=b}i=true;ay.stopInPlaceZoomAnimation();c();Z.x=ay.pageContainer.scrollLeft;Z.y=ay.pageContainer.scrollTop;Z.xTouch=aT.x;Z.yTouch=aT.y;return true};this.handlePointerUp=function(aS,aT){if(ay.isFlipping()){return}az.onUserAction();if(aS._FSI_Click&&aS.type!=="touchstart"&&aS.type!=="mousedown"){aF(aS)}i=false};var ah=function(aS){if(g.bQuantize){aS=Math.round(aS/aD)*aD}return aS};var af=function(aS){if(g.bQuantize){aS=Math.round(aS/al)*al}return aS};var w=function(aS){if(D===b){ay.bFlipping=false}if(!ay.bZoomed&&aS!==0){e(ay.getCurrentPage(true),(aS>5))}};this.onAfterTouchEnd=function(){ay.bFlipping=false};this.modifyAfterTouchTarget=function(aV){var aU;if(C){aU=aV.y-Z.yTouch;if(!ay.bZoomed&&Math.abs(aU)<15){w(Math.abs(aU));return false}var aS=Z.y-aU-R;aS=af(aS)+R;aS=s(aS,1);aV.y=Z.y-aS+Z.yTouch}else{aU=aV.x-Z.xTouch;if(!ay.bZoomed&&Math.abs(aU)<15){w(Math.abs(aU));return false}var aT=Z.x-aU-R;aT=ah(aT)+R;aT=U(aT,1);aV.x=Z.x-aT+Z.xTouch}return aV};this.handlePointerMove=function(aT,aV){if(k||!aT||!z){if(aT){aT.FSI_allowEventDefault=true}return}var aU=Math.abs(aV.x-aT.FSI_start_x);var aS=Math.abs(aV.y-aT.FSI_start_y);if(!ay.bZoomed){if(C){if(1.5*aS<aU){aT.FSI_allowEventDefault=true}}else{if(1.5*aU<aS){aT.FSI_allowEventDefault=true}}if(aT&&ay.bScrollEventHandler){if(C){Z.yTarget=Z.y+aT.FSI_start_y-aV.y}else{Z.xTarget=Z.x+aT.FSI_start_x-aV.x}ay.bFlipping=true;if(!D){D=requestAnimationFrame(aQ)}}}else{Z.yTarget=Z.y+aT.FSI_start_y-aV.y;Z.xTarget=Z.x+aT.FSI_start_x-aV.x;if(!D){D=requestAnimationFrame(ar)}}};var ar=function(){ay.pageContainer.scrollTop=Z.yTarget;ay.pageContainer.scrollLeft=Z.xTarget;D=b};var aQ=function(){if(C){ay.pageContainer.scrollTop=Z.yTarget}else{ay.pageContainer.scrollLeft=Z.xTarget}D=b};this.initLayout=function(){aP=(C)?"scrollTop":"scrollLeft";ay.pageContainerOuter=document.createElement("div");a.addClass(ay.pageContainerOuter,"fsi-pages-page-container-outer");ay.pageContainer.appendChild(ay.pageContainerOuter);if(C){ay.pageContainerOuter.style.width="100%"}else{ay.pageContainerOuter.style.height="100%"}ay.pageContainerInner=document.createElement("div");a.addClass(ay.pageContainerInner,"fsi-pages-page-container-inner");ay.pageContainerOuter.appendChild(ay.pageContainerInner);if(C){a.addClass(ay.pageContainer,"fsi-pages-layout-grid-vert");ag=ay.getFirstItemVert}else{a.addClass(ay.pageContainer,"fsi-pages-layout-grid-horz");ag=ay.getFirstItemHorz}ao=ay.touchOptions={};ao.detectGestures=false;ao.bAllowMouseDown=true;ao.afterTouch={enabled:true};if(g.bMainLayout){ao.afterTouch.factorAmount=10;ao.afterTouch.factorAmountQuad=20;ao.afterTouch.factorFrames=(a.isMobileDevice)?0.4:1.1;ao.afterTouch.minDelta=0}else{ao.afterTouch.factorAmount=13;ao.afterTouch.factorAmountQuad=30;ao.afterTouch.factorFrames=1.25;ao.afterTouch.minDelta=0}ao.afterTouch.minFrames=0;ao.afterTouch.useAnimationFrame=true;ao.afterTouch.modifyTarget=ay.modifyAfterTouchTarget;ao.onAfterTouchEnd=ay.onAfterTouchEnd;ao.nClickRadius=30;ao.detectClick=true;if(!a.isInternetExplorer){if(C&&!ay.bFlipLayout){ao.panDirectionAllowed="pan-x"}else{ao.panDirectionAllowed="pan-y"}}q=ay.touchHandler=new a.TouchHandler(ay.pageContainerOuter,ao,ay.handlePointerDown,ay.handlePointerMove,ay.handlePointerUp);ax();if(az.cfgBool("mousewheelnavigation",true)){var aV=aR=a.addCustomEvent(ay.pageContainer,"FSIMouseWheel",ay.onMouseWheel);a.setCustomEventListenerProperty(aV,"acceleration",1.22);a.setCustomEventListenerProperty(aV,"accelerationMax",25)}var aW=Math.max(ay.nMinPageIndex,Math.min(ay.nMaxPageIndex,g.initialPageIndex));if(isNaN(aW)){aW=ay.nMinPage}var aU=ay.createPageContainerForPage(aW);if(!aU){return}aU.show();ac.start=aU.nIndex;ac.end=aU.nIndex;ac.nVisible=1;ay.updateContainerDim();ay.containerMarginsInitial=a.utils.cloneObject(ay.containerMargins);if(!v){var aT=ay.containerMargins.left+ay.containerMargins.right+ay.dimContainer.width;var aS=ay.containerMargins.top+ay.containerMargins.bottom+ay.dimContainer.height;g.thumbWidth=Math.max(2,Math.min(g.thumbWidth,Math.floor(g.elContainer.clientWidth/n)-aT));g.thumbHeight=Math.max(2,Math.min(g.thumbHeight,Math.floor(g.elContainer.clientHeight)-aS))}ay.updatePageSize(true);ay.onResize();if(ay.bScrollEventHandler){a.addEvent(ay.pageContainer,"scroll",aH)}if(g.bMainLayout&&g.enableZoom){a.addEvent(ay.pageContainer,"dblclick",ay.onPageDoubleClick)}ay.bHasPages=true;H();if(g.bSelectFirstPage){y(aW)}var aX=aW;if(C){aX-=Math.floor(p/2)}r(aX,false,true);ay.pageContainer.style.visibility="true";aA(true)};this.enableScroll=function(aS){z=aS};var ax=function(){k=(ay.nDocumentScale>=1.5);q.setCapture(!k,false)};this.onStartDocumentZoom=function(){aJ=true;u(true);ay.disableActiveLink();q.enable(false);k=true;Q(false,false)};var ae=this.onAfterDocumentZoom;this.onAfterDocumentZoom=function(aS){if(q.getPointerCount()>1){return}aJ=false;var aT=(az.bUseDevicePixelRatio)?aS.FSI_scale_with_pixel_ratio:aS.FSI_scale;aT=az.roundDocumentScale(aT);if(aT!==ay.nDocumentScalePixelRatio){ay.nDocumentScalePixelRatio=aT;ay.nDocumentScale=az.roundDocumentScale(aS.FSI_scale);ay.resetCropCache();ay.updateImagesOfVisiblePages()}q.enable(true);ax();Q(false,false);u(true);ae.apply(ay,arguments)};var U=function(aT,aS){return Math.max(aS*R,Math.min(Math.round(ay.pageContainer.scrollWidth-G.width-aS*R),aT))};var s=function(aT,aS){return Math.max(aS*R,Math.min(Math.round(ay.pageContainer.scrollHeight-G.height-aS*R),aT))};this.getScrollTarget=function(aS){var aT;if(C){aT=Math.floor(Math.floor(aS/S)*al+R);aT=s(aT,1)}else{aT=Math.floor(Math.floor(aS/S)*aD+R);aT=U(aT,1)}return aT};this.getCurrentPage=function(aU){if(!aU||!ay.bLayoutVisible){return ay.nCurrentPage}var aT,aS;var aV;if(C){aV=Math.min(0,G.height-al)/2;aS=Math.round((ay.pageContainer.scrollTop-R+aV)/al)*S}else{aV=Math.min(0,G.width-aD)/2;aS=Math.round((ay.pageContainer.scrollLeft-R+aV)/aD)*S}if(ay.bGroupDoublePages){aT=2*aS}else{aT=aS}aT=Math.max(ay.nMinPage,Math.min(ay.nMaxPage,aT));return aT};var y=this.setSelectedPage=function(aS){var aT=ay.getContainerIndexFromPage(aS);if(X!==aT){if(X!==b){a.removeClass(ay.arContainers[X].elContainer,"selected")}if(ay.arContainers[aT]===b){x(aT)}a.addClass(ay.arContainers[aT].elContainer,"selected");X=aT}if(ai){ai.apply(ay,[aS])}};var r=this.gotoPage=function(aS,aT,aU){if(aT&&ay.bPreventAnimation){aT=false}if(aB){aB=b}if(ay.bZoomed){ay.zoom(false,true)}aS=Math.max(ay.nMinPage,Math.min(ay.nMaxPage,aS));ay.setCurrentPage(aS,"gotoPage");ay.scrollToContainer(ay.getContainerIndexFromPage(aS),aT,aU)};var aM=function(aS){if(ab!==aS){ab=aS;if(am){am.apply(ay,[aS,true])}}};this.setCurrentPage=function(aS){var aT=false;if(ay.nCurrentPage!==aS){aT=true;ay.nCurrentPage=ab=aS;if(ak){y(aS)}if(am){am.apply(ay,[aS])}if(g.bMainLayout){if(l!==b){clearTimeout(l)}l=setTimeout(E,350)}}return aT};var E=function(){l=b;if(g.enableZoom&&!ay.bZoomed){az.getMenu().enableButton("ZoomPage",ay.canZoomPage())}};ay.isPageInCurrentContainer=function(aU){var aT=false;var aS=ay.getCurrentContainer();if(aS){if(aS.iPage1&&aS.iPage1.nIndex===aU){aT=aS.iPage1}else{if(aS.iPage2&&aS.iPage2.nIndex===aU){aT=aS.iPage2}}}return aT};this.gotoPageAndZoom=function(aU,aT){var aW=ay.isPageInCurrentContainer(aU);if(aW){var aS=aE.viewStringToArray(aT);var aV=new a.Rect(aS[2],aS[3],aS[4],aS[5]);aV.normalizeRect();if(aW&&aW.iSiblingPage){aV.scaleRectXY(0.5,1);if(aW.iSiblingPage.nIndex<aW.nIndex){aV.offsetRect(0.5,0)}}var aX={};aX.left=aV.left+aV.width()/2;aX.top=aV.top+aV.height()/2;if(ay.bZoomed){ay.zoom(false,true)}ay.zoom(true,true,aX)}else{r(aU,true);aB=arguments}};this.scrollToContainer=function(aS,aV,aX){var aU=ay.getScrollTarget(aS);if(g.bLazyScroll&&!aX){var aT=aD*aS;var aW=ay.pageContainer.scrollLeft-ay.scrollOffsetStart;if(aT<aW||aT+aD>aW+G.width){if(aT<ay.pageContainer.scrollLeft){aU=aT-G.width+aD}else{aU=aT}aU=ah(aU+aa)-aa+ay.scrollOffsetStart;aU=U(aU,1)}else{return}}aU=Math.floor(aU);if(aU!==ay.pageContainer[aP]){u();if(!aV){if(C){ay.pageContainer.scrollTop=aU}else{ay.pageContainer.scrollLeft=aU}}else{aj(aU)}}};var e=ay.scrollToPage=function(aS,aU,aV){aS=Math.max(ay.nMinPage,Math.min(ay.nMaxPage,aS));var aT=ay.getContainerIndexFromPage(aS);ay.scrollToContainer(aT,aU,aV)};var c=function(aS){if(D){cancelAnimationFrame(D);D=b;ay.bFlipping=false;if(aS){if(C){ay.pageContainer.scrollTop=aC.end}else{ay.pageContainer.scrollLeft=aC.end}}}};var aj=function(aT,aS){c(aS);aT=Math.floor(aT);aC.prop=(C)?"scrollTop":"scrollLeft";var aU=aT-ay.pageContainer[aC.prop];if(C){if(aT===ay.pageContainer.scrollTop){return}if(Math.abs(aU)>aL*al){if(aU>0){ay.pageContainer.scrollTop=aT-aL*al}else{ay.pageContainer.scrollTop=aT+aL*al}}}else{if(aT===ay.pageContainer.scrollLeft){return}if(Math.abs(aU)>aL*aD){if(aU>0){ay.pageContainer.scrollLeft=aT-aL*aD}else{ay.pageContainer.scrollLeft=aT+aL*aD}}}aC.pos=1;aC.frames=L;aC.start=ay.pageContainer[aC.prop];aC.end=aT;aC.delta=aT-aC.start;if(aC.end!==aC.start){au=false;J(true);D=requestAnimationFrame(Y);ay.bFlipping=true}};var Y=function(){ay.pageContainer[aC.prop]=aw(aC.pos++,aC.frames,aC.start,aC.delta);if(aC.pos<=aC.frames){D=requestAnimationFrame(Y)}else{D=b;ay.bFlipping=false;ay.doAfterGotoPageFinished()}};var aG=function(aS){return ay.getTargetPage(ay.nCurrentPage+aS)};var M=function(aT){if(!aT){return}var aS=aG(aT);var aU=!(aS===ay.nCurrentPage);r(aS,true,true);return aU};this.nextPage=function(){var aS=(ay.bGroupDoublePages)?2*S:S;M(aS)};this.previousPage=function(){var aS=(ay.bGroupDoublePages)?2*S:S;M(-aS)};this.firstPage=function(){M(-ay.nMaxPage)};this.lastPage=function(){M(ay.nMaxPage)};var aF=function(aS){var aU;if(ay.bZoomed){if(g.bOneClickZoom){aU=ay.getPageInstanceFromChildElement(aS.target);if(aU){var aT=aU.getLinksInstance();if(!aT||aT.noActiveArea()){ay.toggleZoom(true)}}}return}if(typeof(g.onPageClick)!="function"){return}aU=ay.getPageInstanceFromChildElement(aS.target);if(aU&&aU.bRealPage){g.onPageClick.apply(ad,[aU,aS])}};this.doAfterGotoPageFinished=function(){if(aB){ay.gotoPageAndZoom.apply(ay,aB);aB=b}};var u=this.stopScrolling=function(aS){c(aS);if(q){q.cancelAfterTouch()}i=false;ay.cancelScrollEndCheck()};this.cancelScrolling=function(aS){u();ay.setCurrentPage(ay.getCurrentPage(true),"cancelScrolling");Q(aS)};this.onBeforeResize=function(){if(ay.bResizing){return}if(!ay.bResizing){ay.stopInPlaceZoomAnimation();u()}};this.onAfterResize=function(aS){if(aS&&!aS.FSI_after_treshold){return}if(ay.bHasPages){u();ay.updateContainerDim();if(h!==b){e(h,false,true,false)}else{Q(false)}ay.centerContent();aA();if(ay.repositionDropShadow){ay.repositionDropShadow()}}};var P=this.show;this.show=function(aS){P.apply(ay,arguments);if(!aS){aA()}};var m=this.updatePageSize;this.updatePageSize=function(aT){var aU=m.apply(ay,arguments);if(!ay.bHasPages){return aU}if(aU){ay.resetCropCache();if(!ay.bDefinesPageSizeByCSS){for(var aS=ay.nMinPageIndex;aS<ay.nMaxPageIndex;aS++){ay.arPages[aS].setSize(ay.dimImage.width,ay.dimImage.height)}}G={};ay.updateContainerDim();ay.updateImagesOfVisiblePages()}return aU};this.resetCenterContent=function(){if(g.bCenterContent){if(ay.bVertical){ay.pageContainer.style.paddingRight=ay.pageContainer.style.paddingLeft="0px"}else{ay.pageContainer.style.paddingBottom=ay.pageContainer.style.paddingTop="0px"}}};this.centerContent=function(){var aU;var aT;if(g.bCenterContent){if(ay.bVertical){aT=aD*ay.nColumnsPerRow;aU=Math.max(0,Math.round((ay.pageContainerInner.offsetWidth-aT)/2));ay.pageContainerOuter.style.paddingRight="0";ay.pageContainerOuter.style.paddingLeft=aU+"px"}else{aT=al*ay.nColumnsPerRow;aU=Math.max(0,Math.round((ay.pageContainerInner.offsetHeight-aT)/2));if(g.bMainLayout){ay.pageContainerOuter.style.paddingTop="0";var aS=a.getBoundingClientRect(ay.pageContainerOuter);if(aS.height>ay.pageContainerInner.offsetHeight){aU+=Math.floor((aS.height-ay.pageContainerInner.offsetHeight)/2)}}ay.pageContainerOuterStylePaddingTop=aU;ay.pageContainerOuter.style.paddingBottom="0";ay.pageContainerOuter.style.paddingTop=aU+"px"}}};var H=function(){G={};ay.updateContainerDim()};var aK=function(){if(A){return}A=true;ay.pageContainer.style.visibility="visible"};this.updateContainerDim=function(){var a1,aZ,aU,aT;var a0=ay.arContainers[ac.start];if(!a0){t.error("ERROR updateContainerDim container undefined");return}var aV=a0.elContainer;if(!aV){t.error("ERROR updateContainerDim container element undefined");return}if(!aV.parentNode){t.error("ERROR updateContainerDim container not in DOM");return}var aS=a0.nIndex;var aW=((aS===ay.nFrontCoverContainerIndex||aS===ay.nBackCoverContainerIndex)&&!a.hasClass(aV,"fsi-pages-page-border"));if(aW){a.addClass(aV,"fsi-pages-page-border");if(a0.iPage1){aU=a0.iPage1.getContainer();a1=aU.className;a.removeClass(aU,"fsi-pages-page-border")}if(a0.iPage2){aT=a0.iPage2.getContainer();aZ=aT.className;a.removeClass(aT,"fsi-pages-page-border")}}ay.containerMargins=a.utils.getElementMargins(aV);ay.dimContainer={width:aV.offsetWidth,height:aV.offsetHeight};ay.clientDimContainer={width:aV.clientWidth,height:aV.clientHeight};var aX=ay.containerMargins;aD=ay.wItem=ay.dimContainer.width+aX.left+aX.right;al=ay.hItem=ay.dimContainer.height+aX.top+aX.bottom;G.width=ay.pageContainer.clientWidth;G.height=ay.pageContainer.clientHeight;O=a.utils.getElementPaddings(ay.pageContainer);f=O.top;o=O.left;aI=ay.pageContainer.clientWidth-O.left-O.right;d=ay.pageContainer.clientHeight-O.top-O.bottom;ay.nScrollOver=0;ay.scrollOffsetStart=ay.scrollOffsetEnd=0;ay.calcColumnsAndRows(C);if(C){B=-n*S;if(!ay.bZoomed&&g.alignMode===1){ay.scrollOffsetStart=Math.round((d-al)/2)}}else{B=-n*S;if(!ay.bZoomed&&g.alignMode===1){ay.scrollOffsetStart=Math.round((aI-aD)/2)}}ay.scrollOffsetEnd=ay.scrollOffsetStart;R=Math.ceil(ay.nScrollOver);ay.scrollOffsetStart+=R;ay.scrollOffsetEnd+=R;V=ay.scrollOffsetStart+ay.scrollOffsetEnd;switch(g.alignMode){case 1:aa=aI/2+aD/2;break;default:aa=0}at=b;var aY;if(C){aY=Math.ceil(ay.nLayoutContainers/S)*al;if(!ay.bFlipLayout&&V){aY=Math.max(ay.pageContainer.clientHeight,aY)}ay.pageContainerOuter.style.height=(V+aY)+"px"}else{aY=Math.ceil(ay.nLayoutContainers/S)*aD;if(!ay.bFlipLayout&&V){aY=Math.max(ay.pageContainer.clientWidth,aY)}ay.pageContainerOuter.style.width=(V+aY)+"px"}ay.updateScrollOffset(ac.start,ac.end);if(ay.bZoomed){if(C){ay.pageContainerOuter.style.width=(aX.left+aX.right+ay.dimContainer.width)+"px"}else{ay.pageContainerOuter.style.height=(aX.top+aX.bottom+ay.dimContainer.height)+"px"}}if(aW){if(aU){aU.className=a1}if(aT){aT.className=aZ}a.removeClass(aV,"fsi-pages-page-border")}return true};this.calcColumnsAndRows=function(aS){if(aS){ay.nScrollOver=Math.round(al/2);S=ay.nColumnsPerRow=Math.max(1,Math.floor(aI/aD));av=Math.max(1,Math.ceil(G.height/al));p=(av+1)*S}else{ay.nScrollOver=Math.round(aD/2/n);S=ay.nColumnsPerRow=1;av=Math.max(1,Math.ceil(G.width/aD));p=av*S}ap=Math.ceil(aN*p);ap-=ap%S;I=Math.floor(an*p);I-=I%S+1};this.setColumnsAndRows=function(aW,aT,aU,aV,aS){S=ay.nColumnsPerRow=aW;av=aT;p=aU;ap=aV;I=aS};this.updateScrollOffset=function(aS){if(C){ay.pageContainerInner.style.paddingTop=(ay.scrollOffsetStart+Math.floor(aS/S)*al)+"px"}else{ay.pageContainerInner.style.paddingLeft=(ay.scrollOffsetStart+Math.floor(aS/S)*aD)+"px"}};this.getFirstItemVert=function(){var aS=ay.pageContainer.scrollTop-R;return Math.max(0,Math.floor(aS/al))*S};this.getFirstItemHorz=function(){var aS=ay.pageContainer.scrollLeft-R;return Math.max(0,Math.floor(aS/aD))*S};var x=function(aT){var aS=(ay.bGroupDoublePages)?ay.createPageContainerForPage(2*aT):ay.createPageContainerForPage(aT);if(!aS){t.error("FAILED TO CREATE CONTAINER: "+aT)}return aS};var T=function(aT,aU){var aS=ay.arContainers[aT];if(!aS){aS=x(aT)}aS.show(aU)};this.removeAllContainers=function(){for(var aS=ac.start;aS<=ac.end;aS++){ay.arContainers[aS].hide()}ac.start=ac.end=-1};var aA=this.updateVisiblePageRange=function(aT){if(!ay.bLayoutVisible||ay.bResizing){return}var aS;var aU;var aV=ag();if(at===aV&&!aT){return}at=aV;F.start=ac.start;F.end=ac.end;ac.start=Math.max(0,aV-ap);ac.end=Math.min(ay.nContainers-1,aV+I);if(ac.start===F.start&&ac.end===F.end&&!aT){return}ac.nVisible=ac.end-ac.start+1;ay.resetLoadContent();if(ac.start>F.end||ac.end<F.start){if(F.start>-1){for(aS=F.start;aS<=F.end;aS++){ay.arContainers[aS].hide()}}for(aS=ac.start;aS<=ac.end;aS++){T(aS)}}else{if(ac.start!==F.start){if(ac.start>F.start){for(aS=F.start;aS<ac.start;aS++){ay.arContainers[aS].hide()}}else{aU=ay.arContainers[F.start];for(aS=ac.start;aS<F.start;aS++){T(aS,aU)}}}if(ac.end!==F.end){if(ac.end<F.end){for(aS=ac.end+1;aS<=F.end;aS++){ay.arContainers[aS].hide()}}else{for(aS=F.end+1;aS<=ac.end;aS++){T(aS)}}}}ay.updateScrollOffset(ac.start,ac.end);ay.startLoadingContent(ac.start,ac.end)};var Q=this.centerCurrentPage=function(aS,aU){var aT=ay.getCurrentPage(aU);if(ay.bVisible&&D===b){e(aT,aS,true)}};this.onMouseWheel=function(aS){az.onUserAction();var aT=(a.isMac)?aS.FSI_normalized_delta:aS.FSI_normalized_accelerated_delta;if(a.isChrome){setTimeout(function(){M(Math.round(aT*B))},0)}else{M(Math.round(aT*B))}if(aS.preventDefault){aS.preventDefault()}};this.cancelScrollEndCheck=function(){if(N){clearInterval(N);N=b}if(ay.bScrolling){ay.bScrolling=false;ay.restoreActiveLinkState()}};this.saveScrollPos=function(){ay.nStoredScrollPosX=ay.pageContainer.scrollLeft;ay.nStoredScrollPosY=ay.pageContainer.scrollTop};this.restoreScrollPos=function(){ay.pageContainer.scrollLeft=ay.nStoredScrollPosX;ay.pageContainer.scrollTop=ay.nStoredScrollPosY};var aO=function(){K++;aA();if(au&&K%4===0){aM(ay.getCurrentPage(true))}if(D!==b||i||j++<1){return}ay.setCurrentPage(ay.getCurrentPage(true),"scrollEnd");au=g.trackCurrentPageWhileScrolling;if(g.bScrollToCurrentTopPageAfterResize){h=ay.getCurrentPage(true)}ay.cancelScrollEndCheck();if(ay.bHasScrollBar){var aT=ay.pageContainer.scrollTop;var aS;if(C){aS=s(aT,1)}else{if(C){aS=U(aT,1)}}if(aT!==aS){aj(aS)}}};var J=function(){if(aJ){return}if(!ay.bScrolling){if(!N){K=0;ay.deactivateActiveLink();N=setInterval(aO,150)}ay.bScrolling=true}};var aH=function(){if(aJ){return}if(!ay.bScrolling){J()}j=0}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageLayoutFlip!==b){return}a.PageLayoutFlip=function(d,s,ac,D,i){i=this.oOptions=(typeof(i)=="object")?i:{};i.bHorizontal=true;i.bOnePageInView=false;a.PageLayoutGrid.prototype.constructor.call(this,d,s,ac,D,i);var o=this;o._strClassName="FSI.PageLayoutFlip";var f;var x;var K;var J=true;var w,af,B;var u,ad;o.bUseAfterTouch=false;o.bScrollEventHandler=false;o.bFlipLayout=true;var N=0;var h;var y;var O;var T=false;var G;var ab;var Z={};o.strPageContainerClass="fsi-pages-flip";var Y;var t=o.bGroupDoublePages;var E;var aj,p,l;var M;var H=false;var F=this.init;this.init=function(){M=d.getConfigInt("NoEdgeFlipBelowWidth",0);a.addEvent(s.getRootContainer(),"contextmenu",I);Y=(t)?2:1;var am={};am.onFlipFinish=o.onFlipFinish;am.svgTemplate=s.svgTemplateWithRect.cloneNode(true);am.bDoublePages=t;if(a.isInternetExplorer&&s.cfgBool("FixEdgeTransformFlicker",true)){am.bFixEdgeTransformFlicker=true}var ak=(i.bMainLayout&&i.dropShadow);if(ak){o.divDropShadow=aj=document.createElement("div");if(!isNaN(i.dropShadowOpacity)){aj.style.opacity=i.dropShadowOpacity}aj.bVisible=true;if(!isNaN(i.dropShadowDistance)){o.fDropSchadowDistance=2*i.dropShadowDistance}else{o.fDropSchadowDistance=1}aj.className="fsi-pages-drop-shadow-container";p=document.createElement("div");p.bVisible=true;p.className="fsi-pages-drop-shadow fsi-pages-drop-shadow-left";aj.appendChild(p);l=p.cloneNode(false);l.bVisible=true;l.className="fsi-pages-drop-shadow fsi-pages-drop-shadow-right";aj.appendChild(l)}f=new a.FlipEffect(d,s,o,am);F.apply(o,arguments);if(ak){o.pageContainer.insertBefore(aj,o.pageContainer.firstChild);S();e()}else{if(aj){aj.parentNode.removeChild(aj)}o.divDropShadow=aj=b}f.appendTo(o.pageContainerInner);var al=f.getContainerElement();al.style.position="absolute";al.style.zIndex="3";o.updateFlipContainerPos();a.addEvent(o.pageContainerInner,"mousemove",j);ah()};var v=this.initLayout;this.initLayout=function(){v.apply(o,arguments);if(!t){o.loadContainerContent(o.getContainerForPage(-1))}};var W=this.destroy;this.destroy=function(){a.removeEvent(s.getRootContainer(),"contextmenu",I);aa();n();X();W.apply(o,arguments);f.destroy();a.removeEvent(o.pageContainerInner,"mousemove",j)};this.setLayoutContainers=function(){o.nLayoutContainers=1};this.cancelScrollEndCheck=function(){};var k=this.hide;this.hide=function(ak){if(!k.apply(o,arguments)){return}R()};this.calcColumnsAndRows=function(){o.setColumnsAndRows(1,1,1,0,0)};this.updateScrollOffset=function(){if(o.bVertical){o.pageContainerInner.style.paddingTop=o.scrollOffsetStart+"px"}else{o.pageContainerInner.style.paddingLeft=o.scrollOffsetStart+"px"}};var V=this.setCurrentPage;this.setCurrentPage=function(al,ak){x=o.nCurrentPage;V.apply(o,arguments);h=o.getCurrentContainer();e();c()};this.getCurrentPage=function(){return o.nCurrentPage};this.getFirstItemHorz=this.getFirstItemVert=function(){return o.getContainerIndexFromPage(o.nCurrentPage)};this.scrollToContainer=function(ak,al){if(o.bResizing){return}n();X();if(x!==o.nCurrentPage){R();o.updateVisiblePageRange();if(al){var am=L(x,o.nCurrentPage);if(am!==b){var ap;var an=s.getCommandRepeatCount();var ao=false;if(an||N){ao=true;ap=14}ab=true;if(am){f.flip(2,ap,ao)}else{f.flip(0,ap,ao)}}}}};var r=this.onBeforeResize;this.onBeforeResize=function(){var ak=r.apply(o,arguments);if(!o.bResizing){R()}return ak};var q=this.onResize;this.onResize=function(al){var ak=q.apply(o,arguments);J=true;if(al&&al.FSI_after_treshold){o.updateFlipContainerPos();ah()}return ak};var ah=function(){if(M<1){return}H=(K<M)};o.showDropShadow=function(ak){if(!aj||ak===aj.bVisible){return}aj.bVisible=ak;if(ak){aj.style.display=""}else{aj.style.display="none"}};var e=function(am,ak){if(!aj||!t){return}if(!am){am=h}var an,al;if(t){an=(am&&am.iPage1&&am.iPage1.bRealPage);al=(am&&am.iPage2&&am.iPage2.bRealPage);if(ak){am=ak;an=(an&&am&&am.iPage1&&am.iPage1.bRealPage);al=(al&&am&&am.iPage2&&am.iPage2.bRealPage)}}if(an!==p.bVisible){p.bVisible=an;p.style.display=(an)?"":"none"}if(al!==l.bVisible){l.bVisible=al;l.style.display=(al)?"":"none"}};var S=o.repositionDropShadow=function(){if(o.bZoomed||!aj){return}if(!t){return o.showDropShadow(false)}aj.style.width=(o.containerPaddingX+o.dimContainer.width)+"px";aj.style.height=(0.7*o.containerPaddingY+o.dimContainer.height)+"px";aj.style.left=(o.containerMargins.left+o.scrollOffsetStart-o.containerPaddingX/2)+"px";aj.style.top=(o.containerMargins.top+o.pageContainerOuterStylePaddingTop+0.3*o.containerPaddingY)+"px"};var g=this.updateContainerDim;this.updateContainerDim=function(){var ak=g.apply(o,arguments);if(ak){J=true;K=(o.bGroupDoublePages)?o.dimContainer.width/2:o.dimContainer.width;f.setPageSize(K,o.dimContainer.height)}return ak};this.onFlipFinish=function(al,ak){N=0;X();Q();R();if(al&&!ak){o.setCurrentPage(o.flipPointerTargetPage,"AfterMouseFlip");o.updateVisiblePageRange()}o.doAfterGotoPageFinished()};var U=function(ak){if(ak.bCloned){ak.unCloneDomElements()}ak.elContainer.style.visibility=""};var P=function(ak){ak.elContainer.style.visibility="hidden";o.loadContainerContent(ak)};var R=function(){if(!o.bFlipping){return}a.removeClass(o.pageContainer,"fsi-pages-flipping");ab=false;o.bFlipEffectDrag=false;f.cancel();o.bFlipping=false;o.pageContainer.parentNode.style.zIndex="";o.pageContainer.parentNode.style.position="";var ak;ak=w;if(ak){U(ak);w=b}ak=af;if(ak){U(ak);af=b}if(B){U(B);B=b}f.removeContent();f.resetTransform();e()};var L=function(ak,aq){if(ak===b){return}if(o.bFlipping){R()}o.bFlipping=true;o.deactivateActiveLink();a.addClass(o.pageContainer,"fsi-pages-flipping");if(o.bGroupDoublePages){ak=o.getTargetPage(ak);aq=o.getTargetPage(aq)}if(ak===aq){return}o.updateFlipContainerPos();var ao=(ak<aq);o.pageContainer.parentNode.style.zIndex=800;o.pageContainer.parentNode.style.position="absolute";if(t){w=o.getContainerForPage(ak);u=w.cloneDomElements();var an=w.cloneDomElements();P(w);af=o.getContainerForPage(aq);ad=af.cloneDomElements();var am=af.cloneDomElements();P(af);if(ao){f.elFlipTopContent.style.left=(-K)+"px";f.elFlipBottomContent.style.left="0px";f.elTopStaticContent.style.left="0px";f.elBottomStaticContent.style.left=(-K)+"px"}else{f.elFlipTopContent.style.left="0px";f.elFlipBottomContent.style.left=(-K)+"px";f.elTopStaticContent.style.left=(-K)+"px";f.elBottomStaticContent.style.left="0px"}f.setContent(an,am,u,ad)}else{f.elFlipTopContent.style.left="0px";f.elFlipBottomContent.style.left="0px";f.elBottomStaticContent.style.left="0px";var al,ar,ap;af=o.getContainerForPage(-1);if(ao){w=o.getContainerForPage(ak);B=o.getContainerForPage(aq)}else{w=o.getContainerForPage(aq);B=o.getContainerForPage(ak)}al=w.cloneDomElements();ar=af.cloneDomElements();ap=B.cloneDomElements();P(af);P(w);P(B);f.setContent(al,ar,null,ap)}if(!G){e(af,w)}return ao};var I=function(ak){if(o.bFlipping){ak.cancelBubble=true;if(ak.stopPropagation){ak.stopPropagation()}if(ak.preventDefault){ak.preventDefault()}return false}};o.updateFlipContainerPos=function(){if(h){f.setPosition(h.elContainer.offsetLeft,h.elContainer.offsetTop,ad)}};var ag=function(an,ar,aq){if(!h||o.bZoomed||H){return false}var ao=a.getBoundingClientRect(h.elContainer);if(ar===b){if(!an){return}ar={x:an.clientX,y:an.clientY}}var am=ar.x-ao.left;var ap=ar.y-ao.top;var al=(am>=0&&ap>=0&&am<=h.elContainer.offsetWidth&&ap<=h.elContainer.offsetHeight);var ak=(an.type==="touchstart"||(an.pointerType&&an.pointerType!=="mouse"))?80:50;if(al){al=(am<ak||am>h.elContainer.offsetWidth-ak)}if(al){if(am<h.elContainer.offsetWidth/2){if(o.nCurrentPage<2){al=false}}else{if(o.nCurrentPage+2>o.nMaxPageIndex){al=false}}}if(al&&aq){if(ap>ak&&ap<h.elContainer.offsetHeight-ak){al=false}}return al};var A=this.handlePointerDown;this.handlePointerDown=function(ak,am){A.apply(o,arguments);if(ab){return}if(f.bFlipFinishing&&o.bFlipping&&f.bPointerFlip){o.onFlipFinish(true,false)}n();X();R();if(!ag(ak,am)){return true}o.bFlipEffectDrag=true;var al=ae(ak,am);o.flipPointerTargetPage=al.nPageTarget;return true};var ae=function(ak,am){var al={};f.handlePointerDown(ak,am);al.nCorner=f.getFlipCorner();al.nPageCurrent=o.getTargetPage(o.nCurrentPage);al.nPageTarget=(al.nCorner>1&&!f.bReverse)?al.nPageCurrent+Y:al.nPageCurrent-Y;L(al.nPageCurrent,al.nPageTarget);return al};var ai=this.handlePointerMove;this.handlePointerMove=function(ak,al){if(o.bFlipEffectDrag){f.handlePointerMove(ak,al)}else{ai.apply(o,arguments);if(ak&&!o.bZoomed){ak.FSI_allowEventDefault=true}}};var m=this.handlePointerUp;this.handlePointerUp=function(ak,al){if(o.bFlipEffectDrag){f.handlePointerUp(ak);if(ak._FSI_Click&&ag(ak,al,true)){if(f.getFlipCorner()>1&&!f.bReverse){o.nextPage()}else{o.previousPage()}return}}o.bFlipEffectDrag=false;m.apply(o,arguments)};this.modifyAfterTouchTarget=function(ak){if(!o.bZoomed){ak=false}return ak};var z=this.onMouseWheel;this.onMouseWheel=function(ak){var al=z.apply(o,arguments);if(al){N++}return al};var n=function(){if(y){clearTimeout(y);y=b}};var j=function(ak){O=ak;if(!o.bFlipEffectDrag&&!ab&&!f.bFlipFinishing){if(T){f.handlePointerMove(O);Q()}else{if(!y){y=setTimeout(Q,200)}}}};var Q=function(){y=b;var am=ag(O,b,true);if(T!==am){if(am){G=true;a.removeEvent(o.pageContainerInner,"mousemove",j);a.addEvent(window,"mousemove",j);R();ae(O);f.setPreliminary(true)}else{X()}T=am}var al=(T||ag(O,b,false));if(al!==E){E=al;var ak=(E)?a.addClass:a.removeClass;ak(o.pageContainerInner,"fsi-pages-page-curl")}};var X=function(){if(!T){return}T=G=false;a.addEvent(o.pageContainerInner,"mousemove",j);a.removeEvent(window,"mousemove",j);f.handlePointerUp(O);f.setPreliminary(false)};var c=function(){if(Z.nInterval===b){Z.nInterval=setInterval(C,250)}Z.count=0;Z.left=Z.right=o.getTargetPage(o.nCurrentPage)};var C=function(){Z.left-=Y;Z.right+=Y;if(Z.left>0){o.loadContainerContent(o.getContainerForPage(Z.left))}if(Z.right<=o.nMaxPageIndex){o.loadContainerContent(o.getContainerForPage(Z.right))}Z.count++;if(Z.count>3){aa()}};var aa=function(){if(Z.nInterval!==b){clearInterval(Z.nInterval);Z.nInterval=b}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageToolTip!==b){return}a.PageToolTip=function(h,e){var l=this;var c;var f=false;var j;var i=a.utils.getCustomEventListenerInstance("FSIViewport");var d=new a.Rect();var m=new a.Rect();var g=new a.Rect();this.destroy=function(){if(!j){return}if(c.parentNode){a.removeChild(c.parentNode,c)}j=false};var k=function(){if(j){return}j=true;c=document.createElement("div");a.addClass(c,"fsi-pages-tooltip");c.style.display="none";c.style.transformOrigin=c.style.webkitTransformOrigin="0px 0px";h.appendChild(c)};this.hide=function(){if(!f){return}f=false;a.addClass(c,"fsi-pages-tooltip-hide");a.removeClass(c,"fsi-pages-tooltip-show");c.innerHTML="";c.style.display="none"};this.setParentContainer=function(n){h=n;h.appendChild(c)};this.show=function(q,I,n,K){if(!K||typeof(I)!=="object"||typeof(q)!=="string"){this.hide()}else{var A=e.nDocumentScale;f=true;c.style.width="";var M=4/A;var C=i.getVisibleRect();g.copyRect(C);g.left+=2/A;g.top+=2/A;g.right-=24/A;g.bottom-=24/A;var o=i.getScrollRect();var p=e.getDoublePageMode();var x=I.nPage;a.addClass(c,"fsi-pages-tooltip-show");a.removeClass(c,"fsi-pages-tooltip-hide");var F=a.getElementPosition(h);var Q=Math.max(100,g.width());c.innerHTML=q;c.style.display="block";var O=a.getElementPosition(n);var v=(O.right-O.left);var w=(O.bottom-O.top);var E=1/A;if(E!==1){c.style.transform=c.style.webkitTransform="scale("+E+","+E+")";Q/=E}else{c.style.transform=c.style.webkitTransform="none"}var N=a.getBoundingClientRect(c);if(N.height>g.height()||N.width>Q){c.style.width=Q+"px";N=a.getBoundingClientRect(c);if(N.width>g.width()||N.height>g.height()){var s=N.width*N.height;var r=g.width()*g.height();var R=1.02*Math.sqrt(s/r);E/=R;Q*=R;c.style.width=Q+"px";c.style.transform=c.style.webkitTransform="scale("+E+","+E+")";N=a.getBoundingClientRect(c)}}var u,J;var z=O.top-o.top;var H=O.left-o.left;var y=g.top;var L=g.left;var P=g.right-N.width;var U=g.bottom-N.height;var G=-F.left+o.left;var D=-F.top+o.top;J=z;if(J>U){J=J+w-N.height}var B=H-N.width-M;var T=H+v+M;if(p){var S=(x%2===0);if(S){u=T;if(u>P){u=B}}else{u=B;if(u<L){u=T}}}else{u=T;if(u>P){u=B}}u=Math.max(L,Math.min(P,u));J=Math.max(y,Math.min(U,J));c.style.left=(u+G)+"px";c.style.top=(J+D)+"px";N=a.getBoundingClientRect(c);d.copyRect(N);m.copyRect(O);d.interSectRectValidate(m);if(d.width()>0&&d.height()>0){c.style.width=Q+"px";N=a.getBoundingClientRect(c);P=g.right-N.width;U=g.bottom-N.height;u=(H+(v-N.width)/2);u=Math.max(L,Math.min(P,u));c.style.left=(u+G)+"px";J=z+w+M;if(J>U){J=z-N.height-M}J=Math.max(y,Math.min(U,J));c.style.top=(J+D)+"px"}}};k()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageData!==b){return}a.PageData=function(f,e,k,i){var m=this;var h=k.iConfig;m.arAreas=[];var g=0;this.nPage=k.nIndex;this.global={};var l=function(){if(k.oImage&&typeof(k.oImage.fullImagePath)==="string"){var o={type:"info",renderer:null,tpl:e.cfgString("PageDataTemplate")};var n=h.getImageURL(k.oImage.fullImagePath,o);h.loadFile(n,j,"application/xml")}else{j()}};var j=function(o,n){if(n!==b){d(n)}i.apply(k)};var d=function(p){if(!p){m.bNoLinks=true;m.bReady=true;return}var o;var n=p.firstChild;var q=false;while(n){q=false;if(n.nodeType===1){var r=n.nodeName.toLowerCase();if(!m.bHasData&&r==="pages"){m.bHasData=true}switch(r){case"page":c(n,m.global);break;case"links":m.oLinkAttributes={};c(n,m.oLinkAttributes);break;case"image":q=true;break;case"area":q=true;m.addAreaFromXML(n);break}}o=n.firstChild;if(!o||q){o=n.nextSibling;if(!o){o=n.parentNode.nextSibling}}n=o}if(!m.global.version){m.global.version=0}else{m.global.version=parseFloat(m.global.version)}if(m.arAreas.length>0){m.bNoLinks=false}m.bReady=true};this.addAreaFromXML=function(n){var q=n;if(!q.firstChild){return}var s;var r={};r.nIndex=g++;if(r.type===b){r.type=0}c(q,r);r._arShapes=[];q=q.firstChild;while(q){if(q.nodeType===1){var t=q.nodeName.toLowerCase();switch(t){case"shape":s={};c(q,s);if(s.coords){s.parsedCoords=s.coords.split(",");if(s.parsedCoords.length>3){r._arShapes.push(s)}}break;case"text":var o="";o=q.innerHTML;if(o.length>0){r.tip=o}break;default:var p=q;while(p&&(p.nodeType!==1||!p.getAttribute("class"))){p=p.nextSibling}if(p){s={svg:p};c(q,s);r._arShapes.push(s)}}}q=q.nextSibling}if(r._arShapes.length>0){m.arAreas.push(r)}};var c=function(p,q){for(var o=0;o<p.attributes.length;o++){var n=p.attributes[o];q[n.nodeName.toLowerCase()]=n.nodeValue}};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Page!==b){return}a.Page=function(x,v,u,d,w,q,B){var z=this;z.iLayout=u;z.oImage=q;var A=z.iConfig=w.iConfig;z.bDoublePage=B.bDoublePage;z.bOddPage=B.bOddPage;z.bRealPage=B.bRealPage;z.nIndex=d;var t;var c;var j;var H;var m;var h=true;var k,D;var y;var G;var n;var f;var s=false;var C=this.init=function(){if(k){return}k=true;t=document.createElement("div");if(!z.bRealPage){t.style.visibility="hidden"}var I="fsi-pages-page";if(q.cssClass){I+=" "+q.cssClass}a.addClass(t,I);t._fsiPage=z;if(typeof(B.pageCSS)==="string"){z.setStyle(B.pageCSS)}if(!u.bDefinesPageSizeByCSS){E(w.width,w.height)}};this.destroy=function(){if(!k){return}o();if(t.parentNode){a.removeChild(t.parentNode,t);t=b}k=false};this.getSVG=function(){if(!f){f=v.svgTemplate.cloneNode(true);var I="fsi-pages-linkcontainer";if(B.bInteractive){I+=" fsi-pages-linkcontainer-interactive"}f.setAttribute("class",I);var J=z.elSVGRect=(f.children)?f.children["bend-effect"]:f.getElementById("bend-effect");if(J){J.removeAttribute("id")}if(B.bBendEffect&&!q.bNoBendEffect){if(J){if(q.cssClass){J.setAttribute("fill","url(#fsi_pages_gradient_page_"+q.cssClass+")")}else{if(!z.bOddPage){J.setAttribute("fill","url(#fsi_pages_gradient_page_even)")}}}}t.appendChild(f)}return f};this.getContainer=function(){return t};this.setOuterContainer=function(I){c=I};var o=z.removeContent=function(){if(!D){return}D=false;p();if(f){a.removeChild(f.parentNode,f);f=b}if(j){j.destroy();j=b}if(G){a.removeChild(G.parentNode,G);G=b}if(H){a.removeChild(H.parentNode,H);H=b}};var l=function(){if(q.width===b||q.height===b){var I=A.getImageInfoURL(q.fullImagePath);A.loadFile(I,i)}else{e()}};var e=function(){if(!k){return}z.updateImage();if(y){H=u.getImageNode();if(!v.iLinkEditor){H.src=y.urlCurrent}t.appendChild(H)}else{H=b}if(j){j.createLinkShapes();j.updateSVGStyle();if(h){j.show()}}};var i=function(J,I){q.width=parseInt(I.width);q.height=parseInt(I.height);e()};this.updateImage=function(){y=u.getPageImageURL(q,z.bOddPage);z.oCroppedImageCurrent=y.oCroppedImage;if(y){y.urlCurrent=A.getImageURL(q.fullImagePath,y.oImageOptions)+y.strCrop;if(A.hasImageParameterConditions){y.urlCurrent=A.reWriteImageURLByConditions(y.urlCurrent)}if(H){H.src=y.urlCurrent}if(j){j.updateSVGStyle()}}};this.initContent=function(){if(!k){return}if(D){return}D=true;z.show();if(typeof(q)==="object"){if(typeof(q.fullImagePath)==="string"){l()}else{if(q.htmlContent!==b&&u.oOptions.bMainLayout){t.innerHTML=q.htmlContent;t.style.visibility="";if(z.nIndex===0){a.addClass(t,"fsi-pages-intro-content")}}}}if(B.bPageNumbers&&u.elPageNumberTemplate&&z.strCoverClass===b&&z.bRealPage&&!q.bImageOnly){G=u.elPageNumberTemplate.cloneNode(true);if(z.bOddPage){a.addClass(G,"fsi-page-number-odd")}G.innerText=u.getPageNumberString(z.nIndex);t.appendChild(G)}if(!B.bImageOnly&&q&&!q.bImageOnly){if(q.pageData===b){m=q.pageData=new a.PageData(x,v,z,r)}else{m=q.pageData;r()}}else{g()}};this.getImageData=function(){return q};this.getFinished=function(){return s};var g=function(){s=true;if(!z.bRealPage){}else{if(B.bBendEffect){z.getSVG()}}if(u.onFinishPage){u.onFinishPage(z,t)}if(h){F(true)}if(z.onUpdateClone!==b){z.onUpdateClone(z)}};var E=z.setSize=function(I,J){t.style.width=I+"px";t.style.height=J+"px"};var r=function(){if(!D){return}var I=(v.iLinkEditor||(m&&m.arAreas&&m.arAreas.length>0));if(w.hasLinks&&I){j=new a.PageLinks(x,v,u,z,t,m,B)}g()};this.getLinksInstance=function(){return j};this.hasLinks=function(){return(j!==b)};var F=this.show=function(I){if((!I&&h)||!k){return}h=true;if(j){j.show()}c.style.display=""};var p=this.hide=function(){if(!h||!k){return}h=false;if(j){j.hide()}c.style.display="none"};this.isVisible=function(){return h};this.attachTo=function(I){n=I;if(!k){C()}n.appendChild(t)}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageContainer!==b){return}a.PageContainer=function(g,f,j,h,e,d,c){var m=this;m.nIndex=e;m.elContainer=h;m.iPage1=d;m.iPage2=c;m.bVisible=false;m.bContentLoaded=false;m.bCloned=false;var l=function(){if(d){d.oContainer=m}if(c){c.oContainer=m}h.setAttribute("data-fsi-page-index",e)};this.destroy=function(){m.hide();if(d){d.destroy()}if(c){c.destroy()}};this.show=function(n){if(m.bVisible){return}m.bVisible=true;if(n){j.pageContainerInner.insertBefore(h,n.elContainer)}else{j.pageContainerInner.appendChild(h)}};this.unCloneDomElements=function(){if(!m.bCloned){console.error("container "+m.nIndex+" has not been cloned")}else{m.bCloned=false;if(m.iPage1){if(m.iPage1){m.iPage1.elClonedContent=b;m.iPage1.onUpdateClone=b}if(m.iPage2){m.iPage2.elClonedContent=b;m.iPage2.onUpdateClone=b}}}};var i=function(p,n){if(!p){return}if(p.elClonedContent===b){p.onUpdateClone=k;p.elClonedContent=[]}var o=p.getContainer().cloneNode(true);p.elClonedContent.push(o);n.appendChild(o)};this.cloneDomElements=function(){m.bCloned=true;if(m.iPage1){var n=m.elContainer.cloneNode();if(!j.bGroupDoublePages){n.className=""}i(m.iPage1,n);i(m.iPage2,n)}return n};var k=function(p){if(p.elClonedContent!==b){var o=p.getContainer();for(var n=0;n<p.elClonedContent.length;n++){if(p.elClonedContent[n].parentNode){p.elClonedContent[n].parentNode.setAttribute("data-fsi-updated","yes");var q=o.cloneNode(true);p.elClonedContent[n].parentNode.replaceChild(q,p.elClonedContent[n]);p.elClonedContent[n]=q}}}};this.hide=function(){if(!m.bVisible){return}m.bVisible=false;j.pageContainerInner.removeChild(h)};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageLinks!==b){return}a.PageLinks=function(c,r,y,k,I,O,f){var j=this;var C=r.getDebug();var F;var o,e;var E;var L=a.utils.getSVGNameSpaceURL();var B=r.getConfig();var R=1;var U=0;var H;var q;var v,i;var n;var S=function(){G()};this.destroy=function(){if(F){j.hide()}};this.getLinkContainer=function(){return F};var A={"0":"fsi-pages-link-auto-color","2":"fsi-pages-link-icon"};var G=this.createLinkShapes=function(){if(q){return}var aa=function(ay,ax){var au=ax.svg;var aC;if(!au.outerHTML){var at=0;var av=au.cloneNode(true);var az={};var aB;while(av){if(av.nodeType===1){aB=document.createElementNS(L,av.nodeName);for(var aw=0;aw<av.attributes.length;aw++){var aA=av.attributes[aw];aB.setAttribute(aA.name,aA.value)}az[at+1]=aB;if(at>0){az[at].appendChild(aB)}else{aC=aB}}if(av.firstChild){at++;av=av.firstChild}else{if(av.nextSibling){av=av.nextSibling}else{av=av.parentNode;at--;while(av&&!av.nextSibling){at--;av=av.parentNode}if(av){av=av.nextSibling}}}}}else{if(!ah){ah=document.createElementNS(L,"g")}ah.innerHTML=au.outerHTML;aC=ah.firstChild}if(aC){ax.el=aC;ax.el._FSIShape=ax;ay.appendChild(aC)}};if(!k.oCroppedImageCurrent){return}if(!r.svgTemplate){return}F=k.getSVG();if(!F){return}v=parseInt(k.oImage.width);i=parseInt(k.oImage.height);q=true;F._FSI_PAGE_INDEX=k.nIndex;if(k.oCroppedImageCurrent.isCropped()){F.setAttribute("preserveAspectRatio","xMinYMin");k.oCroppedImageCurrent.setSourceDimension(v,i);var al=k.oCroppedImageCurrent.getPixelRangeRect();F.setAttribute("viewBox",al.left+","+al.top+","+al.right+","+al.bottom);var Z=k.elSVGRect;if(Z){Z.setAttribute("x",al.left);Z.setAttribute("y",al.top);Z.setAttribute("width",al.right+al.left);Z.setAttribute("height",al.bottom+al.top)}}else{F.setAttribute("viewBox","0,0,"+v+","+i)}var ac=O.global.version;var ae="fsi-pages-link fsi-pages-link-v"+ac;var W=document.createElementNS(L,"g");W.setAttribute("class","fsi-pages-links");var ad=document.createElementNS(L,"g");if(ac){ad.setAttribute("class",ae)}else{ad.setAttribute("class",ae+" fsi-pages-link-auto-color")}var V=document.createElementNS(L,"polygon");V.setAttribute("class","fsi-pages-link-shape");var ah;var ab=O.arAreas;for(var ao=0;ao<ab.length;ao++){var ai=ab[ao];if(ai._arShapes&&ai._arShapes){var ak=ai._arShapes;var ap=ad.cloneNode(false);if(ac){if(A[ai.type]){ap.setAttribute("class",ae+" "+A[ai.type])}}W.appendChild(ap);ap._FSIArea=ai;ai.DOMElement=ap;ai.nPage=O.nPage;for(var am=0;am<ak.length;am++){var ar=ak[am];if(ar.svg){aa(ap,ar)}else{var an=ar.parsedCoords;if(an.length%2!==0){an.push(0)}var Y="";var aj=0;for(var aq=0;aq<an.length/2;aq++){var ag=parseFloat(an[aj]);var af=parseFloat(an[aj+1]);Y+=Math.round(v*ag)+","+Math.round(i*af)+" ";aj+=2}var X=ar.el=V.cloneNode(false);X.setAttribute("points",Y);X._FSIShape=ar;ap.appendChild(X)}}}}F.appendChild(W);g()};var h=function(V){if(!V||!V.tagName){return}while(!V._FSIArea&&V.parentNode&&V.tagName!=="svg"){V=V.parentNode}return V._FSIArea};var u=function(V){if(!V||!V.tagName){return}while(!V._FSIShape&&V.parentNode&&V.tagName!=="svg"){V=V.parentNode}return V._FSIShape};var P=function(V){if(!V.strCSSClass){V.strCSSClass=V.DOMElement.getAttribute("class")}return V.strCSSClass};var K=this.updateLinkVisualState=function(Z,V,Y){if(!Z){return}var W=Y;if(W===b){W=Z._state}if(Z._visualState===W){return}var X=(V&&V.target)?V.target:null;switch(W){case 0:Z.DOMElement.setAttribute("class",P(Z));if(Z._visualState){p(false,Z,X,false)}break;case 1:if(Y&&!U){U++}Z.DOMElement.setAttribute("class",P(Z)+" hover");if(!Z._visualState){p(w(Z),Z,X,true)}break;case 2:if(Y&&!U){U++}if(!Z._visualState){p(w(Z),Z,X,true)}Z.DOMElement.setAttribute("class",P(Z)+" active");break}Z._visualState=W};var x=this.setLinkNormal=function(V,W){if(o===b||o._state===0){return}if(!W){y.setActiveLinkArea(k,j,b)}U=0;r.iCallbacks.run("onLinkHover",[o,false]);o._state=0;K(o,V);o=e=b;n=a.now()};var s=function(V){var W=h(V.target);if(!W||W._state===1){return}if(o&&o.nIndex!==W.nIndex){x()}o=W;y.setActiveLinkArea(k,j,o,V);o._state=1;r.iCallbacks.run("onLinkHover",[o,true]);if(y.isFlipping()){return}K(W,V)};this.getActiveArea=function(){return o};this.noActiveArea=function(){return(!o&&(n===b||(a.now()-n)>150))};var z=function(V){if(!o||o._state===2){return}o._state=2;if(y.isFlipping()){return}K(o,V)};var T=function(V){V.pointerType="touch";H=true;if(V.touches.length>1){N(V)}else{l(V);J(V)}};var N=function(V){V.pointerType="touch";if(H&&V.touches.length===0){t(V)}H=false};var J=function(V){if(!V.pointerType||V.pointerType==="mouse"){z(V)}else{var W=h(V.target);if(!W){y.deactivateActiveLink();return}if(U>0){z(V)}}};var t=function(V){var W=h(V.target);if(!W){return}if(!V.pointerType||V.pointerType==="mouse"){s(V)}else{if(U>0){m(V)}U++;s(V)}};var l=function(V){if(y.bFlipEffectDrag){return}s(V)};var D=function(W){if(!W.pointerType||W.pointerType==="mouse"){if(o&&!W.target._FSIShape){var X=document.elementFromPoint(W.clientX,W.clientY);var V=h(X);if(V&&V.nIndex===o.nIndex){return}}U=0;x(W)}};var Q=function(V){if(V.pointerType&&V.pointerType!=="mouse"){return}m(V)};var m=function(ae){if(y.isFlipping()){return}var ad=h(ae.target);if(!ad){return}var ac=ad.nPage;var af,Z;var W=B.getHotSpotUrl(O,ad);W=B.ReplaceLinkTemplates(W);var Y=B.getHotSpotTarget(O,ad,W);if(r.iCallbacks.isset("onOpenPageLink")){var aa=r.iCallbacks.run("onOpenPageLink",[ad.nIndex,W,Y]);if(aa===false){return}if(typeof(aa)=="object"){if(typeof(aa.strURL)=="string"){W=aa.strURL}if(typeof(aa.strTarget)=="string"){Y=aa.strTarget}}}C.log("Final Hyperlink URL: ("+Y+") "+W);if(W.charAt(0)==="#"){var ab=W.toLowerCase();if(ab.indexOf("#page=")===0){af=W.split("=");if(B.bUseNamedPageNumbersExternal){af=B.getPageNumberFromString(af[1])}else{af=Math.max(0,Math.min(r.maxPage,parseInt(af[1])))}if(!isNaN(af)){c.gotoPage(af,true);return true}}if(ab.indexOf("#zoomonpage=")===0){af=W.split("=");af=af[1].split(";");if(B.bUseNamedPageNumbersExternal){Z=B.getPageNumberFromString(af[0])}else{Z=parseInt(af[0])}if(Z<0||Z>r.maxPage){return true}if(!isNaN(Z)){y.gotoPageAndZoom(Z,af[1]);return true}}if(ab==="#zoom"||ab.indexOf("#zoom=")===0||ab==="#zoomarea"){af=W.split("=");if(af.length>1){af=af[1];if(af===b||af.length<10){af="1,1,0.5,0.5,0.5,0.5"}}else{var X=u(ae.target);if(X){var V=M(X);af="1,1,"+V.xMin+","+V.yMin+","+V.xMax+","+V.yMax}else{af="1,1,0.5,0.5,0.5,0.5"}}y.gotoPageAndZoom(ac,af);return true}if(ab.indexOf("#showimage=")===0){C.error("#showimage not implemented");return false}}if(r.cfgBool("DebugLinks")){alert("Open Link #"+ad.nIndex+"\r\nTarget: "+Y+"\r\nURL "+W+"\r\nTouchClick: "+U+"\r\nEvent: "+ae.type)}if(W.length>1&&B.bFollowLinks){if(C.on){C.log("Open Link: ("+Y+") URL +"+W)}if(W.indexOf("javascript:")===0&&Y.toLowerCase()==="_self"){document.location=W}else{window.open(W,Y)}}};var M=function(X){var W=X.el.getBBox();var V={};V.xMin=W.x/v;V.yMin=W.y/i;V.xMax=V.xMin+W.width/v;V.yMax=V.yMin+W.height/i;return V};var w=function(W){var V;if(B.ParamForceLinkTip!==b){V=B.ParamForceLinkTip}else{V=W.tip;if(V===b){V=B.ParamDefaultLinkTip;if(V===b){V=false}}else{V=V.replace(/\+/g," ");V=decodeURIComponent(V)}}return V};var g=this.updateSVGStyle=function(X,Y){if(F){R=k.oImage.width/k.oCroppedImageCurrent.widthUncropped;if(X===b){X=R}if(a.isInternetExplorer||Y){var W=Math.round(10*r.nLinkStrokeWidth*X)/10;F.style.strokeWidth=W/2+"px";if(r.bLinkAntLine){var V=Math.ceil(r.nLinkStrokeDashLength*X);F.style.strokeDasharray=V+"px"}}}};var p=function(X,Y,V,W){r.showPageToolTip.apply(c,[X,Y,V,W])};j.show=function(){if(!E&&F&&f.bInteractive){if(!E){E=true;d(a.addEvent)}}if(F){F.style.display=""}};j.hide=function(){if(E&&F&&f.bInteractive){if(E){E=false;d(a.removeEvent)}}if(F){F.style.display="none"}};var d=function(W,X){var V=F;if(X){V=X}if(!V){return}if(!a.isMobileDevice&&!a.isEventSupported("pointerdown")){W(V,"mouseover",l);W(V,"mouseout",D);W(V,"mousedown",J);W(window,"mouseup",t)}if(a.isEventSupported("pointerdown")){W(V,"pointerover",l);W(V,"pointerout",D);W(V,"pointerdown",J);W(V,"pointerup",t)}else{W(F,"touchstart",T);W(window,"touchend",N)}if(!a.isMobileDevice){W(V,"click",Q)}};S()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.API.Pages!==b){return}a.utils.API.Pages=function(d,e){var c=this;c.scriptMainFile="FSI.Pages.js";c.getActiveMenuButtons=function(){if(e.arMenuButtons===b){return b}var f={};for(var g=0;g<e.arMenuButtons.length;g++){var h=e.arMenuButtons[g].cmd;if(h!==b){f[h]=true}}return f};c.oMenuCommands={SavePage:"Save Page",PrintPage:"Print Page",FirstPage:"First Page",PreviousPage:"Previous Page",PageInputEnter:"Show Specified Page",NextPage:"Next Page",LastPage:"Last Page",ToggleBookmarkList:"Show Bookmarks",ToggleBookmark:"Add Bookmark",ToggleTableOfContents:"Table of Contents",TogglePageIndex:"Show / Hide Page Index",ToggleFullScreen:"FullScreen"};c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},changeConfig:{a:"strCfgFileName, oParameters"},clickMenuButton:{a:"strButtonID"},debugEnabled:{r:"bEnabled"},debugError:{a:"mixed"},debugLog:{a:"mixed"},debugWarn:{a:"mixed"},destroy:{},dumpListeners:{},firstPage:{},getBuild:{r:"strBuild"},getConfigBoolean:{a:"strParameterName, bDefault",r:"bResult"},getConfigFloat:{a:"strParameterName, fDefault",r:"fResult"},getConfigInt:{a:"strParameterName, nDefault",r:"nResult"},getConfigString:{a:"strParameterName, strDefault",r:"strResult"},getConfigValue:{a:"strName",r:"mixed"},getContentID:{r:"strContentID"},getCurrentPageNumber:{r:"strPageNumber"},getInitDone:{r:"bInitDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getMenuButtonPresent:{a:"strButtonID",r:"bPresent"},getPageContainerDim:{r:"oDimension"},getPageLayoutData:{r:"oPageLayoutData"},getPageNumberString:{a:"nPage",r:"strPageNumber"},getParameters:{r:"oCurrentParameters"},getPluginParameter:{a:"strPluginName, strParameterName, defaultValue, bMakeBoolean",r:"mixed"},getSkinClassName:{r:"strClassName"},getTargetPage:{a:"nPage",r:"nPage"},getVersion:{r:"strVersion"},gotoPage:{a:"strPage, bAnimate"},gotoPageAndZoom:{a:"strPage, strViewString"},gotoPageNumeric:{a:"nPage, bAnimate"},hideMenuToolTip:{},init:{a:"domElement, oParameters, bDebug"},lastPage:{},makeBoolean:{a:"mixedConvert, bDefaultValue",r:"bResult"},nextPage:{},pressMenuButton:{a:"strButtonID"},previousPage:{},printAPI:{},registerExternalMenuButton:{a:"elButton, strButtonID, strTip"},registerExternalMenuButtonsFromContainer:{a:"elContainer"},releaseMenuButton:{a:"strButtonID"},removeListener:{a:"strListenerName, fn",r:"bSuccess"},searchForString:{a:"strKeyWords",r:"bSuccess"},setFullScreenElement:{a:"elFullScreenContainer",r:"bSuccess"},showAboutWindow:{},showMenuToolTip:{a:"strTip, elSrc, x, y"},showSearchDialog:{a:"bShow",r:"bSuccess"},start:{},testAPIListenersStart:{},testAPIListenersStop:{},togglePageIndex:{},traceConfigValue:{a:"strName"},unregisterExternalMenuButton:{a:"elButton"},unregisterExternalMenuButtonsFromContainer:{a:"elContainer"}};c.oProperties={};c.oCallbacks={onAfterRegisterExternalButton:{a:"elButton, strButtonID, bButtonPresentInViewer"},onAutoPageLayoutChange:{a:"bDoublePage"},onBookmarkAdded:{a:"nPage"},onBookmarkRemoved:{a:"nPage"},onBookmarksLoaded:{a:"strLoaded"},onBookmarksSaved:{a:"strStored"},onChangeConfig:{a:"strCfgFileName, oParameters"},onClickDemoMode:{a:"url, targetFrame"},onDestroy:{},onGetChaptersData:{a:"nodeChaptersData"},onGetIntroContent:{a:"nodeIntroData"},onEnterDemoMode:{},onExitDemoMode:{},onFullScreen:{a:"bSet"},onInitFailed:{a:"strReason"},onLinkHover:{a:"oLinkData, bHover"},onMenuButtonEnabled:{a:"strButtonID, null, bEnable"},onMenuButtonMouseDown:{a:"strButtonID, evt"},onMenuButtonPressed:{a:"strButtonID, evt"},onMenuButtonReleased:{a:"strButtonID, evt"},onMenuButtonClicked:{a:"strButtonID, evt"},onMenuButtonSetPressed:{a:"bPressed"},onMenuDestroy:{},onMenuEnabled:{a:"bEnabled"},onMenuReady:{},onOpenPageLink:{a:"nLinkAreaIndex, strURL, strTarget",r:'false or {strURL:"foo", strTarget:"foo"}'},onPageChanged:{a:"nPage, strPage, strMaxPage"},onPageLayoutChanged:{a:"oPageLayoutData"},onPageSizeChanged:{a:"nWidth, nHeight"},onPageToolTip:{a:"nLinkAreaIndex, strURL, strTipContent",r:"strModifiedToolTipContent"},onPageZoomed:{a:"nPage"},onPrintPages:{a:"arPageIndices, arImageURLs"},onReady:{},onRegisterExternalMenuButtons:{},onRemoveAllBookmarks:{},onResize:{a:"nWidth, nHeight, bResizeDone, bFullscreen"},onSearchInit:{a:"elInput"},onSearchResults:{a:"arPageNumbers, arImages"},onSearchStart:{a:"strKeyWords, strInput"},onShowBookmarkList:{a:"bShow"},onShowChapters:{a:"bShow"},onShowChaptersData:{a:"arIndexItems"},onShowPageIndex:{a:"bShow"},onShowPrintDialog:{a:"bShow"},onShowSaveDialog:{a:"bShow"},onShowSearchDialog:{a:"bShow"},onSkinChanged:{a:"strClassName, strClassNameBefore"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Pages!==b){return}a.Pages=function(aE,d){var aU={};var bO={strVersion:"2019",strBuild:"19.10.6785",strConfigSection:"Pages",oTraceConfigParameters:d,bHasListeners:true};var bJ=new a.utils.ClassDef(this,"FSI Pages",bO);bJ.oAPI=new a.utils.API.Pages(this,aU);var aL=bJ.instance;a.utils.guessFSIViewerLocation("fsipages.js",3);var a4=a.utils.getViewerInstanceID();this.getInstanceID=aU.getInstanceID=function(){return a4};this.getInstanceName=function(){return bJ.strClassName+" ["+az+"]"};var a1={};var q=new a.EmptyDebugger();var aw=function(cp,o){if(o&&!q.on&&cp.on){bC.stopPendingRequests();aL.destroy();aL.init(T,a1,true);aL.start();return true}q=aU.debug=cp;if(b7){b7.setDebug(q)}if(q.on){q.setPrefix(aL.getInstanceName())}};var bK;var bU=false;var S;var T;var az;var bC;var a7=0;var bD="";var bc;var ch;var cd;var aq;var cn;var bb;var F;var bI;var ap,b6;var b7;var b1;var f={};aU.oCropCacheSource={};var z={};var s={};var E;var bq;var U=false;var b5;var at={};at.cursors={};var bp;var l;var ak={};var ar,K,bo,bG;var bd;var bA;var aC;var Q={};var cj,v,y;var be;var bQ;var bW,c;var ac=false;var bi;var V;var g;var cc=0;var bR={};var bs=false;var bH=0;var x;var cg,bT;var aH;var aB=false;var bX;var aZ=0;var b0=0;var Z,by;var O;var ci;var D;var a3;var aS;var aW,bP;var m={};var b9={};var bF;var bM,aN;var a2;var bg={};var a0,b8;var aA;var W;var bL,ay;aU.bIsIOS=(a.mobileOS==="ios");this.init=function(cp,cr,o){T=cp;if(bU){aL.destroy()}if(typeof(cp)==="object"){if(typeof(cp.id)==="string"){az=cp.id}}else{if(typeof(cp)==="string"){az=cp}}if(!az){az="fsi.pages #"+a4}if(aL._fsi_parameters){cr=aL._fsi_parameters;delete aL._fsi_parameters;aL._fsi_parameters=b}if(typeof(cp)==="object"&&cp.tagName!==b){cd=cp}else{cd=document.getElementById(cp)}cd.setAttribute("data-fsi-id",az);if(typeof(cr)==="object"&&typeof(window[cr.oninit])==="function"){window[cr.oninit](aL,az,cr)}bW=cd;a1=(cr&&typeof(cr)==="object")?a.utils.cloneParameters(cr):{};N();bB();aC=a.getElementDimension(aq);aJ(true);var cq=a1;if(o){cq=a.utils.cloneObject(a1);cq.debug=true}bC.init(cq);if(q.on){q.log(aL.getVersion())}bU=true};this.getInitDone=function(){return bU};this.start=function(){bC.loadConfigs()};var aO=function(o){if(o&&typeof(o.destroy)==="function"){o.destroy()}return b};var bx=function(){if(W!==b){W.destroy();W=b}a.FullScreen.removeChangeEvents(window,bz,aM);aU.bBookmarkIconsOnPages=aA=false;if(bG){bG.unregisterExternalButtons()}bl();b3();if(a2){a2.destroy();a2=aU.iChapters=b}if(bC){bC.reset()}if(b7){b7.removeConfigListeners()}cm();au();if(y!==b){a.removeCustomEvent(aq,"FSIDocumentZoomChange",cb)}if(cj!==b){a.removeCustomEvent(aq,"FSIElementDimension",ca)}cj=b;v=false;if(aN!==b){clearTimeout(aN);aN=b}a.utils.deleteInstanceCSSRules(s);for(var cp in bR){if(bR.hasOwnProperty(cp)){bR[cp].destroy()}}g=bQ=V=b;bR={};if(E){E.remove();E=b}if(bq){bq.remove();bq=b}bi=aO(bi);be=aO(be);bI=aO(bI);bd=aO(bd);bX=aO(bX);aW=bP=b;ak={}};this.destroyOnDetach=function(){if(ak&&ak.autoDestroy!==false){I()}};var I=this.destroy=function(){if(cd){cd.removeAttribute("data-fsi-id")}if(ch){ch.destroy()}if(bC){bC.destroy()}bx();bG=aO(bG);if(aq){a.removeChild(aq.parentNode,aq)}aq=b;bU=false;if(b7){b7.run("onDestroy");b7.destroy()}bC.reset();ak={};if(bb){a.removeChild(bb.parentNode,bb);bb=aU.pageIndexContainer=b}};this.getContentID=aU.getContentID=function(){return bD};aU.getLayout=function(){return bQ};this.getPageLayoutData=function(){if(!bQ){return null}return bQ.getPageLayoutData()};this.getTargetPage=function(o){return(bQ)?bQ.getTargetPage(o):null};this.addListener=function(cr,cp,cq){var o=false;if(b7){o=b7.addListener(cr,cp,cq)}return o};this.removeListener=function(cq,cp){var o=false;if(b7){o=b7.removeListener(cq,cp)}return o};var bB=function(){aq=document.createElement("div");aq.setAttribute("draggable","false");aq.setAttribute("style","width:100%;height:100%;");cn=document.createElement("div");a.addClass(cn,"fsi-pages-content");aq.appendChild(cn);cd.appendChild(aq)};var N=function(){var o={};o.onConfigsReady=av;o.onDebuggerChange=aw;bC=aU.iConfig=new a.PagesConfig(aL,aU,null,o,{strSection:bJ.strConfigSection});bC.setEffectsFilterArea();aL.loadFile=bC.loadFile;bC.cfgDefaults.listtemplate=b;if(!b7){b7=aU.iCallbacks=new a.Callbacks(aL,bC)}else{b7.setConfig(bC)}};aU.getConfig=function(){return bC};var av=function(){if(!bC.hasPlugin("pages")){bC.addPluginFromString("pages",{})}bC.initPagesParameters();aU.bUseDevicePixelRatio=aL.getConfigBoolean("usedevicepixelratio",true);aU.nDocumentScale=a.utils.getDocumentScale();if(aU.bUseDevicePixelRatio){aU.nDocumentScalePixelRatio=a.utils.getDocumentScaleWithPixelRatio()}else{aU.nDocumentScalePixelRatio=aU.nDocumentScale}ak.pagedatatemplate=al("PageDataTemplate","catalog_page.xml");if(ak.pagedatatemplate.indexOf(".xml")===-1){ak.pagedatatemplate+=".xml"}bC.cfg.listtemplate=al("ListTemplate","image_list.json");if(bC.hasPlugin("fullscreen")&&!bC.hasPlugin("resize")){bC.addPluginFromString("resize")}S=(typeof(d.iLinkEditor)==="object");aU.iLinkEditor=d.iLinkEditor;ab()};var ab=function(){var cp=bC.readCustomPageNumbers;var o=k("customskinclass");if(ch&&ch.paramCustomSkinClass!==o){ch.destroy()}if(o!==b){if(!ch||ch.paramCustomSkinClass!==o){ch=new a.CustomSkinClass(aL,o,aU,cp)}}else{cp()}};aU.onCustomPageNumbersDone=function(){P()};var P=function(){var cp;aB=bC.hasPlugin("pagesthumbbar");y=a.addCustomEvent(aq,"FSIDocumentZoomChange",cb);a.setCustomEventListenerProperty(y,"treshold",250);if(bC.hasPlugin("resize")){if(!v){aq.style.width=aq.style.height="100%";cp=cj=a.addCustomEvent(aq,"FSIElementDimension",ca);a.setCustomEventListenerProperty(cp,"treshold",250);v=true}}else{aq.style.width=aq.offsetWidth+"px";aq.style.height=aq.offsetHeight+"px";if(v){a.removeCustomEvent(aq,"FSIElementDimension",ca);v=false}}if(aU.svgTemplate===b){var o=bC.getReloadPath(bC.locationFSIViewer,"/skins/resources/svg/fsi-pages-core.svg");bC.loadFile(o,aF,"text/html; charset=utf-8")}else{aF()}};var aF=function(cv){if(cv&&(cv.responseText||cv.response)){var cp=(cv.responseText)?cv.responseText:cv.response;var ct;var o=document.createElement("div");o.innerHTML=cp;var cr=o.firstChild;if(cr){aq.appendChild(cr);var cs=aU.svgTemplate=cr.cloneNode(true);aq.appendChild(cs);o=cs.getElementById("gradients");cs.removeChild(o);aU.svgTemplateWithRect=aU.svgTemplate.cloneNode(true);if(al("BendEffect","glossy").toLowerCase()==="none"){ct=cs.getElementById("bend-effect");if(ct){cs.removeChild(ct)}}aq.removeChild(cs);cr.setAttribute("style","position:absolute;width:0px;height:0px;visibility:hidden:z-index:-1");ct=cr.getElementById("bend-effect");if(ct){cr.removeChild(ct)}}}var cw=al("skin","black");if(b5!==cw){U=false;b5=cw}q.log("Loading skin: "+cw+".css");if(E){E.remove();E=b}if(!U){var cu=at.className;at.name=cw;at.className="fsi-skin-"+at.name;ap=".fsi-pages-root.fsi-pages-instance-"+a4;b6="fsi-root fsi-pages-root fsi-pages-instance-"+a4;if(a.isMobileDevice){b6+=" fsi-mobile"}b2();aq.className=b6+" "+at.className;var cq=[{file:"resources/fsi-core.css",nPriority:1},{file:"resources/fsi-pages-core.css",nPriority:5}];E=a.utils.loadSkinCSS(cw,aL,M,10,cq);if(cu!==at.className){b7.runPersistent("onSkinChanged",[at.className,cu])}}else{b2();M(U)}};this.getSkinClassName=function(){return at.className};aU.getBaseCSSSelector=function(){return ap};aU.getBaseCSSClass=function(){return b6};aU.getCurrentPageNumberNumeric=function(){return bQ.getCurrentPage()+aZ};aU.getCurrentPageNumber=this.getCurrentPageNumber=function(){return bC.getPageNumberString(bQ.getCurrentPage())};var M=function(o,cq){b9.hideUI=false;if(al("DemoURL","").length>0){b9.hideUI=aP("hideuiindemomode",true);aj()}else{au()}E=b;if(o){q.log("Skin loaded successfully. ")}else{l={hMenuBar:0};q.error("Failed to load skin.")}if(cq){G()}else{at._nameParsedLast=b}if(bC.hasPlugin("chapters")){var cp={};cp.onReady=J;cp.elContainer=aq;a2=aU.iChapters=new a.PagesChapters(aL,aU,cp);a2.init()}else{bk()}};var J=function(o){if(!o){a2.destroy();a2=aU.iChapters=b}bk()};var aY=function(ct,o,cp){var cr,cq;cr=al(ct);if(cr!==b){cr=a.utils.rgbaHexToDecimal(cr);cq="stroke:rgba("+cr.strRGBA+");";if(cp>0){cq+="fill:rgba("+cr.strRGBA+");fill-opacity:"+cp+";"}var cs=ap+" .fsi-pages-linkcontainer .fsi-pages-link"+o+".fsi-pages-link-auto-color";cs=cs+", "+cs+" *";a.utils.addInstanceCSSRule(s,cs,cq)}};var b2=function(){a.utils.deleteInstanceCSSRules(s);var o=aL.getConfigInt("linkFillAlpha",0)/100;aY("LinkRGBANormal","",o);aY("LinkRGBAHover",".hover",o);aY("LinkRGBAActive",".active",o)};var G=function(){if(at._nameParsedLast!==at.name){at._nameParsedLast=at.name;var cv=document.createElement("div");cv.style.position="absolute";cv.style.top="0px";cv.style.left="0px";cv.style.width="1px";cv.style.height="1px";cv.style.overflow="hidden";cv.style.visibility="hidden";var cp=document.createElement("div");cv.appendChild(cp);aq.appendChild(cv);var cx={};var cs=function(cF,cC,cA,cz,cB){var cy,cE;if(cx[cF]===b){cp.className=cF;cE=cx[cF]=getComputedStyle(cp,cB)}else{cE=cx[cF]}cy=cE.getPropertyValue(cC);if(cz){cy=cy.replace(/^[^{]*/g,"");cy=cy.replace(/[^}]*$/g,"");cy=cy.replace(/\\"/g,'"');if(cy.length>0){try{cy=JSON.parse(cy)}catch(cD){a.console.error("ERROR parsing JSON from CSS selector '"+cF+"' property '"+cC+"'.");a.console.error(cD.message)}}else{cy={}}}if(cy===b){cy=cA}return cy};l=cs("fsi-ui-info","content",b,true,":before");l.hMenuBar=cs("fsi-ui-menu-bar","height");at.urlLogo=cs("fsi-ui-logo-image","background-image");if(typeof(at.urlLogo)==="string"){var cu=/url\(\s*["']?([^"')]*)["']?\s*\)/;var o=cu.exec(at.urlLogo);if(o&&o.length>0){at.urlLogo=o[1]}}var cw=16;var cr=8;if(l){if(!isNaN(l.baseSize)&&l.baseSize>0){cw=l.baseSize}if(!isNaN(l.baseEnlargement)&&l.baseEnlargement>0){cr=l.baseEnlargement}}else{l={}}if(aP("LinkAntLineAnimation",true)){cv.className="fsi-pages-linkcontainer-interactive";var cq=cs("fsi-pages-link hover","animation");if(typeof(cq)!=="string"||cq.length<1){cq=cs("fsi-pages-link hover","-webkit-animation")}if(typeof(cq)!=="string"||cq.length<1){cq=cs("fsi-pages-link hover","animationName")}if(typeof(cq)!=="string"){cq=""}aU.bLinkAntLine=(cq.indexOf("fsipagesbaseLinkAnimation")===0)}aU.nLinkStrokeWidth=parseFloat(cs("fsi-pages-link","stroke-width"));if(isNaN(aU.nLinkStrokeWidth)){aU.nLinkStrokeWidth=2}aU.nLinkStrokeDashLength=parseFloat(cs("fsi-pages-link","stroke-dasharray"));if(isNaN(aU.nLinkStrokeDashLength)){aU.nLinkStrokeDashLength=6}var ct=1;if(a.isMobileDevice&&ak.adaptiveUISize===true){ct=a.getDevicePixelRatio()}bp=Math.round(cw+cr*ct);l._baseSkinSize=bp;aq.removeChild(cv)}aq.style.fontSize=bp+"px"};aU.roundDocumentScale=function(o){if(o>0.9&&o<1.2){o=1}return Math.ceil(2*o)/2};var bk=function(){if(typeof(l.hMenuBar)!=="string"||l.hMenuBar.length<1||isNaN(parseFloat(l.hMenuBar))){ar=false}else{ar=(aP("HideUI")!==true)}bZ()};var bf=function(){if(bd!==b){bC.loadLanguageFile(f,al("language"),bV,q)}};var bV=function(o){bA=o;bd.setContent(bA);if(W){W.onLanguageDataReady()}};var bZ=function(){if(bd===b){if(a.getViewerLocation()!==b){bd=new a.ToolTip(aq)}}bf();if(bG===b||!U){bG=aO(bG);bG=new a.MenuBar(aU,at,aq,ax,bJ.oAPI.oMenuCommands);bG.setCallbacks(b7)}else{if(U&&bG){bG.setInterface(aU)}ax()}};var ax=function(){if(!ar){bG.removeDomElement()}K=bG.getHeight();if(b9.bEnabled&&b9.hideUI){bG.show(false)}aD(K);ck();n()};var aD=function(o){if(b9.hideUI&&b9.bEnabled){bo=0}else{if(l&&l.bFloatingMenuBar){bo=0}else{bo=o}}a8()};this.getParameters=function(){return a.utils.cloneParameters(a1)};this.getConfigValue=function(o){if(bC&&typeof(o)==="string"){return bC.cfg[a.trim(o.toLowerCase())]}};this.makeBoolean=function(cp,o){if(bC){return bC.makeBool(cp,o)}};this.getPluginParameter=function(cr,cq,cp,o){if(bC){return bC.getPluginParameter(cr,cq,cp,o)}};this.changeConfig=function(o,cp){b7.runPersistent("onChangeConfig",[o,cp]);if(q.on){a.console.log("")}U=true;bx();if(cp!==null&&typeof(cp)==="object"){a1=a.utils.cloneParameters(cp)}if(typeof(o)==="string"){a1.cfg=o}N();bC.init(a1);aL.start()};this.getPageContainerDim=function(){var cq=bo;if(g&&g.bLayoutVisible){cq+=ai()}var o=cn.clientWidth;var cp=cn.clientHeight;return{width:o,height:cp-cq}};var w=function(){var o=false;if(a.FullScreen){o=a.FullScreen.getElement()}return(o&&o!==c)};aU.registerLayout=function(o){if(o.nLayoutID!==b){q.error("Layout already registered");return}o.nLayoutID=++a7;bR[o.nLayoutID]=o};aU.unregisterLayout=function(o){if(o.nLayoutID===b){q.error("Failed to unregister Layout: "+o.name);return}bR[o.nLayoutID]=b;delete (bR[o.nLayoutID]);o.nLayoutID=b};var cb=function(cp){if(aN===b){for(var cq in bR){if(bR.hasOwnProperty(cq)){bR[cq].onStartDocumentZoom(cp)}}}else{clearTimeout(aN)}aN=setTimeout(aV,250);bM=cp;aU.nDocumentScale=cp.FSI_scale;aU.nDocumentScalePixelRatio=(aU.bUseDevicePixelRatio)?cp.FSI_scale_with_pixel_ratio:cp.FSI_scale};var aV=function(){aN=b;for(var cp in bR){if(bR.hasOwnProperty(cp)){bR[cp].onAfterDocumentZoom(bM)}}};var ca=this.onResize=function(cp){if(w()){return}aC=a.getElementDimension(aq);if(!D){bm();if(a2){a2.onResize()}}D=(cp&&!cp.FSI_after_treshold);if(!D){e()}if(W){W.onResize(cp)}for(var cq in bR){if(bR.hasOwnProperty(cq)){bR[cq].onResize(cp)}}aJ(cp.FSI_after_treshold)};var aJ=function(o){b7.runPersistent("onResize",[aC.width,aC.height,(o!==b),ac])};var bw=function(){if(g&&bC.getPluginParameter("pagesthumbbar","autohide",true,true)){var o=((b9.bEnabled&&b9.hideUI)||aq.offsetHeight<600);if(o!==bs){bs=o;if(o){g.lockShow("autoShowHideThumbbar")}else{g.unlockShow("autoShowHideThumbbar")}}}};var e=function(){bw();if(bX){if(aq.offsetWidth<500){bX.hide()}else{bX.show()}}if(bG){bG.setContainerSize(aC)}if(a3&&!D&&bQ&&aq.offsetWidth>100){var o=a9();if(ci.pageOptions.bGroupDoublePages!==o){cg=ci.pageOptions.bGroupDoublePages=o;ci.initialPageIndex=bQ.getCurrentPage();var cp=bQ.getShowState();bQ.destroy();u();bQ.restoreShowState(cp);b7.runPersistent("onAutoPageLayoutChange",[o])}}};aU.getDoublePageModeConfig=function(){return bT};aU.getDoublePageMode=function(){if(!bQ){return true}return ci.pageOptions.bGroupDoublePages};var a9=function(){if(bQ){return bQ.getAutoDoublePageMode()}return true};var aQ=this.getPageNumberString=function(o){return bC.getPageNumberString(o)};var ao=function(cp,o){if(!o){if(g){g.setSelectedPage(cp);g.gotoPage(cp,true)}if(bL!==b){localStorage.setItem(bL,cp);if(ay!==b){localStorage.setItem(ay,L())}}bn()}if(bX){bX.blur();if(ci.pageOptions.bGroupDoublePages){cp=Math.max(aZ,cp-cp%2)}bX.onPageChange(aQ(cp),aQ(O+aZ-1))}if(bi){aU.updateAddBookmarkButton(cp)}b7.runPersistent("onPageChanged",[cp,aQ(cp),aQ(O+aZ-1)])};var bn=function(){var cp=bQ.getCurrentPage();var cq=1;if(cg){cp-=cp%2;cq=2}var o=(cp<2);if(o!==aW){aW=o;Y("FirstPage",!o);Y("PreviousPage",!o)}o=(cp>=O+aZ-cq);if(o!==bP){bP=o;Y("LastPage",!o);Y("NextPage",!o)}};aU.updateAddBookmarkButton=function(o){if(!bQ){return}if(o===b){o=bQ.getCurrentPage()}var cp=bi.isPageBookmarked(o);if(cp!==bi.bCurrentPageIsBookmarked){bi.bCurrentPageIsBookmarked=cp;if(cp){bG.addButtonCSSClass("ToggleBookmark","remove-bookmark")}else{bG.removeButtonCSSClass("ToggleBookmark","remove-bookmark")}}};this.showMenuToolTip=function(cq,cp,o,cr){if(bG){bG.showToolTip(cq,cp,o,cr)}};this.hideMenuToolTip=function(){if(bG){bG.hideToolTip()}};var a5=function(o){g.setOption("bLazyScroll",false);j(o.nIndex,true);g.resetOption("bLazyScroll")};var ai=function(){if(!g||!g.bLayoutVisible){return 0}return g._totalHeight};aU.showThumbBar=function(o){if(g){if(o){g.unlockShow("Zoom")}else{g.lockShow("Zoom")}}};var t=function(o){if(!aB){return}var cq={};var cp=bC.getPluginParameter("pagesthumbbar","height",80);cp=parseInt(cp);if(isNaN(cp)||cp<10){cp=80}cq.imageOptions={};if(al("effects")!==b){cq.imageOptions.effects=al("effects")}cq.elContainer=aq;cq.pageOptions={bInteractive:false,bImageOnly:true,bGroupDoublePages:bT,bPageNumbers:bC.getPluginParameter("pagesthumbbar","PageNumbers",true,true)};cq.alignMode=1;cq.bQuantize=true;cq.nConcurrentImageLoad=12;cq.name="ThumbnailBar";cq.bLazyScroll=true;cq.onPageClick=a5;cq.bSelectFirstPage=true;cq.strContainerClass="fsi-pages-thumbbar";cq.bHorizontal=true;cq.initialPageIndex=o;cq.thumbWidth=aq.clientWidth;cq.thumbHeight=cp;cq.onShowHide=a8;g=new a.PageLayoutGrid(aL,aU,b1,bC,cq);if(aA){g.onFinishPage=bu}g.init();g.dimMargins=a.utils.getElementMargins(g.pageContainer);g._height=g.hItem;g._totalHeight=g.dimMargins.top+g.dimMargins.bottom+g._height;g.pageContainer.style.top="auto";g.pageContainer.style.bottom=cc+"px";g.pageContainer.style.height=g._height+"px";bw()};var n=function(){var cq=bC.getImageList();aU.bListWithDimensionLoaded=false;if(typeof(cq)==="object"&&typeof(cq.arImages)==="object"&&cq.arImages.length>0){if(!cq.images){cq.images=[];for(var cp=0;cp<cq.arImages.length;cp++){cq.images[cp]={src:cq.arImages[cp],fullImagePath:cq.arImages[cp],file:"[src]"}}}aa(cq.arImages,cq)}else{var o=al("dir");if(o!==b){aU.bListWithDimensionLoaded=true;bC.loadImageList(o,aa)}}};aU.getImageDimFitInto=function(cp,cy,cx,cw,cq,cv){var ct={};var cs=cp;var cr=cy;if(!cv){cx=Math.min(cp,cx);cw=Math.min(cy,cw)}var cu=cq&&cq.isCropped();if(cu){cq.setSourceDimension(cp,cy);var o=cq.getPixelRangeRect();cp=o.right;cy=o.bottom}if(cp/cx>cy/cw){ct.width=cx;ct.height=Math.round(cy/cp*cx)}else{ct.height=cw;ct.width=Math.round(cp/cy*cw)}if(cu){ct.widthUncropped=Math.round(ct.width*cs/cp);ct.heightUncropped=Math.round(ct.height*cr/cy)}else{ct.widthUncropped=ct.width;ct.heightUncropped=ct.height}return ct};var am=function(cq,o){if(cq.oContainer.nIndex!==bQ.getCurrentContainerIndex()){j(cq.nIndex,true)}else{if(ci.bOneClickZoom){if(!bQ.bFlipping&&!bQ.bZoomed){var cp=cq.getLinksInstance();if(!cp||cp.noActiveArea()){bQ.clickZoomPage(o)}}}}};var a8=function(){cc=bo+ai();cn.style.paddingBottom=cc+"px";if(g){g.pageContainer.style.bottom=bo+"px"}};var L=function(){return new Date().getTime()};var aX=function(){var cr;var cq;if(a.BrowserSupports.localStorage()&&aP("RememberLastViewedPage",false)){var cp=br("RememberLastViewedPageExpireAfter",0);if(cp<0){cp=0}bL=aU.getContentID()+"_initialPage";ay=b;cq=parseInt(localStorage.getItem(bL));if(!isNaN(cq)){cr=cq;if(cp>0){ay=bL+"_time";cq=parseInt(localStorage.getItem(ay));if(!isNaN(cq)&&((L()-cq)/1000)>cp){cr=b;localStorage.removeItem(bL);localStorage.removeItem(ay)}}}}if(cr===b){cr=br("initialPage",1)}var ct={};cc=bo;t(cr);a8();if(!bb){bb=aU.pageIndexContainer=document.createElement("div");a.addClass(bb,"fsi-pages-page-index-container");bb.style.paddingBottom=bo+"px";aq.appendChild(bb)}ct.imageOptions={};if(al("effects")!==b){ct.imageOptions.effects=al("effects")}if(a3){cg=a9()}ct.elContainer=cn;cq=bC.cfg.listtemplate;var o=(typeof(cq)==="string"&&cq.indexOf("image_list")!==0);o=aP("Links",o);ct.pageOptions={bInteractive:true,bImageOnly:!o,bGroupDoublePages:cg,bPageNumbers:aP("PageNumbers",false)};ct.bHorizontal=!aP("VerticalLayout",false);ct.bCenterContent=true;ct.bOnePageInView=aP("OnePageInView",true);ct.bOneClickZoom=aP("OneClickZoom",false);ct.ShowNeighbourPages=br("ShowNeighbourPages",0);ct.ScrollItemMinimumSpacing=br("ScrollItemMinimumSpacing",12);ct.onCurrentPageChange=ao;ct.trackCurrentPageWhileScrolling=true;ct.thumbWidth=ct.thumbHeight="auto";ct.initialPageIndex=cr+aZ-1;ct.strContainerClass="fsi-pages-main-view";ct.bFocusCurrentPage=false;ct.onPageClick=am;ct.bMainLayout=true;ct.alignMode=1;ct.bSingleColumn=true;ct.bQuantize=true;ct.dropShadow=aP("dropShadow",true);if(ct.dropShadow){ct.dropShadowOpacity=r("dropShadowOpacity");ct.dropShadowDistance=r("dropShadowDistance",50)/100}ct.enableZoom=aP("zoom",true);if(ct.enableZoom){var cu=r("maxZoom",100)/100;if(isNaN(cu)||cu<=0){cu=1}ct.fMaxZoom=cu}ct.nCreateAhead=(a.isMobileDevice)?1:1.5;ct.bAutoSelectCurrentPage=true;ci=ct;aU.maxPage=b1.images.length;if(aZ>0&&b1.images.length>0){var cs=bC.getUnrecognizedConfigNode("FSIPagesIntroContent");if(cs===b){if(bK){cs=bK}else{cs=bK=b7.run("onGetIntroContent")}}if(cs&&typeof(cs)==="object"){cs=a.trim(cs.innerHTML);if(cs.length>0){b1.images[0].htmlContent=cs}}}u();e();bG.setEnabled(true)};var u=function(){ci.name="Main";bQ=new a[x](aL,aU,b1,bC,ci);if(S){bQ.onFinishPage=d.iLinkEditor.onPageReady}else{if(aA){bQ.onFinishPage=bu}}bQ.init();F=bQ.pageContainer;if(!cg&&O===1){if(bQ.enableScroll){bQ.enableScroll(false)}}};var bu=function(o){if(!aA||!bi.isPageBookmarked(o.nIndex)||!o.bRealPage){return}o.iLayout.showBookmarkIconOnPage(o.nIndex,true,bF)};var X=aU.showBookmarkIconOnPage=function(cp,o){if(!aA){return}if(bQ){bQ.showBookmarkIconOnPage(cp,o,bF)}if(g){g.showBookmarkIconOnPage(cp,o,bF)}};this.gotoPageAndZoom=function(o,cp){if(bQ){bQ.gotoPageAndZoom(o,cp)}};this.gotoPage=function(cq,cp){var o=bC.getPageNumberFromString(cq);return R(o,cp)};var j=aU.gotoPageByIndex=function(o,cp){bY();bQ.gotoPage(o,cp)};var R=this.gotoPageNumeric=function(o,cp){if(isNaN(o)){return false}return j(o-1+aZ,cp)};aU.getFrontCoverIndex=function(){return Z};aU.getBackCoverIndex=function(){return by};aU.getFakePagesStart=function(){return aZ};aU.getFakePagesEnd=function(){return b0};aU.getRealPages=function(){return O};var bt=aU.sortNumeric=function(cp,o){return cp.nPage-o.nPage};var bh=function(o){b7.runPersistent("onInitFailed",[o])};var aa=function(ct,cv){var cD,cs,cp,cx;aZ=b0=0;if(cv.images===b){cv.images=[]}if(cv.images.length<1){bh("image list is empty")}b1=cv;b1._arImages=ct;bD=al("UniqueID","");if(bD.length<1){if(b1._arImages.length>0){bD=bC.getImageURL(b1._arImages[0])}}var cu=al("removepages","");if(cu.length>0){cu=cu.split(",")}if(cu.length>0){cu.sort(bt);for(cx=cu.length-1;cx>-1;cx--){cD=cu[cx]-1;if(cD>-1&&cD<b1.images.length){b1.images.splice(cD,1);ct.splice(cD,1)}}}var cz=al("emptyimages","");if(cz.length>0){cz=cz.split(",")}if(cz.length>0){cz.sort(bt);for(cx=0;cx<cz.length;cx++){cD=cz[cx]-1;if(cD>-1&&cD<b1.images.length){b1.images.splice(cD,0,{type:"blank"});ct.splice(cD,0,null)}}}cg=bT=aP("DoublePageMode",true);a3=(cg&&aP("AutoDoublePageMode",true));var cy=aP("FrontCover",true);var cA=aP("BackCover",true);var cC=false;cp=al("FrontCoverImage","");if(cp.length>0){cs={src:cp,fullImagePath:cp};b1.images.unshift(cs);b1._arImages.unshift(cp)}else{cC=aP("BlankFrontCover")}var cE=false;cp=al("BackCoverImage","");if(cp.length>0){cs={src:cp,fullImagePath:cp};b1.images.push(cs);b1._arImages.push(cp)}else{cE=aP("BlankBackCover")}O=b1.images.length;Z=by=b;if(cy){Z=1;if(cC){b1.images.unshift({type:"blank"});b1._arImages.unshift(null);O++}b1.images.unshift({});b1._arImages.unshift(null);aZ++}if(cA){if(cE){b1.images.push({type:"blank"});b1._arImages.push(null);O++}if((O+aZ)%2===0){b1.images.push({type:"blank"});b1._arImages.push(null);O++}by=b1.images.length-1;if((O+aZ)%2!==0){b1.images.push({});b1._arImages.push(null);b0++}}else{if(cg&&(O+aZ)%2===1){b1.images.push({type:"blank"});b1._arImages.push(null);O++}}if(O<1){q.error("No images to display.");return}if(Z!==b){b1.images[Z].cssClass="frontcover"}if(by!==b){b1.images[by].cssClass="backcover"}bH=b;for(cx=0;cx<b1.images.length;cx++){if(b1.images[cx].src!==b){if(bH!==b){bH=cx;break}else{bH=cx}}}x="PageLayoutGrid";var cw=al("PageLayout","flip").toLowerCase();if(cw==="flip"){x="PageLayoutFlip";var cB=al("PageBackFaceImage","");bg={bImageOnly:true,bNoBendEffect:true,cssClass:"fsi-pages-page-back-face"};if(cB.length>0){bg.src=bg.fullImagePath=cB}else{bg.type="blank"}}if(x==="PageLayoutFlip"){b1.images[-1]=bg;b1._arImages[-1]=bg.fullImagePath}aR();if(isNaN(aS.width)||isNaN(aS.height)){aS=b;if(bH===b){q.error("No image to measure aspect ratio of pages.")}else{var cr=b1.images[bH];var cq=bC.getImageInfoURL(cr.fullImagePath);bC.loadFile(cq,ae)}}else{H()}};var ae=function(cq,o){var cp=b1.images[bH];cp.width=parseInt(o.width);cp.height=parseInt(o.height);aR();if(isNaN(aS.width)||isNaN(aS.height)){q.error("Failed to measure page aspect ratio.")}else{H()}};var H=function(){if(bC.hasPlugin("bookmarks")){bN()}aX();bI=new a.PageToolTip(aq,aU);aU.oImageList=b1;h();b9.bRestore=false};var aj=function(){if(b9.bEnabled){return}b9.bEnabled=true;if(bQ){bQ.zoom(false,false)}aL.hideMenuToolTip();bm();if(bG&&b9.hideUI){bG.show(false);aD(0)}a.addClass(aq,"fsi-demo-mode");a.addEvent(cd,"click",ce);var o=bC.cfg.demotooltip;if(!a.isMobileDevice&&typeof(o)==="string"&&o.length>0){b9.bToolTip=true;b9.strTip=o;a.addEvent(cd,"mousemove",aG);a.addEvent(cd,"mouseout",ag)}else{b9.strTip="";b9.bToolTip=false}b7.runPersistent("onEnterDemoMode")};var aG=function(o){if(!b9.oToolTip){if(aU.getToolTip()){b9.oToolTip=aU.getToolTip();b9.bDestroyToolTip=false}else{b9.oToolTip=new a.ToolTip(aq);b9.oToolTip.setContent({});b9.bDestroyToolTip=true}}var cp=a.getElementClientPos(aq);b9.oToolTip.show(b9.strTip,null,o.clientX-cp.left,o.clientY-cp.top,b,100,true)};var ag=function(){if(b9.oToolTip){b9.oToolTip.hide()}};var au=function(){if(!b9.bEnabled){return}b9.bEnabled=false;aU.onUserAction();if(bG&&b9.hideUI){bG.show(true);aD(K)}a.removeClass(aq,"fsi-demo-mode");a.removeEvent(cd,"click",ce);if(b9.bToolTip){a.removeEvent(cd,"mousemove",aG);a.removeEvent(cd,"mouseout",ag);b9.oToolTip.hide();if(b9.bDestroyToolTip){b9.oToolTip.destroy();b9.oToolTip=b}}b7.runPersistent("onExitDemoMode")};var ce=function(){if(!b9.bEnabled){return}var cp=al("DemoURL");var cq=al("DemoURLTarget","_self");var o=b7.run("onClickDemoMode",[cp,cq]);if(o===false){return}if(cp==="no action"){return}if(cp==="enter fullscreen"){b9.bRestore=true;if(bC.hasPlugin("fullscreen")){aU.clickMenuButton("ToggleFullScreen",b,true)}}else{window.open(cp,cq)}};var h=function(){bc=aU.bAutoFlipCrop=aP("AutoFlipCropRect",true);if(typeof(bC.cfg.fullscreenelement)!=="undefined"){bW=bC.cfg.fullscreenelement}else{bW=cd}bG.setEnabled(true,true);aT();b7.runPersistent("onReady");if(W){W.onDataComplete()}if(S){d.iLinkEditor.onPagesReady(aL,aU,b6)}};var aT=function(){if(aP("IdleAutoTurn",false)){var o=bQ.getTargetPage(bQ.nMaxPageIndex);var cq=br("IdleAutoTurnMaxPage",o);m.nMaxPage=Math.min(o,cq);cq=br("IdleAutoTurnMinPage",1);m.nMinPage=Math.max(1,cq);if(m.nMinPage>m.nMaxPage){cq=m.nMinPage;m.nMinPage=m.nMaxPage;m.nMaxPage=cq}var cp=r("IdleAutoTurnDelay",1.5);var cr=Math.ceil(cp*1000);if(!isNaN(cr)&&cr>0){m.bForward=(bQ.getTargetPage(bQ.nCurrentPage)<m.nMaxPage);m.nInterval=setInterval(A,cr)}}};aU.onUserAction=function(){cm()};var cm=function(){if(m.nInterval===b){return}clearInterval(m.nInterval);m.nInterval=b};var A=function(){var o=bQ.getTargetPage(bQ.nCurrentPage);if(o<=m.nMinPage||o>=m.nMaxPage){m.bForward=(o<m.nMaxPage)}if(m.bForward){aL.nextPage()}else{aL.previousPage()}};z.onPageToolTip=function(cp,o){o[2]=cp;return cp};aU.showPageToolTip=function(cr,cs,o,cp){if(typeof(cr)==="string"&&cr.length<1){cr=false}if(bI){if(b7.isset("onPageToolTip")){if(cr===false){b7.run("onPageToolTip",[false])}else{var cq=b7.run("onPageToolTip",[cs.nIndex,cs.url,cr]);if(typeof(cq)==="string"){cr=cq}}}bI.show(cr,cs,o,cp)}};var bm=aU.hideToolTip=function(){if(bI){bI.hide();b7.runPersistent("onPageToolTip",[false])}};var p=aU.getMeasurePageIndex=function(){return bH};var aR=aU.getPageAspectRatio=function(){if(aS){return aS}aS={};var cu=al("Ratio","auto");var cp=true;if(typeof(cu)==="string"&&cu.toLowerCase()!=="auto"){cu=cu.split(":");if(cu.length===2){cu[0]=parseFloat(cu[0]);cu[1]=parseFloat(cu[1]);if(!isNaN(cu[0])&&cu[0]>0&&!isNaN(cu[1])&&cu[1]>0){cp=false;aS.width=100000*cu[0];aS.height=100000*cu[1]}}}if(cp){var o,ct;var cs=p();var cr=b1.images[cs];if(cr){o=cr.width;ct=cr.height}bS(cs-aZ,o,ct);var cq=new a.CroppedImage();cq.setSourceDimension(o,ct);cq.setCropFromConfig(bC.cfg);if(cq.isCropped()){var cv=cq.getPixelRangeRect();o=cv.right;ct=cv.bottom}aS.width=o;aS.height=ct}return aS};var bS=function(cq,o,cp){if(aH||o===b){return}aH=true;q.log("auto page aspect ratio from image #"+(cq+1)+": "+o+" : "+cp)};this.showAboutWindow=function(){if(be){be.destroy();be=b;return}var o={};o.title="About FSI Pages";o.fnOnDestroy=b4;o.strLongVersion=aL.getVersion();be=new a.AboutWindow(aq,o)};var b4=function(){if(be){be=b}return true};this.setFullScreenElement=function(o){if(ac){aK();a.FullScreen.quit()}bC.cfg.fullscreenelement=o};var aM=function(){q.error("ERROR entering FullScreen")};var bz=function(){aK()};var aK=function(){var o=a.FullScreen.getEnabled();if(o&&w()){return}if(o===ac){return}a.setCustomEventListenerProperty(cj,"skiptreshold",true);if(bG){bG.setButtonPressed("ToggleFullScreen",o)}b7.runPersistent("onFullScreen",[o]);ac=o;if(be){aL.showAboutWindow()}if(o===true){a.addClass(c,"fsi-fullscreen-element")}else{a.removeClass(c,"fsi-fullscreen-element")}if(!o){c=b}if(o){au()}else{if(b9.bRestore){aj();aT()}}};var aI=function(o){j(o.nIndex,true)};aU.getCurrentPageRange=function(){var o=aL.getTargetPage(bQ.nCurrentPage);var cp=bC.getPageNumber(o);if(ci.pageOptions.bGroupDoublePages&&o!==Z&&o+1<bQ.nMaxPageIndex){cp=cp+"-"+(cp+1)}return""+cp};aU.getMinMaxRealPages=function(){return{nMin:aZ,nMax:bQ.nMaxPageIndex}};var bN=function(){bF=document.createElement("div");bF.className="fsi-pages-bookmark-icon";var o={bDoublePages:bT};bi=new a.PagesBookmarks(aL,aU,b1,o);aU.bBookmarkIconsOnPages=aA=bi&&bC.getPluginParameter("bookmarks","showIconsOnPages",true,true)};aU.getLanguageString=function(cp,o){if(bA&&bA[cp]){return bA[cp]}else{return o}};var ad=aU.hideBookmarks=function(){if(bi&&bi.getVisible()){a6()}};var bj=function(o){if(!bi){return}var ct=bQ.getCurrentPage(false);var cq=bi.toggleBookmark(ct);var cs=bQ.getCurrentContainer();if(cs.iPage1){X(cs.iPage1,cq)}if(cs.iPage2){X(cs.iPage2,cq)}var cp=(cq)?"Bookmark added":"Bookmark removed";var cr;if(o===b){cr=bG.getButtonDomElement("ToggleBookmark")}else{cr=o.target;while(cr.parentNode&&!a.hasClass(cr,"fsi-ui-button")&&!a.hasClass(cr,"fsi-root")){cr=cr.parentNode}}bd.show(cp,cr,b,b,b,0);bd.hideAfter();aU.updateAddBookmarkButton(ct)};var a6=function(){if(bi===b){return}var o=!bi.getVisible();if(o){bY();if(g){g.lockShow("PageIndex")}bQ.lockShow("PageIndex")}else{if(g){g.unlockShow("PageIndex")}bQ.unlockShow("PageIndex")}ah(!o);bi.show(o);bG.setButtonPressed("ToggleBookmarkList",o);bG.enableButton("ToggleBookmark",!o)};var ba=function(){if(a0!==b){bl();bG.setButtonPressed("PrintPage",false)}else{b3();a0=new a.PagesPrintDialog(aL,aU,b1);b7.runPersistent("onShowPrintDialog",[true])}};var bl=aU.closePrintDialog=function(){if(a0!==b){bG.setButtonPressed("PrintPage",false);a0.destroy();a0=b;b7.runPersistent("onShowPrintDialog",[false])}};var i=function(){if(b8!==b){b3();bG.setButtonPressed("SavePage",false)}else{bl();b8=new a.PagesSaveDialog(aL,aU,b1);b7.runPersistent("onShowSaveDialog",[true])}};var b3=aU.closeSaveDialog=function(){if(b8!==b){bG.setButtonPressed("SavePage",false);b8.destroy();b8=b;b7.runPersistent("onShowSaveDialog",[false])}};var cl=function(){ad();if(V){C()}if(a2){a2.toggle()}};var ah=function(o){bG.enableButton("ZoomPage",o);bG.setButtonPressed("ZoomPage",bQ.bZoomed)};var C=aL.togglePageIndex=function(){var o;if(V){if(g){g.unlockShow("PageIndex")}bQ.unlockShow("PageIndex");o=false;V.destroy();V=b;ah(true);b7.runPersistent("onShowPageIndex",[false])}else{ad();ah(false);bQ.cancelScrolling();bQ.disableActiveLink();o=true;var cp={};cp.initialPageIndex=bQ.getCurrentPage();if(g){g.lockShow("PageIndex")}bQ.lockShow("PageIndex");cp.imageOptions={};if(al("effects")!==b){cp.imageOptions.effects=al("effects")}cp.elContainer=bb;cp.pageOptions={bInteractive:false,bImageOnly:true,bGroupDoublePages:bT,bPageNumbers:true};cp.bSelectFirstPage=true;cp.nScrollAnimationFrames=12;cp.nCreateAhead=0.2;cp.bScrollToCurrentTopPageAfterResize=true;cp.name="Index";cp.nConcurrentImageLoad=24;cp.onPageClick=aI;cp.strContainerClass="fsi-pages-thumbindex fsi-pages-scrollbar";cp.bCenterContent=true;var cq=br("ThumbSize",160);cp.thumbWidth=cp.thumbHeight=Math.max(80,cq);V=new a.PageLayoutGrid(aL,aU,b1,bC,cp);if(aA){V.onFinishPage=bu}V.init();b7.runPersistent("onShowPageIndex",[true])}bG.setButtonPressed("TogglePageIndex",o)};var k=aU.getConfigVal=function(cr,cq,o){cr=cr.toLowerCase();if(ak[cr]!==b){return ak[cr]}var cp=bC.cfg[cr];if(cp===b){cp=bC.getPagesParameter(cr);if(cp===b){cp=cq}}switch(o){case 1:cp=bC.makeBool(cp,cq);break;case 2:cp=parseInt(cp);if(isNaN(cp)){cp=cq}break;case 3:cp=parseFloat(cp);if(isNaN(cp)){cp=cq}break}ak[cr]=cp;return cp};this.debugLog=function(){q.log.apply(q,arguments)};this.debugWarn=function(){q.warn.apply(q,arguments)};this.debugError=function(){q.error.apply(q,arguments)};this.debugEnabled=function(){return q.on};var al=aU.cfgString=this.getConfigString=function(cp,o){return k(cp,o,0)};var aP=aU.cfgBool=this.getConfigBoolean=function(cp,o){return k(cp,o,1)};var br=aU.cfgInt=this.getConfigInt=function(cp,o){return k(cp,o,2)};var r=aU.cfgFloat=this.getConfigFloat=function(cp,o){return k(cp,o,3)};var co=function(o){bX=new a.PageInput(aL,aU,o)};var an=function(){var cp={dir:al("dir"),oMenu:bG};if(W){W.destroy()}W=new a.PagesSearchDialog(aL,aU,cp);var o=a.trim(al("SearchTextOnStart",""));if(o.length>0){W.search(o)}};this.searchForString=function(o){if(!W){q.error("search is not enabled");return false}if(typeof(o)!=="string"){q.error("searchForString expects string argument");return false}o=a.trim(o);if(o.length<1){return false}W.runSearch(o)};this.showSearchDialog=function(o){if(!W){return false}W.show(o)};var ck=function(){if(!bG){return}var cp=aU.arMenuButtons=[];if(aP("zoom",true)){cp.push({x:1,cmd:"ZoomPage",bCheckButton:1})}if(aP("print",true)){cp.push({cmd:"PrintPage",bCheckButton:1})}if(aP("save",false)){cp.push({cmd:"SavePage",bCheckButton:1})}var o=aP("ButtonsFirstLastPage",true);if(o){cp.push({cmd:"FirstPage"})}cp.push({cmd:"PreviousPage"});if(aP("PageInput",true)){cp.push({cmd:"PageInput",bNoMouseEvents:true,fnCreateInstance:aL,fnCreate:co});if(aP("PageInputEnterButton",true)){cp.push({cmd:"PageInputEnter"})}}cp.push({cmd:"NextPage"});if(o){cp.push({cmd:"LastPage"})}if(bC.hasPlugin("bookmarks")){cp.push({cmd:"ToggleBookmarkList",bCheckButton:1});cp.push({cmd:"ToggleBookmark"})}if(a2!==b){cp.push({cmd:"ToggleTableOfContents",bCheckButton:1})}if(aP("Index",true)){cp.push({cmd:"TogglePageIndex",bCheckButton:1})}if(bC.hasPlugin("fullscreen")){a.FullScreen.removeChangeEvents(window,bz,aM);a.FullScreen.addChangeEvents(window,bz,aM);cp.push({cmd:"ToggleFullScreen",bCheckButton:1})}bG.addButtons(cp,al("MenuButtonOrder"));if(aP("Search",false)===true){an()}};aU.getCommandRepeatCount=function(){return Q.nRepeatCount};var cf=function(o){if(o===b){o=Q.cmd;Q.nRepeatCount++}switch(o){case"NextPage":bQ.nextPage();break;case"PreviousPage":bQ.previousPage();break}if(Q.nRepeatCount===1){if(Q.intervalTimeFirst!==Q.intervalTimeRepeat){clearInterval(Q.interval);Q.interval=setInterval(cf,Q.intervalTimeRepeat)}}};var af=function(cq,o,cp){bE();Q={};Q.bRunning=true;if(o===b){o=500}Q.intervalTimeFirst=o;if(cp===b){Q.intervalTimeRepeat=o}else{Q.intervalTimeRepeat=cp}Q.nRepeatCount=0;Q.cmd=cq;Q.interval=setInterval(cf,Q.intervalTimeFirst);cf(cq)};var bE=function(){if(!Q.bRunning){return}clearInterval(Q.interval);switch(Q.cmd){case"NextPage":case"PreviousPage":break}Q={}};var Y=function(cp,o){return bG.enableButton(cp,o)};var bY=aU.exitIndexAndZoom=function(){ad();if(V){C()}if(a2){a2.show(false)}};var B=this.clickMenuButton=function(o){aU.pressMenuButton(o,b,true);aU.releaseMenuButton(o,b,true);aU.clickMenuButton(o,b,true)};this.pressMenuButton=function(o){bG.pressButton(o)};this.releaseMenuButton=function(o){bG.releaseButton(o)};this.nextPage=function(){B("NextPage")};this.previousPage=function(){B("PreviousPage")};this.firstPage=function(){B("FirstPage")};this.lastPage=function(){B("LastPage")};aU.pressMenuButton=function(cq,o,cs){if(W){W.closeDialog()}if(!cs){aU.onUserAction()}bE();var cp,cr;if(cq.indexOf("_")!==-1){cp=cq.split("_");cq=cp[0];cr=cp[1]}switch(cq){case"NextPage":case"PreviousPage":bY();af(cq,500,200);break}};aU.releaseMenuButton=function(cp,o,cq){if(!cq){aU.onUserAction()}bE()};aU.clickMenuButton=function(cr,o){var cp,cs;if(typeof(cr)==="string"&&cr.indexOf("_")!==-1){cp=cr.split("_");cr=cp[0];cs=cp[1]}switch(cr){case"ToggleTableOfContents":cl();break;case"TogglePageIndex":if(a2){a2.show(false)}C();break;case"ToggleFullScreen":if(a.FullScreen.getEnabled()){aK();a.FullScreen.quit()}else{var cq=bW;if(typeof(cq)==="string"){cq=document.getElementById(cq);if(cq===b){cq=cd}}c=cq;a.addClass(cq,"fsi-viewer");a.FullScreen.start(cq);aK()}break;case"ZoomPage":bQ.toggleZoom(true);break;case"PrintPage":ba();break;case"SavePage":i();break;case"ToggleBookmarkList":a6();break;case"ToggleBookmark":bj(o);break;case"FirstPage":bY();bQ.firstPage();break;case"LastPage":bY();bQ.lastPage();break}};var bv=aU;bv.iViewer=aL;bv.getDebug=function(){return q};bv.getToolTip=function(){return bd};bv.getLanguageData=function(){return bA};bv.getElementSpace=function(){return aC};bv.getRootContainer=function(){return aq};bv.getParentElement=function(){return cd};bv.getCallbacks=function(){return b7};bv.getIsFullScreen=function(){return ac};bv.gotoPage=function(o){bQ.gotoPage(o,bAnimate)};bv.getMenu=function(){return bG};bv.getMenuHeight=function(){var o=0;if(bG){o=bG.getHeight()}return o};bv.getPageToolTip=function(){return bI};bv.getPageNumberString=aQ;if(typeof(d)!=="object"||a.makeBool(d.autoInit,true)){aL.init(aE,d)}};a.customTags.register("fsi-pages",{constructorClass:a.Pages,viewerCSS:"display:block;width:300px;height:300px;"});a.PagesIntroContentData=function(d){var c;this.init=function(){d.style.display="none";c=d.parentNode;if(c&&c.tagName==="FSI-PAGES"&&typeof(c.addListener)==="function"){c.addListener("onGetIntroContent",e)}};var e=function(){c.removeListener("onGetIntroContent",e);c.removeChild(d);return d}};a.customTags.register("fsi-pages-intro-content",{constructorClass:a.PagesIntroContentData,viewerCSS:"display:none;"});a.dispatchEvent("FSIPagesLoaded")}(window.$FSI=window.$FSI||{}));