/*!
 * FSI Quick Zoom
 * Build: 19.10.6785
 * 
 * Copyright (c) 2019 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function(k,d){if(k.fnDoNothing!==d){return}k.fnDoNothing=function(){};if(typeof(console.error)!=="function"){k.console={};k.console.log=k.fnDoNothing;k.console.logCSS=k.fnDoNothing;k.console.warn=k.fnDoNothing;k.console.error=k.fnDoNothing;k.console.dir=k.fnDoNothing;k.console.info=k.fnDoNothing}else{k.console=console;if(typeof(console.timeLog)==="function"){k.console.logCSS=console.log}else{k.console.logCSS=function(e){e=e.replace(/%c/g,"");console.log(e)}}}if(typeof(window.requestAnimationFrame)!=="function"){var b=0;var m=["ms","moz","webkit","o"];for(var l=0;l<m.length&&!window.requestAnimationFrame;++l){window.requestAnimationFrame=window[m[l]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m[l]+"CancelAnimationFrame"]||window[m[l]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(q){var e=new Date().getTime();var i=Math.max(0,16-(e-b));var p=window.setTimeout(function(){q(e+i)},i);b=e+i;return p};window.cancelAnimationFrame=function(e){clearTimeout(e)}}}k.initCustomTag=k.initCustomTags=k.fnDoNothing;k.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};k.osVersion=[0,0,0];var c=navigator.userAgent.toLowerCase();var o,n,f;if(c.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){o=true;if(c.search("android")>-1){k.mobileOS="android";k.isTouch=true;k.noMouse=true;n=c.match(/android (\S*)/);if(n&&n.length>1){n=n[1].split(".");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}else{if(c.indexOf("mac os")!==-1){k.mobileOS="ios";k.isTouch=true;k.noMouse=true;n=c.match(/ os (\S*)/);if(n&&n.length>1){n=n[1].split("_");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}}}else{o=false}k.isMobileDevice=o;k.isSmallMobileDevice=(c.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);k.isInternetExplorer=false;k.isIETouch=false;if(c.search("msie")>-1){k.isInternetExplorer=true;n=c.match(/msie ([^;]*)/);if(n&&n.length>1){k.versionInternetExplorer=parseFloat(n[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){k.isInternetExplorer=true;k.versionInternetExplorer=parseFloat(RegExp.$1)}else{k.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");if(k.isInternetExplorer){k.versionInternetExplorer=12}}}if(window.navigator.msPointerEnabled){k.isIETouch=(window.navigator.msMaxTouchPoints>1)}if(!k.isTouch){k.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(c.search("chrome")!==-1&&c.search("edge")===-1){k.isChrome=true}else{if(c.search("safari")!==-1){k.isSafari=true}else{if(c.search("firefox")!==-1){k.isFirefox=true}else{if(c.search("opera")!==-1){k.isOpera=true}}}}if(c.search("mac os")>-1){k.isMac=true}if(typeof(window.pageYOffset)==="number"){k.getDocumentScroll=function(e){return{x:e.pageXOffset,y:e.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.body.scrollLeft,y:e.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.documentElement.scrollLeft,y:e.document.documentElement.scrollTop}}}}}if(typeof(window.devicePixelRatio)!=="undefined"){k.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{k.getDevicePixelRatio=function(){return 1}}k.preventDefaultEvent=function(e){if(e.preventDefault){e.preventDefault()}e.returnValue=false;return false};k.getElementDimension=function(e){return{width:e.offsetWidth,height:e.offsetHeight}};k.getViewportSize=function(i){var e;if(!i){i=window}if(k.BrowserSupports.visualViewportAPI()){e={width:i.visualViewport.width,height:i.visualViewport.height}}else{e={width:i.innerWidth,height:i.innerHeight}}return e};k.replaceChild=function(q,s,i){try{var p=s.nextSibling;if(p){q.removeChild(s);q.insertBefore(i,p)}else{q.appendChild(i)}}catch(r){k.console.error(r.message);k.console.log(q);k.console.log(s);k.console.log(i)}};k.removeChild=function(i,q){try{i.removeChild(q)}catch(p){k.console.error(p.message);k.console.log(i);k.console.log(q)}};k.getWindowOffset=function(r){var q=0;var p=0;try{if(r.frameElement){var i=r;while(i.frameElement){var s=i.frameElement;var u=k.getElementPosition(s);q+=u.left;p+=u.top;i=i.parent}}}catch(t){}return{x:q,y:p}};var a=document.createElement("div");try{a.getBoundingClientRect();k.getBoundingClientRect=function(e){return e.getBoundingClientRect()}}catch(h){k.getBoundingClientRect=function(i){try{return i.getBoundingClientRect()}catch(p){return{top:0,left:0,right:0,bottom:0,width:0,height:0}}}}k.getElementClientDim=function(e){var i=k.getBoundingClientRect(e);return{width:(i.right-i.left),height:(i.bottom-i.top)}};k.getElementClientPos=function(e){return k.getBoundingClientRect(e)};k.getElementPosition=function(v){var i=k.getBoundingClientRect(v);var t=v.clientLeft;var B=v.clientTop;var C=0;var x=0;var u=0;var r=0;var D=0;var A=0;try{var q=window.getComputedStyle(v,null);u=parseFloat(q.paddingLeft);r=parseFloat(q.paddingRight);D=parseFloat(q.paddingTop);A=parseFloat(q.paddingBottom);t=parseFloat(q.borderLeftWidth);C=parseFloat(q.borderRightWidth);B=parseFloat(q.borderTopWidth);x=parseFloat(q.borderBottomWidth)}catch(w){}var s=i.left+t+u;var z=i.top+B+D;var p=i.right-C-r;var y=i.bottom-x-A;return{left:s,top:z,right:p,bottom:y}};k.dispatchEvent=function(e){var i;if(k.BrowserSupports.genericEvent()){i=new Event(e)}else{i=document.createEvent("Event");i.initEvent(e,true,true)}if(i){return window.dispatchEvent(i)}else{return false}};k.removeEvent=function(q,i,p,e){if(window.removeEventListener&&q){if(e===d){e=true}q.removeEventListener(i,p,e)}else{if(window.detachEvent&&q){q.detachEvent("on"+i,p)}}};k.addEvent=function(q,i,p,e){if(window.addEventListener&&q){if(e===d){e=true}q.addEventListener(i,p,e)}else{if(window.attachEvent&&q){q.attachEvent("on"+i,p)}}};k.sign=Math.sign||function(i){var e;if(isNaN(i)){e=NaN}else{if(i===0){e=0}else{e=(i<0)?-1:1}}return e};k.trim=function(e){if(!e||typeof(e)!=="string"||e.length<1){return e}return e.replace(/(^\s+)|(\s+$)/g,"")};var j=k.escapeRegEx=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};k.addClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};k.addClass(p,q);e.setAttribute("class",p.className)};k.removeClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={removeAttribute:k.fnDoNothing,className:i};k.removeClass(p,q);if(p.className!==""){e.setAttribute("class",p.className)}else{e.removeAttribute("class")}};k.hasClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};return k.hasClass(p,q)};k.addClass=function(i,r){if(!i||typeof(i.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var q=j(r);var p=new RegExp("(^|\\s+)"+q+"(\\s+|$)");var s=k.trim(i.className);var e=s.match(p);if(!e){if(s.length>0){s+=" "+r}else{s+=r}i.className=s}};k.removeClass=function(e,r){if(!e||typeof(e.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");var q=k.trim(e.className.replace(i," "));if(q.length>0){e.className=q}else{e.removeAttribute("class")}};k.hasClass=function(e,r){if(typeof(r)!=="string"){return false}r=k.trim(r);if(r.length<1){return false}var q=e.className;if(typeof(q)!=="string"||q.length<1){return false}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");return(q.match(i)!=null)};k.getFSIServerImageDim=function(e,r,p,t,i,q){var u={width:e,height:r};var s={width:p,height:t};k.calcFSIServerImageDim(u,s,i,q);return s};k.calcFSIServerImageDim=function(e,i,q,r){if(typeof(q)!=="object"){q={left:0,top:0,width:1,height:1}}else{q.left=q.left<0?0:q.left>1?1:q.left;q.top=q.top<0?0:q.top>1?1:q.top;q.width=q.width<0?1-q.left:q.width+q.left>1?1-q.left:q.width;q.height=q.height<0?1-q.top:q.height+q.top>1?1-q.top:q.height}i.width=i.width<=0||i.width===d?-1:i.width;i.height=i.height<=0||i.height===d?-1:i.height;var u={};if(i.width!==-1&&i.height!==-1){u.x=i.width/(e.width*q.width);u.y=i.height/(e.height*q.height)}else{if(i.height===-1){u.x=u.y=i.width/(e.width*q.width)}else{u.x=u.y=i.height/(e.height*q.height)}}if(i.width===-1||i.height===-1){var t=Math.min(u.x,u.y);if(i.width===-1){i.width=Math.round(e.width*q.width*t)}else{if(i.height===-1){i.height=Math.round(e.height*q.height*t)}}u.x=t;u.y=t}if(r&&Math.abs(u.x-u.y)>1e-7){if(u.x>u.y){var p=i.height*e.width*q.width/(e.height*q.height);u.x=p/e.width;i.width=Math.round(p)}else{var s=i.width*e.height*q.height/(e.width*q.width);u.y=s/e.height;i.height=Math.round(s)}}i.width=i.width===0?1:i.width;i.height=i.height===0?1:i.height;return u};k.BrowserSupports={};k.BrowserSupports[false]=function(){return false};k.BrowserSupports[true]=function(){return true};k.BrowserSupports.localStorage=function(){var i=false;try{if(typeof(window.localStorage)!=="undefined"&&typeof(localStorage.setItem)==="function"){i=true}}catch(p){}k.BrowserSupports.localStorage=k.BrowserSupports[i];return i};k.BrowserSupports.visualViewportAPI=function(){var i=false;try{if(typeof(window.visualViewport)!=="undefined"){i=true}}catch(p){}k.BrowserSupports.visualViewportAPI=k.BrowserSupports[i];return i};k.BrowserSupports.genericEvent=function(){var i=false;try{if(typeof(window.Event)==="function"){i=true}}catch(p){}k.BrowserSupports.genericEvent=k.BrowserSupports[i];return i};k.BrowserSupports.customElementRegistry=function(){var i=false;try{if(typeof(window.customElements)==="object"&&typeof(window.customElements.define)==="function"){i=true}}catch(p){}k.BrowserSupports.customElementRegistry=k.BrowserSupports[i];return i};k.BrowserSupports.registerElement=function(){var i=false;try{if(typeof(document.registerElement)==="function"){i=true}}catch(p){}k.BrowserSupports.registerElement=k.BrowserSupports[i];return i};k.BrowserSupports.canvas=function(){var q=false;try{var p=document.createElement("canvas");var i=p.getContext("2d");if(i&&i.clearRect!==d){q=true}}catch(r){}k.BrowserSupports.canvas=k.BrowserSupports[q];return q};k.BrowserSupports.cssTouchAction=function(){var p=false;try{if(k.isTouch){if(typeof(window.getComputedStyle)==="function"){var i=window.getComputedStyle(document.body);p=(typeof(i.touchAction)==="string")}}}catch(q){}k.BrowserSupports.cssTouchAction=k.BrowserSupports[p];return p};var g=Boolean(k.isMobileDevice||k.isIETouch||k.isTouch||(k.isMac&&k.isSafari));k.BrowserSupports.documentZoom=k.BrowserSupports[g]}(window.$FSI=window.$FSI||{}));(function($FSI,undefined){if($FSI.Utils!==undefined){return}$FSI.Utils=function(){var self=this;var addedCSSBlocks={};var rgxThousandSeperator=/(\d+)(\d{3})/;var regexPlusToSpace=/\+/g;var regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;var regExServerFormat1=/(&)?format=[^&]*/ig;var regExServerFormat2=/\?&/;var documentScaleMethod;var __getMediaMinScreenWidthCount=0;var __getMediaMinScreenWidthLoopCount=0;var __LastGetMediaMinScreenWidthResult;var __LastGetMediaMinScreenWidth;var __getDocumentScaleReferenceWidth;var strCSSTransformStyleName;var iLoaderCSSSkin;var iLoaderJavascript;this.oLanguageMap=undefined;this.API={};var topWindow;var strFSIViewerURL;try{if(typeof(top.window.alert)==="function"){topWindow=top.window}else{topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");topWindow=window}var oMatchMedia=topWindow.matchMedia||topWindow.msMatchMedia;this.getTopWindow=function(){return topWindow};var callbackFunctionID=0;this.getNewCallbackFunctionID=function(){return callbackFunctionID++};var nViewerInstanceID=0;this.getViewerInstanceID=function(){return ++nViewerInstanceID};var oSupportedEvents={};$FSI.isEventSupported=function(eventName){if(oSupportedEvents[eventName]!==undefined){return oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;oSupportedEvents[eventName]=isSupported;return isSupported};this.getSVGNameSpaceURL=function(){return"http://www.w3.org/2000/svg"};var nSVGID=0;this.getSVGID=function(){return"$FSI.SVGID_"+nSVGID++};var oClassDefCreated={};this.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;if(oOptions.bNoAPI!==true){instance.getAPIData=function(){return self.oAPI}}this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){if(obj.hasOwnProperty(o)){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,strResult,strType,itm;var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{$FSI.console.log("\r\n"+strTitle+" of "+strVersionString+line)}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a===undefined){ar[i].a="void"}args="%c( "+ar[i].a+" )"}else{args="%c"}strResult=(ar[i].r===undefined)?"%c":"%c"+strReturn+ar[i].r;strType=(ar[i].t===undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]===undefined){nNotAvailable++;itm+=" [x]"}$FSI.console.logCSS(itm,"color:#00a;","color:green;")}if(nNotAvailable>0){$FSI.console.logCSS("%c\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options","color:#c50")}if(fnGroup!==undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)==="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)==="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!==undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)==="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!==undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!oClassDefCreated[strClassName]){oClassDefCreated[strClassName]=true;if(instance.getBuild()!==$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};new self.ClassDef($FSI,"FSI Core",{strVersion:"2019",strBuild:"19.10.6785",bNoAPI:true});this.mergeObjects=function(o1,o2){for(var o in o2){if(o2.hasOwnProperty(o)){o1[o]=o2[o]}}return o1};this.cloneArray=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}return ar.concat([])};this.cloneArrayRecursive=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=self.cloneValue(ar[i])}return ret};this.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=self.cloneArrayRecursive(val)}else{ret=self.cloneObject(val)}}break;default:ret=val}return ret};this.cloneObject=function(obj){if(typeof(obj)!=="object"){return{}}if(obj==null){return null}var ret={};if(typeof(obj)==="object"&&typeof(obj.push)==="function"){ret=self.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=self.cloneValue(obj[o])}}return ret};this.cloneParameters=function(parameters){return self.cloneObject(parameters)};var regExEffects=/((\?)|&)effects=([^&]*)/ig;var regExPadEffect=/[=,]+Pad\([^)]*/ig;this.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match(regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match(regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};var documentDomain=document.location.hostname;var regCors=new RegExp("//"+documentDomain+"[:/]");this.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match(regCors)==null};this.loadImageCors=function(img,url){if(self.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};var oBoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=oBoolTable[value];if(ret===undefined){ret=def}}return ret};this.getBoolTable=function(val){return oBoolTable[val]};var oCustomEventListenerClasses={};var oCustomEventListenerInstances={};var oCustomEventListeners={};var nCustomEventListeners=0;var nCustomEventListenerID=0;var nCustomEventFunctionID=0;var nCustomEventElementID=0;this.customEventClassExists=function(nam){return(oCustomEventListenerClasses[nam]!==undefined)};this.getCustomEventListenerInstance=function(myEvent){return new oCustomEventListenerClasses[myEvent]()};this.registerCustomEvent=function(nam,fnClass){if(oCustomEventListenerClasses[nam]){return false}oCustomEventListenerClasses[nam]=fnClass};this.getNewEventElementID=function(){return nCustomEventElementID++};this.getNewEventFunctionID=function(){return nCustomEventFunctionID++};$FSI.addCustomEvent=function(myObj,myEvent,myFunc){var obj,listenerID;var listener=oCustomEventListenerInstances[myEvent];if(!listener){if(typeof(oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is missing.");return false}listener=oCustomEventListenerInstances[myEvent]=new oCustomEventListenerClasses[myEvent]()}obj=listener.addListener(myObj,myFunc);if(obj!==undefined){listenerID=obj.nCustomEventListenerID=nCustomEventListenerID++;oCustomEventListeners[obj.nCustomEventListenerID]=obj;nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc){var listener=oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&oCustomEventListeners[obj.nCustomEventListenerID]!==undefined){delete oCustomEventListeners[obj.nCustomEventListenerID];nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};var createJavascriptLoader=function(){if(!iLoaderJavascript){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!createJavascriptLoader()){return false}return iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!createJavascriptLoader()){return false}return iLoaderJavascript.release(strScriptPath,idInstance)};this.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof(iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};this.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};this.setStyleAttr=function(el,strStyle){
/*@cc_on
			 @if (@_jscript_version < 9)
			 el.style.setAttribute('cssText', strStyle);
			 @else @*/
el.setAttribute("style",strStyle);
/*@end
			 @*/
};this.changeRendererInURL=function(url,strRenderer){url=url.replace(regExServerRenderer,"$1renderer="+strRenderer);return url};this.removeFormatInURL=function(url){url=url.replace(regExServerFormat1,"");url=url.replace(regExServerFormat2,"?");return url};this.urlEncode=function(str){if(!str){return str}try{str=encodeURIComponent(str)}catch(e){$FSI.console.error("Malformed URI: "+str)}str=str.replace(regexPlusToSpace,"%2B");return str};this.getCSSTransformStyleName=function(){if(strCSSTransformStyleName!==undefined){return strCSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!=="translate( 0 , 0)"){ret=ar[i];break}}div=null;strCSSTransformStyleName=ret;return ret};var oViewerClassCSSRules={};var oInsertedCSS;this.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=oViewerClassCSSRules[strClass];if(res===strRule){return}addCSSRule(strClass,strRule,0);oViewerClassCSSRules[strClass]=strRule};this.dumpCSS=function(){console.log("Viewer Class CSS");console.log(oViewerClassCSSRules);console.log("CSS blocks");console.log(addedCSSBlocks);console.log("CSS in FSI.CORE");console.dir(oInsertedCSS.sheet.rules)};this.cssClassExists=function(cssID){return(typeof(addedCSSBlocks[cssID])!=="undefined")};this.addCSSClass=function(cssID,strCode){if(self.cssClassExists(cssID)){return false}var node=addCSSNode(cssID);if(node){try{node.innerHTML=strCode;addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};var addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("data-generated-by","FSI");node.setAttribute("data-generated-for",cssID);node.setAttribute("data-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};this.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!==undefined&&ar.length>0){for(var i=0;i<ar.length;i++){deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};this.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors===undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);addCSSRule(strSelector,strRule,0)};var addCSSRule=function(selector,rules,index){if(oInsertedCSS===undefined){oInsertedCSS=addCSSNode("FSI.Core")}if(oInsertedCSS!==undefined){try{if(oInsertedCSS&&oInsertedCSS.sheet){if("insertRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};var deleteCSSRule=function(selector){var ret=false;var i;if(oInsertedCSS!==undefined){try{var arDelete=[];var ar=oInsertedCSS.sheet.cssRules;for(i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText===selector){arDelete.push(i)}}if(arDelete.length>0){for(i=arDelete.length-1;i>-1;i--){oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};this.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};this.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};this.getElementBorders=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.borderLeftWidth);ret.top=parseFloat(style.borderTopWidth);ret.right=parseFloat(style.borderRightWidth);ret.bottom=parseFloat(style.borderBottomWidth)}catch(e){}return ret};this.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};var getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};this.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};this.guessFSIViewerLocation=function(strScriptName,depth){if(strFSIViewerURL!==undefined){return strFSIViewerURL}var ret=self.getScriptPath(strScriptName,depth);if(ret){strFSIViewerURL=ret}return ret};var bHTTPS=(document.location.protocol==="https:");this.isHTTPS=function(){return bHTTPS};$FSI.getViewerLocation=function(){return strFSIViewerURL};this.getNumberSeperators=function(iConfig){var lngEng={english:1,japanese:1,chinese_simplified:1,chinese_traditional:1};var lng;if(!iConfig||!iConfig.cfg||typeof(iConfig.cfg.language)!=="string"){lng="english"}else{lng=iConfig.cfg.language.toLowerCase()}return(lngEng[lng])?{thousand:",",decimal:"."}:{thousand:".",decimal:","}};this.makeNiceNumber=function(val,dec,oNumberSep){if(!oNumberSep){oNumberSep={thousand:",",decimal:"."}}if(dec===undefined){dec=0}val=val.toFixed(dec);val=""+val;val=val.split(".");var ret=val[0];while(rgxThousandSeperator.test(ret)){ret=ret.replace(rgxThousandSeperator,"$1"+oNumberSep.thousand+"$2")}if(dec>0){ret+=oNumberSep.decimal+val[1]}return ret};this.makeNiceFileSize=function(n,oNumberSep){var u="byte";if(n>1024){n/=1024;u="KB"}if(n>1024){n/=1024;u="MB"}if(n>1024){n/=1024;u="GB"}if(n>1024){n/=1024;u="TB"}if(u!=="byte"){n=self.makeNiceNumber(Math.round(100*n)/100,2,oNumberSep)}else{n=self.makeNiceNumber(n,0,oNumberSep)}return n+" "+u};this.getCSSColor=function(val){if(typeof(val)==="string"&&val.length>0){val=$FSI.trim(val);if(val.match(/^[0-9,a-f]{3}$/i)||val.match(/^[0-9,a-f]{6}$/i)){val="#"+val.toUpperCase()}}return val};var getMediaMinScreenWidth=function(nam,unit){var init=topWindow.document.documentElement.clientWidth;if(__LastGetMediaMinScreenWidth===topWindow.document.documentElement.clientWidth){return __LastGetMediaMinScreenWidthResult}__LastGetMediaMinScreenWidth=topWindow.document.documentElement.clientWidth;__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}__LastGetMediaMinScreenWidthResult=__getDocumentScaleReferenceWidth=init-step;return __LastGetMediaMinScreenWidthResult};this.getDocumentScaleMethod=function(){return documentScaleMethod};this.getDocumentScaleNone=function(){return 1};this.getDocumentScaleInit=function(){self.getDocumentScale=self.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){documentScaleMethod="visualViewport API";self.getDocumentScale=function(){return topWindow.visualViewport.scale};return self.getDocumentScale()}if(topWindow.innerWidth===undefined){documentScaleMethod="none";return self.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";self.getDocumentScale=function(){if(screen.width!==topWindow.outerWidth){return(topWindow.outerWidth-192)/topWindow.innerWidth}return(topWindow.outerWidth-83)/topWindow.innerWidth};return self.getDocumentScale()}if(window.orientation!==undefined){if(!window.outerWidth){documentScaleMethod="screen.width / window.innerWidth iOS";self.getDocumentScale=function(){__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return __getDocumentScaleReferenceWidth/window.innerWidth};return self.getDocumentScale()}documentScaleMethod="window.outerWidth / window.innerWidth";self.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return self.getDocumentScale()}if(oMatchMedia&&topWindow.document.documentElement.clientWidth>0){var w=getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){documentScaleMethod="CSS Media Query";self.getDocumentScale=function(){var res=getMediaMinScreenWidth("min-width","px")/topWindow.innerWidth;if(isNaN(res)){res=1}return res};return self.getDocumentScale()}}documentScaleMethod="fallback";self.getDocumentScale=function(){return topWindow.outerWidth/topWindow.innerWidth};return self.getDocumentScale()};self.getDocumentScale=self.getDocumentScaleInit;self.getDocumentScaleWithPixelRatio=function(){return self.getDocumentScale()*$FSI.getDevicePixelRatio()};self.getImageDimFitInto=function(wSrc,hSrc,wMax,hMax,oCroppedImage,bNoLimitToSourceDim){var ret={};var wSrcOrg=wSrc;var hSrcOrg=hSrc;if(!bNoLimitToSourceDim){wMax=Math.min(wSrc,wMax);hMax=Math.min(hSrc,hMax)}var bCropped=oCroppedImage&&oCroppedImage.isCropped();if(bCropped){oCroppedImage.setSourceDimension(wSrc,hSrc);var rc=oCroppedImage.getPixelRangeRect();wSrc=rc.right;hSrc=rc.bottom}if(wSrc/wMax>hSrc/hMax){ret.width=wMax;ret.height=Math.round(hSrc/wSrc*wMax)}else{ret.height=hMax;ret.width=Math.round(wSrc/hSrc*hMax)}if(bCropped){ret.widthUncropped=Math.round(ret.width*wSrcOrg/wSrc);ret.heightUncropped=Math.round(ret.height*hSrcOrg/hSrc)}else{ret.widthUncropped=ret.width;ret.heightUncropped=ret.height}return ret};self.extendRectToFill=function(rc,srcWidth,srcHeight,targetWidth,targetHeight,bAllowInvalidRect,bAllowMove){var amount;var wCur=rc.width()*srcWidth;var hCur=rc.height()*srcHeight;var dim=self.fitImageIntoSpace(wCur,hCur,targetWidth,targetHeight,true,true);if(dim.width/targetWidth<dim.height/targetHeight){amount=(targetWidth/dim.width-1)*rc.width();rc.left=rc.left-amount/2;rc.right=rc.right+amount/2;if(bAllowMove){if(rc.right>1){rc.offsetRect(-(rc.right-1),0)}else{if(rc.left<0){rc.offsetRect(-rc.left,0)}}}}else{amount=(targetHeight/dim.height-1)*rc.height();rc.top=rc.top-amount/2;rc.bottom=rc.bottom+amount/2;if(bAllowMove){if(rc.bottom>1){rc.offsetRect(0,-(rc.bottom-1))}else{if(rc.top<0){rc.offsetRect(0,-rc.top)}}}}if(!bAllowInvalidRect){rc.limitToImageRect()}};this.fitImageIntoSpace=function(wSrc,hSrc,wTarget,hTarget,bDoNotLimitToSrcDim,bFloats){if(!bDoNotLimitToSrcDim){wTarget=Math.min(wTarget,wSrc);hTarget=Math.min(hTarget,hSrc)}var ret={};if(wTarget/wSrc<hTarget/hSrc){ret.dim="width";if(bDoNotLimitToSrcDim){ret.width=wTarget}else{ret.width=Math.min(wTarget,wSrc)}ret.height=ret.width*hSrc/wSrc}else{ret.dim="height";if(bDoNotLimitToSrcDim){ret.height=Math.min(hTarget,hSrc)}else{ret.height=hTarget}ret.width=ret.height*wSrc/hSrc}if(!bFloats){ret.width=Math.round(ret.width);ret.height=Math.round(ret.height)}return ret};this.getParameterValueFromURL=function(url,nam){var ret=undefined;if(typeof(url)==="string"&&typeof(nam)==="string"&&nam.length>0&&url.length>0){nam=$FSI.escapeRegEx(nam);var reg=new RegExp("(\\?|&)"+nam+"=([^&]*)");var match=url.match(reg);if(match&&match[2]){ret=decodeURIComponent(match[2])}}return ret}};if(!$FSI.utils){$FSI.utils=new $FSI.Utils()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomTags!==b){return}a.CustomTags=function(){var g={};var e=false;var f=(a.BrowserSupports.registerElement()||a.BrowserSupports.customElementRegistry());var d=this.initCustomTags=function(){if(f){return false}for(var h in g){if(g.hasOwnProperty(h)){c(h)}}return true};var c=this.initCustomTag=function(l){if(f){return false}var k=g[l];if(!k){return false}var h=document.getElementsByTagName(l);if(h.length>0){k.replaceTagInit()}if(h&&h.length>0){for(var j=0;j<h.length;j++){k.replaceTag(h[j],k)}}return true};this.get=function(h){return g[h]};this.register=function(i,h){if(g[i]===b){g[i]=new a.CustomTag(i,h);if(!e){e=true;if(!f){a.addEvent(window,"DOMContentLoaded",d)}}a.customTags.initCustomTag(i)}return g[i]}};a.CustomTag=function(f,c){var q=this;var h;this.opts=c;var p=function(){a.utils.addViewerClassCSSRule(f,c.viewerCSS);if(a.BrowserSupports.customElementRegistry()){j()}else{if(a.BrowserSupports.registerElement()){l()}}};var e=function(s,t){var r=s.getAttribute(t);if(typeof(r)==="string"&&r.length>0){if(!r.match(/[^0-9\s]/)){r+="px"}s.style[t]=r}};var k=function(r){e(r,"width");e(r,"height")};var i=function(u){var r=a.utils.attributes2parameters(u);if(c.parameterAliases){var v=c.parameterAliases;for(var t in v){if(v.hasOwnProperty(t)){var s=v[t];if(r[t]!==b&&r[s]===b){r[s]=r[t]}}}}if(r.src!==b&&r.imagesrc===b){r.imagesrc=r.src}return r};var j=function(){window.customElements.define(f,n)};var g=this.onCreated=function(){c.constructorClass.prototype.constructor.call(this,this,{autoInit:false})};var o=this.onAttached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}m(this)};var m=function(r){k(r);r.init(r,i(r),b,true);if(typeof(r.start)==="function"){r.start()}};var d=this.onDetached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}if(typeof(this.destroyOnDetach)==="function"){this.destroyOnDetach()}};var l=function(){var r=Object.create(HTMLDivElement.prototype);r.createdCallback=g;r.attachedCallback=o;r.detachedCallback=d;document.registerElement(f,{prototype:r})};this.replaceTag=function(s,r){if(!s||(typeof(s.getInitDone)==="function"&&s.getInitDone())){return}if(r.opts.bConfigTag!==true){c.constructorClass.prototype.constructor.call(s,s,{autoInit:false});m(s)}else{c.constructorClass.prototype.constructor.call(s);s.init(s,i(s),false,true)}};this.replaceTagInit=function(){if(h){return}h=true;a.utils.addViewerClassCSSRule(f,c.viewerCSS)};var n;if(window.Reflect){n=function(){var r=window.Reflect.construct(HTMLElement,[],this.constructor);g.apply(r);return r};n.prototype=Object.create(HTMLElement.prototype);n.prototype.constructor=n;n.prototype.connectedCallback=o;n.prototype.disconnectedCallback=d}p()};if(!a.customTags){a.customTags=new a.CustomTags();a.initCustomTags=a.customTags.initCustomTags;a.initCustomTag=a.customTags.initCustomTag}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!==b){return}a.Config=function(al,x,f){if(typeof(f)!=="object"){f={}}if(!x||typeof(x)!=="object"){x={}}var n=this;this.parameters=(al&&typeof(al)==="object")?al:{};this.XMLSerializer=(window.XMLSerializer)?new window.XMLSerializer():b;this.plugins={};this.arPlugins=[];this.arUnrecognizedConfigNodes=[];this.arConditions=[];var Z=false;var O={};var B=0;var r;var ad={};var H=n.debug=new a.EmptyDebugger();var D=false;var y={};var aq=false;var T={stickynotes:"bookmarks"};var g;var Y=false;var t;var L;var ag;var c;var m;var v="token";var w;var p;var K={};var aj=/(\\?|&)tpl=/i;var af=/\.json\s*$/i;var d=/\.xml\s*$/i;if(a.isInternetExplorer&&a.versionInternetExplorer<10){p=function(at){var ar;if(!a.utils.isCrossDomain(at)){aq=false;ar=new XMLHttpRequest()}else{aq=true;ar=new XDomainRequest()}return ar}}else{if(typeof(XMLHttpRequest)!=="undefined"){p=function(){return new XMLHttpRequest()}}}this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",format:"imageformat",renderer:"fpxservertemplate",imagerenderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(av){n.reset();t=(typeof(f.strSection)==="string")?f.strSection:"";L=t.toLowerCase();if(typeof(f.strTraceParam)==="string"){var at=f.strTraceParam.toLowerCase();c={};c[at]=true;if(at.indexOf("_")>0&&at.indexOf("pages")===0){at=at.split("_");at.shift();at=at.join("_");c[at]=true}var au=n.getParameterAlias(at);if(au){c[au]=true}}else{c=false}if(av){if(n.parameters){n.parameters=a.utils.mergeObjects(n.parameters,av)}else{n.parameters=av}}ak(n.parameters);n.getQueryParameters();n.cloneParameters(n.cfgDefaults,n.cfg);n.cloneParameters(n.queryParameters,n.cfg);delete n.cfg.effects;n.elevateToHTTPS();e();n.locationFSIViewer="";if(n.queryParameters.fsiviewerlocation!==b){n.locationFSIViewer=n.queryParameters.fsiviewerlocation}else{H.log("FSI Viewer location guessed based on script location: "+a.getViewerLocation());n.locationFSIViewer=(a.getViewerLocation()||"")}if(n.locationFSIViewer.charAt(n.locationFSIViewer.length-1)!=="/"){n.locationFSIViewer+="/"}var ar=n.cfg.defaultcfg;if(typeof(ar)==="string"&&ar.length>0){n.nextConfigURL=n.getReloadPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.defaultcfg))}else{n.nextConfigURL=b}n.checkDebug(false)};var ak=this.makeObjectPropertiesLowerCase=function(ar){for(var at in ar){if(ar.hasOwnProperty(at)){var au=at.toLowerCase();if(at!==au){if(ar[au]===b){ar[au]=ar[at]}delete ar[at]}}}};this.getClassParameters=function(){return ag};this.setAccessToken=function(ar){w=ar};this.getParameterAlias=function(au){var ar;if(n.cfgAliasNames[au]){ar=n.cfgAliasNames[au]}else{for(var at in n.cfgAliasNames){if(n.cfgAliasNames.hasOwnProperty(at)){if(n.cfgAliasNames[at]===au){ar=at;break}}}}return ar};var e=function(){Z=n.makeBool(n.cfg.usenc,false);if(n.cfg.usencquery!==b&&n.cfg.usencquery.length>0){D=n.cfg.usencquery;Z=true;n.queryToObject("?"+D,y)}};this.stopPendingRequests=function(){for(var at in O){if(O.hasOwnProperty(at)){var ar=O[at];if(ar){ar.FSIaborted=true;if(ar.abort){ar.abort()}}}}};this.destroy=function(){n.stopPendingRequests()};this.reset=function(){K={};ag={};n.parameters={};H=n.debug=new a.EmptyDebugger();n.stopPendingRequests();r=Math.random();n.nIncludedConfigs=0;n.completedConfigs={};n.plugins={};n.cfg={};n.queryParameters=b;n.arUnrecognizedConfigNodes=[];am=0;n.arConditions=[];ad={}};this.getQueryParameters=function(){if(n.queryParameters!==b){return}n.queryParameters={};n.cloneParameters(n.parameters,n.queryParameters)};this.makeBool=function(av,ar){if(typeof(ar)!=="boolean"){ar=false}var at=ar;switch(typeof(av)){case"string":var au=a.makeBool(av);if(au!==b){at=au}break;case"number":at=Boolean(av);break;case"boolean":at=av;break}return at};this.parsePositionParameter=function(at){if(typeof(at)!=="string"||at.length<3){return b}at=at.split(",");if(at.length<3){return b}for(var ar=0;ar<3;ar++){at[ar]=parseFloat(at[ar]);if(isNaN(at[ar])){at[ar]=0}}return{x:at[0],y:at[1],z:at[2]}};this.logLoadFileFailed=function(ar){if(!H.on){return}if(ar&&ar.status!==b){var au="HTTP "+ar.status;if(ar&&ar.statusText){au+=", "+ar.statusText}var at=(ar._url)?ar._url:"";H.error("Failed to load "+at+" ("+au+")")}else{H.error("Failed loading a file");if(ar&&ar._url){H.error(ar._url)}}};this.getAttributeValue=function(at,ar){if(!at){return}return at.getAttribute(ar)};this.getImageDownloadOriginalURL=function(at){var ar=n.serverBase.replace(/\/server$/,"");return ar+"/service/file/"+at};this.getImageURL=function(au,ar){var at;if(au===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="image"}if(w){ar[v]=w}ar.source=au;for(at in ad){if(ad.hasOwnProperty(at)){if(ad[at]!==b&&ar[at]===b){ar[at]=ad[at]}}}for(at in ab){if(ar[at]){if(ab[at]!==at){if(!ar[ab[at]]){ar[ab[at]]=ar[at]}ar[at]=null}}}if(ar.renderer===b){ar.renderer="jpeg"}return n.requestBase+"?"+n.objectToQuery(ar)};this.getRectFromInitialView=function(au){var at=n.viewStringToArray(au);return new a.Rect(at[2],at[3],at[4],at[5])};this.getImageRectParamFromRect=function(ar){var at=ar.duplicateRect();at.right=at.width();at.bottom=at.height();return at.toString()};this.getImageURLAsInViewer=function(ax,aA,aF,av,aw,aG,ar,az){az=az||{};var aH={};if(!ar||typeof(ar)!=="object"){ar={}}if(typeof(aG)!=="string"){aG=n.cfg.initialview}var aC,aE;var aB={width:aA,height:aF};var aD={width:aA,height:aF};if(aG){aE=n.getRectFromInitialView(aG)}if(az.bDoNotModifyQuery!==true){delete ar.width;delete ar.height;delete ar.rect}var au=new a.CroppedImage();au.setSourceDimension(aA,aF);au.setCropFromConfig(n.cfg);if(az.cropToFill){au=au.getCropToFill(av,aw,az.cropToFill,true)}var ay;aH.iCrop=au;if(au.isCropped()){ay=aC=au.getFloatRect();aH.rcSource=au.getImageRect()}else{aH.rcSource=new a.Rect(0,0,aA,aF)}if(aE&&!aE.isDefaultImageRect()&&az.expandViewStringToFit!==false){var aI,aJ;if(ay){aI=ay.width();aJ=ay.height()}else{aI=aJ=1}a.utils.extendRectToFill(aE,aI*aA,aJ*aF,av,aw,false,true)}if(ay){if(aE){aC=aC.getPartialRect(aE)}}else{aC=aE}if(aC&&!aC.isDefaultImageRect()){aD.width=aA*aC.width();aD.height=aF*aC.height();aB.width=Math.round(aD.width);aB.height=Math.round(aD.height);if(ar.rect===b){ar.rect=n.getImageRectParamFromRect(aC)}}aH.rc=aC;var at=a.utils.fitImageIntoSpace(aD.width,aD.height,av,aw);if(ar.width===b&&ar.height===b){ar[at.dim]=at[at.dim]}aH.dimFit=at;aH.srcArea=aB;aH.srcAreaFloat=aD;aH.url=n.getImageURL(ax,ar);return aH};this.getImageInfoURL=function(at,ar){if(at===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="info"}if(ar.tpl===b){if(n.cfg.fpxinfotemplate!==b){ar.tpl=n.cfg.fpxinfotemplate}else{ar.tpl="info.json"}}if(n.cfg.headers&&n.cfg.headers.length>0){ar.headers=n.cfg.headers}if(!ar.tpl.match(/.json$/)){ar.tpl+=".json"}ar.source=at;if(w){ar[v]=w}return n.requestBase+"?"+n.objectToQuery(ar)};this.queryToObject=function(aw,au){if(au===b){au={}}var av,ay,ax,ar,at;av=aw.indexOf("?");if(av!==-1){at=aw.slice(av+1)}else{at=""}av=at.indexOf("#");if(av!==-1){at=at.substring(0,av)}at=at.split("&");for(av=0;av<at.length;av++){ay=at[av].split("=");ax=decodeURIComponent(ay[0]).toLowerCase();if(ax.length>0){ar=decodeURIComponent(ay[1]);au[ax]=ar}}return au};this.parseSceneSets=function(ar,aw){var aD={};if(aw===b){aw=true}var aI=[];var aG=0;var aE=0;var au;var ay,ax,av,aC,aA,aH;var az,aB,aF;var at=n.cfg.scenesets;if(ar>1&&at!==b&&typeof(at)==="string"){aB=at.split(";");for(ay=0;ay<aB.length;ay++){aF=[];az=aB[ay].split(",");aE=0;for(ax=0;ax<az.length;ax++){aH=az[ax].split("-");aC=aA=0;if(aH.length===1){aC=parseInt(aH[0])}else{aC=parseInt(aH[0]);if(isNaN(aC)){aC=1}au=false;if(aH[1].charAt(0)===">"){aH[1]=aH[1].substr(1);if(!isNaN(parseInt(aH[1]))){au=true}}aA=parseInt(aH[1]);if(isNaN(aA)){aA=ar}if(aC>0&&aA>0&&aC<=ar&&aA<=ar){if(au===true||aC!==aA){if(au!==true){if(aA<aC){for(av=aC;av>=aA;av--){aF[aE]=av;aE++}}else{for(av=aC;av<=aA;av++){aF[aE]=av;aE++}}}else{for(av=aC;av<=ar;av++){aF[aE]=av;aE++}for(av=1;av<=aA;av++){aF[aE]=av;aE++}}}}}if(aC>0&&aC<=ar&&(aA===0||aA===aC)){aF[aE]=aC;aE++}}if(aE>0){aI[aG]={};aI[aG].arScenes=[];aI[aG].arScenes=aI[aG].arScenes.concat(aF);aG++}}}if(aG===0){aD.bDefault=true;if(aw){aI[0]={};aI[0].arScenes=[];for(ay=0;ay<ar;ay++){aI[0][ay]=ay}}}aD.nSceneSets=aG;aD.bHasMultipleSets=(aD.nSceneSets>1);aD.arSets=aI;aD.nCurrent=1;return aD};this.objectToQuery=function(au){var at=[];var aw,av;if(Z&&D!==false){for(aw in y){if(y.hasOwnProperty(aw)){au[aw]=y[aw]}}}for(aw in au){if(au.hasOwnProperty(aw)){av=au[aw];if(av!==null&&av!==b){av=encodeURIComponent(av);at.push(encodeURIComponent(aw)+"="+av)}}}return at.join("&")};this.loadImageInfo=function(av,ar,au){if(typeof(av)!=="string"||av.length<1){if(ar){ar(null,"",au)}}else{var at=n.getImageInfoURL(av);n.loadFile(at,ar,b,au)}};this.loadFile=function(aw,av,au,aA,az,at,ax){if(!aw||aw.length<0){if(av){setTimeout(function(){av(null,"",aA)},0)}return}if(az===b){az="GET"}if(at===b){at=null}else{if(typeof(at)==="object"){at=n.objectToQuery(at)}}if(au===b){au="application/json"}var ay=p(aw);if(au&&ay.overrideMimeType){ay.overrideMimeType(au)}ay._url=aw;var ar=B;O[B]=ay;B++;if(aq){ay.onerror=function(){delete O[ar];if(av===b||this.FSIaborted){return}n.logLoadFileFailed(this)};ay.onload=function(){delete O[ar];if(av===b||this.FSIaborted){return}var aB=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var aC=new ActiveXObject("Microsoft.XMLDOM");aC.async=false;aC.loadXML(aB);aB=this.responseXML=aC}catch(aD){H.log("Failed parsing XML using Microsoft.XMLDOM");H.log(aw)}break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aD){H.error("Failed parsing JSON from URL: "+aw+" ("+aD.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}else{ay.onreadystatechange=function(){var aB;if(ay.readyState!==4){return}delete O[ar];if(this.FSIaborted||typeof(av)!=="function"){return}if(this.status>299){n.logLoadFileFailed(this)}switch(au){case"application/xml":case"text/xml":aB=this.responseXML;break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aC){H.error("Failed parsing JSON from URL: "+aw+" ("+aC.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}ay.open(az,aw,true);if(ax&&w){ay.setRequestHeader("data-token",w)}if(at){ay.setRequestHeader("Content-type","application/x-www-form-urlencoded");ay.send(at)}else{ay.send()}return ay};this.loadConfigs=function(){ag=(t.length>0)?{}:false;g=true;n.loadNextConfig(true)};this.loadNextConfig=function(at){if(n.nextConfigURL===b){X();return}var au={};if(f.bPreventCaching||n.makeBool(n.cfg.debug)||(!at&&!n.makeBool(n.cfg.configcaching,true)&&n.makeBool(n.cfg.enableconfigcachingparameter))){n.addNoCacheParams(au)}n.finishRequestParams(au);var ar=n.addURLParameters(n.nextConfigURL,au);H.log("Loading config file: "+ar);n.loadFile(ar,E,"application/xml")};this.setDebugger=function(ar){H=n.debug=ar};this.checkDebug=function(au){if(f.bNoDebug){return}var at;var ar;if(n.parameters.debug!==b){ar=n.makeBool(n.parameters.debug)}else{ar=n.makeBool(n.cfg.debug)}if(ar){if(!H||!H.on){H=n.debug=new a.Debugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}else{if(!H||H.on===true){H=n.debug=new a.EmptyDebugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}return at};var E=function(ar){var au=ar.responseXML;m=n.nextConfigURL;n.parseConfig(au);m=b;n.elevateToHTTPS();if(n.checkDebug(true)===true){return}e();if(g&&f.bCaptureDefaultCfg){g=false;n.cfgFromDefaultConfig=a.utils.cloneValue(n.cfg)}var at;if(n.cfg.includeconfig!==b&&n.nIncludedConfigs<10){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.includeconfig));n.nIncludedConfigs++;n.cfg["_includeconfig("+n.nIncludedConfigs+")"]=n.cfg.includeconfig;n.cfg.includeconfig=b}else{if(n.cfg.cfg!==b){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.cfg))}}if(at!==b&&!n.completedConfigs[at]){n.completedConfigs[at]=true;n.nextConfigURL=at;n.loadNextConfig()}else{n.evaluateQuery(n.queryParameters,n.cfg);X()}};this.evaluateXML=function(ar){m="XML Object";n.parseConfig(ar);m=b;n.elevateToHTTPS();e();n.evaluateQuery(n.queryParameters,n.cfg);X()};this.elevateToHTTPS=function(){if(!a.utils.isHTTPS()){return}if(!n.makeBool(n.cfg.autoelevatetohttps,true)){return}i("fpxbase");i("fpxserver")};var i=function(ar){if(n.cfg[ar]!==b&&n.cfg[ar].length>0&&n.cfg[ar].indexOf("http://")===0){n.cfg[ar]="https"+n.cfg[ar].substr(4)}};this.evaluateQuery=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){n.setConfigParamByValue(ar,au.toLowerCase(),at[au])}}};this.parseConfig=function(at,au){var aD="";var ax;var az=false;if(at&&typeof(at)==="object"){if(au===b){au=at.firstChild}if(au&&au.nodeName==="xml"){au=au.nextSibling}var aC=au.childNodes;for(var ay=0;ay<aC.length;ay++){var aw=aC[ay];if(aw.nodeType!==1){continue}var aA;if(aw._myTagName!==b){aA=aw._myTagName}else{aA=aw.nodeName.toLowerCase()}aD=aA;var av=aw.childNodes;az=false;switch(aA){case"licence":break;case"if":n.arConditions.push(aw);break;case"plugins":for(ax=0;ax<av.length;ax++){n.parsePluginNode(av[ax])}break;case L:az=true;case"info":case"options":aD=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(ax=0;ax<av.length;ax++){var aB=av[ax];if(aB.nodeType!==1){continue}if(aB.tagName==="if"){aB._myTagName=aA;n.arConditions.push(aB)}else{var ar=n.getValueFromXMLNode(aB,aD);if(aD===b&&ag){if(az){n.setConfigParam(ag,ar,null,true);n.setConfigParam(n.cfg,ar,aB)}else{if(ag[ar.name]===b){n.setConfigParam(n.cfg,ar,aB)}}}else{n.setConfigParam(n.cfg,ar,aB)}}}break;default:n.arUnrecognizedConfigNodes.push(aw)}}}};this.getData=function(){var ar={};ar.cfg={};for(var at in n.cfg){if(n.cfg.hasOwnProperty(at)){ar.cfg[at]=n.cfg[at]}}return ar};this.setData=function(ar){if(!ar||!ar.cfg){return}n.cfg={};this.setCfgValues(ar.cfg)};this.setCfgValues=function(at){for(var au in at){if(at.hasOwnProperty(au)){var ar=au.toLowerCase();if(n.cfgAliasNames[ar]){ar=n.cfgAliasNames[ar]}if(K.nItems){if(K.bPositive){if(!K.params[ar]){continue}}else{if(K.params[ar]){continue}}}n.cfg[ar]=at[au]}}W()};this.getImagesNodeList=function(au){var ar=[];if(au===b){au=n.getUnrecognizedConfigNode("images")}if(au){var av=au.firstChild;while(av){if(av.nodeType===1){var at={};at.attributes={};N(av,at.attributes);at.cfg={};n.parseConfigFragment(av,at.cfg);ar.push(at)}av=av.nextSibling}}return ar};this.removeUnrecognizedConfigNodes=function(){n.arUnrecognizedConfigNodes=[]};this.setUnrecognizedConfigNode=function(aw,au){var ar;aw=aw.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var av=n.arUnrecognizedConfigNodes[at];if(av&&av.nodeName.toLowerCase()===aw){ar=av;break}}if(!ar){if(au!==null){n.arUnrecognizedConfigNodes.push(au)}}else{if(au===null){n.arUnrecognizedConfigNodes.slice(at,1)}else{n.arUnrecognizedConfigNodes[at]=au}}return ar};this.getUnrecognizedConfigNode=function(av){var ar;av=av.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var au=n.arUnrecognizedConfigNodes[at];if(au&&au.nodeName.toLowerCase()===av){ar=au;break}}return ar};this.parseConfigFragment=function(at,az,ay){var aD="";if(at&&typeof(at)==="object"&&az!==b){if(ay===b){ay=[]}var aC=at.childNodes;for(var ax=0;ax<aC.length;ax++){var av=aC[ax];if(av.nodeType!==1){continue}var aA=av.nodeName.toLowerCase();aD=aA;var au=av.childNodes;switch(aA){case"info":case"options":aD=b;case"fpx":case"image":case"include":for(var aw=0;aw<au.length;aw++){var aB=au[aw];if(aB.nodeType!==1){continue}var ar=n.getValueFromXMLNode(aB,aD);n.setConfigParam(az,ar,aB)}break;default:ay.push(av)}}}};this.findXMLNode=function(at,ar){if(at===b||at.nodeType===b){return b}while(at){if(at.nodeName.toLowerCase()===ar){break}if(at.firstChild){at=at.firstChild}else{if(at.nextSibling){at=at.nextSibling}else{at=at.parentNode.nextSibling}}}return at};this.getValueFromXMLNode=function(au,ar){if(!au||au.nodeType!==1){return}var at={};var av=(ar)?ar:"";at.name=av+au.nodeName.toLowerCase();var aw=au.getAttribute("value");if(aw){at.value=aw;return at}at.value=n.XMLChildNodesToString(au);at.node=au;return at};this.getXMLNodeAttribute=function(av,au,ar){if(!av||av.nodeType!==1||!av.getAttribute){return ar}var at=av.getAttribute(au);if(at===b||at==null){at=ar}return at};this.XMLChildNodesToString=function(au,at){var ar="";if(!au||!au.firstChild){return ar}if(au.childNodes.length===1&&au.firstChild.nodeType===3){ar=au.firstChild.nodeValue}else{ar=au.innerHTML}if(at!==b){ar=ar.replace(/[\x00-\x1f]/g,at)}return ar};this.hasPlugin=function(ar){return(n.plugins&&n.plugins[ar]!==b)};this.getPluginParameter=function(ay,at,ar,ax,az){ay=ay.toLowerCase();at=at.toLowerCase();if(n.plugins[ay]===b){H.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+ay+"."+at);return ar}var aw;var av=ay+"_"+at;if(az&&n.cfg[av]===b){av=at}if(n.cfg[av]!==b){aw=n.cfg[av]}else{if(ag&&ag[at]!==b&&L==="pages"){aw=ag[at]}else{var au=n.plugins[ay].parameters;if(au!==b&&au[at]!==b){aw=au[at]}}}if(aw===b){aw=ar}if(ax){aw=n.makeBool(aw,ar)}return aw};var R=this.getAllPluginParameters=function(at){at=at.toLowerCase();var au=a.utils.cloneObject(n.plugins[at].parameters);var aw=at+"_";var ar=aw.length;for(var ax in n.cfg){if(n.cfg.hasOwnProperty(ax)){if(ax.toLowerCase().indexOf(aw)===0){var av=ax.substr(ar);au[av]=n.cfg[ax]}}}return au};this.getIntParameterMinMax=function(at,au,ar,av){return Math.min(av,Math.max(ar,n.getIntParameter(at,au)))};this.getIntParameter=function(at,au){var ar=parseInt(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};this.getStringParameter=function(at,au){var ar=n.cfg[at.toLowerCase()];if(ar===b){ar=au}return ar};this.getFloatParameter=function(at,au){var ar=parseFloat(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};var N=function(ax,at){if(!ax||!ax.attributes||!ax.attributes.length||!at){return false}var au=ax.attributes;for(var aw=0;aw<au.length;aw++){var ar=au[aw];var av=ar.nodeName.toLowerCase();at[av]=ar.value}return true};this.parsePluginNode=function(au){if(au.nodeType!==1){return}var aw={};N(au,aw);var av=au.childNodes;for(var ar=0;ar<av.length;ar++){var ax=av[ar];if(ax.nodeType!==1){continue}var at=n.getValueFromXMLNode(ax);if(at.value!==b){aw[at.name]=at.value;if(at.node!==b){aw[at.name+".node"]=at.node}}}this.addPluginFromString(aw.src,aw)};this.clone=function(){var ar=new a.Config(al,x,f);ar.init();ar.setParameterFilter(K);ar.serverBase=n.serverBase;ar.requestBase=n.requestBase;ar.cfg=a.utils.cloneObject(n.cfg);ar.plugins=a.utils.cloneObject(n.plugins);ar.arPlugins=a.utils.cloneArray(ar.arPlugins);ar.arUnrecognizedConfigNodes=a.utils.cloneArray(n.arUnrecognizedConfigNodes);ar.arUnrecognizedConfigNodesWithoutDefault=a.utils.cloneArray(n.arUnrecognizedConfigNodesWithoutDefault);ar.setImageQueryParameters(ad);ar.arConditions=a.utils.cloneArray(n.arConditions);ar.hasImageParameterConditions=n.hasImageParameterConditions;return ar};this.setImageQueryParameters=function(ar){ad=a.utils.cloneObject(ar)};this.getImageQueryParameters=function(){return a.utils.cloneObject(ad)};this.addPluginsFromString=function(au){if(typeof(au)!=="string"||au.length<1){return}var ar=au.split(",");for(var at=0;at<ar.length;at++){var av=a.trim(ar[at]);n.addPluginFromString(av)}};this.addPluginFromString=function(av,aw){if(typeof(av)!=="string"||av.length<1){H.error("PLUGIN without src parameter:");return}av=av.toLowerCase();if(T[av]!==b){av=T[av]}if(aw===b){aw={}}var at=n.plugins[av]={};at.name=av;if(aw.src===b){aw.src=av}at.parameters=aw;if(c){for(var ax in c){if(c.hasOwnProperty(ax)){if(ax.indexOf(av+"_")===0){var au=av+"_";var ar=ax.substr(au.length);if(typeof(at.parameters[ar])!=="undefined"){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log(at.parameters[ar]);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}else{if(ax===av){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log("(enabled)");n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}}};this.setConfigParamByValue=function(at,au,ar){n.setConfigParam(at,{name:au.toLowerCase(),value:ar})};var V=function(at){if(at.nodeType!==1){return"<unknown>"}var ar=n.XMLSerializer.serializeToString(at.cloneNode(false));ar=ar.replace(/\/>$/gi,">");return ar};this.setParameterFilter=function(at,ar){if(at===b){if(K.nItems){K={}}return}if(typeof(at)==="string"){K=n.getParameterFilterFromString(at,ar)}else{if(typeof(at)==="object"){K=a.utils.cloneObject(at)}}};this.getParameterFilterFromString=function(ay,at){var av={bPositive:at,nItems:0,params:{}};var az=av.params;var au=ay.split(",");for(var ax=0;ax<au.length;ax++){var aw=a.trim(au[ax]).toLowerCase();if(aw.length>0){az[aw]=true;av.nItems++}}return av};this.getParameterFilter=function(){return a.utils.cloneObject(K)};this.setConfigParam=function(av,ar,aw,ax){var az=ar.name;var aB=ar.value;if(!az){return}if(c){for(var aA in c){if(aA===az&&!ax){if(typeof(aw)==="object"&&typeof(aw.tagName)==="string"){var ay;if(m){ay=m}var au=aw.parentNode;var at=[];while(au){if(au.tagName==="if"){ay="Matched Condition"}at.unshift(V(au));au=au.parentNode}at.shift();at.shift();n.iTraceParameterDebug.group(ay);n.iTraceParameterDebug.log(at.join(" "));n.iTraceParameterDebug.log(aw);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}else{n.iTraceParameterDebug.group("By Parameter/Attribute:");n.iTraceParameterDebug.log(aB);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}if(n.cfgAliasNames[az]!==b){az=n.cfgAliasNames[az]}if(K.nItems){if(K.bPositive){if(!K.params[az]){return}}else{if(K.params[az]){return}}}if(av[az]!==b&&(typeof(aB)==="string"&&a.utils.getBoolTable(aB.toLowerCase())===false)&&a.utils.getBoolTable(av[az])===b){delete av[az]}else{switch(az){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":aB=a.trim(aB);n.appendImageEffect(av,az,aB);break;case"plugins":n.addPluginsFromString(aB);break;case"fpxpath":av[az]=aB;av.fpxsrc=encodeURIComponent(aB);break;default:av[az]=aB;if(ar.node!==b){av[az+".node"]=ar.node}}}};this.appendImageEffect=function(au,at,ar){if(typeof(ar)!=="string"){return}if(ar.match(/^ClearEffects\(\)*/i)){ar=ar.replace(/^ClearEffects\(\)\s*[,]?\s*/i,"");au[at]=b}if(ar.length>0){if(au[at]!==b&&au[at].length>0){au[at]+=","+ar;au[at]=au[at].replace(/,,/g,",")}else{au[at]=ar}}};var l={};l["="]=function(at,ar){return(at.toLowerCase()===ar.toLowerCase())};l["=="]=function(at,ar){return(at===ar)};l["!="]=function(at,ar){return(at.toLowerCase()!==ar.toLowerCase())};l["!=="]=function(at,ar){return(at!==ar)};l["<"]=function(at,ar){return(at<ar)};l["<="]=function(at,ar){return(at<=ar)};l[">"]=function(at,ar){return(at>ar)};l[">="]=function(at,ar){return(at>=ar)};l.match=function(at,ar){var au=false;var aw="g";if(ar.charAt(0)==="/"&&ar.lastIndexOf("/")>0){var av=ar.split("/");av.shift();aw=av.pop();ar=av.join("/")}try{var ax=new RegExp(ar,aw);au=(at.match(ax)!==null)}catch(ay){H.error("Invalid regex in condition: "+ar)}return au};l.notmatch=function(at,ar){return !l.match(at,ar)};var s={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var u=function(at,au){if(n.cfgAliasNames[au]){au=n.cfgAliasNames[au]}var ar=n.cfg[au];if(ar===b){ar=""}if(!n.hasImageParameterConditions){n.hasImageParameterConditions=(ab[au]!==b)}return G(at,au,ar)};var M=function(av,aw){var ar=false;var au;var at=av.getAttribute("value");switch(aw){case"@mobile":at=n.makeBool(at,true);au=a.isMobileDevice;break;case"@devicepixelratio":au=a.getDevicePixelRatio();break;case"@navigatoruseragent":au=navigator.userAgent;break;case"@navigatorlanguage":au=navigator.language;break;case"@navigatorplatform":au=navigator.platform;break}if(au!==b){if(typeof(at)!=="string"){at=""+at}if(typeof(au)!=="string"){au=""+au}ar=G(av,aw,au,at)}return ar};var G=function(av,au,ax,aw){var az;var at=av.getAttribute("operator");if(typeof(at)!=="string"){at="="}at=at.toLowerCase();if(s[at]){at=s[at]}if(l[at]===b){at="="}if(aw===b){aw=av.getAttribute("value")}if(aw===null){aw=""}var ar=l[at];if(at.match(/[<,>]+/)){var aA=function(aB){aB=parseFloat(aB);if(isNaN(aB)){az=false}return aB};ax=aA(ax);aw=aA(aw)}else{ax=decodeURIComponent(ax)}if(az===b){az=ar(ax,aw)}if(H.on){H.log("Evaluating condition: "+au+": "+ax+" "+at+" "+aw+" => "+az)}if(az===true){if(av._myTagName!==b){var ay={};ay.nodeType=1;ay.tagName=av._myTagName;ay.childNodes=[av];av=ay}n.parseConfig(av,av)}return az};var ab={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var ac={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi",overlays:"overlays"};var aa;var U=function(){if(aa===b){aa={};for(var ar in ab){aa[ab[ar]]=ar}}return aa};var q=function(aw,av,au){if(au===b){au=""}var ay=au+"left";if(aw[ay]===b){return}var ax=au+"top";var at=au+"right";var ar=au+"bottom";if(av==="pixelrange"){aw[at]=aw[at]-aw[ay];aw[ar]=aw[ar]-aw[ax]}aw[av]=aw[ay]+","+aw[ax]+","+aw[at]+","+aw[ar];if(aw[ay]){delete aw[ay]}if(aw[ax]){delete aw[ax]}if(aw[at]){delete aw[at]}if(aw[ar]){delete aw[ar]}};var ao=this.mapImageParametersToViewer=function(ar){q(ar,"rect");q(ar,"pixelrange","pixel");U();ai(ar,U())};var an=this.mapImageParametersToServer=function(ar){ai(ar,ab)};var ai=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){if(ar[au]&&au!==ar[au]){at[ar[au]]=at[au];delete at[au]}}}};this.reWriteImageURLByConditions=function(ay){if(n.arConditions.length<1){return ay}if(typeof(ay)!=="string"||ay.length<1){return ay}var au=ay.indexOf("?");if(au===-1){return ay}var at=n.clone();var aw={};n.parseQuery(ay,aw);ao(aw);n.evaluateQuery(aw,at.cfg);var ar=at.evaluateConditions();if(!ar){return ay}var ax;for(ax in aw){if(aw.hasOwnProperty(ax)){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}}for(ax in ac){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}an(aw);var av=ay.substr(0,au);return av+"?"+n.objectToQuery(aw)};var o=this.applyConditions=function(){if(n.arConditions.length<1){return}if(n.cfgBeforeConditions===b){n.cfgBeforeConditions=a.utils.cloneObject(n.cfg)}n.cfg=n.cfgBeforeConditions;return h()};var am=0;var h=this.evaluateConditions=function(){if(n.arConditions.length<1){return false}var at=false;for(var au=am;au<n.arConditions.length;au++){var av=n.arConditions[au];if(av.fsiConfigEvaluated){continue}am++;var aw=av.getAttribute("parameter");if(typeof(aw)==="string"){aw=aw.toLowerCase();var ar;if(aw.charAt(0)==="@"){ar=M(av,aw)}else{ar=u(av,aw)}if(!at&&ar){at=ar}}}return at};var W=function(){o();n.serverProfile=n.cfg.fpxservertemplate;n.serverProfileDoublePage=n.cfg.fpxservertemplatedoublepage;if(n.serverProfileDoublePage===b){n.serverProfileDoublePage="doublepage"}n.serverBase=n.cfg.fpxserver;if(n.serverBase===b){H.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+n.locationFSIViewer+")");var at;at=n.locationFSIViewer.indexOf("/users/");if(at!==-1){n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}else{at=n.locationFSIViewer.indexOf("/viewer/");n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}H.log("Derived server location is: ["+n.serverBase+"]")}n.requestBase=n.serverBase;ad={};var ar=n.cfg;for(var au in ac){if(ar[au]!==b){ad[au]=ar[au]}}if(ad.fpxsrc!==b){ad.fpxsrc=decodeURIComponent(ad.fpxsrc)}ar=n.cfg.effects;if(ar!==b){n.cfg.effectsUnFiltered=ar;n.cfg.effects=ar=k(ar)}if(ar!==b){ad.effects=ar}ar=n.cfg.lefteffects;if(ar!==b){ad.lefteffects=ar}ar=n.cfg.righteffects;if(ar!==b){ad.righteffects=ar}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){n.setEffectsFilter(n.getAreaEffects())};this.setEffectsFilter=function(aw){if(typeof(aw)!=="string"||aw.length<1){Y=false;return}aw=a.trim(aw);var au=aw.split(",");for(var av=0;av<au.length;av++){au[av]=a.escapeRegEx(au[av])}var at="(^|[=,]+)("+au.join("|")+")\\([^)]*\\)";Y=new RegExp(at,"ig")};var k=this.removeFilteredEffects=function(ar){if(Y===false||typeof(ar)!=="string"){return ar}ar=ar.replace(Y,"");ar=ar.replace(/^[,\s]*/g,"");ar=a.trim(ar);return ar};var j=function(){for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){var au=at.toLowerCase();var ar=n.makeBool(n.cfg[au],true);if(!ar){n.plugins[at]=b}}}};var X=function(){n.elevateToHTTPS();j();W();n.dumpConfig();if(x.onConfigsReady){x.onConfigsReady()}};this.dumpConfig=function(au){if(!au){au=H}if(au.on){if(n.cfg.fpxsrc!==b){n.cfg["fpxsrc (decoded)"]=decodeURIComponent(n.cfg.fpxsrc)}au.info("Evaluated Configuration:",Q(n.cfg));if(n.queryParameters){au.info("Parameters:",Q(n.queryParameters))}if(ag){au.info("Class <"+t+"> Configuration:",Q(ag))}var at=n.getPluginsAndParameters();var ar=at.data;if(at.count===0){ar="No active plugins."}au.info("Plugin Configuration:",Q(ar))}};var Q=function(au){var ar="--- none ---";if(typeof(au)!=="object"){return ar}for(var at in au){if(au.hasOwnProperty(at)){ar=au;break}}return ar};this.getPluginsAndParameters=function(){var ar={};var au=0;for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){if(n.hasPlugin(at)){ar[at]=R(at);au++}}}return{count:au,data:ar}};var J=this.addQueryParameterToURL=function(av,ar,au){var at=av.lastIndexOf("?");if(at===-1){av+="?"}else{if(at!==av.length-1){av+="&"}}return av+encodeURIComponent(ar)+"="+encodeURIComponent(au)};var ap=n.finishURL=function(ar){if(w){ar=J(ar,v,w)}if(!Z||ar===b){return ar}var at;if(D===false){at="cache=0&cachernd="+r;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+="&"+at}}else{at=D;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+=at}}return ar};this.addURLParameters=function(au,av){if(!au||!av){return au}var at=[];for(var aw in av){if(av.hasOwnProperty(aw)){at.push(encodeURIComponent(aw)+"="+encodeURIComponent(av[aw]))}}if(at.length>0){if(au.indexOf("?")===-1){au+="?"}else{au+="&"}au+=at.join("&")}return au};this.finishRequestParams=function(at){if(Z){if(D===false){at.cache=0;at.cachernd=r}else{for(var ar in y){if(y.hasOwnProperty(ar)){at[ar]=y[ar]}}}}};this.addNoCacheParams=function(ar){ar.cache=0;ar.cachernd=r};this.parseQuery=function(at,ar){if(typeof(ar)!=="object"||typeof(at)!=="string"||at.length<1){return}n.queryToObject(at,ar);if(ar.ignorequeryparameters!==b){delete ar.ignorequeryparameters}if(ar.enableconfigcachingparameter!==b){delete ar.enableconfigcachingparameter}};this.cloneParameters=function(ar,at){if(!ar||!at||typeof(ar)!=="object"||typeof(at)!=="object"){H.error("Cloning object failed: "+ar+" / "+at)}for(var au in ar){if(ar.hasOwnProperty(au)){at[au]=ar[au]}}};this.getFSIPath=function(ar,at){if(typeof(at)!=="string"){at=""}if(at.indexOf("//")!==-1){return at}if(n.cfg.fsibase!==b){at=n.cfg.fsibase+at}return n.getReloadPath(ar,at)};this.expandFSIPath=function(at){if(typeof(at)!=="string"){return at}var ar=decodeURIComponent(at);if(ar.indexOf("?")!==-1||ar.indexOf(".xml")===(ar.length-4)){return at}return at+".xml"};this.getReloadPath=function(av,ax){var at,ay,ar,aw;if(av===b){av=n.locationFSIViewer}if(typeof(ax)!=="string"){ax=""}var au="/";if(ax.indexOf("//")!==-1){return ax}at=av;aw=at.lastIndexOf("?");if(aw===-1){aw=at.length}ay=at.lastIndexOf("\\",aw);ar=at.lastIndexOf("/",aw);ay=Math.max(ay,ar);if(ay===-1){ay=at.length-1}at=at.slice(0,ay);if(at.length>0&&ax.indexOf(au)!==0){at+=au}return at+ax};var C=function(ar){var at;if(!ar){return}if(ar.childNodes.length>0){at=ar.innerHTML}else{at=ar.getAttribute("value")}return at};var I=function(au,aw){var at,ar;var av=0;while(au){if(au.nodeType===1&&au.nodeName.toLowerCase()===aw){ar=au;break}at=au.firstChild;if(!at){at=au.nextSibling}else{av++}if(!at&&av>0&&au.parentNode){at=au.parentNode.nextSibling;av--}au=at}return ar};var S=function(aO,at){var ay;var aK;if(at===b){at=0}var aL={};var aJ=aL.arImages=[];var aC=aL.arConfigs=[];var aM=aL.arNodes=[];var aw=aL.arImageLists=[];var aB="";var aP="";var aI;var ax;var aH={};if(at===0&&(n.cfg.imagelistparameterfilterpositive||n.cfg.imagelistparameterfilternegative)){n.getParameterFilter();n.cloneParameters(K,aH);if(n.cfg.imagelistparameterfilterpositive){n.setParameterFilter(n.cfg.imagelistparameterfilterpositive,true)}else{if(n.cfg.imagelistparameterfilternegative){n.setParameterFilter(n.cfg.imagelistparameterfilternegative,false)}}}var aG=function(ar){aJ.push(ar);aM.push(aO);if(at===0){aC.push(aI);aw.push(ax)}};var aF;if(!aO){return aL}var aU;aU=n.getAttributeValue(aO,"prefix");if(typeof(aU)==="string"){aB=aU}aU=n.getAttributeValue(aO,"suffix");if(typeof(aU)==="string"){aP=aU}var av=n.getAttributeValue(aO,"from");var aE=n.getAttributeValue(aO,"to");var aT,au;if(typeof(av)==="string"&&typeof(aE)==="string"){aT=parseInt(av);au=parseInt(aE);if(!isNaN(aT)&&!isNaN(au)&&aT<=au&&(au-aT)<512){}else{aT=au=b}}if(aT!==b){ax=aI=b;var aS;var aN=av.length;var aR=aE.length;if(aN===aR){aS=aN}for(var aQ=aT;aQ<=au;aQ++){aK=""+aQ;if(aS){while(aK.length<aS){aK="0"+aK}}if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}}else{aO=I(aO,"image");var az;if(!aO){return aL}while(aO){az=true;if(aO.nodeType===1&&aO.nodeName.toLowerCase()==="image"){ax=aI=b;if(at===0){aI=n.clone();aI.getImageQueryParameters();aI.arUnrecognizedConfigNodes=[];aI.parseConfig(aO,aO);aI.setCfgValues({});aI.checkDebug();if(aI.debug&&aI.debug.on){aI.debug.group("Sub Config #"+aJ.length+" from image list:");aI.dumpConfig();aI.debug.groupEnd()}aI.serverBase=n.serverBase;aI.requestBase=n.requestBase;ax=aI.getImageList(at+1);if(ax&&ax.arImages.length>0){az=false;var aD=aI.parseSceneSets(ax.arImages.length,true);var aV=n.viewStringToArray(aI.cfg.initialview);var aA=aD.arSets[aV[0]-1][aV[1]-1];if(aA===b){aA=0}aG(ax.arImages[aA])}}if(az){ax=aI=b;aF=I(aO,"path");aK=C(aF);if(!aK){aK=decodeURIComponent(n.getAttributeValue(aO,"src"))}if(!aK){aK=decodeURIComponent(n.getAttributeValue(aO,"file"))}if(aK!==b){if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}if(aL.width===b){aF=I(aO,"width");aF=C(aF);if(aF!==b){aL.width=parseInt(aF)}aF=I(aO,"height");aF=C(aF);if(aF!==b){aL.height=parseInt(aF)}}}}aO=aO.nextSibling}}if(aH){n.setParameterFilter(aH)}return aL};this.getImageList=function(au){var aA,ay,av;A();if(!n.makeBool(n.cfg.ignoreimagelists)){if(n.cfg&&n.cfg.fpxsources!==b){var az=n.cfg.fpxsources;if(typeof(az)==="string"||(typeof(az)==="object")&&typeof(az.push)==="function"){aA={};aA.oXML=null;if(typeof(az)==="string"){if(ae===false){aA.arImages=az.split(",");for(ay=0;ay<aA.arImages.length;ay++){aA.arImages[ay]=decodeURIComponent(aA.arImages[ay])}}else{var ax=az.split(",");aA.arImages=[];for(ay=0;ay<ax.length;ay++){av=decodeURIComponent(ax[ay]);if(ae(av)){aA.arImages.push(av)}}}}else{aA.arImages=az}}}if(!aA&&n.arUnrecognizedConfigNodes&&n.arUnrecognizedConfigNodes.length>0){var aB=n.arUnrecognizedConfigNodes;for(ay=0;ay<aB.length;ay++){var aw=aB[ay];if(typeof(aw.nodeName)==="string"){var at=aw.nodeName.toLowerCase();if(at==="images"||at==="images3d"){if(H.on){H.log("Reading image list from XML node: <"+aw.nodeName+">")}aA=S(aw,au);aA.oXML=aw;break}}}}}if(!aA&&n.cfg&&n.cfg.fpxsrc!==b){aA={};aA.oXML=null;if(ae===false){aA.arImages=[decodeURIComponent(n.cfg.fpxsrc)]}else{av=decodeURIComponent(n.cfg.fpxsrc);if(ae(av)){aA.arImages=[av]}}}return aA};this.fillViewString=function(aw){if(typeof(aw)!=="string"){aw=""}var au=[1,1,0,0,1,1,0];var at=aw.split(",");if(at.length===2){return aw+",0,0,1,1,0"}if(at.length===6){return aw+",0"}if(at.length===7){return aw}for(var av=at.length;av<7;av++){at.push(au[av])}return at.join(",")};this.viewStringToArray=function(au){var av=function(ay,ax){var ar=parseFloat(ay);if(isNaN(ar)){ar=ax}return ar};var aw=function(ay,ax){var ar=parseInt(ay);if(isNaN(ar)){ar=ax}return ar};au=n.fillViewString(au);var at=au.split(",");at[0]=aw(at[0],1);at[1]=aw(at[1],1);at[2]=av(at[2],0);at[3]=av(at[3],0);at[4]=av(at[4],1);at[5]=av(at[5],1);at[6]=av(at[6],0);return at};this.getServerBase=function(){return n.serverBase};this.loadImageList=function(aw,ax,az,ay){if(!n.serverBase||!aw){ax([],b,ay);return false}A();var av=n.serverBase+"?type=list";if(!aw.match(aj)){var au=n.cfg.listtemplate;if(au&&au.length>0&&!au.match(af)&&!au.match(d)){au+=".json"}av+="&tpl="+au}if(n.cfg.headers&&n.cfg.headers.length>0&&y.headers===b){av+="&headers="+n.cfg.headers}if(typeof(n.cfg.imagelistlimit)==="string"&&n.cfg.imagelistlimit.length>0){av+="&limit="+encodeURIComponent(n.cfg.imagelistlimit)}if(n.cfg.imagelistsort!==b){H.log("Sorting image list by: "+n.cfg.imagelistsort);av+="&sort="+n.cfg.imagelistsort}if(typeof(n.cfg.imagelistsortorder)==="string"){var at=n.cfg.imagelistsortorder.toLowerCase();if(at==="asc"||at==="desc"){H.log("Image list sort order: "+at);av+="&sortorder="+at}}av+="&source="+encodeURIComponent(aw);if(az!==b){av+=az}av=ap(av);var ar=n.loadFile(av,function(aA,aE){if(typeof(aE)==="object"&&typeof(aE.images)==="object"){aE.images.pop();var aF="";if(aE&&aE.imagesattributes&&aE.imagesattributes.dir){aF=aE.imagesattributes.dir}var aB,aD;if(ae===false){aB=new Array(aE.images.length);for(aD=0;aD<aE.images.length;aD++){aB[aD]=aF+aE.images[aD].src}}else{aB=[];for(aD=aE.images.length-1;aD>-1;aD--){var aC=aF+aE.images[aD].src;if(ah(aC)){aB.push(aC)}else{aE.images.splice(aD,1)}}aB.reverse()}ax(aB,aE,ay)}else{ax([],aE,ay)}},"application/json",ay);return ar};var ah=function(at){if(typeof(at)!=="string"){return 1}var ar=1;if(P!==b){if(!at.match(P)){ar=0}}if(ar===1&&z!==b){if(at.match(z)){ar=0}}return ar};var ae=true;var P,z;var F=function(aw){var au;var ay=n.cfg[aw.toLowerCase()];if(!ay||typeof(ay)!=="string"||ay.length<1){return}var ar=/\/([^/]*)$/;try{var av=ay.match(ar);if(av&&av.length>1){var at=av[1];ay=ay.replace(ar,"");ay=ay.replace(/^\//,"")}au=new RegExp(ay,at)}catch(ax){H.error("Invalid Regular Expression "+ay+" in parameter "+aw);H.error(ax.message);au=b}return au};var A=function(){P=F("ListFilterPositive");z=F("ListFilterNegative");if(P===b&&z===b){ae=false}else{ae=ah}};this.traceConfigValue=function(ar,av){if(typeof(ar)!=="string"){return false}ar=a.trim(ar);if(ar.length<1){return false}var at=ar.toLowerCase();if(at.indexOf(".")!==-1){at=at.split(".").join("")}if(at.indexOf("/")!==-1){at=at.split("/").join("")}if(at.indexOf(" ")!==-1){at=at.split(" ").join("")}var au=new a.Debugger();au.setPrefix("");au.group('Tracing parameter "'+ar+'"');var aw=function(){var ax=ar;var aC=n.getParameterAlias(at);if(typeof(aC)==="string"){ax+=" (alias: "+aC+")";if(typeof(n.cfgAliasNames[at])==="string"){at=n.cfgAliasNames[at]}}var ay=n.cfg[at];var aB=true;if(at.indexOf("_")!==-1){var aA=at.split("_");var az=aA.shift();var aD=aA.join("_");if(n.hasPlugin(az)){ay=n.getPluginParameter(az,aD)}}else{if(n.hasPlugin(at)){aB=false;ay="is enabled."}}if(ay===b){aB=false;ay="is undefined (default value applies)"}if(aB){ay='= "'+ay+'"'}au.group("RESULT:");au.log(ax+" "+ay);au.groupEnd();au.groupEnd()};x={onConfigsReady:aw};f.strTraceParam=at;f.bNoDebug=true;n.iTraceParameterDebug=au;n.init(av);n.loadConfigs();return""};this.loadLanguageFile=function(ar,aD,aw,au){var ax=arguments;var ay,aB;if(typeof(aD)!=="string"||n.makeBool(aD,true)===false){return aw.call(n,{},"")}var aC=function(aE){try{a.utils.oLanguageMap=JSON.parse(aE.responseText)}catch(aF){a.utils.oLanguageMap={"default":"english"}}n.loadLanguageFile.apply(this,ax)};var az=function(aE,aH){ar.urlLanguageCurrentLoaded=ay;var aG=ar.oLanguageData={};if(aH){var aF=n.findXMLNode(aH,"data");if(aF){aF=n.findXMLNode(aF,"tip")}while(aF){if(aF.nodeType===1){var aI=aF.getAttribute("id");aG[aI]=aF.innerHTML}aF=aF.nextSibling}}aw.call(n,ar.oLanguageData,aB)};if(aD.toLowerCase()==="auto"){if(!a.utils.oLanguageMap){n.loadFile(n.locationFSIViewer+"/languages/mapping.json",aC,"application/json");return}if(a.utils.oLanguageMap._current!==b){aD=a.utils.oLanguageMap._current}else{aD=a.utils.oLanguageMap["default"];var av=navigator.language;if(typeof(av)==="string"){av=av.toLowerCase()}if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}else{if(av.indexOf("-")!==-1){av=av.split("-")[0];if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}}}}if(aD===b){return aw.call(n,{},"")}if(au){au.log('Automatically choosing language "'+aD+'" from navigator.language "'+navigator.language+'"')}a.utils.oLanguageMap._current=aD}var aA=aD+".xml";var at=n.locationFSIViewer+"/languages/"+aA;if(at!==ar.urlLanguageCurrentLoaded){aB=aD;ay=at;if(au){au.log("Loading language file: "+at)}n.loadFile(at,az,"application/xml")}else{aw.call(n,ar.oLanguageData,aB)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!==b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.setFromArray=function(h){e.left=h[0];e.top=h[1];e.right=h[2];e.bottom=h[3]};this.scaleRect=function(h){if(h===1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h===1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.getPartialRect=function(j){var i=e.duplicateRect();if(!j.isDefaultImageRect()){var h=i.width();var k=i.height();i.offsetRect(j.left*h,j.top*k);i.right=i.left+h*j.width();i.bottom=i.top+k*j.height()}return i};this.isDefaultImageRect=function(){return(e.left===0&&e.top===0&&e.right===1&&e.bottom===1)};this.limitToImageRect=function(){e.left=Math.max(0,Math.min(1,e.left));e.right=Math.max(0,Math.min(1,e.right));e.top=Math.max(0,Math.min(1,e.top));e.bottom=Math.max(0,Math.min(1,e.bottom))};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left===h.left&&e.top===h.top&&e.right===h.right&&e.bottom===h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.setFromString=function(j){if(typeof(j)!=="string"){return}j=decodeURIComponent(j);j=j.replace(/[^0-9,.]/g,"");j=j.split(",");if(j.length>3){for(var h=0;h<j.length;h++){j[h]=parseFloat(j[h])}e.setFromArray(j)}};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ObjectCollection!==b){return}a.ObjectCollection=function(){var d=this;var f;var h;var c=0;var g;var e;this.reset=function(){c=0;d.empty()};this.empty=function(){f=[];h={};g=0;e=false};this.getCount=function(){return g};this.add=function(j){if(!j){return}c++;h[c]=j;j.__id=c;j.__arrayPos=f.length;f.push(j);g++;return c};this.deleteObject=function(j){if(!j||!j.__id){return}return d.deleteObjectById(j.__id)};this.deleteObjectById=function(j){if(!h[j]){console.error("ObjectCollection deleteObjectById "+j+" failed.");return}g--;delete h[j];e=true;return true};this.replace=function(j,k){if(!j||!k){return}return d.replaceById(j.__id,k)};this.replaceById=function(l,k){if(h[l]===b||k===b){return}var j=h[l].__arrayPos;delete h[l];c++;k.__id=c;k.__arrayPos=j;f[j]=k;h[c]=k;return true};var i=function(){if(!e){return}f=new Array(g);var l=0;for(var k in h){if(h.hasOwnProperty(k)){var j=h[k];j.__arrayPos=l;f[l]=j;l++}}e=false};this.getById=function(j){return h[j]};this.getArray=function(){if(e){i()}return f};this.getObjects=function(){return h};d.empty()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ImageTagCollection!==b){return}a.ImageTagCollection=function(c,o){a.ObjectCollection.prototype.constructor.apply(this,arguments);var q=this;var p=false;var j=false;var n=false;var r;var h;var d;var e,g;this.init=function(){var u,s;if(typeof(o.imgsrcattributename)==="string"&&o.imgsrcattributename.length>0){h=o.imgsrcattributename}else{h="src"}d=(h==="src");if(typeof(c.NameID)=="string"){r=c.NameID}else{r="$FSI_ImageTagID"}if(typeof(o.fnfilterimagesource)=="function"){j=o.fnfilterimagesource}if(typeof(o.addcssclass)=="string"){n=o.addcssclass}if(typeof(o.enablebycssclass)=="string"&&o.enablebycssclass.length>0){g={};s=o.enablebycssclass.split(",");for(u=0;u<s.length;u++){g[s[u]]=true}}if(typeof(o.disablebycssclass)=="string"&&o.disablebycssclass.length>0){e={};s=o.disablebycssclass.split(",");for(u=0;u<s.length;u++){e[s[u]]=true}}p=(e!==b||g!==b)};var m=this.isValidFSIImageServerImageSource=function(s){if(typeof(s)!=="string"){return false}return !(s.length<1||s.search(/[?,&]type=image/i)===-1||s.search(/[?,&]source=/i)===-1)};var i=this.createObjectForImageTag=function(t,x){var s=false;var u=x;if(x===b){u=x=k(t)}if(j!==false){var w=x;x=j(x,t);s=(x!==w)}if(!m(x)){return}if(!f(t)){return}if(n){a.addClass(t,n)}var v={};v.img=t;v.src=x;v.orgSrc=u;v.orgSrcDisplay=t.src;if(s){v.bIgnoreSourceChange=true}return v};var k=this.getSrc=function(s){var t=null;if(typeof(s)==="object"&&s.nodeName==="IMG"){if(d){t=s.src}else{t=s.getAttribute(h);if(typeof(t)!=="string"||t.length<1){t=null}}}return t};this.addBaseMethod=this.add;this.add=function(s){if(s[r]!==b){return}var u=k(s);if(u===null){return}var t=i(s,u);if(t){this.addBaseMethod(t);s[r]=t.__id}return t};this.replaceBaseMethod=this.replace;this.replace=function(s,t){if(q.replaceBaseMethod(s,t)){t.img[r]=t.__id}};var l=this.releaseImage=function(t){if(!t||!t.img){return false}var s=t.img;if(!s[r]===b||s[r]!==t.__id){return}if(n){a.removeClass(s,n)}return true};this.remove=function(s){if(!this.deleteObject(s)){return false}l(s);return true};var f=this.isImageEnabledByCSSClass=function(s){var v;if(!p){return true}var t=false;var u=s.className;if(typeof(u)!="string"){u=[]}else{u=u.split(" ")}if(e){t=true;for(v=0;v<u.length;v++){if(e[u[v]]){t=false;break}}}if(g){for(v=0;v<u.length;v++){if(g[u[v]]){t=true;break}}}return t}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.CustomEventListener!==b){return}a.utils.CustomEventListener=function(i){var k=this;var c=[];var f={};var g={};var h=0;k._strClassName="$FSI.CustomEventListener";var j=function(){};this.destroy=function(){for(var l=0;l<c.length;l++){var m=c[l];e(m.element,m.fn)}c=[];f={};g={};k.onDestroy()};this.fireEvent=function(l,m){if(!l||!l.enabled){return false}if(typeof(m)!="object"){m={}}if(l.paused){m.FSI_paused=true}m.FSI_custom_event=true;m.FSI_type=i;m.FSI_target=l.element;return l.fn.call(l.element,m)};this.fireEvents=function(m){if(typeof(m)!="object"){m={}}m.FSI_custom_event=true;m.FSI_type=i;for(var n=0;n<c.length;n++){var l=c[n];if(l.enabled){if(l.paused){m.FSI_paused=true}else{if(m.FSI_paused){delete m.FSI_paused}}m.FSI_target=l.element;l.fn.call(l.element,m)}}};this.addListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for addListener");return}if(p.__FSI===b){p.__FSI={}}if(p.__FSI.eventElementID===b){p.__FSI.eventElementListenerCount=1;p.__FSI.eventElementID=a.utils.getNewEventElementID()}else{p.__FSI.eventElementListenerCount++}if(o.__FSIEventFunctionID===b){o.__FSIEventFunctionListenerCount=1;o.__FSIEventFunctionID=a.utils.getNewEventFunctionID()}else{o.__FSIEventFunctionListenerCount++}var m=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(f[m]===b){var l=f[m]={};l.nFunction=0;l.oFunctions={}}if(f[m].oFunctions[n]===b){f[m].nFunction++;f[m].oFunctions[n]=[]}else{a.console.warn(k._strClassName+": There is already a listener for this exact element and function");a.console.log(p);a.console.log(o)}var q={};q.element=p;q.elementID=m;q.fn=o;q.fnID=n;q.instanceListener=k;q.enabled=true;q.paused=false;q.uniqueID=h++;f[m].oFunctions[n].push(q);c.push(q);g[q.uniqueID]=q;k._onListenerAdd(q);k._onListenerCountChange(c.length);return q};this.setListenerProps=function(o,m,n){var l=g[o];if(!l){return false}if(l.props===b){l.props={}}l.props[m]=n;return true};this.enableListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.enabled===m){return}l.enabled=m};this.pauseListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.paused===m){return}l.paused=m};var e=this.removeListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for removeListener");return}if(typeof(p.__FSI)!=="object"||p.__FSI.eventElementID===b||o.__FSIEventFunctionID===b){if(o.__FSIEventFunctionID===b){a.console.error(k._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(k._strClassName+": Element not registered for listener in removeListener")}return}var l=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(!f[l]){a.console.error(k._strClassName+": No registered listener for this element in removeListener");return}var m=f[l].oFunctions[n];if(m===b||typeof(m.pop)!="function"){a.console.error(k._strClassName+": No registered listener for this function in removeListener");return}var q=m.pop();q.fn.__FSIEventFunctionListenerCount--;q.element.__FSI.eventElementListenerCount--;if(q.element.__FSI.eventElementListenerCount===0){delete q.element.__FSI.eventElementListenerCount;delete q.element.__FSI.eventElementID}if(q.fn.__FSIEventFunctionListenerCount===0){delete q.fn.__FSIEventFunctionListenerCount;delete q.fn.__FSIEventFunctionID}if(m.length===0){delete f[l].oFunctions[n];f[l].nFunction--;if(f[l].nFunction===0){delete f[l]}}delete g[q.uniqueID];d();k._onListenerRemove(q);k._onListenerCountChange(c.length);return q};this.getEventListenerByID=function(l){return g[l]};this.getListenerObjectByID=function(l){return g[l]};this.getListenersArray=function(){return c};this.getListenerCount=function(){return c.length};var d=function(){c=[];for(var m in f){if(f.hasOwnProperty(m)){var o=f[m].oFunctions;for(var n in o){if(o.hasOwnProperty(n)){var l=o[n];c=c.concat(l)}}}}};this.dump=function(){a.console.dir(f);a.console.dir(c)};this._onListenerCountChange=function(l){};this._onListenerAdd=function(m,l){};this._onListenerRemove=function(m,l){};this.triggerEvent=function(l){};this.triggerEvents=function(){};this.setListenerProps=function(n,l,m){};this.onDestroy=function(){};j()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIElementDimension")){return}a.utils.registerCustomEvent("FSIElementDimension",function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)==="function";a.utils.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e===b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(!g){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!==b){h(s)}}}}};var h=function(p){if(p===k||e===b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIDocumentZoomChange")){return}a.utils.registerCustomEvent("FSIDocumentZoomChange",function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.utils.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.utils.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!==c){if(q){j()}else{i()}}};var m=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!==q){g=q;k(q);p=true}else{p=false}return p};var d=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!==q){if(!f){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l===20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l===40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l===50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.utils.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.utils.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.utils.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.utils.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!==b){return}a.TouchHandler=function(m,aX,al,e,aN){var aE=this;var aL=false;var ak=true;var o=false;var aT=false;var aK=false;var aB,E,j,ad;var aC,Y,aI;var h=false;var ae;var r;var a0={};var aq=[];var ac=0;var I=window;var aV;var s;var aU;var d;var aZ=[];var aR={x:0,y:0};var v={x:0,y:0};var ar=40;var n={};n.enabled=false;n.factor=5;n.fEndDiff=1;var ay={};ay.enabled=false;ay.minFrames=14;ay.factorAmount=23;ay.factorAmountQuad=0;ay.factorFrames=2.6;ay.offsetFrames=5;var ab;var az;var aH,w;var F;var at={};var X;var aM=false;var z=false;var am={};am.name="none";var N;var W;var aO;var f=false;var Z={};if(!aX||typeof(aX)!="object"){aX={}}var an=function(){var a6;if(aL){aE.destroy()}aU=A;s=b;if(a.utils.getTopWindow()!==window){s=a.utils.getTopWindow();try{var a5=a.getWindowOffset(window);if(a5.x!==b&&a5.y!==b){aU=ap}}catch(a4){aU=A;s=b}}else{s=b}F=aX.oPassTrough;aW(aX.panDirectionAllowed,true);if(aX.getPageCoords){r=aF}else{r=M}if(aX.afterTouch){for(a6 in aX.afterTouch){if(aX.afterTouch.hasOwnProperty(a6)){ay[a6]=aX.afterTouch[a6]}}}if(ay.minDelta===b){ay.minDelta=15}if(aX.nClickRadius){ab=aX.nClickRadius}else{ab=10}if(ay.fnStartStopAfterTouch&&typeof(ay.fnStartStopAfterTouch)!="function"){ay.fnStartStopAfterTouch=b}if(ay.fnStartStopAfterTouch){ay.useAnimationFrame=b}if(typeof(ay.modifyTarget)!="function"){ay.modifyTarget=b}if(typeof(ay.fnGetAfterTouchEnabled)=="function"){az=ay.fnGetAfterTouchEnabled}else{az=b}if(aX.smoothing){for(a6 in aX.smoothing){if(aX.smoothing.hasOwnProperty(a6)){n[a6]=aX.smoothing[a6]}}}if(aX.detectClick===true){X=true}if(aX.preventSelection!==false){aX.preventSelection=true}if(!m){return}if(typeof(m.join)!="function"){m=[m]}if(typeof(al)!="function"){al=A}if(typeof(e)!="function"){e=A}if(typeof(aN)!="function"){aN=A}if(typeof(aX.onPinchChange)=="function"){N=aX.onPinchChange}else{N=b}aM=aX.detectGestures;aZ=[];ax(true,aM);for(var a3=0;a3<m.length;a3++){var a2=m[a3];if(a2&&typeof(a2.nodeName)!="undefined"){a6={};a6.element=a2;aZ.push(a6);ao(a2,R);if(a.isTouch){try{if(a2.style!==b){if(a.BrowserSupports.cssTouchAction()){if(at.cssTouchAction!==b){q(a2,at.cssTouchAction)}}}}catch(a4){}}}}if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aD,false)}};this.setFnDown=function(a2){al=a2};this.setFnUp=function(a2){aN=a2};this.setFnMove=function(a2){e=a2};var aW=this.setAllowedPanDirection=function(a3,a2){if(typeof(a3)=="string"){if(a3==="pan-x"||a3==="pan-y"||a3==="pan-x pan-y"){aV=a3+" "}else{aV=""}}else{aV=""}if(!a2){at.nCheck=b;ah(at.captureScroll,at.capturePinch)}};this.enable=function(a2){if(ak===a2){return}if(!a2){Q();ah(false,false)}else{ah(at.captureScrollUser,at.capturePinchUser)}ak=a2};this.getEnabled=function(){return ak};this.cancel=function(){P();ag();aJ();Q()};var aJ=function(){if(n.enabled){i()}B()};this.cancelAfterTouch=function(){B()};this.getInitialDownEvent=function(){return W};var Q=function(){if(!o){return}aJ();o=false;W=b;z=false;if(ac===0){aP()}};var aP=function(){f=false;c()};this.destroy=function(){if(a.BrowserSupports.cssTouchAction()){for(var a3=0;a3<m.length;a3++){var a2=m[a3];q(a2,"")}}if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aD,false)}if(aO){clearTimeout(aO)}aE.cancel();var a2;for(var a3=0;a3<aZ.length;a3++){var a4=aZ[a3];a2=a4.element;x(a2,R)}at={}};var q=function(a2,a3){if(!a.BrowserSupports.cssTouchAction()||!a2||!a2.style){return}a2.style.touchAction=a2.style.msTouchAction=a3};var T=function(a2){if(a2.preventDefault){a2.preventDefault()}};var l=function(a2){T(a2);return false};var ao=function(a3,a2){a.addEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{a.addEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a3,"touchstart",a2);a.addEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a3,"MSPointerDown",a2)}a.addEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var x=function(a3,a2){a.removeEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{a.removeEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a3,"touchstart",a2);a.removeEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a3,"MSPointerDown",a2)}a.removeEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var A=function(){return true};var aQ=function(a2){if(aK){V(a2,a2.pointerId)}else{var a3=a2.changedTouches;for(var a4=0;a4<a3.length;a4++){V(a3[a4],a3[a4].identifier)}}};var V=function(a2,a4){if(a4===b||a0[a4]!==b){if(aX.debug){if(a4===b){a.console.error("doRegisterPointer: no pointerId")}if(a0[a4]!==b){a.console.error("doRegisterPointer: pointerId already registered: "+a4)}}return}ac++;var a3=a0[a4]={};a3.identifier=a4;r(a3,a2);aq.push(a3)};var aj=function(a2){var a4=false;if(aK){a4=K(a2.pointerId)}else{var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){a4=K(a3[a5].identifier)}}}if(a4){aq=new Array(ac);var a7=0;for(var a6 in a0){if(a0.hasOwnProperty(a6)){aq[a7++]=a0[a6]}}}};var K=function(a2){if(a2===b||a0[a2]===b){if(aX.debug){if(a2===b){a.console.error("doUnregisterPointer: no pointerId")}if(a0[a2]===b){a.console.error("doUnregisterPointer: pointerId not registered: "+a2)}}return false}delete a0[a2];ac--;return true};var H=function(){ac=0;a0={};aq=[]};var M=function(a3,a2){a3.x=a2.clientX;a3.y=a2.clientY};var aF=function(a3,a2){a3.x=a2.pageX;a3.y=a2.pageY};var u=function(a2){var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){var a4=a0[a3[a5].identifier];if(a4){r(a4,a3[a5])}}}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y}};var aw=function(a2){var a3=a0[a2.pointerId];if(a3){r(a3,a2)}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y;aU(a2,aR)}};var U=function(a2){r(aR,a2);aU(a2,aR)};this.getMousePositionFromMouseEvent=function(a2){U(a2);return aR};this.getMousePositionPage=function(a3){var a2={};aF(a2,a3);aU(a3,a2);return a2};this.getMousePositionClient=function(a3){var a2={};M(a2,a3);aU(a3,a2);return a2};var t=function(a2,a3){if(window!==a2.view){var a4=a.getWindowOffset(window);a3.x-=a4.x;a3.y-=a4.y}};var ap=function(a2){try{t(a2);aU=t}catch(a3){aU=A}};var aA=function(a2){if(!ak){return}var a4=ac;if(z&&a4===0){z=false}var a5=a2.type;if(o||am.started){if(a5!==aB){if(am.started){P();ag()}else{a2._FSI_Canceled=true;a1(a2,true)}}}aB=a5;d=false;var a3=true;switch(a5){case"touchstart":aT=true;aK=false;ae=u;j="touchmove";E="touchend";ad="touchcancel";aH=false;break;case"MSPointerDown":ae=aw;aT=true;aK=true;j="MSPointerDown";E="MSPointerUp";ad="MSPointerCancel";aH=false;d=true;break;case"pointerdown":ae=aw;aT=true;aK=true;j="pointermove";E="pointerup";ad="pointercancel";aH=true;d=true;break;default:if(ac>0){H()}aT=false;aK=false;aH=(aX.preventSelection);a3=false;ae=U;j="mousemove";E="mouseup";ad=b;d=true}if(aT&&a3){aQ(a2)}ae(a2);if(ac>1){Z.bClick=false}w=false;if(a3&&ai(a2)){if(a4===0){B();D()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ac};var R=this.handleDownEvent=function(a2){if(aX.bMouseOnly&&a2.type==="pointerdown"&&a2.pointerType!=="mouse"){return true}if(!aA(a2)){return}if(o||a2.which>1){return}g(a2)};this.getCurrentPos=function(){return v};var g=function(a2){aJ();if(o){return}ay.evtMove=b;if(n.enabled){v={x:aR.x,y:aR.y}}else{v=aR}Z.x=aR.x;Z.y=aR.y;var a3=W;W=a2;if(!al.call(I,a2,v,F)){W=a3;return false}o=f=true;if(X&&!z){Z.bClick=true;Z.clickRadiusX=Z.clickRadiusY=0}else{Z.bClick=false}D();if(ay.enabled){ay.x=ay.y=0;ay.lastX=aR.x;ay.lastY=aR.y;if(ay.nInterval){clearInterval(ay.nInterval)}ay.nInterval=setInterval(aa,30)}return true};var c=function(){if(h&&Y!==b){var a2={passive:false,capture:false};var a4=(s===b)?a2:b;h=false;a.removeEvent(window,Y,af,a4);a.removeEvent(window,aC,a1,a4);if(d&&s){try{a.removeEvent(s,Y,af,a2);a.removeEvent(s,aC,a1,a2)}catch(a3){}}if(aI!==b){a.removeEvent(window,aI,au,a4)}Y=aC=aI=b}};var aD=function(){};var D=function(){if(h){c()}h=true;var a2={passive:false,capture:false};var a4=(s===b)?a2:b;Y=j;aC=E;aI=ad;a.addEvent(window,Y,af,a4);a.addEvent(window,aC,a1,a4);if(d&&s){try{a.addEvent(s,Y,af,a2);a.addEvent(s,aC,a1,a2)}catch(a3){}}if(ad!==b){a.addEvent(window,aI,au,a4)}};var af=function(a2){ae(a2);a2.FSI_start_x=Z.x;a2.FSI_start_y=Z.y;if(ay.enabled&&ay.evtMove===b){ay.evtMove=a2}if(o){if(Z.bClick){Z.clickRadiusX=Math.max(Z.clickRadiusX,Math.abs(aR.x-Z.x));if(Z.clickRadiusX>ab){Z.bClick=false}else{Z.clickRadiusY=Math.max(Z.clickRadiusY,Math.abs(aR.y-Z.y));if(Z.clickRadiusY>ab){Z.bClick=false}}}if(n.enabled){n.evt=a2;aY()}else{e.call(I,a2,v,F)}}else{if(am.started){if(am.nType===1){av(a2)}}}if(w&&!a2.FSI_allowEventDefault){T(a2)}};var av=function(a2){var a3=k();if(!N){return}a2._FSI_PinchDeltaStart=am.nPinchDistance-am.pinchDistanceStart;a2._FSI_PinchDeltaRelative=am.nPinchDistance-am.pinchDistanceLast;a2._FSI_PinchScale=Math.max(ar,am.pinchDistanceLast)/am.pinchDistanceStartMaxed;am.pinchDistanceLast=am.nPinchDistance;a2._FSI_PinchDistance=a3;N.call(I,a2,aR,F)};var au=function(a2){if(aT){aj(a2);if(ac<1){if(o){a2._FSI_Canceled=true;a1(a2,true);return}else{Q();return}}}ae(a2);ai(a2)};var a1=function(a3,a4){var a2=Z.bClick;Z.bClick=false;if(a4){a3._FSI_Canceled=true}if(aT){aj(a3)}if(ac===0){aP()}ae(a3);if(!a4&&ai(a3)){return}aJ();if(!a4){if(!o||ac>0){return}}a3.FSI_start_x=Z.x;a3.FSI_start_y=Z.y;var a5=false;if(!a4&&ay.enabled){if(az===b||az()){a5=S(a3)}}if(a5){Q();y(a3)}else{if(X){a3._FSI_Click=a2}aN.call(I,a3,v,F);if(a3.type==="touchend"){aO=setTimeout(p,1)}Q()}T(a3)};var p=function(){Q();H();aO=b};var G=function(){return aq};var aY=function(){if(n.animationFrame!==b){return}aS()};var i=function(){if(n.animationFrame===b){return}cancelAnimationFrame(n.animationFrame);n.animationFrame=b};var aS=function(){var a2=Math.abs(v.x-aR.x)+Math.abs(v.y-aR.y);if(a2>n.fEndDiff){v.x+=(aR.x-v.x)/n.factor;v.y+=(aR.y-v.y)/n.factor;n.animationFrame=requestAnimationFrame(aS)}else{v.x=aR.x;v.y=aR.y;n.animationFrame=b}e.call(I,n.evt,v,F)};var S=function(a2){var a3;if(!ay.enabled){return false}if(ay.running){B()}ay.pos=0;var a5=(a2.touches!==b)?1.8:1;if(ay.factorAmountQuad){a3=(ay.x>0)?1:-1;ay.x=ay.x+a3*ay.x*ay.x/ay.factorAmountQuad;a3=(ay.y>0)?1:-1;ay.y=ay.y+a3*ay.y*ay.y/ay.factorAmountQuad}var a7=a5*ay.factorAmount;ay.startX=v.x;ay.startY=v.y;var a6={};a6.x=ay.startX+a7*ay.x;a6.y=ay.startY+a7*ay.y;if(ay.roundTargetPos){a6.x=Math.round(a6.x);a6.y=Math.round(a6.y)}if(ay.modifyTarget){a6=ay.modifyTarget.call(I,a6,F);if(a6===false){return false}}ay.amountX=a6.x-ay.startX;ay.amountY=a6.y-ay.startY;ay.amountXABS=Math.abs(ay.amountX);ay.amountYABS=Math.abs(ay.amountY);var a4=(ay.amountXABS>ay.minDelta||ay.amountYABS>ay.minDelta);if(a4){a7=ay.factorFrames/100;ay.frames=ay.offsetFrames+Math.round(a7*ay.amountXABS+a7*ay.amountYABS)}else{if(typeof(aX.onAfterTouchCancel)=="function"){aX.onAfterTouchCancel.call(I,a2,v,F)}}return a4};this.isAfterTouchRunning=function(){return ay.running};var y=function(a2){if(typeof(aX.onAfterTouchStart)=="function"){aX.onAfterTouchStart.call(I,a2,v,F)}ay.running=true;ay.evtUp=a2;if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,true,ay.evtMove,F)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}else{ay.intervalRun=setInterval(J,16)}}return true};var aG=function(a3,a2,a5,a4){return a5*((a3=a3/a4-1)*a3*a3+1)+a2};var J=this.runAfterTouch=function(){var a2=false;ay.pos++;v.x=aG(ay.pos,ay.startX,ay.amountX,ay.frames);v.y=aG(ay.pos,ay.startY,ay.amountY,ay.frames);e.call(I,ay.evtMove,v,F);if(ay.pos===ay.frames){B(true)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}a2=true}return a2};this.enableAfterTouch=function(a2){if(ay.enabled===a2){return}if(!a2){B()}ay.enabled=a2};var B=function(a2){if(!ay.running){return}if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,false,ay.evtMove,F)}else{if(ay.useAnimationFrame){if(ay.animationFrameRun){cancelAnimationFrame(ay.animationFrameRun)}}else{if(ay.intervalRun){clearInterval(ay.intervalRun);ay.intervalRun=b}}}if(typeof(aX.onAfterTouchEnd)=="function"){aX.onAfterTouchEnd.call(I,ay.evtMove,F)}ay.evtMove=b;ay.running=false;ay.evtUp._FSI_Canceled=(a2!==true);ay.evtUp._FSI_fromAfterTouch=true;aN.call(I,ay.evtUp,v,F)};var aa=function(){ay.x=(2*ay.x+aR.x-ay.lastX)/5;ay.y=(2*ay.y+aR.y-ay.lastY)/5;ay.lastX=aR.x;ay.lastY=aR.y};var ax=this.setCapture=function(a2,a4){var a3=ah(a2,a4);if(a3){at.captureScrollUser=a2;at.capturePinchUser=a4}return a3};var ah=function(a2,a4){var a3=0;if(a2){a3+=2}if(a4){a3+=4}if(a3===at.nCheck){return}at.nCheck=a3;at.captureScroll=a2;at.capturePinch=a4;if(a.BrowserSupports.cssTouchAction()){O(a2,a4)}return true};var O=function(){if(aX.bMouseOnly){return}var a4;switch(at.nCheck){case 0:a4="auto";break;case 2:a4=aV+"pinch-zoom";break;case 4:a4="pan-x pan-y";break;default:a4=(aV.length>0)?aV:"none"}at.cssTouchAction=a4;for(var a3=0;a3<m.length;a3++){var a2=m[a3];q(a2,at.cssTouchAction)}};var k=function(){if(aq.length<1){return 0}var a3=Math.abs(aq[1].x-aq[0].x);var a2=Math.abs(aq[1].y-aq[0].y);return am.nPinchDistance=Math.sqrt(a3*a3+a2*a2)};var ai=function(a2){w=false;if(!ak){return}var a3=aq.length;if(!aM){w=(a3===1&&at.captureScroll);return}if(am.pointerCount!==a3){P(a2);if(a3>1){ag();am.nPointers=a3;switch(a3){case 2:am.started=true;am.name="pinch";am.nType=1;if(typeof(aX.onPinchStart)=="function"){L(a2);am.nPinchDistance=0;am.nPinchDistance=k();am.pinchDistanceStart=am.pinchDistanceLast=am.nPinchDistance;am.pinchDistanceStartMaxed=Math.max(ar,am.pinchDistanceStart);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchStart.call(I,a2,aR,F)}break;default:am.started=true;am.name="unknown";am.nType=-1}if(am.started){z=true;if(o){aJ();o=false;a2._FSI_Canceled=true;aN.call(I,a2,v,F)}if(typeof(aX.onGestureStart)=="function"){L(a2);aX.onGestureStart.call(I,a2,aR,F)}}}else{if(a3<1){ag()}}am.pointerCount=a3;w=false;if(a3===1){if(at.captureScroll){w=true}}else{if(at.capturePinch&&am.nType===1){w=true}}}return am.started};var ag=function(){if(!am.timeoutRestartDown){return}clearTimeout(am.timeoutRestartDown);am.timeoutRestartDown=b};var C=function(){if(ac!==1){return}g(W);ag()};var L=function(a2){a2._FSI_Gesture=am.name;a2._FSI_GestureType=am.nType;a2._FSI_PointerCount=am.nPointers};var P=function(a2){if(!am.started){return}am.started=false;if(!a2){a2={}}if(am.nType===1&&typeof(aX.onPinchEnd)=="function"){L(a2);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchEnd.call(I,a2,aR,F)}if(typeof(aX.onGestureEnd)=="function"){L(a2);aX.onGestureEnd.call(I,a2,aR,F)}am.name="none";am.nType=0;if(a2&&ac===1){ag();am.timeoutRestartDown=setTimeout(C,20)}};an()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!==b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=this.logCSS=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=a.console;var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("logCSS",this.log);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!==b){return}a.Callbacks=function(f,m,k,c){if(typeof(m)!=="object"||typeof(m.cfg)!=="object"){m={cfg:{}}}if(typeof(k)!=="object"){k={}}var l=this;var q=0;var s={};var t=0;var g={};var n=new a.EmptyDebugger();var p={};var w={reg:{}};var o;var v={};var j;var r=function(){if(f){f.dumpListeners=l.dumpReg}};this.destroy=function(){if(n.on){this.removeConfigListeners();if(q>0){n.warn("WARNING: "+q+" listener(s) have not been removed:");for(var x in g){if(g.hasOwnProperty(x)){if(g[x].count>0){a.console.logCSS(g[x].dump(),"color:blue;","color:green;")}}}}}m={cfg:{}};this.checkListenerChanges()};this.removeConfigListeners=function(){for(var x in s){if(s.hasOwnProperty(x)){var y=s[x];if(y!==false){d(y.evt,y.fn)}}}s={}};this.setDebug=function(x){n=x};this.setConfig=function(x){l.removeConfigListeners();m=x};var u=function(A){if(!g[A]){if(s[A]===b){var z;var y=A.toLowerCase();var B=m.cfg[y];var x=typeof(B);if(x!=="undefined"){if(x==="function"){z=B}else{if(x==="string"&&typeof(window[B])==="function"){z=window[B]}}if(z&&h(A,z,f,true)){s[A]={evt:A,fn:z}}else{s[A]=false}}}if(!g[A]){g[A]=new e(A)}}return g[A]};var h=this.addListener=function(z,x,y,B){if(typeof(x)!="function"){n.error("Failed to add listener for "+z+". The function argument is not a function.");return false}var A;if(g[z]===b){A=g[z]=new e(z)}else{A=g[z]}A.addFunction(x,y,B);return true};var d=this.removeListener=function(y,x){var z=g[y];if(z===b||typeof(x)!="function"||x.__FSICallbackFunctionID===b){n.error("Unable to remove listener: no callback for "+y+" registered");return false}return z.removeFunction(x)};this.watchListeners=function(y,x){o=x;v=y;j=false;for(var z in y){if(y.hasOwnProperty(z)){j=true;l.isset(z);w.reg[z]=b}}w.bDirty=true;l.checkListenerChanges()};var i=function(x){if(v[x]){w.bDirty=true;if(w.reg[x]===b){w.reg[x]=g[x].count}if(w.nTimeout===b){w.nTimeout=setTimeout(l.checkListenerChanges,5)}}};this.checkListenerChanges=function(){if(typeof(o)==="function"){if(w.nTimeout!==b){clearTimeout(w.nTimeout);w.nTimeout=b}if(w.bDirty){var z={};for(var x in w.reg){if(w.reg.hasOwnProperty(x)){var y=(g[x]!==b&&g[x].count>0);var A=(w.reg[x]===b)?b:(w.reg[x]>0);if(y!==A){z[x]=y}}}o.apply(l,[z]);w.bDirty=false;w.reg={}}}};this.dumpReg=function(){var A;var B;if(f&&f.getAPIData){B=f.getAPIData().oCallbacks}if(B){for(A in B){if(B.hasOwnProperty(A)){u(A)}}}var x;if(n&&n.on){x=n}else{x=a.console}var y=[];x.group("Total listeners: "+q);for(A in g){if(g.hasOwnProperty(A)){y.push(g[A].dump())}}y.sort();for(var z=0;z<y.length;z++){x.logCSS(y[z],"color:blue;","color:green;")}x.groupEnd()};this.isset=function(x){return(u(x).count>0)};this.runPersistent=function(y,x){l.run(y,x);p[y]=[x]};this.run=function(C,z){var y;var E=u(C);if(E.count>0){var x=E.getFunctionsArray();for(var B=0;B<x.length;B++){var D=x[B];D.countCalled++;var A=D.fn.apply(D.scope,z);if(A!==b){y=A;if(E.handleCallbackResult){y=E.handleCallbackResult(y,z)}}}}return y};var e=function(B){var y=this;this.count=0;var C=false;var A;var z={};var x={};this.addFunction=function(E,F,J){if(j&&y.count===0){i(B)}q++;y.count++;C=true;if(F===b){F=f}var D=E.__FSICallbackFunctionID;if(D===b){D=E.__FSICallbackFunctionID=a.utils.getNewCallbackFunctionID()}if(x[D]===b){x[D]=[]}x[D].push(t);z[t]={fn:E,scope:F,countCalled:0};if(n.on){var I=x[D].length;if(I>1){var H="";try{H=" "+E.name+"()"}catch(G){}n.error(I+" listeners for "+B+" have been added for the same function "+H+". Did you forget to remove a listener?")}if(y.count>20){n.error(I+" listeners for "+B+" have been added for this instance. Did you forget to remove a listener?")}}if(typeof(k[B])==="function"){y.handleCallbackResult=k[B]}if(p[B]!==b){if(!c||c(B,p[B],J)){E.apply(F,p[B][0])}}t++};this.getFunctionsArray=function(){if(C){A=[];var D=z;for(var E in D){if(D.hasOwnProperty(E)){if(typeof(D[E].fn)==="function"){A.push(D[E])}}}C=false}return A};this.removeFunction=function(G){var E=G.__FSICallbackFunctionID;var D=x[E];if(D===b){if(n.on){var I="this function";try{I="the function "+G.name}catch(H){}n.error("Unable to remove listener: no callback for "+B+" registered for "+I)}return false}var F=D.pop();if(j&&y.count===1){i(B)}q--;y.count--;if(D.length===0){delete x[E]}C=true;delete z[F]};this.dump=function(){var F;if(y.count===0){F="%c"+B+": %c no listeners"}else{if(y.count===1){F="%c"+B+": %c"+y.count+" listener"}else{F="%c"+B+": %c"+y.count+" listeners"}}var E=y.getFunctionsArray();if(E&&E.length>0){for(var G=0;G<E.length;G++){try{var I=E[G].fn.name;if(typeof(I)!=="string"||I.length===0){I="anonymous"}}catch(H){I="anonymous"}F+="\n - "+I;var D=E[G].countCalled;if(D===0){F+=" (not called yet)"}else{if(D===1){F+=" (called once)"}else{F+=" (called "+E[G].countCalled+" times)"}}}}return F}};r()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.API.QuickZoom!==b){return}a.utils.API.QuickZoom=function(d,e){var c=this;c.scriptMainFile="FSI.QuickZoom.js";c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,__FSI:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},addImage:{a:"elImg"},cancelZoom:{},destroy:{},dumpListeners:{},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getImageCount:{r:"nRegisteredImages"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getParameters:{r:"oParameters"},getVersion:{r:"strVersion"},init:{},printAPI:{},removeImages:{a:"arImageDOMElements"},removeListener:{a:"strListenerName, fn",r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},scanForNewImages:{}};c.oCallbacks={onConfigsReady:{a:"oConfigValues"},onDestroy:{},onInit:{},onModifyPositionAndSize:{a:"oModify, oInfo"},onStart:{a:"nImagesPrepared, arImageDOMElements"},onZoomEnd:{},onZoomStart:{a:"elImage, strZoomImage"}}}}(window.$FSI=window.$FSI||{}));(function(a,c){if(a.QuickZoom!==c){return}a.utils.addViewerClassCSSRule("div.FSIQuickZoom","position:absolute!important;z-index:10000;box-sizing:content-box!important;overflow:hidden!important;padding:0px 0px 0px 0px;cursor: crosshair;background-color:white;border:0px none;");a.QuickZoom=function(af){var w={};var W={strVersion:"2019",strBuild:"19.10.6785",strConfigSection:"QuickZoom",bHasListeners:true};var ar=new a.utils.ClassDef(this,"FSI QuickZoom",W);ar.oAPI=new a.utils.API.QuickZoom(this,w);var q=ar.instance;a.utils.guessFSIViewerLocation("fsiquickzoom.js",3);var u=a.utils.getViewerInstanceID();var P=new a.EmptyDebugger();var p=function(ax,aw){if(aw&&!P.on&&ax.on){if(M){M.stopPendingRequests()}q.destroy();q.init(ae,ap,true);return true}P=ax;if(P.on){P.setPrefix(q.getInstanceName())}};this.getInstanceID=function(){return u};this.getInstanceName=function(){return ar.strClassName+" [#"+u+"]"};var ap=(af)?a.utils.cloneParameters(af):{};var K;var z=false;var l;var M;var G;var ae;var au=new a.Rect();var E;var ak;var O=false;var e=true;var S=/((\?)|&)effects=([^&]*)/ig;var at=/((\?)|&)rect=([^&]*)/ig;var g=/((\?)|&)rect=([^&]*)/i;var aj=/[=,]+Pad\([^)]*/ig;var o=/((\?)|&)(width|height)=[^&]*/ig;var k;var y={};var av={};var aq=3;var H=false;var Z={x:0,y:0};var r={x:10000000,y:10000000};var R;var D;var m;var ai,N;var B;var t=1;var Q=true;var ah=false;var i=true;var h=true;var Y;var L;var an;P.log(q.getVersion());this.init=function(ax,az,aw,ay){ae=ax;if(ay){a.quickZoomParameters=a.utils.cloneParameters(az);return}if(z){return}if(aw!==c){ap.debug=aw}if(a.getDocumentScroll===c){P.error("Unsupported browser. "+navigator.userAgent);return}var aA={};aA.onConfigsReady=aa;aA.onDebuggerChange=p;M=new a.Config(null,aA,{strSection:ar.strConfigSection});M.init(ap);M.loadConfigs();G=w.iCallbacks=new a.Callbacks(q,M);if(G.isset("onInit")){G.runPersistent("onInit",[ap])}return true};this.getConfigValue=function(aw){if(M&&typeof(aw)==="string"){return M.cfg[a.trim(aw.toLowerCase())]}};this.getParameters=function(){return a.utils.cloneParameters(ap)};this.destroy=function(){U();if(M){M.destroy();M=c}if(G){G.run("onDestroy");G.destroy();G=c}if(B!==c){a.removeCustomEvent(q,"FSIDocumentZoomChange",j);B=c}if(K){var aw=K.getArray();for(var ax=0;ax<aw.length;ax++){n(aw[ax].tag)}K.empty()}z=false};var aa=function(){var aC;if(q.bAutoInitialized){P.log("Start (auto initialized)")}else{P.log("Start")}if(G.isset("onConfigsReady")){G.runPersistent("onConfigsReady",[a.utils.cloneObject(M.cfg)])}Y=M.makeBool(M.cfg.usedevicepixelratio,true);ak=M.makeBool(M.cfg.uncropzoomedimage,false);O=M.makeBool(M.cfg.inplacezoom,false);if(O){e=false}else{e=M.makeBool(M.cfg.autozoomdimension,true)}Q=M.makeBool(M.cfg.moverangecentercorners,false);if(a.BrowserSupports.documentZoom()){B=a.addCustomEvent(q,"FSIDocumentZoomChange",j);ah=(a.utils.getDocumentScale()>1)}if(!K){var aw={NameID:"$FSIQuickZoom_TagID"};K=new a.ImageTagCollection(aw,M.cfg);K.init()}a._FSIQuickZoomInstance=q;if(M.cfg.length>0){k="&headers="+M.cfg.headers}else{k=""}aq=J("magnification",2);aq=Math.max(1,aq);r.x=J("maxZoomWindowWidth",r.x);r.y=J("maxZoomWindowHeight",r.y);ai=J("minZoomWindowWidth",100);N=J("minZoomWindowHeight",100);Z.x=J("skipImageWidth",0);Z.y=J("skipImageHeight",0);R=J("pageMargin",18);D=J("zoomImageBorderWidth",-1);m=J("zoomImageOffset",0);L=(M.makeBool(M.cfg.usetouch,true));if(!L&&a.isMobileDevice&&a.BrowserSupports.documentZoom()){P.log("Aborting QuickZoom, useTouch is !== true");return false}if(D<0){try{var ay=document.createElement("div");ay.style.display="none";a.addClass(ay,"FSIQuickZoom");document.body.appendChild(ay);var ax=window.getComputedStyle(ay,null);var az=0;az=Math.max(az,parseFloat(ax.borderLeftWidth));az=Math.max(az,parseFloat(ax.borderRightWidth));az=Math.max(az,parseFloat(ax.borderTopWidth));az=Math.max(az,parseFloat(ax.borderBottomWidth));D=az;a.removeChild(document.body,ay)}catch(aD){}}var aE=document.getElementsByTagName("img");P.log("Preparing images (total images: "+aE.length+")");for(aC=0;aC<aE.length;aC++){am(aE[aC])}P.log(K.getCount()+" images have been prepared for FSI QuickZoom");if(G.isset("onStart")){var aB=K.getArray();var aA=new Array(aB.length);for(aC=0;aC<aB.length;aC++){aA[aC]=aB[aC].tag}G.runPersistent("onStart",[aA.length,aA])}z=true};this.addListener=function(az,ax,ay){var aw=false;if(G){aw=G.addListener(az,ax,ay)}return aw};this.removeListener=function(ay,ax){var aw=false;if(G){aw=G.removeListener(ay,ax)}return aw};var j=function(aw){var ax=(aw.FSI_scale>1);if(ah===ax){return}ah=ax;if(ax){U()}};var J=function(ax,ay){var aw=parseFloat(M.cfg[ax.toLowerCase()]);if(isNaN(aw)){aw=ay}return aw};this.getImageCount=function(){return(K)?K.getCount():0};this.removeImages=function(aw){if(aw===c||!z){return}if(aw.join===c){aw=[aw]}var ax=K.getCount();for(var az=0;az<aw.length;az++){n(aw[az])}var ay=K.getCount();var aA=ax-ay;P.log("removeImages: "+aA+" images have been removed, total zoom images now: "+ay+" images.");return aA};var x=function(aw){if(!aw){return}var ax=K.getById(aw.$FSIQuickZoom_TagID);if(ax){a.removeEvent(aw,"load",C,false);a.removeEvent(aw,"error",ab,false);a.removeEvent(aw,"mouseover",I,false);if(typeof(av)==="object"&&av.id===ax.__id){U()}}else{P.error("image to be removed not in collection:");P.log(aw);P.log(aw.oSprite)}return ax};var n=function(aw){var ax=x(aw);if(ax){K.remove(ax);ax.img.$FSIQuickZoom_TagID=c;delete ax.img.$FSIQuickZoom_TagID;if(L&&ax.touchHandler){ax.touchHandler.destroy();ax.touchHandler=c}}};this.addImage=function(ax,aw){if(!ax||ax.$FSIQuickZoom_TagID!==c||!z){return}var ay=am(ax);if(ay){ay.oInfo=aw}return(ay!==c)};var am=function(aw){if(!K){return}if(aw.FSIQuickZoomInstanceID!==c&&aw.FSIQuickZoomInstanceID!==u){return}var ax=K.add(aw);if(!ax){return}ax.srcCurrent=ax.src;ax.tag=aw;a.addEvent(aw,"load",C,false);a.addEvent(aw,"error",ab,false);a.addEvent(aw,"mouseover",I,false);if(L){ax.touchHandler=new a.TouchHandler(aw,{},ag,d,ao)}return ax};var ag=function(aw,ax){I.call(aw.target,aw,ax,true);return true};var ao=function(aw){an=a.now();f.call(aw.target)};var ad=function(ax){if(!ax||!ax.img||ax.bPrepared===true){return}var aw=ax.img;ax.src=ac(ax.src);if(aw.width!==c&&aw.width>0){ax.width=aw.width}if(aw.height!==c&&aw.height>0){ax.height=aw.height}if(ax.width>0&&ax.height>0){s(ax)}else{ax.bFinishOnLoad=true}ax.bPrepared=true;return ax};var s=function(aA){if(aA.img.bFSIUnCropZoomed===true||(ak&&aA.img.bFSIUnCropZoomed===c)){var aC=aA.src.match(g);if(aC&&aC.length===4){var aB=(aC[1]==="?")?"?":"";aA.src=aA.src.replace(at,aB);aA.rcUncropZoomed=aC[3]}}aA.ready=true;aA.wOrg=aA.width;aA.hOrg=aA.height;aA.src=M.reWriteImageURLByConditions(aA.src);var ay;ay=aA.src.match(S);if(ay&&typeof(ay)==="object"&&typeof(ay[0])==="string"){ay[0]=decodeURIComponent(ay[0]);if(ay[0].match(aj)){aA.bHasPadEffect=true}}if(!aA.bHasPadEffect){ay=aA.src.match(at);if(ay&&ay[0]){var ax=ay[0].split("=");if(ax.length>0){ax=decodeURIComponent(ax[1]).split(",");if(ax.length>3){var aw=parseFloat(ax[2]);var az=parseFloat(ax[3]);if(aw>0&&aw<=1&&az>0&&az<=1){aA.cropRectWidth=aw;aA.cropRectHeight=az}}}}}};var ac=function(aw){return aw.replace(o,"$2")};var ab=function(){var aw=(!a.isInternetExplorer)?this:window.event.srcElement;var ax=K.getById(aw.$FSIQuickZoom_TagID);if(ax.bLoading){ax.ready=false;ax.bLoading=false}};this.cancelZoom=function(){if(av){U()}};var C=function(){var ax=(!a.isInternetExplorer)?this:window.event.srcElement;var az=K.getById(ax.$FSIQuickZoom_TagID);var aw=K.getSrc(ax);if(!az.bLoading&&az.orgSrc!==aw){var ay=false;if(typeof(av)==="object"&&av.idVisible===az.__id){ay=true}if(ay){U()}az.bPrepared=az.ready=false;az.bInfo=az.oInfo=c;ac(az.src);az.srcCurrent=az.orgSrc=aw;az.sourceWidth=az.sourceHeight=c;az.src=ac(az.orgSrc);ad(az);al(az);if(ay&&l){I.call(az.img,l,y)}}if(az.bFinishOnLoad){delete az.bFinishOnLoad;az.width=ax.width;az.height=ax.height;s(az)}else{if(az.bLoading){az.bLoading=false}}};var F=function(aw){y.x=aw.clientX;y.y=aw.clientY};var U=function(){if(av&&av.elDiv){var aw=av.el;var ax=av.elDiv;if(av.id!==c){a.removeEvent(aw,"mousemove",d,false);a.removeEvent(aw,"mouseout",f,false);av.id=av.img=c;av.src=av.idVisible=c}if(!ax){return}a.removeEvent(av.elImageFinalZoom,"load",v,false);if(ax.parentNode){a.removeChild(ax.parentNode,ax)}av.elDiv=c;a.removeClass(aw,"FSIQuickZoom");G.run("onZoomEnd")}};var A=function(aG,a3){if(ah){return}var aJ=aG.img;if(Y){t=Math.max(1,a.getDevicePixelRatio())}else{t=1}var aB=D;var ba=m;if(typeof(av)==="object"&&av.idVisible===aG.__id){return}if(!aG.bInfo){return}var a4=false;if(aG.rcUncropZoomed&&typeof(aG.rcUncropZoomed)==="string"){au.setFromString(aG.rcUncropZoomed);if(!isNaN(au.width())&&au.width()>0&&!isNaN(au.height())&&au.height()>0){a4=true}}var aM=a.getViewportSize(window);var bn=R;var aS=aM.width-R-2*aB;var aQ=R;var bj=aM.height-R-2*aB;var aR=a.getDocumentScroll(window);var aC=a.getElementPosition(aJ);var bc=T(aJ);var aW;var aL,a0,bp,aD;if(!e){aW=a.utils.getElementPaddings(aJ);aL=aC.right-aC.left;a0=aC.bottom-aC.top;bp=aL+aW.left+aW.right;aD=a0+aW.top+aW.bottom}else{bp=aG.wOrg;aD=aG.hOrg}bp=Math.min(bp,r.x);aD=Math.min(aD,r.y);if(!O){var ay;var bb;var aT=aM.width-2*R-2*aB;var a8=aM.height-2*R-2*aB;var bl,bk;if(aT-bp>a8-aD){bb=a8;var a6=aC.left-R-bc.left-ba-2*aB;var a5=aM.width-aC.right-R-bc.right-ba-2*aB;bk=0;if(a5>a6){ay=a5;bl=1}else{ay=a6;bl=-1}}else{ay=aT;var a2=aC.top-R-bc.top-ba-2*aB;var a1=aM.height-aC.bottom-R-bc.bottom-ba-2*aB;bl=0;if(a1>a2){bb=a1;bk=1}else{bb=a2;bk=-1}}bp=Math.min(ay,bp);aD=Math.min(bb,aD)}var aX=false;if(typeof(aG.tag.getAttribute)==="function"){var bf=aG.tag.getAttribute("FSIQuickZoomMagnification")||aG.tag.getAttribute("data-fsi-quickzoom-magnification");if(typeof(bf)==="string"){bf=parseFloat(bf);if(!isNaN(bf)&&bf>1){aX=bf}}}if(!aX){aX=aq}a.utils.expandSourceDimensionForPadEffect(aG,aG.wOrg,aG.hOrg);var aI=aG.sourceWidth;var bi=aG.sourceHeight;var aV=Math.round(aI/t);var bg=Math.min(aV,Math.round(aX*aG.wOrg));if(a4){bg/=au.width()}aV=Math.round(bi/t);var a9=Math.min(aV,Math.round(aX*aG.hOrg));if(a4){a9/=au.height()}var aF;if(aG.cropRectWidth){aF=a.getFSIServerImageDim(aG.cropRectWidth*aI,aG.cropRectHeight*bi,bg,a9,c,!aG.bHasPadEffect)}else{aF=a.getFSIServerImageDim(aI,bi,bg,a9,c,!aG.bHasPadEffect)}if(aF.width<bp&&aF.height<=bp){return}bg=aF.width;a9=aF.height;var aP=Math.min(aI,Math.round(bg*t));var be=Math.min(bi,Math.round(a9*t));var aZ=bg/aP;var aA=function(){if(Q){i=false;h=false}else{i=(bg<=bp);h=(a9<=aD)}};aA();if(e){if(i){bp=bg}if(h){aD=a9}}var aK=aG.src+"&width="+aP+"&height="+be;if(av.src===aK){return}var aE,aH,aO,aN,br,bq;if(O){aE=-aB-aW.left;aH=-aB-aW.top}else{if(bl===0){aE=(aC.right-aC.left)/2-bp/2-aB}else{if(bl>0){aE=aC.right-aC.left+bc.right+ba}else{aE=-bc.left-bp-2*aB-ba}}aO=aC.left+aE;aN=aO+bp;if(aO<bn){aE+=bn-aO}if(aN>aS){aE-=aN-aS}if(bk===0){aH=(aC.bottom-aC.top)/2-aD/2-aB}else{if(bk>0){aH=aC.bottom-aC.top+bc.bottom+ba}else{aH=-bc.top-aD-2*aB-ba}}br=aC.top+aH;bq=br+aD;if(br<aQ){aH+=aQ-br}if(bq>bj){aH-=bq-bj}}if(G.isset("onModifyPositionAndSize")){var bh={};var bo={};bo.left=aE;bo.top=aH;bo.width=bp;bo.height=aD;bo.srcZoomImage=aK;bh.sourceElement=aJ;bh.imageWidth=bg;bh.imageHeight=a9;bh.imageWidthDPR=aP;bh.imageHeightDPR=be;bh.sourceImageWidth=aI;bh.sourceImageHeight=bi;bh.borderWidth=aB;bh.imageMargin=ba;bh.minZoomWidth=ai;bh.minZoomHeight=N;bh.maxZoomWidth=r.x;bh.maxZoomHeight=r.y;bh.elementPosition=a.utils.cloneObject(aC);bh.imgPaddings=a.utils.cloneObject(bc);bh.scrollPos=a.utils.cloneObject(aR);bh.event=a3;G.run("onModifyPositionAndSize",[bo,bh]);aE=bo.left;aH=bo.top;bp=bo.width;aD=bo.height;aK=bo.srcZoomImage;aA()}if(bp<ai||aD<N){return}a.addClass(aJ,"FSIQuickZoom");if(av.elDiv!==c){U()}av.id=av.idVisible=aG.__id;av.el=aJ;av.width=aJ.offsetWidth;av.height=aJ.offsetHeight;av.oImage=aG;av.elOffsetX=-aC.left-aR.x;av.elOffsetY=-aC.top-aR.y;var ax=av.elImageZoom=document.createElement("img");ax.setAttribute("loading","eager");ax.setAttribute("width",String(aP));ax.setAttribute("height",String(be));var a7="position:relative;border:0px none; padding:0px; margin:0px;";a7+="max-width:none;max-height:none;min-width:none;min-height:none;";a7+="width:"+aP+"px;height:"+be+"px";a.utils.setStyleAttr(ax,a7);if(aZ!==1){ax.style.width=bg+"px";ax.style.height=a9+"px"}var bm=document.createElement("div");a.utils.setStyleAttr(bm,"margin-left:0px;margin-top:0px;");bm.setAttribute("class","FSIQuickZoom");bm.style.width=bp+"px";bm.style.height=aD+"px";bm.style.left=Math.round(aR.x+aC.left+aE)+"px";bm.style.top=Math.round(aR.y+aC.top+aH)+"px";av.src=aK;av.elDiv=bm;av.elImageFinalZoom=ax;av.elImageZoom=av.elImagePreviewZoom=ax.cloneNode(false);if(a4){var aw=av.elImagePreviewZoom;E={width:aw.style.width,height:aw.style.height,paddingLeft:aw.style.paddingLeft,paddingTop:aw.style.paddingTop};aw.style.width=(bg*au.right)+"px";aw.style.height=(a9*au.bottom)+"px";aw.style.paddingLeft=(bg*au.left)+"px";aw.style.paddingTop=(bg*au.top)+"px"}else{E=c}av.elImagePreviewZoom.src=aG.orgSrcDisplay;a.addEvent(av.elImageFinalZoom,"load",v,false);ax.src=aK;av.scaleX=bg/aG.wOrg;av.scaleY=a9/aG.hOrg;av.centerX=av.elOffsetX;av.centerY=av.elOffsetY;if(Q){av.moveFactorX=bg/aG.wOrg;av.moveFactorY=a9/aG.hOrg;av.moveOffsetX=Math.round(bp/2);av.moveOffsetY=Math.round(aD/2);av.centerX-=aG.wOrg/2;av.centerY-=aG.hOrg/2}else{av.moveFactorX=(bg-bp)/aG.wOrg;av.moveFactorY=(a9-aD)/aG.hOrg;av.moveOffsetX=0;av.moveOffsetY=0}bm.style.pointerEvents="none";bm.appendChild(av.elImagePreviewZoom);document.body.appendChild(bm);var aY=new a.Rect();var aU=new a.Rect();var az=a.getElementClientPos(aJ);aY.copyRect(az);var bd=a.getElementClientPos(bm);aU.copyRect(bd);aU.interSectRectValidate(aY);H=(aU.width()>0&&aU.height()>0);d();G.run("onZoomStart",[aG.tag,aK])};var v=function(){var aw=this;a.removeEvent(aw,"load",v,false);var ax=av.elImagePreviewZoom;setTimeout(function(){if(E){for(var ay in E){if(E.hasOwnProperty(ay)){ax.style[ay]=E[ay]}}}ax.src=aw.src},0)};var T=function(ax){var aw={left:0,top:0,right:0,bottom:0};try{var ay=window.getComputedStyle(ax,null);aw.left+=parseFloat(ay.paddingLeft);aw.right+=parseFloat(ay.paddingRight);aw.top+=parseFloat(ay.paddingTop);aw.bottom+=parseFloat(ay.paddingBottom);aw.left+=parseFloat(ay.borderLeftWidth);aw.right+=parseFloat(ay.borderRightWidth);aw.top+=parseFloat(ay.borderTopWidth);aw.bottom+=parseFloat(ay.borderBottomWidth)}catch(az){}return aw};var d=function(ax,aB){if(aB!==c){y.x=aB.x;y.y=aB.y}else{if(ax){F(ax)}}if(!av||!av.elDiv){return}var aA=a.getDocumentScroll(window);var aw,az;if(i){y.x=-av.centerX-aA.x}if(h){y.y=-av.centerY-aA.y}aw=y.x+av.elOffsetX+aA.x;az=y.y+av.elOffsetY+aA.y;aw=aw*av.moveFactorX-av.moveOffsetX;az=az*av.moveFactorY-av.moveOffsetY;var ay=av.elImageZoom;ay.style.left=-Math.round(aw*t)/t+"px";ay.style.top=-Math.round(az*t)/t+"px"};var I=function(aw,aA,ay){if(L&&!ay&&an!==c){if(a.now()-an<50){f();return}an=c}l=aw;if(aA!==c){y.x=aA.x;y.y=aA.y}else{F(aw)}var ax=(!a.isInternetExplorer)?this:window.event.srcElement;var az=K.getById(ax.$FSIQuickZoom_TagID);if(!az){return}if(av.id!==az.__id){if(av.id){U()}a.addEvent(ax,"mousemove",d,false);a.addEvent(ax,"mouseout",f,false);av.id=az.__id;av.img=ax}ad(az);al(az);A(az,aw)};var f=function(){U()};this.scanForNewImages=function(){var aw=document.getElementsByTagName("img");var ax=0;P.log("...scanning for new images: "+aw.length+" image(s) in total");for(var ay=0;ay<aw.length;ay++){if(aw[ay].$FSIQuickZoom_ID===c){if(am(aw[ay])){ax++}}}P.log(ax+" new QuickZoom image(s) added")};var al=function(az){if(!az||az.bInfo!==c){return}az.bInfo=false;if(az.oInfo){V(null,az.oInfo,az)}else{var aw=az.src;var ax=aw.match(/.*[?]/);var ay=aw.match(/[?&]source=[^&]*/);aw=ax+"type=info&tpl=info.json"+k+ay;M.loadFile(aw,V,c,az)}};var V=function(az,ax,ay){if(typeof(ax)!=="object"){P.error("Failed to get image info for "+ay.src);ax=a.getFSIServerImageDim(ay.wOrg,ay.hOrg,4000,4000,c,true)}ay.sourceWidth=ax.width;ay.sourceHeight=ax.height;X(ay);var aw=false;if(Z.x>0&&ay.wOrg<Z.x){aw=true}if(Z.y>0&&ay.hOrg<Z.y){aw=true}if(aw){n(ay.img)}else{if(av.id===ay.__id){A(ay)}}};var X=function(aw){if(!aw.sourceWidth||!aw.sourceHeight){aw.ready=false;return}if(aw.rectWidth){aw.maxWidth=Math.round(aw.rectWidth*aw.sourceWidth);aw.maxHeight=Math.round(aw.rectHeight*aw.sourceHeight)}else{aw.maxWidth=aw.sourceWidth;aw.maxHeight=aw.sourceHeight}aw.bInfo=true}};var b=function(){a.removeEvent(window,"DOMContentLoaded",b);if(typeof(a.quickZoomParameters)!=="object"||a.makeBool(a.quickZoomParameters.autoInit,true)){a.initCustomTag("fsi-quickzoom");if(typeof(a.quickZoom)==="object"&&typeof(a.quickZoom.destroy)==="function"){a.quickZoom.destroy()}var d;if(typeof(a.quickZoomParameters)==="object"){d=a.quickZoomParameters}a.quickZoom=new a.QuickZoom(d);a.quickZoom.bAutoInitialized=true;a.quickZoom.init()}};a.addEvent(window,"DOMContentLoaded",b);a.customTags.register("fsi-quickzoom",{constructorClass:a.QuickZoom,viewerCSS:"display:none;",bConfigTag:true});a.dispatchEvent("FSIQuickZoomLoaded")}(window.$FSI=window.$FSI||{}));