/*!
 * FSI Thumb Bar
 * Build: 19.10.6785
 * 
 * Copyright (c) 2019 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function(k,d){if(k.fnDoNothing!==d){return}k.fnDoNothing=function(){};if(typeof(console.error)!=="function"){k.console={};k.console.log=k.fnDoNothing;k.console.logCSS=k.fnDoNothing;k.console.warn=k.fnDoNothing;k.console.error=k.fnDoNothing;k.console.dir=k.fnDoNothing;k.console.info=k.fnDoNothing}else{k.console=console;if(typeof(console.timeLog)==="function"){k.console.logCSS=console.log}else{k.console.logCSS=function(e){e=e.replace(/%c/g,"");console.log(e)}}}if(typeof(window.requestAnimationFrame)!=="function"){var b=0;var m=["ms","moz","webkit","o"];for(var l=0;l<m.length&&!window.requestAnimationFrame;++l){window.requestAnimationFrame=window[m[l]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m[l]+"CancelAnimationFrame"]||window[m[l]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(q){var e=new Date().getTime();var i=Math.max(0,16-(e-b));var p=window.setTimeout(function(){q(e+i)},i);b=e+i;return p};window.cancelAnimationFrame=function(e){clearTimeout(e)}}}k.initCustomTag=k.initCustomTags=k.fnDoNothing;k.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};k.osVersion=[0,0,0];var c=navigator.userAgent.toLowerCase();var o,n,f;if(c.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){o=true;if(c.search("android")>-1){k.mobileOS="android";k.isTouch=true;k.noMouse=true;n=c.match(/android (\S*)/);if(n&&n.length>1){n=n[1].split(".");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}else{if(c.indexOf("mac os")!==-1){k.mobileOS="ios";k.isTouch=true;k.noMouse=true;n=c.match(/ os (\S*)/);if(n&&n.length>1){n=n[1].split("_");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}}}else{o=false}k.isMobileDevice=o;k.isSmallMobileDevice=(c.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);k.isInternetExplorer=false;k.isIETouch=false;if(c.search("msie")>-1){k.isInternetExplorer=true;n=c.match(/msie ([^;]*)/);if(n&&n.length>1){k.versionInternetExplorer=parseFloat(n[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){k.isInternetExplorer=true;k.versionInternetExplorer=parseFloat(RegExp.$1)}else{k.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");if(k.isInternetExplorer){k.versionInternetExplorer=12}}}if(window.navigator.msPointerEnabled){k.isIETouch=(window.navigator.msMaxTouchPoints>1)}if(!k.isTouch){k.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(c.search("chrome")!==-1&&c.search("edge")===-1){k.isChrome=true}else{if(c.search("safari")!==-1){k.isSafari=true}else{if(c.search("firefox")!==-1){k.isFirefox=true}else{if(c.search("opera")!==-1){k.isOpera=true}}}}if(c.search("mac os")>-1){k.isMac=true}if(typeof(window.pageYOffset)==="number"){k.getDocumentScroll=function(e){return{x:e.pageXOffset,y:e.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.body.scrollLeft,y:e.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.documentElement.scrollLeft,y:e.document.documentElement.scrollTop}}}}}if(typeof(window.devicePixelRatio)!=="undefined"){k.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{k.getDevicePixelRatio=function(){return 1}}k.preventDefaultEvent=function(e){if(e.preventDefault){e.preventDefault()}e.returnValue=false;return false};k.getElementDimension=function(e){return{width:e.offsetWidth,height:e.offsetHeight}};k.getViewportSize=function(i){var e;if(!i){i=window}if(k.BrowserSupports.visualViewportAPI()){e={width:i.visualViewport.width,height:i.visualViewport.height}}else{e={width:i.innerWidth,height:i.innerHeight}}return e};k.replaceChild=function(q,s,i){try{var p=s.nextSibling;if(p){q.removeChild(s);q.insertBefore(i,p)}else{q.appendChild(i)}}catch(r){k.console.error(r.message);k.console.log(q);k.console.log(s);k.console.log(i)}};k.removeChild=function(i,q){try{i.removeChild(q)}catch(p){k.console.error(p.message);k.console.log(i);k.console.log(q)}};k.getWindowOffset=function(r){var q=0;var p=0;try{if(r.frameElement){var i=r;while(i.frameElement){var s=i.frameElement;var u=k.getElementPosition(s);q+=u.left;p+=u.top;i=i.parent}}}catch(t){}return{x:q,y:p}};var a=document.createElement("div");try{a.getBoundingClientRect();k.getBoundingClientRect=function(e){return e.getBoundingClientRect()}}catch(h){k.getBoundingClientRect=function(i){try{return i.getBoundingClientRect()}catch(p){return{top:0,left:0,right:0,bottom:0,width:0,height:0}}}}k.getElementClientDim=function(e){var i=k.getBoundingClientRect(e);return{width:(i.right-i.left),height:(i.bottom-i.top)}};k.getElementClientPos=function(e){return k.getBoundingClientRect(e)};k.getElementPosition=function(v){var i=k.getBoundingClientRect(v);var t=v.clientLeft;var B=v.clientTop;var C=0;var x=0;var u=0;var r=0;var D=0;var A=0;try{var q=window.getComputedStyle(v,null);u=parseFloat(q.paddingLeft);r=parseFloat(q.paddingRight);D=parseFloat(q.paddingTop);A=parseFloat(q.paddingBottom);t=parseFloat(q.borderLeftWidth);C=parseFloat(q.borderRightWidth);B=parseFloat(q.borderTopWidth);x=parseFloat(q.borderBottomWidth)}catch(w){}var s=i.left+t+u;var z=i.top+B+D;var p=i.right-C-r;var y=i.bottom-x-A;return{left:s,top:z,right:p,bottom:y}};k.dispatchEvent=function(e){var i;if(k.BrowserSupports.genericEvent()){i=new Event(e)}else{i=document.createEvent("Event");i.initEvent(e,true,true)}if(i){return window.dispatchEvent(i)}else{return false}};k.removeEvent=function(q,i,p,e){if(window.removeEventListener&&q){if(e===d){e=true}q.removeEventListener(i,p,e)}else{if(window.detachEvent&&q){q.detachEvent("on"+i,p)}}};k.addEvent=function(q,i,p,e){if(window.addEventListener&&q){if(e===d){e=true}q.addEventListener(i,p,e)}else{if(window.attachEvent&&q){q.attachEvent("on"+i,p)}}};k.sign=Math.sign||function(i){var e;if(isNaN(i)){e=NaN}else{if(i===0){e=0}else{e=(i<0)?-1:1}}return e};k.trim=function(e){if(!e||typeof(e)!=="string"||e.length<1){return e}return e.replace(/(^\s+)|(\s+$)/g,"")};var j=k.escapeRegEx=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};k.addClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};k.addClass(p,q);e.setAttribute("class",p.className)};k.removeClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={removeAttribute:k.fnDoNothing,className:i};k.removeClass(p,q);if(p.className!==""){e.setAttribute("class",p.className)}else{e.removeAttribute("class")}};k.hasClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};return k.hasClass(p,q)};k.addClass=function(i,r){if(!i||typeof(i.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var q=j(r);var p=new RegExp("(^|\\s+)"+q+"(\\s+|$)");var s=k.trim(i.className);var e=s.match(p);if(!e){if(s.length>0){s+=" "+r}else{s+=r}i.className=s}};k.removeClass=function(e,r){if(!e||typeof(e.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");var q=k.trim(e.className.replace(i," "));if(q.length>0){e.className=q}else{e.removeAttribute("class")}};k.hasClass=function(e,r){if(typeof(r)!=="string"){return false}r=k.trim(r);if(r.length<1){return false}var q=e.className;if(typeof(q)!=="string"||q.length<1){return false}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");return(q.match(i)!=null)};k.getFSIServerImageDim=function(e,r,p,t,i,q){var u={width:e,height:r};var s={width:p,height:t};k.calcFSIServerImageDim(u,s,i,q);return s};k.calcFSIServerImageDim=function(e,i,q,r){if(typeof(q)!=="object"){q={left:0,top:0,width:1,height:1}}else{q.left=q.left<0?0:q.left>1?1:q.left;q.top=q.top<0?0:q.top>1?1:q.top;q.width=q.width<0?1-q.left:q.width+q.left>1?1-q.left:q.width;q.height=q.height<0?1-q.top:q.height+q.top>1?1-q.top:q.height}i.width=i.width<=0||i.width===d?-1:i.width;i.height=i.height<=0||i.height===d?-1:i.height;var u={};if(i.width!==-1&&i.height!==-1){u.x=i.width/(e.width*q.width);u.y=i.height/(e.height*q.height)}else{if(i.height===-1){u.x=u.y=i.width/(e.width*q.width)}else{u.x=u.y=i.height/(e.height*q.height)}}if(i.width===-1||i.height===-1){var t=Math.min(u.x,u.y);if(i.width===-1){i.width=Math.round(e.width*q.width*t)}else{if(i.height===-1){i.height=Math.round(e.height*q.height*t)}}u.x=t;u.y=t}if(r&&Math.abs(u.x-u.y)>1e-7){if(u.x>u.y){var p=i.height*e.width*q.width/(e.height*q.height);u.x=p/e.width;i.width=Math.round(p)}else{var s=i.width*e.height*q.height/(e.width*q.width);u.y=s/e.height;i.height=Math.round(s)}}i.width=i.width===0?1:i.width;i.height=i.height===0?1:i.height;return u};k.BrowserSupports={};k.BrowserSupports[false]=function(){return false};k.BrowserSupports[true]=function(){return true};k.BrowserSupports.localStorage=function(){var i=false;try{if(typeof(window.localStorage)!=="undefined"&&typeof(localStorage.setItem)==="function"){i=true}}catch(p){}k.BrowserSupports.localStorage=k.BrowserSupports[i];return i};k.BrowserSupports.visualViewportAPI=function(){var i=false;try{if(typeof(window.visualViewport)!=="undefined"){i=true}}catch(p){}k.BrowserSupports.visualViewportAPI=k.BrowserSupports[i];return i};k.BrowserSupports.genericEvent=function(){var i=false;try{if(typeof(window.Event)==="function"){i=true}}catch(p){}k.BrowserSupports.genericEvent=k.BrowserSupports[i];return i};k.BrowserSupports.customElementRegistry=function(){var i=false;try{if(typeof(window.customElements)==="object"&&typeof(window.customElements.define)==="function"){i=true}}catch(p){}k.BrowserSupports.customElementRegistry=k.BrowserSupports[i];return i};k.BrowserSupports.registerElement=function(){var i=false;try{if(typeof(document.registerElement)==="function"){i=true}}catch(p){}k.BrowserSupports.registerElement=k.BrowserSupports[i];return i};k.BrowserSupports.canvas=function(){var q=false;try{var p=document.createElement("canvas");var i=p.getContext("2d");if(i&&i.clearRect!==d){q=true}}catch(r){}k.BrowserSupports.canvas=k.BrowserSupports[q];return q};k.BrowserSupports.cssTouchAction=function(){var p=false;try{if(k.isTouch){if(typeof(window.getComputedStyle)==="function"){var i=window.getComputedStyle(document.body);p=(typeof(i.touchAction)==="string")}}}catch(q){}k.BrowserSupports.cssTouchAction=k.BrowserSupports[p];return p};var g=Boolean(k.isMobileDevice||k.isIETouch||k.isTouch||(k.isMac&&k.isSafari));k.BrowserSupports.documentZoom=k.BrowserSupports[g]}(window.$FSI=window.$FSI||{}));(function($FSI,undefined){if($FSI.Utils!==undefined){return}$FSI.Utils=function(){var self=this;var addedCSSBlocks={};var rgxThousandSeperator=/(\d+)(\d{3})/;var regexPlusToSpace=/\+/g;var regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;var regExServerFormat1=/(&)?format=[^&]*/ig;var regExServerFormat2=/\?&/;var documentScaleMethod;var __getMediaMinScreenWidthCount=0;var __getMediaMinScreenWidthLoopCount=0;var __LastGetMediaMinScreenWidthResult;var __LastGetMediaMinScreenWidth;var __getDocumentScaleReferenceWidth;var strCSSTransformStyleName;var iLoaderCSSSkin;var iLoaderJavascript;this.oLanguageMap=undefined;this.API={};var topWindow;var strFSIViewerURL;try{if(typeof(top.window.alert)==="function"){topWindow=top.window}else{topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");topWindow=window}var oMatchMedia=topWindow.matchMedia||topWindow.msMatchMedia;this.getTopWindow=function(){return topWindow};var callbackFunctionID=0;this.getNewCallbackFunctionID=function(){return callbackFunctionID++};var nViewerInstanceID=0;this.getViewerInstanceID=function(){return ++nViewerInstanceID};var oSupportedEvents={};$FSI.isEventSupported=function(eventName){if(oSupportedEvents[eventName]!==undefined){return oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;oSupportedEvents[eventName]=isSupported;return isSupported};this.getSVGNameSpaceURL=function(){return"http://www.w3.org/2000/svg"};var nSVGID=0;this.getSVGID=function(){return"$FSI.SVGID_"+nSVGID++};var oClassDefCreated={};this.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;if(oOptions.bNoAPI!==true){instance.getAPIData=function(){return self.oAPI}}this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){if(obj.hasOwnProperty(o)){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,strResult,strType,itm;var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{$FSI.console.log("\r\n"+strTitle+" of "+strVersionString+line)}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a===undefined){ar[i].a="void"}args="%c( "+ar[i].a+" )"}else{args="%c"}strResult=(ar[i].r===undefined)?"%c":"%c"+strReturn+ar[i].r;strType=(ar[i].t===undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]===undefined){nNotAvailable++;itm+=" [x]"}$FSI.console.logCSS(itm,"color:#00a;","color:green;")}if(nNotAvailable>0){$FSI.console.logCSS("%c\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options","color:#c50")}if(fnGroup!==undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)==="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)==="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!==undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)==="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!==undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!oClassDefCreated[strClassName]){oClassDefCreated[strClassName]=true;if(instance.getBuild()!==$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};new self.ClassDef($FSI,"FSI Core",{strVersion:"2019",strBuild:"19.10.6785",bNoAPI:true});this.mergeObjects=function(o1,o2){for(var o in o2){if(o2.hasOwnProperty(o)){o1[o]=o2[o]}}return o1};this.cloneArray=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}return ar.concat([])};this.cloneArrayRecursive=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=self.cloneValue(ar[i])}return ret};this.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=self.cloneArrayRecursive(val)}else{ret=self.cloneObject(val)}}break;default:ret=val}return ret};this.cloneObject=function(obj){if(typeof(obj)!=="object"){return{}}if(obj==null){return null}var ret={};if(typeof(obj)==="object"&&typeof(obj.push)==="function"){ret=self.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=self.cloneValue(obj[o])}}return ret};this.cloneParameters=function(parameters){return self.cloneObject(parameters)};var regExEffects=/((\?)|&)effects=([^&]*)/ig;var regExPadEffect=/[=,]+Pad\([^)]*/ig;this.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match(regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match(regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};var documentDomain=document.location.hostname;var regCors=new RegExp("//"+documentDomain+"[:/]");this.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match(regCors)==null};this.loadImageCors=function(img,url){if(self.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};var oBoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=oBoolTable[value];if(ret===undefined){ret=def}}return ret};this.getBoolTable=function(val){return oBoolTable[val]};var oCustomEventListenerClasses={};var oCustomEventListenerInstances={};var oCustomEventListeners={};var nCustomEventListeners=0;var nCustomEventListenerID=0;var nCustomEventFunctionID=0;var nCustomEventElementID=0;this.customEventClassExists=function(nam){return(oCustomEventListenerClasses[nam]!==undefined)};this.getCustomEventListenerInstance=function(myEvent){return new oCustomEventListenerClasses[myEvent]()};this.registerCustomEvent=function(nam,fnClass){if(oCustomEventListenerClasses[nam]){return false}oCustomEventListenerClasses[nam]=fnClass};this.getNewEventElementID=function(){return nCustomEventElementID++};this.getNewEventFunctionID=function(){return nCustomEventFunctionID++};$FSI.addCustomEvent=function(myObj,myEvent,myFunc){var obj,listenerID;var listener=oCustomEventListenerInstances[myEvent];if(!listener){if(typeof(oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is missing.");return false}listener=oCustomEventListenerInstances[myEvent]=new oCustomEventListenerClasses[myEvent]()}obj=listener.addListener(myObj,myFunc);if(obj!==undefined){listenerID=obj.nCustomEventListenerID=nCustomEventListenerID++;oCustomEventListeners[obj.nCustomEventListenerID]=obj;nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc){var listener=oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&oCustomEventListeners[obj.nCustomEventListenerID]!==undefined){delete oCustomEventListeners[obj.nCustomEventListenerID];nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};var createJavascriptLoader=function(){if(!iLoaderJavascript){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!createJavascriptLoader()){return false}return iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!createJavascriptLoader()){return false}return iLoaderJavascript.release(strScriptPath,idInstance)};this.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof(iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};this.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};this.setStyleAttr=function(el,strStyle){
/*@cc_on
			 @if (@_jscript_version < 9)
			 el.style.setAttribute('cssText', strStyle);
			 @else @*/
el.setAttribute("style",strStyle);
/*@end
			 @*/
};this.changeRendererInURL=function(url,strRenderer){url=url.replace(regExServerRenderer,"$1renderer="+strRenderer);return url};this.removeFormatInURL=function(url){url=url.replace(regExServerFormat1,"");url=url.replace(regExServerFormat2,"?");return url};this.urlEncode=function(str){if(!str){return str}try{str=encodeURIComponent(str)}catch(e){$FSI.console.error("Malformed URI: "+str)}str=str.replace(regexPlusToSpace,"%2B");return str};this.getCSSTransformStyleName=function(){if(strCSSTransformStyleName!==undefined){return strCSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!=="translate( 0 , 0)"){ret=ar[i];break}}div=null;strCSSTransformStyleName=ret;return ret};var oViewerClassCSSRules={};var oInsertedCSS;this.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=oViewerClassCSSRules[strClass];if(res===strRule){return}addCSSRule(strClass,strRule,0);oViewerClassCSSRules[strClass]=strRule};this.dumpCSS=function(){console.log("Viewer Class CSS");console.log(oViewerClassCSSRules);console.log("CSS blocks");console.log(addedCSSBlocks);console.log("CSS in FSI.CORE");console.dir(oInsertedCSS.sheet.rules)};this.cssClassExists=function(cssID){return(typeof(addedCSSBlocks[cssID])!=="undefined")};this.addCSSClass=function(cssID,strCode){if(self.cssClassExists(cssID)){return false}var node=addCSSNode(cssID);if(node){try{node.innerHTML=strCode;addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};var addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("data-generated-by","FSI");node.setAttribute("data-generated-for",cssID);node.setAttribute("data-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};this.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!==undefined&&ar.length>0){for(var i=0;i<ar.length;i++){deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};this.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors===undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);addCSSRule(strSelector,strRule,0)};var addCSSRule=function(selector,rules,index){if(oInsertedCSS===undefined){oInsertedCSS=addCSSNode("FSI.Core")}if(oInsertedCSS!==undefined){try{if(oInsertedCSS&&oInsertedCSS.sheet){if("insertRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};var deleteCSSRule=function(selector){var ret=false;var i;if(oInsertedCSS!==undefined){try{var arDelete=[];var ar=oInsertedCSS.sheet.cssRules;for(i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText===selector){arDelete.push(i)}}if(arDelete.length>0){for(i=arDelete.length-1;i>-1;i--){oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};this.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};this.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};this.getElementBorders=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.borderLeftWidth);ret.top=parseFloat(style.borderTopWidth);ret.right=parseFloat(style.borderRightWidth);ret.bottom=parseFloat(style.borderBottomWidth)}catch(e){}return ret};this.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};var getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};this.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};this.guessFSIViewerLocation=function(strScriptName,depth){if(strFSIViewerURL!==undefined){return strFSIViewerURL}var ret=self.getScriptPath(strScriptName,depth);if(ret){strFSIViewerURL=ret}return ret};var bHTTPS=(document.location.protocol==="https:");this.isHTTPS=function(){return bHTTPS};$FSI.getViewerLocation=function(){return strFSIViewerURL};this.getNumberSeperators=function(iConfig){var lngEng={english:1,japanese:1,chinese_simplified:1,chinese_traditional:1};var lng;if(!iConfig||!iConfig.cfg||typeof(iConfig.cfg.language)!=="string"){lng="english"}else{lng=iConfig.cfg.language.toLowerCase()}return(lngEng[lng])?{thousand:",",decimal:"."}:{thousand:".",decimal:","}};this.makeNiceNumber=function(val,dec,oNumberSep){if(!oNumberSep){oNumberSep={thousand:",",decimal:"."}}if(dec===undefined){dec=0}val=val.toFixed(dec);val=""+val;val=val.split(".");var ret=val[0];while(rgxThousandSeperator.test(ret)){ret=ret.replace(rgxThousandSeperator,"$1"+oNumberSep.thousand+"$2")}if(dec>0){ret+=oNumberSep.decimal+val[1]}return ret};this.makeNiceFileSize=function(n,oNumberSep){var u="byte";if(n>1024){n/=1024;u="KB"}if(n>1024){n/=1024;u="MB"}if(n>1024){n/=1024;u="GB"}if(n>1024){n/=1024;u="TB"}if(u!=="byte"){n=self.makeNiceNumber(Math.round(100*n)/100,2,oNumberSep)}else{n=self.makeNiceNumber(n,0,oNumberSep)}return n+" "+u};this.getCSSColor=function(val){if(typeof(val)==="string"&&val.length>0){val=$FSI.trim(val);if(val.match(/^[0-9,a-f]{3}$/i)||val.match(/^[0-9,a-f]{6}$/i)){val="#"+val.toUpperCase()}}return val};var getMediaMinScreenWidth=function(nam,unit){var init=topWindow.document.documentElement.clientWidth;if(__LastGetMediaMinScreenWidth===topWindow.document.documentElement.clientWidth){return __LastGetMediaMinScreenWidthResult}__LastGetMediaMinScreenWidth=topWindow.document.documentElement.clientWidth;__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}__LastGetMediaMinScreenWidthResult=__getDocumentScaleReferenceWidth=init-step;return __LastGetMediaMinScreenWidthResult};this.getDocumentScaleMethod=function(){return documentScaleMethod};this.getDocumentScaleNone=function(){return 1};this.getDocumentScaleInit=function(){self.getDocumentScale=self.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){documentScaleMethod="visualViewport API";self.getDocumentScale=function(){return topWindow.visualViewport.scale};return self.getDocumentScale()}if(topWindow.innerWidth===undefined){documentScaleMethod="none";return self.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";self.getDocumentScale=function(){if(screen.width!==topWindow.outerWidth){return(topWindow.outerWidth-192)/topWindow.innerWidth}return(topWindow.outerWidth-83)/topWindow.innerWidth};return self.getDocumentScale()}if(window.orientation!==undefined){if(!window.outerWidth){documentScaleMethod="screen.width / window.innerWidth iOS";self.getDocumentScale=function(){__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return __getDocumentScaleReferenceWidth/window.innerWidth};return self.getDocumentScale()}documentScaleMethod="window.outerWidth / window.innerWidth";self.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return self.getDocumentScale()}if(oMatchMedia&&topWindow.document.documentElement.clientWidth>0){var w=getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){documentScaleMethod="CSS Media Query";self.getDocumentScale=function(){var res=getMediaMinScreenWidth("min-width","px")/topWindow.innerWidth;if(isNaN(res)){res=1}return res};return self.getDocumentScale()}}documentScaleMethod="fallback";self.getDocumentScale=function(){return topWindow.outerWidth/topWindow.innerWidth};return self.getDocumentScale()};self.getDocumentScale=self.getDocumentScaleInit;self.getDocumentScaleWithPixelRatio=function(){return self.getDocumentScale()*$FSI.getDevicePixelRatio()};self.getImageDimFitInto=function(wSrc,hSrc,wMax,hMax,oCroppedImage,bNoLimitToSourceDim){var ret={};var wSrcOrg=wSrc;var hSrcOrg=hSrc;if(!bNoLimitToSourceDim){wMax=Math.min(wSrc,wMax);hMax=Math.min(hSrc,hMax)}var bCropped=oCroppedImage&&oCroppedImage.isCropped();if(bCropped){oCroppedImage.setSourceDimension(wSrc,hSrc);var rc=oCroppedImage.getPixelRangeRect();wSrc=rc.right;hSrc=rc.bottom}if(wSrc/wMax>hSrc/hMax){ret.width=wMax;ret.height=Math.round(hSrc/wSrc*wMax)}else{ret.height=hMax;ret.width=Math.round(wSrc/hSrc*hMax)}if(bCropped){ret.widthUncropped=Math.round(ret.width*wSrcOrg/wSrc);ret.heightUncropped=Math.round(ret.height*hSrcOrg/hSrc)}else{ret.widthUncropped=ret.width;ret.heightUncropped=ret.height}return ret};self.extendRectToFill=function(rc,srcWidth,srcHeight,targetWidth,targetHeight,bAllowInvalidRect,bAllowMove){var amount;var wCur=rc.width()*srcWidth;var hCur=rc.height()*srcHeight;var dim=self.fitImageIntoSpace(wCur,hCur,targetWidth,targetHeight,true,true);if(dim.width/targetWidth<dim.height/targetHeight){amount=(targetWidth/dim.width-1)*rc.width();rc.left=rc.left-amount/2;rc.right=rc.right+amount/2;if(bAllowMove){if(rc.right>1){rc.offsetRect(-(rc.right-1),0)}else{if(rc.left<0){rc.offsetRect(-rc.left,0)}}}}else{amount=(targetHeight/dim.height-1)*rc.height();rc.top=rc.top-amount/2;rc.bottom=rc.bottom+amount/2;if(bAllowMove){if(rc.bottom>1){rc.offsetRect(0,-(rc.bottom-1))}else{if(rc.top<0){rc.offsetRect(0,-rc.top)}}}}if(!bAllowInvalidRect){rc.limitToImageRect()}};this.fitImageIntoSpace=function(wSrc,hSrc,wTarget,hTarget,bDoNotLimitToSrcDim,bFloats){if(!bDoNotLimitToSrcDim){wTarget=Math.min(wTarget,wSrc);hTarget=Math.min(hTarget,hSrc)}var ret={};if(wTarget/wSrc<hTarget/hSrc){ret.dim="width";if(bDoNotLimitToSrcDim){ret.width=wTarget}else{ret.width=Math.min(wTarget,wSrc)}ret.height=ret.width*hSrc/wSrc}else{ret.dim="height";if(bDoNotLimitToSrcDim){ret.height=Math.min(hTarget,hSrc)}else{ret.height=hTarget}ret.width=ret.height*wSrc/hSrc}if(!bFloats){ret.width=Math.round(ret.width);ret.height=Math.round(ret.height)}return ret};this.getParameterValueFromURL=function(url,nam){var ret=undefined;if(typeof(url)==="string"&&typeof(nam)==="string"&&nam.length>0&&url.length>0){nam=$FSI.escapeRegEx(nam);var reg=new RegExp("(\\?|&)"+nam+"=([^&]*)");var match=url.match(reg);if(match&&match[2]){ret=decodeURIComponent(match[2])}}return ret}};if(!$FSI.utils){$FSI.utils=new $FSI.Utils()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomTags!==b){return}a.CustomTags=function(){var g={};var e=false;var f=(a.BrowserSupports.registerElement()||a.BrowserSupports.customElementRegistry());var d=this.initCustomTags=function(){if(f){return false}for(var h in g){if(g.hasOwnProperty(h)){c(h)}}return true};var c=this.initCustomTag=function(l){if(f){return false}var k=g[l];if(!k){return false}var h=document.getElementsByTagName(l);if(h.length>0){k.replaceTagInit()}if(h&&h.length>0){for(var j=0;j<h.length;j++){k.replaceTag(h[j],k)}}return true};this.get=function(h){return g[h]};this.register=function(i,h){if(g[i]===b){g[i]=new a.CustomTag(i,h);if(!e){e=true;if(!f){a.addEvent(window,"DOMContentLoaded",d)}}a.customTags.initCustomTag(i)}return g[i]}};a.CustomTag=function(f,c){var q=this;var h;this.opts=c;var p=function(){a.utils.addViewerClassCSSRule(f,c.viewerCSS);if(a.BrowserSupports.customElementRegistry()){j()}else{if(a.BrowserSupports.registerElement()){l()}}};var e=function(s,t){var r=s.getAttribute(t);if(typeof(r)==="string"&&r.length>0){if(!r.match(/[^0-9\s]/)){r+="px"}s.style[t]=r}};var k=function(r){e(r,"width");e(r,"height")};var i=function(u){var r=a.utils.attributes2parameters(u);if(c.parameterAliases){var v=c.parameterAliases;for(var t in v){if(v.hasOwnProperty(t)){var s=v[t];if(r[t]!==b&&r[s]===b){r[s]=r[t]}}}}if(r.src!==b&&r.imagesrc===b){r.imagesrc=r.src}return r};var j=function(){window.customElements.define(f,n)};var g=this.onCreated=function(){c.constructorClass.prototype.constructor.call(this,this,{autoInit:false})};var o=this.onAttached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}m(this)};var m=function(r){k(r);r.init(r,i(r),b,true);if(typeof(r.start)==="function"){r.start()}};var d=this.onDetached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}if(typeof(this.destroyOnDetach)==="function"){this.destroyOnDetach()}};var l=function(){var r=Object.create(HTMLDivElement.prototype);r.createdCallback=g;r.attachedCallback=o;r.detachedCallback=d;document.registerElement(f,{prototype:r})};this.replaceTag=function(s,r){if(!s||(typeof(s.getInitDone)==="function"&&s.getInitDone())){return}if(r.opts.bConfigTag!==true){c.constructorClass.prototype.constructor.call(s,s,{autoInit:false});m(s)}else{c.constructorClass.prototype.constructor.call(s);s.init(s,i(s),false,true)}};this.replaceTagInit=function(){if(h){return}h=true;a.utils.addViewerClassCSSRule(f,c.viewerCSS)};var n;if(window.Reflect){n=function(){var r=window.Reflect.construct(HTMLElement,[],this.constructor);g.apply(r);return r};n.prototype=Object.create(HTMLElement.prototype);n.prototype.constructor=n;n.prototype.connectedCallback=o;n.prototype.disconnectedCallback=d}p()};if(!a.customTags){a.customTags=new a.CustomTags();a.initCustomTags=a.customTags.initCustomTags;a.initCustomTag=a.customTags.initCustomTag}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!==b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=this.logCSS=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=a.console;var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("logCSS",this.log);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!==b){return}a.Config=function(al,x,f){if(typeof(f)!=="object"){f={}}if(!x||typeof(x)!=="object"){x={}}var n=this;this.parameters=(al&&typeof(al)==="object")?al:{};this.XMLSerializer=(window.XMLSerializer)?new window.XMLSerializer():b;this.plugins={};this.arPlugins=[];this.arUnrecognizedConfigNodes=[];this.arConditions=[];var Z=false;var O={};var B=0;var r;var ad={};var H=n.debug=new a.EmptyDebugger();var D=false;var y={};var aq=false;var T={stickynotes:"bookmarks"};var g;var Y=false;var t;var L;var ag;var c;var m;var v="token";var w;var p;var K={};var aj=/(\\?|&)tpl=/i;var af=/\.json\s*$/i;var d=/\.xml\s*$/i;if(a.isInternetExplorer&&a.versionInternetExplorer<10){p=function(at){var ar;if(!a.utils.isCrossDomain(at)){aq=false;ar=new XMLHttpRequest()}else{aq=true;ar=new XDomainRequest()}return ar}}else{if(typeof(XMLHttpRequest)!=="undefined"){p=function(){return new XMLHttpRequest()}}}this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",format:"imageformat",renderer:"fpxservertemplate",imagerenderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(av){n.reset();t=(typeof(f.strSection)==="string")?f.strSection:"";L=t.toLowerCase();if(typeof(f.strTraceParam)==="string"){var at=f.strTraceParam.toLowerCase();c={};c[at]=true;if(at.indexOf("_")>0&&at.indexOf("pages")===0){at=at.split("_");at.shift();at=at.join("_");c[at]=true}var au=n.getParameterAlias(at);if(au){c[au]=true}}else{c=false}if(av){if(n.parameters){n.parameters=a.utils.mergeObjects(n.parameters,av)}else{n.parameters=av}}ak(n.parameters);n.getQueryParameters();n.cloneParameters(n.cfgDefaults,n.cfg);n.cloneParameters(n.queryParameters,n.cfg);delete n.cfg.effects;n.elevateToHTTPS();e();n.locationFSIViewer="";if(n.queryParameters.fsiviewerlocation!==b){n.locationFSIViewer=n.queryParameters.fsiviewerlocation}else{H.log("FSI Viewer location guessed based on script location: "+a.getViewerLocation());n.locationFSIViewer=(a.getViewerLocation()||"")}if(n.locationFSIViewer.charAt(n.locationFSIViewer.length-1)!=="/"){n.locationFSIViewer+="/"}var ar=n.cfg.defaultcfg;if(typeof(ar)==="string"&&ar.length>0){n.nextConfigURL=n.getReloadPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.defaultcfg))}else{n.nextConfigURL=b}n.checkDebug(false)};var ak=this.makeObjectPropertiesLowerCase=function(ar){for(var at in ar){if(ar.hasOwnProperty(at)){var au=at.toLowerCase();if(at!==au){if(ar[au]===b){ar[au]=ar[at]}delete ar[at]}}}};this.getClassParameters=function(){return ag};this.setAccessToken=function(ar){w=ar};this.getParameterAlias=function(au){var ar;if(n.cfgAliasNames[au]){ar=n.cfgAliasNames[au]}else{for(var at in n.cfgAliasNames){if(n.cfgAliasNames.hasOwnProperty(at)){if(n.cfgAliasNames[at]===au){ar=at;break}}}}return ar};var e=function(){Z=n.makeBool(n.cfg.usenc,false);if(n.cfg.usencquery!==b&&n.cfg.usencquery.length>0){D=n.cfg.usencquery;Z=true;n.queryToObject("?"+D,y)}};this.stopPendingRequests=function(){for(var at in O){if(O.hasOwnProperty(at)){var ar=O[at];if(ar){ar.FSIaborted=true;if(ar.abort){ar.abort()}}}}};this.destroy=function(){n.stopPendingRequests()};this.reset=function(){K={};ag={};n.parameters={};H=n.debug=new a.EmptyDebugger();n.stopPendingRequests();r=Math.random();n.nIncludedConfigs=0;n.completedConfigs={};n.plugins={};n.cfg={};n.queryParameters=b;n.arUnrecognizedConfigNodes=[];am=0;n.arConditions=[];ad={}};this.getQueryParameters=function(){if(n.queryParameters!==b){return}n.queryParameters={};n.cloneParameters(n.parameters,n.queryParameters)};this.makeBool=function(av,ar){if(typeof(ar)!=="boolean"){ar=false}var at=ar;switch(typeof(av)){case"string":var au=a.makeBool(av);if(au!==b){at=au}break;case"number":at=Boolean(av);break;case"boolean":at=av;break}return at};this.parsePositionParameter=function(at){if(typeof(at)!=="string"||at.length<3){return b}at=at.split(",");if(at.length<3){return b}for(var ar=0;ar<3;ar++){at[ar]=parseFloat(at[ar]);if(isNaN(at[ar])){at[ar]=0}}return{x:at[0],y:at[1],z:at[2]}};this.logLoadFileFailed=function(ar){if(!H.on){return}if(ar&&ar.status!==b){var au="HTTP "+ar.status;if(ar&&ar.statusText){au+=", "+ar.statusText}var at=(ar._url)?ar._url:"";H.error("Failed to load "+at+" ("+au+")")}else{H.error("Failed loading a file");if(ar&&ar._url){H.error(ar._url)}}};this.getAttributeValue=function(at,ar){if(!at){return}return at.getAttribute(ar)};this.getImageDownloadOriginalURL=function(at){var ar=n.serverBase.replace(/\/server$/,"");return ar+"/service/file/"+at};this.getImageURL=function(au,ar){var at;if(au===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="image"}if(w){ar[v]=w}ar.source=au;for(at in ad){if(ad.hasOwnProperty(at)){if(ad[at]!==b&&ar[at]===b){ar[at]=ad[at]}}}for(at in ab){if(ar[at]){if(ab[at]!==at){if(!ar[ab[at]]){ar[ab[at]]=ar[at]}ar[at]=null}}}if(ar.renderer===b){ar.renderer="jpeg"}return n.requestBase+"?"+n.objectToQuery(ar)};this.getRectFromInitialView=function(au){var at=n.viewStringToArray(au);return new a.Rect(at[2],at[3],at[4],at[5])};this.getImageRectParamFromRect=function(ar){var at=ar.duplicateRect();at.right=at.width();at.bottom=at.height();return at.toString()};this.getImageURLAsInViewer=function(ax,aA,aF,av,aw,aG,ar,az){az=az||{};var aH={};if(!ar||typeof(ar)!=="object"){ar={}}if(typeof(aG)!=="string"){aG=n.cfg.initialview}var aC,aE;var aB={width:aA,height:aF};var aD={width:aA,height:aF};if(aG){aE=n.getRectFromInitialView(aG)}if(az.bDoNotModifyQuery!==true){delete ar.width;delete ar.height;delete ar.rect}var au=new a.CroppedImage();au.setSourceDimension(aA,aF);au.setCropFromConfig(n.cfg);if(az.cropToFill){au=au.getCropToFill(av,aw,az.cropToFill,true)}var ay;aH.iCrop=au;if(au.isCropped()){ay=aC=au.getFloatRect();aH.rcSource=au.getImageRect()}else{aH.rcSource=new a.Rect(0,0,aA,aF)}if(aE&&!aE.isDefaultImageRect()&&az.expandViewStringToFit!==false){var aI,aJ;if(ay){aI=ay.width();aJ=ay.height()}else{aI=aJ=1}a.utils.extendRectToFill(aE,aI*aA,aJ*aF,av,aw,false,true)}if(ay){if(aE){aC=aC.getPartialRect(aE)}}else{aC=aE}if(aC&&!aC.isDefaultImageRect()){aD.width=aA*aC.width();aD.height=aF*aC.height();aB.width=Math.round(aD.width);aB.height=Math.round(aD.height);if(ar.rect===b){ar.rect=n.getImageRectParamFromRect(aC)}}aH.rc=aC;var at=a.utils.fitImageIntoSpace(aD.width,aD.height,av,aw);if(ar.width===b&&ar.height===b){ar[at.dim]=at[at.dim]}aH.dimFit=at;aH.srcArea=aB;aH.srcAreaFloat=aD;aH.url=n.getImageURL(ax,ar);return aH};this.getImageInfoURL=function(at,ar){if(at===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="info"}if(ar.tpl===b){if(n.cfg.fpxinfotemplate!==b){ar.tpl=n.cfg.fpxinfotemplate}else{ar.tpl="info.json"}}if(n.cfg.headers&&n.cfg.headers.length>0){ar.headers=n.cfg.headers}if(!ar.tpl.match(/.json$/)){ar.tpl+=".json"}ar.source=at;if(w){ar[v]=w}return n.requestBase+"?"+n.objectToQuery(ar)};this.queryToObject=function(aw,au){if(au===b){au={}}var av,ay,ax,ar,at;av=aw.indexOf("?");if(av!==-1){at=aw.slice(av+1)}else{at=""}av=at.indexOf("#");if(av!==-1){at=at.substring(0,av)}at=at.split("&");for(av=0;av<at.length;av++){ay=at[av].split("=");ax=decodeURIComponent(ay[0]).toLowerCase();if(ax.length>0){ar=decodeURIComponent(ay[1]);au[ax]=ar}}return au};this.parseSceneSets=function(ar,aw){var aD={};if(aw===b){aw=true}var aI=[];var aG=0;var aE=0;var au;var ay,ax,av,aC,aA,aH;var az,aB,aF;var at=n.cfg.scenesets;if(ar>1&&at!==b&&typeof(at)==="string"){aB=at.split(";");for(ay=0;ay<aB.length;ay++){aF=[];az=aB[ay].split(",");aE=0;for(ax=0;ax<az.length;ax++){aH=az[ax].split("-");aC=aA=0;if(aH.length===1){aC=parseInt(aH[0])}else{aC=parseInt(aH[0]);if(isNaN(aC)){aC=1}au=false;if(aH[1].charAt(0)===">"){aH[1]=aH[1].substr(1);if(!isNaN(parseInt(aH[1]))){au=true}}aA=parseInt(aH[1]);if(isNaN(aA)){aA=ar}if(aC>0&&aA>0&&aC<=ar&&aA<=ar){if(au===true||aC!==aA){if(au!==true){if(aA<aC){for(av=aC;av>=aA;av--){aF[aE]=av;aE++}}else{for(av=aC;av<=aA;av++){aF[aE]=av;aE++}}}else{for(av=aC;av<=ar;av++){aF[aE]=av;aE++}for(av=1;av<=aA;av++){aF[aE]=av;aE++}}}}}if(aC>0&&aC<=ar&&(aA===0||aA===aC)){aF[aE]=aC;aE++}}if(aE>0){aI[aG]={};aI[aG].arScenes=[];aI[aG].arScenes=aI[aG].arScenes.concat(aF);aG++}}}if(aG===0){aD.bDefault=true;if(aw){aI[0]={};aI[0].arScenes=[];for(ay=0;ay<ar;ay++){aI[0][ay]=ay}}}aD.nSceneSets=aG;aD.bHasMultipleSets=(aD.nSceneSets>1);aD.arSets=aI;aD.nCurrent=1;return aD};this.objectToQuery=function(au){var at=[];var aw,av;if(Z&&D!==false){for(aw in y){if(y.hasOwnProperty(aw)){au[aw]=y[aw]}}}for(aw in au){if(au.hasOwnProperty(aw)){av=au[aw];if(av!==null&&av!==b){av=encodeURIComponent(av);at.push(encodeURIComponent(aw)+"="+av)}}}return at.join("&")};this.loadImageInfo=function(av,ar,au){if(typeof(av)!=="string"||av.length<1){if(ar){ar(null,"",au)}}else{var at=n.getImageInfoURL(av);n.loadFile(at,ar,b,au)}};this.loadFile=function(aw,av,au,aA,az,at,ax){if(!aw||aw.length<0){if(av){setTimeout(function(){av(null,"",aA)},0)}return}if(az===b){az="GET"}if(at===b){at=null}else{if(typeof(at)==="object"){at=n.objectToQuery(at)}}if(au===b){au="application/json"}var ay=p(aw);if(au&&ay.overrideMimeType){ay.overrideMimeType(au)}ay._url=aw;var ar=B;O[B]=ay;B++;if(aq){ay.onerror=function(){delete O[ar];if(av===b||this.FSIaborted){return}n.logLoadFileFailed(this)};ay.onload=function(){delete O[ar];if(av===b||this.FSIaborted){return}var aB=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var aC=new ActiveXObject("Microsoft.XMLDOM");aC.async=false;aC.loadXML(aB);aB=this.responseXML=aC}catch(aD){H.log("Failed parsing XML using Microsoft.XMLDOM");H.log(aw)}break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aD){H.error("Failed parsing JSON from URL: "+aw+" ("+aD.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}else{ay.onreadystatechange=function(){var aB;if(ay.readyState!==4){return}delete O[ar];if(this.FSIaborted||typeof(av)!=="function"){return}if(this.status>299){n.logLoadFileFailed(this)}switch(au){case"application/xml":case"text/xml":aB=this.responseXML;break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aC){H.error("Failed parsing JSON from URL: "+aw+" ("+aC.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}ay.open(az,aw,true);if(ax&&w){ay.setRequestHeader("data-token",w)}if(at){ay.setRequestHeader("Content-type","application/x-www-form-urlencoded");ay.send(at)}else{ay.send()}return ay};this.loadConfigs=function(){ag=(t.length>0)?{}:false;g=true;n.loadNextConfig(true)};this.loadNextConfig=function(at){if(n.nextConfigURL===b){X();return}var au={};if(f.bPreventCaching||n.makeBool(n.cfg.debug)||(!at&&!n.makeBool(n.cfg.configcaching,true)&&n.makeBool(n.cfg.enableconfigcachingparameter))){n.addNoCacheParams(au)}n.finishRequestParams(au);var ar=n.addURLParameters(n.nextConfigURL,au);H.log("Loading config file: "+ar);n.loadFile(ar,E,"application/xml")};this.setDebugger=function(ar){H=n.debug=ar};this.checkDebug=function(au){if(f.bNoDebug){return}var at;var ar;if(n.parameters.debug!==b){ar=n.makeBool(n.parameters.debug)}else{ar=n.makeBool(n.cfg.debug)}if(ar){if(!H||!H.on){H=n.debug=new a.Debugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}else{if(!H||H.on===true){H=n.debug=new a.EmptyDebugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}return at};var E=function(ar){var au=ar.responseXML;m=n.nextConfigURL;n.parseConfig(au);m=b;n.elevateToHTTPS();if(n.checkDebug(true)===true){return}e();if(g&&f.bCaptureDefaultCfg){g=false;n.cfgFromDefaultConfig=a.utils.cloneValue(n.cfg)}var at;if(n.cfg.includeconfig!==b&&n.nIncludedConfigs<10){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.includeconfig));n.nIncludedConfigs++;n.cfg["_includeconfig("+n.nIncludedConfigs+")"]=n.cfg.includeconfig;n.cfg.includeconfig=b}else{if(n.cfg.cfg!==b){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.cfg))}}if(at!==b&&!n.completedConfigs[at]){n.completedConfigs[at]=true;n.nextConfigURL=at;n.loadNextConfig()}else{n.evaluateQuery(n.queryParameters,n.cfg);X()}};this.evaluateXML=function(ar){m="XML Object";n.parseConfig(ar);m=b;n.elevateToHTTPS();e();n.evaluateQuery(n.queryParameters,n.cfg);X()};this.elevateToHTTPS=function(){if(!a.utils.isHTTPS()){return}if(!n.makeBool(n.cfg.autoelevatetohttps,true)){return}i("fpxbase");i("fpxserver")};var i=function(ar){if(n.cfg[ar]!==b&&n.cfg[ar].length>0&&n.cfg[ar].indexOf("http://")===0){n.cfg[ar]="https"+n.cfg[ar].substr(4)}};this.evaluateQuery=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){n.setConfigParamByValue(ar,au.toLowerCase(),at[au])}}};this.parseConfig=function(at,au){var aD="";var ax;var az=false;if(at&&typeof(at)==="object"){if(au===b){au=at.firstChild}if(au&&au.nodeName==="xml"){au=au.nextSibling}var aC=au.childNodes;for(var ay=0;ay<aC.length;ay++){var aw=aC[ay];if(aw.nodeType!==1){continue}var aA;if(aw._myTagName!==b){aA=aw._myTagName}else{aA=aw.nodeName.toLowerCase()}aD=aA;var av=aw.childNodes;az=false;switch(aA){case"licence":break;case"if":n.arConditions.push(aw);break;case"plugins":for(ax=0;ax<av.length;ax++){n.parsePluginNode(av[ax])}break;case L:az=true;case"info":case"options":aD=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(ax=0;ax<av.length;ax++){var aB=av[ax];if(aB.nodeType!==1){continue}if(aB.tagName==="if"){aB._myTagName=aA;n.arConditions.push(aB)}else{var ar=n.getValueFromXMLNode(aB,aD);if(aD===b&&ag){if(az){n.setConfigParam(ag,ar,null,true);n.setConfigParam(n.cfg,ar,aB)}else{if(ag[ar.name]===b){n.setConfigParam(n.cfg,ar,aB)}}}else{n.setConfigParam(n.cfg,ar,aB)}}}break;default:n.arUnrecognizedConfigNodes.push(aw)}}}};this.getData=function(){var ar={};ar.cfg={};for(var at in n.cfg){if(n.cfg.hasOwnProperty(at)){ar.cfg[at]=n.cfg[at]}}return ar};this.setData=function(ar){if(!ar||!ar.cfg){return}n.cfg={};this.setCfgValues(ar.cfg)};this.setCfgValues=function(at){for(var au in at){if(at.hasOwnProperty(au)){var ar=au.toLowerCase();if(n.cfgAliasNames[ar]){ar=n.cfgAliasNames[ar]}if(K.nItems){if(K.bPositive){if(!K.params[ar]){continue}}else{if(K.params[ar]){continue}}}n.cfg[ar]=at[au]}}W()};this.getImagesNodeList=function(au){var ar=[];if(au===b){au=n.getUnrecognizedConfigNode("images")}if(au){var av=au.firstChild;while(av){if(av.nodeType===1){var at={};at.attributes={};N(av,at.attributes);at.cfg={};n.parseConfigFragment(av,at.cfg);ar.push(at)}av=av.nextSibling}}return ar};this.removeUnrecognizedConfigNodes=function(){n.arUnrecognizedConfigNodes=[]};this.setUnrecognizedConfigNode=function(aw,au){var ar;aw=aw.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var av=n.arUnrecognizedConfigNodes[at];if(av&&av.nodeName.toLowerCase()===aw){ar=av;break}}if(!ar){if(au!==null){n.arUnrecognizedConfigNodes.push(au)}}else{if(au===null){n.arUnrecognizedConfigNodes.slice(at,1)}else{n.arUnrecognizedConfigNodes[at]=au}}return ar};this.getUnrecognizedConfigNode=function(av){var ar;av=av.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var au=n.arUnrecognizedConfigNodes[at];if(au&&au.nodeName.toLowerCase()===av){ar=au;break}}return ar};this.parseConfigFragment=function(at,az,ay){var aD="";if(at&&typeof(at)==="object"&&az!==b){if(ay===b){ay=[]}var aC=at.childNodes;for(var ax=0;ax<aC.length;ax++){var av=aC[ax];if(av.nodeType!==1){continue}var aA=av.nodeName.toLowerCase();aD=aA;var au=av.childNodes;switch(aA){case"info":case"options":aD=b;case"fpx":case"image":case"include":for(var aw=0;aw<au.length;aw++){var aB=au[aw];if(aB.nodeType!==1){continue}var ar=n.getValueFromXMLNode(aB,aD);n.setConfigParam(az,ar,aB)}break;default:ay.push(av)}}}};this.findXMLNode=function(at,ar){if(at===b||at.nodeType===b){return b}while(at){if(at.nodeName.toLowerCase()===ar){break}if(at.firstChild){at=at.firstChild}else{if(at.nextSibling){at=at.nextSibling}else{at=at.parentNode.nextSibling}}}return at};this.getValueFromXMLNode=function(au,ar){if(!au||au.nodeType!==1){return}var at={};var av=(ar)?ar:"";at.name=av+au.nodeName.toLowerCase();var aw=au.getAttribute("value");if(aw){at.value=aw;return at}at.value=n.XMLChildNodesToString(au);at.node=au;return at};this.getXMLNodeAttribute=function(av,au,ar){if(!av||av.nodeType!==1||!av.getAttribute){return ar}var at=av.getAttribute(au);if(at===b||at==null){at=ar}return at};this.XMLChildNodesToString=function(au,at){var ar="";if(!au||!au.firstChild){return ar}if(au.childNodes.length===1&&au.firstChild.nodeType===3){ar=au.firstChild.nodeValue}else{ar=au.innerHTML}if(at!==b){ar=ar.replace(/[\x00-\x1f]/g,at)}return ar};this.hasPlugin=function(ar){return(n.plugins&&n.plugins[ar]!==b)};this.getPluginParameter=function(ay,at,ar,ax,az){ay=ay.toLowerCase();at=at.toLowerCase();if(n.plugins[ay]===b){H.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+ay+"."+at);return ar}var aw;var av=ay+"_"+at;if(az&&n.cfg[av]===b){av=at}if(n.cfg[av]!==b){aw=n.cfg[av]}else{if(ag&&ag[at]!==b&&L==="pages"){aw=ag[at]}else{var au=n.plugins[ay].parameters;if(au!==b&&au[at]!==b){aw=au[at]}}}if(aw===b){aw=ar}if(ax){aw=n.makeBool(aw,ar)}return aw};var R=this.getAllPluginParameters=function(at){at=at.toLowerCase();var au=a.utils.cloneObject(n.plugins[at].parameters);var aw=at+"_";var ar=aw.length;for(var ax in n.cfg){if(n.cfg.hasOwnProperty(ax)){if(ax.toLowerCase().indexOf(aw)===0){var av=ax.substr(ar);au[av]=n.cfg[ax]}}}return au};this.getIntParameterMinMax=function(at,au,ar,av){return Math.min(av,Math.max(ar,n.getIntParameter(at,au)))};this.getIntParameter=function(at,au){var ar=parseInt(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};this.getStringParameter=function(at,au){var ar=n.cfg[at.toLowerCase()];if(ar===b){ar=au}return ar};this.getFloatParameter=function(at,au){var ar=parseFloat(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};var N=function(ax,at){if(!ax||!ax.attributes||!ax.attributes.length||!at){return false}var au=ax.attributes;for(var aw=0;aw<au.length;aw++){var ar=au[aw];var av=ar.nodeName.toLowerCase();at[av]=ar.value}return true};this.parsePluginNode=function(au){if(au.nodeType!==1){return}var aw={};N(au,aw);var av=au.childNodes;for(var ar=0;ar<av.length;ar++){var ax=av[ar];if(ax.nodeType!==1){continue}var at=n.getValueFromXMLNode(ax);if(at.value!==b){aw[at.name]=at.value;if(at.node!==b){aw[at.name+".node"]=at.node}}}this.addPluginFromString(aw.src,aw)};this.clone=function(){var ar=new a.Config(al,x,f);ar.init();ar.setParameterFilter(K);ar.serverBase=n.serverBase;ar.requestBase=n.requestBase;ar.cfg=a.utils.cloneObject(n.cfg);ar.plugins=a.utils.cloneObject(n.plugins);ar.arPlugins=a.utils.cloneArray(ar.arPlugins);ar.arUnrecognizedConfigNodes=a.utils.cloneArray(n.arUnrecognizedConfigNodes);ar.arUnrecognizedConfigNodesWithoutDefault=a.utils.cloneArray(n.arUnrecognizedConfigNodesWithoutDefault);ar.setImageQueryParameters(ad);ar.arConditions=a.utils.cloneArray(n.arConditions);ar.hasImageParameterConditions=n.hasImageParameterConditions;return ar};this.setImageQueryParameters=function(ar){ad=a.utils.cloneObject(ar)};this.getImageQueryParameters=function(){return a.utils.cloneObject(ad)};this.addPluginsFromString=function(au){if(typeof(au)!=="string"||au.length<1){return}var ar=au.split(",");for(var at=0;at<ar.length;at++){var av=a.trim(ar[at]);n.addPluginFromString(av)}};this.addPluginFromString=function(av,aw){if(typeof(av)!=="string"||av.length<1){H.error("PLUGIN without src parameter:");return}av=av.toLowerCase();if(T[av]!==b){av=T[av]}if(aw===b){aw={}}var at=n.plugins[av]={};at.name=av;if(aw.src===b){aw.src=av}at.parameters=aw;if(c){for(var ax in c){if(c.hasOwnProperty(ax)){if(ax.indexOf(av+"_")===0){var au=av+"_";var ar=ax.substr(au.length);if(typeof(at.parameters[ar])!=="undefined"){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log(at.parameters[ar]);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}else{if(ax===av){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log("(enabled)");n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}}};this.setConfigParamByValue=function(at,au,ar){n.setConfigParam(at,{name:au.toLowerCase(),value:ar})};var V=function(at){if(at.nodeType!==1){return"<unknown>"}var ar=n.XMLSerializer.serializeToString(at.cloneNode(false));ar=ar.replace(/\/>$/gi,">");return ar};this.setParameterFilter=function(at,ar){if(at===b){if(K.nItems){K={}}return}if(typeof(at)==="string"){K=n.getParameterFilterFromString(at,ar)}else{if(typeof(at)==="object"){K=a.utils.cloneObject(at)}}};this.getParameterFilterFromString=function(ay,at){var av={bPositive:at,nItems:0,params:{}};var az=av.params;var au=ay.split(",");for(var ax=0;ax<au.length;ax++){var aw=a.trim(au[ax]).toLowerCase();if(aw.length>0){az[aw]=true;av.nItems++}}return av};this.getParameterFilter=function(){return a.utils.cloneObject(K)};this.setConfigParam=function(av,ar,aw,ax){var az=ar.name;var aB=ar.value;if(!az){return}if(c){for(var aA in c){if(aA===az&&!ax){if(typeof(aw)==="object"&&typeof(aw.tagName)==="string"){var ay;if(m){ay=m}var au=aw.parentNode;var at=[];while(au){if(au.tagName==="if"){ay="Matched Condition"}at.unshift(V(au));au=au.parentNode}at.shift();at.shift();n.iTraceParameterDebug.group(ay);n.iTraceParameterDebug.log(at.join(" "));n.iTraceParameterDebug.log(aw);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}else{n.iTraceParameterDebug.group("By Parameter/Attribute:");n.iTraceParameterDebug.log(aB);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}if(n.cfgAliasNames[az]!==b){az=n.cfgAliasNames[az]}if(K.nItems){if(K.bPositive){if(!K.params[az]){return}}else{if(K.params[az]){return}}}if(av[az]!==b&&(typeof(aB)==="string"&&a.utils.getBoolTable(aB.toLowerCase())===false)&&a.utils.getBoolTable(av[az])===b){delete av[az]}else{switch(az){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":aB=a.trim(aB);n.appendImageEffect(av,az,aB);break;case"plugins":n.addPluginsFromString(aB);break;case"fpxpath":av[az]=aB;av.fpxsrc=encodeURIComponent(aB);break;default:av[az]=aB;if(ar.node!==b){av[az+".node"]=ar.node}}}};this.appendImageEffect=function(au,at,ar){if(typeof(ar)!=="string"){return}if(ar.match(/^ClearEffects\(\)*/i)){ar=ar.replace(/^ClearEffects\(\)\s*[,]?\s*/i,"");au[at]=b}if(ar.length>0){if(au[at]!==b&&au[at].length>0){au[at]+=","+ar;au[at]=au[at].replace(/,,/g,",")}else{au[at]=ar}}};var l={};l["="]=function(at,ar){return(at.toLowerCase()===ar.toLowerCase())};l["=="]=function(at,ar){return(at===ar)};l["!="]=function(at,ar){return(at.toLowerCase()!==ar.toLowerCase())};l["!=="]=function(at,ar){return(at!==ar)};l["<"]=function(at,ar){return(at<ar)};l["<="]=function(at,ar){return(at<=ar)};l[">"]=function(at,ar){return(at>ar)};l[">="]=function(at,ar){return(at>=ar)};l.match=function(at,ar){var au=false;var aw="g";if(ar.charAt(0)==="/"&&ar.lastIndexOf("/")>0){var av=ar.split("/");av.shift();aw=av.pop();ar=av.join("/")}try{var ax=new RegExp(ar,aw);au=(at.match(ax)!==null)}catch(ay){H.error("Invalid regex in condition: "+ar)}return au};l.notmatch=function(at,ar){return !l.match(at,ar)};var s={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var u=function(at,au){if(n.cfgAliasNames[au]){au=n.cfgAliasNames[au]}var ar=n.cfg[au];if(ar===b){ar=""}if(!n.hasImageParameterConditions){n.hasImageParameterConditions=(ab[au]!==b)}return G(at,au,ar)};var M=function(av,aw){var ar=false;var au;var at=av.getAttribute("value");switch(aw){case"@mobile":at=n.makeBool(at,true);au=a.isMobileDevice;break;case"@devicepixelratio":au=a.getDevicePixelRatio();break;case"@navigatoruseragent":au=navigator.userAgent;break;case"@navigatorlanguage":au=navigator.language;break;case"@navigatorplatform":au=navigator.platform;break}if(au!==b){if(typeof(at)!=="string"){at=""+at}if(typeof(au)!=="string"){au=""+au}ar=G(av,aw,au,at)}return ar};var G=function(av,au,ax,aw){var az;var at=av.getAttribute("operator");if(typeof(at)!=="string"){at="="}at=at.toLowerCase();if(s[at]){at=s[at]}if(l[at]===b){at="="}if(aw===b){aw=av.getAttribute("value")}if(aw===null){aw=""}var ar=l[at];if(at.match(/[<,>]+/)){var aA=function(aB){aB=parseFloat(aB);if(isNaN(aB)){az=false}return aB};ax=aA(ax);aw=aA(aw)}else{ax=decodeURIComponent(ax)}if(az===b){az=ar(ax,aw)}if(H.on){H.log("Evaluating condition: "+au+": "+ax+" "+at+" "+aw+" => "+az)}if(az===true){if(av._myTagName!==b){var ay={};ay.nodeType=1;ay.tagName=av._myTagName;ay.childNodes=[av];av=ay}n.parseConfig(av,av)}return az};var ab={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var ac={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi",overlays:"overlays"};var aa;var U=function(){if(aa===b){aa={};for(var ar in ab){aa[ab[ar]]=ar}}return aa};var q=function(aw,av,au){if(au===b){au=""}var ay=au+"left";if(aw[ay]===b){return}var ax=au+"top";var at=au+"right";var ar=au+"bottom";if(av==="pixelrange"){aw[at]=aw[at]-aw[ay];aw[ar]=aw[ar]-aw[ax]}aw[av]=aw[ay]+","+aw[ax]+","+aw[at]+","+aw[ar];if(aw[ay]){delete aw[ay]}if(aw[ax]){delete aw[ax]}if(aw[at]){delete aw[at]}if(aw[ar]){delete aw[ar]}};var ao=this.mapImageParametersToViewer=function(ar){q(ar,"rect");q(ar,"pixelrange","pixel");U();ai(ar,U())};var an=this.mapImageParametersToServer=function(ar){ai(ar,ab)};var ai=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){if(ar[au]&&au!==ar[au]){at[ar[au]]=at[au];delete at[au]}}}};this.reWriteImageURLByConditions=function(ay){if(n.arConditions.length<1){return ay}if(typeof(ay)!=="string"||ay.length<1){return ay}var au=ay.indexOf("?");if(au===-1){return ay}var at=n.clone();var aw={};n.parseQuery(ay,aw);ao(aw);n.evaluateQuery(aw,at.cfg);var ar=at.evaluateConditions();if(!ar){return ay}var ax;for(ax in aw){if(aw.hasOwnProperty(ax)){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}}for(ax in ac){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}an(aw);var av=ay.substr(0,au);return av+"?"+n.objectToQuery(aw)};var o=this.applyConditions=function(){if(n.arConditions.length<1){return}if(n.cfgBeforeConditions===b){n.cfgBeforeConditions=a.utils.cloneObject(n.cfg)}n.cfg=n.cfgBeforeConditions;return h()};var am=0;var h=this.evaluateConditions=function(){if(n.arConditions.length<1){return false}var at=false;for(var au=am;au<n.arConditions.length;au++){var av=n.arConditions[au];if(av.fsiConfigEvaluated){continue}am++;var aw=av.getAttribute("parameter");if(typeof(aw)==="string"){aw=aw.toLowerCase();var ar;if(aw.charAt(0)==="@"){ar=M(av,aw)}else{ar=u(av,aw)}if(!at&&ar){at=ar}}}return at};var W=function(){o();n.serverProfile=n.cfg.fpxservertemplate;n.serverProfileDoublePage=n.cfg.fpxservertemplatedoublepage;if(n.serverProfileDoublePage===b){n.serverProfileDoublePage="doublepage"}n.serverBase=n.cfg.fpxserver;if(n.serverBase===b){H.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+n.locationFSIViewer+")");var at;at=n.locationFSIViewer.indexOf("/users/");if(at!==-1){n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}else{at=n.locationFSIViewer.indexOf("/viewer/");n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}H.log("Derived server location is: ["+n.serverBase+"]")}n.requestBase=n.serverBase;ad={};var ar=n.cfg;for(var au in ac){if(ar[au]!==b){ad[au]=ar[au]}}if(ad.fpxsrc!==b){ad.fpxsrc=decodeURIComponent(ad.fpxsrc)}ar=n.cfg.effects;if(ar!==b){n.cfg.effectsUnFiltered=ar;n.cfg.effects=ar=k(ar)}if(ar!==b){ad.effects=ar}ar=n.cfg.lefteffects;if(ar!==b){ad.lefteffects=ar}ar=n.cfg.righteffects;if(ar!==b){ad.righteffects=ar}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){n.setEffectsFilter(n.getAreaEffects())};this.setEffectsFilter=function(aw){if(typeof(aw)!=="string"||aw.length<1){Y=false;return}aw=a.trim(aw);var au=aw.split(",");for(var av=0;av<au.length;av++){au[av]=a.escapeRegEx(au[av])}var at="(^|[=,]+)("+au.join("|")+")\\([^)]*\\)";Y=new RegExp(at,"ig")};var k=this.removeFilteredEffects=function(ar){if(Y===false||typeof(ar)!=="string"){return ar}ar=ar.replace(Y,"");ar=ar.replace(/^[,\s]*/g,"");ar=a.trim(ar);return ar};var j=function(){for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){var au=at.toLowerCase();var ar=n.makeBool(n.cfg[au],true);if(!ar){n.plugins[at]=b}}}};var X=function(){n.elevateToHTTPS();j();W();n.dumpConfig();if(x.onConfigsReady){x.onConfigsReady()}};this.dumpConfig=function(au){if(!au){au=H}if(au.on){if(n.cfg.fpxsrc!==b){n.cfg["fpxsrc (decoded)"]=decodeURIComponent(n.cfg.fpxsrc)}au.info("Evaluated Configuration:",Q(n.cfg));if(n.queryParameters){au.info("Parameters:",Q(n.queryParameters))}if(ag){au.info("Class <"+t+"> Configuration:",Q(ag))}var at=n.getPluginsAndParameters();var ar=at.data;if(at.count===0){ar="No active plugins."}au.info("Plugin Configuration:",Q(ar))}};var Q=function(au){var ar="--- none ---";if(typeof(au)!=="object"){return ar}for(var at in au){if(au.hasOwnProperty(at)){ar=au;break}}return ar};this.getPluginsAndParameters=function(){var ar={};var au=0;for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){if(n.hasPlugin(at)){ar[at]=R(at);au++}}}return{count:au,data:ar}};var J=this.addQueryParameterToURL=function(av,ar,au){var at=av.lastIndexOf("?");if(at===-1){av+="?"}else{if(at!==av.length-1){av+="&"}}return av+encodeURIComponent(ar)+"="+encodeURIComponent(au)};var ap=n.finishURL=function(ar){if(w){ar=J(ar,v,w)}if(!Z||ar===b){return ar}var at;if(D===false){at="cache=0&cachernd="+r;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+="&"+at}}else{at=D;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+=at}}return ar};this.addURLParameters=function(au,av){if(!au||!av){return au}var at=[];for(var aw in av){if(av.hasOwnProperty(aw)){at.push(encodeURIComponent(aw)+"="+encodeURIComponent(av[aw]))}}if(at.length>0){if(au.indexOf("?")===-1){au+="?"}else{au+="&"}au+=at.join("&")}return au};this.finishRequestParams=function(at){if(Z){if(D===false){at.cache=0;at.cachernd=r}else{for(var ar in y){if(y.hasOwnProperty(ar)){at[ar]=y[ar]}}}}};this.addNoCacheParams=function(ar){ar.cache=0;ar.cachernd=r};this.parseQuery=function(at,ar){if(typeof(ar)!=="object"||typeof(at)!=="string"||at.length<1){return}n.queryToObject(at,ar);if(ar.ignorequeryparameters!==b){delete ar.ignorequeryparameters}if(ar.enableconfigcachingparameter!==b){delete ar.enableconfigcachingparameter}};this.cloneParameters=function(ar,at){if(!ar||!at||typeof(ar)!=="object"||typeof(at)!=="object"){H.error("Cloning object failed: "+ar+" / "+at)}for(var au in ar){if(ar.hasOwnProperty(au)){at[au]=ar[au]}}};this.getFSIPath=function(ar,at){if(typeof(at)!=="string"){at=""}if(at.indexOf("//")!==-1){return at}if(n.cfg.fsibase!==b){at=n.cfg.fsibase+at}return n.getReloadPath(ar,at)};this.expandFSIPath=function(at){if(typeof(at)!=="string"){return at}var ar=decodeURIComponent(at);if(ar.indexOf("?")!==-1||ar.indexOf(".xml")===(ar.length-4)){return at}return at+".xml"};this.getReloadPath=function(av,ax){var at,ay,ar,aw;if(av===b){av=n.locationFSIViewer}if(typeof(ax)!=="string"){ax=""}var au="/";if(ax.indexOf("//")!==-1){return ax}at=av;aw=at.lastIndexOf("?");if(aw===-1){aw=at.length}ay=at.lastIndexOf("\\",aw);ar=at.lastIndexOf("/",aw);ay=Math.max(ay,ar);if(ay===-1){ay=at.length-1}at=at.slice(0,ay);if(at.length>0&&ax.indexOf(au)!==0){at+=au}return at+ax};var C=function(ar){var at;if(!ar){return}if(ar.childNodes.length>0){at=ar.innerHTML}else{at=ar.getAttribute("value")}return at};var I=function(au,aw){var at,ar;var av=0;while(au){if(au.nodeType===1&&au.nodeName.toLowerCase()===aw){ar=au;break}at=au.firstChild;if(!at){at=au.nextSibling}else{av++}if(!at&&av>0&&au.parentNode){at=au.parentNode.nextSibling;av--}au=at}return ar};var S=function(aO,at){var ay;var aK;if(at===b){at=0}var aL={};var aJ=aL.arImages=[];var aC=aL.arConfigs=[];var aM=aL.arNodes=[];var aw=aL.arImageLists=[];var aB="";var aP="";var aI;var ax;var aH={};if(at===0&&(n.cfg.imagelistparameterfilterpositive||n.cfg.imagelistparameterfilternegative)){n.getParameterFilter();n.cloneParameters(K,aH);if(n.cfg.imagelistparameterfilterpositive){n.setParameterFilter(n.cfg.imagelistparameterfilterpositive,true)}else{if(n.cfg.imagelistparameterfilternegative){n.setParameterFilter(n.cfg.imagelistparameterfilternegative,false)}}}var aG=function(ar){aJ.push(ar);aM.push(aO);if(at===0){aC.push(aI);aw.push(ax)}};var aF;if(!aO){return aL}var aU;aU=n.getAttributeValue(aO,"prefix");if(typeof(aU)==="string"){aB=aU}aU=n.getAttributeValue(aO,"suffix");if(typeof(aU)==="string"){aP=aU}var av=n.getAttributeValue(aO,"from");var aE=n.getAttributeValue(aO,"to");var aT,au;if(typeof(av)==="string"&&typeof(aE)==="string"){aT=parseInt(av);au=parseInt(aE);if(!isNaN(aT)&&!isNaN(au)&&aT<=au&&(au-aT)<512){}else{aT=au=b}}if(aT!==b){ax=aI=b;var aS;var aN=av.length;var aR=aE.length;if(aN===aR){aS=aN}for(var aQ=aT;aQ<=au;aQ++){aK=""+aQ;if(aS){while(aK.length<aS){aK="0"+aK}}if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}}else{aO=I(aO,"image");var az;if(!aO){return aL}while(aO){az=true;if(aO.nodeType===1&&aO.nodeName.toLowerCase()==="image"){ax=aI=b;if(at===0){aI=n.clone();aI.getImageQueryParameters();aI.arUnrecognizedConfigNodes=[];aI.parseConfig(aO,aO);aI.setCfgValues({});aI.checkDebug();if(aI.debug&&aI.debug.on){aI.debug.group("Sub Config #"+aJ.length+" from image list:");aI.dumpConfig();aI.debug.groupEnd()}aI.serverBase=n.serverBase;aI.requestBase=n.requestBase;ax=aI.getImageList(at+1);if(ax&&ax.arImages.length>0){az=false;var aD=aI.parseSceneSets(ax.arImages.length,true);var aV=n.viewStringToArray(aI.cfg.initialview);var aA=aD.arSets[aV[0]-1][aV[1]-1];if(aA===b){aA=0}aG(ax.arImages[aA])}}if(az){ax=aI=b;aF=I(aO,"path");aK=C(aF);if(!aK){aK=decodeURIComponent(n.getAttributeValue(aO,"src"))}if(!aK){aK=decodeURIComponent(n.getAttributeValue(aO,"file"))}if(aK!==b){if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}if(aL.width===b){aF=I(aO,"width");aF=C(aF);if(aF!==b){aL.width=parseInt(aF)}aF=I(aO,"height");aF=C(aF);if(aF!==b){aL.height=parseInt(aF)}}}}aO=aO.nextSibling}}if(aH){n.setParameterFilter(aH)}return aL};this.getImageList=function(au){var aA,ay,av;A();if(!n.makeBool(n.cfg.ignoreimagelists)){if(n.cfg&&n.cfg.fpxsources!==b){var az=n.cfg.fpxsources;if(typeof(az)==="string"||(typeof(az)==="object")&&typeof(az.push)==="function"){aA={};aA.oXML=null;if(typeof(az)==="string"){if(ae===false){aA.arImages=az.split(",");for(ay=0;ay<aA.arImages.length;ay++){aA.arImages[ay]=decodeURIComponent(aA.arImages[ay])}}else{var ax=az.split(",");aA.arImages=[];for(ay=0;ay<ax.length;ay++){av=decodeURIComponent(ax[ay]);if(ae(av)){aA.arImages.push(av)}}}}else{aA.arImages=az}}}if(!aA&&n.arUnrecognizedConfigNodes&&n.arUnrecognizedConfigNodes.length>0){var aB=n.arUnrecognizedConfigNodes;for(ay=0;ay<aB.length;ay++){var aw=aB[ay];if(typeof(aw.nodeName)==="string"){var at=aw.nodeName.toLowerCase();if(at==="images"||at==="images3d"){if(H.on){H.log("Reading image list from XML node: <"+aw.nodeName+">")}aA=S(aw,au);aA.oXML=aw;break}}}}}if(!aA&&n.cfg&&n.cfg.fpxsrc!==b){aA={};aA.oXML=null;if(ae===false){aA.arImages=[decodeURIComponent(n.cfg.fpxsrc)]}else{av=decodeURIComponent(n.cfg.fpxsrc);if(ae(av)){aA.arImages=[av]}}}return aA};this.fillViewString=function(aw){if(typeof(aw)!=="string"){aw=""}var au=[1,1,0,0,1,1,0];var at=aw.split(",");if(at.length===2){return aw+",0,0,1,1,0"}if(at.length===6){return aw+",0"}if(at.length===7){return aw}for(var av=at.length;av<7;av++){at.push(au[av])}return at.join(",")};this.viewStringToArray=function(au){var av=function(ay,ax){var ar=parseFloat(ay);if(isNaN(ar)){ar=ax}return ar};var aw=function(ay,ax){var ar=parseInt(ay);if(isNaN(ar)){ar=ax}return ar};au=n.fillViewString(au);var at=au.split(",");at[0]=aw(at[0],1);at[1]=aw(at[1],1);at[2]=av(at[2],0);at[3]=av(at[3],0);at[4]=av(at[4],1);at[5]=av(at[5],1);at[6]=av(at[6],0);return at};this.getServerBase=function(){return n.serverBase};this.loadImageList=function(aw,ax,az,ay){if(!n.serverBase||!aw){ax([],b,ay);return false}A();var av=n.serverBase+"?type=list";if(!aw.match(aj)){var au=n.cfg.listtemplate;if(au&&au.length>0&&!au.match(af)&&!au.match(d)){au+=".json"}av+="&tpl="+au}if(n.cfg.headers&&n.cfg.headers.length>0&&y.headers===b){av+="&headers="+n.cfg.headers}if(typeof(n.cfg.imagelistlimit)==="string"&&n.cfg.imagelistlimit.length>0){av+="&limit="+encodeURIComponent(n.cfg.imagelistlimit)}if(n.cfg.imagelistsort!==b){H.log("Sorting image list by: "+n.cfg.imagelistsort);av+="&sort="+n.cfg.imagelistsort}if(typeof(n.cfg.imagelistsortorder)==="string"){var at=n.cfg.imagelistsortorder.toLowerCase();if(at==="asc"||at==="desc"){H.log("Image list sort order: "+at);av+="&sortorder="+at}}av+="&source="+encodeURIComponent(aw);if(az!==b){av+=az}av=ap(av);var ar=n.loadFile(av,function(aA,aE){if(typeof(aE)==="object"&&typeof(aE.images)==="object"){aE.images.pop();var aF="";if(aE&&aE.imagesattributes&&aE.imagesattributes.dir){aF=aE.imagesattributes.dir}var aB,aD;if(ae===false){aB=new Array(aE.images.length);for(aD=0;aD<aE.images.length;aD++){aB[aD]=aF+aE.images[aD].src}}else{aB=[];for(aD=aE.images.length-1;aD>-1;aD--){var aC=aF+aE.images[aD].src;if(ah(aC)){aB.push(aC)}else{aE.images.splice(aD,1)}}aB.reverse()}ax(aB,aE,ay)}else{ax([],aE,ay)}},"application/json",ay);return ar};var ah=function(at){if(typeof(at)!=="string"){return 1}var ar=1;if(P!==b){if(!at.match(P)){ar=0}}if(ar===1&&z!==b){if(at.match(z)){ar=0}}return ar};var ae=true;var P,z;var F=function(aw){var au;var ay=n.cfg[aw.toLowerCase()];if(!ay||typeof(ay)!=="string"||ay.length<1){return}var ar=/\/([^/]*)$/;try{var av=ay.match(ar);if(av&&av.length>1){var at=av[1];ay=ay.replace(ar,"");ay=ay.replace(/^\//,"")}au=new RegExp(ay,at)}catch(ax){H.error("Invalid Regular Expression "+ay+" in parameter "+aw);H.error(ax.message);au=b}return au};var A=function(){P=F("ListFilterPositive");z=F("ListFilterNegative");if(P===b&&z===b){ae=false}else{ae=ah}};this.traceConfigValue=function(ar,av){if(typeof(ar)!=="string"){return false}ar=a.trim(ar);if(ar.length<1){return false}var at=ar.toLowerCase();if(at.indexOf(".")!==-1){at=at.split(".").join("")}if(at.indexOf("/")!==-1){at=at.split("/").join("")}if(at.indexOf(" ")!==-1){at=at.split(" ").join("")}var au=new a.Debugger();au.setPrefix("");au.group('Tracing parameter "'+ar+'"');var aw=function(){var ax=ar;var aC=n.getParameterAlias(at);if(typeof(aC)==="string"){ax+=" (alias: "+aC+")";if(typeof(n.cfgAliasNames[at])==="string"){at=n.cfgAliasNames[at]}}var ay=n.cfg[at];var aB=true;if(at.indexOf("_")!==-1){var aA=at.split("_");var az=aA.shift();var aD=aA.join("_");if(n.hasPlugin(az)){ay=n.getPluginParameter(az,aD)}}else{if(n.hasPlugin(at)){aB=false;ay="is enabled."}}if(ay===b){aB=false;ay="is undefined (default value applies)"}if(aB){ay='= "'+ay+'"'}au.group("RESULT:");au.log(ax+" "+ay);au.groupEnd();au.groupEnd()};x={onConfigsReady:aw};f.strTraceParam=at;f.bNoDebug=true;n.iTraceParameterDebug=au;n.init(av);n.loadConfigs();return""};this.loadLanguageFile=function(ar,aD,aw,au){var ax=arguments;var ay,aB;if(typeof(aD)!=="string"||n.makeBool(aD,true)===false){return aw.call(n,{},"")}var aC=function(aE){try{a.utils.oLanguageMap=JSON.parse(aE.responseText)}catch(aF){a.utils.oLanguageMap={"default":"english"}}n.loadLanguageFile.apply(this,ax)};var az=function(aE,aH){ar.urlLanguageCurrentLoaded=ay;var aG=ar.oLanguageData={};if(aH){var aF=n.findXMLNode(aH,"data");if(aF){aF=n.findXMLNode(aF,"tip")}while(aF){if(aF.nodeType===1){var aI=aF.getAttribute("id");aG[aI]=aF.innerHTML}aF=aF.nextSibling}}aw.call(n,ar.oLanguageData,aB)};if(aD.toLowerCase()==="auto"){if(!a.utils.oLanguageMap){n.loadFile(n.locationFSIViewer+"/languages/mapping.json",aC,"application/json");return}if(a.utils.oLanguageMap._current!==b){aD=a.utils.oLanguageMap._current}else{aD=a.utils.oLanguageMap["default"];var av=navigator.language;if(typeof(av)==="string"){av=av.toLowerCase()}if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}else{if(av.indexOf("-")!==-1){av=av.split("-")[0];if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}}}}if(aD===b){return aw.call(n,{},"")}if(au){au.log('Automatically choosing language "'+aD+'" from navigator.language "'+navigator.language+'"')}a.utils.oLanguageMap._current=aD}var aA=aD+".xml";var at=n.locationFSIViewer+"/languages/"+aA;if(at!==ar.urlLanguageCurrentLoaded){aB=aD;ay=at;if(au){au.log("Loading language file: "+at)}n.loadFile(at,az,"application/xml")}else{aw.call(n,ar.oLanguageData,aB)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!==b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.setFromArray=function(h){e.left=h[0];e.top=h[1];e.right=h[2];e.bottom=h[3]};this.scaleRect=function(h){if(h===1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h===1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.getPartialRect=function(j){var i=e.duplicateRect();if(!j.isDefaultImageRect()){var h=i.width();var k=i.height();i.offsetRect(j.left*h,j.top*k);i.right=i.left+h*j.width();i.bottom=i.top+k*j.height()}return i};this.isDefaultImageRect=function(){return(e.left===0&&e.top===0&&e.right===1&&e.bottom===1)};this.limitToImageRect=function(){e.left=Math.max(0,Math.min(1,e.left));e.right=Math.max(0,Math.min(1,e.right));e.top=Math.max(0,Math.min(1,e.top));e.bottom=Math.max(0,Math.min(1,e.bottom))};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left===h.left&&e.top===h.top&&e.right===h.right&&e.bottom===h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.setFromString=function(j){if(typeof(j)!=="string"){return}j=decodeURIComponent(j);j=j.replace(/[^0-9,.]/g,"");j=j.split(",");if(j.length>3){for(var h=0;h<j.length;h++){j[h]=parseFloat(j[h])}e.setFromArray(j)}};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CroppedImage!==b){return}a.CroppedImage=function(){var p=this;var e=new a.Rect(0,0,0,0);var n,d;var i=new a.Rect();var h=new a.Rect(0,0,1,1);var c={width:0,height:0};var k=false;var o=function(t,s){if(typeof(t)!="string"){return s}var q=t.split(",");var r=q.length;while(q.length<4){q.push(s[r]);r++}return q};this.setCropFromConfig=function(q){if(q.cropvalues!==b){p.setCropValuesParam(q.cropvalues)}else{if(q.croprect!==b){p.setCropRectParam(q.croprect)}}};this.setCropRectParam=function(r){var q=o(r,["0","0","1","1"]);p.setCropRect(q[0],q[1],q[2],q[3])};var g=function(s,r){var q;if(isNaN(s)){q=r}else{q=Math.max(0,Math.min(1,s))}return q};var j=function(r,q){return Math.round(r*q)};this.setCropRect=function(s,u,v,q){n={l:s,t:u,r:v,b:q};d=b;s=g(s,0);u=g(u,0);v=g(v,1);q=g(q,1);h.setRect(s,u,1-v,1-q);s=j(s,c.width);u=j(u,c.height);v=c.width-j(v,c.width);q=c.height-j(q,c.height);f(s,u,v,q)};var f=function(s,u,v,q){v=Math.min(c.width-s,v);q=Math.min(c.height-u,q);e.setRect(s,u,v,q);k=(s!==0||u!==0||v!==0||q!==0);i.setRect(s,u,c.width-v,c.height-q)};this.setCropValuesParam=function(r){var q=o(r,["0","0","0","0"]);p.setCropValues(q[0],q[1],q[2],q[3])};var m=function(s,q){var r={};if(s.indexOf("%")!==-1){s=Math.max(0,Math.min(100,parseFloat(s)));r.floatVal=s/100;r.pxVal=Math.round(s*q/100)}else{if(s.indexOf("px")!==-1){s=parseInt(s);r.pxVal=Math.max(0,Math.min(q,s));r.floatVal=r.pxVal/q}else{r.floatVal=Math.max(0,Math.min(1,parseFloat(s)));r.pxVal=Math.round(r.floatVal*q)}}return r};this.setCropValues=function(s,u,v,q){d={l:s,t:u,r:v,b:q};n=b;s=m(s,c.width);v=m(v,c.width);u=m(u,c.height);q=m(q,c.height);h.setRect(s.floatVal,u.floatVal,v.floatVal,q.floatVal);f(s.pxVal,u.pxVal,v.pxVal,q.pxVal)};this.setSourceDimension=function(q,r){c.width=q;c.height=r;l()};this.getSourceDimension=function(){return{width:c.width,height:c.height}};this.isCropped=function(){return k};this.getImageRect=function(){return i.duplicateRect()};this.flipCropHorz=function(){var r=function(t){var s=t.l;t.l=t.r;t.r=s};var q=function(t){var s=t.l;t.l=1-t.r;t.r=1-s};if(n){q(n)}if(d){r(d)}l()};this.getFloatValues=function(){return h.duplicateRect()};this.getFloatRect=function(){var q=h.duplicateRect();q.right=1-q.right;q.bottom=1-q.bottom;return q};this.getCropMargins=function(){return e.duplicateRect()};var l=function(){if(n!==b){p.setCropRect(n.l,n.t,n.r,n.b)}else{if(d!==b){p.setCropValues(d.l,d.t,d.r,d.b)}else{f(0,0,0,0);h.setRect(0,0,0,0)}}};this.getOffsettedPixelRangeRect=function(q,v,r,t){var u=i.width();var s=i.height();q=Math.max(0,Math.min(u,q));v=Math.max(0,Math.min(s,v));r=Math.max(0,Math.min(u-q,r));t=Math.max(0,Math.min(s-v,t));q+=i.left;v+=i.top;return new a.Rect(q,v,r,t)};this.getPixelRangeRect=function(r,u,z,v,B,s){var q,A;if(r===b&&u===b){r=i.width();u=i.height();A=1}else{if(r!==b){A=i.width()/r;if(u===b){u=i.height()/A}}else{A=i.height()/u;if(r===b){r=i.width()/A}}}if(z===b){z=v=0;B=r;s=u}if(!k){q=new a.Rect(z,v,B,s);q._refWidth=r;q._refHeight=u}else{r*=A;u*=A;var t=new a.Rect(z,v,B,s);t.scaleRect(A);q=p.getOffsettedPixelRangeRect(t.left,t.top,t.right,t.bottom);q.scaleRectInt(1/A);r+=e.left+e.right;u+=e.top+e.bottom;r/=A;u/=A;q._refWidth=Math.round(r);q._refHeight=Math.round(u);q.right=Math.min(q._refWidth-q.left,q.right);q.bottom=Math.min(q._refHeight-q.top,q.bottom)}return q};this.getPixelRangeParameters=function(A,u,q,z,r,t){var s;var v=p.getPixelRangeRect(A,u,q,z,r,t);if(v.left===0&&v.top===0&&v.width()===v._refWidth&&v.height()===v._refHeight){s="&width="+v._refWidth}else{s="&pixelRange="+v.left+","+v.top+","+v.right+","+v.bottom+"&referenceWidth="+v._refWidth+"&referenceHeight="+v._refHeight}return s};this.getPixelRangeParametersByCalculatedResult=function(r){var q;if(r.left===0&&r.top===0&&r.width()===r._refWidth&&r.height()===r._refHeight){q="&width="+r._refWidth}else{q="&pixelRange="+r.left+","+r.top+","+r.right+","+r.bottom+"&referenceWidth="+r._refWidth+"&referenceHeight="+r._refHeight}return q};this.getCropToFill=function(u,s,y,B){var C=new a.CroppedImage();var D,v;if(typeof(y)!=="string"||y.length!==2){y="cc"}else{y=y.toLowerCase()}var t=0;var r=new a.Rect();var A;var z=p.isCropped();var q,E;var x,F;if(z){x=(1-h.left-h.right);F=(1-h.top-h.bottom);q=Math.round(x*c.width);E=Math.round(F*c.height)}else{q=c.width;E=c.height}u=Math.min(u,q);s=Math.min(s,E);if(u/q<s/E){v=s;D=Math.round(q/E*s);t=D-u;switch(y.charAt(1)){case"l":r.setRect(0,0,D-t,v);break;case"r":r.setRect(t,0,D,v);break;case"v":A=Math.random()*t;r.setRect(A,0,A+u,v);break;default:r.setRect(t/2,0,D-t/2,v)}}else{D=u;v=Math.round(E/q*u);t=v-s;switch(y.charAt(0)){case"t":r.setRect(0,0,D,v-t);break;case"b":r.setRect(0,t,D,v);break;case"v":A=Math.random()*t;r.setRect(0,A,D,A+s);break;default:r.setRect(0,t/2,D,v-t/2)}}r.scaleRectXY(1/D,1/v);if(p.isCropped()){D/=x;v/=F;if(B){D=Math.min(D,c.width);v=Math.min(v,c.height)}C.setSourceDimension(D,v);r.scaleRectXY(x,F);r.offsetRect(h.left,h.top)}else{if(B){D=Math.min(D,c.width);v=Math.min(v,c.height)}C.setSourceDimension(D,v)}C.widthUncropped=D;C.heightUncropped=v;C.setCropRect(r.left,r.top,r.right,r.bottom);return C}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.CustomEventListener!==b){return}a.utils.CustomEventListener=function(i){var k=this;var c=[];var f={};var g={};var h=0;k._strClassName="$FSI.CustomEventListener";var j=function(){};this.destroy=function(){for(var l=0;l<c.length;l++){var m=c[l];e(m.element,m.fn)}c=[];f={};g={};k.onDestroy()};this.fireEvent=function(l,m){if(!l||!l.enabled){return false}if(typeof(m)!="object"){m={}}if(l.paused){m.FSI_paused=true}m.FSI_custom_event=true;m.FSI_type=i;m.FSI_target=l.element;return l.fn.call(l.element,m)};this.fireEvents=function(m){if(typeof(m)!="object"){m={}}m.FSI_custom_event=true;m.FSI_type=i;for(var n=0;n<c.length;n++){var l=c[n];if(l.enabled){if(l.paused){m.FSI_paused=true}else{if(m.FSI_paused){delete m.FSI_paused}}m.FSI_target=l.element;l.fn.call(l.element,m)}}};this.addListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for addListener");return}if(p.__FSI===b){p.__FSI={}}if(p.__FSI.eventElementID===b){p.__FSI.eventElementListenerCount=1;p.__FSI.eventElementID=a.utils.getNewEventElementID()}else{p.__FSI.eventElementListenerCount++}if(o.__FSIEventFunctionID===b){o.__FSIEventFunctionListenerCount=1;o.__FSIEventFunctionID=a.utils.getNewEventFunctionID()}else{o.__FSIEventFunctionListenerCount++}var m=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(f[m]===b){var l=f[m]={};l.nFunction=0;l.oFunctions={}}if(f[m].oFunctions[n]===b){f[m].nFunction++;f[m].oFunctions[n]=[]}else{a.console.warn(k._strClassName+": There is already a listener for this exact element and function");a.console.log(p);a.console.log(o)}var q={};q.element=p;q.elementID=m;q.fn=o;q.fnID=n;q.instanceListener=k;q.enabled=true;q.paused=false;q.uniqueID=h++;f[m].oFunctions[n].push(q);c.push(q);g[q.uniqueID]=q;k._onListenerAdd(q);k._onListenerCountChange(c.length);return q};this.setListenerProps=function(o,m,n){var l=g[o];if(!l){return false}if(l.props===b){l.props={}}l.props[m]=n;return true};this.enableListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.enabled===m){return}l.enabled=m};this.pauseListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.paused===m){return}l.paused=m};var e=this.removeListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for removeListener");return}if(typeof(p.__FSI)!=="object"||p.__FSI.eventElementID===b||o.__FSIEventFunctionID===b){if(o.__FSIEventFunctionID===b){a.console.error(k._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(k._strClassName+": Element not registered for listener in removeListener")}return}var l=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(!f[l]){a.console.error(k._strClassName+": No registered listener for this element in removeListener");return}var m=f[l].oFunctions[n];if(m===b||typeof(m.pop)!="function"){a.console.error(k._strClassName+": No registered listener for this function in removeListener");return}var q=m.pop();q.fn.__FSIEventFunctionListenerCount--;q.element.__FSI.eventElementListenerCount--;if(q.element.__FSI.eventElementListenerCount===0){delete q.element.__FSI.eventElementListenerCount;delete q.element.__FSI.eventElementID}if(q.fn.__FSIEventFunctionListenerCount===0){delete q.fn.__FSIEventFunctionListenerCount;delete q.fn.__FSIEventFunctionID}if(m.length===0){delete f[l].oFunctions[n];f[l].nFunction--;if(f[l].nFunction===0){delete f[l]}}delete g[q.uniqueID];d();k._onListenerRemove(q);k._onListenerCountChange(c.length);return q};this.getEventListenerByID=function(l){return g[l]};this.getListenerObjectByID=function(l){return g[l]};this.getListenersArray=function(){return c};this.getListenerCount=function(){return c.length};var d=function(){c=[];for(var m in f){if(f.hasOwnProperty(m)){var o=f[m].oFunctions;for(var n in o){if(o.hasOwnProperty(n)){var l=o[n];c=c.concat(l)}}}}};this.dump=function(){a.console.dir(f);a.console.dir(c)};this._onListenerCountChange=function(l){};this._onListenerAdd=function(m,l){};this._onListenerRemove=function(m,l){};this.triggerEvent=function(l){};this.triggerEvents=function(){};this.setListenerProps=function(n,l,m){};this.onDestroy=function(){};j()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIDocumentZoomChange")){return}a.utils.registerCustomEvent("FSIDocumentZoomChange",function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.utils.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.utils.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!==c){if(q){j()}else{i()}}};var m=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!==q){g=q;k(q);p=true}else{p=false}return p};var d=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!==q){if(!f){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l===20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l===40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l===50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.utils.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.utils.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.utils.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.utils.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIElementDimension")){return}a.utils.registerCustomEvent("FSIElementDimension",function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)==="function";a.utils.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e===b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(!g){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!==b){h(s)}}}}};var h=function(p){if(p===k||e===b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIViewport")){return}a.utils.registerCustomEvent("FSIViewport",function(){var k=this;var d=false;var h=new a.Rect(0,0,0,0);var i=new a.Rect(0,0,0,0);var l=new a.Rect(0,0,0,0);var H=new a.Rect(0,0,0,0);var t={left:0,top:0};var T;var B;var C="";var o=b;var y;var q=10;var F;var s=0;var u;var E;var S=0;var c=100;var n=1;var z=1;var N=32;var w;var p;var G=a.BrowserSupports.visualViewportAPI();try{p=window.frameElement}catch(P){}a.utils.CustomEventListener.prototype.constructor.call(k,"FSIViewport");k._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){m()};var M=function(){if(d){return}d=true;g(a.addEvent);F=a.addCustomEvent(k,"FSIDocumentZoomChange",I);n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio()};var m=function(){if(!d){return}d=false;g(a.removeEvent);a.removeCustomEvent(k,"FSIDocumentZoomChange",I);F=b;if(o){clearInterval(o);o=b}r();s=0;if(w!==b){clearTimeout(w);w=b}};var g=function(U){var e=window;U(e.document,"scroll",j,false);U(e,"resize",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&p){U(e,"touchmove",Q,false)}}while(e.frameElement){e=e.parent.window;if(e){U(e.document,"scroll",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){U(e,"touchmove",Q,false)}}U(e,"resize",j,false)}}U(window,"orientationchange",j,false)};this.setListenerProps=function(W,U,V){if(typeof(U)!="string"){return false}var e=k.getListenerObjectByID(W);if(!e){return false}switch(U){case"treshold":if(e.tresholdEnd!==b){s--;e.tresholdEnd=b}if(V&&V>0){s++;e.tresholdEnd=V}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=V;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!==b){s--}};this._onListenerCountChange=function(e){var U=(e>0);if(U!==d){if(U){M()}else{m()}}};var I=function(e){n=e.FSI_scale;z=e.FSI_scale_with_pixel_ratio;j()};var j=function(){if(w!==b){return}w=setTimeout(K,N);K()};var K=function(){if(w!==b){clearTimeout(w);w=b}var e=false;var U=L();if(C!==U){C=U;e=true;f()}return e};var J=function(){n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio();L()};this.triggerEvent=function(V){var e=k.getEventListenerByID(V);if(!e){return}J();var U=O();k.fireEvent(e,U)};this.triggerEvents=function(){J();f()};var f=this.fireEvents=function(){var U=O();var V=k.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(!e.fireTresholdEventOnly){k.fireEvent(e,U)}}A()};var O=function(){var e={};e.FSI_scale=a.utils.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=i;e.FSI_scroll=t;e.FSI_client_rect_body_top=T;e.FSI_viewport_size_top=B;return e};this.getVisibleRect=function(){L();return H};this.getScrollRect=function(){return T};var R=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);var e=window.visualViewport;H.setRect(e.pageLeft,e.pageTop,e.pageLeft+e.width,e.pageTop+e.height);if(p){t.left=-window.pageXOffset;t.top=-window.pageYOffset}else{t.left=T.left;t.top=T.top}i.left=e.offsetLeft;i.top=e.offsetTop;i.right=i.left+e.width;i.bottom=i.top+e.height;return e.scale+"_"+e.offsetLeft+","+e.offsetTop+","+e.width+","+e.height+" "+B.width+" x "+B.height+" "+e.pageTop+"x"+e.pageLeft};var x=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);h.left=a.utils.getTopWindow().pageXOffset;h.top=a.utils.getTopWindow().pageYOffset;h.right=h.left+B.width;h.bottom=h.top+B.height;if(p){var e=a.getViewportSize(window);var U=a.getWindowOffset(window);i.left=0;i.top=0;i.right=i.left+e.width;i.bottom=i.top+e.height;t.left=-window.pageXOffset;t.top=-window.pageYOffset;l.copyRect(i);l.left=-U.x+h.left+T.left;l.top=-U.y+h.top+T.top;l.right=l.left+B.width;l.bottom=l.top+B.height;i.interSectRectValidate(l);var V=a.getBoundingClientRect(window.document.body);H.copyRect(i);H.offsetRect(U.x+V.left,U.y+V.top)}else{t.left=T.left;t.top=T.top;H.copyRect(h);i.copyRect(h);i.offsetRect(T.left,T.top)}return n+"_"+H.toString()+" "+B.width+" x "+B.height};var L=(G)?R:x;var Q=function(){y=q;if(o!==b){return}o=setInterval(v,100)};var v=function(){if(!K()){y--}else{y=q}if(y<1){clearInterval(o);o=b}};var r=function(){if(E!==b){clearInterval(E);E=b;u=b}};var A=function(){r();if(s>0){E=setInterval(D,c)}};var D=function(){var W,e;S+=c;if(u===b){S=c;u=[];var V=k.getListenersArray();for(W=0;W<V.length;W++){e=V[W];if(e.tresholdEnd>0){u.push(e)}}}var U;for(W=u.length-1;W>-1;W--){e=u[W];if(e.tresholdEnd<=S){if(k.getEventListenerByID(e.uniqueID)!==b){if(U===b){U=O();U.FSI_after_treshold=true}k.fireEvent(e,U)}u.splice(W,1)}}if(u.length===0){r()}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!==b){return}a.Easing={easeLinear:function(f,g,e,h){return h*(f/g)+e},easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f===0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f===g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f===0){return e}if(f===g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j)===1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j)===1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j/2)===2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g===b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g===b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g===b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!==b){return}a.TouchHandler=function(m,aX,al,e,aN){var aE=this;var aL=false;var ak=true;var o=false;var aT=false;var aK=false;var aB,E,j,ad;var aC,Y,aI;var h=false;var ae;var r;var a0={};var aq=[];var ac=0;var I=window;var aV;var s;var aU;var d;var aZ=[];var aR={x:0,y:0};var v={x:0,y:0};var ar=40;var n={};n.enabled=false;n.factor=5;n.fEndDiff=1;var ay={};ay.enabled=false;ay.minFrames=14;ay.factorAmount=23;ay.factorAmountQuad=0;ay.factorFrames=2.6;ay.offsetFrames=5;var ab;var az;var aH,w;var F;var at={};var X;var aM=false;var z=false;var am={};am.name="none";var N;var W;var aO;var f=false;var Z={};if(!aX||typeof(aX)!="object"){aX={}}var an=function(){var a6;if(aL){aE.destroy()}aU=A;s=b;if(a.utils.getTopWindow()!==window){s=a.utils.getTopWindow();try{var a5=a.getWindowOffset(window);if(a5.x!==b&&a5.y!==b){aU=ap}}catch(a4){aU=A;s=b}}else{s=b}F=aX.oPassTrough;aW(aX.panDirectionAllowed,true);if(aX.getPageCoords){r=aF}else{r=M}if(aX.afterTouch){for(a6 in aX.afterTouch){if(aX.afterTouch.hasOwnProperty(a6)){ay[a6]=aX.afterTouch[a6]}}}if(ay.minDelta===b){ay.minDelta=15}if(aX.nClickRadius){ab=aX.nClickRadius}else{ab=10}if(ay.fnStartStopAfterTouch&&typeof(ay.fnStartStopAfterTouch)!="function"){ay.fnStartStopAfterTouch=b}if(ay.fnStartStopAfterTouch){ay.useAnimationFrame=b}if(typeof(ay.modifyTarget)!="function"){ay.modifyTarget=b}if(typeof(ay.fnGetAfterTouchEnabled)=="function"){az=ay.fnGetAfterTouchEnabled}else{az=b}if(aX.smoothing){for(a6 in aX.smoothing){if(aX.smoothing.hasOwnProperty(a6)){n[a6]=aX.smoothing[a6]}}}if(aX.detectClick===true){X=true}if(aX.preventSelection!==false){aX.preventSelection=true}if(!m){return}if(typeof(m.join)!="function"){m=[m]}if(typeof(al)!="function"){al=A}if(typeof(e)!="function"){e=A}if(typeof(aN)!="function"){aN=A}if(typeof(aX.onPinchChange)=="function"){N=aX.onPinchChange}else{N=b}aM=aX.detectGestures;aZ=[];ax(true,aM);for(var a3=0;a3<m.length;a3++){var a2=m[a3];if(a2&&typeof(a2.nodeName)!="undefined"){a6={};a6.element=a2;aZ.push(a6);ao(a2,R);if(a.isTouch){try{if(a2.style!==b){if(a.BrowserSupports.cssTouchAction()){if(at.cssTouchAction!==b){q(a2,at.cssTouchAction)}}}}catch(a4){}}}}if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aD,false)}};this.setFnDown=function(a2){al=a2};this.setFnUp=function(a2){aN=a2};this.setFnMove=function(a2){e=a2};var aW=this.setAllowedPanDirection=function(a3,a2){if(typeof(a3)=="string"){if(a3==="pan-x"||a3==="pan-y"||a3==="pan-x pan-y"){aV=a3+" "}else{aV=""}}else{aV=""}if(!a2){at.nCheck=b;ah(at.captureScroll,at.capturePinch)}};this.enable=function(a2){if(ak===a2){return}if(!a2){Q();ah(false,false)}else{ah(at.captureScrollUser,at.capturePinchUser)}ak=a2};this.getEnabled=function(){return ak};this.cancel=function(){P();ag();aJ();Q()};var aJ=function(){if(n.enabled){i()}B()};this.cancelAfterTouch=function(){B()};this.getInitialDownEvent=function(){return W};var Q=function(){if(!o){return}aJ();o=false;W=b;z=false;if(ac===0){aP()}};var aP=function(){f=false;c()};this.destroy=function(){if(a.BrowserSupports.cssTouchAction()){for(var a3=0;a3<m.length;a3++){var a2=m[a3];q(a2,"")}}if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aD,false)}if(aO){clearTimeout(aO)}aE.cancel();var a2;for(var a3=0;a3<aZ.length;a3++){var a4=aZ[a3];a2=a4.element;x(a2,R)}at={}};var q=function(a2,a3){if(!a.BrowserSupports.cssTouchAction()||!a2||!a2.style){return}a2.style.touchAction=a2.style.msTouchAction=a3};var T=function(a2){if(a2.preventDefault){a2.preventDefault()}};var l=function(a2){T(a2);return false};var ao=function(a3,a2){a.addEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{a.addEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a3,"touchstart",a2);a.addEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a3,"MSPointerDown",a2)}a.addEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var x=function(a3,a2){a.removeEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{a.removeEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a3,"touchstart",a2);a.removeEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a3,"MSPointerDown",a2)}a.removeEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var A=function(){return true};var aQ=function(a2){if(aK){V(a2,a2.pointerId)}else{var a3=a2.changedTouches;for(var a4=0;a4<a3.length;a4++){V(a3[a4],a3[a4].identifier)}}};var V=function(a2,a4){if(a4===b||a0[a4]!==b){if(aX.debug){if(a4===b){a.console.error("doRegisterPointer: no pointerId")}if(a0[a4]!==b){a.console.error("doRegisterPointer: pointerId already registered: "+a4)}}return}ac++;var a3=a0[a4]={};a3.identifier=a4;r(a3,a2);aq.push(a3)};var aj=function(a2){var a4=false;if(aK){a4=K(a2.pointerId)}else{var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){a4=K(a3[a5].identifier)}}}if(a4){aq=new Array(ac);var a7=0;for(var a6 in a0){if(a0.hasOwnProperty(a6)){aq[a7++]=a0[a6]}}}};var K=function(a2){if(a2===b||a0[a2]===b){if(aX.debug){if(a2===b){a.console.error("doUnregisterPointer: no pointerId")}if(a0[a2]===b){a.console.error("doUnregisterPointer: pointerId not registered: "+a2)}}return false}delete a0[a2];ac--;return true};var H=function(){ac=0;a0={};aq=[]};var M=function(a3,a2){a3.x=a2.clientX;a3.y=a2.clientY};var aF=function(a3,a2){a3.x=a2.pageX;a3.y=a2.pageY};var u=function(a2){var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){var a4=a0[a3[a5].identifier];if(a4){r(a4,a3[a5])}}}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y}};var aw=function(a2){var a3=a0[a2.pointerId];if(a3){r(a3,a2)}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y;aU(a2,aR)}};var U=function(a2){r(aR,a2);aU(a2,aR)};this.getMousePositionFromMouseEvent=function(a2){U(a2);return aR};this.getMousePositionPage=function(a3){var a2={};aF(a2,a3);aU(a3,a2);return a2};this.getMousePositionClient=function(a3){var a2={};M(a2,a3);aU(a3,a2);return a2};var t=function(a2,a3){if(window!==a2.view){var a4=a.getWindowOffset(window);a3.x-=a4.x;a3.y-=a4.y}};var ap=function(a2){try{t(a2);aU=t}catch(a3){aU=A}};var aA=function(a2){if(!ak){return}var a4=ac;if(z&&a4===0){z=false}var a5=a2.type;if(o||am.started){if(a5!==aB){if(am.started){P();ag()}else{a2._FSI_Canceled=true;a1(a2,true)}}}aB=a5;d=false;var a3=true;switch(a5){case"touchstart":aT=true;aK=false;ae=u;j="touchmove";E="touchend";ad="touchcancel";aH=false;break;case"MSPointerDown":ae=aw;aT=true;aK=true;j="MSPointerDown";E="MSPointerUp";ad="MSPointerCancel";aH=false;d=true;break;case"pointerdown":ae=aw;aT=true;aK=true;j="pointermove";E="pointerup";ad="pointercancel";aH=true;d=true;break;default:if(ac>0){H()}aT=false;aK=false;aH=(aX.preventSelection);a3=false;ae=U;j="mousemove";E="mouseup";ad=b;d=true}if(aT&&a3){aQ(a2)}ae(a2);if(ac>1){Z.bClick=false}w=false;if(a3&&ai(a2)){if(a4===0){B();D()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ac};var R=this.handleDownEvent=function(a2){if(aX.bMouseOnly&&a2.type==="pointerdown"&&a2.pointerType!=="mouse"){return true}if(!aA(a2)){return}if(o||a2.which>1){return}g(a2)};this.getCurrentPos=function(){return v};var g=function(a2){aJ();if(o){return}ay.evtMove=b;if(n.enabled){v={x:aR.x,y:aR.y}}else{v=aR}Z.x=aR.x;Z.y=aR.y;var a3=W;W=a2;if(!al.call(I,a2,v,F)){W=a3;return false}o=f=true;if(X&&!z){Z.bClick=true;Z.clickRadiusX=Z.clickRadiusY=0}else{Z.bClick=false}D();if(ay.enabled){ay.x=ay.y=0;ay.lastX=aR.x;ay.lastY=aR.y;if(ay.nInterval){clearInterval(ay.nInterval)}ay.nInterval=setInterval(aa,30)}return true};var c=function(){if(h&&Y!==b){var a2={passive:false,capture:false};var a4=(s===b)?a2:b;h=false;a.removeEvent(window,Y,af,a4);a.removeEvent(window,aC,a1,a4);if(d&&s){try{a.removeEvent(s,Y,af,a2);a.removeEvent(s,aC,a1,a2)}catch(a3){}}if(aI!==b){a.removeEvent(window,aI,au,a4)}Y=aC=aI=b}};var aD=function(){};var D=function(){if(h){c()}h=true;var a2={passive:false,capture:false};var a4=(s===b)?a2:b;Y=j;aC=E;aI=ad;a.addEvent(window,Y,af,a4);a.addEvent(window,aC,a1,a4);if(d&&s){try{a.addEvent(s,Y,af,a2);a.addEvent(s,aC,a1,a2)}catch(a3){}}if(ad!==b){a.addEvent(window,aI,au,a4)}};var af=function(a2){ae(a2);a2.FSI_start_x=Z.x;a2.FSI_start_y=Z.y;if(ay.enabled&&ay.evtMove===b){ay.evtMove=a2}if(o){if(Z.bClick){Z.clickRadiusX=Math.max(Z.clickRadiusX,Math.abs(aR.x-Z.x));if(Z.clickRadiusX>ab){Z.bClick=false}else{Z.clickRadiusY=Math.max(Z.clickRadiusY,Math.abs(aR.y-Z.y));if(Z.clickRadiusY>ab){Z.bClick=false}}}if(n.enabled){n.evt=a2;aY()}else{e.call(I,a2,v,F)}}else{if(am.started){if(am.nType===1){av(a2)}}}if(w&&!a2.FSI_allowEventDefault){T(a2)}};var av=function(a2){var a3=k();if(!N){return}a2._FSI_PinchDeltaStart=am.nPinchDistance-am.pinchDistanceStart;a2._FSI_PinchDeltaRelative=am.nPinchDistance-am.pinchDistanceLast;a2._FSI_PinchScale=Math.max(ar,am.pinchDistanceLast)/am.pinchDistanceStartMaxed;am.pinchDistanceLast=am.nPinchDistance;a2._FSI_PinchDistance=a3;N.call(I,a2,aR,F)};var au=function(a2){if(aT){aj(a2);if(ac<1){if(o){a2._FSI_Canceled=true;a1(a2,true);return}else{Q();return}}}ae(a2);ai(a2)};var a1=function(a3,a4){var a2=Z.bClick;Z.bClick=false;if(a4){a3._FSI_Canceled=true}if(aT){aj(a3)}if(ac===0){aP()}ae(a3);if(!a4&&ai(a3)){return}aJ();if(!a4){if(!o||ac>0){return}}a3.FSI_start_x=Z.x;a3.FSI_start_y=Z.y;var a5=false;if(!a4&&ay.enabled){if(az===b||az()){a5=S(a3)}}if(a5){Q();y(a3)}else{if(X){a3._FSI_Click=a2}aN.call(I,a3,v,F);if(a3.type==="touchend"){aO=setTimeout(p,1)}Q()}T(a3)};var p=function(){Q();H();aO=b};var G=function(){return aq};var aY=function(){if(n.animationFrame!==b){return}aS()};var i=function(){if(n.animationFrame===b){return}cancelAnimationFrame(n.animationFrame);n.animationFrame=b};var aS=function(){var a2=Math.abs(v.x-aR.x)+Math.abs(v.y-aR.y);if(a2>n.fEndDiff){v.x+=(aR.x-v.x)/n.factor;v.y+=(aR.y-v.y)/n.factor;n.animationFrame=requestAnimationFrame(aS)}else{v.x=aR.x;v.y=aR.y;n.animationFrame=b}e.call(I,n.evt,v,F)};var S=function(a2){var a3;if(!ay.enabled){return false}if(ay.running){B()}ay.pos=0;var a5=(a2.touches!==b)?1.8:1;if(ay.factorAmountQuad){a3=(ay.x>0)?1:-1;ay.x=ay.x+a3*ay.x*ay.x/ay.factorAmountQuad;a3=(ay.y>0)?1:-1;ay.y=ay.y+a3*ay.y*ay.y/ay.factorAmountQuad}var a7=a5*ay.factorAmount;ay.startX=v.x;ay.startY=v.y;var a6={};a6.x=ay.startX+a7*ay.x;a6.y=ay.startY+a7*ay.y;if(ay.roundTargetPos){a6.x=Math.round(a6.x);a6.y=Math.round(a6.y)}if(ay.modifyTarget){a6=ay.modifyTarget.call(I,a6,F);if(a6===false){return false}}ay.amountX=a6.x-ay.startX;ay.amountY=a6.y-ay.startY;ay.amountXABS=Math.abs(ay.amountX);ay.amountYABS=Math.abs(ay.amountY);var a4=(ay.amountXABS>ay.minDelta||ay.amountYABS>ay.minDelta);if(a4){a7=ay.factorFrames/100;ay.frames=ay.offsetFrames+Math.round(a7*ay.amountXABS+a7*ay.amountYABS)}else{if(typeof(aX.onAfterTouchCancel)=="function"){aX.onAfterTouchCancel.call(I,a2,v,F)}}return a4};this.isAfterTouchRunning=function(){return ay.running};var y=function(a2){if(typeof(aX.onAfterTouchStart)=="function"){aX.onAfterTouchStart.call(I,a2,v,F)}ay.running=true;ay.evtUp=a2;if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,true,ay.evtMove,F)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}else{ay.intervalRun=setInterval(J,16)}}return true};var aG=function(a3,a2,a5,a4){return a5*((a3=a3/a4-1)*a3*a3+1)+a2};var J=this.runAfterTouch=function(){var a2=false;ay.pos++;v.x=aG(ay.pos,ay.startX,ay.amountX,ay.frames);v.y=aG(ay.pos,ay.startY,ay.amountY,ay.frames);e.call(I,ay.evtMove,v,F);if(ay.pos===ay.frames){B(true)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}a2=true}return a2};this.enableAfterTouch=function(a2){if(ay.enabled===a2){return}if(!a2){B()}ay.enabled=a2};var B=function(a2){if(!ay.running){return}if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,false,ay.evtMove,F)}else{if(ay.useAnimationFrame){if(ay.animationFrameRun){cancelAnimationFrame(ay.animationFrameRun)}}else{if(ay.intervalRun){clearInterval(ay.intervalRun);ay.intervalRun=b}}}if(typeof(aX.onAfterTouchEnd)=="function"){aX.onAfterTouchEnd.call(I,ay.evtMove,F)}ay.evtMove=b;ay.running=false;ay.evtUp._FSI_Canceled=(a2!==true);ay.evtUp._FSI_fromAfterTouch=true;aN.call(I,ay.evtUp,v,F)};var aa=function(){ay.x=(2*ay.x+aR.x-ay.lastX)/5;ay.y=(2*ay.y+aR.y-ay.lastY)/5;ay.lastX=aR.x;ay.lastY=aR.y};var ax=this.setCapture=function(a2,a4){var a3=ah(a2,a4);if(a3){at.captureScrollUser=a2;at.capturePinchUser=a4}return a3};var ah=function(a2,a4){var a3=0;if(a2){a3+=2}if(a4){a3+=4}if(a3===at.nCheck){return}at.nCheck=a3;at.captureScroll=a2;at.capturePinch=a4;if(a.BrowserSupports.cssTouchAction()){O(a2,a4)}return true};var O=function(){if(aX.bMouseOnly){return}var a4;switch(at.nCheck){case 0:a4="auto";break;case 2:a4=aV+"pinch-zoom";break;case 4:a4="pan-x pan-y";break;default:a4=(aV.length>0)?aV:"none"}at.cssTouchAction=a4;for(var a3=0;a3<m.length;a3++){var a2=m[a3];q(a2,at.cssTouchAction)}};var k=function(){if(aq.length<1){return 0}var a3=Math.abs(aq[1].x-aq[0].x);var a2=Math.abs(aq[1].y-aq[0].y);return am.nPinchDistance=Math.sqrt(a3*a3+a2*a2)};var ai=function(a2){w=false;if(!ak){return}var a3=aq.length;if(!aM){w=(a3===1&&at.captureScroll);return}if(am.pointerCount!==a3){P(a2);if(a3>1){ag();am.nPointers=a3;switch(a3){case 2:am.started=true;am.name="pinch";am.nType=1;if(typeof(aX.onPinchStart)=="function"){L(a2);am.nPinchDistance=0;am.nPinchDistance=k();am.pinchDistanceStart=am.pinchDistanceLast=am.nPinchDistance;am.pinchDistanceStartMaxed=Math.max(ar,am.pinchDistanceStart);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchStart.call(I,a2,aR,F)}break;default:am.started=true;am.name="unknown";am.nType=-1}if(am.started){z=true;if(o){aJ();o=false;a2._FSI_Canceled=true;aN.call(I,a2,v,F)}if(typeof(aX.onGestureStart)=="function"){L(a2);aX.onGestureStart.call(I,a2,aR,F)}}}else{if(a3<1){ag()}}am.pointerCount=a3;w=false;if(a3===1){if(at.captureScroll){w=true}}else{if(at.capturePinch&&am.nType===1){w=true}}}return am.started};var ag=function(){if(!am.timeoutRestartDown){return}clearTimeout(am.timeoutRestartDown);am.timeoutRestartDown=b};var C=function(){if(ac!==1){return}g(W);ag()};var L=function(a2){a2._FSI_Gesture=am.name;a2._FSI_GestureType=am.nType;a2._FSI_PointerCount=am.nPointers};var P=function(a2){if(!am.started){return}am.started=false;if(!a2){a2={}}if(am.nType===1&&typeof(aX.onPinchEnd)=="function"){L(a2);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchEnd.call(I,a2,aR,F)}if(typeof(aX.onGestureEnd)=="function"){L(a2);aX.onGestureEnd.call(I,a2,aR,F)}am.name="none";am.nType=0;if(a2&&ac===1){ag();am.timeoutRestartDown=setTimeout(C,20)}};an()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!==b){return}a.Callbacks=function(f,m,k,c){if(typeof(m)!=="object"||typeof(m.cfg)!=="object"){m={cfg:{}}}if(typeof(k)!=="object"){k={}}var l=this;var q=0;var s={};var t=0;var g={};var n=new a.EmptyDebugger();var p={};var w={reg:{}};var o;var v={};var j;var r=function(){if(f){f.dumpListeners=l.dumpReg}};this.destroy=function(){if(n.on){this.removeConfigListeners();if(q>0){n.warn("WARNING: "+q+" listener(s) have not been removed:");for(var x in g){if(g.hasOwnProperty(x)){if(g[x].count>0){a.console.logCSS(g[x].dump(),"color:blue;","color:green;")}}}}}m={cfg:{}};this.checkListenerChanges()};this.removeConfigListeners=function(){for(var x in s){if(s.hasOwnProperty(x)){var y=s[x];if(y!==false){d(y.evt,y.fn)}}}s={}};this.setDebug=function(x){n=x};this.setConfig=function(x){l.removeConfigListeners();m=x};var u=function(A){if(!g[A]){if(s[A]===b){var z;var y=A.toLowerCase();var B=m.cfg[y];var x=typeof(B);if(x!=="undefined"){if(x==="function"){z=B}else{if(x==="string"&&typeof(window[B])==="function"){z=window[B]}}if(z&&h(A,z,f,true)){s[A]={evt:A,fn:z}}else{s[A]=false}}}if(!g[A]){g[A]=new e(A)}}return g[A]};var h=this.addListener=function(z,x,y,B){if(typeof(x)!="function"){n.error("Failed to add listener for "+z+". The function argument is not a function.");return false}var A;if(g[z]===b){A=g[z]=new e(z)}else{A=g[z]}A.addFunction(x,y,B);return true};var d=this.removeListener=function(y,x){var z=g[y];if(z===b||typeof(x)!="function"||x.__FSICallbackFunctionID===b){n.error("Unable to remove listener: no callback for "+y+" registered");return false}return z.removeFunction(x)};this.watchListeners=function(y,x){o=x;v=y;j=false;for(var z in y){if(y.hasOwnProperty(z)){j=true;l.isset(z);w.reg[z]=b}}w.bDirty=true;l.checkListenerChanges()};var i=function(x){if(v[x]){w.bDirty=true;if(w.reg[x]===b){w.reg[x]=g[x].count}if(w.nTimeout===b){w.nTimeout=setTimeout(l.checkListenerChanges,5)}}};this.checkListenerChanges=function(){if(typeof(o)==="function"){if(w.nTimeout!==b){clearTimeout(w.nTimeout);w.nTimeout=b}if(w.bDirty){var z={};for(var x in w.reg){if(w.reg.hasOwnProperty(x)){var y=(g[x]!==b&&g[x].count>0);var A=(w.reg[x]===b)?b:(w.reg[x]>0);if(y!==A){z[x]=y}}}o.apply(l,[z]);w.bDirty=false;w.reg={}}}};this.dumpReg=function(){var A;var B;if(f&&f.getAPIData){B=f.getAPIData().oCallbacks}if(B){for(A in B){if(B.hasOwnProperty(A)){u(A)}}}var x;if(n&&n.on){x=n}else{x=a.console}var y=[];x.group("Total listeners: "+q);for(A in g){if(g.hasOwnProperty(A)){y.push(g[A].dump())}}y.sort();for(var z=0;z<y.length;z++){x.logCSS(y[z],"color:blue;","color:green;")}x.groupEnd()};this.isset=function(x){return(u(x).count>0)};this.runPersistent=function(y,x){l.run(y,x);p[y]=[x]};this.run=function(C,z){var y;var E=u(C);if(E.count>0){var x=E.getFunctionsArray();for(var B=0;B<x.length;B++){var D=x[B];D.countCalled++;var A=D.fn.apply(D.scope,z);if(A!==b){y=A;if(E.handleCallbackResult){y=E.handleCallbackResult(y,z)}}}}return y};var e=function(B){var y=this;this.count=0;var C=false;var A;var z={};var x={};this.addFunction=function(E,F,J){if(j&&y.count===0){i(B)}q++;y.count++;C=true;if(F===b){F=f}var D=E.__FSICallbackFunctionID;if(D===b){D=E.__FSICallbackFunctionID=a.utils.getNewCallbackFunctionID()}if(x[D]===b){x[D]=[]}x[D].push(t);z[t]={fn:E,scope:F,countCalled:0};if(n.on){var I=x[D].length;if(I>1){var H="";try{H=" "+E.name+"()"}catch(G){}n.error(I+" listeners for "+B+" have been added for the same function "+H+". Did you forget to remove a listener?")}if(y.count>20){n.error(I+" listeners for "+B+" have been added for this instance. Did you forget to remove a listener?")}}if(typeof(k[B])==="function"){y.handleCallbackResult=k[B]}if(p[B]!==b){if(!c||c(B,p[B],J)){E.apply(F,p[B][0])}}t++};this.getFunctionsArray=function(){if(C){A=[];var D=z;for(var E in D){if(D.hasOwnProperty(E)){if(typeof(D[E].fn)==="function"){A.push(D[E])}}}C=false}return A};this.removeFunction=function(G){var E=G.__FSICallbackFunctionID;var D=x[E];if(D===b){if(n.on){var I="this function";try{I="the function "+G.name}catch(H){}n.error("Unable to remove listener: no callback for "+B+" registered for "+I)}return false}var F=D.pop();if(j&&y.count===1){i(B)}q--;y.count--;if(D.length===0){delete x[E]}C=true;delete z[F]};this.dump=function(){var F;if(y.count===0){F="%c"+B+": %c no listeners"}else{if(y.count===1){F="%c"+B+": %c"+y.count+" listener"}else{F="%c"+B+": %c"+y.count+" listeners"}}var E=y.getFunctionsArray();if(E&&E.length>0){for(var G=0;G<E.length;G++){try{var I=E[G].fn.name;if(typeof(I)!=="string"||I.length===0){I="anonymous"}}catch(H){I="anonymous"}F+="\n - "+I;var D=E[G].countCalled;if(D===0){F+=" (not called yet)"}else{if(D===1){F+=" (called once)"}else{F+=" (called "+E[G].countCalled+" times)"}}}}return F}};r()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.MetaDataReplacer!==b){return}a.MetaDataReplacer=function(d){d=d||{};var r=this;var o={};var e;var p=new RegExp("###[a-z0-9 .]+###","ig");var g=new RegExp("^language.","i");var n;var l;var c={};var m;var k;var q=function(){h();if(d.oLanguageData){r.setLanguageData(d.oLanguageData)}if(d.fnCallbackReplace){r.setReplaceCallback(d.fnCallbackReplace)}if(d.strLocale){r.setLocale(d.strLocale)}};var j=function(t){if(typeof(t)!=="string"){t=""}var F,D;var A={};A.strContentRaw=t;A.bHasPlaceHolders=false;var z,v,C,w;var y=t.match(p);if(y){F=D=t;A.strContentNoTemplates=t.replace(p,"");A.bHasPlaceHolders=true;var u=y;var s;var E=new RegExp(/^###/);var B=new RegExp(/###$/);A.oAllTemplates={};A.oNoMetaDataTemplates={};A.oMetaDataTemplates={};A.nTemplates=u.length;A.arAllReplacers=[];A.arMetaDataReplacers=[];A.arNoMetaDataReplacers=[];for(var x=0;x<u.length;x++){C=v=u[x];w=C.replace(E,"").replace(B,"");C=w.toLowerCase();if(!A.oAllTemplates[C]){A.oAllTemplates[C]=true;z=new RegExp(v,"ig");if(!k[C]&&!C.match(g)){D=D.replace(z,"");A.bNeedsMetaData=true;A.oMetaDataTemplates[C]=true;s=f(w,v);A.arMetaDataReplacers.push(s)}else{F=F.replace(z,"");s=f(w,v);A.arNoMetaDataReplacers.push(s);A.oNoMetaDataTemplates[C]=true}A.arAllReplacers.push(s)}}A.strContentMetaTemplatesOnly=F;A.strContentNoMetaTemplates=D;if(A.oAllTemplates["image.width"]||A.oAllTemplates["image.height"]){A.bNeedsImageDim=true}}else{A.bHasPlaceHolders=false;A.strContentNoTemplates=t}return A};var f=function(z,x){var C=z.toLowerCase();if(!c[C]){var s=new RegExp(x,"ig");var u;var A;var t;var B=z.split(".");if(B.length<2){u=function(){return"invalid key"}}else{z=z.toLowerCase();var w=B[0]+"."+B[1];w=w.toLowerCase();if(B[3]!=="raw"){t=n[z]}switch(w){case"image.index":u=function(D){return D.nIndex};break;case"image.number":u=function(D){return D.nIndex+1};break;case"image.width":u=function(D){return D.sourceWidth};break;case"image.height":u=function(D){return D.sourceHeight};break;case"image.filepath":u=function(D){return D.imagePath};break;case"image.filename":u=function(E){var D=E.imagePath.split("/");D=D[D.length-1];return D};break;case"image.filedir":u=function(E){var D=E.imagePath.split("/");D.pop();D=D.join("/");return D};break;default:var v=B[0];var y=B[1];if(v==="language"){u=function(){return o[y]||""}}else{v=v.toLowerCase();if(v==="general"){u=function(D){A=(D.oMetaData.general!==b)?D.oMetaData.general:D.oMetaData;return A[y]||""}}else{u=function(D){A=D.oMetaData[v];return(A&&A[y]!==b)?A[y]:""}}}break}}c[C]=function(F,D){var E=D._fsi_MetaDataReplacer_cache[z];if(E===b){E=u(D);if(t){E=t(E)}if(l){E=l(z,E)}D._fsi_MetaDataReplacer_cache[z]=E}return F.replace(s,E)}}return c[C]};var i=function(v,t,u){if(!t._fsi_MetaDataReplacer_cache){t._fsi_MetaDataReplacer_cache={}}for(var s=0;s<u.length;s++){v=u[s](v,t)}return v};var h=function(){e=d.oNumberSeperators;k={"image.index":true,"image.number":true,"image.filename":true,"image.filepath":true,"image.filedir":true};if(d.bItemsHaveWidthAndHeight){k["image.width"]=true;k["image.height"]=true}var v=a.utils.makeNiceNumber;var s=a.utils.makeNiceFileSize;var x=function(z){var y;z=parseInt(z);if(isNaN(z)){y="---"}else{y=v(parseInt(z),0,e)}return y};var u=function(z){var y;z=parseInt(z);if(isNaN(z)){y="---"}else{y=s(z,e)}return y};var w=new Date();var t;if(typeof(w.toLocaleDateString)==="function"){t=function(z){var y;z=parseInt(z);if(isNaN(z)){y="---"}else{y=new Date(z).toLocaleString(m)}return y}}else{t=function(z){var y;z=parseInt(z);if(isNaN(z)){y="---"}else{y=new Date(z).toString(m)}return y}}n={"general.size":u,"image.width":x,"image.height":x,"image.index":x,"image.number":x,"general.lastmodified":t}};this.destroy=function(){c={}};this.setLanguageData=function(s){o=s};this.setLocale=function(s){m=s};this.setReplaceCallback=function(s){if(typeof(s)==="function"){l=s}else{l=false}};this.parseTemplate=j;this.replaceBasic=function(t,s){return i(s.strContentNoMetaTemplates,t,s.arNoMetaDataReplacers)};this.replaceMetaData=function(t,s){return i(s.strContentMetaTemplatesOnly,t,s.arMetaDataReplacers)};this.replaceAll=function(t,s){return i(s.strContentRaw,t,s.arAllReplacers)};q()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.API.ThumbBar!==b){return}a.utils.API.ThumbBar=function(d,e){var c=this;c.scriptMainFile="FSI.ThumbBar.js";c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addImages:{a:"arPathsOrObjects"},addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},assignFSIViewer:{a:"iFSIViewerInstance"},buttonDown:{a:"strCommand",r:"bSuccess"},buttonUp:{r:"bSuccess"},changeConfig:{a:"strCfgFileName, oParameters"},changeDir:{a:"strDirectory",r:"bSuccess"},closeZoom:{a:"evt, bImmediate"},destroy:{},dumpListeners:{},firstImage:{a:"nAnimationFrames"},focusImage:{a:"nImage"},getBuild:{r:"strBuild"},getCurrentImageIndex:{r:"nIndex"},getConfigValue:{a:"strName",r:"mixed"},getImageCount:{r:"nImages"},getInitDone:{r:"bDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getParameters:{r:"oParameters"},getScrollPos:{r:"fPosition"},getVersion:{r:"strVersion"},init:{a:"elementID, oParameters, bDebug"},isScrolling:{r:"bScrolling"},lastImage:{a:"nAnimationFrames"},nextImage:{a:"nAnimationFrames"},nextPage:{a:"nAnimationFrames"},previousImage:{a:"nAnimationFrames"},previousPage:{a:"nAnimationFrames"},printAPI:{},registerButton:{a:"DOMElement, strCommand",r:"bSuccess"},removeAllImages:{r:"bSuccess"},removeImages:{a:"arIndice"},setScrollPos:{a:"fPosition, nAnimationFrames",r:"fPosition"},startAutoRotate:{a:"fSpeed"},stopAutoRotate:{},removeListener:{a:"strListenerName, fn",r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},unRegisterButton:{a:"DOMElement",r:"bSuccess"},zoomImage:{a:"nImage"}};c.oCallbacks={onAfterReplaceLabelTemplates:{a:"strLabel, oItem",r:"strNewLabel"},onBeforeReplaceLabelTemplates:{a:"strLabel, oItem",r:"strNewLabel"},onChangeConfig:{a:"strConfigFileName, oParameters"},onClick:{a:"nIndex, oItem"},onConfigsReady:{a:"oConfigValues"},onDestroy:{},onFocus:{a:"nImageIndex, strImagePath"},onInit:{a:"oParameters)"},onMetaData:{a:"oItem, oMetaData"},onMouseEnter:{a:"nIndex, oItem)"},onMouseLeave:{a:"nIndex, oItem)"},onReady:{},onReplaceTemplateValue:{a:"name, value",r:"newValue"},onResize:{a:"nWidth, nHeight, bResizeDone"},onScrollStart:{a:"fPosition"},onScrollEnd:{a:"fPosition"},onSetScrollRange:{a:"fTotalSize, fRange, bEndlessScrolling, nTotalImages"},onStart:{a:"strDirectory, nImages, arImagePaths"},onZoomEnd:{},onZoomReady:{a:"nImageIndex, strZoomedImageURL, elZoomedImage"},onZoomStart:{a:"nImageIndex, strImageURL"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ThumbBar!==b){return}a.ThumbBar=function(ep,cQ){var eH={};var af={strVersion:"2019",strBuild:"19.10.6785",strConfigSection:"ThumbBar",bHasListeners:true};var bB=new a.utils.ClassDef(this,"FSI ThumbBar",af);bB.oAPI=new a.utils.API.ThumbBar(this,eH);var aE=bB.instance;a.utils.guessFSIViewerLocation("fsithumbbar.js",3);var cn=a.utils.getViewerInstanceID();this.getInstanceID=function(){return cn};this.getInstanceName=function(){return bB.strClassName+" ["+D+"]"};var cI=(cQ)?a.utils.cloneParameters(cQ):{};var dN;var dp;var cf;var du;var cp={};var b2,dt,eE;var eh,v,eX;var bj;var U;var bJ;var bt={};var ay;var cg,d3,ev;var aN={};var X;var b1={};var e1;var bR=0;var dH;var aB;var ce;var ew;var aT;var y;var D;var cF;var a6,aQ;var ca,dO;var cB=0;var dw=0;var er=false;var dj;var c0,ct,cH,T,R;var di;var c1;var d0={};var ag;var ey=false;var bH;var at;var cC;var aH,av,ba;var G;var c9={};var cx;var dm;var ad;var eL=[];var da,H;var ab;var bk,eA;var eT;var d;var bE;var dT=100;var a3;var cG=0;var cl={};var dB;var cN=0;var e;var eQ=false;var d6=0;var cJ;var dR;var V;var eG={};var b0={};var dq={};var ea;var S;var ap;var B,ai;var dZ;var a7;var bq;var c8;var bY={};var cu,cd;var ee;var ar;var aC={};var I;var ex=false;var em;var bv;var by=false;var cs=false;var F;var cz,ec;var a9;var dx=false;var aU;var e0;var aY;var dc;var cY;var eN;var aa,dP,bh;var dG=0;var aR=0;var aJ;var dJ;var dI,bK;var bF=[];var a8;var Z;var eO={};var cO;var bp=(a.isMobileDevice)?" mobile":"";var aX={};var bs={};var cr,dD;var db={};var ak;var c6;var d7=0;var dS;var j;var c2;var b9;var ez;var dy={};var dY;var au;var bf;var bZ={};var dQ=0;var dE=0;var a5=512;var dA={ts:0,dist:0};var dv={passive:true,capture:false};var bg=/((\?)|&)(width|height)=[^&]*/ig;var bL=("filter" in document.body.style)?"filter":"webkitFilter";var x;var ds;var aK;var cL;var Y=0;var d9=(a.isMobileDevice)?8:16;var ax=[];var a2=0;var ah,f,i;var dV="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";var eS=true;var en;var eF;var l;var q;var r;var aD;var aS={strings:{dir:"",fpxservertemplate:"",effects:"",overlays:"",quality:"",cropRect:"",cropValues:"",format:"",presentationType:"flat",elementWidth:"10%",elementSpacing:"0.25%",placeHolderImage:"default",placeHolderPadEffect:"Pad(CC,FFFFFF)",metaDataTemplate:"details.json",autoCrop:""},booleans:{autoDestroy:true,autoResize:true,depthFadeout:true,enableZoom:true,ScrollBar:true,centerZoomedImage:true,endlessScrolling:false,useTouchZoom:true,vertical:false,autoElementSpacing:true},floats:{autoRotateSpeed:0,Alignment:1,ContainerAlignment:0,PerspectiveAlignment:1,zoomShaderStartOpacity:0,zoomShaderEndOpacity:0.8},integers:{minElementWidth:24,minElementSpacing:0,initialImage:0,preloadCount:40,paddingTop:10,paddingBottom:0,garbageCollectionSize:-1,zoomMargin:40}};var cc=new a.EmptyDebugger();var eY=function(e4,e3){if(e3&&!cc.on&&e4.on){if(em){em.stopPendingRequests()}aE.destroy(true);aE.init(en,cI,true);return true}cc=e4;if(cc.on){cc.setPrefix(aE.getInstanceName())}};var b7=function(e4,e9,e3){var e6;var e5;en=e4;if(!e4){return}if(typeof(e4)==="object"){if(typeof(e4.id)==="string"){D=e4.id}}else{if(typeof(e4)==="string"){D=e4}}if(!D){D="fsi.thumbbar #"+cn}if(aE._fsi_parameters){e9=aE._fsi_parameters;delete aE._fsi_parameters}if(typeof(e4)==="object"&&e4.tagName!==b){e6=e4}else{e6=document.getElementById(e4)}if(!e6){return}if(er){aE.destroy()}e6.setAttribute("data-fsi-id",D);cI=(e9)?a.utils.cloneParameters(e9):cI;var fa={};fa.onConfigsReady=cA;fa.onDebuggerChange=eY;em=new a.Config(null,fa,{strSection:bB.strConfigSection});bv=eH.iCallbacks=new a.Callbacks(aE,em);if(bv.isset("onInit")){bv.runPersistent("onInit",[cI])}var e8=cI;if(e3){e8=a.utils.cloneObject(cI);e8.debug=true}em.init(e8);cc.log(aE.getVersion());dj=e6;e6.innerHTML="";ah=document.createElement("img");ah.crossOrigin="anonymous";ah.setAttribute("loading","eager");f=document.createElement("div");f.className="fsi-thumbbar-thumbnail";i=document.createElement("p");i.className="fsi-thumbbar-label";c0=document.createElement("div");var e7="fsi-thumbbar-root";if(a.isMobileDevice){e7+=" mobile"}c0.className=e7;e5="position:relative;width:100%;height:100%;border:0 none;margin:0px;padding:0px;overflow:hidden;";a.utils.setStyleAttr(c0,e5);ct=document.createElement("div");ct.className="fsi-thumbbar-container";e5="position:absolute;z-index:1;width:100%;height:100%;border:0 none;margin:0px;padding:0px;";e5+="text-align:left;vertical-align:top;";e5+="perspective:100px;perspective-origin:50% 100%;pointer-events:none;";if(a.isInternetExplorer){e5+="transform-style:preserve-3d;"}else{e5+="transform-style:flat;"}a.utils.setStyleAttr(ct,e5);c0.appendChild(ct);dj.appendChild(c0);aO();er=true;ew={};em.loadConfigs()};this.getConfigValue=function(e3){if(em&&typeof(e3)==="string"){return em.cfg[a.trim(e3.toLowerCase())]}};this.getParameters=function(){return a.utils.cloneParameters(cI)};var eB=function(e4){if(c9.bImageDragging){return}if(a.now()-dA.ts<25&&dA.dist>10){return}dA.ts=0;cH.style.pointerEvents="none";ct.style.pointerEvents="all";var e3=document.elementFromPoint(e4.clientX,e4.clientY);if(e3){var e5=e3.oSprite;if(!e5&&e3.parentNode){e5=e3.parentNode.oSprite}if(e5){bu(e5)}}cH.style.pointerEvents="all";ct.style.pointerEvents="none"};var bu=function(e3){if(bv.isset("onClick")){bv.run("onClick",[e3.nIndex,e3])}if(ew.enableZoom){K(e3)}if(ew.centerZoomedImage){be(e3)}};var bG=function(e3){if(e3===cH[G]){return}cH[G]=e3;c9.bIgnoreEvent=true;c9.bIgnoreEventPos=cH[G]};var dW=function(){if(c9.bIgnoreEvent){c9.bIgnoreEvent=false;var e6=c9.bIgnoreEventPos;c9.bIgnoreEventPos=false;if(cH[G]===e6){return}}if(c9.bImageDragging){if(!y.isAfterTouchRunning()){return}}var e4=(cC)?cH.offsetHeight:cH.offsetWidth;if(e4!==U){return}var e3=cH[G];var e5=cJ;if(V){e5=bQ(e3,dG)}N(-e3,true,e5,1)};var bQ=function(e3,e6){var e5;var e4=Math.abs(Math.round(e3+e6));if(e4<20){e5=0}else{e5=Math.floor(Math.max(0,Math.min(20,e4/45)))}return e5};var ac=function(){eo();dG=0};var eP=function(){aI();ax=[];for(var e3=0;e3<bF.length;e3++){bw(bF[e3])}cP();ab={};bZ={};d0={};ax=[];bF=[];dQ=0;dw=0;cN=0;dX()};var eo=function(){if(aB){clearTimeout(aB);aB=b}bJ=b;aT=b;ao();eP();if(bq){bq.style.display="none"}cr=0;return true};var cA=function(){eo();if(bv.isset("onConfigsReady")){bv.runPersistent("onConfigsReady",[a.utils.cloneObject(em.cfg)])}ea={};ea.nLabelHeight=0;ea.elContainer=f.cloneNode(true);cY=b;eN=b;em.loadLanguageFile(aN,em.cfg.language,ek,cc)};var ek=function(e4){cg=e4;d3=e4.locale||"en-US";if(ay){ay.setLanguageData(cg);ay.setLocale(d3)}ev=a.utils.getNumberSeperators(em);bv.runPersistent("onLanguageData",[cg]);var e3=em.cfg.viewerselector;if(!e3){e3=em.cfg.viewerid}if(e3){aE.assignFSIViewer(e3)}else{br()}};var br=function(){var e4=em.cfg.dir;if(!e4||e4.length===0){var e3=em.getImageList();if(e3){aZ(e3.arImages,e3)}else{aZ([],{})}}else{em.loadImageList(em.cfg.dir,aZ)}};var dd=function(e3,e4){bv.run("onChangeConfig",[e3,e4]);if(cc.on){a.console.log("")}if(e4!==null&&typeof(e4)==="object"){cI=a.utils.cloneParameters(e4)}if(typeof(e3)==="string"){cI.cfg=e3}aE.destroy(true);cc=new a.EmptyDebugger();aE.init(en,cI)};var eV=function(e3){if(typeof(e3)!=="string"){return false}ac();em.cfg.dir=e3;cA();return true};var aZ=function(e3,e4){if(!er){return}if(!e3){e3=[]}cY=e4;eN=(cY&&cY.images&&cY.images[0]&&cY.images[0].width!==b&&cY.images[0].height!==b);eL=e3;d6=e3.length;cc.log("Image list loaded ("+eL.length+" images)");cE();aP()};var cE=function(){bo(ew)};var el=function(e4,e3,e7,e5){for(var e6 in e7){if(e7.hasOwnProperty(e6)){e3[e6]=e4.getFloatParameter(e5+e6,e7[e6])}}};var cM=function(e4,e3,e7,e5){for(var e6 in e7){if(e7.hasOwnProperty(e6)){e3[e6]=e4.getIntParameter(e5+e6,e7[e6])}}};var b8=function(e5,e4,e3,e6){for(var e7 in e3){if(e3.hasOwnProperty(e7)){e4[e7]=e5.getStringParameter(e6+e7,e3[e7])}}};var s=function(e4,e3,e6,e5){for(var e7 in e6){if(e6.hasOwnProperty(e7)){e3[e7]=e4.makeBool(e4.getStringParameter(e5+e7),e6[e7])}}};var bT=function(e4,e3,e6,e5){var e7;if(e6&&e6.length>0){if(e3[e6]===b){e3[e6]={}}e5=e5[e6];e7=e3[e6]}else{e7=e3}if(e5.strings){b8(e4,e7,e5.strings,e6)}if(e5.booleans){s(e4,e7,e5.booleans,e6)}if(e5.floats){el(e4,e7,e5.floats,e6)}if(e5.integers){cM(e4,e7,e5.integers,e6)}};var bo=function(e3){if(e3===b){e3={}}e3.serverBase=em.serverBase;bT(em,e3,"",aS);var e6=/[\dabcdef]{3,6}/i;for(var e7 in aS.strings){if(aS.strings.hasOwnProperty(e7)){if(e7.indexOf("Color")!==-1){var e5=ew[e7];if(e5.indexOf("#")!==0){var e4=e5.match(e6);if(e4){if(e4[0].length===e5.length&&(e4[0].length===3||e4[0].length===6)){ew[e7]="#"+e4[0]}}}}}}};var am=function(e5){var e4,e3;if(typeof(e5)==="string"){e3=e5.indexOf("%");e4=parseFloat(e5)}else{e3=-1;e4=e5}if(e3!==-1){e4=Math.round(aa.width*e4/100)}return{val:e4,bRelative:(e3!==-1)}};var dK=function(){var e8,e4;var e6=function(fb,fa){var e9=fa(fb);e9.width=e9.left+e9.right;e9.height=e9.top+e9.bottom;return e9};var e3=function(fb,e9){for(var fa in fb){if(fb.hasOwnProperty(fa)){fb[fa]+=e9[fa]}}};var e7={};e7.nIndex=-1;e7.elContainer=f.cloneNode(true);e7.img=ah.cloneNode(false);e7.elContainer.appendChild(e7.img);bl(e7,true);b2=e6(e7.elContainer,a.utils.getElementBorders);dt=e6(e7.elContainer,a.utils.getElementMargins);eE=a.utils.cloneObject(b2);e3(eE,dt);eh=e6(e7.img,a.utils.getElementBorders);v=e6(e7.img,a.utils.getElementMargins);eX=a.utils.cloneObject(eh);e3(eX,v);bw(e7,true);e8=am(ew.elementWidth);if(isNaN(e8.val)){e8=am(aS.strings.elementWidth)}var e5=am(ew.minElementWidth);if(isNaN(e5.val)){e5.val=aS.integers.minElementWidth}if(e5.val>e8.val){e8=e5}e4=bY.width=e8.val;if(cC){cL=e4-Math.ceil(eE.height+eX.height)}else{aY=e4-Math.ceil(eE.width+eX.width)}bY.widthRelative=e8.bRelative;e8=am(ew.elementSpacing);if(isNaN(e8.val)){e8=am(aS.strings.elementSpacing)}e5=am(ew.minElementSpacing);if(isNaN(e5.val)){e5.val=aS.integers.minElementSpacing}if(e5.val>e8.val){e8=e5}dc=bY.spacing=e8.val;bY.spacingRelative=e8.bRelative;c3()};var z=function(){if(!cH){return}a.removeEvent(cH,"scroll",dW,dv);a.removeEvent(cH,"click",eB);if(l!==b){a4()}if(!a.isMobileDevice){a.removeEvent(cH,"mouseenter",J)}c0.removeChild(cH);cH=b};var aO=function(){cH=document.createElement("div");cH.className="fsi-thumbbar-scroll-bar";var e3="z-index:2;width:100%;height:100%;margin:0px;padding:0px;border:0 none;position:absolute;overflow:hidden;-webkit-overflow-scrolling:touch;";a.utils.setStyleAttr(cH,e3);R=document.createElement("div");a.utils.setStyleAttr(R,"width:1px;height:1px;visibility:hidden;");cH.appendChild(R);c0.appendChild(cH);a.addEvent(cH,"scroll",dW,dv);a.addEvent(cH,"click",eB);if(!a.isMobileDevice){a.addEvent(cH,"mouseenter",J)}};var eK=function(){if(!T){return}a.removeEvent(T,"scroll",W,dv);a.removeEvent(T,"mouseup",bI);a.removeEvent(T,"pointerup",bI);a.removeEvent(T,"touchend",bI);c0.removeChild(T);T=b};var t=function(){if(a.isInternetExplorer&&I>0){cH.style.display="";if(!T){cc.info("Using scroll bar optimization");T=document.createElement("div");T.className="fsi-thumbbar-scroll-bar fake";var e3="z-index:20;width:0px;height:0px;margin:0px;padding:0px;border:0 none;position:absolute;overflow:hidden;-webkit-overflow-scrolling:touch;";a.utils.setStyleAttr(T,e3);c0.appendChild(T);a.addEvent(T,"scroll",W,dv);a.addEvent(T,"mouseup",bI);a.addEvent(T,"pointerup",bI);a.addEvent(T,"touchend",bI)}T.style.overflowX=cH.style.overflowX;T.style.overflowY=cH.style.overflowY;while(T.firstChild){T.removeChild(T.firstChild)}T.appendChild(R.cloneNode(false));if(cC){T.style.width=I+"px";T.style.height="100%";if(eS){T.style.bottom="";if(!c6){T.style.right="0px"}else{T.style.right=-I+"px"}cH.style.width=(cH.offsetWidth+I)+"px"}}else{T.style.width="100%";T.style.height=I+"px";if(eS){if(!c6){T.style.bottom="0px"}else{T.style.bottom=-I+"px"}T.style.right="";cH.style.height=(cH.offsetHeight+I)+"px"}}a7=an;bq=T;di=true}else{eK();a7=a.fnDoNothing;bq=cH;di=false;if(c6){cH.style.display="";if(cC){cH.style.width=(cH.offsetWidth+I)+"px"}else{cH.style.height=(cH.offsetHeight+I)+"px"}}else{cH.style.display="none";cH.style.width=cH.style.height="100%"}}};var an=function(e3){T[G]=e3;c9.bIgnoreFakeEvent=true;c9.bIgnoreFakeEventPos=T[G]};var bI=function(){bG(-dG)};var W=function(){if(c9.bIgnoreFakeEvent){c9.bIgnoreFakeEvent=false;var e6=c9.bIgnoreFakeEventPos;c9.bIgnoreFakeEventPos=false;if(T[G]===e6){return}}var e4=(cC)?T.offsetHeight:T.offsetWidth;if(e4!==U){return}var e3=T[G];var e5=cJ;if(V){e5=bQ(e3,dG)}N(-e3,true,e5,2)};var aP=function(){X={tpl:ew.metaDataTemplate};if(ew.autoCrop.length===2){b1.cropToFill=ew.autoCrop}else{b1.cropToFill=false}ej();eA=ew.initialImage;r=ew.useTouchZoom;if(r){if(typeof(a.TouchZoom)==="function"){ci()}else{aD=true;a.addEvent(window,"FSITouchZoomLoaded",ci)}}else{bm()}cC=ew.vertical;F=ew.presentationType.toLowerCase();by=ew.endlessScrolling;cr=eL.length;aa=bh=dP=cD();ds=ew.autoRotateSpeed;dK();da=a.utils.cloneArray(eL);if(cY&&cY.images){H=a.utils.cloneArray(cY.images)}else{H=b}ab={};if(ew.autoResize===true){if(e0===b){e0=a.addCustomEvent(dj,"FSIElementDimension",aA);a.setCustomEventListenerProperty(e0,"treshold",200)}}else{if(e0!==b){a.removeCustomEvent(dj,"FSIElementDimension",aA);e0=b}}aw()};var eJ=function(){var e5=bB.strClassName;if(!a.utils.cssClassExists(e5)){var e3="div.fsi-thumbbar-container .fsi-thumbbar-thumbnail{\n\tposition:absolute!important;\n\ttransform-origin: center;\n\tbox-sizing: content-box;\n\toverflow: hidden;\n\ttext-align:center;\n\tpadding:0!important;\n}\n";e3+="div.fsi-thumbbar-container .fsi-thumbbar-thumbnail > img{\n\tborder:0 none;\n\tmargin:0;\n\tdisplay:inline;\n\tbox-sizing: content-box;\n}\n";e3+="div.fsi-thumbbar-container .fsi-thumbbar-thumbnail p.fsi-thumbbar-label{\n\tposition:absolute;\n\twidth:100%;\n\tbox-sizing:border-box;\n\tbottom:0;\n\twhite-space: nowrap;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tbackground-color:#EEE;\n\tcolor:#000;\n\tfont-family:sans-serif;\n\ttext-align:center;\n\tvertical-align:middle;\n\tpadding:2px;\n\tmargin:0;\n\tfont-size:12px;\n\tline-height:normal;\n\tz-index: 1;\n}\n";e3+="div.fsi-thumbbar-container.stacks,\ndiv.fsi-thumbbar-container.ring {\n\t-webkit-transform: translate3d(0, 0, 0);\n\ttransform: translate3d(0, 0, 0);\n\t-moz-backface-visibility: hidden;\n\t-ms-backface-visibility: hidden;\n\t-webkit-backface-visibility: hidden;\n\tbackface-visibility: hidden;\n}\n";e3+="div.fsi-thumbbar-container.custom,\ndiv.fsi-thumbbar-container.ring img{\n\twill-change: transform,filter;\n}\n";e3+="div.fsi-thumbbar-container.stacks img{\n\twill-change: transform;\n}\n";e3+="div.fsi-thumbbar-container img.placeholder.none{\n\tdisplay:none;\n}\n";e3+="div.fsi-thumbbar-container img.placeholder.blank{\n\tbackground-color:#eee;\n}\n";var e4="R0lGODlhFwAXAIABAMzMzAAAACH5BAEAAAEALAAAAAAXABcAAAI5jI+py30AYwyyoiophncDvXWh9z0eiIkpqVqsOZ7wKjt2m70Gq6Nu7csBecNTjxia/ZI7I/AGjSYKADs=";e3+="div.fsi-thumbbar-root div.fsi-thumbbar-container img.placeholder.default,\ndiv.fsi-thumbbar-root div.fsi-thumbbar-container img.placeholder.custom{\n\tbackground-color:#eee;\n\twidth:100%;\n\theight:100%;\n\tbackground-position:center center;\n\tbackground-repeat:no-repeat;\n\tbackground-image:url(data:image/gif;base64,"+e4+");\n}\n";e3+="div.fsi-thumbbar-shader{\n\tposition:absolute;\n\tz-index:10000;\n\tbox-sizing:border-box;\n\tbackground-color:#FFF;\n\topacity:0;\n}\n";e3+="div.fsi-thumbbar-zoom-div{\n\tposition:absolute;\n\tz-index:10001;\n\tmargin:0px!important;\n\tbox-sizing:content-box;\n\tbackground-color:#FFF;\n\tline-height:0;\n}\n";a.utils.addCSSClass(e5,e3)}};var a0=function(e4){var e3;if(eN&&cY.images[e4]){e3=cY.images[e4]}return e3};var aM=function(e4){var e3=typeof(e4);if(e3==="string"){e4=window[e4];e3=typeof(e4)}return(e3==="function")?e4:false};var aw=function(){var e4;ec=b;if(cC){G="scrollTop";aH=ef;av=dl;ba=cv}else{G="scrollLeft";aH=w;av=eI;ba=d2}a2++;bR=parseFloat(em.cfg.containeralignment);if(isNaN(bR)){e4=(em.cfg.containeralignment)?em.cfg.containeralignment:"";switch(e4){case"right":case"bottom":bR=1;break;case"center":case"middle":bR=0.5;break;default:bR=0}}else{bR=Math.max(0,Math.min(1,bR))}cx=parseFloat(ew.Alignment);if(!isNaN(cx)){if(typeof(em.cfg.alignment)!=="string"||em.cfg.alignment.toLowerCase()!=="false"){if(cC){e4="center";if(cx<0.25){e4="left"}else{if(cx>0.75){e4="right"}}f.style.textAlign=e4}else{e4="middle";if(cx<0.25){e4="top"}else{if(cx>0.75){e4="bottom"}}ah.style.verticalAlign=e4}}}dm=ew.PerspectiveAlignment;if(!ew.depthFadeout){at=false}else{at=(!a.isInternetExplorer||a.versionInternetExplorer>11)}var e3=S={};if(ew.effects.length>0){e3.effects=ew.effects;eT="&effects="+ew.effects}else{eT=""}if(ew.overlays.length>0){e3.overlays=ew.overlays}if(ew.quality.length>0){e3.quality=ew.quality}if(ew.format.length>0){e3.format=ew.format}if(ew.fpxservertemplate.length>0){e3.renderer=ew.fpxservertemplate}eJ();aI();ex=false;cH.style.display="";if(cC){cH.style.width="100%";ad=-1;cH.style.overflowX="hidden";cH.style.overflowY="auto";R.style.height=2*aa.width+"px";I=(cH.offsetWidth-cH.scrollWidth);U=cH.offsetHeight}else{cH.style.height="100%";ad=1;cH.style.overflowX="auto";cH.style.overflowY="hidden";R.style.width=2*aa.width+"px";I=(cH.offsetHeight-cH.scrollHeight);U=cH.offsetWidth}cH.style.display="none";c6=!ew.ScrollBar;ak=(eL.length<2);if(ak){c6=true}V=(I>0);cJ=(I>0&&!a.isChrome)?1:0;cN=0;a2++;if(eL.length!==da.length){eL=a.utils.cloneArray(da);if(H&&cY){cY.images=a.utils.cloneArray(H)}}cr=eL.length;bx();bN();az();ea.width=aY;ea.height=cL;dn();bb();if(!a.isMobileDevice){de()}if(aU!==b){var e5=aU.offsetLeft/aU.nAdvance;dG=e5*dJ;aU=b}dG=u(dG);ch();ex=true;if(cL<1){cc.error("Insufficient instance height. Resulting image height is "+cL+"px");return}dX();bk=Math.max(0,Math.min(cr-1,eA));dG=u(bk*-dJ);dL();c7()};var az=function(){e=false;dI=aa.width/2;cs=false;var e6=F;c8=false;ai=false;switch(F){case"stacks":c1=dM;break;case"flat":c8=true;c1=c;cs=!by;ew.zoomCenteredImageOnly=false;if(!by){e=true;dI=dJ/2}break;case"custom":var e4=aM(em.cfg.custompresentationfunction);if(e4){B=e4}else{B=eM}e4=aM(em.cfg.custompresentationinitfunction);if(e4){ai=e4}c1=bi;break;default:e6="ring";ey=(F!=="innerring");c1=bW;F="carousel";break}a.addClass(ct,e6);if(cC){dI-=cp.height/2}else{dI-=cp.width/2}var e3=(cC)?cp.height:cp.width;bK=(aa.width-e3)/2/Math.sin(1);if(F!=="stacks"){var e5;if(ey){e5=1}else{e5=0.75}bK=Math.sin(1)*(e5*aa.width)}bK=Math.round(bK);ag=10*Math.ceil(aa.width/e3);ct.style.perspective=bK+"px"};var bx=function(){bj=bH=0;dc=bY.spacing;if(F==="flat"&&!by){var e4=(cC)?"height":"width";var e3=(cp[e4]+dc)*cr-dc;if(e3<aa.width&&ew.autoElementSpacing){if(cr>1){dc=(aa.width-cr*cp[e4])/(cr-1);bj=dc;bH=-dc/2}else{dc=(aa.width-cp[e4])}}else{bj=dc;bH=-dc/2}}};this.removeAllImages=function(){if(!eL||eL.length<1){return false}ao();eP();eL=[];cY={};c7();return true};this.removeImages=function(e5){var e8;var fa=[];if(typeof(e5)==="number"){e5=[e5]}if(typeof(e5)!=="object"||typeof(e5.pop)!=="function"){return fa}if(!eL||eL.length<1){return fa}var fb=et();ao();ax=[];var e6=function(fe,fd){return fd-fe};e5.sort(e6);var fc={};var e3=0;var e9=eL.length-1;for(e8=0;e8<e5.length;e8++){var e4=e5[e8];if(e4<0||e4>e9){continue}if(fc[e4]){continue}e3++;var e7={};e7.nIndex=e4;e7.src=eL[e4];eL.splice(e4,1);fb.splice(e4,1);if(cY){if(cY.images){e7.image=cY.images[e4];cY.images.splice(e4,1)}if(cY.arConfigs){e7.iConfig=cY.arConfigs[e4];cY.arConfigs.splice(e4,1)}if(cY.arImageLists){e7.imageList=cY.arImageLists[e4];cY.arImageLists.splice(e4,1)}if(cY.arNodes){e7.node=cY.arNodes[e4];cY.arNodes.splice(e4,1)}bw(ab[e4]);fa.push(e7);delete ab[e4]}fc[e4]=true}if(e3>0){df(fb);c7();fa.reverse()}return fa};this.addImages=function(fd,fc){ao();ax=[];if(isNaN(fc)||fc<-1||fc>=eL.length){fc=b}if(typeof(fd)==="string"){fd=[fd]}if(typeof(fd)==="object"&&typeof(fd.pop)!=="function"){fd=[fd]}if(fc!==b){fd.reverse()}var fa=[];var e8;var e4;if(typeof(fd)!=="object"||typeof(fd.pop)!=="function"||fd.length<1){return fa}var fe=et();var ff=function(fg,fh){if(fc===b){fg.push(fh)}else{fg.splice(fc,0,fh)}};var e7=function(fi,fh){var fg;if(fi&&typeof(fi)==="object"){fg=fi;if(cY[fh]===b){cY[fh]=new Array(Math.max(0,e5-1))}switch(fh){case"arConfigs":fi=fi.clone();break;case"arImageLists":fi=a.utils.cloneObject(fi);break;case"arNodes":fi=fi.cloneNode(true);break}ff(cY[fh],fi)}else{if(cY[fh]!==b){ff(cY[fh],b)}}return fg};var e6=0;var e3;for(var e9=0;e9<fd.length;e9++){var fb=fd[e9];e8={nIndex:eL.length};e3=b;e4=b;if(typeof(fb)==="string"&&fb.length>0){eN=false;e3=fb;e4={src:e3};e7(b,"arConfigs");e7(b,"arNodes");e7(b,"arImageLists")}else{if(typeof(fb)==="object"&&typeof(fb.src)==="string"&&fb.src.length>0){eN=false;var e5=eL.length;e3=fb.src;if(fb.image===b){e4={src:fb.src}}else{e4=fb.image}if(fb.parameters){if(fb.iConfig===b){fb.iConfig=new a.Config();fb.iConfig.init()}fb.iConfig.setCfgValues(fb.parameters)}if(fb.iConfig&&fb.iConfig.cfg&&fb.iConfig.cfg.fpxserver===b){fb.iConfig.cfg.fpxserver=em.cfg.fpxserver;fb.iConfig.requestBase=em.requestBase}e7(fb.iConfig,"arConfigs");e7(fb.node,"arNodes");e7(fb.imageList,"arImageLists")}}if(e3){e6++;e8.src=e3;ff(eL,e3);ff(fe,b);if(cY&&cY.images){ff(cY.images,e4)}if(cY&&cY.arImages&&eL.length>cY.arImages.length){ff(cY.arImages,e3)}fa.push(e8)}}if(e6>0){df(fe);c7();dX()}if(fc!==b){fd.reverse()}return fa};var et=function(){var e3=new Array(eL.length);for(var e4 in ab){if(ab.hasOwnProperty(e4)){e3[ab[e4].nIndex]=ab[e4]}}return e3};var df=function(e5){var e3={};for(var e4=0;e4<e5.length;e4++){var e6=e5[e4];if(e6){delete e6.placedX;delete e6.position;e6.nIndex=e4;e3[e4]=e6}}ab=e3};var c7=function(){var e3=c6;da=eL;ax=[];d6=cr=eL.length;dn();bx();c6=!ew.ScrollBar;ak=(eL.length<2);if(ak){c6=true}bN();bb();if(cO<=0){if(F==="flat"&&!ew.autoElementSpacing){cB=(aa.width-e1)*bR}c6=true;bN()}else{cB=0}dG=Math.max(dG,-cO);az();b3();if(e3!==c6){eP()}E()};var bN=function(){var e4=aa.height;if(!c6&&V){e4-=I}var e3=e4-ew.paddingTop-ew.paddingBottom;if(cC){aY=e3-Math.ceil(eE.height+eX.height);dJ=Math.ceil(eX.height+eE.height)+cL+dc}else{cL=e3-Math.ceil(eE.width+eX.width);dJ=Math.ceil(eX.width+eE.width)+aY+dc}f.style.width=(aY+eX.width)+"px";i.style.width=f.style.width;f.style.height=(cL+eX.height)+"px";f.style.lineHeight=(cL-2)+"px";c3()};var c3=function(){cp.width=eX.width+eE.width+aY;cp.height=eX.height+eE.height+cL};var ch=function(){var e3;if(cC){e3=ew.paddingTop+dm*cp.width;ct.style.perspectiveOrigin=e3+"px "+aa.width/2+"px"}else{e3=ew.paddingTop+dm*cp.height;ct.style.perspectiveOrigin=aa.width/2+"px "+e3+"px"}};var dL=function(){ap=b;if(cC){ea.width=Math.min(ea.width,ea.height)}else{ea.height=Math.min(ea.width,ea.height)}if(ew.placeHolderImage.length<1){ew.placeHolderImage="none"}var e4=ew.placeHolderImage.toLowerCase();switch(e4){case"blank":case"default":case"custom":ah.src=dV;ah.className=dO="placeholder "+e4+bp;ea.nMode=1;o();break;case"none":ah.className=dO="placeholder none"+bp;o();ea.nMode=1;break;default:ah.className=dO="placeholder image"+bp;ea.nMode=2;var e5=a0(0);if(e5){eq(null,e5)}else{var e3=em.getImageInfoURL(eL[bk]);em.loadFile(e3,eq)}}};var eq=function(e5,e3){cU(ea,e3);var e4=a.utils.fitImageIntoSpace(ea.maxWidth,ea.maxHeight,aY,cL);ea.width=e4.width;ea.height=e4.height;ea.bHasPadEffect=true;ah.src=dg(ea,ew.placeHolderImage,{effects:ew.placeHolderPadEffect});o()};var bX=function(){if(!em.cfg.imagelistparameterfilternegative&&!em.cfg.imagelistparameterfilterpositive){if(!aT||aT.nItems){aT={}}return}if(em.cfg.imagelistparameterfilterpositive){aT=em.getParameterFilterFromString(em.cfg.imagelistparameterfilterpositive,true)}else{aT=em.getParameterFilterFromString(em.cfg.imagelistparameterfilternegative,false)}};var o=function(){if(!cz&&ew.enableZoom){if(!du){du=a.addCustomEvent(aE,"FSIViewport",dr);a.setCustomEventListenerProperty(du,"treshold",150);a.setCustomEventListenerProperty(du,"fireTresholdEventOnly",true);a.triggerCustomEvent(du)}}else{if(du){a.removeCustomEvent(aE,"FSIViewport",dr);du=b}}d={scope:aE,elementID:D,nMaxThumbWidth:dJ,totalWidth:aa.width,totalHeight:aa.height,nPerspective:bK,nHorizontalFactor:ad};if(ai){ai.apply(this,[d])}dC();if(by){var e4=0;var e3=function(){for(var e5 in cY){if(cY.hasOwnProperty(e5)){if(typeof(cY[e5].concat)==="function"){cY[e5]=cY[e5].concat(cY[e5])}}}};while(eL.length<=bF.length+2){e4++;eL=eL.concat(eL);if(cY){e3()}cr=eL.length}}dD=cr-1;bb();if(cO<=0&&!c6){c6=true;eP()}bN();if(ew.garbageCollectionSize<0){if(a.isMobileDevice){a3=2*(ew.preloadCount+bF.length)}else{a3=Math.max(250,6*(ew.preloadCount+bF.length))}}else{if(ew.garbageCollectionSize===0){a3=cr}else{a3=Math.max(ew.preloadCount+bF.length,ew.garbageCollectionSize)}}b3();bq.style.display="";if(ew.preloadCount>0){db.bEnabled=true;cF=cj}else{db.bEnabled=false;cF=a.fnDoNothing}p();if(ds){dk()}bE=a.now();if(a3<cr){cc.info("Enabling garbage collection (max. "+a3+" images)")}else{cc.info("Garbage collection disabled");ck()}bG(-dG);if(di){an(-dG)}cy();bv.run("onReady")};var b3=function(){if(e){e1=dJ*cr-bj}else{e1=aa.width+(dJ*cr);if(!by){e1-=dJ}}bv.runPersistent("onSetScrollRange",[e1,e1-aa.width,by,cr]);if(cC){R.style.height=e1+"px";if(c8){ct.style.height=e1+"px"}}else{R.style.width=e1+"px";if(c8){ct.style.width=e1+"px"}}t();bq.style.display=""};var dr=function(e3){a6=e3.FSI_viewport_rect;aQ=e3.FSI_client_rect_body_top};var ej=function(){if(document.querySelectorAll===b){return}var e3=em.cfg.cmdbuttonselector;if(typeof(e3)!=="string"){return false}var e6=document.querySelectorAll(e3);for(var e4=0;e4<e6.length;e4++){var e5=e6[e4].getAttribute("data-fsi-cmd");if(e5===null){e5=e6[e4].getAttribute("x-fsi-cmd")}if(typeof(e5)==="string"&&e5.length>0){cc.log("Registering button from config for command: "+e5);aE.registerButton(e6[e4],e5)}}em.cfg.cmdbuttonselector=b};var dn=function(){if(cr<1){ee=es}else{if(cs){ee=cW}else{ee=dz}}};var cy=function(){if(bv.isset("onStart")){bv.runPersistent("onStart",[ew.dir,eL.length,a.utils.cloneArray(eL)])}aV(0);bO()};var bb=function(){cO=cr*dJ;if(!by){if(F==="flat"){cO-=aa.width}else{cO-=dJ}cO-=bj;cO=Math.max(0,cO)}cO=Math.round(cO)};var de=function(){if(!aa||aa.width<1||aa.height<1){return false}if(a.isIETouch){c0.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}if(!y){var e3={};e3.bMouseOnly=true;e3.afterTouch={enabled:true};e3.afterTouch.factorAmount=25;e3.afterTouch.factorFrames=3;e3.afterTouch.minFrames=5;e3.afterTouch.offsetFrames=1;e3.afterTouch.useAnimationFrame=true;e3.detectGestures=false;y=new a.TouchHandler(cH,e3,cS,L,d1);y.setCapture(true,false)}};var cS=function(e3,e5){dA.ts=0;bs.x=e5.x;bs.y=e5.y;if(I>0){var e4=a.getBoundingClientRect(cH);if(cC){if(e5.x-e4.left>e4.width-I){return false}}else{if(e5.y-e4.top>e4.height-I){return false}}}e2();ds=0;cancelAnimationFrame(Z);Z=b;y.enableAfterTouch(true);c9.bImageDragging=true;aX.startX=bs.x;aX.startY=bs.y;aX.offsetLeft=dG;E();return true};var L=function(e3,e5){bs.x=e5.x;bs.y=e5.y;if(c9.bImageDragging){if(cC){aX.dy=bs.x-aX.startX;aX.dx=bs.y-aX.startY}else{aX.dx=bs.x-aX.startX;aX.dy=bs.y-aX.startY}if(!eQ){eu(true)}var e4=dG;dG=u(aX.offsetLeft+aX.dx);E();if(di){a7(-dG)}else{bG(-dG)}if(e4===dG||Math.abs(aX.dy)>3*Math.abs(aX.dx)){e3.FSI_allowEventDefault=true}}};var d1=function(e4,e7){bs.x=e7.x;bs.y=e7.y;if(c9.bImageDragging){c9.bImageDragging=false;eu(false);if(di){bG(-dG)}}var e5=e7.x-e4.FSI_start_x;var e3=e7.y-e4.FSI_start_y;var e6=Math.sqrt(e5*e5+e3*e3);dA.ts=a.now();dA.dist=e6;E()};var P=function(e5,e6){var e3=false;e6=Math.ceil(e6);if(isNaN(e6)||e6<0){e6=0}if(isNaN(e5)){return false}e5=e5%cO;var e4=N(-e5,false,e6);if(e4!==false){e3=eO.end}return e3};var eC=function(e3){c9.bSetIsScrolling=e3;if(dR){clearTimeout(dR)}dR=setTimeout(Q,100)};var Q=function(){eu(c9.bSetIsScrolling);dR=b;db.nLoad=Math.min(cr,ew.preloadCount);cu()};var eu=function(e3){if(dR){clearTimeout(dR);dR=b}if(e3===eQ){return}eQ=e3;if(eQ){bv.run("onScrollStart",[-dG])}else{bv.run("onScrollEnd",[-dG])}if(!eQ&&dp){cP()}};var aV=function(e3){d7=e3;bf=b;if(bv.isset("onFocus")){var e4=ab[e3];if(e4){bv.runPersistent("onFocus",[e4.nIndex,eL[e4.nIndex]])}}};var bO=function(){if(!er||!cz||a9||!ab||!ab[bk]){return}M(ab[bk]);a9=true;cR(ab[bk]);bJ=ab[bk].nIndex};var cR=function(e7){if(!e7||!cz||typeof(cz.changeImage)!=="function"){return}if(ec===e7.nIndex&&!e7.iConfig){return}ec=e7.nIndex;var e8={};var e5;if(cY.arConfigs){e5=cY.arConfigs[e7.nIndex]}if(e5){e5.cloneParameters(e5.cfg,e8)}var e3=false;var e9=false;var fa;if(cY.arImageLists){fa=cY.arImageLists[e7.nIndex]}if(fa&&fa.arImages){e8.fpxsources=fa.arImages.join(",");if(e8.fpxsources===cz.getConfigValue("fpxsources")){e3=true}}else{e8.fpxsrc=eL[e7.nIndex];var fc=cz.getConfigValue("fpxsrc");if(e8.fpxsrc===fc){e3=true}else{e9=true}}e8.imageWidth=e7.sourceWidthNoPadEffect;e8.imageHeight=e7.sourceHeightNoPadEffect;if(!e5||!e5.cfg){e8.cropRect=em.cfg.croprect;e8.cropValues=em.cfg.cropvalues;e8.effects=em.cfg.effects;e8.fpxServerTemplate=em.cfg.fpxservertemplate;e8.imageFormat=em.cfg.imageformat}else{e9=true;if(e3){if(aT===b){bX()}var e4=new a.Config();e4.init();var e6=b;if(cY.arNodes&&cY.arNodes[e7.nIndex]){e6=cY.arNodes[e7.nIndex]}e4.cfg={};e4.setParameterFilter(aT);if(e6){e4.parseConfig(e6,e6)}else{e4.setCfgValues(e5.cfg)}if(e4&&aF(e4.cfg)){e9=false}}}if(e9){if(e8.effects){e8.effects="ClearEffects(),"+e8.effects}var fb=(e5&&e5.cfg.cfg)?e5.cfg.cfg:b;cz.changeConfig(fb,e8)}else{if(!e3){cz.changeImage(e8)}if(e5&&e5.cfg){if(e5.cfg.initialview){cz.gotoViewString(e5.cfg.initialview,true)}else{cz.resetView(true)}}else{if(e3){cz.resetView(true)}}}};var cK={initialview:true,thumblabel:true};var aF=function(e3){var e4=true;for(var e5 in e3){if(e3.hasOwnProperty(e5)){if(!cK[e5]&&e5.indexOf(".node")===-1){e4=false;break}}}return e4};var K=function(fd){if(fd.bError){return}bJ=fd.nIndex;M(fd);if(cz!==b){cR(fd);return}d8(b,true);if(!fd.bReady){return}var fp=document.body.scrollWidth;var fj=document.body.scrollHeight;var fr=a.utils.getDocumentScaleWithPixelRatio();var fg=a6.left-aQ.left;var e5=a6.top-aQ.top;dS=document.createElement("div");j=document.createElement("div");j.style.willChange="opacity";b9=document.createElement("img");dy.alphaShader=0;dS.setAttribute("class","fsi-thumbbar-zoom-div");ez=fd.nIndex;c2=fd.img.cloneNode(true);c2.style.transform="";c2.style.position="static";c2.style[bL]="none";var fk=a.getBoundingClientRect(fd.img);c2.style.width=c2.style.height="100%";dS.appendChild(c2);document.body.appendChild(dS);var e4=a.getElementClientPos(document.body);var fi=-e4.left;var fh=-e4.top;var e9=a.utils.getElementBorders(dS);var e7=a.utils.getElementPaddings(dS);dy.startX=fi+fk.left-e9.left;dy.startY=fh+fk.top-e9.top;dy.startWidth=fk.width;dy.startHeight=fk.height;dS.style.width=dy.startWidth+"px";dS.style.height=dy.startHeight+"px";dS.style.left=dy.startX+"px";dS.style.top=dy.startY+"px";dS.style.willChange="left,top,width,height";var fq=a.getViewportSize(window);a.addEvent(j,"mousedown",d8,false);a.addEvent(window,"touchstart",d8,{passive:false});a.addEvent(dS,"mousedown",d8,false);a.addEvent(window,"scroll",d8,false);var fo=Math.ceil(ew.zoomMargin/fr);var fa=fq.width-fo-e9.left-e9.right-e7.left-e7.right;var fb=fq.height-fo-e9.top-e9.bottom-e7.top-e7.bottom;var fe=fd.maxWidth;var fn=fd.maxHeight;var fl=a.utils.fitImageIntoSpace(fe,fn,fa,fb);fe=fl.width;fn=fl.height;dy.endWidth=fe;dy.enddHeight=fn;dy.dWidth=fe-dy.startWidth;dy.dHeight=fn-dy.startHeight;dy.endX=fg+Math.round((fq.width-fe-e9.left-e9.right-e7.left-e7.right)/2);dy.endY=e5+Math.round((fq.height-fn-e9.top-e9.bottom-e7.top-e7.bottom)/2);dy.dx=dy.endX-dy.startX;dy.dy=dy.endY-dy.startY;var fc="left:"+fg+"px;top:"+e5+"px;";if(fr===1){fc+="width:100%;height:100%"}else{var e6=a6.width();var ff=a6.height();if(fg+e6>fp){e6-=fg+e6-fp}if(e5+ff>fj){ff-=e5+ff-fj}fc+="width:"+e6+"px;height:"+ff+"px"}dy.bImageReady=false;var e8=fd.img.src;e8=e8.replace(bg,"$1");var e3=Math.min(fd.maxWidth,Math.round(fr*fe));var fm=Math.min(fd.maxHeight,Math.round(fr*fn));e8+="&width="+e3+"&height="+fm;aK=true;a.addEvent(b9,"load",b4,false);b9.style.width=dy.endWidth+"px";b9.style.height=dy.endHeight+"px";b9.setAttribute("crossorigin","anonymous");b9.src=e8;dy.pos=0;dy.frames=bV(32);a.utils.setStyleAttr(j,fc);j.setAttribute("class","fsi-thumbbar-shader");document.body.appendChild(j);dy.alphaShader=ew.zoomShaderStartOpacity;cancelAnimationFrame(dY);dY=requestAnimationFrame(a1);dy.posFader=0;dy.framesShader=bV(12);dy.startAlpha=dy.alphaShader;dy.endAlpha=ew.zoomShaderEndOpacity;dy.dAlpha=dy.endAlpha-dy.startAlpha;dy.bRemoveOnEnd=false;au=requestAnimationFrame(g);bv.run("onZoomStart",[fd.nIndex,e8]);if(!a.isMobileDevice){a.addEvent(window,"resize",d8,false)}else{a.addEvent(window,"orientationchange",d8,false)}};var bz=a.Easing.easeOutCubic;var a1=function(){dy.pos++;if(dy.pos>dy.frames){dY=b;requestAnimationFrame(c4);return}var e3=bz(dy.pos,dy.frames,dy.startX,dy.dx);var e6=bz(dy.pos,dy.frames,dy.startY,dy.dy);var e4=bz(dy.pos,dy.frames,dy.startWidth,dy.dWidth);var e5=bz(dy.pos,dy.frames,dy.startHeight,dy.dHeight);dS.style.left=e3.toFixed(2)+"px";dS.style.top=e6.toFixed(2)+"px";dS.style.width=e4.toFixed(2)+"px";dS.style.height=e5.toFixed(2)+"px";dY=requestAnimationFrame(a1)};var c4=function(){if(!dS||!dy.bImageReady||dY!==b){return}dS.replaceChild(b9,dS.firstChild);dS.firstChild.style.width=b9.style.width;dS.firstChild.style.height=b9.style.height;dS.firstChild.src=b9.src;dS.style.width="";dS.style.height="";dS.style.willChange="auto";j.style.willChange="auto";bv.run("onZoomReady",[ez,b9.src,b9]);b9=b};var b4=function(){dy.bImageReady=true;a.removeEvent(b9,"load",b4,false);aK=false;c4()};var d8=this.closeZoom=function(e3,e4){if(!dS){return}bJ=b;M();bf=b;if(!a.isMobileDevice){a.removeEvent(window,"resize",d8,false)}else{a.removeEvent(window,"orientationchange",d8,false)}if(au){cancelAnimationFrame(au);au=b}cancelAnimationFrame(dY);dY=b;a.removeEvent(j,"mousedown",d8,false);a.removeEvent(dS,"mousedown",d8,false);a.removeEvent(window,"touchstart",d8,{passive:false});a.removeEvent(window,"scroll",d8,false);if(aK){a.removeEvent(b9,"load",b4,false)}if(b9){b9=b}a.removeChild(dS.parentNode,dS);dS=b;if(e4===true){a.removeChild(j.parentNode,j);j=b}else{j.style.willChange="opacity";dy.posFader=0;dy.framesShader=10;dy.startAlpha=dy.alphaShader;dy.endAlpha=0;dy.dAlpha=dy.endAlpha-dy.startAlpha;dy.bRemoveOnEnd=true;au=requestAnimationFrame(g)}bv.run("onZoomEnd");if(e3&&e3.touches&&e3.touches.length===1){e3.cancelBubble=true;if(e3.stopPropagation){e3.stopPropagation()}if(e3.preventDefault){e3.preventDefault()}}ez=b};var cV=function(e3){j.style.opacity=dy.alphaShader=e3};var g=function(){dy.posFader++;if(dy.posFader>dy.framesShader){if(dy.bRemoveOnEnd){a.removeChild(j.parentNode,j);j=b}au=b;return}var e3=bz(dy.posFader,dy.framesShader,dy.startAlpha,dy.dAlpha,3);cV(e3);au=requestAnimationFrame(g)};var be=function(e4,e3){if(!e4){return false}aV(e4.nIndex);return N(-e4.nIndex*dJ,e3,30)};var u=function(e3){if(by){e3=Math.round(e3)%cO;if(e3>0){e3-=cO}}else{e3=Math.min(0,Math.max(-cO,e3))}return e3};var bV=function(e3){if(a.isMobileDevice){e3=Math.ceil(e3/1.3)}return e3};var N=function(e7,e4,e6,e3){if(ak){return}if(e6===b){e6=40}if(e6>0){e6=bV(e6)}e2();if(by&&!e4){e7=u(e7);dG=u(dG);var e5=e7-dG;if(Math.abs(e5)>cO/2){if(e5>0){e7=-cO+e7}else{e7=cO+e7}}}if(!by){e7=Math.min(0,Math.max(e7,-cO))}if(e7===dG||(Z!==b&&e7===eO.end)){return false}eu(true);cancelAnimationFrame(Z);Z=b;eO.frames=e6;eO.pos=0;eO.nScrollBarID=e3;eO.start=dG;eO.end=e7;if(!e3&&((by&&e4)||!by)){eO.end=u(eO.end)}eO.diff=eO.end-eO.start;if(e6<1){n()}else{Z=requestAnimationFrame(n)}return true};var n=function(){eO.pos++;if(eO.pos>=eO.frames){dG=u(eO.end);if(eO.bUpdateVisibleScrollBar){bq[G]=-dG}eC(false);Z=b;p();cq();if(di&&eO.nScrollBarID!==2){a7(-dG)}if(!eO.nScrollBarID){bG(-dG)}eD();return}dG=u(bz(eO.pos,eO.frames,eO.start,eO.diff,3));if(di&&eO.nScrollBarID!==2){a7(-dG)}else{if(!eO.nScrollBarID){bG(-dG)}}p();cq();Z=requestAnimationFrame(n)};var bA=function(e4){var e3=em.getImageInfoURL(e4.imagePath,X);em.loadFile(e3,dF,b,e4)};var cZ=function(e5){if(e5.oTemplate&&e5.oTemplate.bNeedsMetaData){bA(e5)}else{if(eN){var e4=e5.oInfo=a0(e5.nIndex);ei(e5,e4)}else{e5.bInfoLoading=true;var e3=em.getImageInfoURL(eL[e5.nIndex]);em.loadFile(e3,m,b,e5)}}};var m=function(e3,e4,e5){if(typeof(e4)==="object"){e5.oInfo=e4;e4.width=parseInt(e4.width);e4.height=parseInt(e4.height);if(isNaN(e4.width)){ed.call(e5.img)}}ei(e5,e4)};var cU=function(e4,e3){if(e4.bImageInfoCalculated){return}e4.bImageInfoCalculated=true;e4.nThumbnailDimWidth=aY;e4.nThumbnailDimHeight=cL;e4.bInfoReady=true;e4.sourceWidth=e4.sourceWidthNoPadEffect=e3.width;e4.sourceHeight=e4.sourceHeightNoPadEffect=e3.height};var ei=function(e4,e3){if(!er){return}if(!e3||!e4||e4.nStartID!==a2){return}if(e4.oTemplate&&e4.oTemplate.bNeedsMetaData&&!e4.oMetaData){return}e4.oInfo=e3;cU(e4,e3);eU(e4)};var bn=function(e3){if(cC){e3.offsetX=0;e3.offsetY=ew.paddingTop}else{e3.offsetX=0;e3.offsetY=ew.paddingTop}};var dg=function(e7,e6,e4){if(e4===b){e4=S}var e3=em;if(e7.iConfig){e3=e7.iConfig}e4.width=e7.width;if(e7.bHasPadEffect){e4.height=e7.height-e7.nLabelHeight}var e5=e3.getImageURLAsInViewer(e6,e7.sourceWidth,e7.sourceHeight,aY,cL-e7.nLabelHeight,null,e4,b1);e7.maxWidth=e5.srcArea.width;e7.maxHeight=e5.srcArea.height;if(ea.nMode===1&&e7.img&&e5.dimFit){e7.img.style.width=e5.dimFit.width+"px";e7.img.style.height=e5.dimFit.height+"px"}return e5.url};var eU=function(e5){if(!e5.bInfoReady||e5.bThumbLoadStarted){return false}e5.imageURL=dg(e5,e5.imagePath);e5.tsRemovedFromDOM=bE;var e3=e5.img;e5.nThumbnailDimWidth=aY;e5.nThumbnailDimHeight=cL;e5.bThumbLoadStarted=true;e5.nStartID=a2;if(e5.width<1||e5.height<1){ed.call(e3)}else{Y++;aC[e5.nIndex]=e5;e5.bHasEvents=true;a.addEvent(e3,"load",cX);a.addEvent(e3,"error",ed);var e4=e5.imageURL;if(em.hasImageParameterConditions){e4=em.reWriteImageURLByConditions(e4)}e5.src=e3.src=e4}return true};var bC=function(e3){return(e3.nThumbnailDimWidth===aY&&e3.nThumbnailDimHeight===cL)};var aj=function(e3){return(e3&&e3.nStartID===a2)};var bD=function(e3){if(e3.bHasEvents===true){delete aC[e3.nIndex];a.removeEvent(e3.img,"load",cX);a.removeEvent(e3.img,"error",ed);e3.bHasEvents=false}};var ed=function(e3){var e4=this.parentNode.oSprite;if(!e4){return}e4.bReady=false;e4.bError=true;if(isNaN(e4.sourceWidth)||isNaN(e4.sourceHeight)){e4.width=e4.sourceWidth=e4.maxWidth=ea.width;e4.height=e4.sourceHeight=e4.maxHeight=ea.height}e4.bLoadComplete=true;e4.bThumbLoading=false;e4.img.src=dV;e4.img.className="placeholder blank error";if(aj(e4)&&e3){Y--}bD(e4);cu()};var cX=function(){var e3=this.parentNode.oSprite;if(!e3||!er){return}e3.img.style.width=e3.img.style.height="";bD(e3);if(e3.bLoadComplete||!aj(e3)){return}Y--;if(!bC(e3)){return}e3.bReady=true;e3.bLoadComplete=true;e3.placedX=b;a.removeClass(e3.img,dO);if(e3.bVisible){eg(e3)}cq();bZ[e3.nIndex]=e3;dQ++;if(ca&&ca.nIndex===e3.nIndex){M(e3)}cu();if(dQ>=a3){cb()}};var eg=function(e3){if(!r||!e3.bReady){return}if(!e3.imgInOtherViewers){e3.imgInOtherViewers=e3.img;b0[e3.nIndex]=e3;delete dq[e3.nIndex];ae(true)}};var eR=function(e3){if(!r||!e3.bReady){return}if(e3.imgInOtherViewers){delete e3.imgInOtherViewers;dq[e3.nIndex]=e3;b0[e3.nIndex]=b;delete b0[e3.nIndex];ae(true)}};var ae=function(e3){if(dp!==e3){dp=e3;if(cf===b&&!eQ){cf=setTimeout(cP,500)}}};var ci=function(){if(aD){a.removeEvent(window,"FSITouchZoomLoaded",ci);aD=false}if(!dN){var e3={debug:false,useimagetiles:false,imgsrcattributename:"src",scanOnInit:false};dN=new a.TouchZoom(e3);dN.init(false,null,cc.on,false,true)}if(dp){var e4=dp;dp=b;ae(e4)}};var cP=function(){cf=b;if(!dp||!dN||eQ){return}ae(false);var e5,e3;var e4=dN.getInstanceID();for(e5 in b0){if(b0.hasOwnProperty(e5)&&b0[e5]){b0[e5].img.FSITouchZoomInstanceID=e4;dN.addImage(b0[e5].img,b0[e5].oInfo)}}e3=[];for(e5 in dq){if(dq.hasOwnProperty(e5)&&dq[e5]){e3.push(dq[e5].img)}}if(e3.length>0){dN.removeImages(e3)}b0={};dq={}};var cq=function(){if(bf===b){return}var e3=A(bf);if(!e3.bReady||!al(e3)){return}K(e3);bf=b};var J=function(e3){if(!bv.isset("onMouseEnter")&&!bv.isset("onMouseLeave")){return}l=e3;eF={};a.addEvent(cH,"mouseleave",a4);a.addEvent(cH,"mousemove",d5)};var a4=function(){a.removeEvent(cH,"mouseleave",a4);a.removeEvent(cH,"mousemove",d5);if(q!==b){clearTimeout(q)}q=b;if(eF.nIndex!==b){bv.run("onMouseLeave",[eF.nIndex,eF])}eF={};l=b};var d5=function(e3){l=e3;eD()};var eD=function(){if(!l){return}if(q===b){q=setTimeout(dh,100)}};var dh=function(){q=b;cH.style.pointerEvents="none";ct.style.pointerEvents="all";var e4=document.elementFromPoint(l.clientX,l.clientY);cH.style.pointerEvents="all";ct.style.pointerEvents="none";var e3;if(e4&&e4.parentNode&&e4.parentNode.oSprite){e3=e4.parentNode.oSprite.nIndex}if(eF.nIndex!==e3){if(eF.nIndex!==b){bv.run("onMouseLeave",[eF.nIndex,eF])}if(e3===b){eF={}}else{eF=e4.parentNode.oSprite;bv.run("onMouseEnter",[eF.nIndex,eF])}}};var A=function(e5,e8){e5%=cr;if(e5<0){e5+=cr}var e7=ab[e5];if(e7===b){dw++;e7=ab[e5]={};e7.nStartID=a2;e7.nIndex=e5;e7.imagePath=eL[e7.nIndex];if(cY&&cY.arConfigs&&cY.arConfigs[e7.nIndex]){e7.iConfig=cY.arConfigs[e7.nIndex]}}if(!e7.img){e7.elContainer=f.cloneNode(true);e7.nLabelHeight=0;e7.elContainer.oSprite=e7;if(e7.label===b){var e6;if(cY.arNodes){e6=cY.arNodes[e7.nIndex]}if(e6&&e6.getAttribute("label")){e7.label=e6.getAttribute("label")}if(!e7.label){var e3=e7.iConfig||em;e7.label=e3.cfg.thumblabel}dU(e7)}var e4=e7.img=ah.cloneNode(false);if(r){e4.FSITouchZoomInstanceID=-1}if(e7.oTemplate){e7.elLabel=i.cloneNode(true);e7.elLabel.innerHTML=e7.label;e7.elContainer.appendChild(e7.elLabel);e7.nLabelHeight=O(e7);e7.elContainer.style.lineHeight=(cL-2-e7.nLabelHeight)+"px"}e7.elContainer.appendChild(e4);if(e7.bPurged){delete e7.bPurged}else{bn(e7);if(ea.nMode===1&&eN){cU(e7,cY.images[e5])}else{e7.width=ea.width;e7.height=ea.height;e4.style.width=ea.width+"px";e4.style.height=ea.height+"px"}}}if(e8&&!e7.bImageLoadStarted){ax.push(e7)}return e7};var O=function(e6){var e4=!e6.bAppended;if(e4){bl(e6,true)}var e5=e6.elLabel.getBoundingClientRect();var e3=e5.height;if(e4){bw(e6,true)}return e3};var bM=function(){var e3={oLanguageData:cg,bItemsHaveWidthAndHeight:eN,oNumberSeperators:ev,strLocale:d3};if(bv.isset("onReplaceTemplateValue")){e3.fnCallbackReplace=aW}ay=new a.MetaDataReplacer(e3)};var aW=function(e4,e5){var e3=bv.run("onReplaceTemplateValue",[e4,e5]);if(e3!==b){e5=e3}return e5};var dU=function(e5){var e4;if(typeof(e5.label)==="string"&&e5.label.length>0){e5.label=decodeURIComponent(e5.label);e4=bv.run("onBeforeReplaceLabelTemplates",[e5.label,e5]);if(e4===false){e5.label=b;return}else{if(typeof(e4)==="string"){e5.label=e4}}if(!bt[e5.label]){bt[e5.label]=true;if(!ay){bM()}bt[e5.label]=ay.parseTemplate(e5.label)}e5.oTemplate=bt[e5.label];if(e5.oTemplate.bHasPlaceHolders){if(eN&&e5.oTemplate.bNeedsImageDim){var e3=cY.images[e5.nIndex];e5.sourceWidth=parseInt(e3.width);e5.sourceHeight=parseInt(e3.height)}e5.label=ay.replaceBasic(e5,e5.oTemplate)}d4(e5)}else{e5.label=b}};var d4=function(e4){if(bv.isset("onAfterReplaceLabelTemplates")){var e3=bv.run("onAfterReplaceLabelTemplates",[e4.label,e4]);if(e3===false){e4.label=b}else{if(typeof(e3)==="string"){e4.label=e3}}}};var dF=function(e3,e4,e5){e5.oMetaData=e4;if(bv.isset("onMetaData")){bv.run("onMetaData",[e5,e4])}if(e5.sourceWidth===b){e5.sourceWidth=parseInt(e4.width);e5.sourceHeight=parseInt(e4.height)}e5.label=ay.replaceAll(e5,e5.oTemplate);d4(e5);if(e5.elLabel){e5.elLabel.innerHTML=e5.label;e5.nLabelHeight=O(e5);e5.elContainer.style.lineHeight=(cL-2-e5.nLabelHeight)+"px"}m(e3,e4,e5)};var dX=function(){cu=cw;cd=aL};var aI=function(){cu=cd=a.fnDoNothing;if(ar){clearTimeout(ar);ar=b}};var cw=function(){if(!ar){ar=setTimeout(aL,25)}};var aL=function(){if(ar){clearTimeout(ar);ar=b}cF();while(ax.length>0&&Y<d9){var e3=ax.shift();if(!e3.bImageLoadStarted){e3.bImageLoadStarted=true;cN++;if(cN===cr&&a3>=cr){aI()}cZ(e3)}}};var bS=function(e5,e3){if(!by){if(e5<0||e5>=cr){return 0}}var e4;var e6=A(e5);if(e3!==e6.position){e6.position=e3;e4=c1(e6);if(e4&&!e6.bVisible){bl(e6)}e6.bVisible=e6.calculatedRet=e4}else{e4=e6.calculatedRet;if(e4&&!e6.bVisible){bl(e6)}e6.bVisible=e4}if(e6.bVisible){bF.push(e6);if(!e6.bImageLoadStarted){ax.push(e6)}}return e6.bVisible};var bW=function(e7){var e5,e6;e5=e7.position/bK;e6=Math.cos(e5);e7.z=e6;if(e6<0.5){return 0}e7.x=dI+bH+e7.offsetX+Math.sin(e5)*bK;e7.y=e7.offsetY;var e4=e7.elContainer.style;if(ey){av(e7.elContainer,e7.x,e7.y,-bK+bK*e7.z,ad*e5)}else{av(e7.elContainer,e7.x,e7.y,bK-bK*e7.z,-ad*e5)}if(at){var e3=(Math.round(120*e6)-20)/100;if(e3<0.99){e4[bL]="brightness("+e3+")"}else{e4[bL]="none"}}return 1};var dM=function(e5){var e3=dI+bH+e5.position+e5.offsetX;if(e3+3*dJ<=0||e3>=aa.width+3*dJ){return 0}e3=Math.max(-bK,Math.min(e5.position,bK));var e4=e5.position/bK;e5.z=Math.cos(e4);e5.x=dI+e5.offsetX+Math.sin(e3/bK)*bK;e5.y=e5.offsetY;aH(e5.elContainer,e5.x,e5.y);e5.elContainer.style.zIndex=ag+Math.round(ag*e5.z);return 1};var c=function(e3){e3.x=dI+bH+e3.position+e3.offsetX;if(e3.x+dJ<=0||e3.x>=aa.width){return 0}e3.x=Math.round(e3.x-dG);e3.y=e3.offsetY;if(e3.x!==e3.placedX){e3.placedX=e3.x;if(cC){e3.elContainer.style.left=e3.y+"px";e3.elContainer.style.top=e3.x+"px"}else{e3.elContainer.style.left=e3.x+"px";e3.elContainer.style.top=e3.y+"px"}}return 1};var eM=function(e3){if(e3.x+dJ<=0||e3.x>=aa.width){return 0}return 1};var bi=function(e4){e4.x=dI+e4.position+e4.offsetX;e4.y=e4.offsetY;e4.z=0;var e3=B.apply(d.scope,[d,e4]);if(e3){ba(e4)}return e3};var al=function(e3){return(e3&&e3.bVisible)};var dC=function(){if(ax.length>0){ax=[]}bF=[];var e6;var e4=u(dG);e6=Math.floor(-e4/dJ);var e3=e4%dJ;bS(e6,e3);var e5=ee(e6,e3);if(db.bEnabled){db.nLastLeftImage=e6-e5+1;db.nLastRightImage=e6+e5-1;if(Z===b&&!eQ){db.nLoad=Math.min(cr,ew.preloadCount)}else{db.nLoad=0}}};var bl=function(e4,e3){if(!e4.bAppended){d0[e4.nIndex]=e4;e4.bAppended=true;ct.appendChild(e4.elContainer);if(!e3){eg(e4)}}};var bw=function(e4,e3){if(e4.bAppended){e4.bAppended=false;if(!e3){eR(e4)}ct.removeChild(e4.elContainer);e4.tsRemovedFromDOM=bE;delete d0[e4.nIndex]}};var es=function(){return 0};var dz=function(e6,e3){var e7;var e5=0;var e4=0;do{e5+=dJ;e4++;e7=bS(e6-e4,e3-e5);e7+=bS(e6+e4,e3+e5)}while(e7>0&&e4<a5);return e4};var cW=function(e6,e3){var e7;var e5=0;var e4=0;do{e5+=dJ;e4++;e7=bS(e6+e4,e3+e5)}while(e7>0&&e4<a5);return e4};var cj=function(){if(!db.nLoad||ax.length>2){return}var e3=1;while(e3>0&&ax.length<6&&db.nLoad>0){e3=0;if(by||db.nLastLeftImage>0){A(--db.nLastLeftImage,true);db.nLoad--;e3++}if(by||db.nLastRightImage<dD){A(++db.nLastRightImage,true);db.nLoad--;e3++}}};var cb=function(){if(dZ){return}dZ=setInterval(bd,dT);bE=a.now()};var ck=function(){if(!dZ){return}clearInterval(dZ);dZ=b};var bd=function(){bE+=dT;if(dQ>a3){cm()}else{ck()}};var cm=function(){if(c9.bImageDragging||dQ<=a3){return}var e5=new Array(dQ);var e6=0;var e8,e3;for(var e7 in bZ){if(bZ.hasOwnProperty(e7)){e8=bZ[e7];if(!e8.bAppended&&e8.bReady){e5[e6++]=bZ[e7]}}}e5=e5.splice(0,e6);e5.sort(cT);var e4=Math.max(0,Math.min(dQ-a3,Math.min(e6,50)));for(e6=0;e6<e4;e6++){e8=e5[e6];e3=e8.nIndex;while(e8.elContainer.firstChild){e8.elContainer.removeChild(e8.elContainer.firstChild)}delete e8.elContainer;delete e8.elLabel;delete e8.img;delete e8.placedX;e8.bPurged=true;e8.bThumbLoadStarted=e8.bLoadComplete=e8.bReady=e8.bImageLoadStarted=false;delete bZ[e3]}dE+=e4;dQ-=e4;cN-=e4};var cT=function(e4,e3){return e4.tsRemovedFromDOM-e3.tsRemovedFromDOM};var E=function(){if(aJ!==b){return}aJ=requestAnimationFrame(bc)};var ao=function(){if(aJ!==b){cancelAnimationFrame(aJ);aJ=b}};var bc=function(){aJ=b;p()};var p=function(){var e3;if(!dZ){bE=a.now()}if(aJ!==b){cancelAnimationFrame(aJ);aJ=b}for(e3 in d0){if(d0.hasOwnProperty(e3)){d0[e3].bVisible=false}}dC();for(e3 in d0){if(d0.hasOwnProperty(e3)){if(!d0[e3].bVisible){bw(d0[e3])}}}if(c8){aH(ct,dG+cB,0)}cu()};var dk=function(e3){if(x!==b){return}dG=u(dG);ds=a.sign(ds)*Math.min(Math.abs(ds),Math.abs(cO)/50);c9.nAutoRotateUpdateCount=0;a.addEvent(cH,"pointerdown",e2);if(e3!==b&&!isNaN(e3)){ds=e3}x=requestAnimationFrame(h);eu(true)};var h=function(){if(by){dG=u(dG-ds)}else{dG-=ds;if(dG>0||dG<-cO){ds=-ds;dG-=ds}}if(di){a7(-dG)}bG(-dG);E();x=requestAnimationFrame(h);eD()};var e2=function(){if(x===b){return}a.removeEvent(cH,"pointerdown",e2);cancelAnimationFrame(x);x=b;eu(false);return false};var cD=function(){var e3=a.getElementDimension(c0);if(e3.width<1){e3.width=1}if(e3.height<1){e3.height=1}if(cC){var e4=e3.width;e3.width=e3.height;e3.height=e4}return e3};var eW=function(){aa=dP=cD()};var aA=function(e3){if(!ex||da.length<1){return}if(aU===b){eA=-dG/dJ;dx=true;aU={};aU.offsetLeft=dG;aU.nAdvance=dJ;aU.nCenter=dI;ao();e2();cancelAnimationFrame(Z);y.cancel();y.enable(false)}if(e3.FSI_after_treshold!==b){dx=false;y.enable(true);aI();ax=[];eW();if(aa.width>1&&aa.height>1){dK();eo();aw()}}bv.run("onResize",[aa.width,aa.height,(e3.FSI_after_treshold!==b)])};var w=function(e4,e3,e5){e4.style.transform="translate("+e3.toFixed(2)+"px,"+e5.toFixed(2)+"px)"};var ef=function(e4,e5,e3){e4.style.transform="translate("+e3.toFixed(2)+"px,"+e5.toFixed(2)+"px)"};var eI=function(e4,e3,e7,e6,e5){e4.style.transform="translate3d("+e3.toFixed(2)+"px,"+e7.toFixed(2)+"px,"+e6.toFixed(2)+"px) rotateY("+e5.toFixed(6)+"rad)"};var dl=function(e4,e7,e3,e6,e5){e4.style.transform="translate3d("+e3.toFixed(2)+"px,"+e7.toFixed(2)+"px,"+e6.toFixed(2)+"px) rotateX("+e5.toFixed(6)+"rad)"};var d2=function(e6){var e5="translate3d("+e6.x.toFixed(2)+"px,"+e6.y.toFixed(2)+"px,"+e6.z.toFixed(2)+"px)";if(e6.rx){e5+=" rotateX("+e6.rx.toFixed(6)+"rad)"}if(e6.ry){e5+=" rotateY("+e6.ry.toFixed(6)+"rad)"}if(e6.rz){e5+=" rotateZ("+e6.rz.toFixed(6)+"rad)"}if(e6.sx){e5+=" scaleX("+e6.sx.toFixed(2)+")"}if(e6.sy){e5+=" scaleY("+e6.sy.toFixed(2)+")"}if(e6.brightness!==b&&at){var e3=e6.brightness;var e4=e6.elContainer.style;if(e3<0.99){e4[bL]="brightness("+e3+")"}else{e4[bL]="none"}}if(e6.bSetZIndex){e6.elContainer.style.zIndex=ag+Math.round(ag*e6.z/bK)}e6.elContainer.style.transform=e5};var cv=function(e6){var e5="translate3d("+e6.y.toFixed(2)+"px,"+e6.x.toFixed(2)+"px,"+e6.z.toFixed(2)+"px)";if(e6.rx){e5+=" rotateY("+e6.rx.toFixed(6)+"rad)"}if(e6.ry){e5+=" rotateX("+e6.ry.toFixed(6)+"rad)"}if(e6.rz){e5+=" rotateZ("+e6.rz.toFixed(6)+"rad)"}if(e6.sx){e5+=" scaleY("+e6.sx.toFixed(2)+")"}if(e6.sy){e5+=" scaleX("+e6.sy.toFixed(2)+")"}if(e6.brightness!==b&&at){var e3=e6.brightness;var e4=e6.elContainer.style;if(e3<0.99){e4[bL]="brightness("+e3+")"}else{e4[bL]="none"}}if(e6.bSetZIndex){e6.elContainer.style.zIndex=ag+Math.round(ag*e6.z/bK)}e6.elContainer.style.transform=e5};var bP=function(e5){if(cG>0){for(var e6 in cl){if(cl.hasOwnProperty(e6)){var e3=cl[e6];for(var e4=0;e4<e3.length;e4++){if(!e5||e3[e4].bByConfig){aE.unRegisterButton(e3[e4].el)}}}}}};var M=function(e3){if(ca&&ca.img){a.removeClass(ca.elContainer,"fsi-selected-thumb")}if(e3){if(e3.elContainer){a.addClass(e3.elContainer,"fsi-selected-thumb")}ca=e3}else{ca=b}};var bm=function(){if(dN){if(a.touchZoom&&dN.getInstanceName()!==a.touchZoom.getInstanceName()){dN.destroy()}dN=b}};var eb=function(){if(!er){return}er=false;if(aD){a.removeEvent(window,"FSITouchZoomLoaded",ci);aD=false}M();if(du!==b){a.removeCustomEvent(aE,"FSIViewport",dr);du=b}bP();ck();if(em){em.destroy()}eP();bm();if(dR){clearTimeout(dR);dR=b}z();eK();dj.removeAttribute("data-fsi-id");aI();for(var e3 in aC){if(aC.hasOwnProperty(e3)){bD(aC[e3])}}aC={};if(e0!==b){a.removeCustomEvent(dj,"FSIElementDimension",aA);e0=b}ax=[];e2();bf=b;d8(b,true);d7=0;cancelAnimationFrame(dY);cancelAnimationFrame(aJ);aJ=b;cancelAnimationFrame(Z);Z=b;cancelAnimationFrame(au);au=b;bF=[];db={};if(y){y.destroy();y=b}dG=aR=0;a8=b;eL=[];Y=0;a.removeChild(c0.parentNode,c0);if(bv){bv.run("onDestroy");bv.destroy()}};var c5=function(){if(!Z){return dG}else{return eO.end}};this.init=b7;this.destroy=eb;this.getInitDone=function(){return er};this.addListener=function(e6,e4,e5){var e3=false;if(bv){e3=bv.addListener(e6,e4,e5)}return e3};this.changeDir=function(e3){return eV(e3)};this.removeListener=function(e5,e4){var e3=false;if(bv){e3=bv.removeListener(e5,e4)}return e3};this.getImageCount=function(){return d6};this.getCurrentImageIndex=function(){return bJ};this.setScrollPos=P;this.getScrollPos=function(){return -dG};this.isScrolling=function(){return eQ};this.firstImage=function(e3){N(0,false,e3)};this.lastImage=function(e3){var e4=(by)?-cO+dJ:-cO;N(e4,false,e3)};this.previousPage=function(e3){N(c5()+aa.width,false,e3)};this.nextPage=function(e3){N(c5()-aa.width,false,e3)};this.nextImage=function(e3){N(c5()-dJ,false,e3)};this.previousImage=function(e3){N(c5()+dJ,false,e3)};this.assignFSIViewer=function(e3){ce=e3;if(aB){clearTimeout(aB);aB=b}dH=0;aG(e3)};var aG=function(){var e3=ce;aB=b;dH++;var e4=e3;if(e4&&typeof(e4)==="string"){if(e4.toLowerCase()==="auto"){var e5=document.getElementsByTagName("fsi-viewer");if(e5&&e5.length>0){e3=e5[0]}else{e3=b}}else{e3=document.querySelector(e4);if(!e3){e3=document.getElementById(e4)}}}if(!e3||typeof(e3.changeImage)!=="function"){cz=b}else{cz=e3}a9=false;bO();if(!cz&&dH<10){aB=setTimeout(aG,250)}else{br()}return cz};this.focusImage=function(e3){if(isNaN(e3)){return}e3=Math.round(e3);if(e3<0||e3>=eL){return false}var e4=A(e3);be(e4);return true};this.startAutoRotate=dk;this.stopAutoRotate=e2;this.zoomImage=function(e3){if(!ew.enableZoom||!this.focusImage(e3)){return false}var e4=A(e3);bf=e4.nIndex;cq()};this.destroyOnDetach=function(){if(ew&&ew.autoDestroy!==false){eb()}};var C={lastimage:{fn:this.lastImage,bSingleCommand:true},firstimage:{fn:this.firstImage,bSingleCommand:false},nextimage:{fn:this.nextImage},previousimage:{fn:this.previousImage},nextpage:{fn:this.nextPage,ntRepeat:350},previouspage:{fn:this.previousPage,ntRepeat:350}};var bU=this.buttonDown=function(e3){if(typeof(e3)!=="string"){return false}e3=e3.toLowerCase();if(!C[e3]){return false}if(eG.cmd){if(e3===eG.cmd){return false}aq()}if(C[e3].ntRepeat){eG.ntRepeat=C[e3].ntRepeat}else{eG.ntRepeat=125}eG.fn=C[e3].fn;eG.bSingleCommand=C[e3].bSingleCommand;eG.cmd=e3;eG.repeat=0;eG.nInterval=setInterval(eZ,350);eZ()};var eZ=function(){eG.fn.apply(aE);eG.repeat++;if(eG.bSingleCommand){aq()}else{if(eG.repeat===2){clearInterval(eG.nInterval);eG.nInterval=setInterval(eZ,eG.ntRepeat)}}};var aq=this.buttonUp=function(){if(eG.nInterval){clearInterval(eG.nInterval)}eG.cmd=b};this.registerButton=function(e4,e5,e6){if(typeof(e4)==="string"){e4=document.getElementById(e4)}if(!e4||typeof(e4)!=="object"||typeof(e4.tagName)!=="string"){return false}e5=e5.toLowerCase();if(!C[e5]){return false}if(!e4.x_fsi_thumbbar_cmd_count){e4.setAttribute("data-fsi-thumbbar-cmd",e5);e4.x_fsi_thumbbar_cmd_count=1}else{e4.x_fsi_thumbbar_cmd_count++}a.addEvent(e4,"contextmenu",a.preventDefaultEvent);a.addEvent(e4,"mousedown",co);if(a.isEventSupported("touchstart")){a.addEvent(e4,"touchstart",co,{passive:false})}cG++;var e3=cl[e5];if(e3===b){e3=cl[e5]=[]}e3.push({el:e4,bByConfig:e6});return true};this.changeConfig=dd;var b5=function(e3){a.addEvent(window,"mouseup",b6);if(a.isEventSupported("touchstart")){a.addEvent(e3,"touchcancel",b6);a.addEvent(e3,"touchend",b6)}};var k=function(e3){a.removeEvent(window,"mouseup",b6);if(a.isEventSupported("touchstart")){a.removeEvent(e3,"touchcancel",b6);a.removeEvent(e3,"touchend",b6)}};this.unRegisterButton=function(e3){if(typeof(e3)==="string"){e3=document.getElementById(e3)}if(!e3||typeof(e3)!=="object"||typeof(e3.tagName)!=="string"||!e3.x_fsi_thumbbar_cmd_count){return false}if(--e3.x_fsi_thumbbar_cmd_count===0){e3.x_fsi_thumbbar_cmd_count=b;e3.removeAttribute("data-fsi-thumbbar-cmd")}a.removeEvent(e3,"mousedown",co);if(a.isEventSupported("touchstart")){a.removeEvent(e3,"touchstart",co,{passive:false})}k(e3);cG--;return true};var b6=function(){if(dB){a.removeClass(dB,"fsi-pressed")}aq();k(dB);dB=b};var co=function(e3){if(dB){b6()}var e4=e3.target||e3.srcElement;if(!e4||!e4.getAttribute("data-fsi-thumbbar-cmd")){return}dB=e4;b5(e4);var e5=e4.getAttribute("data-fsi-thumbbar-cmd");a.addClass(e4,"fsi-pressed");bU(e5);a.preventDefaultEvent(e3);return true};if(typeof(cQ)!=="object"||a.makeBool(cQ.autoInit,true)){aE.init(ep,cQ)}};a.customTags.register("fsi-thumbbar",{constructorClass:a.ThumbBar,viewerCSS:"display:block;width:300px;height:300px;"});a.dispatchEvent("FSIThumbBarLoaded")}(window.$FSI=window.$FSI||{}));