/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.EncryptionToken;
import org.apache.ws.secpolicy.model.Layout;
import org.apache.ws.secpolicy.model.ProtectionToken;
import org.apache.ws.secpolicy.model.SignatureToken;
import org.apache.ws.secpolicy.model.SymmetricAsymmetricBindingBase;

public class SymmetricBinding
extends SymmetricAsymmetricBindingBase {
    private EncryptionToken encryptionToken;
    private SignatureToken signatureToken;
    private ProtectionToken protectionToken;

    public SymmetricBinding(int version) {
        super(version);
    }

    public EncryptionToken getEncryptionToken() {
        return this.encryptionToken;
    }

    public void setEncryptionToken(EncryptionToken encryptionToken) {
        if (this.protectionToken != null) {
            // empty if block
        }
        this.encryptionToken = encryptionToken;
    }

    public ProtectionToken getProtectionToken() {
        return this.protectionToken;
    }

    public void setProtectionToken(ProtectionToken protectionToken) {
        if (this.encryptionToken != null || this.signatureToken != null) {
            // empty if block
        }
        this.protectionToken = protectionToken;
    }

    public SignatureToken getSignatureToken() {
        return this.signatureToken;
    }

    public void setSignatureToken(SignatureToken signatureToken) {
        if (this.protectionToken != null) {
            // empty if block
        }
        this.signatureToken = signatureToken;
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.SYMMETRIC_BINDING;
        }
        return SP11Constants.SYMMETRIC_BINDING;
    }

    public PolicyComponent normalize() {
        if (this.isNormalized()) {
            return this;
        }
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        List configurations = algorithmSuite.getConfigurations();
        Policy policy = new Policy();
        ExactlyOne exactlyOne = new ExactlyOne();
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            All wrapper = new All();
            SymmetricBinding symmetricBinding = new SymmetricBinding(this.version);
            algorithmSuite = (AlgorithmSuite)iterator.next();
            symmetricBinding.setAlgorithmSuite(algorithmSuite);
            symmetricBinding.setEncryptionToken(this.getEncryptionToken());
            symmetricBinding.setEntireHeadersAndBodySignatures(this.isEntireHeadersAndBodySignatures());
            symmetricBinding.setIncludeTimestamp(this.isIncludeTimestamp());
            symmetricBinding.setLayout(this.getLayout());
            symmetricBinding.setProtectionOrder(this.getProtectionOrder());
            symmetricBinding.setProtectionToken(this.getProtectionToken());
            symmetricBinding.setSignatureProtection(this.isSignatureProtection());
            symmetricBinding.setSignatureToken(this.getSignatureToken());
            symmetricBinding.setSignedEndorsingSupportingTokens(this.getSignedEndorsingSupportingTokens());
            symmetricBinding.setSignedSupportingToken(this.getSignedSupportingToken());
            symmetricBinding.setTokenProtection(this.isTokenProtection());
            symmetricBinding.setNormalized(true);
            wrapper.addPolicyComponent((PolicyComponent)symmetricBinding);
            exactlyOne.addPolicyComponent((PolicyComponent)wrapper);
        }
        policy.addPolicyComponent((PolicyComponent)exactlyOne);
        return policy;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        SymmetricBinding.writeStartElement(writer, prefix, localname, namespaceURI);
        SymmetricBinding.writeStartElement(writer, SPConstants.POLICY);
        if (this.encryptionToken != null) {
            this.encryptionToken.serialize(writer);
        } else if (this.protectionToken != null) {
            this.protectionToken.serialize(writer);
        } else {
            throw new RuntimeException("Either EncryptionToken or ProtectionToken must be set");
        }
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        if (algorithmSuite == null) {
            throw new RuntimeException("AlgorithmSuite must be set");
        }
        algorithmSuite.serialize(writer);
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.serialize(writer);
        }
        if (this.isIncludeTimestamp()) {
            SymmetricBinding.writeEmptyElement(writer, prefix, "IncludeTimestamp", namespaceURI);
        }
        if ("EncryptBeforeSigning".equals(this.getProtectionOrder())) {
            SymmetricBinding.writeEmptyElement(writer, prefix, "EncryptBeforeSigning", namespaceURI);
        }
        if (this.isSignatureProtection()) {
            SymmetricBinding.writeEmptyElement(writer, prefix, "EncryptSignature", namespaceURI);
        }
        if (this.isEntireHeadersAndBodySignatures()) {
            writer.writeEmptyElement(prefix, "OnlySignEntireHeadersAndBody", namespaceURI);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

