/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class OrDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Or"}, {"LocalName", "Or"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("OrDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/OrDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public OrDescriptor() {
        super(resources, supportedModes, 2, null, null, null, null);
    }

    protected boolean validateSources(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateSources(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        for (int i = 0; i < 2; ++i) {
            RenderedImage renderedImage = parameterBlock.getRenderedSource(i);
            int n = renderedImage.getSampleModel().getDataType();
            if (n == 0 || n == 1 || n == 2 || n == 3) continue;
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("OrDescriptor1"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, RenderedImage renderedImage2, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Or", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setSource("source1", renderedImage2);
        return JAI.create("Or", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, RenderableImage renderableImage2, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Or", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setSource("source1", renderableImage2);
        return JAI.createRenderable("Or", parameterBlockJAI, renderingHints);
    }
}

