/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rampart.ExtendedPolicyValidatorCallbackHandler;
import org.apache.rampart.PolicyValidatorCallbackHandler;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.ServiceNonceCache;
import org.apache.rampart.TokenCallbackHandler;
import org.apache.rampart.ValidatorData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.saml.SAMLAssertionHandler;
import org.apache.rampart.saml.SAMLAssertionHandlerFactory;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.secpolicy.model.UsernameToken;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RampartEngine {
    private static Log log = LogFactory.getLog(RampartEngine.class);
    private static Log tlog = LogFactory.getLog((String)"org.apache.rampart.TIME");
    private static ServiceNonceCache serviceNonceCache = new ServiceNonceCache();

    public List<WSSecurityEngineResult> process(MessageContext msgCtx) throws WSSPolicyException, RampartException, WSSecurityException, AxisFault {
        List results;
        boolean dotDebug = tlog.isDebugEnabled();
        log.debug((Object)"Enter process(MessageContext msgCtx)");
        RampartMessageData rmd = new RampartMessageData(msgCtx, false);
        RampartPolicyData rpd = rmd.getPolicyData();
        msgCtx.setProperty("rampartPolicyData", (Object)rpd);
        RampartUtil.validateTransport(rmd);
        if (rpd == null) {
            return null;
        }
        if (this.isSecurityFault(rmd) || !RampartUtil.isSecHeaderRequired(rpd, rmd.isInitiator(), true)) {
            SOAPEnvelope env = Axis2Util.getSOAPEnvelopeFromDOMDocument(rmd.getDocument(), true);
            msgCtx.setEnvelope(env);
            Axis2Util.useDOOM(false);
            log.debug((Object)"Return process MessageContext msgCtx)");
            return null;
        }
        WSSecurityEngine engine = new WSSecurityEngine();
        ValidatorData data = new ValidatorData(rmd);
        SOAPHeader header = rmd.getMsgContext().getEnvelope().getHeader();
        if (header == null) {
            throw new RampartException("missingSOAPHeader");
        }
        ArrayList headerBlocks = header.getHeaderBlocksWithNSURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SOAPHeaderBlock secHeader = null;
        if (headerBlocks != null) {
            for (SOAPHeaderBlock elem : headerBlocks) {
                if (!elem.getLocalName().equals("Security")) continue;
                secHeader = elem;
                break;
            }
        }
        if (secHeader == null) {
            throw new RampartException("missingSecurityHeader");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (dotDebug) {
            t0 = System.currentTimeMillis();
        }
        if (!rmd.isInitiator()) {
            Collection<UsernameToken> usernameTokens = RampartUtil.getUsernameTokens(rpd);
            for (UsernameToken usernameTok : usernameTokens) {
                if (!usernameTok.isNoPassword()) continue;
                log.debug((Object)"Found UsernameToken with no password assertion in policy, configuring ws security processing to allow username tokens without password.");
                engine.getWssConfig().setAllowUsernameTokenNoPassword(true);
                break;
            }
        }
        String actorValue = secHeader.getAttributeValue(new QName(rmd.getSoapConstants().getEnvelopeURI(), "actor"));
        Crypto signatureCrypto = RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader());
        TokenCallbackHandler tokenCallbackHandler = new TokenCallbackHandler(rmd.getTokenStorage(), RampartUtil.getPasswordCB(rmd));
        if (rpd.isSymmetricBinding()) {
            log.debug((Object)"Processing security header using SymetricBinding");
            results = engine.processSecurityHeader(rmd.getDocument(), actorValue, (CallbackHandler)tokenCallbackHandler, signatureCrypto, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader()));
            if (rmd.isInitiator() && (msgCtx.getFLOW() == 1 || msgCtx.getFLOW() == 3)) {
                tokenCallbackHandler.removeEncryptedToken();
            }
        } else {
            log.debug((Object)"Processing security header in normal path");
            results = engine.processSecurityHeader(rmd.getDocument(), actorValue, (CallbackHandler)tokenCallbackHandler, signatureCrypto, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader()));
        }
        if (dotDebug) {
            t1 = System.currentTimeMillis();
        }
        for (int j = 0; j < results.size(); ++j) {
            WSSecurityEngineResult wser = (WSSecurityEngineResult)results.get(j);
            Integer actInt = (Integer)wser.get((Object)"action");
            if (8 == actInt) {
                Object samlAssertion = wser.get((Object)"saml-assertion");
                SAMLAssertionHandler samlAssertionHandler = SAMLAssertionHandlerFactory.createAssertionHandler(samlAssertion);
                if (samlAssertionHandler.isBearerAssertion()) break;
                try {
                    TokenStorage store = rmd.getTokenStorage();
                    if (store.getToken(samlAssertionHandler.getAssertionId()) != null) continue;
                    Token token = new Token(samlAssertionHandler.getAssertionId(), samlAssertionHandler.getAssertionElement(), samlAssertionHandler.getDateNotBefore(), samlAssertionHandler.getDateNotOnOrAfter());
                    token.setSecret(samlAssertionHandler.getAssertionKeyInfoSecret(signatureCrypto, tokenCallbackHandler));
                    store.add(token);
                    continue;
                }
                catch (Exception e) {
                    throw new RampartException("errorInAddingTokenIntoStore", e);
                }
            }
            if (1 == actInt) {
                String serviceEndpointName;
                boolean valueRepeating;
                WSUsernameTokenPrincipal userNameTokenPrincipal = (WSUsernameTokenPrincipal)wser.get((Object)"principal");
                String username = userNameTokenPrincipal.getName();
                msgCtx.setProperty("username", (Object)username);
                if (userNameTokenPrincipal.getNonce() == null) continue;
                int nonceLifeTimeInSeconds = 0;
                if (rpd.getRampartConfig() != null) {
                    String stringLifeTime = rpd.getRampartConfig().getNonceLifeTime();
                    try {
                        nonceLifeTimeInSeconds = Integer.parseInt(stringLifeTime);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)"Invalid value for nonceLifeTime in rampart configuration file.", (Throwable)e);
                        throw new RampartException("invalidNonceLifeTime", e);
                    }
                }
                if (valueRepeating = serviceNonceCache.isNonceRepeatingForService(serviceEndpointName = msgCtx.getAxisService().getEndpointName(), username, userNameTokenPrincipal.getNonce())) {
                    throw new RampartException("repeatingNonceValue", new Object[]{userNameTokenPrincipal.getNonce(), username});
                }
                serviceNonceCache.addNonceForService(serviceEndpointName, username, userNameTokenPrincipal.getNonce(), nonceLifeTimeInSeconds);
                continue;
            }
            if (2 != actInt) continue;
            X509Certificate cert = (X509Certificate)wser.get((Object)"x509-certificate");
            if (rpd.isAsymmetricBinding() && cert == null && rpd.getInitiatorToken() != null && !rpd.getInitiatorToken().isDerivedKeys()) {
                throw new RampartException("invalidSignatureAlgo");
            }
            msgCtx.setProperty("X509Certificate", (Object)cert);
        }
        SOAPEnvelope env = Axis2Util.getSOAPEnvelopeFromDOMDocument(rmd.getDocument(), true);
        if (dotDebug) {
            t2 = System.currentTimeMillis();
        }
        msgCtx.setEnvelope(env);
        Axis2Util.useDOOM(false);
        PolicyValidatorCallbackHandler validator = RampartUtil.getPolicyValidatorCB(msgCtx, rpd);
        if (validator instanceof ExtendedPolicyValidatorCallbackHandler) {
            ExtendedPolicyValidatorCallbackHandler extendedPolicyValidatorCallbackHandler = (ExtendedPolicyValidatorCallbackHandler)validator;
            extendedPolicyValidatorCallbackHandler.validate(data, results);
        } else {
            Vector resultsVector = new Vector(results);
            validator.validate(data, resultsVector);
        }
        if (dotDebug) {
            t3 = System.currentTimeMillis();
            tlog.debug((Object)("processHeader by WSSecurityEngine took : " + (t1 - t0) + ", DOOM conversion took :" + (t2 - t1) + ", PolicyBasedResultsValidattor took " + (t3 - t2)));
        }
        log.debug((Object)"Return process(MessageContext msgCtx)");
        return results;
    }

    private boolean isSecurityFault(RampartMessageData rmd) {
        SOAPFault soapFault = rmd.getMsgContext().getEnvelope().getBody().getFault();
        return soapFault == null ? false : RampartUtil.isSecurityFault(soapFault);
    }
}

