<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/linkbutton.ftl">

  <@tableHeader Heading="Delete Skin" />
  
  <#if request_confirmation??>
  
    <form action="pt.do" method="POST" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="deleteskin">
    <input type="hidden" name="confirmed" value="1">
    <input type="hidden" name="skinname" value="${skinname}">
    <#if user?? >
    <input type="hidden" name="user" value="${user}">
    </#if>

    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
     <tr>
      <td class="sectionheader">Delete selected skin?</td>
     </tr>
     <tr><td><hr size="1" class="hr1"/></td></tr>
     <tr> 
      <td class="pad1">Are you sure you want to delete skin "${skinname}"? All published codesnips referring to this 
      skin or to configuration files where this skin is referenced will be broken.</td>
     </tr>
     <tr>
      <td class="pad1" style="text-align:right; padding-top: 20px;">
       <span class="btnwhite" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
       <@formsubmit value="Delete" />
      </td>
     </tr>
    </table>
    </form>
      
  <#elseif show_error?? >
  
   <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
     <tr>
      <td class="sectionheader">Error</td>
     </tr>
     <tr><td><hr size="1" class="hr1"/></td></tr>
     <tr>
      <td class="pad1">
  	   <#if message??><span style="color: red">${message}</span><br /><br /></#if>
  	  </td>
  	 </tr>
  	 <tr>
      <td class="pad1" style="text-align:right;">
       <span class="btnwhite" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Back</span>     
      </td>
     </tr> 
   </table>
  	
  <#elseif show_confirmation?? > 
  
    <table cellspacing="0" cellpadding="0" style="border: 0px;">
     <tr>
       <td class="sectionheader">
  	    <#if all_deleted >
  	     Skin deleted
  	    <#else>
  	     Incomplete deletion
  	    </#if>
  	   </td>
  	 </tr>
     <tr><td><hr size="1" class="hr1"/></td></tr>
     <tr>
      <td class="pad1">
  	   <#if all_deleted >
  		The skin "${skinname}" was successfully deleted.<br /><br />
	   <#else>
		Some of the files could not be deleted please check manually or contact your system administrator.<br /><br />
	   </#if>
	  </td>
	 </tr>
	 <tr>
      <td class="pad1" style="text-align: right";>
       <#if user??>
        <@linkbutton value="Ok" targeturl="pt.do?action=listskins&user=${user}" />
	   <#else>
        <@linkbutton value="Ok" targeturl="pt.do?action=listskins&defaultviewer=true" />
       </#if>
      </td>
     </tr>
	</table>
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">