/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.formats.jpeg.segments.Segment;

public class SosSegment
extends Segment {
    public final int numberOfComponents;
    public final Component[] components;
    public final int startOfSpectralSelection;
    public final int endOfSpectralSelection;
    public final int successiveApproximationBitHigh;
    public final int successiveApproximationBitLow;

    public SosSegment(int marker, byte[] segmentData) throws IOException {
        this(marker, segmentData.length, new ByteArrayInputStream(segmentData));
    }

    public SosSegment(int marker, int marker_length, InputStream is) throws IOException {
        super(marker, marker_length);
        if (this.getDebug()) {
            System.out.println("SosSegment marker_length: " + marker_length);
        }
        this.numberOfComponents = this.readByte("number_of_components_in_scan", is, "Not a Valid JPEG File");
        this.components = new Component[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            byte scan_component_selector = this.readByte("scan_component_selector", is, "Not a Valid JPEG File");
            byte ac_dc_entropy_coding_table_selector = this.readByte("ac_dc_entrooy_coding_table_selector", is, "Not a Valid JPEG File");
            int dcCodingTableSelector = ac_dc_entropy_coding_table_selector >> 4 & 0xF;
            int acCodingTableSelector = ac_dc_entropy_coding_table_selector & 0xF;
            this.components[i] = new Component(scan_component_selector, dcCodingTableSelector, acCodingTableSelector);
        }
        this.startOfSpectralSelection = this.readByte("start_of_spectral_selection", is, "Not a Valid JPEG File");
        this.endOfSpectralSelection = this.readByte("end_of_spectral_selection", is, "Not a Valid JPEG File");
        byte successive_approximation_bit_position = this.readByte("successive_approximation_bit_position", is, "Not a Valid JPEG File");
        this.successiveApproximationBitHigh = successive_approximation_bit_position >> 4 & 0xF;
        this.successiveApproximationBitLow = successive_approximation_bit_position & 0xF;
        if (this.getDebug()) {
            System.out.println("");
        }
    }

    public String getDescription() {
        return "SOS (" + this.getSegmentType() + ")";
    }

    public static class Component {
        public final int scanComponentSelector;
        public final int dcCodingTableSelector;
        public final int acCodingTableSelector;

        public Component(int scanComponentSelector, int dcCodingTableSelector, int acCodingTableSelector) {
            this.scanComponentSelector = scanComponentSelector;
            this.dcCodingTableSelector = dcCodingTableSelector;
            this.acCodingTableSelector = acCodingTableSelector;
        }
    }
}

