<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/linkbutton.ftl">

  <@tableHeader Heading="Add Group" />

  <#if show_groups_exceeded_message?? >
  
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr><td>
   The maximum number of groups permitted by the installed licence has been reached. Creating more groups will 
   invalidate the licence and is therefore not supported in this interface. 
      </td></tr>
   </table>
   
  <#elseif ldap_managed_groups?? >
   
   Groups are managed by an external LDAP server and cannot be modified here.

  <#elseif show_form?? >

   <form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="addgroup">
    <input type="hidden" name="save" value="1">
      
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
       <td class="pad1" colspan="2">
        <#if message??>
         <span style="color: red">${message}</span>
        <#else>
         Enter the group properties below and press the save button. The group will be created an is immediately usable.
        </#if>
       </td>
      </tr>
      <tr>
       <td class="sectionheader" colspan="2">Group Properties</td>
      </tr>
      <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
      <tr>
       <td class="pad1">Group Name</td>
       <td class="pad1" align="right"><input type="text" class="inwhite" name="name" <#if name?? >value="${name}"</#if> help="<@appID/>:groups_name" /></td>
      </tr>
      <tr>
       <td class="pad1">Permission Set</td>
       <td class="pad1" align="right"><@formgfxselect objid="permissionset" itemlist=available_permissionsets preselect=permissionset helpid="group_permissionset" /></td>
      </tr>
      <tr>
       <td class="pad1">Property Set</td>
       <td class="pad1" align="right"><@formgfxselect objid="propertyset" itemlist=available_propertysets preselect=propertyset helpid="group_propertyset" /></td>
      </tr>
      <tr>
        <td class="pad1" style="padding-top: 20px;" colspan="2" align="right">
          <@linkbutton value="Cancel" targeturl="pt.do?action=listgroups" />
          <@formsubmit value="Save" helpid="groups_save" />	
        </td>
      </tr>
      </table>
    </form>

  <#elseif show_error?? >
  
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
       <td class="sectionheader">Error saving group</td>
      </tr>
      <tr><td><hr size="1" class="hr1"/></td></tr>
      <tr>
       <td class="pad1">
        Error saving the group, please contact the Administrator or check the server logfiles. 
       </td>
      </tr>
      <tr>
       <td class="pad1" style="text-align: right;">
        <@linkbutton value="Ok" targeturl="pt.do?action=listgroups" /> 
       </td>
      </tr>
    </table>    

  <#elseif show_confirmation?? >
    
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
       <td class="sectionheader" colspan="2">Group Saved</td>
      </tr>
      <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
      <tr>
       <td class="pad1" colspan="2">
         Please wait for the changes to take effect.
       </td>
      </tr>
    </table>
    <#assign timeout="5" />
    <#assign postprogresslocation="action=listgroups">
    <#include "/sub/progressbar.ftl">
    
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">