<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">
<#include "/macros/formtable.ftl">
<#include "/macros/barchart.ftl">
<#include "/macros/byteprint.ftl">
<#include "/macros/timeprint.ftl">

  <@tableHeader Heading="Search Database" />

  <#if show_summary?? >

    <#if message??>
      ${message}<br /><br />
    </#if>
    
    <table cellspacing="0" cellpadding="0" style="border:0px; width: 500px;" >
    
      <tr>
	   <td class="pad1" colspan="2">
		FSI Server uses an external Solr Server to search the asset metadata. <br /><br />
	   </td>
	  </tr>
	  <tr>
	    <td class="pad1" style="font-weight: bold;" colspan="2">Solr Server</td>
	  </tr>
      <tr>
	    <td colspan="2"><hr size="1" class="hr1"/></td>
	  </tr>
	  <tr>
	    <td class="pad1" style="font-weight: bold;">Location</td>
	    <td class="pad1" style="font-weight: bold;">Core</td>
	  </tr>
      <tr>
        <td class="pad1">${solrserveruri}</td>
        <td class="pad1">${solrcore}</td>
      </tr>
      
      <#if solrserver_found?? >
      
      <tr>
	    <td class="pad1" style="font-weight: bold; padding-top: 30px;" colspan="2">System</td>
	  </tr>
      <tr>
	    <td colspan="2"><hr size="1" class="hr1"/></td>
	  </tr>
      <tr>
        <td class="pad1" style="font-weight: bold;">Details</td> 
        <td class="pad1">${system.name} (${system.version})</td>
      </tr>
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">Physical Memory</td> 
        <td class="pad1" style="padding-top: 10px;"><@barChart used=(system.physical_memory.total - system.physical_memory.free) total=system.physical_memory.total height=20 width=400 />
                         <@bytePrint bytes=system.physical_memory.total /> Total, <@bytePrint bytes=(system.physical_memory.total - system.physical_memory.free) /> Used, <@bytePrint bytes=system.physical_memory.free /> Free</td>
      </tr>
      <tr>
		<td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">Swap Space</td> 
        <td class="pad1" style="padding-top: 10px;"><@barChart used=(system.swap_space.total - system.swap_space.free) total=system.swap_space.total height=20 width=400 />
                         <@bytePrint bytes=system.swap_space.total /> Total, <@bytePrint bytes=(system.swap_space.total - system.swap_space.free) /> Used, <@bytePrint bytes=system.swap_space.free /> Free</td>
      </tr>            
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">File Descriptors</td> 
        <td class="pad1" style="padding-top: 10px;"><@barChart used=system.files.open total=system.files.max height=20 width=400 />
        				 ${system.files.max} Max, ${system.files.open} Open</td>
      </tr>
      
      <tr>
	    <td class="pad1" style="font-weight: bold; padding-top: 30px;" colspan="2">JVM</td>
	  </tr>
      <tr>
	    <td colspan="2"><hr size="1" class="hr1"/></td>
	  </tr>
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">Details</td> 
        <td class="pad1">${jvm.name} (${jvm.version})</td>
      </tr>
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">Memory</td> 
        <td class="pad1" style="padding-top: 10px;"><@barChart used=jvm.memory.used total=jvm.memory.total height=20 width=400 />
        				 <@bytePrint bytes=jvm.memory.total /> Heap Size, <@bytePrint bytes=jvm.memory.used /> Used Heap, <@bytePrint bytes=jvm.memory.max /> Max Heap</td>
      </tr>
      
      <tr>
	    <td class="pad1" style="font-weight: bold; padding-top: 30px;" colspan="2">Core</td>
	  </tr>
      <tr>
	    <td colspan="2"><hr size="1" class="hr1"/></td>
	  </tr>
	  <#if solrcore_found?? >
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">Name</td> 
        <td class="pad1">${core.name}</td>
      </tr>
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">Directory</td> 
        <td class="pad1">${core.instance_dir}</td>
      </tr>
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">Config</td> 
        <td class="pad1">${core.config}</td>
      </tr>
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">Schema</td> 
        <td class="pad1">${core.schema}</td>
      </tr>
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">Uptime</td> 
        <td class="pad1"><@timeSpanPrint seconds=core.uptime /></td>
      </tr>
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;"># of Documents</td> 
        <td class="pad1">${core.num_docs}</td>
      </tr>
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">Max Documents</td> 
        <td class="pad1">${core.max_docs}</td>
      </tr>
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">Size</td> 
        <td class="pad1"><@bytePrint bytes=core.size /></td>
      </tr>
      <#if core.last_modified??>
      <tr>
        <td class="pad1" style="font-weight: bold; vertical-align: top; padding-top: 10px;">Last Modified</td> 
        <td class="pad1">${core.last_modified}</td>
      </tr>
      </#if>
      
      <#else>
      
      <tr>
        <td colspan="2" class="pad1"><font color="red">Could not get information on the configured Solr Core.</font></td>
      </tr>
      
      </#if>
      
      <tr>
	    <td class="pad1" style="font-weight: bold; padding-top: 30px;" colspan="2">Consistency Check</td>
	  </tr>
      <tr>
	    <td colspan="2"><hr size="1" class="hr1"/></td>
	  </tr>
            
      <tr>
        <td class="pad1">Status</td> 
        <td class="pad1">${check_status}</td>
      </tr>
      <tr>
        <td class="pad1">Check scheduled</td> 
        <td class="pad1">${check_scheduled?string}</td>
      </tr>
      
      <tr>
        <td class="pad1" style="font-weight: bold; padding-bottom: 20px;" colspan="2" align="right">
          <form action="pt.do" method="post" onsubmit="this.submit();">    
          <@printRequiredParams method="post" />
          <input type="hidden" name="action" value="searchdb">
          <input type="hidden" name="schedule_check" value="1">
          <#assign checkbutton_disabled = (check_status == "checking" || check_scheduled)?string />
          <@formsubmit value="Schedule Check" disabled=checkbutton_disabled helpid="searchdatabase_schedule_rebuild" />
	      </form>
        </td>
      </tr>
      
      <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
      <tr>
        <td class="pad1" align="left">
          <form action="pt.do" method="get" onsubmit="this.submit();">    
          <@printRequiredParams method="post" />
          <input type="hidden" name="action" value="searchdb">
          <@formsubmit value="Refresh" helpid="searchdatabase_refresh" />
	      </form>
        </td>
      </tr>
      
      <#else>
      
      <tr>
	    <td colspan="2"><hr size="1" class="hr1"/></td>
	  </tr>
	  <tr>
        <td class="pad1"><font color="red">Could not connect to the Solr Server. Status information not available.</font></td>
      </tr>
      
      </#if>
      
      </table>
    
  <#elseif show_check_request?? > 
    
    <table cellspacing="0" cellpadding="0" border="0" width="500px">
	<tr>
	  <td style="text-align: left; padding-top: 30px;" colspan="2">
	    Really schedule a consistency check of the search database?    
      </td>
	</tr>
    <tr>
      <td class="pad1" align="right">
          <form action="pt.do" method="post" onsubmit="this.submit();">    
          <@printRequiredParams method="post" />
          <input type="hidden" name="action" value="searchdb">
          <input type="hidden" name="schedule_check" value="1">
          <input type="hidden" name="confirmed" value="1">
          <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
          <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="spansubmit(this);">Schedule Check</span>
	      </form>
        </td>
    </tr>
    </table>
      
  <#elseif show_disabled?? >      
      
     <table cellspacing="0" cellpadding="0" style="border:0px; width: 500px;" >
    
      <tr>
	   <td class="pad1">
		The search database is disabled. Please check the configuration or the logfiles for details.<br /><br />
	   </td>
	  </tr>
	 </table> 
      
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">