/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.formats.png.BitParser;
import org.apache.commons.imaging.formats.png.GammaCorrection;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPlte;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilter;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilterAverage;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilterNone;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilterPaeth;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilterSub;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilterUp;
import org.apache.commons.imaging.formats.png.transparencyfilters.TransparencyFilter;

public abstract class ScanExpediter
extends BinaryFileParser {
    protected final int width;
    protected final int height;
    protected final InputStream is;
    protected final BufferedImage bi;
    protected final int colorType;
    protected final int bitDepth;
    protected final int bytesPerPixel;
    protected final int bitsPerPixel;
    protected final PngChunkPlte pngChunkPLTE;
    protected final GammaCorrection gammaCorrection;
    protected final TransparencyFilter transparencyFilter;

    public ScanExpediter(int width, int height, InputStream is, BufferedImage bi, int color_type, int bitDepth, int bitsPerPixel, PngChunkPlte pngChunkPLTE, GammaCorrection gammaCorrection, TransparencyFilter transparencyFilter) {
        this.width = width;
        this.height = height;
        this.is = is;
        this.bi = bi;
        this.colorType = color_type;
        this.bitDepth = bitDepth;
        this.bytesPerPixel = this.getBitsToBytesRoundingUp(bitsPerPixel);
        this.bitsPerPixel = bitsPerPixel;
        this.pngChunkPLTE = pngChunkPLTE;
        this.gammaCorrection = gammaCorrection;
        this.transparencyFilter = transparencyFilter;
    }

    protected int getBitsToBytesRoundingUp(int bits) {
        int bytes = bits / 8;
        if (bits % 8 > 0) {
            ++bytes;
        }
        return bytes;
    }

    protected final int getPixelARGB(int alpha, int red, int green, int blue) {
        int rgb = (0xFF & alpha) << 24 | (0xFF & red) << 16 | (0xFF & green) << 8 | (0xFF & blue) << 0;
        return rgb;
    }

    protected final int getPixelRGB(int red, int green, int blue) {
        return this.getPixelARGB(255, red, green, blue);
    }

    public abstract void drive() throws ImageReadException, IOException;

    protected int getRGB(BitParser bitParser, int pixelIndexInScanline) throws ImageReadException, IOException {
        switch (this.colorType) {
            case 0: {
                int sample = bitParser.getSampleAsByte(pixelIndexInScanline, 0);
                if (this.gammaCorrection != null) {
                    sample = this.gammaCorrection.correctSample(sample);
                }
                int rgb = this.getPixelRGB(sample, sample, sample);
                if (this.transparencyFilter != null) {
                    rgb = this.transparencyFilter.filter(rgb, sample);
                }
                return rgb;
            }
            case 2: {
                int red = bitParser.getSampleAsByte(pixelIndexInScanline, 0);
                int green = bitParser.getSampleAsByte(pixelIndexInScanline, 1);
                int blue = bitParser.getSampleAsByte(pixelIndexInScanline, 2);
                int rgb = this.getPixelRGB(red, green, blue);
                if (this.transparencyFilter != null) {
                    rgb = this.transparencyFilter.filter(rgb, -1);
                }
                if (this.gammaCorrection != null) {
                    int alpha = (0xFF000000 & rgb) >> 24;
                    red = this.gammaCorrection.correctSample(red);
                    green = this.gammaCorrection.correctSample(green);
                    blue = this.gammaCorrection.correctSample(blue);
                    rgb = this.getPixelARGB(alpha, red, green, blue);
                }
                return rgb;
            }
            case 3: {
                int index = bitParser.getSample(pixelIndexInScanline, 0);
                int rgb = this.pngChunkPLTE.getRGB(index);
                if (this.transparencyFilter != null) {
                    rgb = this.transparencyFilter.filter(rgb, index);
                }
                return rgb;
            }
            case 4: {
                int sample = bitParser.getSampleAsByte(pixelIndexInScanline, 0);
                int alpha = bitParser.getSampleAsByte(pixelIndexInScanline, 1);
                if (this.gammaCorrection != null) {
                    sample = this.gammaCorrection.correctSample(sample);
                }
                int rgb = this.getPixelARGB(alpha, sample, sample, sample);
                return rgb;
            }
            case 6: {
                int red = bitParser.getSampleAsByte(pixelIndexInScanline, 0);
                int green = bitParser.getSampleAsByte(pixelIndexInScanline, 1);
                int blue = bitParser.getSampleAsByte(pixelIndexInScanline, 2);
                int alpha = bitParser.getSampleAsByte(pixelIndexInScanline, 3);
                if (this.gammaCorrection != null) {
                    red = this.gammaCorrection.correctSample(red);
                    green = this.gammaCorrection.correctSample(green);
                    blue = this.gammaCorrection.correctSample(blue);
                }
                int rgb = this.getPixelARGB(alpha, red, green, blue);
                return rgb;
            }
        }
        throw new ImageReadException("PNG: unknown color type: " + this.colorType);
    }

    protected ScanlineFilter getScanlineFilter(int filter_type, int BytesPerPixel) throws ImageReadException {
        ScanlineFilter filter;
        switch (filter_type) {
            case 0: {
                filter = new ScanlineFilterNone();
                break;
            }
            case 1: {
                filter = new ScanlineFilterSub(BytesPerPixel);
                break;
            }
            case 2: {
                filter = new ScanlineFilterUp(BytesPerPixel);
                break;
            }
            case 3: {
                filter = new ScanlineFilterAverage(BytesPerPixel);
                break;
            }
            case 4: {
                filter = new ScanlineFilterPaeth(BytesPerPixel);
                break;
            }
            default: {
                throw new ImageReadException("PNG: unknown filter_type: " + filter_type);
            }
        }
        return filter;
    }

    protected byte[] unfilterScanline(int filter_type, byte[] src, byte[] prev, int BytesPerPixel) throws ImageReadException, IOException {
        ScanlineFilter filter = this.getScanlineFilter(filter_type, BytesPerPixel);
        byte[] dst = new byte[src.length];
        filter.unfilter(src, dst, prev);
        return dst;
    }

    protected byte[] getNextScanline(InputStream is, int length, byte[] prev, int BytesPerPixel) throws ImageReadException, IOException {
        int filterType = is.read();
        if (filterType < 0) {
            throw new ImageReadException("PNG: missing filter type");
        }
        byte[] scanline = this.readBytes("scanline", is, length, "PNG: missing image data");
        byte[] unfiltered = this.unfilterScanline(filterType, scanline, prev, BytesPerPixel);
        return unfiltered;
    }
}

