<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/linkbutton.ftl">

  <@tableHeader Heading="Edit Source Connector" />

  <#if show_form?? >
  
   <script type="text/javascript">
     
        function checkSelection() {
            var fObj = document.getElementById('format');
            if (fObj){
                var qObj = document.getElementById('quality');
                if (qObj){
                    if (fObj.value.match(/lossless/i)) {
                       qObj.setAttribute('disabled', 'true');
                    }
                    else {
                       qObj.removeAttribute('disabled');
                    }
                }
            }
            var typeObject = document.getElementById('type');
            if (typeObject) {
                var formatSection = document.getElementById('formattable');
                if (typeObject.value.match(/storage/i)) {
                	formatSection.style.display = 'table';
                }
                else {
                	formatSection.style.display = 'none';
                }
            }
        }
        
        
        
   </script>

   <form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="editsourceconnector">
    <input type="hidden" name="confirmed" value="1">
    <input type="hidden" name="connectorname" value="${connectorname}">
      
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
     <tr>
      <td class="pad1" colspan="2">
       <#if message??>
        ${message}
       <#else>
        Change the source connector settings below and press "save".
       </#if>
      </td>
     </tr>
     <tr>
      <td class="sectionheader" colspan="2">Source Connector Settings</td>
	 </tr>
	 <tr>
      <td colspan="2"><hr size="1" class="hr1"/></td>
     </tr>
      <tr>
        <td class="pad1">Source Connector Name</td>
        <td class="pad1">
      	  <input type="text" class="inwhite" id="connectorname" name="connectorname" <#if connectorname??>value="${connectorname}"</#if> disabled help="<@appID/>:sourceconnector_name">
        </td>
      </tr>
      <tr>
        <td class="pad1">Enabled</td>
        <td class="pad1">
        	<@formcheckbox objid="enabled" preselect=enabled helpid="sourceconnector_enabled" />
        </td>
      </tr>
      <tr>
        <td class="pad1">Type</td>
        <td class="pad1"><@formgfxselect objid="type" itemlist=available_types preselect=type callbackonchange="checkSelection" helpid="sourceconnector_type" /></td>
      </tr>
      <tr>
        <td class="pad1">Location</td>
        <td class="pad1">
      	  <input type="text" class="inwhite" id="location" name="location"  <#if location??>value="${location}"</#if> help="<@appID/>:sourceconnector_location">
        </td>
      </tr>
      <tr>
        <td class="pad1">Copyright Notice</td>
        <td class="pad1">
      	  <input type="text" class="inwhite" id="copyrightnotice" name="copyrightnotice"  <#if copyrightnotice??>value="${copyrightnotice}"</#if> help="<@appID/>:sourceconnector_copyrightnotice">
        </td>
      </tr>
      </table>
      
      
      <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;" id="formattable">
      <tr>
       <td class="sectionheader" colspan="3">Format Settings</td>
	  </tr>
      <tr>
        <td class="pad1">Format:</td>
        <td class="pad1"><@formgfxselect objid="format" itemlist=available_formats preselect=format callbackonchange="checkSelection" helpid="sourceconnector_format" /></td>
      </tr>
      <tr>
        <td class="pad1">Image quality</td>
        <td class="pad1">
      	  <input type="text" class="inwhite" maxlength="3" style="width:190px" id="quality" name="quality" <#if quality??>value="${quality}"</#if> help="<@appID/>:sourceconnector_quality">
        </td>
      </tr>
      <tr>
        <td class="pad1">Level Quality:</td>
        <td class="pad1"><@formgfxselect objid="levelquality" itemlist=available_levelqualities preselect=levelquality callbackonchange="checkSelection" helpid="sourceconnector_levelquality" /></td>
      </tr>
      <tr>
        <td class="pad1">Chroma Subsampling:</td>
        <td class="pad1"><@formgfxselect objid="chromasubsampling" itemlist=available_chromasubsamplings preselect=chromasubsampling callbackonchange="checkSelection" helpid="sourceconnector_chromasubsampling" /></td>
      </tr>
      <tr>
        <td class="pad1">Histogram</td>
        <td class="pad1">
        	<@formcheckbox objid="histogram" preselect=histogram?string helpid="sourceconnector_histogram" />
        </td>
      </tr>
      </table>
      
      <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
       <td class="sectionheader" colspan="3">Comment</td>
	  </tr>
      <tr>
        <td class="pad1">
      	  <input type="text" class="inwhite" id="comment" name="comment"  <#if comment??>value="${comment}"</#if> help="<@appID/>:sourceconnector_comment">
        </td>
      </tr>
      </table>
      
      <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
        <td class="pad1" style="padding-top: 20px;" colspan="2" align="right">
          <@linkbutton value="Cancel" targeturl="pt.do?action=listsourceconnectors" helpid="sourceconnector_cancel" />
          <@formsubmit value="Save Changes" helpid="sourceconnector_save" /> 
        </td>
      </tr>
      </table>
      
    </form>

    <script type="text/javascript">
        checkSelection();
    </script>

  <#elseif show_confirmation?? >

    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
     <tr>
      <td class="sectionheader">Source Connector saved</td>
	 </tr>
	 <tr>
      <td><hr size="1" class="hr1"/></td>
     </tr>
     <tr>
      <td class="pad1">
      Please wait while the source connectors are re-read for the changes to take effect.
      </td>
     </tr>
    </table>
    <#assign timeout="8" />
	<#assign postprogresslocation="action=listsourceconnectors">
    <#include "/sub/progressbar.ftl">
    
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">