/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.imaging.util.Debug;

public class FieldTypeShort
extends FieldType {
    public FieldTypeShort(int type, String name) {
        super(type, name, 2);
    }

    public Object getValue(TiffField entry) {
        byte[] bytes = entry.getByteArrayValue();
        if (entry.getCount() == 1L) {
            return ByteConversions.toShort(bytes, entry.getByteOrder());
        }
        return ByteConversions.toShorts(bytes, entry.getByteOrder());
    }

    public byte[] writeData(Object o, ByteOrder byteOrder) throws ImageWriteException {
        if (o instanceof Short) {
            return ByteConversions.toBytes((Short)o, byteOrder);
        }
        if (o instanceof short[]) {
            short[] numbers = (short[])o;
            return ByteConversions.toBytes(numbers, byteOrder);
        }
        if (o instanceof Short[]) {
            Short[] numbers = (Short[])o;
            short[] values = new short[numbers.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = numbers[i];
            }
            return ByteConversions.toBytes(values, byteOrder);
        }
        throw new ImageWriteException("Invalid data: " + o + " (" + Debug.getType(o) + ")");
    }
}

