/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CachingOutputStream
extends OutputStream {
    private final OutputStream os;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public CachingOutputStream(OutputStream os) {
        this.os = os;
    }

    public void write(int b) throws IOException {
        this.os.write(b);
        this.baos.write(b);
    }

    public byte[] getCache() {
        return this.baos.toByteArray();
    }

    public void close() throws IOException {
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }
}

