<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">

	<@tableHeader Heading="Delete Source Connector" />
    
    <#if show_form?? >
    
     <form action="pt.do" method="post" onsubmit="this.submit();">
      <@printRequiredParams method="post" />
      <input type="hidden" name="action" value="deletesourceconnector">
      <input type="hidden" name="confirmed" value="1"> 
      <input type="hidden" name="connectorname" value="${connectorname}">
      <table cellpadding="0" cellspacing="0" style="border: 0px; width: 500px;" >
       <tr>
        <td class="pad1" colspan="2">
          If an source connector is deleted, all images belonging to this source connector are also deleted from 
          FSI Servers internal storage. The image data in the source directory is left untouched. As the data from 
          the internal storage is deleted all images from this source connector will need to be re-imported if the source connector 
          was deleted accidentally. 
        </td>
       </tr>             
       <tr>
        <td class="sectionheader" colspan="2">
          Delete Source Connector          
        </td>
       </tr>
       <tr><td style="text-align: left;" colspan="2"><hr size="1" class="hr1"/></td></tr>
       <tr>
        <td class="pad1">
          Are you sure you want to delete source connector: <br />"${connectorname}"?
        </td>
        <td align="right">
         <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
         <@formsubmit value="Delete" />
        </td>
       </tr>
      </table>
     </form>
    
    <#elseif show_confirmation?? >
    
     <table cellpadding="0" cellspacing="0" style="border: 0px; width: 500px;" >
       <tr>
        <td class="sectionheader" colspan="2">Source Connector deleted</td>
       </tr>
       <tr><td style="text-align: left;" colspan="2"><hr size="1" class="hr1"/></td></tr>
       <tr>
        <td class="pad1">
          Source connector deleted. Please wait while the source connectors are re-read for the changes to take effect.
    	</td>
       </tr>
      </table>
      <#assign timeout="8" />
      <#assign postprogresslocation="action=listsourceconnectors">
      <#include "/sub/progressbar.ftl">
    	
    <#elseif show_error?? >
    
      <table cellpadding="0" cellspacing="0" style="border: 0px; width: 500px;" >
       <tr>
        <td class="sectionheader" colspan="2">Error deleting source connector</td>
       </tr>
       <tr><td style="text-align: left;" colspan="2"><hr size="1" class="hr1"/></td></tr>
       <tr>
        <td class="pad1" colspan="2">
    	 The source connector could not be deleted. Please check the log files and contact the system administrator.
    	</td>
       </tr>
       <tr>
        <td class="pad1" colspan="2" style="text-align: right">
    	 <@linkbutton value="Ok" targeturl="pt.do?action=listsourceconnectors" />
    	</td>
       </tr>
      </table>
      
    </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">