/*!
	jquery.dynatree.js
	Dynamic tree view control, with support for lazy loading of branches.

	Copyright (c) 2008-2009  Martin Wendt (http://wwWendt.de)
	Licensed under the MIT License (MIT-License.txt)

	A current version and some documentation is available at
		http://dynatree.googlecode.com/

	Let me know, if you find bugs or improvements (martin at domain wwWendt.de).
	
	@modified: by NeptuneLabs

	$Version: 0.4.2$
	$Revision: 216, 2009-04-19 08:08:47$

 	@depends: jquery.js
 	@depends: ui.core.js
	@depends: jquery.cookie.js

/*************************************************************************
 *	Constants
 */
;var DTNodeStatus_Error=-1;var DTNodeStatus_Loading=1;var DTNodeStatus_Ok=0;(function($){var Class={create:function(){return function(){this.initialize.apply(this,arguments)}}};var DynaTreeNode=Class.create();DynaTreeNode.prototype={initialize:function(parent,tree,data){this.parent=parent;this.tree=tree;if(typeof data=="string"){data={title:data}}if(data.key==undefined){data.key="_"+tree._nodeCount++}this.data=$.extend({},$.ui.dynatree.nodedatadefaults,data);this.div=null;this.span=null;this.childList=null;this.isRead=false;this.hasSubSel=false;this.ajaxID=0;if(tree.initMode=="cookie"){if(tree.initActiveKey==this.data.key){tree.activeNode=this}if(tree.initFocusKey==this.data.key){tree.focusNode=this}this.bExpanded=($.inArray(this.data.key,tree.initExpandedKeys)>=0);this.bSelected=($.inArray(this.data.key,tree.initSelectedKeys)>=0)}else{if(data.activate){tree.activeNode=this}if(data.focus){tree.focusNode=this}this.bExpanded=(data.expand==true);this.bSelected=(data.select==true)}if(this.bExpanded){tree.expandedNodes.push(this)}if(this.bSelected){tree.selectedNodes.push(this)}},getChildByTitle:function(strTitle){if(this.childList==null){return null}var childFound=null;for(var i=0;i<this.childList.length;i++){if(this.childList[i].data.title==strTitle&&!this.childList[i].data.noPath){childFound=this.childList[i];break}}return childFound},toString:function(){return"dtnode<"+this.data.key+">: '"+this.data.title+"'"},toDict:function(recursive,callback){var dict=$.extend({},this.data);dict.activate=(this.tree.activeNode===this);dict.focus=(this.tree.focusNode===this);dict.expand=this.bExpanded;dict.select=this.bSelected;if(callback){callback(dict)}if(recursive&&this.childList){dict.children=[];for(var i=0;i<this.childList.length;i++){dict.children.push(this.childList[i].toDict(true,callback))}}else{delete dict.children}return dict},generateHTML:function(){var opts=this.tree.options;var rootParent=opts.rootVisible?null:this.tree.tnRoot;var bHideFirstExpander=(opts.rootVisible&&opts.minExpandLevel>0)||opts.minExpandLevel>1;var bHideFirstConnector=opts.rootVisible||opts.minExpandLevel>0;var link,textNode;var res="";var p=this.parent;var myTree=this.tree;var id="";while(p){if(bHideFirstConnector&&(p==rootParent)){break}id=(p.isLastSibling()?"0":"1")+id;p=p.parent}var connector;if(this.parent==rootParent&&bHideFirstExpander){connector=0}else{if(this.childList||this.data.isLazy){connector=2}else{connector=1}}var idNodeCache=id+"_"+connector+"_"+this.data.icon;if(!myTree.treeNodeCache[idNodeCache]){if(myTree.connectorCache[id]==undefined){myTree.oDebug._connectorcachesize++;var node=myTree.spanTemplate.cloneNode(false);for(var i=0;i<id.length;i++){if(id.charAt(i)=="0"){node.appendChild(myTree.tagEmptyTemplate.cloneNode(false))}else{node.appendChild(myTree.tagVlineTemplate.cloneNode(false))}}if(id.length>0){myTree.connectorCache[id]=node}else{myTree.connectorCache[id]=1}}else{myTree.oDebug._connectorcachehits++}var nodeContent=this.tree.spanTemplate.cloneNode(false);if(myTree.connectorCache[id]!=1){nodeContent.appendChild(myTree.connectorCache[id].cloneNode(true))}if(connector){if(connector==2){nodeContent.appendChild(this.tree.tagExpanderTemplate.cloneNode(false))}else{nodeContent.appendChild(this.tree.tagConnectorTemplate.cloneNode(false))}}if(this.data.icon==null){nodeContent.appendChild(myTree.tagNodeIconTemplate.cloneNode(true))}else{if(this.data.icon!=false){var imgNode=myTree.iconImageTemplate.cloneNode(false);imgNode.setAttribute("src",opts.imagePath+this.data.icon);nodeContent.appendChild(imgNode)}}textNode=document.createTextNode("x");link=myTree.linkTemplate.cloneNode(false);link.appendChild(textNode);nodeContent.appendChild(link);myTree.oDebug._nodeCacheSize++;myTree.treeNodeCache[idNodeCache]=nodeContent.cloneNode(true)}else{myTree.oDebug._nodeCacheHits++;nodeContent=myTree.treeNodeCache[idNodeCache].cloneNode(true)}this.tagLink=link=nodeContent.lastChild;if(this.data.displayTitle){link.firstChild.nodeValue=this.data.displayTitle}else{link.firstChild.nodeValue=this.data.title}this.span.treeitem=this;if(this.span.firstChild){this.span.replaceChild(nodeContent,this.span.firstChild)}else{this.span.appendChild(nodeContent)}return res},render:function(bDeep,bHidden,bNoVisibilityUpdate){if(!this.div){this.div=this.tree.divTemplate.cloneNode(true);this.span=this.div.firstChild;this.span.dtnode=this;if(this.data.key){this.span.id=this.tree.options.idPrefix+this.data.key}if(this.parent){var lc=this.parent.spanChildren.lastChild;if(lc&&lc.spanContent){lc=lc.spanContent}if(!lc||lc.childNodes.length%this.tree.childGroupSize==0){this.spanContent=this.tree.contentDivTemplate.cloneNode(false);var divSpacer=this.spanContent.divSpacer=this.tree.divSpacerTemplate.cloneNode(false);divSpacer.elVisible=divSpacer;divSpacer.spanContent=this.spanContent;if(lc){this.parent.spanChildren.appendChild(divSpacer);if(this.parent.spanChildren.oExtraGroups==undefined){this.tree.largeGroupParents[this.tree.largeGroupParentID++]=this.parent.spanChildren;this.parent.spanChildren.oExtraGroups=new Object();this.parent.spanChildren.oExtraGroupsVisible=new Object();this.parent.spanChildren.ExtraGroupID=0}this.parent.spanChildren.oExtraGroups[this.parent.spanChildren.ExtraGroupID++]=divSpacer;divSpacer.extraGroupID=this.parent.spanChildren.ExtraGroupID}else{this.parent.spanChildren.appendChild(this.spanContent)}}else{this.spanContent=lc}this.spanContent.appendChild(this.div)}if(this.parent==null&&!this.tree.options.rootVisible){this.span.style.display="none"}}this.generateHTML();var opts=this.tree.options;var cn=opts.classNames;var isLastSib=this.isLastSibling();var cnList=[];cnList.push((this.data.isFolder)?cn.folder:cn.document);if(this.bExpanded){cnList.push(cn.expanded)}if(this.data.isLazy&&!this.isRead){cnList.push(cn.lazy)}if(isLastSib){cnList.push(cn.lastsib)}if(this.bSelected){cnList.push(cn.selected)}if(this.hasSubSel){cnList.push(cn.partsel)}if(this.tree.activeNode===this){cnList.push(cn.active)}if(this.data.addClass){cnList.push(this.data.addClass)}cnList.push(cn.combinedExpanderPrefix+(this.bExpanded?"e":"c")+(this.data.isLazy&&!this.isRead?"d":"")+(isLastSib?"l":""));cnList.push(cn.combinedIconPrefix+(this.bExpanded?"e":"c")+(this.data.isFolder?"f":""));this.span.className=cnList.join(" ");if(bDeep&&this.childList&&(bHidden||this.bExpanded)){if(!this.spanChildren){this.spanChildren=this.tree.contentDivTemplate.cloneNode(false);this.div.appendChild(this.spanChildren)}$(this.spanChildren).hide();for(var i=0;i<this.childList.length;i++){this.childList[i].render(bDeep,bHidden,bNoVisibilityUpdate)}var node=this.childList[i-1];var spacer=node.spanContent.divSpacer;if(spacer){spacer.style.height=node.spanContent.childNodes.length*16+"px"}}if(this.spanChildren&&this.bExpanded){$(this.spanChildren).show()}},hasChildren:function(){return this.childList!=null},getChildList:function(){return this.childList},isLastSibling:function(){var p=this.parent;if(!p){return true}return p.childList[p.childList.length-1]===this},prevSibling:function(){if(!this.parent){return null}var ac=this.parent.childList;for(var i=1;i<ac.length;i++){if(ac[i]===this){return ac[i-1]}}return null},nextSibling:function(){if(!this.parent){return null}var ac=this.parent.childList;for(var i=0;i<ac.length-1;i++){if(ac[i]===this){return ac[i+1]}}return null},_setStatusNode:function(data){var firstChild=(this.childList?this.childList[0]:null);if(!data){if(firstChild){firstChild.spanContent.removeChild(firstChild.div);if(this.childList.length==1){this.childList=null}else{this.childList.shift()}}}else{if(firstChild){data.isStatusNode=true;firstChild.data=data;firstChild.render(false,false)}else{data.isStatusNode=true;firstChild=this._addNode(data)}}},setLazyNodeStatus:function(lts){switch(lts){case DTNodeStatus_Ok:this._setStatusNode(null);this.isRead=true;this.render(false,false);if(this.tree.options.autoFocus||(this.tree.options.autoGetFocus&&this.tree.options.autoGetFocus())){if(this===this.tree.tnRoot&&!this.tree.options.rootVisible&&this.childList){this.childList[0].focus()}else{this.focus()}}if(this.bExpanded&&(!this.childList||this.childList.length<1)){this._expand(false);this.isRead=false;this.isLazy=false}break;case DTNodeStatus_Loading:this._setStatusNode({title:this.tree.options.strings.loading,addClass:this.tree.options.classNames.nodeWait});break;case DTNodeStatus_Error:this._setStatusNode({title:this.tree.options.strings.loadError,addClass:this.tree.options.classNames.nodeError});break;default:throw"Bad LazyNodeStatus: '"+lts+"'."}},_parentList:function(includeRoot,includeSelf){var l=[];var dtn=includeSelf?this:this.parent;while(dtn){if(includeRoot||dtn.parent){l.unshift(dtn)}dtn=dtn.parent}return l},getLevel:function(){var level=0;var dtn=this.parent;while(dtn){level++;dtn=dtn.parent}return level},isVisible:function(){var parents=this._parentList(true,false);for(var i=0;i<parents.length;i++){if(!parents[i].bExpanded){return false}}return true},makeVisible:function(){var parents=this._parentList(true,false);for(var i=0;i<parents.length;i++){parents[i]._expand(true)}},focus:function(){var opts=this.tree.options;if(opts.onBeforeFocus){if(opts.onBeforeFocus.call(this.span,this)){return}}this.makeVisible();try{this.tagLink.focus()}catch(e){}if(opts.onAfterFocus){opts.onAfterFocus.call(this.span,this)}},isActive:function(){return(this.tree.activeNode===this)},activate:function(bByUser,bNoCallBack){var opts=this.tree.options;if(this.data.isStatusNode){return}if(opts.onQueryActivate&&opts.onQueryActivate.call(this.span,true,this)==false){return}if(this.tree.activeNode){if(this.tree.activeNode===this){return}this.tree.activeNode.deactivate()}if(opts.activeVisible){this.makeVisible()}this.tree.activeNode=this;if(opts.persist){$.cookie(opts.cookieId+"-active",this.data.key,opts.cookie)}$(this.span).addClass(opts.classNames.active);if(opts.onActivate&&!bNoCallBack){opts.onActivate.call(this.span,this,bByUser)}},deactivate:function(){if(this.tree.activeNode===this){var opts=this.tree.options;if(opts.onQueryActivate&&opts.onQueryActivate.call(this.span,false,this)==false){return}$(this.span).removeClass(opts.classNames.active);if(opts.persist){$.cookie(opts.cookieId+"-active","",opts.cookie)}this.tree.activeNode=null;if(opts.onDeactivate){opts.onDeactivate.call(this.span,this)}}},_userActivate:function(){var activate=true;var expand=false;if(this.data.isFolder){switch(this.tree.options.clickFolderMode){case 2:activate=false;expand=true;break;case 3:activate=true;if(this.bExpanded){expand=(this.tree.activeNode===this)}else{expand=true}break}}if(this.parent==null&&this.tree.options.minExpandLevel>0){expand=false}if(expand){this.toggleExpand();this.focus()}if(activate){this.activate(true)}},_setSubSel:function(hasSubSel){if(hasSubSel){this.hasSubSel=true;$(this.span).addClass(this.tree.options.classNames.partsel)}else{this.hasSubSel=false;$(this.span).removeClass(this.tree.options.classNames.partsel)}},_fixSelectionState:function(){if(this.bSelected){this.visit(function(dtnode){dtnode.parent._setSubSel(true);dtnode._select(true,false,false)});var p=this.parent;while(p){p._setSubSel(true);var allChildsSelected=true;for(var i=0;i<p.childList.length;i++){var n=p.childList[i];if(!n.bSelected&&!n.data.isStatusNode){allChildsSelected=false;break}}if(allChildsSelected){p._select(true,false,false)}p=p.parent}}else{this._setSubSel(false);this.visit(function(dtnode){dtnode._setSubSel(false);dtnode._select(false,false,false)});var p=this.parent;while(p){p._select(false,false,false);var isPartSel=false;for(var i=0;i<p.childList.length;i++){if(p.childList[i].bSelected||p.childList[i].hasSubSel){isPartSel=true;break}}p._setSubSel(isPartSel);p=p.parent}}},_select:function(sel,fireEvents,deep){var opts=this.tree.options;if(this.data.isStatusNode){return}if(this.bSelected==sel){return}if(fireEvents&&opts.onQuerySelect&&opts.onQuerySelect.call(this.span,sel,this)==false){return}if(opts.selectMode==1&&this.tree.selectedNodes.length&&sel){this.tree.selectedNodes[0]._select(false,false,false)}this.bSelected=sel;if(sel){$(this.span).addClass(opts.classNames.selected);if(deep&&opts.selectMode==3){this._fixSelectionState()}if(fireEvents&&opts.onSelect){opts.onSelect.call(this.span,true,this)}}else{$(this.span).removeClass(opts.classNames.selected);if(deep&&opts.selectMode==3){this._fixSelectionState()}if(fireEvents&&opts.onSelect){opts.onSelect.call(this.span,false,this)}}},isSelected:function(){return this.bSelected},select:function(sel){return this._select(sel!=false,true,true)},toggleSelect:function(){return this.select(!this.bSelected)},_expand:function(bExpand){if(this.bExpanded==bExpand){return}var opts=this.tree.options;if(!bExpand&&this.getLevel()<opts.minExpandLevel){this.tree.logDebug("dtnode._expand(%o) forced expand - %o",bExpand,this);return}if(opts.onQueryExpand&&opts.onQueryExpand.call(this.span,bExpand,this)==false){return}this.bExpanded=bExpand;this.render(false);if(this.bExpanded&&this.parent&&opts.autoCollapse){var parents=this._parentList(false,true);for(var i=0;i<parents.length;i++){parents[i].collapseSiblings()}}if(opts.activeVisible&&this.tree.activeNode&&!this.tree.activeNode.isVisible()){this.tree.activeNode.deactivate()}if(bExpand&&this.data.isLazy&&!this.isRead){try{this.setLazyNodeStatus(DTNodeStatus_Loading);if(true==opts.onLazyRead.call(this.span,this)){this.setLazyNodeStatus(DTNodeStatus_Ok)}}catch(e){this.setLazyNodeStatus(DTNodeStatus_Error)}if(opts.onExpand){opts.onExpand.call(this.span,bExpand,this)}return}var $d=$(this.spanChildren);if(this.bExpanded){$d.show()}else{$d.hide()}if(opts.onExpand){opts.onExpand.call(this.span,bExpand,this)}},expand:function(flag){if(!this.childList&&!this.data.isLazy&&flag){return}if(this.parent==null&&this.tree.options.minExpandLevel>0&&!flag){return}this._expand(flag);this.tree.updateExtraBlockVisibility()},toggleExpand:function(){this.expand(!this.bExpanded)},collapseSiblings:function(){if(this.parent==null){return}var ac=this.parent.childList;for(var i=0;i<ac.length;i++){if(ac[i]!==this&&ac[i].bExpanded){ac[i]._expand(false)}}},onClick:function(event){if($(event.target).hasClass(this.tree.options.classNames.expander)){this.toggleExpand()}else{if($(event.target).hasClass(this.tree.options.classNames.checkbox)){this.toggleSelect()}else{this._userActivate();this.span.getElementsByTagName("a")[0].focus()}}return false},onMouseUp:function(event){if(event.button!=2){return true}if($(event.target).hasClass(this.tree.options.classNames.expander)){return true}else{if($(event.target).hasClass(this.tree.options.classNames.checkbox)){return true}else{this.span.getElementsByTagName("a")[0].focus()}}return true},onDblClick:function(event){},onKeydown:function(event){var handled=true;switch(event.which){case 107:case 187:if(!this.bExpanded){this.toggleExpand()}break;case 109:case 189:if(this.bExpanded){this.toggleExpand()}break;case 32:this._userActivate();break;case 8:if(this.parent){this.parent.focus()}break;case 37:if(this.bExpanded){this.toggleExpand();this.focus()}else{if(this.parent&&(this.tree.options.rootVisible||this.parent.parent)){this.parent.focus()}}break;case 39:if(!this.bExpanded&&(this.childList||this.data.isLazy)){this.toggleExpand();this.focus()}else{if(this.childList){this.childList[0].focus()}}break;case 38:var sib=this.prevSibling();while(sib&&sib.bExpanded){sib=sib.childList[sib.childList.length-1]}if(!sib&&this.parent&&(this.tree.options.rootVisible||this.parent.parent)){sib=this.parent}if(sib){sib.focus()}break;case 40:var sib;if(this.bExpanded){sib=this.childList[0]}else{var parents=this._parentList(false,true);for(var i=parents.length-1;i>=0;i--){sib=parents[i].nextSibling();if(sib){break}}}if(sib){sib.focus()}break;default:handled=false}return !handled},onKeypress:function(event){},onFocus:function(event){var opts=this.tree.options;if(event.type=="blur"||event.type=="focusout"){if(opts.onBlur){opts.onBlur.call(this.span,this)}if(this.tree.tnFocused){$(this.tree.tnFocused.span).removeClass(opts.classNames.focused)}this.tree.tnFocused=null;if(opts.persist){$.cookie(opts.cookieId+"-focus",null,$.extend({},opts.cookie))}}else{if(event.type=="focus"||event.type=="focusin"){if(this.tree.tnFocused&&this.tree.tnFocused!==this){this.tree.logDebug("dtnode.onFocus: out of sync: curFocus: %o",this.tree.tnFocused);$(this.tree.tnFocused.span).removeClass(opts.classNames.focused)}this.tree.tnFocused=this;if(opts.onFocus){opts.onFocus.call(this.span,this)}$(this.tree.tnFocused.span).addClass(opts.classNames.focused);if(opts.persist){$.cookie(opts.cookieId+"-focus",this.data.key,opts.cookie)}}}},_postInit:function(){if(opts.onPostInit){opts.onPostInit.call(this.span,this)}},visit:function(fn,data,includeSelf){var n=0;if(includeSelf==true){if(fn(this,data)==false){return 1}n++}if(this.childList){for(var i=0;i<this.childList.length;i++){n+=this.childList[i].visit(fn,data,true)}}return n},remove:function(){if(this===this.tree.root){return false}return this.parent.removeChild(this)},removeChild:function(tn){var ac=this.childList;if(ac.length==1){if(tn!==ac[0]){throw"removeChild: invalid child"}return this.removeChildren()}if(tn===this.tree.activeNode){tn.deactivate()}tn.removeChildren(true);if(tn.spanContent){if(tn.spanContent.childNodes.length==1){var divSpacer=tn.spanContent.divSpacer;delete tn.parent.spanChildren.oExtraGroups[divSpacer.extraGroupID];if(divSpacer.parentNode!=undefined){divSpacer.parentNode.removeChild(divSpacer)}else{tn.spanContent.divSpacer=null}if(tn.spanContent.parentNode){tn.spanContent.parentNode.removeChild(tn.spanContent)}}else{tn.spanContent.removeChild(tn.div);if(tn.spanContent.style.display=="none"){tn.spanContent.divSpacer.height=tn.spanContent.childNodes.length*16+"px"}}}for(var i=0;i<ac.length;i++){if(ac[i]===tn){this.childList.splice(i,1);delete tn;break}}this.tree.updateExtraBlockVisibility()},removeChildren:function(recursive){var tree=this.tree;var ac=this.childList;if(ac){this.childList=null;if(this.spanChildren){if(this.spanChildren.parentNode){this.div.removeChild(this.spanChildren)}delete this.spanChildren}if(!recursive){this._expand(false);this.isRead=false;this.render(false,false)}}},_addChildNode:function(dtnode,bDontRender){var tree=this.tree;var opts=tree.options;if(this.childList==null){this.childList=[]}else{$(this.childList[this.childList.length-1].span).removeClass(opts.classNames.lastsib)}this.childList.push(dtnode);dtnode.parent=this;if(dtnode.data.expand||opts.minExpandLevel>=dtnode.getLevel()){this.bExpanded=true}if(!dtnode.data.isStatusNode&&opts.selectMode==3&&!tree.isInitializing()){dtnode._fixSelectionState()}if(!bDontRender&&tree.bEnableUpdate){this.render(true,true)}return dtnode},_addNode:function(data,bDontRender){return this._addChildNode(new DynaTreeNode(this,this.tree,data),bDontRender)},append:function(obj){if(!obj||obj.length==0){return}if(!obj.length){obj=[obj]}var tnFirst=null;for(var i=0;i<obj.length;i++){var data=obj[i];var dtnode=this._addNode(data,true);if(!tnFirst){tnFirst=dtnode}if(data.children){dtnode.append(data.children)}}this.div.style.display="none";this.render(true,true,true);this.div.style.display=(this.parent==null||this.parent.bExpanded?"":"none");return tnFirst},appendAjax:function(ajaxOptions){this.setLazyNodeStatus(DTNodeStatus_Loading);var self=this;var orgSuccess=ajaxOptions.success;var orgError=ajaxOptions.error;var orgBeforeSuccessHandler=ajaxOptions.beforeSuccessHandler;var orgAfterSuccessHandler=ajaxOptions.afterSuccessHandler;self.ajaxID++;var ajaxID=self.ajaxID;var options=$.extend({},this.tree.options.ajaxDefaults,ajaxOptions,{success:function(data,textStatus){if(self.ajaxID!=ajaxID){ffDump("Outdated tree ajax reply");return}if(orgBeforeSuccessHandler){orgBeforeSuccessHandler.call(options,self,data)}self.append(data);self.setLazyNodeStatus(DTNodeStatus_Ok);self.tree.updateExtraBlockVisibility();if(orgAfterSuccessHandler){orgAfterSuccessHandler.call(options,self)}self.tree.NELA_continueAutoExpanding(self);if(orgSuccess){orgSuccess.call(options,self)}},error:function(XMLHttpRequest,textStatus,errorThrown){if(self.ajaxID!=ajaxID){ffDump("Outdated tree ajax reply");return}self.setLazyNodeStatus(DTNodeStatus_Error);if(orgError){orgError.call(options,self,XMLHttpRequest,textStatus,errorThrown)}}});$.ajax(options)},getPath:function(noCache){if(!this.getConnectorAndPath(noCache)){return undefined}return this.NELA_nodePath},getParentConnector:function(noCache){if(!this.parent){return undefined}return this.parent.getConnector()},getConnectorNode:function(noCache){if(!this.getConnectorAndPath()){return undefined}return this.NELA_nodeConnector},getConnectorAndPath:function(noCache){if(!noCache&&this.NELA_nodePath!=undefined){return true}if(this.data.isStatusNode){return false}var connector;var path;var nodeFound;var dtnode=nodeFound=this;if(dtnode==this.tree.tnRoot||dtnode.data.action){if(dtnode.data.action=="favorite"){path=dtnode.data.title}else{path=""}if(dtnode==this.tree.tnRoot){connector=this.tree.tnRoot}else{connector=undefined}}else{path=dtnode.data.title;dtnode=dtnode.parent;while(dtnode.parent!=undefined){if(dtnode.NELA_nodePath!=undefined){nodeFound=undefined;connector=dtnode.NELA_nodeConnector;path=dtnode.NELA_nodePath+"/"+path;break}nodeFound=dtnode;path=dtnode.data.title+"/"+path;dtnode=dtnode.parent}if(nodeFound!=undefined){connector=nodeFound}}this.NELA_nodePath=path;this.NELA_nodeConnector=connector;return true},lastentry:undefined};var DynaTree=Class.create();DynaTree.version="$Version: 0.4.2$";DynaTree.prototype={initialize:function(divContainer,options){this.options=options;this.childGroupSize=500;this.strAutoExpandPath=null;this.fnExpandToPathCallback=null;this.connectorCache=new Object();this.treeNodeCache=new Object();this.oDebug=new Object();this.oDebug._redrawcount=0;this.oDebug._connectorcachesize=0;this.oDebug._connectorcachehits=0;this.oDebug._nodeCacheSize=0;this.oDebug._nodeCacheHits=0;this.oDebug.maxTime=0;this.divTemplate=document.createElement("div");this.contentDivTemplate=document.createElement("div");this.spanTemplate=document.createElement("span");this.divTemplate.appendChild(this.spanTemplate);this.linkTemplate=document.createElement("a");this.linkTemplate.setAttribute("href","#");this.tagExpanderTemplate=document.createElement("span");this.tagExpanderTemplate.className=this.options.classNames.expander;this.tagConnectorTemplate=document.createElement("span");this.tagConnectorTemplate.className=this.options.classNames.connector;this.iconImageTemplate=document.createElement("img");this.tagNodeIconTemplate=document.createElement("span");this.tagNodeIconTemplate.className=this.options.classNames.nodeIcon;this.tagEmptyTemplate=document.createElement("span");this.tagEmptyTemplate.className=this.options.classNames.empty;this.tagVlineTemplate=document.createElement("span");this.tagVlineTemplate.className=this.options.classNames.vline;this.divSpacerTemplate=document.createElement("div");this.divSpacerTemplate.className="ui-dynatree-spacer";this.bEnableUpdate=true;this._nodeCount=0;this.initMode="data";this.activeNode=null;this.selectedNodes=[];this.expandedNodes=[];if(this.options.persist){this.initActiveKey=$.cookie(this.options.cookieId+"-active");if(cookie||this.initActiveKey!=null){this.initMode="cookie"}this.initFocusKey=$.cookie(this.options.cookieId+"-focus");var cookie=$.cookie(this.options.cookieId+"-expand");if(cookie!=null){this.initMode="cookie"}this.initExpandedKeys=cookie?cookie.split(","):[];cookie=$.cookie(this.options.cookieId+"-select");this.initSelectedKeys=cookie?cookie.split(","):[]}this.logDebug("initMode: %o, active: %o, focus: %o, expanded: %o, selected: %o",this.initMode,this.initActiveKey,this.initFocusKey,this.initExpandedKeys,this.initSelectedKeys);this.cache={tagEmpty:"<span class='"+options.classNames.empty+"'></span>",tagVline:"<span class='"+options.classNames.vline+"'></span>",tagExpander:"<span class='"+options.classNames.expander+"'></span>",tagConnector:"<span class='"+options.classNames.connector+"'></span>",tagNodeIcon:"<span class='"+options.classNames.nodeIcon+"'></span>",tagCheckbox:"<span class='"+options.classNames.checkbox+"'></span>",lastentry:undefined};this.expandToPath=function(path,dtnodeStart,fnCallback){var node=this.findNodeByPath(path,dtnodeStart);if(node!=null){if(fnCallback){this.fnExpandToPathCallback=fnCallback}var bContinue=false;var pathReached=node.getPath();var bPathReached=(pathReached==path);if(!bPathReached){if(node.data.isLazy&&!node.isRead){this.strAutoExpandPath=path;bContinue=true}}if(!bContinue){if(this.fnExpandToPathCallback){if(!this.fnExpandToPathCallback(node,pathReached,bPathReached)){node.activate(false,!bPathReached)}}else{node.activate(false,!bPathReached)}this.stopAutoExpanding()}node.expand(true)}};this.NELA_continueAutoExpanding=function(dtnode){if(this.strAutoExpandPath==null){return}if(!dtnode||this.strAutoExpandPath.length<1){return}this.expandToPath(this.strAutoExpandPath,dtnode)};this.divTree=divContainer;this.divTree.oTree=this;this.resetContent();var res=navigator.userAgent.match(/MSIE (\d+\.)/gi);if(res){addEvent(divContainer,"scroll",this.onFolderScrollIE)}else{addEvent(divContainer,"scroll",this.onFolderScroll)}},getElPos:function(el){var y=0;while(el!=undefined&&el!=this.divTree){y+=el.offsetTop;el=el.offsetParent}return y},onFolderScroll:function(evt){var self=evt.target.oTree;clearTimeout(self.idTimeoutScroll);setTimeout(self.doScrollTimeout,25,self)},onFolderScrollIE:function(evt){var self=evt.srcElement.oTree;clearTimeout(self.idTimeoutScroll);setTimeout(function(){self.doScrollTimeout(self)},25)},doScrollTimeout:function(self){self.updateExtraBlockVisibility()},updateExtraBlockVisibility:function(){var el=this.divTree;var nTop=el.scrollTop;var nBottom=nTop+el.offsetHeight;var oShowParents=new Object();for(var og in this.largeGroupParents){var spanChildren=this.largeGroupParents[og];if(!spanChildren){delete this.largeGroupParents[og];continue}spanChildren.oShowExtraGroups=undefined;if(spanChildren.style.display=="none"){continue}var offsetParent=this.getElPos(spanChildren.offsetParent);var offsetHeight=spanChildren.offsetHeight;var y=offsetParent+spanChildren.offsetTop;if(offsetHeight==0||nBottom<y||nTop>(y+offsetHeight)){continue}spanChildren.oShowExtraGroups=new Object();oShowParents[og]=spanChildren;var oGroups=spanChildren.oExtraGroups;for(var o in oGroups){var elDiv=oGroups[o];var el=elDiv.elVisible;var elY=offsetParent+el.offsetTop;var elH=el.offsetHeight;var elBottom=elY+elH;if(elH!=0&&nBottom>=elY&&nTop<=elBottom){spanChildren.oShowExtraGroups[o]=elDiv}if(elBottom>nBottom){break}}}for(var og in this.oLargeGroupParentsVisible){var spanChildren=this.oLargeGroupParentsVisible[og];if(oShowParents[og]!=undefined){continue}var oVisibleGroups=spanChildren.oExtraGroupsVisible;for(var o in oVisibleGroups){this.hideExtraGroup(oVisibleGroups[o])}spanChildren.oExtraGroupsVisible=new Object()}var n=0;for(var og in oShowParents){n++;var spanChildren=oShowParents[og];var oVisibleGroups=spanChildren.oExtraGroupsVisible;var oShowGroups=spanChildren.oShowExtraGroups;for(var o in oVisibleGroups){if(oShowGroups[o]!=undefined){continue}this.hideExtraGroup(oVisibleGroups[o])}for(var o in oShowGroups){if(oVisibleGroups[o]!=undefined){continue}var elDiv=oShowGroups[o];elDiv.parentNode.replaceChild(elDiv.spanContent,elDiv);elDiv.elVisible=elDiv.spanContent}spanChildren.oExtraGroupsVisible=spanChildren.oShowExtraGroups}this.oLargeGroupParentsVisible=oShowParents},hideExtraGroup:function(elDiv){if(!elDiv.spanContent||!elDiv.spanContent.parentNode){return}var nh=elDiv.spanContent.offsetHeight;if(nh){elDiv.style.height=elDiv.spanContent.offsetHeight+"px"}elDiv.spanContent.parentNode.replaceChild(elDiv,elDiv.spanContent);elDiv.elVisible=elDiv},resetContent:function(){this.largeGroupParents=new Object();this.oLargeGroupParentsVisible=new Object();this.largeGroupParentID=0;clearTimeout(this.idTimeoutScroll);$(this.divTree).empty();if(this.options.oRootNode){this.tnRoot=new DynaTreeNode(null,this,this.options.oRootNode)}else{this.tnRoot=new DynaTreeNode(null,this,{title:this.options.title,key:"root"})}this.tnRoot.data.isFolder=true;this.tnRoot.render(false,false);this.divRoot=this.tnRoot.div;this.divRoot.className=this.options.classNames.container;this.divTree.appendChild(this.divRoot)},toString:function(){return"DynaTree '"+this.options.title+"'"},toDict:function(){return this.tnRoot.toDict(true)},logDebug:function(msg){if(this.options.debugLevel>=2){Array.prototype.unshift.apply(arguments,["debug"]);_log.apply(this,arguments)}},logInfo:function(msg){if(this.options.debugLevel>=1){Array.prototype.unshift.apply(arguments,["info"]);_log.apply(this,arguments)}},logWarning:function(msg){Array.prototype.unshift.apply(arguments,["warn"]);_log.apply(this,arguments)},isInitializing:function(){return(this.initMode=="data"||this.initMode=="cookie"||this.initMode=="postInit")},redraw:function(){this.logDebug("dynatree.redraw()...");this.tnRoot.render(true,true);this.logDebug("dynatree.redraw() done.");this.oDebug._redrawcount++},getRoot:function(){return this.tnRoot},getNodeByKey:function(key){var el=document.getElementById(this.options.idPrefix+key);return(el&&el.dtnode)?el.dtnode:null},getActiveNode:function(){return this.activeNode},activateKey:function(key){var dtnode=this.getNodeByKey(key);if(!dtnode){this.activeNode=null;return null}dtnode.focus();dtnode.activate();return dtnode},selectKey:function(key,select){var dtnode=this.getNodeByKey(key);if(!dtnode){return null}dtnode.select(select);return dtnode},enableUpdate:function(bEnable){if(this.bEnableUpdate==bEnable){return bEnable}this.bEnableUpdate=bEnable;if(bEnable){this.redraw()}return !bEnable},visit:function(fn,data,includeRoot){return this.tnRoot.visit(fn,data,includeRoot)},_createFromTag:function(parentTreeNode,$ulParent){var self=this;$ulParent.find(">li").each(function(){var $li=$(this);var $liSpan=$li.find(">span:first");var title;if($liSpan.length){title=$liSpan.html()}else{title=$li.html();var iPos=title.search(/<ul/i);if(iPos>=0){title=$.trim(title.substring(0,iPos))}else{title=$.trim(title)}}var data={title:title,isFolder:$li.hasClass("folder"),isLazy:$li.hasClass("lazy"),expand:$li.hasClass("expanded"),select:$li.hasClass("selected"),activate:$li.hasClass("active"),focus:$li.hasClass("focused")};if($li.attr("title")){data.tooltip=$li.attr("title")}if($li.attr("id")){data.key=$li.attr("id")}if($li.attr("data")){var dataAttr=$.trim($li.attr("data"));if(dataAttr){if(dataAttr.charAt(0)!="{"){dataAttr="{"+dataAttr+"}"}try{$.extend(data,eval("("+dataAttr+")"))}catch(e){throw ("Error parsing node data: "+e+"\ndata:\n'"+dataAttr+"'")}}}childNode=parentTreeNode._addNode(data);var $ul=$li.find(">ul:first");if($ul.length){self._createFromTag(childNode,$ul)}})},findNodeByPath:function(strPath,dtnodeStart){if(strPath.length<1){return this.tnRoot}var arTitles=strPath.split("/");for(var i=arTitles.length-1;i>-1;i--){if(arTitles[i].length<1){arTitles.splice(i,1)}}if(arTitles.length<1){return null}var tNode;var n;if(dtnodeStart!=null){tNode=dtnodeStart;n=tNode.getLevel()}else{n=0;tNode=this.tnRoot}var tNodeFound=null;var nEnd=arTitles.length;while(tNode!=null&&n<nEnd){tNodeFound=tNode;tNode=tNode.getChildByTitle(arTitles[n]);n++}if(tNode!=null){tNodeFound=tNode}return tNodeFound},startDebugMeasuring:function(strIdentifier){this.oDebug.strIdentifier=strIdentifier;this.oDebug.timeStart=new Date()},stopDebugMeasuring:function(){this.oDebug.timeEnd=new Date();var exectime=(this.oDebug.timeEnd.getTime()-this.oDebug.timeStart.getTime());var StrItem;if(exectime>this.oDebug.maxTime||this.oDebug.strIdentifier==undefined){this.oDebug.strMaxTime=this.oDebug.strIdentifier;this.oDebug.maxTime=exectime}},stopAutoExpanding:function(){this.strAutoExpandPath=null},isAutoExpanding:function(){return(this.strAutoExpandPath!=null)},lastentry:undefined};$.widget("ui.dynatree",{init:function(){return this._init()},_init:function(){this.options.event+=".dynatree";var $this=this.element;var opts=this.options;if(!opts.imagePath){$("script").each(function(){if(this.src.search(/.*dynatree[^/]*\.js$/i)>=0){if(this.src.indexOf("/")>=0){opts.imagePath=this.src.slice(0,this.src.lastIndexOf("/"))+"/skin/"}else{opts.imagePath="skin/"}return false}})}var divContainer=$this.get(0);if(opts.children||(opts.initAjax&&opts.initAjax.url)||opts.initId){$(divContainer).empty()}this.tree=new DynaTree(divContainer,opts);var root=this.tree.getRoot();var prevFlag=this.tree.enableUpdate(false);this.tree.logDebug("Start init tree structure...");if(opts.children){root.append(opts.children)}else{if(opts.initAjax&&opts.initAjax.url){root.appendAjax(opts.initAjax)}else{if(opts.initId){this.tree._createFromTag(root,$("#"+opts.initId))}else{var $ul=$this.find(">ul").hide();this.tree._createFromTag(root,$ul);$ul.remove()}}}this.tree.enableUpdate(prevFlag);this.tree.logDebug("Init tree structure... done.");this.bind();this.tree.initMode="postInit";if(this.tree.focusNode){this.tree.logDebug("Focus on init: %o",this.tree.focusNode);this.tree.focusNode.focus()}if(this.tree.activeNode){var dtnode=this.tree.activeNode;this.tree.activeNode=null;this.tree.logDebug("Activate on init: %o",dtnode);dtnode._userActivate()}this.tree.initMode="running"},bind:function(){var $this=this.element;var o=this.options;this.unbind();function __getNodeFromElement(el){if(!el){return null}var iMax=4;do{if(el&&el.dtnode){return el.dtnode}el=el.parentNode}while(el&&iMax--);return null}$this.bind("mouseup.dynatree click.dynatree dblclick.dynatree keypress.dynatree keydown.dynatree",function(event){var dtnode=__getNodeFromElement(event.target);if(!dtnode){if(event.type=="mouseup"){return true}else{return false}}switch(event.type){case"mouseup":return(o.onMouseUp&&o.onMouseUp(dtnode,event)===false)?false:dtnode.onMouseUp(event);break;case"click":return(o.onClick&&o.onClick(dtnode,event)===false)?false:dtnode.onClick(event);case"dblclick":return(o.onDblClick&&o.onDblClick(dtnode,event)===false)?false:dtnode.onDblClick(event);case"keydown":return(o.onKeydown&&o.onKeydown(dtnode,event)===false)?false:dtnode.onKeydown(event);case"keypress":return(o.onKeypress&&o.onKeypress(dtnode,event)===false)?false:dtnode.onKeypress(event)}});function __focusHandler(event){event=arguments[0]=$.event.fix(event||window.event);var dtnode=__getNodeFromElement(event.target);return dtnode?dtnode.onFocus(event):false}var div=this.tree.divTree;if(div.addEventListener){div.addEventListener("focus",__focusHandler,true);div.addEventListener("blur",__focusHandler,true)}else{div.onfocusin=div.onfocusout=__focusHandler}},unbind:function(){this.element.unbind(".dynatree")},enable:function(){this.bind();this.setData("disabled",false)},disable:function(){this.unbind();this.setData("disabled",true)},getTree:function(){return this.tree},getRoot:function(){return this.tree.getRoot()},getActiveNode:function(){return this.tree.getActiveNode()},lastentry:undefined});$.ui.dynatree.prototype.options={title:"Dynatree root",rootVisible:false,minExpandLevel:1,imagePath:null,children:null,initId:null,initAjax:null,autoFocus:true,keyboard:true,persist:false,autoCollapse:false,clickFolderMode:3,activeVisible:true,checkbox:false,selectMode:2,fx:null,onClick:null,onDblClick:null,onKeydown:null,onKeypress:null,onFocus:null,onBlur:null,onQueryActivate:null,onQuerySelect:null,onQueryExpand:null,onActivate:null,onDeactivate:null,onSelect:null,onExpand:null,onLazyRead:null,ajaxDefaults:{cache:false,dataType:"json"},strings:{loading:"Loading&#8230;",loadError:"Load error!"},idPrefix:"ui-dynatree-id-",cookieId:"ui-dynatree-cookie",cookie:{expires:null},classNames:{container:"ui-dynatree-container",folder:"ui-dynatree-folder",document:"ui-dynatree-document",empty:"ui-dynatree-empty",vline:"ui-dynatree-vline",expander:"ui-dynatree-expander",connector:"ui-dynatree-connector",checkbox:"ui-dynatree-checkbox",nodeIcon:"ui-dynatree-icon",nodeError:"ui-dynatree-statusnode-error",nodeWait:"ui-dynatree-statusnode-wait",hidden:"ui-dynatree-hidden",combinedExpanderPrefix:"ui-dynatree-exp-",combinedIconPrefix:"ui-dynatree-ico-",active:"ui-dynatree-active",selected:"ui-dynatree-selected",expanded:"ui-dynatree-expanded",lazy:"ui-dynatree-lazy",focused:"ui-dynatree-focused",partsel:"ui-dynatree-partsel",lastsib:"ui-dynatree-lastsib"},debugLevel:1,lastentry:undefined};$.ui.dynatree.nodedatadefaults={title:null,key:null,isFolder:true,isLazy:false,tooltip:null,icon:null,addClass:null,activate:false,focus:false,expand:false,select:false,children:null,lastentry:undefined}})(jQuery);