/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.migration;

import com.neptunelabs.fsiframework.O0oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.o0oO;
import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.Groups;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.authentication.Users;
import com.neptunelabs.fsiserver.migration.OldGroupsConfig;
import com.neptunelabs.fsiserver.migration.OldImporterProfile;
import com.neptunelabs.fsiserver.migration.OldPermissionSet;
import com.neptunelabs.fsiserver.migration.OldPermissionSets;
import com.neptunelabs.fsiserver.migration.OldUsersConfig;
import com.neptunelabs.fsiserver.migration.XMLSettings;
import com.neptunelabs.fsiserver.utils.SourceConnector;
import com.neptunelabs.fsiservletframework.E.B;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;

@WebServlet(name="Migrator", loadOnStartup=2, initParams={@WebInitParam(name="autorestart", value="true")})
public class Migrator
extends GenericServlet {
    private static final long serialVersionUID = 1611263353585839606L;
    private Path servletBaseDir = null;
    private Path defaultViewerDir = null;
    private Path backupViewerDir = null;
    private Path migrationDir = null;
    private Path migrationBackup = null;
    private Path usersDir = null;
    private Path configDirectory = null;
    final List<String> viewer5DistributionSkins = Arrays.asList("black.skn", "silver.skn", "plain.skn", "dialogs.skn");

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initPaths(servletConfig);
        if (!Files.exists(this.migrationDir, new LinkOption[0]) || !Files.isDirectory(this.migrationDir, new LinkOption[0])) {
            return;
        }
        boolean bl = this.quickCheckMigrationDirectory();
        if (bl) {
            bl &= this.backupDefaultViewer();
        }
        if (bl) {
            System.err.println("INFO: Starting test... ");
            bl &= this.migrate(true);
            System.err.println("INFO: Finished test... ");
        }
        if (bl) {
            System.err.println("INFO: Starting migration... ");
            bl &= this.migrate(false);
            System.err.println("INFO: Finished migration... ");
        }
        if (bl) {
            System.err.println("INFO: Migration completed without errors.");
            try {
                if (Files.exists(this.migrationBackup, new LinkOption[0])) {
                    o0oO.\u00f5o0000(this.migrationBackup);
                }
                Files.move(this.migrationDir, this.migrationBackup, new CopyOption[0]);
                System.err.println("INFO: Moved migration files to " + this.migrationBackup.toFile().getAbsolutePath());
            }
            catch (IOException iOException) {
                System.err.println("ERROR: Could not delete backup of old migration. " + this.migrationBackup.toFile().getAbsolutePath() + ". Please remove migration directory manually");
            }
        } else {
            System.err.println("ERROR: Errors occured during migration.");
        }
    }

    private boolean updateViewer(Path path, Path path2) {
        boolean bl = true;
        if (!Files.exists(path2, new LinkOption[0])) {
            bl &= o0oO.privatesuper(null, this.backupViewerDir, path2);
        }
        try {
            bl &= o0oO.\u00d4\u00d30000(path.resolve("_default.fsi"), path2.resolve("_default.xml"));
            if (!Files.exists(path2.resolve("config_backup"), new LinkOption[0])) {
                Files.move(path2.resolve("config"), path2.resolve("config_backup"), StandardCopyOption.REPLACE_EXISTING);
            }
            bl &= o0oO.privatesuper(null, path.resolve("config"), path2.resolve("config"));
            bl &= this.renameFSIFiles(path2.resolve("config"));
            bl &= this.copyFSIViewerSkins(path.resolve("skins"), path2.resolve("skins"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("ERROR: Encountered Exception updating FSI Viewer instance: " + iOException.getLocalizedMessage());
            bl = false;
        }
        return bl;
    }

    private boolean copyFSIViewerSkins(Path path, Path path2) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path3 : directoryStream) {
                String string;
                if (Files.isDirectory(path3, new LinkOption[0])) {
                    string = path3.getFileName().toString();
                    this.copyFSIViewerSkins(path3, path2.resolve(string));
                    continue;
                }
                string = path3.getFileName().toString();
                if (this.viewer5DistributionSkins.contains(string)) continue;
                if (string.endsWith(".skn")) {
                    string = string.substring(0, string.length() - 3) + "swf";
                }
                Path path4 = path3.getParent().resolve(string);
                Files.copy(path3, path4, new CopyOption[0]);
            }
        }
        catch (IOException | DirectoryIteratorException exception) {
            System.err.println("ERROR: Error renaming fsi-files. " + exception.getLocalizedMessage());
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean renameFSIFiles(Path path) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            Iterator<Path> iterator = directoryStream.iterator();
            while (iterator.hasNext()) {
                Path path2 = iterator.next();
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    if (this.renameFSIFiles(path2)) continue;
                    boolean bl = false;
                    return bl;
                }
                String string = path2.getFileName().toString();
                if (!string.endsWith(".fsi")) continue;
                String string2 = string.substring(0, string.length() - 3) + "xml";
                Path path3 = path2.getParent().resolve(string2);
                Files.move(path2, path3, StandardCopyOption.REPLACE_EXISTING);
            }
            return true;
        }
        catch (IOException | DirectoryIteratorException exception) {
            System.err.println("ERROR: Error renaming fsi-files. " + exception.getLocalizedMessage());
            return false;
        }
    }

    private void initPaths(ServletConfig servletConfig) {
        this.servletBaseDir = Paths.get(servletConfig.getServletContext().getRealPath(""), new String[0]);
        this.defaultViewerDir = this.servletBaseDir.resolve("viewer");
        this.usersDir = this.servletBaseDir.resolve("users");
        Path path = this.servletBaseDir.resolve("WEB-INF");
        this.migrationDir = path.resolve("migration");
        this.migrationBackup = path.resolve("migration_backup");
        this.backupViewerDir = path.resolve("viewer_dist");
        String string = System.getProperty("com.neptunelabs.fsiserver.config.home");
        this.configDirectory = string == null ? path.resolve("config") : Paths.get(string, new String[0]);
    }

    private boolean backupDefaultViewer() {
        if (!Files.exists(this.backupViewerDir, new LinkOption[0])) {
            System.err.println("Backing up distribution viewer directory to " + this.backupViewerDir.toFile().getAbsolutePath());
            if (!o0oO.privatesuper(null, this.defaultViewerDir, this.backupViewerDir)) {
                System.err.println("Could not create backup of distribution viewer directory.");
                return false;
            }
        } else {
            System.err.println("INFO: Backup of distribution viewer directory already exists. Skipping...");
        }
        return true;
    }

    private boolean migrate(boolean bl) {
        boolean bl2 = this.migrateDefaultViewer(bl);
        if (bl2) {
            bl2 &= this.migrateUserViewers(bl);
        }
        if (bl2) {
            bl2 &= this.migrateSourceManagerSettings(bl);
        }
        if (bl2) {
            bl2 &= this.migrateRequestProcessorSettings(bl);
        }
        if (bl2) {
            bl2 &= this.migrateUsers(bl);
        }
        if (bl2) {
            bl2 &= this.migrateGroups(bl);
        }
        if (bl2) {
            bl2 &= this.migrateSourceConnectors(bl);
        }
        return bl2;
    }

    private boolean migrateDefaultViewer(boolean bl) {
        boolean bl2;
        Path path = this.migrationDir.resolve("viewer");
        if (Files.exists(path, new LinkOption[0])) {
            if (bl) {
                bl2 = Files.isWritable(this.defaultViewerDir);
                if (!bl2) {
                    System.err.println("ERROR: Aborting migration. Default Viewer directory is not writable: " + this.defaultViewerDir.toString());
                }
            } else {
                bl2 = this.updateViewer(this.migrationDir.resolve("viewer"), this.defaultViewerDir);
            }
        } else {
            System.err.println("INFO: Skipping viewer migration. No viewer dir found.");
            bl2 = true;
        }
        return bl2;
    }

    private boolean migrateUserViewers(boolean bl) {
        boolean bl2 = true;
        if (bl) {
            bl2 = Files.exists(this.usersDir, new LinkOption[0]) ? Files.isWritable(this.usersDir) : Files.isWritable(this.servletBaseDir);
            if (!bl2) {
                System.err.println("ERROR: Aborting migration. User Viewer directory can't be created or is not writable: " + this.usersDir.toString());
            }
        } else {
            Path path = this.migrationDir.resolve("users");
            if (Files.exists(path, new LinkOption[0])) {
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                    for (Path path2 : directoryStream) {
                        Path path3 = this.usersDir.resolve(path2.getFileName().toString());
                        Files.createDirectories(path3, new FileAttribute[0]);
                        bl2 &= this.updateViewer(path2.resolve("viewer"), path3.resolve("viewer"));
                    }
                }
                catch (IOException iOException) {
                    System.err.println("ERROR: Error migrating user viewers: " + iOException.getLocalizedMessage());
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    private boolean migrateSourceManagerSettings(boolean bl) {
        Path path = this.migrationDir.resolve("config").resolve("importer.xml");
        if (!Files.exists(path, new LinkOption[0])) {
            System.err.println("INFO: No Importer configuration found for migration... Skipping.");
            return true;
        }
        XMLSettings xMLSettings = new XMLSettings();
        xMLSettings.setSettingsFile(path);
        if (!xMLSettings.evalutateSettings()) {
            System.err.println("ERROR: Aborting migration. Error reading FSI Server 2 importer settings from " + path.toString());
            return false;
        }
        System.err.println("INFO: FSI Server 2 importer settings read successfully.");
        Path path2 = this.configDirectory.resolve("sourcemanager.xml");
        XMLSettings xMLSettings2 = new XMLSettings();
        xMLSettings2.setSettingsFile(path2);
        if (!xMLSettings2.evalutateSettings()) {
            System.err.println("ERROR: Aborting migration. Error reading FSI Server sourcemanager settings from " + path2.toString());
            return false;
        }
        System.err.println("INFO: FSI Server source manager settings read successfully.");
        String string = xMLSettings.getPrefsString("application", "storage");
        xMLSettings2.setPrefs("application", B._o.\u00d200000, "storage", string);
        String string2 = xMLSettings.getPrefsString("application", "importstrategy");
        xMLSettings2.setPrefs("application", B._o.\u00d200000, "importstrategy", string2);
        String string3 = xMLSettings.getPrefsString("application", "maxcpu");
        xMLSettings2.setPrefs("application", B._o.\u00d200000, "maxcpu", string3);
        String string4 = xMLSettings.getPrefsString("application", "imagethreads");
        xMLSettings2.setPrefs("application", B._o.\u00d200000, "imagethreads", string4);
        String string5 = xMLSettings.getPrefsString("application", "parallelread");
        xMLSettings2.setPrefs("application", B._o.\u00d200000, "parallelread", string5);
        String string6 = xMLSettings.getPrefsString("application", "parallelwrite");
        xMLSettings2.setPrefs("application", B._o.\u00d200000, "parallelwrite", string6);
        String string7 = xMLSettings.getPrefsString("application", "parallelreadwrite");
        xMLSettings2.setPrefs("application", B._o.\u00d200000, "parallelread", string7);
        if (xMLSettings.hasSectionEnabled("search")) {
            System.err.println("WARNING: Found enabled search settings in old configuration. The search can not be automatically migrated. Please configure search manually after the migration has completed.");
        }
        System.err.println("INFO: FSI Server importer settings transferred.");
        if (!Files.isWritable(path2)) {
            System.err.println("ERROR: Aborting migration. Error writing FSI Server sourcemanager settings to " + path2.toString());
            return false;
        }
        if (!bl && !xMLSettings2.saveSettingsFile()) {
            System.err.println("ERROR: Aborting migration. Error writing FSI Server sourcemanager settings to " + path2.toString());
            return false;
        }
        System.err.println("INFO: FSI Server source manager settings written successfully.");
        return true;
    }

    private boolean migrateRequestProcessorSettings(boolean bl) {
        Path path = this.migrationDir.resolve("config").resolve("settings.xml");
        if (!Files.exists(path, new LinkOption[0])) {
            System.err.println("INFO: No core configuration found for migration... Skipping.");
            return true;
        }
        XMLSettings xMLSettings = new XMLSettings();
        xMLSettings.setSettingsFile(path);
        if (!xMLSettings.evalutateSettings()) {
            System.err.println("ERROR: Aborting migration. Error reading FSI Server 2 core settings from " + path.toString());
            return false;
        }
        System.err.println("INFO: FSI Server 2 core settings read successfully.");
        Path path2 = this.configDirectory.resolve("requestprocessor.xml");
        XMLSettings xMLSettings2 = new XMLSettings();
        xMLSettings2.setSettingsFile(path2);
        if (!xMLSettings2.evalutateSettings()) {
            System.err.println("ERROR: Aborting migration. Error reading FSI Server requestprocessor settings from " + path2.toString());
            return false;
        }
        System.err.println("INFO: FSI Server requestprocessor settings read successfully.");
        String string = xMLSettings.getPrefsString("application", "storage");
        xMLSettings2.setPrefs("application", B._o.\u00d200000, "storage", string);
        System.err.println("INFO: FSI Server core settings transferred.");
        if (!Files.isWritable(path2)) {
            System.err.println("ERROR: Aborting migration. Error writing FSI Server requestprocessor settings to " + path2.toString());
            return false;
        }
        if (!bl && !xMLSettings2.saveSettingsFile()) {
            System.err.println("ERROR: Aborting migration. Error writing FSI Server requestprocessor settings to " + path2.toString());
            return false;
        }
        System.err.println("INFO: FSI Server requestprocessor settings written successfully.");
        return true;
    }

    private boolean migrateUsers(boolean bl) {
        Path path = this.migrationDir.resolve("config").resolve("users.xml");
        if (!Files.exists(path, new LinkOption[0])) {
            System.err.println("INFO: No Users file found to migrate... Skipping");
            return true;
        }
        OldUsersConfig oldUsersConfig = null;
        try {
            oldUsersConfig = (OldUsersConfig)JAXB.unmarshal((File)path.toFile(), OldUsersConfig.class);
        }
        catch (Exception exception) {
            System.err.println("ERROR: Aborting migration: Failed to read old users config from " + path.toString());
            return false;
        }
        Users users = new Users();
        users.users = new HashSet<Users.User>();
        for (OldUsersConfig.User user : oldUsersConfig.users) {
            Users.User user2 = new Users.User();
            user2.name = user.name;
            if (user.hash != null && user.hash.length() > 0) {
                user2.hash = user.hash;
            } else {
                user2.plain = user.plain;
            }
            if (user.accesslevel.equalsIgnoreCase("admin")) {
                user2.permissionSet = "administratorPermissions";
            }
            users.users.add(user2);
        }
        Path path2 = this.configDirectory.resolve("users.xml");
        try {
            if (!bl) {
                JAXB.marshal((Object)users, (File)path2.toFile());
            }
            System.err.println("INFO: Written users config to " + path2.toString());
        }
        catch (Exception exception) {
            System.err.println("ERROR: Aborting migration: Failed to write users config to " + path2.toString());
            return false;
        }
        return true;
    }

    private boolean migrateGroups(boolean bl) {
        Path path = this.migrationDir.resolve("config").resolve("groups.xml");
        if (!Files.exists(path, new LinkOption[0])) {
            System.err.println("INFO: No Groups file found to migrate... Skipping");
            return true;
        }
        OldGroupsConfig oldGroupsConfig = null;
        try {
            oldGroupsConfig = (OldGroupsConfig)JAXB.unmarshal((File)path.toFile(), OldGroupsConfig.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("ERROR: Aborting migration: Failed to read old groups config from " + path.toString());
            return false;
        }
        Groups groups = new Groups();
        ArrayList<Group> arrayList = new ArrayList<Group>();
        for (OldGroupsConfig.Group group : oldGroupsConfig.getGroups()) {
            Group group2;
            if (group.name.equals("users")) {
                group2 = new Group("authenticated");
                group2.setPermissionSet("default_authenticated");
            } else {
                group2 = new Group(group.name);
            }
            group2.setUsers(group.users);
            arrayList.add(group2);
        }
        groups.setGroups(arrayList);
        Path path2 = this.configDirectory.resolve("groups.xml");
        try {
            if (!bl) {
                JAXB.marshal((Object)groups, (File)path2.toFile());
            }
            System.err.println("INFO: Written groups config to " + path2.toString());
        }
        catch (Exception exception) {
            System.err.println("ERROR: Aborting migration: Failed to write groups config to " + path2.toString());
            return false;
        }
        return true;
    }

    private boolean migrateSourceConnectors(boolean bl) {
        Path path = this.migrationDir.resolve("importer_profiles");
        Path path2 = this.configDirectory.resolve("connectors");
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path3 : directoryStream) {
                if (!Files.isRegularFile(path3, new LinkOption[0]) || !path3.getFileName().toString().endsWith(".xml")) continue;
                try {
                    OldImporterProfile oldImporterProfile = (OldImporterProfile)JAXB.unmarshal((File)path3.toFile(), OldImporterProfile.class);
                    System.err.println("INFO: Read importer profile definition from : " + path3.getFileName().toString());
                    SourceConnector sourceConnector = new SourceConnector();
                    sourceConnector.enabled = oldImporterProfile.enabled;
                    sourceConnector.conversion.format = oldImporterProfile.conversion.format;
                    if (oldImporterProfile.conversion.quality > 0) {
                        sourceConnector.conversion.quality = oldImporterProfile.conversion.quality;
                    }
                    sourceConnector.type = "storage";
                    sourceConnector.origin.location = oldImporterProfile.origin.location;
                    for (OldImporterProfile.GroupEntry groupEntry : oldImporterProfile.access.groupEntries) {
                        SourceConnector.GroupEntry groupEntry2 = new SourceConnector.GroupEntry();
                        if (groupEntry.permissionset.equals("r")) {
                            groupEntry2.permissionset = "read_only";
                        } else if (groupEntry.permissionset.equals("rw")) {
                            groupEntry2.permissionset = "read_write";
                        } else if (groupEntry.permissionset.equals("public")) {
                            groupEntry2.permissionset = "public_images";
                        } else {
                            this.createNewPermissionSetFromOldPermissionSet(groupEntry.permissionset, bl);
                            groupEntry2.permissionset = groupEntry.permissionset;
                        }
                        groupEntry2.groupname = groupEntry.groupname;
                    }
                    if (bl) continue;
                    Path path4 = path2.resolve(path3.getFileName());
                    JAXB.marshal((Object)sourceConnector, (File)path4.toFile());
                    System.err.println("INFO: Written new Connector configuration to " + path4.toString());
                }
                catch (DataBindingException dataBindingException) {
                    System.err.println("WARNING: Could not read importer profile: " + path3.getFileName().toString() + " ...skipping. " + dataBindingException.getLocalizedMessage());
                }
            }
        }
        catch (IOException | DirectoryIteratorException exception) {
            System.err.println("ERROR: Aborting migration. " + exception.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private void createNewPermissionSetFromOldPermissionSet(String string, boolean bl) {
        PermissionSet permissionSet = new PermissionSet(string);
        OldPermissionSet oldPermissionSet = null;
        Path path = this.migrationDir.resolve("config").resolve("permissionsets.xml");
        OldPermissionSets oldPermissionSets = (OldPermissionSets)JAXB.unmarshal((File)path.toFile(), OldPermissionSets.class);
        for (OldPermissionSet oldPermissionSet2 : oldPermissionSets.getSets()) {
            if (!oldPermissionSet2.name.equals(string)) continue;
            oldPermissionSet = oldPermissionSet2;
            break;
        }
        if (oldPermissionSet != null) {
            if (oldPermissionSet.dirList) {
                permissionSet.list.directories = true;
            }
            if (oldPermissionSet.imageList) {
                permissionSet.list.files = true;
            }
            if (oldPermissionSet.imageRead) {
                permissionSet.read.renderedImages = true;
            }
            if (oldPermissionSet.infoRead) {
                permissionSet.read.basicMetadata = true;
                permissionSet.read.extendedMetadata = true;
            }
            if (oldPermissionSet.upload && oldPermissionSet.delete) {
                permissionSet.write.createDirectory = true;
                permissionSet.write.extendedMetadata = true;
                permissionSet.write.moveWithinConnector = true;
                permissionSet.write.paste = true;
                permissionSet.write.upload = true;
                permissionSet.write.delete = true;
                permissionSet.write.moveToTrash = true;
                permissionSet.write.overwrite = true;
                permissionSet.write.rename = true;
            } else if (oldPermissionSet.upload) {
                permissionSet.write.createDirectory = true;
                permissionSet.write.upload = true;
                permissionSet.list.connector = true;
            }
            if (!bl) {
                Path path2 = this.configDirectory.resolve("permissionsets").resolve(string + ".xml");
                JAXB.marshal((Object)permissionSet, (File)path2.toFile());
            }
        } else {
            System.err.println("WARNING: Failed to migrate permission set " + string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean quickCheckMigrationDirectory() {
        List<String> list = Arrays.asList("config", "viewer", "users", "importer_profiles", "server_profiles");
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.migrationDir);){
            for (Path path : directoryStream) {
                if (list.contains(path.toFile().getName())) continue;
                System.err.println("ERROR: Aborting migration. Migration directory contains unknown files: " + path.toFile().getName());
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException | DirectoryIteratorException exception) {
            System.err.println("ERROR: Aborting migration. " + exception.getLocalizedMessage());
            return false;
        }
        if (Files.isWritable(this.migrationDir.getParent())) return this.checkMigrationDirPermissions(this.migrationDir);
        System.err.println("ERROR: Aborting migration. " + this.migrationDir.getParent().toFile().getAbsolutePath() + " is not writable.");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkMigrationDirPermissions(Path path) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            Path path2;
            Iterator<Path> iterator = directoryStream.iterator();
            do {
                if (!iterator.hasNext()) return true;
                path2 = iterator.next();
                if (!Files.isReadable(path2)) {
                    System.err.println("ERROR: Aborting migration. " + path2.toFile().getAbsolutePath() + " not readable.");
                    boolean bl = false;
                    return bl;
                }
                if (Files.isWritable(path2)) continue;
                System.err.println("ERROR: Aborting migration. " + path2.toFile().getAbsolutePath() + " not writeable.");
                boolean bl = false;
                return bl;
            } while (!Files.isDirectory(path2, new LinkOption[0]) || this.checkMigrationDirPermissions(path2));
            boolean bl = false;
            return bl;
        }
        catch (IOException | DirectoryIteratorException exception) {
            System.err.println("ERROR: Aborting migration. " + exception.getLocalizedMessage());
        }
        return true;
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
    }
}

