/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

final class MlibSeparableConvolveOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    float[] hValues;
    float[] vValues;
    double[] hDoubleData;
    double[] vDoubleData;
    int[] hIntData;
    int[] vIntData;
    int shift = -1;

    public MlibSeparableConvolveOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        int n;
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.hValues = kernelJAI.getHorizontalKernelData();
        this.vValues = kernelJAI.getVerticalKernelData();
        this.hDoubleData = new double[this.hValues.length];
        for (n = 0; n < this.hValues.length; ++n) {
            this.hDoubleData[n] = this.hValues[n];
        }
        this.vDoubleData = new double[this.vValues.length];
        for (n = 0; n < this.vValues.length; ++n) {
            this.vDoubleData[n] = this.vValues[n];
        }
        this.hIntData = new int[this.hValues.length];
        this.vIntData = new int[this.vValues.length];
    }

    private synchronized void setShift(int n) {
        if (this.shift == -1) {
            int n2 = MediaLibAccessor.getMediaLibDataType(n);
            this.shift = Image.SConvKernelConvert((int[])this.hIntData, (int[])this.vIntData, (double[])this.hDoubleData, (double[])this.vDoubleData, (int)this.kw, (int)this.kh, (int)n2);
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        int n2 = this.getSampleModel().getNumBands();
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        block14: for (int i = 0; i < mediaLibImageArray2.length; ++i) {
            switch (mediaLibAccessor2.getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.shift == -1) {
                        this.setShift(n);
                    }
                    switch (this.kw) {
                        case 3: {
                            Image.SConv3x3((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (int[])this.hIntData, (int[])this.vIntData, (int)this.shift, (int)((1 << n2) - 1), (int)0);
                            break;
                        }
                        case 5: {
                            Image.SConv5x5((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (int[])this.hIntData, (int[])this.vIntData, (int)this.shift, (int)((1 << n2) - 1), (int)0);
                            break;
                        }
                        case 7: {
                            Image.SConv7x7((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (int[])this.hIntData, (int[])this.vIntData, (int)this.shift, (int)((1 << n2) - 1), (int)0);
                        }
                    }
                    continue block14;
                }
                case 4: 
                case 5: {
                    switch (this.kw) {
                        case 3: {
                            Image.SConv3x3_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.hDoubleData, (double[])this.vDoubleData, (int)((1 << n2) - 1), (int)0);
                            break;
                        }
                        case 5: {
                            Image.SConv5x5_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.hDoubleData, (double[])this.vDoubleData, (int)((1 << n2) - 1), (int)0);
                            break;
                        }
                        case 7: {
                            Image.SConv7x7_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.hDoubleData, (double[])this.vDoubleData, (int)((1 << n2) - 1), (int)0);
                        }
                    }
                    continue block14;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("Generic2"));
                }
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

