/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class ClampOpImage
extends PointOpImage {
    private byte[][] byteTable = null;
    private final double[] low;
    private final double[] high;

    private synchronized void initByteTable() {
        if (this.byteTable == null) {
            int n = this.getSampleModel().getNumBands();
            this.byteTable = new byte[n][256];
            for (int i = 0; i < n; ++i) {
                byte[] byArray = this.byteTable[i];
                int n2 = (int)this.low[i];
                int n3 = (int)this.high[i];
                byte by = (byte)n2;
                byte by2 = (byte)n3;
                for (int j = 0; j < 256; ++j) {
                    byArray[j] = j < n2 ? by : (j > n3 ? by2 : (byte)j);
                }
            }
        }
    }

    public ClampOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[] dArray, double[] dArray2) {
        super(renderedImage, imageLayout, map, true);
        int n = this.getSampleModel().getNumBands();
        if (dArray.length < n || dArray2.length < n) {
            this.low = new double[n];
            this.high = new double[n];
            for (int i = 0; i < n; ++i) {
                this.low[i] = dArray[0];
                this.high[i] = dArray2[0];
            }
        } else {
            this.low = (double[])dArray.clone();
            this.high = (double[])dArray2.clone();
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2);
            }
        }
        rasterAccessor2.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        this.initByteTable();
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        for (int i = 0; i < n3; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            byte[] byArray5 = this.byteTable[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    byArray3[n10] = byArray5[byArray4[n11] & 0xFF];
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = (int)this.low[i];
            int n9 = (int)this.high[i];
            short s = (short)n8;
            short s2 = (short)n9;
            int n10 = nArray[i];
            int n11 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n12 = n10;
                int n13 = n11;
                n10 += n4;
                n11 += n6;
                for (int k = 0; k < n; ++k) {
                    int n14 = sArray4[n13] & 0xFFFF;
                    sArray3[n12] = n14 < n8 ? s : (n14 > n9 ? s2 : (short)n14);
                    n12 += n5;
                    n13 += n7;
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = (int)this.low[i];
            int n9 = (int)this.high[i];
            short s = (short)n8;
            short s2 = (short)n9;
            int n10 = nArray[i];
            int n11 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n12 = n10;
                int n13 = n11;
                n10 += n4;
                n11 += n6;
                for (int k = 0; k < n; ++k) {
                    short s3 = sArray4[n13];
                    sArray3[n12] = s3 < n8 ? s : (s3 > n9 ? s2 : s3);
                    n12 += n5;
                    n13 += n7;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        for (int i = 0; i < n3; ++i) {
            int[] nArray5 = nArray2[i];
            int[] nArray6 = nArray4[i];
            double d = this.low[i];
            double d2 = this.high[i];
            int n8 = (int)d;
            int n9 = (int)d2;
            int n10 = nArray[i];
            int n11 = nArray3[i];
            for (int j = 0; j < n2; ++j) {
                int n12 = n10;
                int n13 = n11;
                n10 += n4;
                n11 += n6;
                for (int k = 0; k < n; ++k) {
                    int n14 = nArray6[n13];
                    nArray5[n12] = (double)n14 < d ? n8 : ((double)n14 > d2 ? n9 : n14);
                    n12 += n5;
                    n13 += n7;
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        for (int i = 0; i < n3; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            double d = this.low[i];
            double d2 = this.high[i];
            float f = (float)d;
            float f2 = (float)d2;
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    float f3 = fArray4[n11];
                    fArray3[n10] = (double)f3 < d ? f : ((double)f3 > d2 ? f2 : f3);
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        for (int i = 0; i < n3; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            double d = this.low[i];
            double d2 = this.high[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    double d3 = dArray4[n11];
                    dArray3[n10] = d3 < d ? d : (d3 > d2 ? d2 : d3);
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }
}

