/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import java.awt.Point;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.TileScheduler;

class Request
implements TileRequest {
    private final TileScheduler scheduler;
    final PlanarImage image;
    final List indices;
    final Set listeners;
    final Hashtable tileStatus;

    Request(TileScheduler tileScheduler, PlanarImage planarImage, Point[] pointArray, TileComputationListener[] tileComputationListenerArray) {
        if (tileScheduler == null) {
            throw new IllegalArgumentException();
        }
        this.scheduler = tileScheduler;
        if (planarImage == null) {
            throw new IllegalArgumentException();
        }
        this.image = planarImage;
        if (pointArray == null || pointArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.indices = Arrays.asList(pointArray);
        if (tileComputationListenerArray != null) {
            int n = tileComputationListenerArray.length;
            if (n > 0) {
                this.listeners = new HashSet(n);
                for (int i = 0; i < n; ++i) {
                    this.listeners.add(tileComputationListenerArray[i]);
                }
            } else {
                this.listeners = null;
            }
        } else {
            this.listeners = null;
        }
        this.tileStatus = new Hashtable(pointArray.length);
    }

    public PlanarImage getImage() {
        return this.image;
    }

    public Point[] getTileIndices() {
        return this.indices.toArray(new Point[0]);
    }

    public TileComputationListener[] getTileListeners() {
        return this.listeners.toArray(new TileComputationListener[0]);
    }

    public boolean isStatusAvailable() {
        return true;
    }

    public int getTileStatus(int n, int n2) {
        Point point = new Point(n, n2);
        int n3 = this.tileStatus.containsKey(point) ? (Integer)this.tileStatus.get(point) : 0;
        return n3;
    }

    public void cancelTiles(Point[] pointArray) {
        this.scheduler.cancelTiles(this, pointArray);
    }
}

