<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">
<#include "/macros/byteprint.ftl">
<#include "/macros/barchart.ftl">
<#include "/macros/formtable.ftl">

  <@tableHeader Heading="Caches" />

  <#if show_form?? >

    <#if message??>
      ${message}
    </#if>
    
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
	  <tr>
	   <td class="pad1" colspan="6">
		The FSI Server uses internal memory caches to improve the overall server performance and reduce the hardware 
		resources used. The table below shows some cache usage statistics. 
		Clearing the cache here manually is not necessary for normal operation, but might be useful for performance 
		measurements or debugging purposes. Clearing the cache will not delete any files on the server or touch any 
		images uploaded to the server, it will have an impact on the server's performance though, as the cached data 
		needs to be re-computed or re-read from the hard disk.
	   </td>
	  </tr>
	  
	  <#if requestprocessorcache?? && sourcemanagercache??>
	  <tr>
	    <td class="sectionheader" colspan="3">Request Processor Cache</td>
	  </tr>
	  </#if>
	  
	  <#if requestprocessorcache?? >
	  <tr>
	    <td class="sectionheader" style="text-align: right;">Objects Cached</td>
	    <td class="sectionheader" style="text-align: right;">Used Size</td>
	    <td class="sectionheader" style="text-align: right;">Total Size</td>
	    <td class="sectionheader" colspan="3"></td>	    
	  </tr>
	  <tr>
	    <td class="pad1" align="right">${requestprocessorcache.objects}</td>
	    <td class="pad1" align="right"><@bytePrint bytes=requestprocessorcache.used_bytes /></td>
	    <td class="pad1" align="right"><@bytePrint bytes=requestprocessorcache.total_bytes /></td>
	    <td class="pad1" align="right" colspan="3"><@barChart used=requestprocessorcache.used_bytes total=requestprocessorcache.total_bytes height=17 width=200 /></td>
	  </tr>
	  
	  <tr>
	    <td class="sectionheader">Object Type</td>
	    <td class="sectionheader" style="text-align: right;">Hits L1</td>
	    <td class="sectionheader" style="text-align: right;">Hits L2</td>
	    <td class="sectionheader" style="text-align: right;">Total Requests</td>
	    <td class="sectionheader" style="text-align: right;">Save Ops</td>
	    <td class="sectionheader" style="text-align: right;">Failed Save Ops</td>
	  </tr>
	  <tr>
	    <td class="pad1">Blob</td> 
        <td class="pad1" align="right">${requestprocessorcache['hits_L1_BLOB']}</td>
        <td class="pad1" align="right">${requestprocessorcache['hits_L2_BLOB']}</td>
        <td class="pad1" align="right">${requestprocessorcache['requests_BLOB']}</td>
        <td class="pad1" align="right">${requestprocessorcache['saves_BLOB']}</td>
        <td class="pad1" align="right">${requestprocessorcache['savesfailed_BLOB']}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Response</td> 
        <td class="pad1" align="right">${requestprocessorcache['hits_L1_RESPONSE']}</td>
        <td class="pad1" align="right">${requestprocessorcache['hits_L2_RESPONSE']}</td>
        <td class="pad1" align="right">${requestprocessorcache['requests_RESPONSE']}</td>
        <td class="pad1" align="right">${requestprocessorcache['saves_RESPONSE']}</td>
        <td class="pad1" align="right">${requestprocessorcache['savesfailed_RESPONSE']}</td>
	  </tr>
	  <tr>
	    <td class="pad1">List</td> 
        <td class="pad1" align="right">${requestprocessorcache['hits_L1_LIST']}</td>
        <td class="pad1" align="right">${requestprocessorcache['hits_L2_LIST']}</td>
        <td class="pad1" align="right">${requestprocessorcache['requests_LIST']}</td>
        <td class="pad1" align="right">${requestprocessorcache['saves_LIST']}</td>
        <td class="pad1" align="right">${requestprocessorcache['savesfailed_LIST']}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Metadata</td> 
        <td class="pad1" align="right">${requestprocessorcache['hits_L1_METADATA']}</td>
        <td class="pad1" align="right">${requestprocessorcache['hits_L2_METADATA']}</td>
        <td class="pad1" align="right">${requestprocessorcache['requests_METADATA']}</td>
        <td class="pad1" align="right">${requestprocessorcache['saves_METADATA']}</td>
        <td class="pad1" align="right">${requestprocessorcache['savesfailed_METADATA']}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Tile</td>
        <td class="pad1" align="right">${requestprocessorcache['hits_L1_TILE']}</td>
        <td class="pad1" align="right">${requestprocessorcache['hits_L2_TILE']}</td>
        <td class="pad1" align="right">${requestprocessorcache['requests_TILE']}</td>
        <td class="pad1" align="right">${requestprocessorcache['saves_TILE']}</td>
        <td class="pad1" align="right">${requestprocessorcache['savesfailed_TILE']}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Image</td> 
        <td class="pad1" align="right">${requestprocessorcache['hits_L1_IMAGE']}</td>
        <td class="pad1" align="right">${requestprocessorcache['hits_L2_IMAGE']}</td>
        <td class="pad1" align="right">${requestprocessorcache['requests_IMAGE']}</td>
        <td class="pad1" align="right">${requestprocessorcache['saves_IMAGE']}</td>
        <td class="pad1" align="right">${requestprocessorcache['savesfailed_IMAGE']}</td>
	  </tr>
	  </#if>

	  <#if sourcemanagercache?? >
       <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
       <tr>
	    <td class="sectionheader" colspan="3">Source Manager Cache</td>
	   </tr>
	   
	   <tr>
	    <td class="pad1" align="right">${sourcemanagercache.objects}</td>
	    <td class="pad1" align="right"><@bytePrint bytes=sourcemanagercache.used_bytes /></td>
	    <td class="pad1" align="right"><@bytePrint bytes=sourcemanagercache.total_bytes /></td>
	    <td class="pad1" align="right" colspan="3"><@barChart used=sourcemanagercache.used_bytes total=sourcemanagercache.total_bytes height=17 width=200 /></td>
	  </tr>
	  
	  <tr>
	    <td class="sectionheader">Object Type</td>
	    <td class="sectionheader" style="text-align: right;">Hits L1</td>
	    <td class="sectionheader" style="text-align: right;">Hits L2</td>
	    <td class="sectionheader" style="text-align: right;">Total Requests</td>
	    <td class="sectionheader" style="text-align: right;">Save Ops</td>
	    <td class="sectionheader" style="text-align: right;">Failed Save Ops</td>
	  </tr>
	  <tr>
	    <td class="pad1">Blob</td> 
        <td class="pad1" align="right">${sourcemanagercache['hits_L1_BLOB']}</td>
        <td class="pad1" align="right">${sourcemanagercache['hits_L2_BLOB']}</td>
        <td class="pad1" align="right">${sourcemanagercache['requests_BLOB']}</td>
        <td class="pad1" align="right">${sourcemanagercache['saves_BLOB']}</td>
        <td class="pad1" align="right">${sourcemanagercache['savesfailed_BLOB']}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Response</td> 
        <td class="pad1" align="right">${sourcemanagercache['hits_L1_RESPONSE']}</td>
        <td class="pad1" align="right">${sourcemanagercache['hits_L2_RESPONSE']}</td>
        <td class="pad1" align="right">${sourcemanagercache['requests_RESPONSE']}</td>
        <td class="pad1" align="right">${sourcemanagercache['saves_RESPONSE']}</td>
        <td class="pad1" align="right">${sourcemanagercache['savesfailed_RESPONSE']}</td>
	  </tr>
	  <tr>
	    <td class="pad1">List</td> 
        <td class="pad1" align="right">${sourcemanagercache['hits_L1_LIST']}</td>
        <td class="pad1" align="right">${sourcemanagercache['hits_L2_LIST']}</td>
        <td class="pad1" align="right">${sourcemanagercache['requests_LIST']}</td>
        <td class="pad1" align="right">${sourcemanagercache['saves_LIST']}</td>
        <td class="pad1" align="right">${sourcemanagercache['savesfailed_LIST']}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Metadata</td> 
        <td class="pad1" align="right">${sourcemanagercache['hits_L1_METADATA']}</td>
        <td class="pad1" align="right">${sourcemanagercache['hits_L2_METADATA']}</td>
        <td class="pad1" align="right">${sourcemanagercache['requests_METADATA']}</td>
        <td class="pad1" align="right">${sourcemanagercache['saves_METADATA']}</td>
        <td class="pad1" align="right">${sourcemanagercache['savesfailed_METADATA']}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Tile</td>
        <td class="pad1" align="right">${sourcemanagercache['hits_L1_TILE']}</td>
        <td class="pad1" align="right">${sourcemanagercache['hits_L2_TILE']}</td>
        <td class="pad1" align="right">${sourcemanagercache['requests_TILE']}</td>
        <td class="pad1" align="right">${sourcemanagercache['saves_TILE']}</td>
        <td class="pad1" align="right">${sourcemanagercache['savesfailed_TILE']}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Image</td> 
        <td class="pad1" align="right">${sourcemanagercache['hits_L1_IMAGE']}</td>
        <td class="pad1" align="right">${sourcemanagercache['hits_L2_IMAGE']}</td>
        <td class="pad1" align="right">${sourcemanagercache['requests_IMAGE']}</td>
        <td class="pad1" align="right">${sourcemanagercache['saves_IMAGE']}</td>
        <td class="pad1" align="right">${sourcemanagercache['savesfailed_IMAGE']}</td>
	  </tr>
	  </#if> 
	  
      <tr><td colspan="6"><hr size="1" class="hr1"/></td></tr>
	  
      <tr>
        <td class="pad1" align="left">
          <form action="pt.do" method="get" onsubmit="this.submit();">    
          <@printRequiredParams method="post" />
          <input type="hidden" name="action" value="memorycache">
          <@formsubmit value="Refresh" helpid="cache_refresh" />
	      </form>
        </td>
        <td class="pad1" align="right" colspan="5">
          <form action="pt.do" method="post" onsubmit="this.submit();">    
          <@printRequiredParams method="post" />
          <input type="hidden" name="action" value="memorycache">
          <input type="hidden" name="clearcache" value="1">
          <@formsubmit value="Clear Cache" helpid="cache_clear" />
	      </form>
        </td>
      </tr>
      </table>
    
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">