/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ByteOrder;

public class BinaryInputStream
extends InputStream {
    private final InputStream is;
    private ByteOrder byteOrder = ByteOrder.NETWORK;
    protected boolean debug = false;

    public final void setDebug(boolean b) {
        this.debug = b;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public BinaryInputStream(byte[] bytes, ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        this.is = new ByteArrayInputStream(bytes);
    }

    public BinaryInputStream(InputStream is, ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        this.is = is;
    }

    public BinaryInputStream(InputStream is) {
        this.is = is;
    }

    public final void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public final ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int read() throws IOException {
        return this.is.read();
    }

    public final int read4Bytes(String name, String exception) throws IOException {
        return BinaryFunctions.read4Bytes(name, this.is, exception, this.byteOrder);
    }

    public final void debugNumber(String msg, int data) {
        this.debugNumber(msg, data, 1);
    }

    public final void debugNumber(String msg, int data, int bytes) {
        System.out.print(msg + ": " + data + " (");
        int byteData = data;
        for (int i = 0; i < bytes; ++i) {
            if (i > 0) {
                System.out.print(",");
            }
            int singleByte = 0xFF & byteData;
            System.out.print((char)singleByte + " [" + singleByte + "]");
            byteData >>= 8;
        }
        System.out.println(") [0x" + Integer.toHexString(data) + ", " + Integer.toBinaryString(data) + "]");
    }

    public final void readAndVerifyBytes(byte[] expected, String exception) throws ImageReadException, IOException {
        BinaryFunctions.readAndVerifyBytes(this.is, expected, exception);
    }

    public final void readAndVerifyBytes(String name, byte[] expected, String exception) throws ImageReadException, IOException {
        BinaryFunctions.readAndVerifyBytes(name, this.is, expected, exception);
    }

    public final void skipBytes(long length, String exception) throws IOException {
        BinaryFunctions.skipBytes(this.is, length, exception);
    }

    public final void scanForByte(byte value) throws IOException {
        BinaryFunctions.scanForByte(this.is, value);
    }

    public final byte[] readBytes(String name, int length, String exception) throws IOException {
        return BinaryFunctions.readBytes(name, this.is, length, exception);
    }

    public final void debugByteArray(String name, byte[] bytes) {
        System.out.println(name + ": " + bytes.length);
        for (int i = 0; i < bytes.length && i < 50; ++i) {
            this.debugNumber(name + " (" + i + ")", bytes[i]);
        }
    }

    public final void debugNumberArray(String name, int[] numbers, int length) {
        System.out.println(name + ": " + numbers.length);
        for (int i = 0; i < numbers.length && i < 50; ++i) {
            this.debugNumber(name + " (" + i + ")", numbers[i], length);
        }
    }

    public final byte[] readBytes(int length, String error) throws ImageReadException, IOException {
        return BinaryFunctions.readBytes("", this.is, length, error);
    }

    public final boolean compareBytes(byte[] a, int aStart, byte[] b, int bStart, int length) {
        return BinaryFunctions.compareBytes(a, aStart, b, bStart, length);
    }

    public final int read4Bytes(String name, String exception, ByteOrder byteOrder) throws IOException {
        return BinaryFunctions.read4Bytes(name, this.is, exception, byteOrder);
    }

    public final int read4Bytes(String exception) throws IOException {
        return BinaryFunctions.read4Bytes("", this.is, exception, this.byteOrder);
    }

    public final int read3Bytes(String name, String exception, ByteOrder byteOrder) throws IOException {
        return BinaryFunctions.read3Bytes(name, this.is, exception, byteOrder);
    }

    public final int read3Bytes(String name, String exception) throws IOException {
        return BinaryFunctions.read3Bytes(name, this.is, exception, this.byteOrder);
    }

    public final int read2Bytes(String name, String exception, ByteOrder byteOrder) throws IOException {
        return BinaryFunctions.read2Bytes(name, this.is, exception, byteOrder);
    }

    public final int read2Bytes(String name, String exception) throws IOException {
        return BinaryFunctions.read2Bytes(name, this.is, exception, this.byteOrder);
    }

    public final int read2Bytes(String exception) throws IOException {
        return BinaryFunctions.read2Bytes("", this.is, exception, this.byteOrder);
    }

    public final byte readByte(String name, String exception) throws IOException {
        return BinaryFunctions.readByte(name, this.is, exception);
    }

    public final void printCharQuad(String msg, int i) {
        BinaryFunctions.printCharQuad(msg, i);
    }

    public final void printByteBits(String msg, byte i) {
        BinaryFunctions.printByteBits(msg, i);
    }

    public static final int charsToQuad(char c1, char c2, char c3, char c4) {
        return BinaryFunctions.charsToQuad(c1, c2, c3, c4);
    }

    public final int findNull(byte[] src) {
        return BinaryFunctions.findNull(src);
    }

    public final int findNull(byte[] src, int start) {
        return BinaryFunctions.findNull(src, start);
    }

    public final byte[] getRAFBytes(RandomAccessFile raf, long pos, int length, String exception) throws IOException {
        return BinaryFunctions.getRAFBytes(raf, pos, length, exception);
    }

    public void skipBytes(long length) throws IOException {
        BinaryFunctions.skipBytes(this.is, length);
    }
}

