/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.formats.pnm.FileInfo;
import org.apache.commons.imaging.formats.pnm.WhiteSpaceReader;

public class PamFileInfo
extends FileInfo {
    private final int depth;
    private final int maxval;
    private final float scale;
    private final int bytesPerSample;
    private final boolean hasAlpha;
    private final TupleReader tupleReader;

    PamFileInfo(int width, int height, int depth, int maxval, String tupleType) throws ImageReadException {
        super(width, height, true);
        this.depth = depth;
        this.maxval = maxval;
        if (maxval <= 0) {
            throw new ImageReadException("PAM maxVal " + maxval + " is out of range [1;65535]");
        }
        if (maxval <= 255) {
            this.scale = 255.0f;
            this.bytesPerSample = 1;
        } else if (maxval <= 65535) {
            this.scale = 65535.0f;
            this.bytesPerSample = 2;
        } else {
            throw new ImageReadException("PAM maxVal " + maxval + " is out of range [1;65535]");
        }
        this.hasAlpha = tupleType.endsWith("_ALPHA");
        if (tupleType.equals("BLACKANDWHITE") || tupleType.equals("BLACKANDWHITE_ALPHA")) {
            this.tupleReader = new GrayscaleTupleReader(0);
        } else if (tupleType.equals("GRAYSCALE") || tupleType.equals("GRAYSCALE_ALPHA")) {
            this.tupleReader = new GrayscaleTupleReader(1);
        } else if (tupleType.equals("RGB") || tupleType.equals("RGB_ALPHA")) {
            this.tupleReader = new ColorTupleReader();
        } else {
            throw new ImageReadException("Unknown PAM tupletype '" + tupleType + "'");
        }
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    public int getNumComponents() {
        return this.depth;
    }

    public int getBitDepth() {
        return this.maxval;
    }

    public ImageFormat getImageType() {
        return ImageFormat.IMAGE_FORMAT_PAM;
    }

    public String getImageTypeDescription() {
        return "PAM: portable arbitrary map file format";
    }

    public String getMIMEType() {
        return "image/x-portable-arbitrary-map";
    }

    public int getColorType() {
        return this.tupleReader.getColorType();
    }

    public int getRGB(WhiteSpaceReader wsr) throws IOException {
        throw new UnsupportedOperationException("PAM files are only ever binary");
    }

    public int getRGB(InputStream is) throws IOException {
        return this.tupleReader.getRGB(is);
    }

    private class ColorTupleReader
    extends TupleReader {
        private ColorTupleReader() {
        }

        public int getColorType() {
            return 2;
        }

        public int getRGB(InputStream is) throws IOException {
            int red = FileInfo.readSample(is, PamFileInfo.this.bytesPerSample);
            int green = FileInfo.readSample(is, PamFileInfo.this.bytesPerSample);
            int blue = FileInfo.readSample(is, PamFileInfo.this.bytesPerSample);
            red = FileInfo.scaleSample(red, PamFileInfo.this.scale, PamFileInfo.this.maxval);
            green = FileInfo.scaleSample(green, PamFileInfo.this.scale, PamFileInfo.this.maxval);
            blue = FileInfo.scaleSample(blue, PamFileInfo.this.scale, PamFileInfo.this.maxval);
            int alpha = 255;
            if (PamFileInfo.this.hasAlpha) {
                alpha = FileInfo.readSample(is, PamFileInfo.this.bytesPerSample);
                alpha = FileInfo.scaleSample(alpha, PamFileInfo.this.scale, PamFileInfo.this.maxval);
            }
            int rgb = (0xFF & alpha) << 24 | (0xFF & red) << 16 | (0xFF & green) << 8 | (0xFF & blue) << 0;
            return rgb;
        }
    }

    private class GrayscaleTupleReader
    extends TupleReader {
        private final int colorType;

        public GrayscaleTupleReader(int colorType) {
            this.colorType = colorType;
        }

        public int getColorType() {
            return this.colorType;
        }

        public int getRGB(InputStream is) throws IOException {
            int sample = FileInfo.readSample(is, PamFileInfo.this.bytesPerSample);
            sample = FileInfo.scaleSample(sample, PamFileInfo.this.scale, PamFileInfo.this.maxval);
            int alpha = 255;
            if (PamFileInfo.this.hasAlpha) {
                alpha = FileInfo.readSample(is, PamFileInfo.this.bytesPerSample);
                alpha = FileInfo.scaleSample(alpha, PamFileInfo.this.scale, PamFileInfo.this.maxval);
            }
            int rgb = (0xFF & alpha) << 24 | (0xFF & sample) << 16 | (0xFF & sample) << 8 | (0xFF & sample) << 0;
            return rgb;
        }
    }

    private abstract class TupleReader {
        private TupleReader() {
        }

        public abstract int getColorType();

        public abstract int getRGB(InputStream var1) throws IOException;
    }
}

