/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.palette.ColorComponent;
import org.apache.commons.imaging.palette.ColorCount;
import org.apache.commons.imaging.palette.ColorGroup;
import org.apache.commons.imaging.palette.ColorGroupCut;
import org.apache.commons.imaging.palette.MedianCutImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MedianCutLongestAxisImplementation
extends MedianCutImplementation {
    private static final Comparator<ColorGroup> comparator = new Comparator<ColorGroup>(){

        @Override
        public int compare(ColorGroup cg1, ColorGroup cg2) {
            if (cg1.max_diff == cg2.max_diff) {
                return cg2.diff_total - cg1.diff_total;
            }
            return cg2.max_diff - cg1.max_diff;
        }
    };

    @Override
    public boolean performNextMedianCut(List<ColorGroup> color_groups, boolean ignoreAlpha) throws ImageWriteException {
        Collections.sort(color_groups, comparator);
        ColorGroup color_group = color_groups.get(0);
        if (color_group.max_diff == 0) {
            return false;
        }
        if (!ignoreAlpha && color_group.alpha_diff > color_group.red_diff && color_group.alpha_diff > color_group.green_diff && color_group.alpha_diff > color_group.blue_diff) {
            this.doCut(color_group, ColorComponent.ALPHA, color_groups, ignoreAlpha);
        } else if (color_group.red_diff > color_group.green_diff && color_group.red_diff > color_group.blue_diff) {
            this.doCut(color_group, ColorComponent.RED, color_groups, ignoreAlpha);
        } else if (color_group.green_diff > color_group.blue_diff) {
            this.doCut(color_group, ColorComponent.GREEN, color_groups, ignoreAlpha);
        } else {
            this.doCut(color_group, ColorComponent.BLUE, color_groups, ignoreAlpha);
        }
        return true;
    }

    private void doCut(ColorGroup color_group, final ColorComponent mode, List<ColorGroup> color_groups, boolean ignoreAlpha) throws ImageWriteException {
        int limit;
        int median_index;
        Comparator<ColorCount> comparator = new Comparator<ColorCount>(){

            @Override
            public int compare(ColorCount c1, ColorCount c2) {
                switch (mode) {
                    case ALPHA: {
                        return c1.alpha - c2.alpha;
                    }
                    case RED: {
                        return c1.red - c2.red;
                    }
                    case GREEN: {
                        return c1.green - c2.green;
                    }
                    case BLUE: {
                        return c1.blue - c2.blue;
                    }
                }
                return 0;
            }
        };
        Collections.sort(color_group.color_counts, comparator);
        int count_half = (int)Math.round((double)color_group.totalPoints / 2.0);
        int old_count = 0;
        int new_count = 0;
        for (median_index = 0; median_index < color_group.color_counts.size(); ++median_index) {
            ColorCount color_count = color_group.color_counts.get(median_index);
            if ((new_count += color_count.count) >= count_half) break;
            old_count = new_count;
        }
        if (median_index == color_group.color_counts.size() - 1) {
            --median_index;
        } else if (median_index > 0) {
            int new_diff = Math.abs(new_count - count_half);
            int old_diff = Math.abs(count_half - old_count);
            if (old_diff < new_diff) {
                --median_index;
            }
        }
        color_groups.remove(color_group);
        ArrayList<ColorCount> color_counts1 = new ArrayList<ColorCount>(color_group.color_counts.subList(0, median_index + 1));
        ArrayList<ColorCount> color_counts2 = new ArrayList<ColorCount>(color_group.color_counts.subList(median_index + 1, color_group.color_counts.size()));
        ColorGroup less = new ColorGroup(new ArrayList<ColorCount>(color_counts1), ignoreAlpha);
        color_groups.add(less);
        ColorGroup more = new ColorGroup(new ArrayList<ColorCount>(color_counts2), ignoreAlpha);
        color_groups.add(more);
        ColorCount median_value = color_group.color_counts.get(median_index);
        switch (mode) {
            case ALPHA: {
                limit = median_value.alpha;
                break;
            }
            case RED: {
                limit = median_value.red;
                break;
            }
            case GREEN: {
                limit = median_value.green;
                break;
            }
            case BLUE: {
                limit = median_value.blue;
                break;
            }
            default: {
                throw new Error("Bad mode.");
            }
        }
        color_group.cut = new ColorGroupCut(less, more, mode, limit);
    }
}

