/*!
* A JavaScript implementation of the SHA256 hash function.
*
* FILE:	sha256.js
* VERSION:	0.8.1
* AUTHOR:	Christoph Bichlmeier <informatik@zombiearena.de>
*
* NOTE: This version is not tested thoroughly!
*
* Copyright (c) 2003, Christoph Bichlmeier
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1. Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
* 3. Neither the name of the copyright holder nor the names of contributors
*    may be used to endorse or promote products derived from this software
*    without specific prior written permission.
*
* ======================================================================
*
* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
* BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


*  Modified by NeptuneLabs 2009-2014 (transformed into a class)
*/
;function Sha256(){var self=this;var K256=new Array(1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298);var rotateRight=function(n,x){return((x>>>n)|(x<<(32-n)))};var choice=function(x,y,z){return((x&y)^(~x&z))};var majority=function(x,y,z){return((x&y)^(x&z)^(y&z))};var sha256_Sigma0=function(x){return(rotateRight(2,x)^rotateRight(13,x)^rotateRight(22,x))};var sha256_Sigma1=function(x){return(rotateRight(6,x)^rotateRight(11,x)^rotateRight(25,x))};var sha256_sigma0=function(x){return(rotateRight(7,x)^rotateRight(18,x)^(x>>>3))};var sha256_sigma1=function(x){return(rotateRight(17,x)^rotateRight(19,x)^(x>>>10))};var sha256_expand=function(W,j){return(W[j&15]+=sha256_sigma1(W[(j+14)&15])+W[(j+9)&15]+sha256_sigma0(W[(j+1)&15]))};var ihash,count,buffer;var sha256_hex_digits="0123456789abcdef";var safe_add=function(x,y){var lsw=(x&65535)+(y&65535);var msw=(x>>16)+(y>>16)+(lsw>>16);return(msw<<16)|(lsw&65535)};var sha256_init=function(){ihash=new Array(8);count=new Array(2);buffer=new Array(64);count[0]=count[1]=0;ihash[0]=1779033703;ihash[1]=3144134277;ihash[2]=1013904242;ihash[3]=2773480762;ihash[4]=1359893119;ihash[5]=2600822924;ihash[6]=528734635;ihash[7]=1541459225};var sha256_transform=function(){var a,b,c,d,e,f,g,h,T1,T2;var W=new Array(16);a=ihash[0];b=ihash[1];c=ihash[2];d=ihash[3];e=ihash[4];f=ihash[5];g=ihash[6];h=ihash[7];for(var i=0;i<16;i++){W[i]=((buffer[(i<<2)+3])|(buffer[(i<<2)+2]<<8)|(buffer[(i<<2)+1]<<16)|(buffer[i<<2]<<24))}for(var j=0;j<64;j++){T1=h+sha256_Sigma1(e)+choice(e,f,g)+K256[j];if(j<16){T1+=W[j]}else{T1+=sha256_expand(W,j)}T2=sha256_Sigma0(a)+majority(a,b,c);h=g;g=f;f=e;e=safe_add(d,T1);d=c;c=b;b=a;a=safe_add(T1,T2)}ihash[0]+=a;ihash[1]+=b;ihash[2]+=c;ihash[3]+=d;ihash[4]+=e;ihash[5]+=f;ihash[6]+=g;ihash[7]+=h};var sha256_update=function(data,inputLen){var i,index,curpos=0;index=((count[0]>>3)&63);var remainder=(inputLen&63);if((count[0]+=(inputLen<<3))<(inputLen<<3)){count[1]++}count[1]+=(inputLen>>29);for(i=0;i+63<inputLen;i+=64){for(var j=index;j<64;j++){buffer[j]=data.charCodeAt(curpos++)}sha256_transform();index=0}for(var j=0;j<remainder;j++){buffer[j]=data.charCodeAt(curpos++)}};var sha256_final=function(){var index=((count[0]>>3)&63);buffer[index++]=128;if(index<=56){for(var i=index;i<56;i++){buffer[i]=0}}else{for(var i=index;i<64;i++){buffer[i]=0}sha256_transform();for(var i=0;i<56;i++){buffer[i]=0}}buffer[56]=(count[1]>>>24)&255;buffer[57]=(count[1]>>>16)&255;buffer[58]=(count[1]>>>8)&255;buffer[59]=count[1]&255;buffer[60]=(count[0]>>>24)&255;buffer[61]=(count[0]>>>16)&255;buffer[62]=(count[0]>>>8)&255;buffer[63]=count[0]&255;sha256_transform()};var sha256_encode_bytes=function(){var j=0;var output=new Array(32);for(var i=0;i<8;i++){output[j++]=((ihash[i]>>>24)&255);output[j++]=((ihash[i]>>>16)&255);output[j++]=((ihash[i]>>>8)&255);output[j++]=(ihash[i]&255)}return output};var sha256_encode_hex=function(){var output=new String();for(var i=0;i<8;i++){for(var j=28;j>=0;j-=4){var z=ihash[i];output+=sha256_hex_digits.charAt((z>>>j)&15)}}return output};this.sha256_digest=function(data){sha256_init();sha256_update(data,data.length);sha256_final();return sha256_encode_hex()};this.sha256_self_test=function(){return self.sha256_digest("message digest")=="f7846f55cf23e14eebeab5b4e1550cad5b509e3348fbc4efa3a1413d393cb650"};this.utf16to8=function(str){var c;var out="";var len=str.length;for(var i=0;i<len;i++){c=str.charCodeAt(i);if((c>=1)&&(c<=127)){out+=str.charAt(i)}else{if(c>2047){out+=String.fromCharCode(224|((c>>12)&15));out+=String.fromCharCode(128|((c>>6)&63));out+=String.fromCharCode(128|((c>>0)&63))}else{out+=String.fromCharCode(192|((c>>6)&31));out+=String.fromCharCode(128|((c>>0)&63))}}}return out}};