/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.common.PackBits;
import org.apache.commons.imaging.common.mylzw.MyLzwCompressor;
import org.apache.commons.imaging.common.mylzw.MyLzwDecompressor;

public class Compression {
    public byte[] decompressLZW(byte[] compressed, int LZWMinimumCodeSize, int expectedSize, ByteOrder byteOrder) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(compressed);
        MyLzwDecompressor decompressor = new MyLzwDecompressor(LZWMinimumCodeSize, byteOrder);
        byte[] result = decompressor.decompress(is, expectedSize);
        return result;
    }

    public byte[] decompressPackBits(byte[] compressed, int expectedSize, ByteOrder byteOrder) throws ImageReadException {
        byte[] unpacked = new PackBits().decompress(compressed, expectedSize);
        return unpacked;
    }

    public byte[] compressLZW(byte[] src, int LZWMinimumCodeSize, ByteOrder byteOrder, boolean earlyLimit) throws IOException {
        MyLzwCompressor compressor = new MyLzwCompressor(LZWMinimumCodeSize, byteOrder, earlyLimit);
        byte[] compressed = compressor.compress(src);
        return compressed;
    }
}

