<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">

<#setting url_escaping_charset="UTF-8">

  <@tableHeader Heading="Groups" />

    <#assign entries_per_page = 10 />
    <#assign entrylist = groups /> 
    <#assign entry_prefix = "group" />
    <#include "/sub/pagination_js.ftl">

    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
        <td class="pad1" colspan="3">
        This list contains all currently configured groups including the system groups "users" and "public". 
        <#if externalusermanagement >
          The users and groups on this FSI Server are managed using an external directory server and can not be modified here. 
        <#else>
          New groups should preferably be created choosing "New Account" from the 
          left menu. Manually adding new groups here is only recommended of advanced users.<br />
        </#if>
        </td>
      </tr>  
      <tr>
        <td class="sectionheader" style="width: 290px;">Groupname</td>
        <td class="sectionheader" style="width: 100px;">Users</td>
        <td class="sectionheader" style="width: 100px;">&nbsp;</td>
      </tr>
      <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
      <tr>
	   <td class="pad1" colspan="3">
      <#assign i = 0>
      <#list groups?keys?sort as groupname>
        <#assign i = i + 1>
        <div id="group${i}" style="clear: both; <#if (i > entries_per_page)>display: none;</#if>">
	       <div style="width: 290px; height: 26px; float: left;"><span style="line-height: 26px">${groupname}</span></div>
	       <div style="width: 100px; height: 26px; float: left;"><span style="line-height: 26px"><#if groups[groupname].users?? >${groups[groupname].users?size}</#if></span></div>
	       <#if !externalusermanagement>
	       <div style="width: 78px; height: 26px; float:right; text-align: right;">
	       <div style="width: 26px; height: 26px; float: left; text-align: right;">
	        <a href="pt.do?<@printRequiredParams method="get" />action=editgroup&groupname=${groupname?url}"><img onmouseout="spanup(this);" onmouseup="spanup(this);" onmousedown="spandown(this);" onmouseover="spanhover(this);" class="btnwhite" title="Edit Group" alt="Edit Group" src="images/apps/app22/edit_profile.png" id="app1iconic" <#if i==1>help="<@appID/>:groups_edit"</#if> /></a>
	       </div>
	       <div style="width: 26px; height: 26px; float: left; text-align: right;">
	        <a href="pt.do?<@printRequiredParams method="get" />action=copygroup&name=${groupname?url}"><img onmouseout="spanup(this);" onmouseup="spanup(this);" onmousedown="spandown(this);" onmouseover="spanhover(this);" class="btnwhite" title="Copy Group" alt="Copy Group" src="images/apps/app22/copy_profile.png" id="app1iconic" <#if i==1>help="<@appID/>:groups_copy"</#if> /></a>
	       </div>
	       <div style="width: 26px; height: 26px; float: left; text-align: right;">
	        <#if groupname != "authenticated" && groupname != "public" && groupname != "administrators">
	        <a href="pt.do?<@printRequiredParams method="get" />action=deletegroup&name=${groupname?url}"><img onmouseout="spanup(this);" onmouseup="spanup(this);" onmousedown="spandown(this);" onmouseover="spanhover(this);" class="btnwhite" title="Delete Group" alt="Delete Group" src="images/apps/app22/delete_profile.png" id="app1iconic" <#if i==1>help="<@appID/>:groups_delete"</#if> /></a>
	        <#else> 
	        &nbsp;
            </#if>
           </div>
           </div>
           </#if>
        </div>
	  </#list>
	  <#-- fill last page with empty rows -->
	  <#list (i+1)..total_rows as row>
	      <div id="group${row}" style="clear: both; <#if (i > entries_per_page)>display: none;</#if>">
	       <div style="width: 290px; height: 26px; float: left;"><span style="line-height: 26px">&nbsp;</span></div>
	       <div style="width: 125px; height: 26px; float: left;"><span style="line-height: 26px">&nbsp;</span></div>
	       <div style="width: 72px; height: 26px; float: left; text-align: right;"></div>
	      </div>
	  </#list>
	   </td>
	  </tr>
	  
	  <tr>
        <td class="pad1" style="text-align: center; padding-bottom: 5px;" colspan="3">
          <#include "/sub/pagination_buttons.ftl">
        </td>
      </tr>
	  
	  <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
      <tr>
        <td class="sectionfooter">Page <span id="pagenumber">1</span> of ${last_page}</td>
        <td class="pad1" colspan="2" align="right">
          <form action="pt.do" method="post"  onsubmit="this.submit();">
      	  <@printRequiredParams method="post" />
      	  <input type="hidden" name="action" value="addgroup" />
      	  <@formsubmit value="Add Group" helpid="groups_add" />
          </form>          
        </td>
      </tr>
    </table>
    <#include "/sub/pagination_init.ftl">
    <@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">