/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.formats.png.BitParser;
import org.apache.commons.imaging.formats.png.GammaCorrection;
import org.apache.commons.imaging.formats.png.ScanExpediter;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPlte;
import org.apache.commons.imaging.formats.png.transparencyfilters.TransparencyFilter;

public class ScanExpediterInterlaced
extends ScanExpediter {
    private static final int[] Starting_Row = new int[]{0, 0, 4, 0, 2, 0, 1};
    private static final int[] Starting_Col = new int[]{0, 4, 0, 2, 0, 1, 0};
    private static final int[] Row_Increment = new int[]{8, 8, 8, 4, 4, 2, 2};
    private static final int[] Col_Increment = new int[]{8, 8, 4, 4, 2, 2, 1};

    public ScanExpediterInterlaced(int width, int height, InputStream is, BufferedImage bi, int color_type, int BitDepth, int bits_per_pixel, PngChunkPlte fPNGChunkPLTE, GammaCorrection fGammaCorrection, TransparencyFilter fTransparencyFilter) {
        super(width, height, is, bi, color_type, BitDepth, bits_per_pixel, fPNGChunkPLTE, fGammaCorrection, fTransparencyFilter);
    }

    private void visit(int x, int y, BufferedImage bi, BitParser fBitParser, int color_type, int pixel_index_in_scanline, PngChunkPlte fPNGChunkPLTE, GammaCorrection fGammaCorrection) throws ImageReadException, IOException {
        int rgb = this.getRGB(fBitParser, pixel_index_in_scanline);
        bi.setRGB(x, y, rgb);
    }

    public void drive() throws ImageReadException, IOException {
        for (int pass = 1; pass <= 7; ++pass) {
            byte[] prev = null;
            for (int y = Starting_Row[pass - 1]; y < this.height; y += Row_Increment[pass - 1]) {
                byte[] unfiltered;
                int x = Starting_Col[pass - 1];
                int pixel_index_in_scanline = 0;
                if (x >= this.width) continue;
                int ColumnsInRow = 1 + (this.width - Starting_Col[pass - 1] - 1) / Col_Increment[pass - 1];
                int bitsPerScanLine = this.bitsPerPixel * ColumnsInRow;
                int pixel_bytes_per_scan_line = this.getBitsToBytesRoundingUp(bitsPerScanLine);
                prev = unfiltered = this.getNextScanline(this.is, pixel_bytes_per_scan_line, prev, this.bytesPerPixel);
                BitParser fBitParser = new BitParser(unfiltered, this.bitsPerPixel, this.bitDepth);
                while (x < this.width) {
                    this.visit(x, y, this.bi, fBitParser, this.colorType, pixel_index_in_scanline, this.pngChunkPLTE, this.gammaCorrection);
                    x += Col_Increment[pass - 1];
                    ++pixel_index_in_scanline;
                }
            }
        }
    }
}

