/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.palette;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.palette.ColorCount;
import org.apache.commons.imaging.palette.ColorGroup;
import org.apache.commons.imaging.palette.MedianCutImplementation;
import org.apache.commons.imaging.palette.MedianCutPalette;
import org.apache.commons.imaging.palette.Palette;
import org.apache.commons.imaging.palette.SimplePalette;
import org.apache.commons.imaging.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MedianCutQuantizer {
    private final boolean ignoreAlpha;

    public MedianCutQuantizer(boolean ignore_alpha) {
        this.ignoreAlpha = ignore_alpha;
    }

    private Map<Integer, ColorCount> groupColors1(BufferedImage image, int max, int mask) {
        HashMap<Integer, ColorCount> color_map = new HashMap<Integer, ColorCount>();
        int width = image.getWidth();
        int height = image.getHeight();
        int[] row = new int[width];
        for (int y = 0; y < height; ++y) {
            image.getRGB(0, y, width, 1, row, 0, width);
            for (int x = 0; x < width; ++x) {
                ColorCount color;
                int argb = row[x];
                if (this.ignoreAlpha) {
                    argb &= 0xFFFFFF;
                }
                if ((color = (ColorCount)color_map.get(argb &= mask)) == null) {
                    color = new ColorCount(argb);
                    color_map.put(argb, color);
                    if (color_map.keySet().size() > max) {
                        return null;
                    }
                }
                ++color.count;
            }
        }
        return color_map;
    }

    public Map<Integer, ColorCount> groupColors(BufferedImage image, int max_colors) {
        int max = Integer.MAX_VALUE;
        for (int i = 0; i < 8; ++i) {
            int mask = 0xFF & 255 << i;
            mask = mask | mask << 8 | mask << 16 | mask << 24;
            Debug.debug("mask(" + i + ")", mask + " (" + Integer.toHexString(mask) + ")");
            Map<Integer, ColorCount> result = this.groupColors1(image, Integer.MAX_VALUE, mask);
            if (result == null) continue;
            return result;
        }
        throw new Error("");
    }

    public Palette process(BufferedImage image, int max_colors, MedianCutImplementation medianCutImplementation, boolean verbose) throws ImageWriteException {
        Map<Integer, ColorCount> color_map = this.groupColors(image, max_colors);
        int discrete_colors = color_map.keySet().size();
        if (discrete_colors <= max_colors) {
            if (verbose) {
                Debug.debug("lossless palette: " + discrete_colors);
            }
            int[] palette = new int[discrete_colors];
            ArrayList<ColorCount> color_counts = new ArrayList<ColorCount>(color_map.values());
            for (int i = 0; i < color_counts.size(); ++i) {
                ColorCount color_count = (ColorCount)color_counts.get(i);
                palette[i] = color_count.argb;
                if (!this.ignoreAlpha) continue;
                int n = i;
                palette[n] = palette[n] | 0xFF000000;
            }
            return new SimplePalette(palette);
        }
        if (verbose) {
            Debug.debug("discrete colors: " + discrete_colors);
        }
        ArrayList<ColorGroup> color_groups = new ArrayList<ColorGroup>();
        ColorGroup root = new ColorGroup(new ArrayList<ColorCount>(color_map.values()), this.ignoreAlpha);
        color_groups.add(root);
        while (color_groups.size() < max_colors && medianCutImplementation.performNextMedianCut(color_groups, this.ignoreAlpha)) {
        }
        int palette_size = color_groups.size();
        if (verbose) {
            Debug.debug("palette size: " + palette_size);
        }
        int[] palette = new int[palette_size];
        int i = 0;
        while (i < color_groups.size()) {
            ColorGroup color_group = (ColorGroup)color_groups.get(i);
            palette[i] = color_group.getMedianValue();
            color_group.palette_index = i++;
            if (color_group.color_counts.size() >= 1) continue;
            throw new ImageWriteException("empty color_group: " + color_group);
        }
        if (palette_size > discrete_colors) {
            throw new ImageWriteException("palette_size>discrete_colors");
        }
        return new MedianCutPalette(root, palette);
    }
}

