<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">

  <@tableHeader Heading="Edit Renderer" />

  <#if show_form?? >


    <form action="pt.do" method="post" onsubmit="this.submit();">
     <@printRequiredParams method="post" />
     <input type="hidden" name="action" value="editrenderer">
     <input type="hidden" name="confirmed" value="1">
     <input type="hidden" name="renderername" value="${renderername}">
      
     <table cellspacing="0" cellpadding="0" style="border: 0px; width: 700px;">
      <tr>
        <td class="pad1" colspan="4">
         <#if message??>
          ${message}
         <#else>
          Edit the renderer settings and use the save button at the end of the page to save the changes made. 
          The cancel button will discard all changes. 
         </#if>
        </td>
      </tr>
      <tr>
	    <td class="sectionheader" colspan="4">General Settings</td>
	  </tr>
	  <tr><td colspan="4"><hr size="1" class="hr1"/></td></tr>
	  <tr>
        <td class="pad1">Renderer Name:</td>
        <td class="pad1">
      	  <input type="text" class="inwhitedis" id="renderername" name="renderername" <#if renderername??>value="${renderername}"</#if>  readonly help="<@appID/>:renderer_name" />
        </td>
        <td class="pad1">Enabled:</td>
        <td class="pad1">
          <@formcheckbox objid="enabled" preselect=enabled helpid="renderer_enabled" /> 
        </td>
      </tr>
      <tr>
	    <td class="sectionheader" colspan="2">Image Renderer</td>
	    <td class="sectionheader" colspan="2">Options</td>
	  </tr>
	  <tr><td colspan="4"><hr size="1" class="hr1"/></td></tr>
	  <tr>
        <td class="pad1">Implementation:</td>
        <td class="pad1">
        	<input type="text" class="inwhite" id="img_rend_impl" name="img_rend_impl" value="<#if img_rend_impl??>${img_rend_impl}"<#else>default</#if>" help="<@appID/>:renderer_image_renderer_implementation">
        </td>
        <#assign optionkeys = imagerendereroptions?keys?sort>
        <#list optionkeys as key>
          <td class="pad1">${key}:</td>
          <td class="pad1">
      	    <input type="text" class="inwhite" id="imagerendereroption.${key}" name="imagerendereroption.${key}" value="<#if imagerendereroptions[key]??>${imagerendereroptions[key]}</#if>">
          </td>
        </tr>
        <tr>
          <td class="pad1" colspan="2"></td>
        </#list>
      </tr>
      
      <tr>
	    <td class="sectionheader" colspan="2">Directory Image Renderer</td>
	    <td class="sectionheader" colspan="2">Options</td>
	  </tr>
	  <tr><td colspan="4"><hr size="1" class="hr1"/></td></tr>
	  <tr>
        <td class="pad1">Implementation:</td>
        <td class="pad1">
        	<input type="text" class="inwhite" id="dirimg_rend_impl" name="dirimg_rend_impl" value="<#if dirimg_rend_impl??>${dirimg_rend_impl}"<#else>default</#if>" help="<@appID/>:renderer_directory_image_renderer_implementation">
        </td>
        <#assign optionkeys = dirimagerendereroptions?keys?sort>
        <#list optionkeys as key>
          <td class="pad1">${key}:</td>
          <td class="pad1">
      	    <input type="text" class="inwhite" id="dirimagerendereroption.${key}" name="dirimagerendereroption.${key}" value="<#if dirimagerendereroptions[key]??>${dirimagerendereroptions[key]}</#if>">
          </td>
        </tr>
        <tr>
          <td class="pad1" colspan="2"></td>
        </#list>
      </tr>
      
      <tr>
	    <td class="sectionheader" colspan="2">Info Renderer</td>
	    <td class="sectionheader" colspan="2">Options</td>
	  </tr>
	  <tr><td colspan="4"><hr size="1" class="hr1"/></td></tr>
      <tr>
        <td class="pad1">Implementation:</td>
        <td class="pad1">
        	<input type="text" class="inwhite" id="inf_rend_impl" name="inf_rend_impl" value="<#if inf_rend_impl??>${inf_rend_impl}"<#else>default</#if>" help="<@appID/>:renderer_info_renderer_implementation">
        </td>
        <#assign optionkeys = inforendereroptions?keys?sort />
        <#list optionkeys as key>
          <td class="pad1">${key}:</td>
          <td class="pad1">
      	    <input type="text" class="inwhite" id="inforendereroption.${key}" name="inforendereroption.${key}" value="<#if inforendereroptions[key]??>${inforendereroptions[key]}</#if>">
          </td>
        </tr>
        <tr>
          <td class="pad1" colspan="2"></td>
        </#list>
      </tr>
      <tr>
	    <td class="sectionheader" colspan="2">List Renderer</td>
	    <td class="sectionheader" colspan="2">Options</td>
	  </tr>
	  <tr><td colspan="4"><hr size="1" class="hr1"/></td></tr>
	  <tr>
        <td class="pad1">Implementation:</td>
        <td class="pad1">
        	<input type="text" class="inwhite" id="lst_rend_impl" name="lst_rend_impl" value="<#if inf_rend_impl??>${lst_rend_impl}"<#else>default</#if>" help="<@appID/>:renderer_list_renderer_implementation">
        </td>
        <#assign optionkeys = listrendereroptions?keys?sort />
        <#list optionkeys as key>
          <td class="pad1">${key}:</td>
          <td class="pad1">
      	    <input type="text" class="inwhite" id="listrendereroption.${key}" name="listrendereroption.${key}" value="<#if listrendereroptions[key]??>${listrendereroptions[key]}</#if>">
          </td>
        </tr>
        <tr>
          <td class="pad1" colspan="2"></td>
        </#list>
      </tr>
      <tr>
	    <td class="sectionheader" colspan="4">Output Effects</td>
	  </tr>
	  <tr><td colspan="4"><hr size="1" class="hr1"/></td></tr>
      
	  <tr>
	    <td class="pad1">Effects:</td>
	    <td class="pad1" colspan="3">
	      <input type="text" class="inwhite" id="effect" name="effect" <#if effect??>value="${effect}"</#if> help="<@appID/>:renderer_effects">
	    </td>
	  </tr>
	  <tr>
	    <td class="sectionheader" colspan="4">Output Format</td>
	  </tr>
	  <tr><td colspan="4"><hr size="1" class="hr1"/></td></tr>
      <tr>
        <td class="pad1">Default output format:</td>
        <td class="pad1"><@formgfxselect objid="format" itemlist=available_formats preselect=format helpid="renderer_format" /></td>
      </tr>
      
      
      <tr>
	    <td class="pad1" colspan="4">
	    <table width="100%">
	      <tr>
	        <td class="pad1" style="font-weight: bold">Parameter</td>
	        <td class="pad1" style="font-weight: bold">Applies to</td>
	        <td class="pad1" style="font-weight: bold">Value</td>
	      </tr>
	      
	      <tr>
	        <td class="pad1">Output Quality</td>
	        <td class="pad1"><span style="font-size: 8pt">jpeg, swf</span></td>
	        <td class="pad1">
	          <input type="text" class="inwhite" maxlength="10" id="quality" name="quality" <#if quality??>value="${quality}"</#if> help="<@appID/>:renderer_quality">
	        </td>
	      </tr>
	      
	      <tr>
	        <td class="pad1">Chroma Subsampling</td>
	        <td class="pad1"><span style="font-size: 8pt">jpeg, swf</span></td>
	        <td class="pad1"><@formgfxselect objid="chromasubsampling" itemlist=available_chromasubsamplings preselect=chromasubsampling helpid="renderer_chromasubsampling" /></td>
	      </tr>
	      
	      <tr>
	        <td class="pad1">DPI</td>
	        <td class="pad1"><span style="font-size: 8pt">jpeg, png</span></td>
	        <td class="pad1">
	          <input type="text" class="inwhite" maxlength="10" id="dpi" name="dpi" value="${dpi}" help="<@appID/>:renderer_dpi"> 
	        </td>
	      </tr>
	      
	      <tr>
	        <td class="pad1">Encoding</td>
	        <td class="pad1"><span style="font-size: 8pt">jpeg, png</span></td>
	        <td class="pad1"><@formgfxselect objid="encoding" itemlist=available_encodings preselect=encoding helpid="renderer_encoding" /></td>
	        </td>
	      </tr>
	      
	      <tr>
	        <td class="pad1">Embed ICC</td>
	        <td class="pad1"><span style="font-size: 8pt">jpeg, png</span></td>
	        <td class="pad1">
	          <@formcheckbox objid="embedicc" preselect=embedicc?string helpid="renderer_embedicc" />
	        </td>
	      </tr>
	      
	      <tr>
	        <td class="pad1">Loop</td>
	        <td class="pad1"><span style="font-size: 8pt">animated gif</span></td>
	        <td class="pad1">
	          <input type="text" class="inwhite" maxlength="10" id="loop" name="loop" <#if loop??>value="${loop}"</#if> help="<@appID/>:renderer_loop">
	        </td>
		  </tr>
		  
		  <tr>
	        <td class="pad1">Delay</td>
	        <td class="pad1"><span style="font-size: 8pt">animated gif</span></td>
	        <td class="pad1">
	          <input type="text" class="inwhite" maxlength="10" id="delay" name="delay" <#if delay??>value="${delay}"</#if> help="<@appID/>:renderer_delay">
	        </td>
	      </tr>
		  
		  <tr>
	        <td class="pad1">Background Color</td>
	        <td class="pad1"><span style="font-size: 8pt">png, gif</span></td>
	        <td class="pad1">
	          <input type="text" class="inwhite" maxlength="10" id="backgroundcolor" name="backgroundcolor" <#if backgroundcolor??>value="${backgroundcolor}"</#if> help="<@appID/>:renderer_backgroundcolor">
	        </td>
	      </tr>
	      <tr>
	        <td class="pad1">Compression Level</td>
	        <td class="pad1"><span style="font-size: 8pt">png</span></td>
	        <td class="pad1"><@formgfxselect objid="compressionlevel" itemlist=available_compressionlevels preselect=compressionlevel helpid="renderer_compressionlevel" /></td>
	      </tr>
		  
		  <tr>
	        <td class="pad1">Compression Filter</td>
	        <td class="pad1"><span style="font-size: 8pt">png</span></td>
	        <td class="pad1"><@formgfxselect objid="compressionfilter" itemlist=available_compressionfilters preselect=compressionfilter helpid="renderer_compressionfilter" /></td>
	      </tr>
	      <tr>
	        <td class="pad1">Ditherer</td>
	        <td class="pad1"><span style="font-size: 8pt">gif</span></td>
	        <td class="pad1"><@formgfxselect objid="ditherer" itemlist=available_ditherers preselect=ditherer helpid="renderer_ditherer" /></td>
	      </tr>
		  
		  <tr>
	        <td class="pad1">Colorspace</td>
	        <td class="pad1"><span style="font-size: 8pt">png</span></td>
	        <td class="pad1"><@formgfxselect objid="colorspace" itemlist=available_colorspaces preselect=colorspace helpid="renderer_colorspace" /></td>
	      </tr>
	      <tr>
	        <td class="pad1">Quantizer</td>
	        <td class="pad1"><span style="font-size: 8pt">png, gif</span></td>
	        <td class="pad1"><@formgfxselect objid="quantizer" itemlist=available_quantizers preselect=quantizer helpid="renderer_quantizer" /></td>
	      </tr>
		  
		  <tr>
	        <td class="pad1">Quantizer Sample Depth</td>
	        <td class="pad1"><span style="font-size: 8pt">png, gif</span></td>
	        <td class="pad1">
	          <input type="text" class="inwhite" maxlength="10" id="quantizersampledepth" name="quantizersampledepth" <#if quantizersampledepth??>value="${quantizersampledepth}"</#if> help="<@appID/>:renderer_quantizersampledepth">
	        </td>
	      </tr>
	      <tr>
	        <td class="pad1">Frame Palette</td>
	        <td class="pad1"><span style="font-size: 8pt">aminated gif</span></td>
	        <td class="pad1">
	          <@formcheckbox objid="framepalette" preselect=framepalette?string helpid="renderer_framepalette" />
	        </td>
	      </tr>
		  
		  <tr>
	        <td class="pad1">Max. Colors</td>
	        <td class="pad1"><span style="font-size: 8pt">png, gif</span></td>
	        <td class="pad1">
	          <input type="text" class="inwhite" maxlength="10" id="maxcolors" name="maxcolors" <#if maxcolors??>value="${maxcolors}"</#if> help="<@appID/>:renderer_maxcolors">
	        </td>
		  </tr>
		  <tr>
		    <td class="pad1">Huffman Optimization</td>
		    <td class="pad1"><span style="font-size: 8pt">jpeg, swf</span></td>
	        <td class="pad1" colspan="2">
	          <@formcheckbox objid="optimizehuffman" preselect=optimizehuffman?string helpid="renderer_optimizehuffman" />
	        </td>
		  </tr>
		</table>
	    </td>	      
	  </tr>
      <tr>
        <td class="pad1" colspan="4" align="right">
          <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>	
          <@formsubmit value="Save" />
        </td>
      </tr>
      </table>
    </form>

  <#elseif show_confirmation?? >
    
    
    Renderer changes saved. Please wait while the renderers are re-read for the changes to take effect.<br /><br />
    
    <#assign timeout="5" />
    <#assign postprogresslocation="action=listrenderer">
    <#include "/sub/progressbar.ftl">
    
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">