/*!
 * FSI Server Interface
 * http://www.fsi-viewer.com
 *
 * Copyright (C) 2000-2016 NeptuneLabs GmbH - All rights reserved.
 *
 * Version: 3.0.0
 */
;function Translator(){var self=this;var language;var translation;var bNoLanguageErrorShown=false;this.setNeLAjax=function(na){nelajax=na};this.loadLanguage=function(lang){language=lang;var url=utils.getInterfaceVersionPath()+"languages/"+language.file+".json";var respObj=nelajax.GETTextSync(url,null);if(respObj&&respObj.status==200){try{translation=JSON.parse(respObj.response)}catch(ev){alert("Error parsing language file "+name+"\n"+ev.message+" in line: "+ev.lineNumber+" file:"+ev.fileName)}}else{alert("Error loading language: "+url)}};this.translateText=function(text,componentName){if(translation){var errorVars="";var errorTransKeys="";var transList={};if(translation.components[componentName]){var comTrans=translation.components[componentName];var langVars=text.match(/\%[a-zA-Z0-9]+?\%/g);if(langVars){for(var i=0;i<langVars.length;i++){var cutVar=langVars[i].substring(1,langVars[i].length-1);if(comTrans[cutVar]){transList[cutVar]=true}else{errorVars+=cutVar+"\n"}}if(errorVars!=""){alert("Unknown Translation patterns in components "+componentName+"\n--------\n"+errorVars)}for(var tKey in comTrans){if(!transList[tKey]){errorTransKeys+=tKey+"\n"}}if(transList){for(var varKey in transList){try{var regex=new RegExp("%"+varKey+"%","g");text=text.replace(regex,comTrans[varKey])}catch(ev){alert("error translateText: "+ev.message)}}}}}else{var langVars=text.match(/\%(.+)\%/g);if(langVars){alert("Translation section "+componentName+" missing in "+language.file+" file")}}}else{if(!bNoLanguageErrorShown){alert("No language loaded");bNoLanguageErrorShown=true}}return text};this.translateTextValue=function(keyGroup,key,bGraceFully){if(translation[keyGroup]&&translation[keyGroup][key]){return translation[keyGroup][key]}else{if(!bGraceFully){alert("Unknown Language Key: "+key+" in group "+keyGroup)}else{return key}}};this.translateComponentTextValue=function(rootGroup,keyGroup,key,bGraceFully){if(translation[rootGroup]&&translation[rootGroup][keyGroup]&&translation[rootGroup][keyGroup][key]){return translation[rootGroup][keyGroup][key]}else{if(!bGraceFully){alert("Unknown Language Key: "+key+" in group "+keyGroup)}else{return key}}};this.translateScriptText=function(key,bGraceFully){if(translation.script&&translation.script[key]){return translation.script[key]}else{if(!bGraceFully){alert("Unknown Script Language Key: "+key+" "+translation.script)}else{return key}}};this.translateInternalText=function(key){if(translation.internal&&translation.internal[key]){return translation.internal[key]}else{alert("Unknown Script Language Key: "+key+" "+translation.script)}};this.translateHTTPError=function(HTTPStatus,details){var msg=self.translateTextValue("dialogErrors","HTTP"+HTTPStatus,true);if(msg=="HTTP"+HTTPStatus){msg=self.translateTextValue("fileupload","httpError",true).replace(/\[\.\.\.\]/,HTTPStatus)}if(details!=undefined){msg+=" <br/>"+details.replace(/\n/,"<br/>")}return msg};this.formatLocaleShortDate=function(dateObj){if(language.shortDateFormat){var rawStr=language.shortDateFormat;var halfHourPart="AM";var halfHours=dateObj.getHours();if(halfHours>12){halfHours-=12;var halfHourPart="PM"}var month=dateObj.getMonth()+1;if(month<10){month="0"+month}var date=dateObj.getDate();if(date<10){date="0"+date}var hours=dateObj.getHours();if(hours<10){hours="0"+hours}if(halfHours<10){halfHours="0"+halfHours}var minutes=dateObj.getMinutes();if(minutes<10){minutes="0"+minutes}var seconds=dateObj.getSeconds();if(seconds<10){seconds="0"+seconds}rawStr=rawStr.replace(/%n/g,month);rawStr=rawStr.replace(/%j/g,date);rawStr=rawStr.replace(/%Y/g,dateObj.getFullYear());rawStr=rawStr.replace(/%h/g,halfHours);rawStr=rawStr.replace(/%H/g,hours);rawStr=rawStr.replace(/%A/g,halfHourPart);rawStr=rawStr.replace(/%i/g,minutes);rawStr=rawStr.replace(/%s/g,seconds);return rawStr}};this.formatLocaleDate=function(dateObj){if(language.dateFormat){var rawStr=language.dateFormat;var weekdays=self.translateInternalText("Weekday");var months=self.translateInternalText("Month");var halfHourPart="AM";var halfHours=dateObj.getHours();if(halfHours>12){halfHours-=12;var halfHourPart="PM"}var hours=dateObj.getHours();if(hours<10){hours="0"+hours}var minutes=dateObj.getMinutes();if(minutes<10){minutes="0"+minutes}var seconds=dateObj.getSeconds();if(seconds<10){seconds="0"+seconds}rawStr=rawStr.replace(/%l/g,weekdays[dateObj.getDay()]);rawStr=rawStr.replace(/%F/g,months[dateObj.getMonth()+1]);rawStr=rawStr.replace(/%n/g,dateObj.getMonth()+1);rawStr=rawStr.replace(/%j/g,dateObj.getDate());rawStr=rawStr.replace(/%Y/g,dateObj.getFullYear());rawStr=rawStr.replace(/%h/g,halfHours);rawStr=rawStr.replace(/%H/g,hours);rawStr=rawStr.replace(/%A/g,halfHourPart);rawStr=rawStr.replace(/%i/g,minutes);rawStr=rawStr.replace(/%s/g,seconds);return rawStr}};this.formatLocaleDuration=function(lMs){var lRest;if(lMs>0){var strDays="";var strHours="";var strMinutes="";var strSeconds="";strDays=Math.floor(lMs/86400000);lRest=lMs%86400000;strHours=Math.floor(lRest/3600000);lRest%=3600000;strMinutes=Math.floor(lRest/60000);lRest%=60000;strSeconds=Math.ceil(lRest/1000);if(strHours<10){strHours="0"+strHours}if(strMinutes<10){strMinutes="0"+strMinutes}if(strSeconds<10){strSeconds="0"+strSeconds}var ret=strHours+":"+strMinutes+":"+strSeconds+" h";if(strDays!=0){ret=strDays+"d "+ret}return ret}else{if(lMs==0){return"0ms"}else{return"-1"}}};this.getShortDateOnlyFormat=function(){return language.shortDateOnlyFormat};this.getDayNames=function(bShort){var bCut=false;var t;if(bShort){t=translation.internal.MinWeekday;if(t==undefined){bCut=true}}if(t==undefined){t=translation.internal.Weekday}if(t==undefined){return}var ar=[];if(bCut){for(var o in t){ar.push(t[o].substr(0,2))}}else{for(var o in t){ar.push(t[o])}}return ar};this.getMonthNames=function(){var t=translation.internal.Month;if(t==undefined){return}var ar=[];for(var o in t){ar.push(t[o])}return ar}};