/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.formats.pnm.PnmConstants;
import org.apache.commons.imaging.formats.pnm.PnmWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PgmWriter
extends PnmWriter
implements PnmConstants {
    public PgmWriter(boolean RAWBITS) {
        super(RAWBITS);
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, Map<String, Object> params) throws ImageWriteException, IOException {
        os.write(80);
        os.write(this.RAWBITS ? 53 : 50);
        os.write(32);
        int width = src.getWidth();
        int height = src.getHeight();
        os.write(("" + width).getBytes("US-ASCII"));
        os.write(32);
        os.write(("" + height).getBytes("US-ASCII"));
        os.write(32);
        os.write("255".getBytes("US-ASCII"));
        os.write(10);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = src.getRGB(x, y);
                int red = 0xFF & argb >> 16;
                int green = 0xFF & argb >> 8;
                int blue = 0xFF & argb >> 0;
                int sample = (red + green + blue) / 3;
                if (this.RAWBITS) {
                    os.write((byte)sample);
                    continue;
                }
                os.write(("" + sample).getBytes("US-ASCII"));
                os.write(32);
            }
        }
    }
}

