/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.psd.datareaders;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.common.mylzw.BitsToByteInputStream;
import org.apache.commons.imaging.common.mylzw.MyBitInputStream;
import org.apache.commons.imaging.formats.psd.ImageContents;
import org.apache.commons.imaging.formats.psd.PsdHeaderInfo;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParser;
import org.apache.commons.imaging.formats.psd.datareaders.DataReader;

public class UncompressedDataReader
extends DataReader {
    public UncompressedDataReader(DataParser fDataParser) {
        super(fDataParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readData(InputStream is, BufferedImage bi, ImageContents imageContents, BinaryFileParser bfp) throws ImageReadException, IOException {
        PsdHeaderInfo header = imageContents.header;
        int width = header.Columns;
        int height = header.Rows;
        bfp.setDebug(false);
        int channel_count = this.dataParser.getBasicChannelsCount();
        int depth = header.Depth;
        MyBitInputStream mbis = new MyBitInputStream(is, ByteOrder.MOTOROLA);
        BitsToByteInputStream bbis = null;
        try {
            bbis = new BitsToByteInputStream(mbis, 8);
            int[][][] data = new int[channel_count][height][width];
            for (int channel = 0; channel < channel_count; ++channel) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int b = bbis.readBits(depth);
                        data[channel][y][x] = (byte)b;
                    }
                }
            }
            this.dataParser.parseData(data, bi, imageContents);
        }
        finally {
            if (bbis != null) {
                bbis.close();
            }
        }
    }
}

