/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffElement;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffHeader;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiffContents {
    public final TiffHeader header;
    public final List<TiffDirectory> directories;

    public TiffContents(TiffHeader tiffHeader, List<TiffDirectory> directories) {
        this.header = tiffHeader;
        this.directories = directories;
    }

    public List<TiffElement> getElements() throws ImageReadException {
        ArrayList<TiffElement> result = new ArrayList<TiffElement>();
        result.add(this.header);
        for (int i = 0; i < this.directories.size(); ++i) {
            TiffDirectory directory = this.directories.get(i);
            result.add(directory);
            List<TiffField> fields = directory.entries;
            for (int j = 0; j < fields.size(); ++j) {
                TiffField field = fields.get(j);
                TiffElement oversizeValue = field.getOversizeValueElement();
                if (null == oversizeValue) continue;
                result.add(oversizeValue);
            }
            if (directory.hasTiffImageData()) {
                result.addAll(directory.getTiffRawImageDataElements());
            }
            if (!directory.hasJpegImageData()) continue;
            result.add(directory.getJpegRawImageDataElement());
        }
        return result;
    }

    public TiffField findField(TagInfo tag) throws ImageReadException {
        for (int i = 0; i < this.directories.size(); ++i) {
            TiffDirectory directory = this.directories.get(i);
            TiffField field = directory.findField(tag);
            if (null == field) continue;
            return field;
        }
        return null;
    }

    public void dissect(boolean verbose) throws ImageReadException {
        List<TiffElement> elements = this.getElements();
        Collections.sort(elements, TiffElement.COMPARATOR);
        long lastEnd = 0L;
        for (int i = 0; i < elements.size(); ++i) {
            String verbosity;
            TiffElement element = elements.get(i);
            if (element.offset > lastEnd) {
                Debug.debug("\tgap: " + (element.offset - lastEnd));
            }
            if (element.offset < lastEnd) {
                Debug.debug("\toverlap");
            }
            Debug.debug("element, start: " + element.offset + ", length: " + element.length + ", end: " + (element.offset + (long)element.length) + ": " + element.getElementDescription(false));
            if (verbose && null != (verbosity = element.getElementDescription(true))) {
                Debug.debug(verbosity);
            }
            lastEnd = element.offset + (long)element.length;
        }
        Debug.debug("end: " + lastEnd);
        Debug.debug();
    }
}

