/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy11.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.model.Wss11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSS11Builder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        Wss11 wss11 = new Wss11(1);
        Policy policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement());
        Iterator iterator = (policy = policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), wss11);
        }
        return wss11;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.WSS11};
    }

    private void processAlternative(List assertions, Wss11 parent) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if (SP11Constants.MUST_SUPPORT_REF_KEY_IDENTIFIER.equals(name)) {
                parent.setMustSupportRefKeyIdentifier(true);
                continue;
            }
            if (SP11Constants.MUST_SUPPORT_REF_ISSUER_SERIAL.equals(name)) {
                parent.setMustSupportRefIssuerSerial(true);
                continue;
            }
            if (SP11Constants.MUST_SUPPORT_REF_EXTERNAL_URI.equals(name)) {
                parent.setMustSupportRefExternalURI(true);
                continue;
            }
            if (SP11Constants.MUST_SUPPORT_REF_EMBEDDED_TOKEN.equals(name)) {
                parent.setMustSupportRefEmbeddedToken(true);
                continue;
            }
            if (SP11Constants.MUST_SUPPORT_REF_THUMBPRINT.equals(name)) {
                parent.setMustSupportRefThumbprint(true);
                continue;
            }
            if (SP11Constants.MUST_SUPPORT_REF_ENCRYPTED_KEY.equals(name)) {
                parent.setMustSupportRefEncryptedKey(true);
                continue;
            }
            if (!SP11Constants.REQUIRE_SIGNATURE_CONFIRMATION.equals(name)) continue;
            parent.setRequireSignatureConfirmation(true);
        }
    }
}

