<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/formcheckbox.ftl">

  <@tableHeader Heading="New Account" />
  
  <#if show_error?? >
  
    ${message}
  
  <#elseif externalusermanagement?? && externalusermanagement > 
  
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
     <tr> 
       <td class="pad1">The users of this FSI Server are managend by an external directory server and can not be modified here.</td> 
     </tr>
    </table>
  
  <#elseif wizard_intro?? >
  
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
     <tr> 
       <td class="sectionheader firstsection" colspan="2">New user and new group / source connector</td> 
     </tr>
     <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     <tr>
	  <td class="pad1">
	  Create a new user account and a new group / source connector.  
	  </td>
	  <td class="pad1" align="right">
	   <form action="pt.do" method="post" onsubmit="this.submit();">
        <@printRequiredParams method="post" />
        <input type="hidden" name="action" value="newaccount" />
        <input type="hidden" name="wizardaction" value="neweverything" />
        <@formsubmit value="Ok" />
       </form>
      </td>
     </tr>
     <tr> 
      <td class="sectionheader" colspan="2">New user for existing group</td>
     </tr>
     <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	 <tr>
	  <td class="pad1">
	  Create a new user account for an existing group.  
	  </td>
	  <td class="pad1" align="right">
	   <form action="pt.do" method="post" onsubmit="this.submit();">
        <@printRequiredParams method="post" />
        <input type="hidden" name="action" value="newaccount" />
        <input type="hidden" name="wizardaction" value="newuserforgroup" />
        <@formsubmit value="Ok" disabled=(available_groups?size == 0)?string />
       </form>
      </td>
     </tr>
     <tr> 
       <td class="sectionheader" colspan="2">New admin user</td> 
     </tr>
     <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     <tr>
	  <td class="pad1">
	  Create a new admin user.  
	  </td>
	  <td class="pad1" align="right">
	   <form action="pt.do" method="post" onsubmit="this.submit();">
        <@printRequiredParams method="post" />
        <input type="hidden" name="action" value="newaccount" />
        <input type="hidden" name="wizardaction" value="newadmin" />
        <@formsubmit value="Ok" />
       </form>
      </td>
     </tr>
    </table>
    
  <#elseif show_form?? >
  
    <script type="text/javascript">
 	     function checkStorageConnectorSelection() {
 	            var scObj = document.getElementById('storageconnector');
 	            if (scObj) {
 	                var connectorSettings = document.getElementById('storageconnectorsettings');
 	                if (scObj.value == "true") {
 	                  connectorSettings.style.display = 'table-row';
 	                }
 	                else {
 	                  connectorSettings.style.display = 'none';
 	                }
 	            }
 	     }
 	
 	     function checkStaticConnectorSelection() {
 	         var scObj = document.getElementById('staticconnector');
 	         if (scObj) {
 	             var connectorSettings = document.getElementById('staticconnectorsettings');
 	             if (scObj.value == "true") {
 	               connectorSettings.style.display = 'table-row';
 	             }
 	             else {
 	               connectorSettings.style.display = 'none';
 	             }
 	         }
 	     }
 	     
 	     function prefillWithUsername() {
 	       var enteredName = document.getElementById('newusername').value;
 	       <#if request_groupname?? >
 	         if (document.getElementById('newgroupname').value == '') {
 	         	document.getElementById('newgroupname').value = enteredName;
 	         } 
 	       </#if>
 	       <#if request_connectors?? >
 	         if (document.getElementById('storageconnectorname').value == '') {
 	         	document.getElementById('storageconnectorname').value = enteredName + "_images";
 	         }
 	         if (document.getElementById('staticconnectorname').value == '') {
 	         	document.getElementById('staticconnectorname').value = enteredName + "_files";
 	         }
 	       </#if>
 	     }
 	     
 	</script>
  
    <#if message??><span style="color: red;">${message}</span></#if>
    
    <form action="pt.do" method="post" onsubmit="this.submit();" autocomplete="off">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="newaccount" />
    <input type="hidden" name="wizardaction" value="${wizardaction}" />
    
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
     <tr> 
       <td class="sectionheader firstsection" colspan="2">New Account</td>
     </tr>
     <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     
     <#-- BEGIN REQUEST USERNAME  -->
     
     <#if request_username?? >
     <tr>
	  <td class="pad1">Username:</td>
	  <td class="pad1">
	    <input type="text" class="inwhite" maxlength="30" id="newusername" name="newusername" <#if newusername??>value="${newusername}"</#if> onblur="prefillWithUsername();" /> 
	  </td>
     </tr>
     </#if>
     
     <#-- END REQUEST USERNAME  -->
     
     <#-- BEGIN REQUEST PASSWORD  -->
     
     <#if request_password?? >
     <tr>
      <td class="pad1">Password:</td>
      <td class="pad1">
	    <input type="password" class="inwhite" maxlength="30" id="pwd1" name="pwd1" /> 
	  </td>
     </tr>
     <tr>
      <td class="pad1">Repeat Password:</td>
      <td class="pad1">
	    <input type="password" class="inwhite" maxlength="30" id="pwd2" name="pwd2" /> 
	  </td>
     </tr>
     <#else>
     <tr>
      <td class="pad1" colspan="2"><span style="color: green">Passwords for this FSI Server are handled by you Kerberos, so please remember to create a principle for this user in the appropriate realm con your Kerberos Server. 
      </td>
     </tr>
     </#if>
     
     <#-- END REQUEST PASSWORD  -->
     
     <#-- BEGIN REQUEST GROUPNAME  -->
     
     <#if request_groupname?? >
     <tr>
	  <td class="pad1">Groupname:</td>
	  <td class="pad1">
	    <input type="text" class="inwhite" maxlength="30" id="newgroupname" name="newgroupname" <#if newgroupname??>value="${newgroupname}"</#if> /> 
	  </td>
     </tr>
     </#if>
     
     <#-- END REQUEST GROUPNAME  -->
     
     <#-- BEGIN REQUEST EXISTING GROUP  -->
     
     <#if request_existing_group?? >
       <#if available_groups?size == 0>
       <tr><td>
        No groups available.
       </td></tr>
       <#else>
       <tr> 
        <td class="sectionheader" colspan="2">Choose Group</td> 
       </tr>
       <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
       <tr>
        <td class="pad1">
         Select the group the user will be added to
        </td>
        <td class="pad1">
	     <@formgfxselect objid="groupname" preselect=available_groups?first.value itemlist=available_groups helpid="" />
	    </td>
	   </tr>
	   </#if>
	 </#if>
	 
	 <#-- END REQUEST EXISTING GROUP  -->
	 
	 
	 <#-- BEGIN REQUEST CONNECTORS  -->
	 
	 <#if request_connectors?? >
	   <tr> 
         <td class="sectionheader" colspan="2">Group and source connector information</td> 
       </tr>
       <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
       
       <tr>
        <td class="pad1" style="padding-top: 20px;">Create connector for images</td>
        <td class="pad1" style="padding-top: 20px;"><@formcheckbox objid="storageconnector" preselect="true" callbackonchange="checkStorageConnectorSelection" helpid="" /></td>
       </tr>
       <tr id="storageconnectorsettings">
        <td class="pad1" colspan="2">
         <table cellspacing="0" cellpadding="0" style="border: 0px; width: 100%;">
          <tr>
            <td class="pad1" style="width: 50%; padding-left: 50px;">Source Connector Name:</td>
            <td class="pad1" style="width: 50%;">
	          <input type="text" class="inwhite" id="storageconnectorname" name="storageconnectorname" value="<#if storageconnectorname??>${storageconnectorname}</#if>" /> 
	        </td>
	      </tr>
          <tr>
      		<td class="pad1" style="width: 50%; padding-left: 50px;">Image Directory:</td>
      		<td class="pad1" style="width: 50%;">
	    		<input type="text" class="inwhite" id="storageconnectordirectory" name="storageconnectordirectory" value="<#if storageconnectordirectory??>${storageconnectordirectory}</#if>" /> 
	  		</td>
     	  </tr>
     	 </table>
        </td>
       </tr>
       <tr>
        <td class="pad1" style="padding-top: 20px;">Create connector for static assets</td>
        <td class="pad1" style="padding-top: 20px;"><@formcheckbox objid="staticconnector" preselect="false" callbackonchange="checkStaticConnectorSelection" helpid="" /></td>
       </tr>
       <tr id="staticconnectorsettings" style="display: none">
        <td class="pad1" colspan="2">
         <table cellspacing="0" cellpadding="0" style="border: 0px; width: 100%;">
          <tr>
            <td class="pad1" style="width: 50%; padding-left: 50px;">Source Connector Name:</td>
            <td class="pad1" style="width: 50%;">
	          <input type="text" class="inwhite" id="staticconnectorname" name="staticconnectorname" value="<#if staticconnectorname??>${staticconnectorname}</#if>" /> 
	        </td>
	      </tr>
          <tr>
      		<td class="pad1" style="width: 50%; padding-left: 50px;">Asset Directory:</td>
      		<td class="pad1" style="width: 50%;">
	    		<input type="text" class="inwhite" id="staticconnectordirectory" name="staticconnectordirectory" value="<#if staticconnectordirectory??>${staticconnectordirectory}</#if>" /> 
	  		</td>
     	  </tr>
     	 </table>
        </td>
       </tr>
     </#if>
     
     <#-- END REQUEST CONNECTORS  -->
     
     <#-- BEGIN SUBMIT BUTTON  -->
	 
     <tr>
      <td class="pad1" colspan="2" align="right">
       <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();";>Back</span>
  	   <@formsubmit value="Continue" />     
      </td>
     </tr>
     
     <#-- END SUBMIT BUTTON  -->
     
    </table>
    </form>
    
  <#elseif show_confirmation?? >
  
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
     <tr> 
       <td class="sectionheader firstsection" colspan="2">New Account successfully created.</td>
     </tr>
     <tr>
	  <td class="pad1" colspan="2">
	  <ul>
	  <#if user_created??><li>User "${user_created}" created.</li></#if>
	  <#if group_created??><li>Group "${group_created}" created.</li></#if>
	  <#if user_added_to_group??><li>User added to group "${user_added_to_group}".</li></#if>
	  <#if publishingset_created??><li>Publishing Set "${publishingset_created}" created.</li></#if>
	  <#if propertyset_created??><li>Property Set "${propertyset_created}" created.</li></#if>
	  <#if connectors_created??><li>Connector(s) created.</li></#if>
	  </td>
     </tr>
    </table>
  
  <#elseif step_3_request_new_group_and_connector?? >
  
    <#if $message??><span style="color: red;">${message}</span></#if>
    
    <form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="newaccount" />
    <input type="hidden" name="step" value="4" />
    <input type="hidden" name="newusername" value="${newusername}" />
    <input type="hidden" name="type" value="${type}" />
    
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
     
     <tr>
      <td class="pad1" style="width: 50%;">Groupname:</td>
      <td class="pad1" style="width: 50%;">
	    <input type="text" class="inwhite" id="groupname" name="groupname" value="<#if groupname??>${groupname}<#else>${newusername}</#if>" /> 
	  </td>
     </tr>
     
     <tr>
      <td class="pad1" style="padding-top: 20px;">Install User Viewer:</td>
      <td class="pad1" style="padding-top: 20px;"><@formcheckbox objid="installuserviewer" preselect="true" helpid="userviewer" /></td>
     </tr>
     <tr>
      <td class="pad1" colspan="2" align="right">
        <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();";>Back</span>
  	    <@formsubmit value="Continue" />     
      </td>
     </tr>   
    </table>
    </form>

  <#elseif step_3_request_existing_group?? >

    <#if available_groups?size == 0>
      No groups available.
    <#else>
     <form action="pt.do" method="post" onsubmit="this.submit();">
      <@printRequiredParams method="post" />
      <input type="hidden" name="action" value="newaccount">
      <input type="hidden" name="step" value="4">
      <input type="hidden" name="newusername" value="${newusername}" />
      <input type="hidden" name="type" value="${type}">
      <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
       <tr> 
        <td class="sectionheader firstsection" colspan="2">Choose Group</td> 
       </tr>
       <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
       <tr>
        <td class="pad1">
	     <@formgfxselect objid="groupname" preselect=available_groups?first.value itemlist=available_groups helpid="" />
	    </td>
	   </tr>
	   <tr>
        <td class="pad1" align="right">
	     <@formsubmit value="Save New User" />
	    </td>
	   </tr>
       </table>
      </form>
    </#if>
    
  <#elseif step_4_user_complete?? >    
  
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
    <tr>  
      <td class="sectionheader firstsection">Account created</td>
     </tr>
     <tr><td><hr size="1" class="hr1"/></td></tr>
     <tr>
      <td class="pad1">
        The new account has been saved and the user was added to the selected group. The account is immediately usable.
      </td>
     </tr>
     <tr>
      <td class="pad1" style="text-align: right;">
       <form action="pt.do" method="get" onsubmit="this.submit();">
         <@printRequiredParams method="post" />
         <input type="hidden" name="action" value="default">
         <@formsubmit value="Ok" />    
	   </form> 
      </td>
     </tr> 
    </table>
  
  <#elseif step_4_confirm_new_group_and_connector?? >
    
    <script type="text/javascript">
         function show_saved() {
          document.getElementById("saving").style.display = "none";
          document.getElementById("saved").style.display = "block";
         }
    </script>
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
    <tr>  
      <td class="sectionheader firstsection">Account created</td>
     </tr>
     <tr><td><hr size="1" class="hr1"/></td></tr>
     <tr>
      <td class="pad1">
        The group and source connector have been created. Any images stored in the specified directory will be imported. 
      </td>
     </tr>
     <tr>
      <td class="pad1" style="text-align: center">  
        <div id="saving">
         Please wait while the FSI Server is restarted for the changes to take effect.<br /><br />
         <#assign timeout="5" />
         <#assign postprogressfunction="show_saved();" />
         <center>
         <#include "/sub/progressbar.ftl">
         </center>
        </div>
      </td>
     </tr>
     <tr>
      <td class="pad1" style="text-align: right;">
       <div id="saved" style="display: none;">
	    <form action="pt.do" method="get" onsubmit="this.submit();">
         <@printRequiredParams method="post" />
         <input type="hidden" name="action" value="default">
         <@formsubmit value="Ok" />    
	    </form> 
       </div> 
      </td>
     </tr>
    </table>
  </#if>
 <@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">