/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryConstant;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.common.ByteOrder;

public class BinaryFileParser {
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected boolean debug = false;

    public BinaryFileParser(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public BinaryFileParser() {
    }

    protected void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected final byte[] toBytes(short value) {
        return ByteConversions.toBytes(value, this.byteOrder);
    }

    protected final byte[] toBytes(short value, ByteOrder byteOrder) {
        return ByteConversions.toBytes(value, byteOrder);
    }

    protected final int toInt(byte[] bytes) {
        return ByteConversions.toInt(bytes, this.byteOrder);
    }

    protected final int toUInt16(byte[] bytes) {
        return ByteConversions.toUInt16(bytes, this.byteOrder);
    }

    protected final int toUInt16(byte[] bytes, int start) {
        return ByteConversions.toUInt16(bytes, start, this.byteOrder);
    }

    protected byte[] getStreamBytes(InputStream is) throws IOException {
        return BinaryFunctions.getStreamBytes(is);
    }

    protected final int read4Bytes(String name, InputStream is, String exception) throws IOException {
        return BinaryFunctions.read4Bytes(name, is, exception, this.byteOrder);
    }

    protected final int read3Bytes(String name, InputStream is, String exception) throws IOException {
        return BinaryFunctions.read3Bytes(name, is, exception, this.byteOrder);
    }

    protected final int read2Bytes(String name, InputStream is, String exception) throws IOException {
        return BinaryFunctions.read2Bytes(name, is, exception, this.byteOrder);
    }

    protected final byte readByte(String name, InputStream is, String exception) throws IOException {
        return BinaryFunctions.readByte(name, is, exception);
    }

    protected final byte[] readBytes(String name, InputStream is, int length, String exception) throws IOException {
        return BinaryFunctions.readBytes(name, is, length, exception);
    }

    protected final byte[] readBytes(String name, InputStream is, int length) throws IOException {
        return BinaryFunctions.readBytes(name, is, length);
    }

    protected final byte[] readBytes(InputStream is, int count) throws IOException {
        return BinaryFunctions.readBytes(is, count);
    }

    protected final void readAndVerifyBytes(InputStream is, BinaryConstant expected, String exception) throws IOException, ImageReadException {
        BinaryFunctions.readAndVerifyBytes(is, expected, exception);
    }

    protected final void readAndVerifyBytes(InputStream is, byte[] expected, String exception) throws ImageReadException, IOException {
        BinaryFunctions.readAndVerifyBytes(is, expected, exception);
    }

    protected final void skipBytes(InputStream is, int length) throws IOException {
        BinaryFunctions.skipBytes(is, length);
    }

    protected final void skipBytes(InputStream is, long length) throws IOException {
        BinaryFunctions.skipBytes(is, length);
    }

    protected final void skipBytes(InputStream is, long length, String exception) throws IOException {
        BinaryFunctions.skipBytes(is, length, exception);
    }

    protected final byte[] remainingBytes(String name, byte[] bytes, int count) throws ImageReadException {
        return BinaryFunctions.remainingBytes(name, bytes, count);
    }

    protected final byte[] slice(byte[] bytes, int start, int count) {
        return BinaryFunctions.slice(bytes, start, count);
    }

    protected final int findNull(byte[] src) {
        return BinaryFunctions.findNull(src);
    }

    protected final int findNull(byte[] src, int start) {
        return BinaryFunctions.findNull(src, start);
    }

    protected void printByteBits(String msg, byte i) {
        BinaryFunctions.printByteBits(msg, i);
    }

    protected void printCharQuad(String msg, int i) {
        BinaryFunctions.printCharQuad(msg, i);
    }

    protected final void printCharQuad(PrintWriter pw, String msg, int i) {
        BinaryFunctions.printCharQuad(pw, msg, i);
    }

    protected final void debugNumber(String msg, int data) {
        this.debugNumber(msg, data, 1);
    }

    protected final void debugNumber(String msg, int data, int bytes) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
        this.debugNumber(pw, msg, data, bytes);
        pw.flush();
    }

    protected final void debugNumber(PrintWriter pw, String msg, int data) {
        this.debugNumber(pw, msg, data, 1);
    }

    protected final void debugNumber(PrintWriter pw, String msg, int data, int bytes) {
        pw.print(msg + ": " + data + " (");
        int byteData = data;
        for (int i = 0; i < bytes; ++i) {
            if (i > 0) {
                pw.print(",");
            }
            int singleByte = 0xFF & byteData;
            pw.print((char)singleByte + " [" + singleByte + "]");
            byteData >>= 8;
        }
        pw.println(") [0x" + Integer.toHexString(data) + ", " + Integer.toBinaryString(data) + "]");
        pw.flush();
    }

    protected final void debugByteArray(String name, byte[] bytes) {
        System.out.println(name + ": " + bytes.length);
        for (int i = 0; i < bytes.length && i < 50; ++i) {
            this.debugNumber("\t (" + i + ")", 0xFF & bytes[i]);
        }
    }

    protected final void debugNumberArray(String name, int[] numbers, int length) {
        System.out.println(name + ": " + numbers.length);
        for (int i = 0; i < numbers.length && i < 50; ++i) {
            this.debugNumber(name + " (" + i + ")", numbers[i], length);
        }
    }

    protected final boolean compareBytes(byte[] a, int aStart, byte[] b, int bStart, int length) {
        return BinaryFunctions.compareBytes(a, aStart, b, bStart, length);
    }

    protected static boolean startsWith(byte[] haystack, BinaryConstant needle) {
        if (haystack == null || haystack.length < needle.size()) {
            return false;
        }
        for (int i = 0; i < needle.size(); ++i) {
            if (haystack[i] == needle.get(i)) continue;
            return false;
        }
        return true;
    }

    protected static boolean startsWith(byte[] haystack, byte[] needle) {
        return BinaryFunctions.startsWith(haystack, needle);
    }
}

