/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcType;

public class IptcRecord {
    public final IptcType iptcType;
    private final byte[] bytes;
    public final String value;
    public static final Comparator<IptcRecord> COMPARATOR = new Comparator<IptcRecord>(){

        @Override
        public int compare(IptcRecord e1, IptcRecord e2) {
            return e1.iptcType.getType() - e2.iptcType.getType();
        }
    };

    public IptcRecord(IptcType iptcType, byte[] bytes, String value) {
        this.iptcType = iptcType;
        this.bytes = bytes;
        this.value = value;
    }

    public IptcRecord(IptcType iptcType, String value) {
        byte[] bytes;
        this.iptcType = iptcType;
        try {
            bytes = value.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException cannotHappen) {
            bytes = null;
        }
        this.bytes = bytes;
        this.value = value;
    }

    public byte[] getRawBytes() {
        return (byte[])this.bytes.clone();
    }

    public String getValue() {
        return this.value;
    }

    public String getIptcTypeName() {
        return this.iptcType.getName();
    }
}

