<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/linkbutton.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">

  <@tableHeader Heading="Copy Renderer" />

  <#if show_form?? >

    <form action="pt.do" method="post" onsubmit="this.submit();">
      <@printRequiredParams method="post" />
      <input type="hidden" name="action" value="copyrenderer">
      <input type="hidden" name="renderername" value="${renderername}">
      
      <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
       <tr>
        <td class="pad1" colspan="2">
         This will create an exact copy of the selected renderer, which can then be used as a base for 
         a new custom renderer. Please enter the name for the copy below. 
        </td>
       </tr>
       <tr>
        <td class="sectionheader" colspan="2">Name for new renderer</td>
       </tr>
       <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
       <tr>
        <td class="pad1">Renderer Name:</td>
        <td class="pad1">
      	  <input type="text" class="inwhite" id="target" name="target" <#if renderername??>value="copy_of_${renderername}"</#if> help="<@appID/>:copyrenderer_target">
        </td>
       </tr>
       <tr>
        <td style="padding-top: 20px;" class="pad1" colspan="4" align="right">
          <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
          <@formsubmit value="Copy" />
        </td>
       </tr>
      </table>
    </form>

  <#elseif show_overwrite_request?? > 
  
	<form action="pt.do" method="post" onsubmit="this.submit();">
      <@printRequiredParams method="post" />
      <input type="hidden" name="action" value="copyrenderer">
      <input type="hidden" name="renderername" value="${renderername}">
      <input type="hidden" name="target" value="${target}">
      <input type="hidden" name="overwrite" value="1">

      <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
       <tr>
        <td class="pad1" colspan="2">    
         Another renderer with the requested name already exists. 
        </td>
       </tr>
       <tr>
        <td class="sectionheader" colspan="2">Overwrite Renderer?</td>
       </tr>
       <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
       <tr>
        <td class="pad1">Overwrite the existing renderer?</td>
        <td class="pad1" align="right">
          <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">No</span>	
          <@formsubmit value="Yes" />
        </td>
       </tr>
      </table>
    </form>
    
  <#elseif show_confirmation?? >
    
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
     <tr>
      <td class="sectionheader" colspan="2">Renderer copied</td>
     </tr>
     <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     <tr>
      <td class="pad1">
        Renderer copied. Please wait while the renderers are re-read for the changes to take effect.
      </td>
     </tr>
    </table>
    <#assign timeout="5" />
	<#assign postprogresslocation="action=requestprocessorsettings">
    <#include "/sub/progressbar.ftl">
    
  <#elseif show_error?? >
  
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
     <tr>
      <td class="sectionheader">Error</td>
     </tr>
     <tr><td><hr size="1" class="hr1"/></td></tr>
     <tr>
      <td class="pad1">
       The renderer could not be copied, please contact the system administrator or see the server logs for details.
      </td>
     </tr>
     <tr>
      <td class="pad1" style="text-align:right; padding-top: 20px;">
       <@linkbutton value="Ok" targeturl="pt.do?action=listrenderer" />
      </td>
     </tr>
    </table>
        
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">