<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/formgfxselect.ftl">
<#include "/macros/linkbutton.ftl">


<#if showsettings??>
  
  <@tableHeader Heading="Source Manager Settings" />
  
  
  <table cellspacing="0" cellpadding="0px" style="border: 0px; width: 500px">
      
      <tr>
        <td class="pad1" colspan="2">
         <#if message??>
           ${message}
         <#else>
           The source manager settings configure the behaviour of FSI Servers source manager component. The source manager component 
           is responsible for importing images from the source directories defined by the source manager profiles into 
           FSI Servers internal storage.  
         </#if>
        </td>
      </tr>
      <tr> 
        <td class="sectionheader" colspan="2">General Settings</td>
	  </tr>
      <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1" style="width: 190px">Enabled</td>
	    <td class="pad1" style="width: 310px"><#if application_enabled ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <tr>
	    <td class="pad1">Storage Directory</td>
	    <td class="pad1">${storage}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Temp Directory</td>
	    <td class="pad1">${tempdirectory}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Log To Storage</td>
	    <td class="pad1"><#if logtostorage ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td></td>
	  </tr>
	  <tr>
	    <td class="pad1">Max. CPUCores</td>
	    <td class="pad1">${maxcpu}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Max. IO Threads</td>
	    <td class="pad1">${maxio}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Max. Threads per Job</td>
	    <td class="pad1">${maxthreadsperjob}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Import Strategy</td>
	    <td class="pad1">${importstrategy}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Parallel Reading</td>
	    <td class="pad1"><#if parallelread ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <tr>
	    <td class="pad1">Parallel Writing</td>
	    <td class="pad1"><#if parallelwrite ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <tr>
	    <td class="pad1">Parallel Reading while Writing</td>
	    <td class="pad1"><#if parallelreadwrite ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <tr>
	    <td class="pad1">User Management</td>
	    <td class="pad1"><#if userdb == "xmlfile" >Local XML Files<#else>LDAP Server</#if></td>
	  </tr>
	  <#if userdb == "ldap" >
	  
	  <tr>
	    <td class="pad1">LDAP URI</td>
	    <td class="pad1">${ldapuri}</td>
	  </tr>
	  <tr>
	    <td class="pad1">LDAP Username</td>
	    <td class="pad1">${ldapuser}</td>
	  </tr>
	  <tr>
	    <td class="pad1">LDAP Password</td>
	    <td class="pad1">${ldappassword}</td>
	  </tr>
	  <tr>
	    <td class="pad1">LDAP Base DN</td>
	    <td class="pad1">${ldapbasedn}</td>
	  </tr>
	  </#if>
	  
	  <tr>
	    <td class="pad1">Kerberos Authentication</td>
	    <td class="pad1"><#if usekrb ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  
	  <#if usekrb >
	  <tr>
	    <td class="pad1">Kerberos Debug</td>
	    <td class="pad1"><#if krbdebug ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  </#if>
	  
	  <tr>
	    <td class="pad1">JMX Support</td>
	    <td class="pad1"><#if jmx ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
      <tr>
	    <td class="pad1">Ping Service</td>
	    <td class="pad1" style="max-width: 350px"><span>${pingservice}</span></td>
	  </tr>
	  <tr>
	    <td class="pad1"></td>
	    <td class="pad1" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="sourcemanagersettings">
      		<input type="hidden" name="editsettings" value="1">
      		<@formsubmit value="Edit" helpid="sourcemanagersettings_edit_general" />
      	  </form>
	    </td>
	  </tr>

      <tr> 
        <td class="sectionheader" colspan="3">Scanner Settings</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1"><#if scanner_enabled ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <tr>
	    <td class="pad1">Sorting</td>
	    <td class="pad1"><#if sorting ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <tr>
	    <td class="pad1">Convert Before First Scan</td>
	    <td class="pad1"><#if convertbefore1stscan ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <tr>
	    <td class="pad1"></td>
	    <td class="pad1" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="sourcemanagersettings" />
      		<input type="hidden" name="editscanner" value="1" />
      		<@formsubmit value="Edit" helpid="sourcemanagersettings_edit_scanner" />
      	  </form>
	    </td>
	  </tr>


      <tr> 
        <td class="sectionheader" colspan="3">Search Database Settings</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1"><#if searchenabled ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <#if searchenabled >
	  <tr>
	    <td class="pad1">Server URI</td>
	    <td class="pad1">${solrserveruri}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Core</td>
	    <td class="pad1">${core}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Authentication</td>
	    <td class="pad1"><#if authentication?starts_with("true") ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <#if authentication?starts_with("true") >
	   <tr>
	    <td class="pad1">
	      <table>
	       <tr>
	        <td class="pad1">Type</td>
	        <td class="pad1">${authentication_type}</td>
	       </tr>
	       <tr>
	        <td class="pad1">Username</td>
	        <td class="pad1">${username}</td>
	       </tr>
	       <tr>
	        <td class="pad1">Password</td>
	        <td class="pad1">${password}</td>
	       </tr>
	      </table>
	    </td>
	   </tr>
	  </#if>
	  <tr>
	    <td class="pad1">Use proxy</td>
	    <td class="pad1"><#if proxy?starts_with("true") ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <#if proxy?starts_with("true") >
	       <tr>
	        <td class="pad1" style="padding-left: 20px">Hostname and Port</td>
	        <td class="pad1" colspan="2">${proxyhostname} : ${proxy_port}</td>
	       </tr>
	       <tr>
	        <td class="pad1" style="padding-left: 20px">SSL</td>
	        <td class="pad1" colspan="2"><#if proxyssl?starts_with("true") ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	       </tr>
	       <tr>
	        <td class="pad1" style="padding-left: 20px">Authentication</td>
	        <td class="pad1" colspan="2"><#if proxyauthentication?starts_with("true") ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	       </tr>
	       <tr>
	        <td class="pad1" style="padding-left: 20px">Username</td>
	        <td class="pad1" colspan="2">${proxyusername}</td>
	       </tr>
	       <tr>
	        <td class="pad1" style="padding-left: 20px">Password</td>
	        <td class="pad1" colspan="2">${proxypassword}</td>
	       </tr>
	  </#if>
	  <tr>
	    <td class="pad1">Connection Pool Size</td>
	    <td class="pad1">${connectionpoolmax}</td>
	  </tr>
	  </#if>
	  <tr>
	    <td class="pad1"></td>
	    <td class="pad1" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="sourcemanagersettings" />
      		<input type="hidden" name="editsearch" value="1" />
      		<@formsubmit value="Edit" helpid="sourcemanagersettings_edit_searchsettings" />
      	  </form>
	    </td>
	  </tr>

	  <tr>
	    <td class="sectionheader" colspan="2">Color Management System</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1"><#if cmsenabled ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr> 	 
	  <tr>
	    <td class="pad1">Default CMYK Profile</td>
	    <td class="pad1">${defaultcmykprofile}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Default RGB Profile</td>
	    <td class="pad1">${defaultrgbprofile}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Default Gray Profile</td>
	    <td class="pad1">${defaultgrayprofile}</td>
	  </tr>
     <tr>
	    <td class="pad1">Fallback ICC Conversion</td>
	    <td class="pad1"><#if fallbackICCConversion ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <tr>
	    <td class="pad1"></td>
	    <td class="pad1" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="sourcemanagersettings" />
      		<input type="hidden" name="editcms" value="1" />
      		<@formsubmit value="Edit" helpid="sourcemanagersettings_edit_cms" />
      	  </form>
	    </td>
	  </tr>
     
     
      <tr>
	    <td class="sectionheader" colspan="3">Protected Files and Directories</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Protected Files</td>
	    <td class="pad1" style="max-width: 350px">${protected_files}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Protected Directories</td>
	    <td class="pad1" style="max-width: 350px">${protected_dirs}</td>
	  </tr>
	  <tr>
	    <td class="pad1"></td>
	    <td class="pad1" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="sourcemanagersettings">
      		<input type="hidden" name="editprotectedfiles" value="1">
      		<@formsubmit value="Edit" helpid="sourcemanagersettings_edit_protected_files" />
      	  </form>
	    </td>
	  </tr>
	  
	  <tr>
	    <td class="sectionheader" colspan="2">Memory Cache Settings</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1"><#if cacheenabled ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <tr>
	    <td class="pad1">Max. Memory</td>
	    <td class="pad1" style="max-width: 350px">${maxmemory}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Use Direct Memory</td>
	    <td class="pad1"><#if directmemory?starts_with("true") ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <tr>
	    <td class="pad1"></td>
	    <td class="pad1" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="sourcemanagersettings">
      		<input type="hidden" name="editcachesettings" value="1">
      		<@formsubmit value="Edit" helpid="sourcemanagersettings_edit_cachesettings" />
      	  </form>
	    </td>
	  </tr>
   </table>
   <@tableFooter/>
   
  <#elseif show_cachesettings_form??>
  
    <@tableHeader Heading="Edit Cache Settings" />
    <form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="sourcemanagersettings">
    <input type="hidden" name="editcachesettings" value="1">
    <input type="hidden" name="save" value="1">
    
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
	  <tr>
	    <td class="sectionheader firstsection" colspan="3">Memory Cache Settings</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1" colspan="2">
	      <@formcheckbox objid="cacheenabled" preselect=cacheenabled?string helpid="sourcemanagersettings_cacheenabled" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Max. Memory</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" style="width:300px" id="maxmemory" name="maxmemory" <#if maxmemory??>value="${maxmemory}"</#if> help="<@appID/>:sourcemanagersettings_cache_maxmemory">	    
	    </td>
	  </tr>   
	  <tr>
	    <td class="pad1">Use Direct Memory</td>
	    <td class="pad1" colspan="2">
	      <@formcheckbox  objid="directmemory" preselect=directmemory helpid="sourcemanagersettings_directmemory" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1" style="text-align: right; padding-top: 20px" colspan="2" >
	      <@linkbutton value="Cancel" targeturl="pt.do?action=sourcemanagersettings" helpid="sourcemanagersettings_cancel" />
          <@formsubmit value="Save Changes" helpid="sourcemanagersettings_save" />
	    </td>
	  </tr>
     </table>
    </form>
    <@tableFooter/>
   
  <#elseif show_mainsettings_form??>
  
    <script type="text/javascript">
      function toggle_sections() {
      	var authBox = document.getElementById("userdb");
      	var ldapTableRow1 = document.getElementById("ldaptablerow1");
      	var ldapTableRow2 = document.getElementById("ldaptablerow2");
      	var ldapTableRow3 = document.getElementById("ldaptablerow3");
      	var ldapTableRow4 = document.getElementById("ldaptablerow4");
      	if (authBox.value == "xmlfile") {
      	  ldapTableRow1.style.display = "none";
      	  ldapTableRow2.style.display = "none";
      	  ldapTableRow3.style.display = "none";
      	  ldapTableRow4.style.display = "none";
      	} else {
      	  ldapTableRow1.style.display = "table-row";
      	  ldapTableRow2.style.display = "table-row";
      	  ldapTableRow3.style.display = "table-row";
      	  ldapTableRow4.style.display = "table-row";
      	}
      	var krbBox = document.getElementById("usekrb");
      	var krbdebugrow = document.getElementById("krbdebugrow");
      	if (krbBox.value == "true") {
      	  krbdebugrow.style.display = "table-row";
      	}
      	else {
      	  krbdebugrow.style.display = "none";
      	}
      }
    </script>
  
  
    <@tableHeader Heading="Edit Source Manager Settings" />
  
  	<form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="sourcemanagersettings">
    <input type="hidden" name="editsettings" value="1">
    <input type="hidden" name="save" value="1">
  
     <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
	  <tr>
	    <td class="sectionheader firstsection" colspan="2">General Settings</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
        <td class="pad1" colspan="2">
         <p class="warning">Warning: If you disable the software here, you won't be able to connect to this interface any longer.
         You will need direct access to the server to make any further modifications. 
         </p>
        </td>
      </tr>
	  <tr>
	    <td class="pad1" style="width: 190px">Enabled</td>
	    <td class="pad1" style="width: 310px">
	      <@formcheckbox  objid="enabled" preselect=application_enabled?string helpid="sourcemanagersettings_enabled" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Storage Directory</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" style="width:300px" id="storage" name="storage" <#if storage??>value="${storage}"</#if> help="<@appID/>:sourcemanagersettings_storage">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Temp Directory</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" style="width:300px" id="tempdirectory" name="tempdirectory" <#if tempdirectory??>value="${tempdirectory}"</#if> help="<@appID/>:sourcemanagersettings_tempdirectory">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Log To Storage</td>
	    <td class="pad1">
	      <@formcheckbox objid="logtostorage" preselect=logtostorage?string helpid="sourcemanagersettings_logtostorage" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Max. CPU Cores</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" style="width:300px" id="maxcpu" name="maxcpu" <#if maxcpu??>value="${maxcpu}"</#if> help="<@appID/>:sourcemanagersettings_maxcpu">	    
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Max. IO Threads</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" style="width:300px" id="maxio" name="maxio" <#if maxio??>value="${maxio}"</#if> help="<@appID/>:sourcemanagersettings_maxio">	    
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Max. Threads/Job</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" style="width:300px" id="maxthreadsperjob" name="maxthreadsperjob" <#if maxthreadsperjob??>value="${maxthreadsperjob}"</#if> help="<@appID/>:sourcemanagersettings_maxthreadsperjob">	    
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Import Strategy</td>
	    <td class="pad1">
	      <@formgfxselect width="300" objid="importstrategy" itemlist=all_importstrategies preselect=importstrategy helpid="sourcemanagersettings_importstrategy" />
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Parallel Reading</td>
	    <td class="pad1">
	      <@formcheckbox objid="parallelread" preselect=parallelread?string helpid="sourcemanagersettings_parallelread" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Parallel Writing</td>
	    <td class="pad1">
	      <@formcheckbox objid="parallelwrite" preselect=parallelwrite?string helpid="sourcemanagersettings_parallelwrite" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Parallel Reading wh. Writing</td>
	    <td class="pad1">
	      <@formcheckbox objid="parallelreadwrite" preselect=parallelreadwrite?string helpid="sourcemanagersettings_parallelreadwrite" /> 
	    </td>
	  </tr>
	  
	  <tr>
	    <td class="pad1">User Management</td>
	    <td class="pad1">
	      <@formgfxselect width="300" objid="userdb" itemlist=all_userdb_values preselect=userdb callbackonchange="toggle_sections" helpid="sourcemanagersettings_userdb" />
	    </td>
	  </tr>
	  <tr id="ldaptablerow1" <#if userdb?starts_with("ldap")>style="display: table-row;"<#else>style="display: none;"</#if>>
	    <td class="pad1" style="width: 190px; padding-left: 20px">LDAP URI</td>
	    <td class="pad1" style="width: 310px">
	      <input type="text" class="inwhite" style="width:300px" id="ldapuri" name="ldapuri" <#if ldapuri??>value="${ldapuri}"</#if> help="<@appID/>:sourcemanagersettings_ldapuri">	    
	    </td>
	  </tr>
	  <tr id="ldaptablerow2" <#if userdb?starts_with("ldap")>style="display: table-row;"<#else>style="display: none;"</#if>>
	    <td class="pad1" style="width: 190px; padding-left: 20px">LDAP Username</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" style="width:300px" id="ldapuser" name="ldapuser" <#if ldapuser??>value="${ldapuser}"</#if> help="<@appID/>:sourcemanagersettings_ldapuser">	    
	    </td>
	  </tr>
	  <tr id="ldaptablerow3" <#if userdb?starts_with("ldap")>style="display: table-row;"<#else>style="display: none;"</#if>>
	    <td class="pad1" style="width: 190px; padding-left: 20px">LDAP Password</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" style="width:300px" id="ldappassword" name="ldappassword" <#if ldappassword??>value="${ldappassword}"</#if> help="<@appID/>:sourcemanagersettings_ldappassword">	    
	    </td>
	  </tr>
	  <tr id="ldaptablerow4" <#if userdb?starts_with("ldap")>style="display: table-row;"<#else>style="display: none;"</#if>>
	    <td class="pad1" style="width: 190px; padding-left: 20px">LDAP Base DN</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" style="width:300px" id="ldapbasedn" name="ldapbasedn" <#if ldapbasedn??>value="${ldapbasedn}"</#if> help="<@appID/>:sourcemanagersettings_ldapbasedn">	    
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Kerberos Authentication</td>
	    <td class="pad1">
	      <@formcheckbox objid="usekrb" preselect=usekrb?string callbackonchange="toggle_sections" helpid="sourcemanagersettings_usekrb" /> 
	    </td>
	  </tr>
	  <tr id="krbdebugrow" <#if usekrb >style="display: table-row;"<#else>style="display: none;"</#if>>
	    <td class="pad1" style="padding-left: 20px;">Kerberos Debugging</td>
	    <td class="pad1">
	      <@formcheckbox objid="krbdebug" preselect=krbdebug?string helpid="sourcemanagersettings_krbdebug" /> 
	    </td>
	  </tr>
	  
	  <tr>
	    <td class="pad1">JMX Support</td>
	    <td class="pad1">
	      <@formcheckbox objid="jmx" preselect=jmx?string helpid="sourcemanagersettings_jmx" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Ping Service</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" style="width:300px" id="pingservice" name="pingservice" <#if pingservice??>value="${pingservice}"</#if> help="<@appID/>:requestprocessorsettings_pingservice">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1" style="text-align: right; padding-top: 20px" colspan="2" >
	      <@linkbutton value="Cancel" targeturl="pt.do?action=sourcemanagersettings" helpid="sourcemanagersettings_cancel" />
          <@formsubmit value="Save Changes" helpid="sourcemanagersettings_save" />
	    </td>
	  </tr>
     </table>
    </form>
    <@tableFooter/>
	
  <#elseif show_searchsettings_form??>
  
    <script type="text/javascript">
      function toggle_sections() {
      	var authBox = document.getElementById("authentication");
      	var authTable = document.getElementById("authtable");
      	if (authBox.value == "false") {
      	  authTable.style.display = "none";
      	} else {
      	  authTable.style.display = "table-row";
      	}
      	var proxyBox = document.getElementById("proxy");
      	var proxyTable = document.getElementById("proxytable");
      	if (proxyBox.value == "false") {
      	  proxyTable.style.display = "none";
      	} else {
      	  proxyTable.style.display = "table-row";
      	}
      }
    </script>
  
    <@tableHeader Heading="Edit Search Database Settings" />
  
  	<form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="sourcemanagersettings">
    <input type="hidden" name="editsearch" value="1">
    <input type="hidden" name="save" value="1">
  
     <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
	  <tr>
	    <td class="sectionheader firstsection" colspan="3">Search Database Settings</td>
	  </tr>
	  <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1" colspan="2">
	      <@formcheckbox  objid="enabled" preselect=searchenabled?string helpid="searchsettings_enabled" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Solr Server URI</td>
	    <td class="pad1" colspan="2">
	      <input type="text" class="inwhite" id="solrserveruri" name="solrserveruri" <#if solrserveruri??>value="${solrserveruri}"</#if> help="<@appID/>:searchsettings_solr_solrserveruri">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Core</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" id="core" name="core" <#if core??>value="${core}"</#if> help="<@appID/>:searchsettings_solr_core">  
	    </td>
	  </tr>
	  
	  <tr>
	    <td class="pad1">Use Authentication</td>
	    <td class="pad1" colspan="2">
	      <@formcheckbox  objid="authentication" preselect=authentication callbackonchange="toggle_sections" helpid="searchsettings_solr_authentication" /> 
	    </td>
	  </tr>
	  <tr id="authtable" <#if authentication?starts_with("true")>style="display: table-row;"<#else>style="display: none;"</#if>>
	    <td class="pad1" colspan="2">
	    <table>
	      <tr>
	        <td class="pad1">Authentication Type</td>
	        <td class="pad1" colspan="2">
	          <@formgfxselect objid="authenticationtype" itemlist=authentication_types preselect=authenticationtype helpid="searchsettings_solr_authenticationtype" /> 
	        </td>
	      </tr>
	      <tr>
	        <td class="pad1">Username</td>
	        <td class="pad1" colspan="2">
	          <input type="text" class="inwhite" id="authenticationusername" name="authenticationusername" <#if authenticationusername??>value="${authenticationusername}"</#if> help="<@appID/>:searchsettings_solr_authenticationusername"> 
	        </td>
	      </tr>
          <tr>
	        <td class="pad1">Password</td>
	        <td class="pad1" colspan="2">
	          <input type="text" class="inwhite" id="authenticationpassword" name="authenticationpassword" <#if authenticationpassword??>value="${authenticationpassword}"</#if> help="<@appID/>:searchsettings_solr_authenticationpassword"> 
	        </td>
	      </tr>
		</table>
	    </td>	      
	  </tr>
	  
	  <tr>
	    <td class="pad1">Use Proxy</td>
	    <td class="pad1" colspan="2">
	      <@formcheckbox  objid="proxy" preselect=proxy callbackonchange="toggle_sections" helpid="searchsettings_solr_proxy" /> 
	    </td>
	  </tr>
	  <tr id="proxytable" <#if proxy?starts_with("true")>style="display: table-row;"<#else>style="display: none;"</#if>>
	    <td class="pad1" colspan="2">
	    <table>
	      <tr>
	        <td class="pad1">Hostname</td>
	        <td class="pad1" colspan="2">
	          <input type="text" class="inwhite" id="proxyhostname" name="proxyhostname" <#if proxyhostname??>value="${proxyhostname}"</#if> help="<@appID/>:searchsettings_solr_proxyhostname">
	        </td>
	      </tr>
	      <tr>
	        <td class="pad1">Port</td>
	        <td class="pad1">
	          <input type="text" class="inwhite" id="proxyport" name="proxyport" <#if port??>value="${proxyport}"</#if> help="<@appID/>:searchsettings_solr_proxyport">	    
	        </td>
	      </tr>
	      <tr>
	        <td class="pad1">Access Proxy Using SSL</td>
	        <td class="pad1" colspan="2">
	          <@formcheckbox  objid="proxyssl" preselect=proxyssl helpid="searchsettings_solr_proxyssl" /> 
	        </td>
	      </tr>
	      <tr>
	        <td class="pad1">Proxy Requires Authentication</td>
	        <td class="pad1" colspan="2">
	          <@formcheckbox  objid="proxyauthentication" preselect=proxyauthentication helpid="searchsettings_solr_proxyauthentication" /> 
	        </td>
	      </tr>
	      <tr>
	        <td class="pad1">Username</td>
	        <td class="pad1" colspan="2">
	          <input type="text" class="inwhite" id="proxyusername" name="proxyusername" <#if proxyusername??>value="${proxyusername}"</#if> help="<@appID/>:searchsettings_solr_proxyusername"> 
	        </td>
	      </tr>
          <tr>
	        <td class="pad1">Password</td>
	        <td class="pad1" colspan="2">
	          <input type="text" class="inwhite" id="proxypassword" name="proxypassword" <#if proxypassword??>value="${proxypassword}"</#if> help="<@appID/>:searchsettings_solr_proxypassword"> 
	        </td>
	      </tr>
		</table>
		</td>	      
	  </tr>
	  
	  <tr>
	    <td class="pad1">Connection Pool Size</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" id="connectionpoolmax" name="connectionpoolmax" <#if connectionpoolmax??>value="${connectionpoolmax}"</#if> help="<@appID/>:sourcemanagersettings_solr_connectionpoolmax">	    
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1" style="text-align: right; padding-top: 20px" colspan="2" >
	      <@linkbutton value="Cancel" targeturl="pt.do?action=sourcemanagersettings" helpid="sourcemanagersettings_cancel" />
          <@formsubmit value="Save Changes" helpid="sourcemanagersettings_save" />
	    </td>
	  </tr>
     </table>
    </form>
    <@tableFooter/>
  
   <#elseif show_scannersettings_form??>
  
    <@tableHeader Heading="Edit Scanner Settings" />
  
  	<form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="sourcemanagersettings">
    <input type="hidden" name="editscanner" value="1">
    <input type="hidden" name="save" value="1">
  
     <table cellspacing="0" cellpadding="0" border="0" width="500px">
	  <tr>
	    <td class="sectionheader firstsection" colspan="3">Scanner Settings</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1">
	      <@formcheckbox  objid="enabled" preselect=scanner_enabled?string helpid="sourcemanagersettings_scannerenabled" /> 
	    </td>
	  </tr>
      <tr>
	    <td class="pad1">Sorting</td>
	    <td class="pad1" colspan="2">
	      <@formcheckbox objid="sorting" preselect=sorting?string helpid="sourcemanagersettings_sorting" /> 
	    </td>
	  </tr>
      <tr>
	    <td class="pad1">Convert Before First Scan</td>
	    <td class="pad1" colspan="2">
	      <@formcheckbox objid="convertbefore1stscan" preselect=convertbefore1stscan?string helpid="sourcemanagersettings_sorting" /> 
	    </td>
	  </tr>
    <tr>
	    <td class="pad1">Filescan Delay</td>
	    <td class="pad1" colspan="2">	       
         <input type="text" class="inwhite" id="filescandelay" name="filescandelay" value="${filescandelay}" help="<@appID/>:sourcemanagersettings_filescandelay">
	    </td>
	  </tr>
      <tr>
	    <td class="pad1" style="text-align: right; padding-top: 20px;" colspan="2">
	      <@linkbutton value="Cancel" targeturl="pt.do?action=sourcemanagersettings" helpid="sourcemanagersettings_cancel" />
          <@formsubmit value="Save Changes" helpid="sourcemanagersettings_save" />
	    </td>
	  </tr>     
     </table>
    </form>
    <@tableFooter/>
	
  <#elseif show_cmssettings_form??>
  
    <@tableHeader Heading="Edit Source Manager Color Management Settings" />
  
  	<form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="sourcemanagersettings">
    <input type="hidden" name="editcms" value="1">
    <input type="hidden" name="save" value="1">
  
     <table cellspacing="0" cellpadding="0" border="0" width="500px">
	  <tr>
	    <td class="sectionheader firstsection" colspan="3">Color Management Settings</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1">
	      <@formcheckbox  objid="enabled" preselect=cmsenabled?string helpid="sourcemanagersettings_cmsenabled" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Default CMYK Profile</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="defaultcmykprofile" name="defaultcmykprofile" <#if defaultcmykprofile??>value="${defaultcmykprofile}"</#if> help="<@appID/>:sourcemanagersettings_defaultcmykprofile">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Default RGB Profile</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="defaultrgbprofile" name="defaultrgbprofile" <#if defaultrgbprofile??>value="${defaultrgbprofile}"</#if> help="<@appID/>:sourcemanagersettings_defaultrgbprofile">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Default Gray Profile</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="defaultgrayprofile" name="defaultgrayprofile" <#if defaultgrayprofile??>value="${defaultgrayprofile}"</#if> help="<@appID/>:sourcemanagersettings_defaultgrayprofile">
	    </td>
	  </tr>
 	  <tr>
	    <td class="pad1">Fallback ICC Conversion</td>
	    <td class="pad1">
	      <@formcheckbox  objid="fallbackICCConversion" preselect=fallbackICCConversion?string helpid="sourcemanagersettings_fallbackICCConversion" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1" style="text-align: right; padding-top: 20px;" colspan="2">
	      <@linkbutton value="Cancel" targeturl="pt.do?action=sourcemanagersettings" helpid="sourcemanagersettings_cancel" />
          <@formsubmit value="Save Changes" helpid="sourcemanagersettings_save" />
	    </td>
	  </tr>
     </table>
    </form>
    <@tableFooter/>
  
  <#elseif show_protectedsettings_form??>
  
    <@tableHeader Heading="Edit Protected Files and Directories" />
  
  	<form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="sourcemanagersettings">
    <input type="hidden" name="editprotectedfiles" value="1">
    <input type="hidden" name="save" value="1">
  
     <table cellspacing="0" cellpadding="0" border="0" width="500px">
	  <tr>
	    <td class="sectionheader firstsection" colspan="3">Protected Files and Directories</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Protected Files</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" id="protected_files" name="protected_files" <#if protected_files??>value="${protected_files}"</#if> help="<@appID/>:sourcemanagersettings_protected_files">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Protected Directories</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" id="protected_dirs" name="protected_dirs" <#if protected_dirs??>value="${protected_dirs}"</#if> help="<@appID/>:sourcemanagersettings_protected_dirs">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1" style="text-align: right; padding-top: 20px;" colspan="2">
	      <@linkbutton value="Cancel" targeturl="pt.do?action=sourcemanagersettings" helpid="sourcemanagersettings_cancel" />
          <@formsubmit value="Save Changes" helpid="sourcemanagersettings_save" />
	    </td>
	  </tr>
     </table>
    </form>
    <@tableFooter/>
  <#elseif show_confirmation??>
  
    <@tableHeader Heading="Edit Source Manager Settings" />
  
    <table cellspacing="0" cellpadding="0" border="0" width="500px">
	  <tr>
	    <td class="sectionheader firstsection">Settings saved</td>
	  </tr>
	  <tr><td><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">
          The changes to the settings have been saved. Please wait while the application is restarted for the changes to take effect.
        </td>
      </tr>
    </table>
	<@tableFooter/>
    <#assign timeout="5" />
    <#assign postprogresslocation="action=sourcemanagersettings">
    <#include "/sub/progressbar.ftl">
  
  </#if>
	
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">