/*!
 * FSI Server Interface
 * http://www.fsi-viewer.com
 *
 * Copyright (C) 2000-2016 NeptuneLabs GmbH - All rights reserved.
 *
 * Version: 3.0.0
 */
;function FSIDialogs(interfaceControl){var self=this;var ic=interfaceControl;var translator=ic.getTranslator();var modalopacityDefault=0.65;var browseTree;this.oBrowseOptions=undefined;var translate=this.translate=function(key){if(!translator){return key}var ret=translator.translateTextValue("dialogs",key,true);if(ret.length<1){ret=key}return ret};var translateError=function(key){if(!translator){return key}var ret=translator.translateTextValue("dialogErrors",key,true);if(ret.length<1){ret=key}return ret};var translateComponent=function(key){return translator.translateComponentTextValue("components","dialogs",key,true)};var endDialog=this.endDialog=function(){ic.nCurrentModalDialogs--;if(ic.nCurrentModalDialogs<0){ic.nCurrentModalDialogs=0}ic.oCurrentDialog=ic.oCurrentDialog.previousDialog;ic.unlockInterface()};this.showDialog=function(template,oOptions){var bDefaultDialog=false;var dlgComponents=ic.getComponents().getComponent("dialogs");if(!dlgComponents){return}var dlgComponent=$(dlgComponents).find("#"+template);if(!dlgComponent||dlgComponent.length<1||!oOptions){return}var componentDiv=$(dlgComponent).get(0).cloneNode(true);var elParent=ic.getDocumentBody();if(!elParent){return}oOptions.close=function(event,ui){if($(this).attr("NELAModal")){endDialog()}if(!oOptions.NELAnoAutoDestroy){$(this).dialog("destroy");$(this).remove();ic.getThumbView().setTheFocus()}if(oOptions.callBack){oOptions.callBack(oOptions.callBackParam)}if(oOptions.onClose){oOptions.onClose()}};var dialogID="FSIDialog_"+template;$(componentDiv).attr("id",dialogID);if(oOptions.modal){$(componentDiv).attr("NELAModal",true);delete oOptions.modal;ic.lockInterface(false,true,oOptions.modalopacity);ic.nCurrentModalDialogs++}elParent.appendChild(componentDiv);$(function(){$(componentDiv).dialog(oOptions)});var t=ic.oCurrentDialog;ic.oCurrentDialog=$("#"+dialogID);ic.oCurrentDialog.previousDialog=t;return componentDiv};var getDlgError=function(str){var prefix=translate("error")+":<br/>";var strError=translateError(str);return"<span class='dialogErrorTitle'>"+prefix+"</span>"+strError};var setDefaultButton=function(dlg,elInput,strButtonLabel){var btnDefault=$(dlg).parent("div").find("button:contains('"+translate(strButtonLabel)+"')");if(elInput){elInput.onkeyup=function(e){onDialogKeyUp(e,dlg,btnDefault)}}};var onDialogKeyUp=function(evt,dlg,btnDefault){var ret;if(evt==undefined){evt=window.event}var keycode=evt.keyCode|evt.which;switch(keycode){case 13:$(btnDefault).trigger("click");ret=false;break}return ret};var createDefaultDialogButtons=function(oButtons,arButtonTitles){if(!oButtons||!arButtonTitles||!arButtonTitles.length){return}var title,orgTitle;var callBacks=new Object();for(var i=0;i<arButtonTitles.length;i++){orgTitle=arButtonTitles[i];if(typeof(orgTitle)=="object"){callBacks[orgTitle[0]]=orgTitle[1];orgTitle=orgTitle[0]}title=translate(orgTitle);switch(orgTitle){case"Cancel":oButtons[title]=function(){var fnCallback=this.callBacks.Cancel;if(!fnCallback||fnCallback("Cancel")){$(this).dialog("close")}};break;case"SkipAll":oButtons[title]=function(){var fnCallback=this.callBacks.SkipAll;if(!fnCallback||fnCallback("SkipAll")){interfaceControl.onPostCommandDialogIgnore(true)}};break;case"Skip":oButtons[title]=function(){var fnCallback=this.callBacks.Skip;if(!fnCallback||fnCallback("Skip")){interfaceControl.onPostCommandDialogIgnore(false)}};break;case"Retry":oButtons[title]=function(){var fnCallback=this.callBacks.Retry;if(!fnCallback||fnCallback("Retry")){interfaceControl.onPostCommandDialogRetry()}};break;case"Overwrite":oButtons[title]=function(){var fnCallback=this.callBacks.Overwrite;if(!fnCallback||fnCallback("Overwrite")){interfaceControl.onPostCommandDialogOverwrite(false)}};break;case"OverwriteAll":oButtons[title]=function(){var fnCallback=this.callBacks.OverwriteAll;if(!fnCallback||fnCallback("OverwriteAll")){interfaceControl.onPostCommandDialogOverwrite(true)}};break;case"Replace":oButtons[title]=function(){var fnCallback=this.callBacks.Replace;if(!fnCallback||fnCallback("Replace")){interfaceControl.onPostCommandDialogOverwrite(false)}};break;case"ReplaceAll":oButtons[title]=function(){var fnCallback=this.callBacks.ReplaceAll;if(!fnCallback||fnCallback("ReplaceAll")){interfaceControl.onPostCommandDialogOverwrite(true)}};break}}return callBacks};var showDialogErrorButtons=function(bShow,strButtons){var container=this.parentNode;if(!container){return}if(strButtons==undefined){if(bShow){strButtons="Skip,SkipAll,Retry"}else{strButtons="Skip,SkipAll,Retry,Overwrite,OverwriteAll"}}var arButtons=strButtons.split(",");var cmd=(bShow)?"show":"hide";for(var i=0;i<arButtons.length;i++){var btn=$(container).find("button:contains('"+translate(arButtons[i])+"')");$(btn)[cmd]()}};this.showPleaseWait=function(strDLGId,bShow,bEnableOK){var dlg=$(strDLGId);var elText=$(dlg).find("div.DialogWaitText");if(bShow){$(elText).html(translate("PleaseWait"));$(elText).show()}else{$(elText).html("");$(elText).hide()}showOKButton(strDLGId,bEnableOK)};var showOKButton=this.showOKButton=function(strDLGId,bEnableOK){if(bEnableOK!=undefined){var dlgParent=$(strDLGId).parent("div");if(bEnableOK){showButton(strDLGId,"Ok",true);$(dlgParent).find("a.ui-dialog-titlebar-close").show()}else{showButton(strDLGId,"Ok",false);$(dlgParent).find("a.ui-dialog-titlebar-close").hide()}}};var showButton=function(strDLGId,btnLabel,bShow){var dlgParent=$(strDLGId).parent("div");var btn=$(dlgParent).find("button:contains('"+translate(btnLabel)+"')");if(bShow){$(btn).show()}else{$(btn).hide()}};this.showSimpleError=function(strDLGId,strError,strErrorInfo,bEnableOK){if(strErrorInfo==undefined){strErrorInfo=""}self.showPleaseWait(strDLGId,false);var dlgParent=$(strDLGId).parent("div");var btnCancel=$(dlgParent).find("button:contains('"+translate("Cancel")+"')");$(btnCancel).find("span.ui-button-text").html(translate("Close"));var dlg=$(strDLGId);var elErrorSpan=$(dlg).find("div.DialogErrorText");if(strError!=undefined&&strError.length>0){var txtError="<b>"+translateError("Error")+"</b> "+translateError(strError)+"<br/>"+translateError(strErrorInfo);$(elErrorSpan).html(txtError);$(elErrorSpan).show()}else{$(elErrorSpan).html("");$(elErrorSpan).hide()}showOKButton(strDLGId,bEnableOK)};this.showMetaCMDDlg=function(fnCancel){var oButtons=new Object();var callBacks=createDefaultDialogButtons(oButtons,[["Cancel",fnCancel],"Skip","Retry"]);var oOptions={width:480,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_metacmd",oOptions);ret.callBacks=callBacks;ret.showErrorButtons=showDialogErrorButtons;ret.showErrorButtons(false)};this.showDeleteFilesDlg=function(fnOK,fnCancel,bFromTrash,oPassThrough,bShift){var oButtons=new Object();oButtons[translate("Yes")]=function(evt){var dlg=$("#FSIDialog_dlg_delete");var dlgParent=$(this).parent("div");$(dlgParent).find("button:contains('"+translate("Yes")+"')").hide();$(dlgParent).find("a.ui-dialog-titlebar-close").hide();$("#FSIDialog_dlg_delete").dialog("option","title",translate("PleaseWait"));var bResult=fnOK(dlg,oPassThrough,bShift);if(bResult){$("#dlgdeletebody2").show();$("#dlgdeletebody1").hide();$("#dlgdeletebody1Trash").hide();$("#innerDeleteProgress").css("width","0px")}else{$(this).dialog("close")}};var callBacks=createDefaultDialogButtons(oButtons,[["Cancel",fnCancel],"SkipAll","Skip","Retry"]);var oOptions={width:480,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_delete",oOptions);ret.callBacks=callBacks;if(bFromTrash||bShift){$("#dlgdeletebody1").hide()}else{$("#dlgdeletebody1Trash").hide()}$("#dlgdeletebody2").hide();ret.showErrorButtons=showDialogErrorButtons;ret.showErrorButtons(false);return ret};this.showRestoreItemsDlg=function(fnOK,fnCancel){var oButtons=new Object();oButtons[translate("Yes")]=function(evt){var dlg=$("#FSIDialog_dlg_restore");var dlgParent=$(this).parent("div");$(dlgParent).find("button:contains('"+translate("Yes")+"')").hide();$(dlgParent).find("a.ui-dialog-titlebar-close").hide();$("#FSIDialog_dlg_restore").dialog("option","title",translate("PleaseWait"));var bResult=fnOK(dlg);if(bResult){$("#dlgrestorebody2").show();$("#dlgrestorebody1").hide();$("#innerDeleteProgress").css("width","0px")}else{$(this).dialog("close")}};var callBacks=createDefaultDialogButtons(oButtons,[["Cancel",fnCancel],"SkipAll","Skip","Retry"]);var oOptions={width:480,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_restore",oOptions);ret.callBacks=callBacks;$("#dlgrestorebody1").show();$("#dlgrestorebody2").hide();ret.showErrorButtons=showDialogErrorButtons;ret.showErrorButtons(false);return ret};this.showMoveFilesDlg=function(fnOK,fnCancel,oPassThrough,strTargetDir,bPasteToDifferentFolder){if(oPassThrough.oClipboard==undefined){return}var oButtons=new Object();oButtons[translate("Yes")]=function(evt){var dlg=$("#FSIDialog_dlg_move");var dlgParent=$(this).parent("div");$(dlgParent).find("button:contains('"+translate("Yes")+"')").hide();$(dlgParent).find("a.ui-dialog-titlebar-close").hide();$("#FSIDialog_dlg_move").dialog("option","title",translate("PleaseWait"));var bResult=fnOK(dlg,oPassThrough);if(bResult){$("#dlgmovebody2").show();$("#dlgmovebody1").hide();$("#innerMoveProgress").css("width","0px")}else{$(this).dialog("close")}};var callBacks=createDefaultDialogButtons(oButtons,[["Cancel",fnCancel],"SkipAll","Skip","Retry","OverwriteAll","Overwrite"]);var oOptions={width:760,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_move",oOptions);ret.callBacks=callBacks;var bCopy=(oPassThrough.oClipboard.strMode=="copy");var text;if(bPasteToDifferentFolder){text=translate("dlgMoveBodyTarget",true);text=text.replace(/\[\.\.\.\]/,"<b>/"+strTargetDir+"</b>")}else{text=translate("dlgMoveBody",true)}$("#dlgmovebodytext").html(text);$("#dlgmovebody1").show();$("#dlgmovebody2").hide();ret.showErrorButtons=showDialogErrorButtons;ret.showErrorButtons(false);if(bCopy){$("#dlgMoveBody2Span").html(translate("dlgCopyBody2",true));oButtons[translate("Yes")]();var dlgParent=$(ret).parent("div");$(dlgParent).find("button:contains('"+translate("Yes")+"')").hide()}else{$("#dlgMoveBody2Span").html(translate("dlgMoveBody2",true))}return ret};this.showReimportDlg=function(fnOK,fnCancel,oPassThrough){var oButtons=new Object();oButtons[translate("Yes")]=function(evt){var dlg=$("#FSIDialog_dlg_reimport");var cbs=$("#dlgreimportbody1 input:checked");var arSelected=new Array();for(var i=0;i<cbs.length;i++){arSelected.push($(cbs).eq(i).attr("value"))}var dlgParent=$(this).parent("div");$(dlgParent).find("button:contains('"+translate("Yes")+"')").hide();$(dlgParent).find("a.ui-dialog-titlebar-close").hide();$("#FSIDialog_dlg_reimport").dialog("option","title",translate("PleaseWait"));var bResult=fnOK(dlg,oPassThrough,arSelected);if(bResult){$("#dlgreimportbody2").show();$("#dlgreimportbody1").hide();$("#innerReimportProgress").css("width","0px")}else{$(this).dialog("close")}};var callBacks=createDefaultDialogButtons(oButtons,[["Cancel",fnCancel],"SkipAll","Skip","Retry"]);var oOptions={width:480,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_reimport",oOptions);ret.callBacks=callBacks;$("#dlgreimportbody1").show();$("#dlgreimportbody2").hide();ret.showErrorButtons=showDialogErrorButtons;ret.showErrorButtons(false);var strConnectorType=ic.getCurrentConnectorType();if(!ic.getConnectorPermission("tasks","reimportFiles")||strConnectorType!="STORAGE"){$("#dlgreimportbody1 input[name='image']").removeAttr("checked").attr("disabled","disabled").parent().next().addClass("ui-state-disabled")}if(!ic.getConnectorPermission("write","extendedMetadata")){$("#dlgreimportbody1 input[name='metadata']").removeAttr("checked").attr("disabled","disabled").parent().next().addClass("ui-state-disabled")}var triggerClick=function(){$(this).parent().find("input").trigger("click")};$("#dlgreimportbody1 TR").each(function(){$(this).find("TD").eq(1).click(triggerClick)});var dlg=$("#FSIDialog_dlg_reimport");setDefaultButton(dlg,$(dlg).get(0),"Yes");return ret};this.showCreateFolderDlg=function(fnOK,oPassThrough){var oButtons=new Object();oButtons[translate("Ok")]=function(){var dlg=$("#FSIDialog_dlg_createfolder");var elInput=$(dlg).find("input.fsidialoginput");$(elInput).blur();$(elInput).attr("disabled",true);var strNameEntered=$(elInput).val();var elErrorSpan=$(dlg).find("div.DialogErrorText");$(elErrorSpan).hide();if(strNameEntered.length<1){$(elInput).focus();return}if(checkFolderName(strNameEntered)){fnOK(strNameEntered,oPassThrough)}else{$(elErrorSpan).html(getDlgError("InvalidFilenameCharacters"));$(elErrorSpan).show();$(elInput).attr("disabled",false);$(elInput).focus()}};oButtons[translate("Cancel")]=function(){$(this).dialog("close")};var oOptions={width:420,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_createfolder",oOptions);var dlg=$("#FSIDialog_dlg_createfolder");var elInput=$(dlg).find("input.fsidialoginput").get(0);$(elInput).get(0).focus();setDefaultButton(dlg,elInput,"Ok");return ret};this.showRenameDlg=function(fnOK,fnCancel,entry,strCurrentName,oProcessStruct){if(entry==undefined||strCurrentName==undefined||strCurrentName.length<1){return false}var oButtons=new Object();oButtons[translate("Ok")]=function(){var dlg=$("#FSIDialog_dlg_rename");var elInput=$(dlg).find("input.fsidialoginput");$(elInput).blur();var strNameEntered=$(elInput).val();var elErrorSpan=$(dlg).find("div.DialogErrorText");$(elErrorSpan).hide();if(strNameEntered.length<1){setInputFocusIEsafe(elInput);return}$(elInput).attr("disabled",true);if(checkFolderName(strNameEntered)){fnCancel=undefined;oOptions.callBack=undefined;fnOK(entry,strCurrentName,strNameEntered,oProcessStruct)}else{$(elErrorSpan).html(getDlgError("InvalidFilenameCharacters"));$(elErrorSpan).show();$(elInput).attr("disabled",false);setInputFocusIEsafe(elInput)}};oButtons[translate("Cancel")]=function(){$(this).dialog("close")};var oOptions={width:420,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons,callBack:fnCancel,callBackParam:oProcessStruct};var ret=self.showDialog("dlg_rename",oOptions);$("#FSIDialog_dlg_rename").find("input.fsidialoginput").val(strCurrentName);var dlg=$("#FSIDialog_dlg_rename");var elInput=$(dlg).find("input.fsidialoginput").get(0);setDefaultButton(dlg,elInput,"Ok");setInputFocusIEsafe(elInput);return ret};var setInputFocusIEsafe=function(el){if(!el){return}if(browser.isIE){setTimeout(function(){setInputFocusIE(el)},50)}else{el.focus()}};var setInputFocusIE=function(el){if(!el){return}el.focus();if(document.selection&&el.value){var oSel=document.selection.createRange();oSel.moveStart("character",el.value.length);oSel.moveEnd("character",0);oSel.select()}};var checkFolderName=function(strName){if(!strName){return false}var n=strName.search(/[\x00-\x1F\"\\\/:\*\?<>|]/);var ret=(n==-1)?true:false;return ret};this.showAlert=function(message,title,strUntranslated,callBackOk,paramModalopacity){if(!message||message.length<0){return}if(paramModalopacity==undefined){paramModalopacity=modalopacityDefault}if(strUntranslated==undefined){strUntranslated=""}else{strUntranslated="<br/>"+strUntranslated}var oButtons=new Object();oButtons[translate("Ok")]=function(){$(this).dialog("close")};var oOptions={width:420,bgiframe:true,modal:true,modalopacity:paramModalopacity,resizable:false,draggable:true,buttons:oButtons,callBack:callBackOk,zIndex:2000};if(title!=undefined){oOptions.title=translateError(title)}var ret=self.showDialog("dlg_alert",oOptions);var dlg=$("#FSIDialog_dlg_alert");var dlgParent=$(dlg).parent("div");var elBtn=$(dlgParent).find("button:contains('"+translate("Ok")+"')").get(0);if(elBtn){elBtn.focus()}$("#DLGAlertMessage").html(translateError(message)+strUntranslated);return ret};this.showCustom=function(message,title,strUntranslated,oButtons,paramModalopacity){if((!message||message.length<0)&&(!strUntranslated||strUntranslated.length<0)){return}if(paramModalopacity==undefined){paramModalopacity=modalopacityDefault}if(strUntranslated==undefined){strUntranslated=""}if(oButtons==undefined){oButtons=new Object();oButtons[translate("Ok")]=function(){$(this).dialog("close")}}var oOptions={width:680,bgiframe:true,modal:true,modalopacity:paramModalopacity,resizable:false,draggable:true,buttons:oButtons,zIndex:2001};var ret=self.showDialog("dlg_yesnocancel",oOptions);var dlg=$("#FSIDialog_dlg_yesnocancel");var dlgParent=$(dlg).parent("div");var elBtn=$(dlgParent).find("button:contains('"+translate("Ok")+"')").get(0);if(elBtn){elBtn.focus()}if(title!=undefined){$("#FSIDialog_dlg_yesnocancel").dialog("option","title",title)}$("#DLGYesNoCancelMessage").html(translateError(message)+strUntranslated);return ret};this.showCancelDlg=function(fnCancel,oData){var oButtons=new Object();oButtons[translate("Cancel")]=function(){fnCancel(oData);$(this).dialog("close")};var oOptions={width:400,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:false,buttons:oButtons};return self.showDialog("dlg_canceloperation",oOptions)};this.closeCancelDlg=function(){var dlg=$("#FSIDialog_dlg_canceloperation");if(dlg.length>0&&$(dlg).dialog){$(dlg).dialog("close")}};this.showUploadHTMLDlg=function(fnOK,fnCancel){var oButtons=new Object();oButtons[translate("Ok")]=function(){fnOK()};oButtons[translate("Cancel")]=function(){fnCancel();$(this).dialog("close")};var oOptions={width:760,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons,callBack:fnCancel};var ret=self.showDialog("dlg_uploadhtml",oOptions);return ret};this.showFileUploadErrorDlg=function(fnClose,fnCallback,html,bShowOverwrite,bShowRetry,bShowSkip){var oOptions={NELAnoAutoDestroy:true,width:760,position:[0,0],closeOnEscape:true,autoOpen:false,bgiframe:true,modal:false,modalopacity:modalopacityDefault,stack:false,resizable:false,draggable:true,callBack:fnClose};var ret=self.showDialog("dlg_uploaderror",oOptions);var elDialog=$(".ui-dialog").filter(":parent");var dlg=$("#FSIDialog_dlg_uploaderror");ret.elDialog=elDialog;var elDialog=$(elDialog).detach();$(elDialog).appendTo($("#pictureView_UploadContainer"));$(elDialog).attr("id","DialogUploadError");return ret};this.showSelectListColumnsDlg=function(oTextList){if(!oTextList){return}var oListInputs=new Object();var oButtons=new Object();oButtons[translate("Ok")]=function(){for(var o in oListInputs){var chk=$(oListInputs[o]).is(":checked");if(oList[o]!="disabled"){oList[o]=chk}}$(this).dialog("close");oTextList.setColumnVisibility(oList)};oButtons[translate("Cancel")]=function(){$(this).dialog("close")};var oOptions={bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_selectcolumns",oOptions);var triggerClick=function(){$(this).parent().find("input").trigger("click")};var elTemplate=$(ret).find("TR").get(0);var oList=oTextList.getColumnVisibility();for(var o in oList){var row=elTemplate.cloneNode(true);var cols=$(row).find("TD");$(cols[1]).html(o);$(cols[1]).click(triggerClick);oListInputs[o]=$(cols[0]).find("input");switch(oList[o]){case"disabled":$(oListInputs[o]).attr("disabled","disabled");case true:$(oListInputs[o]).attr("checked","checked");break}elTemplate.parentNode.appendChild(row)}$(elTemplate).hide();return ret};this.showAddMetaDataFieldDlg=function(oMetaData,fnOK){if(!oMetaData){return}var oButtons=new Object();oButtons[translate("Ok")]=function(){var arFieldNames=new Array();$("#FSIDialog_dlg_addMetaDataField input:checked").each(function(){var name=$(this).closest("TR").attr("FSIFieldName");arFieldNames.push(name)});$(this).dialog("close");fnOK(arFieldNames)};oButtons[translate("Cancel")]=function(){$(this).dialog("close")};var oOptions={height:getRelativeHeight(90,200),width:660,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_addMetaDataField",oOptions);var triggerClick=function(){$(this).parent().find("input").trigger("click")};var body=$(ret).find("TBODY").get(0);var metaDataFieldNames=ic.getPictureView().getMetaDataFieldNames();var htmlRows=metaDataFieldNames.getFieldRows(oMetaData);$(body).html(htmlRows);$("#FSIDialog_dlg_addMetaDataField").css("overflow","hidden");$(body).find("td.metaDataFieldValue").click(triggerClick);new ic.checkBoxSelectRange("addMetaDataFieldTable");return ret};this.showDownloadOptions=function(ctrl,fnOK,strConfigName,opts,bBatch){var oButtons=new Object();oButtons[translate("Ok")]=function(){fnOK();$(this).dialog("close")};oButtons[translate("Cancel")]=function(){$(this).dialog("close")};var oOptions={height:500,width:640,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var onDownloadSettingsChanged=function(el){ctrl.setDownloadOptionsDirty(true);$("#btnSaveDownloadOptions").removeAttr("disabled")};var ret=self.showDialog("dlg_downloadOptions",oOptions);$("#cbDownloadOriginal").change(DownloadOptionsRenderedImageChange);$("#cbDownloadRenderedImage").change(DownloadOptionsRenderedImageChange);$("#FSIDialog_dlg_downloadOptions textarea,select,input[type='text'],input[type='radio']").change(onDownloadSettingsChanged).keyup(onDownloadSettingsChanged);$("#inputDownloadPresetSaveName").val(strConfigName);var triggerClick=function(){$(this).parent().find("input").trigger("click")};$("#FSIDialog_dlg_downloadOptions input[name='dlopt_generaltype']").parent().next().click(triggerClick);if(opts.archivetype!=undefined){var elSelect=$("#dlopt_archivetype").get(0);if(elSelect){for(var i=0;i<elSelect.options.length;i++){if(elSelect.options[i].value==opts.archivetype){elSelect.selectedIndex=i;break}}}}if(bBatch){$("#inputRenderingQuery").val(opts.renderingquery);$("#cbDownloadRenderedImage").trigger("click");ctrl.setDownloadOptionsDirty(false);$("#btnSaveDownloadOptions").attr("disabled","disabled")}else{if(!opts){$("#inputRenderingQuery").val("type=image&renderer=jpeg&quality=95&width=480&height=320")}}$("#cbDownloadRenderedImage").attr("disabled","disabled");var elSelect=$("#dlopt_fileExtensions").get(0);if(elSelect){if(opts&&opts.appendfileextension=="1"){elSelect.selectedIndex=1}}if(opts&&opts.bSystem){$("#btnDeleteDownloadOptions").attr("disabled","disabled")}$("#btnDeleteDownloadOptions").click(function(){ctrl.downloadOptionsCommand("delete")});$("#btnSaveDownloadOptions").click(function(){ctrl.downloadOptionsCommand("save")});return ret};var DownloadOptionsRenderedImageChange=function(evt){var value=$("#FSIDialog_dlg_downloadOptions input[name=dlopt_generaltype]:checked").val();if(value=="images"){$("#dlopt_fileExtensions").removeAttr("disabled");$("#inputRenderingQuery").removeAttr("disabled");if($("#inputRenderingQuery").val()==""){$("#inputRenderingQuery").val("type=image&renderer=jpeg&quality=95&width=480&height=320")}$("#inputRenderingQuery").focus()}else{$("#dlopt_fileExtensions").attr("disabled","disabled");$("#inputRenderingQuery").attr("disabled","disabled")}};this.showJobCMDDlg=function(fnCancel,strBody){var oButtons=new Object();oButtons[translate("Cancel")]=function(){fnCancel()};var oOptions={height:260,width:420,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_jobquecmd",oOptions);$("#dlgjobqueuecmdtext").html(translate(strBody))};this.showDownloadConflictDlg=function(ctl,src){var oButtons=new Object();var fn=ctl.onConflictDlgResult;var callBacks=createDefaultDialogButtons(oButtons,[["Cancel",fn],["SkipAll",fn],["Skip",fn],["ReplaceAll",fn],["Replace",fn]]);var oOptions={width:680,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_downloadconflict",oOptions);ret.callBacks=callBacks;var text=translate("dlgDownloadConflictBody",true);text=text.replace(/\[\.\.\.\]/,"<b>"+src+"</b>");$("#dlg_downloadconflicttext").html(text);ret.showErrorButtons=showDialogErrorButtons;ret.showErrorButtons(true,"Skip,SkipAll,Replace,ReplaceAll");return ret};var getRelativeHeight=function(percent,min){if(isNaN(percent)||percent<1||percent>100){return min}var h=Math.round(ic.getWindowSize().height*percent/100);if(isNaN(h)){return min}return h};this.showBrowseDlg=function(oBrowseOptions,oPassThrough){this.oBrowseOptions=oBrowseOptions;if(oBrowseOptions==undefined||oBrowseOptions.listURL==undefined){return}if(oBrowseOptions.path==undefined){oBrowseOptions.path=""}if(oBrowseOptions.labelOK==undefined){oBrowseOptions.labelOK="Ok"}var oButtons=new Object();oButtons[translateComponent(oBrowseOptions.labelOK)]=function(){var node=browseTree.getActiveNode();var strPath="";if(!node||!node.data){return}strPath=node.getPath();if(oBrowseOptions.inputFilename){var strName=$("#dlgBrowseInputFilename").val();if(strName.length<1){if(oBrowseOptions.fileRequired&&node.data.isFolder){return}}else{strPath=strPath.split("/");if(!node.data.isFolder){strPath.pop()}strPath.push(strName);strPath=strPath.join("/")}}else{if(oBrowseOptions.fileRequired&&node.data.isFolder){return}}this.oBrowseOptions=browseTree=undefined;$(this).dialog("close");if(oBrowseOptions.fnOK){oBrowseOptions.fnOK(strPath,oPassThrough)}};oButtons[translate("Cancel")]=function(){this.oBrowseOptions=browseTree=undefined;$(this).dialog("close")};var oOptions={title:oBrowseOptions.title,bgiframe:true,width:660,height:getRelativeHeight(80,200),modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_browse",oOptions);if(!oBrowseOptions.inputFilename){$("#dlgBrowseFilenameRow").hide()}var buttons=3;if(!oBrowseOptions.buttonRename){$("#dlgBrowseButtonRename").hide();buttons--}if(!oBrowseOptions.buttonDelete){$("#dlgBrowseButtonDelete").hide();buttons--}if(!oBrowseOptions.buttonCreateFolder){$("#dlgBrowseButtonCreateFolder").hide();buttons--}if(buttons<1){$("#dlgBrowseButtons").hide()}var el=$("#dlgbrowselisttd").get(0);if(el&&el.offsetHeight){$("#dlgbrowsetree").css("height",el.offsetHeight+"px")}initBrowseTree(oBrowseOptions.listURL,oBrowseOptions.path,oBrowseOptions);if(oBrowseOptions){if(oBrowseOptions.bSave){$("#dlgBrowseInputFilename").focus()}if(oBrowseOptions.strPrefill){$("#dlgBrowseInputFilename").value(strPrefill)}}return ret};this.BrowseDialogCMD=function(cmd){var fullsrc="";var path="";var name="";if(browseTree==undefined||browseTree.getActiveNode==undefined){return}var node=browseTree.getActiveNode();if(node&&node.data){var type=(node.data.isFolder)?"directory":"file";var t=this.oBrowseOptions.path;if(t.length>0&&t.lastIndexOf("/")!=t.length-1){t+="/"}fullsrc=t+node.getPath();if(fullsrc.length>0&&fullsrc.lastIndexOf("/")==fullsrc.length-1){fullsrc=fullsrc.split("/");fullsrc.pop();fullsrc=fullsrc.join("/")}var t=fullsrc.split("/");if(t.length>0){var name=t.pop();if(name.length==0){name=t.pop()}path=t.join("/");if(path.length>0&&path.lastIndexOf("/")!=path.length-1){path+="/"}}}switch(cmd){case"createFolder":var newPath=path.split("/");if(node&&node.data&&!node.data.isFolder){newPath.pop()}newPath.push("newfolder");newPath=newPath.join("/");var bp=this.oBrowseOptions.path;if(bp.length>0&&bp.lastIndexOf("/")!=bp.length-1){bp+="/"}ic.askCreateDirectoryFromTree(node,browseTree,bp);break;case"delete":if(node==undefined||node.data==undefined||path.length<1){return}if(node.data.key=="root"){return}ic.askDeleteSelectedFromTree(node,fullsrc,name,browseTree,type);break;case"rename":if(node==undefined||node.data==undefined||path.length<1){return}if(node.data.key=="root"){return}var namewithoutsuffix;if(type!="directory"){namewithoutsuffix=name.split(".");if(namewithoutsuffix.length>0){namewithoutsuffix.pop()}namewithoutsuffix=namewithoutsuffix.join(".")}else{namewithoutsuffix=name}ic.askRenameSelectedFromTree(node,browseTree,fullsrc,namewithoutsuffix,type);break}};var initBrowseTree=function(listURL,startPath,oBrowseOptions){if(oBrowseOptions.basePath!=undefined){startPath=oBrowseOptions.basePath+startPath}var oRootNode;if(startPath.length<1||startPath=="/"){oRootNode=ic.getFolderTree().getRootNodeObject()}else{var t=startPath;if(t.indexOf("_viewers")==0){t=t.split("_viewers").join("FSI Viewer")}else{if(t.indexOf("_configs")==0){t=t.split("_configs").join("FSI Configs")}}var oRootNode={title:t,connectorType:"ROOT",key:"root"}}if(startPath.lastIndexOf("/")!=startPath.length-1){startPath+="/"}var filterChildNodes=function(data){if(data&&data.length>0){if(oBrowseOptions.regFilterFiles){var reg=oBrowseOptions.regFilterFiles.regEx;var bRemoveNoMatch=!oBrowseOptions.regFilterFiles.bRemoveNoMatch;for(var i=data.length-1;i>-1;i--){var child=data[i];if(!child.isFolder&&!child.isLazy){var oMatch=child.title.match(reg);var bRemove=(bRemoveNoMatch==(oMatch!=null));if(bRemove){data.splice(i,1)}}}}}};$(function(){$("#dlgbrowsetree").dynatree({oRootNode:oRootNode,rootVisible:true,persist:false,autoCollapse:false,autoFocus:false,fx:null,debugLevel:0,ajaxDefaults:{cache:true,dataType:"json",ifModified:false},initAjax:{url:listURL,data:{source:startPath},beforeSuccessHandler:function(dtnode,data){if(oBrowseOptions.regFilterFiles){filterChildNodes(data)}},afterSuccessHandler:function(dtnode){var tree=$("#dlgbrowsetree").dynatree("getTree");if(!oBrowseOptions||(!oBrowseOptions.filter&&!oBrowseOptions.connectorTypeFilter&&!oBrowseOptions.strInitialPath)){return}if(!oBrowseOptions.connectorTypeFilter){oBrowseOptions.connectorTypeFilter={}}if(!oBrowseOptions.filter){oBrowseOptions.filter={}}if(dtnode&&dtnode.childList){var arDelete=new Array();for(var i=0;i<dtnode.childList.length;i++){var node=dtnode.childList[i];if(oBrowseOptions.filter[node.data.title]||oBrowseOptions.connectorTypeFilter[node.data.connectorType]){arDelete.push(node)}}for(var i=0;i<arDelete.length;i++){arDelete[i].remove()}}if(oBrowseOptions.strInitialPath&&oBrowseOptions.strInitialPath.length>0){tree.expandToPath(oBrowseOptions.strInitialPath)}}},strings:{loading:"Loading...",loadError:"error loading content"},onLazyRead:function(dtnode){var nodePath=dtnode.getPath();dtnode.appendAjax({url:listURL,data:{source:startPath+nodePath},beforeSuccessHandler:function(dtnode,data){if(oBrowseOptions.regFilterFiles){filterChildNodes(data)}}})},onDblClick:function(dtnode,evt){var btn=$("#FSIDialog_dlg_browse").parent().find("div.ui-dialog-buttonset").find("button:contains('"+translateComponent(oBrowseOptions.labelOK)+"')");$(btn).trigger("click")},onActivate:function(dtnode,bByUser){if(oBrowseOptions.fileRequired&&dtnode.data.isFolder){return}$("#dlgBrowseInputFilename").val(dtnode.data.title)}})});browseTree=$("#dlgbrowsetree").dynatree("getTree")};this.showPasswordDlg=function(fnOK){var oButtons=new Object();oButtons[translate("Ok")]=function(){if(!fnOK()){return}$(this).dialog("close")};oButtons[translate("Cancel")]=function(){$(this).dialog("close")};var oOptions={width:420,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_changepassword",oOptions);var dlg=$("#FSIDialog_dlg_changepassword");setDefaultButton(dlg,$(dlg).get(0),"Ok");return ret};this.showChangeUserDlg=function(fnOK){var oButtons=new Object();oButtons[translate("Ok")]=function(){var userName=$("#FSIDialog_dlg_changeuser select").eq(0).val();if(!userName||userName.length<1){return}$("#FSIDialog_dlg_changeuser").dialog("close");fnOK(userName)};oButtons[translate("Cancel")]=function(){$(this).dialog("close")};var oOptions={width:420,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_changeuser",oOptions);var elSelect=$("#FSIDialog_dlg_changeuser select").get(0);ic.getLogin().fillUserSelect(elSelect);var dlg=$("#FSIDialog_dlg_changeuser");if(elSelect&&elSelect.selectedIndex){elSelect.selectedIndex=0;elSelect.focus()}if(!elSelect||elSelect.options.length<1){var btnOK=$(dlg).parent("div").find("button:contains('"+translate("Ok")+"')");$(btnOK).hide();setDefaultButton(dlg,$(dlg).get(0),"Cancel")}else{$("#FSIDialog_dlg_changeuser select").eq(0).dblclick(function(){oButtons[translate("Ok")]()});setDefaultButton(dlg,$(dlg).get(0),"Ok")}return ret};this.showEnterTextDlg=function(strTitle,fnOK){var oButtons=new Object();oButtons[translate("Ok")]=function(){var str=$("#FSIDialog_dlg_entertext textarea").eq(0).val();if(fnOK){fnOK(str)}$("#FSIDialog_dlg_entertext").dialog("close")};oButtons[translate("Cancel")]=function(){$(this).dialog("close")};var oOptions={title:strTitle,width:580,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_entertext",oOptions);var elTextarea=$("#FSIDialog_dlg_entertext textarea").get(0);var dlg=$("#FSIDialog_dlg_entertext");if(elTextarea){elTextarea.focus()}return ret};this.showEnterPIDDlg=function(strTitle,fnOK){var bErrorVisible=false;var oButtons=new Object();oButtons[translate("Ok")]=function(){var str=$("#FSIDialog_dlg_enterpid input").eq(0).val();console.log("PID: "+str);var ok=false;if(str.length>0){var t=str.split("-");var nEnd=Math.min(16,t.length);if(t.length>3){ok=true}for(var i=0;i<nEnd;i++){if(t[i].length!=4){ok=false;break}}}if(!ok){var el=$("#FSIDialog_dlg_enterpid input").get(0);if(el){bErrorVisible=true;$("#pidInputError").css("visibility","visible");el.selectionStart=4*i+(i);el.selectionEnd=el.selectionStart+t[i].length}return}if(fnOK){fnOK(str)}$("#FSIDialog_dlg_enterpid").dialog("close")};oButtons[translate("Cancel")]=function(){$(this).dialog("close")};var bAddedHyphen;var oOptions={title:strTitle,width:580,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_enterpid",oOptions);$("#pidInputError").css("visibility","hidden");var el=$("#FSIDialog_dlg_enterpid input").get(0);var dlg=$("#FSIDialog_dlg_enterpid");if(el){$(el).mousedown(function(evt){if(bErrorVisible){$("#pidInputError").css("visibility","hidden")}});$(el).keyup(function(evt){var evt=(evt||window.event);var key=(evt.keyCode||evt.which);if(!bAddedHyphen){return true}if(evt.ctrlKey||evt.altKey){return true}if(key<48&&key!=32){return true}var val=$(this).val();if(this.selectionStart<val.length){return}if(val.indexOf("--")==val.length-2){val=val.substr(0,val.length-1);$(this).val(val)}});$(el).keydown(function(evt){if(bErrorVisible){$("#pidInputError").css("visibility","hidden")}bAddedHyphen=false;var evt=(evt||window.event);var key=(evt.keyCode||evt.which);if(key==13){oButtons[translate("Ok")]()}if(key==27){oButtons[translate("Cancel")]()}if(evt.ctrlKey||evt.altKey){return true}if(key<48&&key!=32){return true}var val=$(this).val();if(this.selectionStart<val.length){return}var t=val.split("-");if(t[t.length-1].length>3){t[t.length-1]+="-";bAddedHyphen=true;var newVal=t.join("-").toUpperCase();$(this).val(newVal)}});el.focus()}return ret};this.showConnectorInfoDlg=function(){var oButtons=new Object();oButtons[translate("Ok")]=function(){$(this).dialog("close")};var strTitle="Source Connector Properties";var heightDLG=getRelativeHeight(90,200);var heightDiv=$("#dlgConnectorInfoContentDiv").css("height");$("#dlgConnectorInfoContentDiv").css("height",heightDiv+"px");var oOptions={title:strTitle,width:520,height:heightDLG,bgiframe:true,modal:true,modalopacity:modalopacityDefault,resizable:false,draggable:true,buttons:oButtons};var ret=self.showDialog("dlg_connectorInfo",oOptions);var rows=$("#dlgConnectorInfoContentTable").find("tr");var rowTemplate=rows[1];var headerTemplate=rows[2];var parent=$(headerTemplate).parent();var oOrgInfo=ic.getCurrentConnectorInfo();var oInfo={};var strTotalFiles=ic.makeNiceInt(oOrgInfo.nTotalFilesVisible);var oPermissions;var oPublicPermissions;for(var o in oOrgInfo){if(o.charAt(0)=="_"){}else{switch(o){case"connectorName":if(!oInfo.Name){oInfo.Name=oOrgInfo[o];oInfo["Total Files"]=strTotalFiles}break;case"displayTitle":oInfo.Name=oOrgInfo[o];oInfo["Total Files"]=strTotalFiles;break;case"nTotalFilesVisible":case"nTotalFiles":case"properties":break;case"permissions":oPermissions=oOrgInfo[o];break;case"publicPermissions":oPublicPermissions=oOrgInfo[o];break;default:oInfo[o]=oOrgInfo[o]}}}function addHeadline(str){var newRow=$(headerTemplate).clone();var tds=$(newRow).find("td");$(tds[0]).text(capitalize(str));$(parent).append(newRow)}function addRow(str1,str2,str3,type2,type3){var newRow=$(rowTemplate).clone();var tds=$(newRow).find("td");$(tds[0]).text(capitalize(str1));if(type2=="boolean"){if(str2===true){$(tds[1]).html("<font color='#39f'>✓</font>")}else{$(tds[1]).html("")}}else{$(tds[1]).text(str2)}if(tds[2]){if(type3=="boolean"){if(str3===true){$(tds[2]).html("<font color='#39f'>✓</font>")}else{$(tds[2]).html("")}}else{$(tds[2]).text(str3)}}$(parent).append(newRow)}function capitalize(str){if(str.length<1){return str}var c=""+str.charAt(0);var upper=c.toUpperCase();if(c!=upper){str=upper+str.substr(1)}return str}function addObjectRows(obj,obj2,bForceBoolean){var subObjects={};var subObjects2={};var val,type;var val2,type2;for(var o in obj){if(o.charAt(0)=="_"){continue}val=obj[o];type=typeof(val);if(obj2&&obj2[o]!=undefined){val2=obj2[o];type2=typeof(val2);if(type2=="object"){subObjects2[o]=val2}else{if(bForceBoolean){type2="boolean"}}}else{if(obj2&&bForceBoolean){val2=false;type2="boolean"}}if(type=="object"){subObjects[o]=val}else{if(bForceBoolean){type="boolean"}addRow(o,val,val2,type,type2)}}for(var o in subObjects){addHeadline(o);addObjectRows(subObjects[o],subObjects2[o],bForceBoolean)}}addHeadline("General");addObjectRows(oInfo);$(rows[1]).remove();$(rows[2]).remove();if(oPermissions){var rows=$("#dlgConnectorInfoContentTable2").find("tr");var rowTemplate=rows[1];var headerTemplate=rows[2];var parent=$(headerTemplate).parent();addObjectRows(oPermissions,oPublicPermissions,true);$(rows[1]).remove();$(rows[2]).remove()}else{$("#dlgConnectorInfoContentTable2").remove()}if(1==0&&oOrgInfo.properties!=undefined){var rows=$("#dlgConnectorPropertiesContentTable").find("tr");var rowTemplate=rows[1];var headerTemplate=rows[2];var parent=$(headerTemplate).parent();addObjectRows(oOrgInfo.properties);$(rows[1]).remove();$(rows[2]).remove()}else{$("#dlgConnectorPropertiesContentTable").remove()}return ret};this.showUAMDlg=function(strURL,oData,fnCallback,oCallBackScope,theWindow){var oButtons=new Object();var originUAM=strURL;oData._initiator="FIS3";oData.fsi_server_interface=3;oButtons[translate("Cancel")]=function(evt){var dlg=$("#FSIDialog_dlg_UAM_login");$(this).dialog("close")};var dlgw=Math.min(window.innerWidth-40,820);var dlgh=Math.min(window.innerHeight-40,1024);var oOptions={width:dlgw,height:dlgh,bgiframe:true,modal:true,modalopacity:0.3,resizable:false,draggable:true,buttons:oButtons,onClose:function(){removeEvent(window,"message",onWindowMessage)}};var ret=self.showDialog("dlg_UAM_login",oOptions);var onWindowMessage=function(evt){var bCloseDialog=false;if(evt.origin==originUAM&&evt.data&&evt.data.cmd){var cmd=evt.data.cmd;var param=evt.data.data;var bCallCallback=false;switch(cmd){case"closeDialog":bCloseDialog=true;break;case"getKeyForThisPID":case"checkForUpdatedKey":bCallCallback=true;break;case"installKeyForPID":if(param.licence_content!=undefined){ic.getPictureView().doInstallNewLicence(param.licence_content);bCloseDialog=true}break}if(bCallCallback&&typeof(fnCallback)=="function"){if(oCallBackScope==undefined){oCallBackScope=theWindow}fnCallback.apply(oCallBackScope,[param])}}if(bCloseDialog){$("#FSIDialog_dlg_UAM_login").dialog("close")}};addEvent(theWindow,"message",onWindowMessage);var form=document.createElement("form");$(form).attr("action",strURL);$(form).attr("target","uam_login_frame");$(form).attr("method","post");$(form).css("display","none");var el=document.createElement("input");$(el).attr("type","text");$(el).attr("name","firstAction");$(el).val(JSON.stringify(oData));$(form).append(el);$("body").append(form);$(form).submit();$(form).remove();$("#FSIDialog_dlg_UAM_login").parent().addClass("fsi_white_dlg");return ret}};