/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp.pixelparsers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryInputStream;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.bmp.BmpHeaderInfo;

public abstract class PixelParser {
    public final BmpHeaderInfo bhi;
    public final byte[] colorTable;
    public final byte[] imageData;
    protected final BinaryInputStream is;

    public PixelParser(BmpHeaderInfo bhi, byte[] ColorTable, byte[] ImageData) {
        this.bhi = bhi;
        this.colorTable = ColorTable;
        this.imageData = ImageData;
        this.is = new BinaryInputStream(new ByteArrayInputStream(ImageData), ByteOrder.LITTLE_ENDIAN);
    }

    public abstract void processImage(ImageBuilder var1) throws ImageReadException, IOException;

    protected int getColorTableRGB(int index) {
        int blue = 0xFF & this.colorTable[(index *= 4) + 0];
        int green = 0xFF & this.colorTable[index + 1];
        int red = 0xFF & this.colorTable[index + 2];
        int alpha = 255;
        int rgb = 0xFF000000 | red << 16 | green << 8 | blue << 0;
        return rgb;
    }
}

