/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.common.IImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegConstants;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegUtils;
import org.apache.commons.imaging.formats.jpeg.decoder.JpegDecoder;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcParser;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.apache.commons.imaging.formats.jpeg.segments.App13Segment;
import org.apache.commons.imaging.formats.jpeg.segments.App14Segment;
import org.apache.commons.imaging.formats.jpeg.segments.App2Segment;
import org.apache.commons.imaging.formats.jpeg.segments.ComSegment;
import org.apache.commons.imaging.formats.jpeg.segments.DqtSegment;
import org.apache.commons.imaging.formats.jpeg.segments.GenericSegment;
import org.apache.commons.imaging.formats.jpeg.segments.JfifSegment;
import org.apache.commons.imaging.formats.jpeg.segments.Segment;
import org.apache.commons.imaging.formats.jpeg.segments.SofnSegment;
import org.apache.commons.imaging.formats.jpeg.segments.UnknownSegment;
import org.apache.commons.imaging.formats.jpeg.xmp.JpegXmpParser;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpegImageParser
extends ImageParser
implements JpegConstants {
    private static final String DEFAULT_EXTENSION = ".jpg";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".jpg", ".jpeg"};
    public static final boolean permissive = true;

    public JpegImageParser() {
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_JPEG};
    }

    @Override
    public String getName() {
        return "Jpeg-Custom";
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    public final BufferedImage getBufferedImage(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        JpegDecoder jpegDecoder = new JpegDecoder();
        return jpegDecoder.decode(byteSource);
    }

    private boolean keepMarker(int marker, int[] markers) {
        if (markers == null) {
            return true;
        }
        for (int marker2 : markers) {
            if (marker2 != marker) continue;
            return true;
        }
        return false;
    }

    public List<Segment> readSegments(ByteSource byteSource, final int[] markers, final boolean returnAfterFirst, boolean readEverything) throws ImageReadException, IOException {
        final ArrayList<Segment> result = new ArrayList<Segment>();
        final JpegImageParser parser = this;
        final int[] sofnSegments = new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487};
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            public boolean beginSOS() {
                return false;
            }

            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }

            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (!JpegImageParser.this.keepMarker(marker, markers)) {
                    return true;
                }
                if (marker == 65517) {
                    result.add(new App13Segment(parser, marker, segmentData));
                } else if (marker == 65518) {
                    result.add(new App14Segment(marker, segmentData));
                } else if (marker == 65506) {
                    result.add(new App2Segment(marker, segmentData));
                } else if (marker == 65504) {
                    result.add(new JfifSegment(marker, segmentData));
                } else if (Arrays.binarySearch(sofnSegments, marker) >= 0) {
                    result.add(new SofnSegment(marker, segmentData));
                } else if (marker == 65499) {
                    result.add(new DqtSegment(marker, segmentData));
                } else if (marker >= 65505 && marker <= 65519) {
                    result.add(new UnknownSegment(marker, segmentData));
                } else if (marker == 65534) {
                    result.add(new ComSegment(marker, segmentData));
                }
                return !returnAfterFirst;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return result;
    }

    private byte[] assembleSegments(List<App2Segment> v) throws ImageReadException {
        try {
            return this.assembleSegments(v, false);
        }
        catch (ImageReadException e) {
            return this.assembleSegments(v, true);
        }
    }

    private byte[] assembleSegments(List<App2Segment> v, boolean start_with_zero) throws ImageReadException {
        if (v.size() < 1) {
            throw new ImageReadException("No App2 Segments Found.");
        }
        int markerCount = v.get((int)0).num_markers;
        if (v.size() != markerCount) {
            throw new ImageReadException("App2 Segments Missing.  Found: " + v.size() + ", Expected: " + markerCount + ".");
        }
        Collections.sort(v);
        int offset = start_with_zero ? 0 : 1;
        int total = 0;
        for (int i = 0; i < v.size(); ++i) {
            App2Segment segment = v.get(i);
            if (i + offset != segment.cur_marker) {
                this.dumpSegments(v);
                throw new ImageReadException("Incoherent App2 Segment Ordering.  i: " + i + ", segment[" + i + "].cur_marker: " + segment.cur_marker + ".");
            }
            if (markerCount != segment.num_markers) {
                this.dumpSegments(v);
                throw new ImageReadException("Inconsistent App2 Segment Count info.  markerCount: " + markerCount + ", segment[" + i + "].num_markers: " + segment.num_markers + ".");
            }
            total += segment.icc_bytes.length;
        }
        byte[] result = new byte[total];
        int progress = 0;
        for (int i = 0; i < v.size(); ++i) {
            App2Segment segment = v.get(i);
            System.arraycopy(segment.icc_bytes, 0, result, progress, segment.icc_bytes.length);
            progress += segment.icc_bytes.length;
        }
        return result;
    }

    private void dumpSegments(List<? extends Segment> v) {
        Debug.debug();
        Debug.debug("dumpSegments", v.size());
        for (int i = 0; i < v.size(); ++i) {
            App2Segment segment = (App2Segment)v.get(i);
            Debug.debug(i + ": " + segment.cur_marker + " / " + segment.num_markers);
        }
        Debug.debug();
    }

    public List<Segment> readSegments(ByteSource byteSource, int[] markers, boolean returnAfterFirst) throws ImageReadException, IOException {
        return this.readSegments(byteSource, markers, returnAfterFirst, false);
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        List<Segment> segments = this.readSegments(byteSource, new int[]{65506}, false);
        ArrayList<App2Segment> filtered = new ArrayList<App2Segment>();
        if (segments != null) {
            for (int i = 0; i < segments.size(); ++i) {
                App2Segment segment = (App2Segment)segments.get(i);
                if (segment.icc_bytes == null) continue;
                filtered.add(segment);
            }
        }
        if (filtered.size() < 1) {
            return null;
        }
        byte[] bytes = this.assembleSegments(filtered);
        if (this.debug) {
            System.out.println("bytes: " + bytes.length);
        }
        if (this.debug) {
            System.out.println("");
        }
        return bytes;
    }

    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        TiffImageMetadata exif = this.getExifMetadata(byteSource, params);
        JpegPhotoshopMetadata photoshop = this.getPhotoshopMetadata(byteSource, params);
        if (null == exif && null == photoshop) {
            return null;
        }
        JpegImageMetadata result = new JpegImageMetadata(photoshop, exif);
        return result;
    }

    public static boolean isExifAPP1Segment(GenericSegment segment) {
        return JpegImageParser.startsWith(segment.bytes, EXIF_IDENTIFIER_CODE);
    }

    private List<Segment> filterAPP1Segments(List<Segment> v) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        for (int i = 0; i < v.size(); ++i) {
            GenericSegment segment = (GenericSegment)v.get(i);
            if (!JpegImageParser.isExifAPP1Segment(segment)) continue;
            result.add(segment);
        }
        return result;
    }

    public TiffImageMetadata getExifMetadata(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        byte[] bytes = this.getExifRawData(byteSource);
        if (null == bytes) {
            return null;
        }
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        if (!params.containsKey("READ_THUMBNAILS")) {
            params.put("READ_THUMBNAILS", Boolean.TRUE);
        }
        return (TiffImageMetadata)new TiffImageParser().getMetadata(bytes, params);
    }

    public byte[] getExifRawData(ByteSource byteSource) throws ImageReadException, IOException {
        List<Segment> segments = this.readSegments(byteSource, new int[]{65505}, false);
        if (segments == null || segments.size() < 1) {
            return null;
        }
        List<Segment> exifSegments = this.filterAPP1Segments(segments);
        if (this.debug) {
            System.out.println("exif_segments.size: " + exifSegments.size());
        }
        if (exifSegments.size() < 1) {
            return null;
        }
        if (exifSegments.size() > 1) {
            throw new ImageReadException("Sanselan currently can't parse EXIF metadata split across multiple APP1 segments.  Please send this image to the Sanselan project.");
        }
        GenericSegment segment = (GenericSegment)exifSegments.get(0);
        byte[] bytes = segment.bytes;
        return this.remainingBytes("trimmed exif bytes", bytes, 6);
    }

    public boolean hasExifSegment(ByteSource byteSource) throws ImageReadException, IOException {
        final boolean[] result = new boolean[]{false};
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            public boolean beginSOS() {
                return false;
            }

            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }

            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65505 && JpegImageParser.startsWith(segmentData, JpegConstants.EXIF_IDENTIFIER_CODE)) {
                    result[0] = true;
                    return false;
                }
                return true;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return result[0];
    }

    public boolean hasIptcSegment(ByteSource byteSource) throws ImageReadException, IOException {
        final boolean[] result = new boolean[]{false};
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            public boolean beginSOS() {
                return false;
            }

            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }

            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65517 && new IptcParser().isPhotoshopJpegSegment(segmentData)) {
                    result[0] = true;
                    return false;
                }
                return true;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return result[0];
    }

    public boolean hasXmpSegment(ByteSource byteSource) throws ImageReadException, IOException {
        final boolean[] result = new boolean[]{false};
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            public boolean beginSOS() {
                return false;
            }

            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }

            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65505 && new JpegXmpParser().isXmpJpegSegment(segmentData)) {
                    result[0] = true;
                    return false;
                }
                return true;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return result[0];
    }

    @Override
    public String getXmpXml(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        final ArrayList result = new ArrayList();
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            public boolean beginSOS() {
                return false;
            }

            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }

            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65505 && new JpegXmpParser().isXmpJpegSegment(segmentData)) {
                    result.add(new JpegXmpParser().parseXmpJpegSegment(segmentData));
                    return false;
                }
                return true;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        if (result.size() < 1) {
            return null;
        }
        if (result.size() > 1) {
            throw new ImageReadException("Jpeg file contains more than one XMP segment.");
        }
        return (String)result.get(0);
    }

    public JpegPhotoshopMetadata getPhotoshopMetadata(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        List<Segment> segments = this.readSegments(byteSource, new int[]{65517}, false);
        if (segments == null || segments.size() < 1) {
            return null;
        }
        PhotoshopApp13Data photoshopApp13Data = null;
        for (int i = 0; i < segments.size(); ++i) {
            App13Segment segment = (App13Segment)segments.get(i);
            PhotoshopApp13Data data = segment.parsePhotoshopSegment(params);
            if (data != null && photoshopApp13Data != null) {
                throw new ImageReadException("Jpeg contains more than one Photoshop App13 segment.");
            }
            photoshopApp13Data = data;
        }
        if (null == photoshopApp13Data) {
            return null;
        }
        return new JpegPhotoshopMetadata(photoshopApp13Data);
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        List<Segment> segments = this.readSegments(byteSource, new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487}, true);
        if (segments == null || segments.size() < 1) {
            throw new ImageReadException("No JFIF Data Found.");
        }
        if (segments.size() > 1) {
            throw new ImageReadException("Redundant JFIF Data Found.");
        }
        SofnSegment fSOFNSegment = (SofnSegment)segments.get(0);
        return new Dimension(fSOFNSegment.width, fSOFNSegment.height);
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    @Override
    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        String FormatDetails;
        List<Segment> SOF_segments = this.readSegments(byteSource, new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487}, false);
        if (SOF_segments == null) {
            throw new ImageReadException("No SOFN Data Found.");
        }
        List<Segment> jfifSegments = this.readSegments(byteSource, new int[]{65504}, true);
        SofnSegment fSOFNSegment = (SofnSegment)SOF_segments.get(0);
        if (fSOFNSegment == null) {
            throw new ImageReadException("No SOFN Data Found.");
        }
        int Width = fSOFNSegment.width;
        int Height = fSOFNSegment.height;
        JfifSegment jfifSegment = null;
        if (jfifSegments != null && jfifSegments.size() > 0) {
            jfifSegment = (JfifSegment)jfifSegments.get(0);
        }
        List<Segment> app14Segments = this.readSegments(byteSource, new int[]{65518}, true);
        App14Segment app14Segment = null;
        if (app14Segments != null && !app14Segments.isEmpty()) {
            app14Segment = (App14Segment)app14Segments.get(0);
        }
        double x_density = -1.0;
        double y_density = -1.0;
        double units_per_inch = -1.0;
        if (jfifSegment != null) {
            x_density = jfifSegment.xDensity;
            y_density = jfifSegment.yDensity;
            int density_units = jfifSegment.densityUnits;
            FormatDetails = "Jpeg/JFIF v." + jfifSegment.jfifMajorVersion + "." + jfifSegment.jfifMinorVersion;
            switch (density_units) {
                case 0: {
                    break;
                }
                case 1: {
                    units_per_inch = 1.0;
                    break;
                }
                case 2: {
                    units_per_inch = 2.54;
                    break;
                }
            }
        } else {
            JpegImageMetadata metadata = (JpegImageMetadata)this.getMetadata(byteSource, params);
            if (metadata != null) {
                TiffField field = metadata.findEXIFValue(TiffTagConstants.TIFF_TAG_XRESOLUTION);
                if (field != null) {
                    x_density = ((Number)field.getValue()).doubleValue();
                }
                if ((field = metadata.findEXIFValue(TiffTagConstants.TIFF_TAG_YRESOLUTION)) != null) {
                    y_density = ((Number)field.getValue()).doubleValue();
                }
                if ((field = metadata.findEXIFValue(TiffTagConstants.TIFF_TAG_RESOLUTION_UNIT)) != null) {
                    int density_units = ((Number)field.getValue()).intValue();
                    switch (density_units) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            units_per_inch = 1.0;
                            break;
                        }
                        case 3: {
                            units_per_inch = 2.54;
                            break;
                        }
                    }
                }
            }
            FormatDetails = "Jpeg/DCM";
        }
        int PhysicalHeightDpi = -1;
        float PhysicalHeightInch = -1.0f;
        int PhysicalWidthDpi = -1;
        float PhysicalWidthInch = -1.0f;
        if (units_per_inch > 0.0) {
            PhysicalWidthDpi = (int)Math.round(x_density * units_per_inch);
            PhysicalWidthInch = (float)((double)Width / (x_density * units_per_inch));
            PhysicalHeightDpi = (int)Math.round(y_density * units_per_inch);
            PhysicalHeightInch = (float)((double)Height / (y_density * units_per_inch));
        }
        ArrayList<String> Comments = new ArrayList<String>();
        List<Segment> commentSegments = this.readSegments(byteSource, new int[]{65534}, false);
        for (int i = 0; i < commentSegments.size(); ++i) {
            ComSegment comSegment = (ComSegment)commentSegments.get(i);
            String comment = "";
            try {
                comment = new String(comSegment.comment, "UTF-8");
            }
            catch (UnsupportedEncodingException cannotHappen) {
                // empty catch block
            }
            Comments.add(comment);
        }
        int Number_of_components = fSOFNSegment.numberOfComponents;
        int Precision = fSOFNSegment.precision;
        int BitsPerPixel = Number_of_components * Precision;
        ImageFormat Format2 = ImageFormat.IMAGE_FORMAT_JPEG;
        String FormatName = "JPEG (Joint Photographic Experts Group) Format";
        String MimeType = "image/jpeg";
        boolean NumberOfImages = true;
        boolean isProgressive = fSOFNSegment.marker == 65474;
        boolean isTransparent = false;
        boolean usesPalette = false;
        int colorType = -2;
        if (app14Segment != null && app14Segment.isAdobeJpegSegment()) {
            int colorTransform = app14Segment.getAdobeColorTransform();
            if (colorTransform == 0) {
                if (Number_of_components == 3) {
                    colorType = 2;
                } else if (Number_of_components == 4) {
                    colorType = 3;
                }
            } else if (colorTransform == 1) {
                colorType = 4;
            } else if (colorTransform == 2) {
                colorType = 5;
            }
        } else if (jfifSegment != null) {
            if (Number_of_components == 1) {
                colorType = 1;
            } else if (Number_of_components == 3) {
                colorType = 4;
            }
        } else if (Number_of_components == 1) {
            colorType = 1;
        } else if (Number_of_components == 2) {
            colorType = 1;
            isTransparent = true;
        } else if (Number_of_components == 3 || Number_of_components == 4) {
            boolean have1 = false;
            boolean have2 = false;
            boolean have3 = false;
            boolean have4 = false;
            boolean haveOther = false;
            for (SofnSegment.Component component : fSOFNSegment.components) {
                int id = component.componentIdentifier;
                if (id == 1) {
                    have1 = true;
                    continue;
                }
                if (id == 2) {
                    have2 = true;
                    continue;
                }
                if (id == 3) {
                    have3 = true;
                    continue;
                }
                if (id == 4) {
                    have4 = true;
                    continue;
                }
                haveOther = true;
            }
            if (Number_of_components == 3 && have1 && have2 && have3 && !have4 && !haveOther) {
                colorType = 4;
            } else if (Number_of_components == 4 && have1 && have2 && have3 && have4 && !haveOther) {
                colorType = 4;
                isTransparent = true;
            } else {
                boolean haveR = false;
                boolean haveG = false;
                boolean haveB = false;
                boolean haveA = false;
                boolean haveC = false;
                boolean havec = false;
                boolean haveY = false;
                for (SofnSegment.Component component : fSOFNSegment.components) {
                    int id = component.componentIdentifier;
                    if (id == 82) {
                        haveR = true;
                        continue;
                    }
                    if (id == 71) {
                        haveG = true;
                        continue;
                    }
                    if (id == 66) {
                        haveB = true;
                        continue;
                    }
                    if (id == 65) {
                        haveA = true;
                        continue;
                    }
                    if (id == 67) {
                        haveC = true;
                        continue;
                    }
                    if (id == 99) {
                        havec = true;
                        continue;
                    }
                    if (id != 89) continue;
                    haveY = true;
                }
                if (haveR && haveG && haveB && !haveA && !haveC && !havec && !haveY) {
                    colorType = 2;
                } else if (haveR && haveG && haveB && haveA && !haveC && !havec && !haveY) {
                    colorType = 2;
                    isTransparent = true;
                } else if (haveY && haveC && havec && !haveR && !haveG && !haveB && !haveA) {
                    colorType = 6;
                } else if (haveY && haveC && havec && haveA && !haveR && !haveG && !haveB) {
                    colorType = 6;
                    isTransparent = true;
                } else {
                    boolean isSubsampled;
                    int minHorizontalSamplingFactor = Integer.MAX_VALUE;
                    int maxHorizontalSmaplingFactor = Integer.MIN_VALUE;
                    int minVerticalSamplingFactor = Integer.MAX_VALUE;
                    int maxVerticalSamplingFactor = Integer.MIN_VALUE;
                    for (SofnSegment.Component component : fSOFNSegment.components) {
                        if (minHorizontalSamplingFactor > component.horizontalSamplingFactor) {
                            minHorizontalSamplingFactor = component.horizontalSamplingFactor;
                        }
                        if (maxHorizontalSmaplingFactor < component.horizontalSamplingFactor) {
                            maxHorizontalSmaplingFactor = component.horizontalSamplingFactor;
                        }
                        if (minVerticalSamplingFactor > component.verticalSamplingFactor) {
                            minVerticalSamplingFactor = component.verticalSamplingFactor;
                        }
                        if (maxVerticalSamplingFactor >= component.verticalSamplingFactor) continue;
                        maxVerticalSamplingFactor = component.verticalSamplingFactor;
                    }
                    boolean bl = isSubsampled = minHorizontalSamplingFactor != maxHorizontalSmaplingFactor || minVerticalSamplingFactor != maxVerticalSamplingFactor;
                    if (Number_of_components == 3) {
                        colorType = isSubsampled ? 4 : 2;
                    } else if (Number_of_components == 4) {
                        colorType = isSubsampled ? 5 : 3;
                    }
                }
            }
        }
        String compressionAlgorithm = "JPEG";
        ImageInfo result = new ImageInfo(FormatDetails, BitsPerPixel, Comments, Format2, "JPEG (Joint Photographic Experts Group) Format", Height, "image/jpeg", 1, PhysicalHeightDpi, PhysicalHeightInch, PhysicalWidthDpi, PhysicalWidthInch, Width, isProgressive, isTransparent, false, colorType, "JPEG");
        return result;
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        pw.println("tiff.dumpImageFile");
        ImageInfo imageInfo = this.getImageInfo(byteSource);
        if (imageInfo == null) {
            return false;
        }
        imageInfo.toString(pw, "");
        pw.println("");
        List<Segment> segments = this.readSegments(byteSource, null, false);
        if (segments == null) {
            throw new ImageReadException("No Segments Found.");
        }
        for (int d = 0; d < segments.size(); ++d) {
            Segment segment = segments.get(d);
            NumberFormat nf = NumberFormat.getIntegerInstance();
            pw.println(d + ": marker: " + Integer.toHexString(segment.marker) + ", " + segment.getDescription() + " (length: " + nf.format(segment.length) + ")");
            segment.dump(pw);
        }
        pw.println("");
        return true;
    }
}

