/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.psd;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;

public class PsdHeaderInfo {
    public final int Version;
    public final byte[] Reserved;
    public final int Channels;
    public final int Rows;
    public final int Columns;
    public final int Depth;
    public final int Mode;

    public PsdHeaderInfo(int Version, byte[] Reserved, int Channels, int Rows, int Columns, int Depth, int Mode) {
        this.Version = Version;
        this.Reserved = Reserved;
        this.Channels = Channels;
        this.Rows = Rows;
        this.Columns = Columns;
        this.Depth = Depth;
        this.Mode = Mode;
    }

    public void dump() {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
        this.dump(pw);
        pw.flush();
    }

    public void dump(PrintWriter pw) {
        pw.println("");
        pw.println("Header");
        pw.println("Version: " + this.Version + " (" + Integer.toHexString(this.Version) + ")");
        pw.println("Channels: " + this.Channels + " (" + Integer.toHexString(this.Channels) + ")");
        pw.println("Rows: " + this.Rows + " (" + Integer.toHexString(this.Rows) + ")");
        pw.println("Columns: " + this.Columns + " (" + Integer.toHexString(this.Columns) + ")");
        pw.println("Depth: " + this.Depth + " (" + Integer.toHexString(this.Depth) + ")");
        pw.println("Mode: " + this.Mode + " (" + Integer.toHexString(this.Mode) + ")");
        pw.println("Reserved: " + this.Reserved.length);
        pw.println("");
        pw.flush();
    }
}

