/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class TransposeOpImage
extends GeometricOpImage {
    protected int type;
    protected int src_width;
    protected int src_height;
    protected Rectangle sourceBounds;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, int n) {
        ImageLayout imageLayout2 = imageLayout != null ? (ImageLayout)imageLayout.clone() : new ImageLayout();
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle rectangle2 = TransposeOpImage.mapRect(rectangle, rectangle, n, true);
        imageLayout2.setMinX(rectangle2.x);
        imageLayout2.setMinY(rectangle2.y);
        imageLayout2.setWidth(rectangle2.width);
        imageLayout2.setHeight(rectangle2.height);
        Rectangle rectangle3 = new Rectangle(renderedImage.getTileGridXOffset(), renderedImage.getTileGridYOffset(), renderedImage.getTileWidth(), renderedImage.getTileHeight());
        rectangle2 = TransposeOpImage.mapRect(rectangle3, rectangle, n, true);
        if (imageLayout2.isValid(16)) {
            imageLayout2.setTileGridXOffset(rectangle2.x);
        }
        if (imageLayout2.isValid(32)) {
            imageLayout2.setTileGridYOffset(rectangle2.y);
        }
        if (imageLayout2.isValid(64)) {
            imageLayout2.setTileWidth(Math.abs(rectangle2.width));
        }
        if (imageLayout2.isValid(128)) {
            imageLayout2.setTileHeight(Math.abs(rectangle2.height));
        }
        return imageLayout2;
    }

    public TransposeOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n) {
        super(TransposeOpImage.vectorize(renderedImage), TransposeOpImage.layoutHelper(imageLayout, renderedImage, n), map, true, null, null, null);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = colorModel;
        }
        this.type = n;
        this.src_width = renderedImage.getWidth();
        this.src_height = renderedImage.getHeight();
        this.sourceBounds = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n) {
        return TransposeOpImage.mapRect(rectangle, this.sourceBounds, this.type, true);
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        return TransposeOpImage.mapRect(rectangle, this.sourceBounds, this.type, false);
    }

    protected static void mapPoint(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = nArray[0];
        int n7 = nArray[1];
        int n8 = -1;
        int n9 = -1;
        switch (n5) {
            case 0: {
                n8 = n6;
                n9 = n2 + n4 - n7;
                break;
            }
            case 1: {
                n8 = n + n3 - n6;
                n9 = n7;
                break;
            }
            case 2: {
                n8 = n - n2 + n7;
                n9 = n2 - n + n6;
                break;
            }
            case 3: {
                if (bl) {
                    n8 = n + n4 - n7;
                    n9 = n2 + n3 - n6;
                    break;
                }
                n8 = n2 + n3 - n7;
                n9 = n + n4 - n6;
                break;
            }
            case 4: {
                if (bl) {
                    n8 = n + n4 - n7;
                    n9 = n2 - n + n6;
                    break;
                }
                n8 = n - n2 + n7;
                n9 = n + n4 - n6;
                break;
            }
            case 5: {
                n8 = n + n3 - n6;
                n9 = n2 + n4 - n7;
                break;
            }
            case 6: {
                if (bl) {
                    n8 = n - n2 + n7;
                    n9 = n3 + n2 - n6;
                    break;
                }
                n8 = n3 + n2 - n7;
                n9 = n2 - n + n6;
            }
        }
        nArray[0] = n8;
        nArray[1] = n9;
    }

    private static Rectangle mapRect(Rectangle rectangle, Rectangle rectangle2, int n, boolean bl) {
        int n2;
        int n3;
        int n4 = rectangle2.x;
        int n5 = rectangle2.y;
        int n6 = n4 + rectangle2.width - 1;
        int n7 = n5 + rectangle2.height - 1;
        int[] nArray = new int[]{rectangle.x, rectangle.y};
        TransposeOpImage.mapPoint(nArray, n4, n5, n6, n7, n, bl);
        int n8 = n3 = nArray[0];
        int n9 = n2 = nArray[1];
        nArray[0] = rectangle.x + rectangle.width - 1;
        nArray[1] = rectangle.y;
        TransposeOpImage.mapPoint(nArray, n4, n5, n6, n7, n, bl);
        n8 = Math.min(n8, nArray[0]);
        n9 = Math.min(n9, nArray[1]);
        n3 = Math.max(n3, nArray[0]);
        n2 = Math.max(n2, nArray[1]);
        nArray[0] = rectangle.x;
        nArray[1] = rectangle.y + rectangle.height - 1;
        TransposeOpImage.mapPoint(nArray, n4, n5, n6, n7, n, bl);
        n8 = Math.min(n8, nArray[0]);
        n9 = Math.min(n9, nArray[1]);
        n3 = Math.max(n3, nArray[0]);
        n2 = Math.max(n2, nArray[1]);
        nArray[0] = rectangle.x + rectangle.width - 1;
        nArray[1] = rectangle.y + rectangle.height - 1;
        TransposeOpImage.mapPoint(nArray, n4, n5, n6, n7, n, bl);
        n8 = Math.min(n8, nArray[0]);
        n9 = Math.min(n9, nArray[1]);
        n3 = Math.max(n3, nArray[0]);
        n2 = Math.max(n2, nArray[1]);
        return new Rectangle(n8, n9, n3 - n8 + 1, n2 - n9 + 1);
    }

    public Raster computeTile(int n, int n2) {
        int n3;
        int n4;
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = n5 + writableRaster.getWidth();
        int n8 = n6 + writableRaster.getHeight();
        Rectangle rectangle = this.getBounds();
        if (n5 < rectangle.x) {
            n5 = rectangle.x;
        }
        if (n7 > (n4 = rectangle.x + rectangle.width)) {
            n7 = n4;
        }
        if (n6 < rectangle.y) {
            n6 = rectangle.y;
        }
        if (n8 > (n3 = rectangle.y + rectangle.height)) {
            n8 = n3;
        }
        if (n5 >= n7 || n6 >= n8) {
            return writableRaster;
        }
        Rectangle rectangle2 = new Rectangle(n5, n6, n7 - n5, n8 - n6);
        IntegerSequence integerSequence = new IntegerSequence(n5, n7);
        integerSequence.insert(n5);
        integerSequence.insert(n7);
        IntegerSequence integerSequence2 = new IntegerSequence(n6, n8);
        integerSequence2.insert(n6);
        integerSequence2.insert(n8);
        PlanarImage planarImage = this.getSource(0);
        int n9 = planarImage.getMinX();
        int n10 = planarImage.getMinY();
        int n11 = planarImage.getWidth();
        int n12 = planarImage.getHeight();
        int n13 = n9 + n11 - 1;
        int n14 = n10 + n12 - 1;
        int n15 = planarImage.getTileWidth();
        int n16 = planarImage.getTileHeight();
        int n17 = planarImage.getTileGridXOffset();
        int n18 = planarImage.getTileGridYOffset();
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int[] nArray = new int[]{n17, n18};
        TransposeOpImage.mapPoint(nArray, n9, n10, n13, n14, this.type, true);
        n19 = nArray[0];
        n21 = nArray[1];
        switch (this.type) {
            case 0: {
                ++n21;
                n20 = n15;
                n22 = n16;
                break;
            }
            case 1: {
                ++n19;
                n20 = n15;
                n22 = n16;
                break;
            }
            case 2: {
                n20 = n16;
                n22 = n15;
                break;
            }
            case 3: {
                ++n19;
                ++n21;
                n20 = n16;
                n22 = n15;
                break;
            }
            case 4: {
                ++n19;
                n20 = n16;
                n22 = n15;
                break;
            }
            case 5: {
                ++n19;
                ++n21;
                n20 = n15;
                n22 = n16;
                break;
            }
            case 6: {
                ++n21;
                n20 = n16;
                n22 = n15;
            }
        }
        int n23 = (int)Math.floor((double)(n5 - n19) / (double)n20);
        for (int i = n19 + n23 * n20; i < n7; i += n20) {
            integerSequence.insert(i);
        }
        int n24 = (int)Math.floor((double)(n6 - n21) / (double)n22);
        for (int i = n21 + n24 * n22; i < n8; i += n22) {
            integerSequence2.insert(i);
        }
        Raster[] rasterArray = new Raster[1];
        Rectangle rectangle3 = new Rectangle();
        integerSequence2.startEnumeration();
        int n25 = integerSequence2.nextElement();
        while (integerSequence2.hasMoreElements()) {
            int n26 = integerSequence2.nextElement();
            int n27 = n26 - n25;
            integerSequence.startEnumeration();
            int n28 = integerSequence.nextElement();
            while (integerSequence.hasMoreElements()) {
                int n29 = integerSequence.nextElement();
                int n30 = n29 - n28;
                nArray[0] = n28;
                nArray[1] = n25;
                TransposeOpImage.mapPoint(nArray, n9, n10, n13, n14, this.type, false);
                int n31 = planarImage.XToTileX(nArray[0]);
                int n32 = planarImage.YToTileY(nArray[1]);
                rasterArray[0] = planarImage.getTile(n31, n32);
                rectangle3.x = n28;
                rectangle3.y = n25;
                rectangle3.width = n30;
                rectangle3.height = n27;
                this.computeRect(rasterArray, writableRaster, rectangle3);
                n28 = n29;
            }
            n25 = n26;
        }
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        PlanarImage planarImage = this.getSource(0);
        int n = planarImage.getMinX();
        int n2 = planarImage.getMinY();
        int n3 = planarImage.getWidth();
        int n4 = planarImage.getHeight();
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        int n7 = raster.getSampleModelTranslateX();
        int n8 = raster.getSampleModelTranslateY();
        Rectangle rectangle2 = raster.getBounds();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = rasterAccessor.getPixelStride();
        int n14 = rasterAccessor.getScanlineStride();
        int[] nArray = new int[]{rectangle.x, rectangle.y};
        TransposeOpImage.mapPoint(nArray, n, n2, n5, n6, this.type, false);
        n11 = nArray[0];
        n12 = nArray[1];
        switch (this.type) {
            case 0: {
                n9 = n13;
                n10 = -n14;
                break;
            }
            case 1: {
                n9 = -n13;
                n10 = n14;
                break;
            }
            case 2: {
                n9 = n14;
                n10 = n13;
                break;
            }
            case 3: {
                n9 = -n14;
                n10 = -n13;
                break;
            }
            case 4: {
                n9 = -n14;
                n10 = n13;
                break;
            }
            case 5: {
                n9 = -n13;
                n10 = -n14;
                break;
            }
            case 6: {
                n9 = n14;
                n10 = -n13;
            }
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, n7, n8, rasterAccessor2, n9, n10, n11, n12);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n7, n8, rasterAccessor2, n9, n10, n11, n12);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n7, n8, rasterAccessor2, n9, n10, n11, n12);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n7, n8, rasterAccessor2, n9, n10, n11, n12);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n7, n8, rasterAccessor2, n9, n10, n11, n12);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2, int n3, int n4, int n5, int n6) {
        int n7 = rasterAccessor2.getWidth();
        int n8 = rasterAccessor2.getHeight();
        int n9 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n10 = rasterAccessor2.getPixelStride();
        int n11 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getOffsetsForBands();
        int n12 = rasterAccessor.getPixelStride();
        int n13 = rasterAccessor.getScanlineStride();
        int n14 = rasterAccessor2.getNumBands();
        int n15 = rectangle.x;
        int n16 = rectangle.y;
        int n17 = rectangle.x + rectangle.width;
        int n18 = rectangle.y + rectangle.height;
        int n19 = (n6 - n2) * n13;
        int n20 = (n5 - n) * n12;
        int n21 = n20 + n19;
        int n22 = 0;
        for (int i = n16; i < n18; ++i) {
            for (int j = 0; j < n14; ++j) {
                byte[] byArray3 = byArray2[j];
                byte[] byArray4 = byArray[j];
                int n23 = n22 + nArray[j];
                int n24 = n21 + nArray2[j];
                for (int k = n15; k < n17; ++k) {
                    byArray4[n23] = byArray3[n24];
                    n24 += n3;
                    n23 += n10;
                }
            }
            n21 += n4;
            n22 += n11;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2, int n3, int n4, int n5, int n6) {
        int n7 = rasterAccessor2.getWidth();
        int n8 = rasterAccessor2.getHeight();
        int n9 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n10 = rasterAccessor2.getPixelStride();
        int n11 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getOffsetsForBands();
        int n12 = rasterAccessor.getPixelStride();
        int n13 = rasterAccessor.getScanlineStride();
        int n14 = rasterAccessor2.getNumBands();
        int n15 = rectangle.x;
        int n16 = rectangle.y;
        int n17 = rectangle.x + rectangle.width;
        int n18 = rectangle.y + rectangle.height;
        int n19 = (n6 - n2) * n13;
        int n20 = (n5 - n) * n12;
        int n21 = n20 + n19;
        int n22 = 0;
        for (int i = n16; i < n18; ++i) {
            for (int j = 0; j < n14; ++j) {
                int[] nArray5 = nArray3[j];
                int[] nArray6 = nArray[j];
                int n23 = n22 + nArray2[j];
                int n24 = n21 + nArray4[j];
                for (int k = n15; k < n17; ++k) {
                    nArray6[n23] = nArray5[n24];
                    n24 += n3;
                    n23 += n10;
                }
            }
            n21 += n4;
            n22 += n11;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2, int n3, int n4, int n5, int n6) {
        int n7 = rasterAccessor2.getWidth();
        int n8 = rasterAccessor2.getHeight();
        int n9 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n10 = rasterAccessor2.getPixelStride();
        int n11 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getOffsetsForBands();
        int n12 = rasterAccessor.getPixelStride();
        int n13 = rasterAccessor.getScanlineStride();
        int n14 = rasterAccessor2.getNumBands();
        int n15 = rectangle.x;
        int n16 = rectangle.y;
        int n17 = rectangle.x + rectangle.width;
        int n18 = rectangle.y + rectangle.height;
        int n19 = (n6 - n2) * n13;
        int n20 = (n5 - n) * n12;
        int n21 = n20 + n19;
        int n22 = 0;
        for (int i = n16; i < n18; ++i) {
            for (int j = 0; j < n14; ++j) {
                short[] sArray3 = sArray2[j];
                short[] sArray4 = sArray[j];
                int n23 = n22 + nArray[j];
                int n24 = n21 + nArray2[j];
                for (int k = n15; k < n17; ++k) {
                    sArray4[n23] = sArray3[n24];
                    n24 += n3;
                    n23 += n10;
                }
            }
            n21 += n4;
            n22 += n11;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2, int n3, int n4, int n5, int n6) {
        int n7 = rasterAccessor2.getWidth();
        int n8 = rasterAccessor2.getHeight();
        int n9 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n10 = rasterAccessor2.getPixelStride();
        int n11 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getOffsetsForBands();
        int n12 = rasterAccessor.getPixelStride();
        int n13 = rasterAccessor.getScanlineStride();
        int n14 = rasterAccessor2.getNumBands();
        int n15 = rectangle.x;
        int n16 = rectangle.y;
        int n17 = rectangle.x + rectangle.width;
        int n18 = rectangle.y + rectangle.height;
        int n19 = (n6 - n2) * n13;
        int n20 = (n5 - n) * n12;
        int n21 = n20 + n19;
        int n22 = 0;
        for (int i = n16; i < n18; ++i) {
            for (int j = 0; j < n14; ++j) {
                float[] fArray3 = fArray2[j];
                float[] fArray4 = fArray[j];
                int n23 = n22 + nArray[j];
                int n24 = n21 + nArray2[j];
                for (int k = n15; k < n17; ++k) {
                    fArray4[n23] = fArray3[n24];
                    n24 += n3;
                    n23 += n10;
                }
            }
            n21 += n4;
            n22 += n11;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2, int n3, int n4, int n5, int n6) {
        int n7 = rasterAccessor2.getWidth();
        int n8 = rasterAccessor2.getHeight();
        int n9 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n10 = rasterAccessor2.getPixelStride();
        int n11 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getOffsetsForBands();
        int n12 = rasterAccessor.getPixelStride();
        int n13 = rasterAccessor.getScanlineStride();
        int n14 = rasterAccessor2.getNumBands();
        int n15 = rectangle.x;
        int n16 = rectangle.y;
        int n17 = rectangle.x + rectangle.width;
        int n18 = rectangle.y + rectangle.height;
        int n19 = (n6 - n2) * n13;
        int n20 = (n5 - n) * n12;
        int n21 = n20 + n19;
        int n22 = 0;
        for (int i = n16; i < n18; ++i) {
            for (int j = 0; j < n14; ++j) {
                double[] dArray3 = dArray2[j];
                double[] dArray4 = dArray[j];
                int n23 = n22 + nArray[j];
                int n24 = n21 + nArray2[j];
                for (int k = n15; k < n17; ++k) {
                    dArray4[n23] = dArray3[n24];
                    n24 += n3;
                    n23 += n10;
                }
            }
            n21 += n4;
            n22 += n11;
        }
    }
}

