/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TIFFJPEGCMYKDecompressor
extends TIFFDecompressor {
    protected static final int SOI = 216;
    protected static final int EOI = 217;
    protected boolean hasJPEGTables = false;
    protected byte[] tables = null;
    private byte[] data = new byte[0];

    @Override
    public void beginDecoding() {
        TIFFImageMetadata tIFFImageMetadata = (TIFFImageMetadata)this.metadata;
        TIFFField tIFFField = tIFFImageMetadata.getTIFFField(347);
        if (tIFFField != null) {
            this.hasJPEGTables = true;
            this.tables = tIFFField.getAsBytes();
        } else {
            this.hasJPEGTables = false;
        }
    }

    @Override
    public void decodeRaw(byte[] byArray, int n, int n2, int n3) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        this.stream.seek(this.offset);
        if (this.hasJPEGTables) {
            int n4;
            int n5 = this.tables.length + this.byteCount;
            if (this.data.length < n5) {
                this.data = new byte[n5];
            }
            int n6 = this.tables.length;
            for (n4 = this.tables.length - 2; n4 > 0; --n4) {
                if ((this.tables[n4] & 0xFF) != 255 || (this.tables[n4 + 1] & 0xFF) != 217) continue;
                n6 = n4;
                break;
            }
            System.arraycopy(this.tables, 0, this.data, 0, n6);
            n4 = (byte)this.stream.read();
            byte by = (byte)this.stream.read();
            if ((n4 & 0xFF) != 255 || (by & 0xFF) != 216) {
                this.data[n6++] = n4;
                this.data[n6++] = by;
            }
            this.stream.readFully(this.data, n6, this.byteCount - 2);
            byteArrayInputStream = new ByteArrayInputStream(this.data);
        } else {
            byte[] byArray2 = new byte[this.byteCount];
            this.stream.read(byArray2);
            byteArrayInputStream = new ByteArrayInputStream(byArray2);
            byArray2 = null;
        }
        JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
        Raster raster = jPEGImageDecoder.decodeAsRaster();
        JPEGDecodeParam jPEGDecodeParam = jPEGImageDecoder.getJPEGDecodeParam();
        DataBuffer dataBuffer = raster.getDataBuffer();
        ColorSpace colorSpace = ColorSpace.getInstance(1004);
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, true, true, 1, dataBuffer.getDataType());
        if (jPEGDecodeParam.getEncodedColorID() == 9) {
            int n7 = dataBuffer.getSize();
            for (int i = 0; i < n7; i += 4) {
                dataBuffer.setElem(0, i, 255 - dataBuffer.getElem(0, i));
                dataBuffer.setElem(0, i + 1, 255 - dataBuffer.getElem(0, i + 1));
                dataBuffer.setElem(0, i + 2, 255 - dataBuffer.getElem(0, i + 2));
            }
        }
        this.rawImage = new BufferedImage(componentColorModel, (WritableRaster)raster, true, null);
        ((InputStream)byteArrayInputStream).close();
        jPEGImageDecoder = null;
        raster = null;
        dataBuffer = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

