/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.imaging.formats.jpeg.segments.Segment;

public class ComSegment
extends Segment {
    public final byte[] comment;

    public ComSegment(int marker, byte[] segmentData) throws IOException {
        this(marker, segmentData.length, new ByteArrayInputStream(segmentData));
    }

    public ComSegment(int marker, int marker_length, InputStream is) throws IOException {
        super(marker, marker_length);
        if (this.getDebug()) {
            System.out.println("ComSegment marker_length: " + marker_length);
        }
        this.comment = this.readBytes("Comment", is, marker_length, "Error reading JPEG comment");
        if (this.getDebug()) {
            System.out.println("");
        }
    }

    public String getDescription() {
        String commentString = "";
        try {
            commentString = new String(this.comment, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "COM (" + commentString + ")";
    }
}

