<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/linkbutton.ftl">

  <@tableHeader Heading="Access to source connector ${connectorname}" />

  <#if show_list?? >
  
  
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
     <tr>
      <td class="pad1" colspan="3">
       <#if message??>
        ${message}
       <#else>
        The settings on this page define which group has access to the selected connector and what permission set is 
        used to describe the access permissions.   
       </#if>
      </td>
     </tr>
	 <tr>
	   <td class="sectionheader">Group</td>
	   <td class="sectionheader">Permission Set</td>
	   <td class="sectionheader">&nbsp;</td>
	 </tr>
	 <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
      <#if accesspermissions?size != 0>
	    <#assign i = 0>
	    <#list accesspermissions?keys?sort as groupname>
	     <#assign i = i + 1>
	     <tr>
          <td class="pad1">${groupname}</td>
          <td class="pad1">${accesspermissions[groupname]}</td>
          <td class="pad1" align="right">
            <a href="pt.do?<@printRequiredParams method="get" />action=sourceconnectoraccess&connectorname=${connectorname}&deletegroup=${groupname}"><img onmouseout="spanup(this);" onmouseup="spanup(this);" onmousedown="spandown(this);" onmouseover="spanhover(this);" class="btnwhite" title="Delete Permission for this group" alt="Delete Permission" src="images/apps/app22/delete_profile.png" id="app1iconic" <#if i==1>help="<@appID/>:sourceconnector_access_delete"</#if> /></a>
          </td>
         </tr>
        </#list>
      <#else>
        <tr>
          <td class="pad1" style="text-align: center;" colspan="3">No access permissions assigned to this connector.</td>
        </tr>
      </#if>
     <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
     <tr>
	    <td class="pad1" colspan="3" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="sourceconnectoraccess">
      		<input type="hidden" name="connectorname" value="${connectorname}">
      		<input type="hidden" name="add" value="1">
      		<@linkbutton value="Back" targeturl="pt.do?action=listsourceconnectors" helpid="sourceconnector_access_back" />
            <@formsubmit value="Add Permission" helpid="sourceconnector_access_add" />
      	  </form>
	    </td>
	 </tr>	
    </table>
    
  <#elseif show_form??>
  
    <form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="sourceconnectoraccess">
    <input type="hidden" name="connectorname" value="${connectorname}">
    <input type="hidden" name="save" value="1">
      		
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
        <td class="pad1" colspan="2">
         Select the group and the desired permission set to assign to the selected connector.
        </td>
      <tr>
        <td class="sectionheader">Group</td>
	    <td class="sectionheader">Permission Set</td>
	  </tr>
	  <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
      <#if available_groups?first?? >
	   <tr>
	    <td class="pad1">
	      <@formgfxselect objid="group" preselect=available_groups?first.value itemlist=available_groups helpid="sourceconnectoraccess_group" />
	    </td>
	    <td class="pad1">
	      <@formgfxselect objid="permissionset" preselect=available_permissionsets?first.value itemlist=available_permissionsets helpid="sourceconnectoraccess_set" />
	    </td>
	   </tr>
	   <tr>
	    <td class="pad1" style="text-align: right; padding-top: 20px;" colspan="2" >
	      <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
	      <@formsubmit value="Assign Selected" helpid="sourceconnectoraccess_assign" />
      	</td>
       </tr>
      <#else>
	   <tr>
	    <td class="pad1" coolspan="2">
	      There are no more groups to assign to this connector. 
	    </td>
	   </tr>
	   <tr>
	    <td class="pad1" colspan="2" style="padding-top: 20px;" align="right">
	      <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
        </td>
       </tr>	 
	  </#if>
    </table>
    </form>

  <#elseif show_delete_form??>

    <form action="pt.do" method="post" onsubmit="this.submit();">
      <@printRequiredParams method="post" />
      <input type="hidden" name="action" value="sourceconnectoraccess">
      <input type="hidden" name="connectorname" value="${connectorname}">
      <input type="hidden" name="deletegroup" value="${deletegroup}">
      <input type="hidden" name="confirmed" value="true">
      
      <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
       <tr>
	    <td class="pad1" colspan="2">
	      Are you sure you want to delete this permission? Members of the group ${deletegroup} will no longer be 
	      able to access the connector ${connectorname}. 
	    </td>
	   </tr>
       <tr>
        <td class="sectionheader" colspan="2">Remove permission</td>
	   </tr>
	   <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
       <tr>
        <td class="pad1">Really remove this permission?</td>
	    <td class="pad1" style="text-align: right;" >
	      <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
	      <@formsubmit value="Delete" />
      	</td>
       </tr>
      </table>
    </form>
    
  <#elseif show_confirmation?? >
    
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
        <td class="sectionheader">Connector saved</td>
	  </tr>
	  <tr><td><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">The changes to the connector have been saved. Please wait while the connectors are re-read for the changes
	    to take effect.
	    </td>
	  </tr>
	</table>
    <#assign timeout="8" />
	<#assign postprogresslocation="action=sourceconnectoraccess&connectorname=${connectorname}">
    <#include "/sub/progressbar.ftl">
    
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">